/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectHashSet;

public class ObjectIdentityHashSet<KType>
extends ObjectHashSet<KType> {
    public ObjectIdentityHashSet() {
        this(4, 0.75);
    }

    public ObjectIdentityHashSet(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectIdentityHashSet(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor);
    }

    public ObjectIdentityHashSet(ObjectContainer<? extends KType> container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    protected int hashKey(KType key2) {
        assert (key2 != null);
        return BitMixer.mixPhi(System.identityHashCode(key2));
    }

    @Override
    protected boolean equals(Object v1, Object v2) {
        return v1 == v2;
    }

    @SafeVarargs
    public static <KType> ObjectIdentityHashSet<KType> from(KType ... elements) {
        ObjectIdentityHashSet<KType> set = new ObjectIdentityHashSet<KType>(elements.length);
        set.addAll(elements);
        return set;
    }
}

