/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.morfologik;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import morfologik.fsa.FSA;
import morfologik.fsa.builders.CFSA2Serializer;
import morfologik.fsa.builders.FSABuilder;
import morfologik.stemming.Dictionary;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.spelling.morfologik.MorfologikSpeller;
import org.languagetool.rules.spelling.morfologik.WeightedSuggestion;

public class MorfologikMultiSpeller {
    private static final LoadingCache<BufferedReaderWithSource, List<byte[]>> dictCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<BufferedReaderWithSource, List<byte[]>>(){

        public List<byte[]> load(@NotNull BufferedReaderWithSource reader) throws IOException {
            List<byte[]> lines = this.getLines(reader.reader, reader.readerPath, reader.language);
            if (reader.languageVariantReader != null) {
                lines.addAll(this.getLines(reader.languageVariantReader, reader.readerPath, reader.language));
                lines.add("LanguageTool".getBytes());
            }
            return lines;
        }

        private List<byte[]> getLines(BufferedReader br, String path, Language lang) throws IOException {
            String originalLine;
            ArrayList<byte[]> lines = new ArrayList<byte[]>();
            while ((originalLine = br.readLine()) != null) {
                List<String> lineList = lang != null ? lang.prepareLineForSpeller(originalLine) : Arrays.asList(originalLine);
                for (String line : lineList) {
                    if (line.startsWith("#") || line.isEmpty() || (line = line.split("#")[0].trim()).isEmpty()) continue;
                    lines.add(line.getBytes(StandardCharsets.UTF_8));
                }
            }
            return lines;
        }
    });
    private static final Map<String, Dictionary> dicPathToDict = new HashMap<String, Dictionary>();
    private static final Map<UserDictCacheKey, Cache<String, Dictionary>> userDictCaches = new HashMap<UserDictCacheKey, Cache<String, Dictionary>>();
    private static final Map<UserDictCacheKey, Map<String, Integer>> userDictSizes = new HashMap<UserDictCacheKey, Map<String, Integer>>();
    private final List<MorfologikSpeller> spellers;
    private final List<MorfologikSpeller> defaultDictSpellers;
    private final List<MorfologikSpeller> userDictSpellers;
    private final boolean convertsCase;
    private final Long premiumUid;
    private final Long userDictCacheSize;
    private final String userDictName;
    private final UserDictCacheKey userDictCacheKey;
    private final Language language;

    public MorfologikMultiSpeller(String binaryDictPath, List<String> plainTextPaths, String languageVariantPlainTextPath, int maxEditDistance) throws IOException {
        this(binaryDictPath, plainTextPaths, languageVariantPlainTextPath, null, maxEditDistance, null);
    }

    public MorfologikMultiSpeller(String binaryDictPath, List<String> plainTextPaths, String languageVariantPlainTextPath, UserConfig userConfig, int maxEditDistance, Language lang) throws IOException {
        this(binaryDictPath, MorfologikMultiSpeller.getBufferedReader(plainTextPaths), plainTextPaths, languageVariantPlainTextPath == null ? null : new BufferedReader(new InputStreamReader(JLanguageTool.getDataBroker().getFromResourceDirAsStream(languageVariantPlainTextPath), StandardCharsets.UTF_8)), languageVariantPlainTextPath, userConfig, maxEditDistance, lang);
        for (String plainTextPath : plainTextPaths) {
            if (plainTextPath == null || plainTextPath.endsWith(".txt") && (languageVariantPlainTextPath == null || languageVariantPlainTextPath.endsWith(".txt"))) continue;
            throw new IllegalArgumentException("Unsupported dictionary, plain text file needs to have suffix .txt: " + plainTextPath);
        }
    }

    public MorfologikMultiSpeller(String binaryDictPath, BufferedReader plainTextReader, List<String> plainTextReaderPath, BufferedReader languageVariantPlainTextReader, String languageVariantPlainTextPath, UserConfig userConfig, int maxEditDistance, Language lang) throws IOException {
        this.language = lang;
        if (userConfig == null || userConfig.getAcceptedWords() == null || userConfig.getAcceptedWords().isEmpty()) {
            this.premiumUid = null;
            this.userDictName = null;
            this.userDictCacheSize = null;
        } else {
            this.premiumUid = userConfig.getPremiumUid();
            this.userDictName = userConfig.getUserDictName();
            this.userDictCacheSize = userConfig.getUserDictCacheSize();
        }
        this.userDictCacheKey = this.premiumUid != null && this.userDictCacheSize != null ? new UserDictCacheKey(this.premiumUid, binaryDictPath) : null;
        MorfologikSpeller speller = this.getBinaryDict(binaryDictPath, maxEditDistance);
        ArrayList<MorfologikSpeller> spellers = new ArrayList<MorfologikSpeller>();
        MorfologikSpeller userDictSpeller = this.getUserDictSpellerOrNull(userConfig, binaryDictPath, maxEditDistance);
        if (userDictSpeller != null) {
            spellers.add(userDictSpeller);
            this.userDictSpellers = Collections.singletonList(userDictSpeller);
        } else {
            this.userDictSpellers = Collections.emptyList();
        }
        spellers.add(speller);
        this.convertsCase = speller.convertsCase();
        if (plainTextReader != null) {
            MorfologikSpeller plainTextSpeller = this.getPlainTextDictSpellerOrNull(plainTextReader, plainTextReaderPath, languageVariantPlainTextReader, languageVariantPlainTextPath, binaryDictPath, maxEditDistance);
            if (plainTextSpeller != null) {
                spellers.add(plainTextSpeller);
                this.defaultDictSpellers = Arrays.asList(speller, plainTextSpeller);
            } else {
                this.defaultDictSpellers = Collections.singletonList(speller);
            }
        } else {
            this.defaultDictSpellers = Collections.singletonList(speller);
        }
        this.spellers = Collections.unmodifiableList(spellers);
    }

    @NotNull
    private static BufferedReader getBufferedReader(List<String> plainTextPaths) {
        ArrayList<InputStream> streams = new ArrayList<InputStream>();
        for (String plainTextPath : plainTextPaths) {
            streams.add(JLanguageTool.getDataBroker().getFromResourceDirAsStream(plainTextPath));
        }
        return new BufferedReader(new InputStreamReader((InputStream)new SequenceInputStream(Collections.enumeration(streams)), StandardCharsets.UTF_8));
    }

    public static void clearUserDictCache() {
        userDictCaches.clear();
        userDictSizes.clear();
    }

    private Cache<String, Dictionary> getUserDictCache() {
        if (this.premiumUid == null || this.userDictCacheSize == null || this.userDictName == null) {
            throw new IllegalStateException("No user / dict caching / dict name configured: user = " + this.premiumUid + ", cache size = " + this.userDictCacheSize + ", dict name = " + this.userDictName);
        }
        if (userDictCaches.containsKey(this.userDictCacheKey)) {
            return userDictCaches.get(this.userDictCacheKey);
        }
        Cache cache = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterWrite(10L, TimeUnit.MINUTES).maximumWeight(this.userDictCacheSize.longValue()).weigher((k, v) -> userDictSizes.get(this.userDictCacheKey).get(k)).build();
        userDictCaches.put(this.userDictCacheKey, (Cache<String, Dictionary>)cache);
        return cache;
    }

    private MorfologikSpeller getUserDictSpellerOrNull(UserConfig userConfig, String dictPath, int maxEditDistance) throws IOException {
        if (this.premiumUid == null) {
            return null;
        }
        if (userConfig.getAcceptedWords().isEmpty()) {
            return null;
        }
        Supplier<List<byte[]>> byteLinesSupplier = () -> {
            ArrayList<byte[]> byteLines = new ArrayList<byte[]>();
            for (String line : userConfig.getAcceptedWords()) {
                byteLines.add(line.getBytes(StandardCharsets.UTF_8));
            }
            return byteLines;
        };
        Dictionary dictionary = this.getDictionary(byteLinesSupplier, dictPath, dictPath.replace(".dict", ".info"), true, userConfig.getAcceptedWords().size());
        return new MorfologikSpeller(dictionary, maxEditDistance);
    }

    private MorfologikSpeller getBinaryDict(String binaryDictPath, int maxEditDistance) {
        if (binaryDictPath.endsWith(".dict")) {
            return new MorfologikSpeller(binaryDictPath, maxEditDistance);
        }
        throw new IllegalArgumentException("Unsupported dictionary, binary Morfologik file needs to have suffix .dict: " + binaryDictPath);
    }

    @Nullable
    private MorfologikSpeller getPlainTextDictSpellerOrNull(BufferedReader plainTextReader, List<String> plainTextReaderPaths, BufferedReader languageVariantPlainTextReader, String languageVariantPlainTextPath, String dictPath, int maxEditDistance) throws IOException {
        Supplier<List<byte[]>> lineSupplier = () -> {
            ArrayList lines = new ArrayList();
            for (String plainTextReaderPath : plainTextReaderPaths) {
                List l = (List)dictCache.getUnchecked((Object)new BufferedReaderWithSource(plainTextReader, plainTextReaderPath, languageVariantPlainTextReader, languageVariantPlainTextPath, this.language));
                lines.addAll(l);
            }
            if (lines.isEmpty()) {
                return null;
            }
            return lines;
        };
        Dictionary dictionary = this.getDictionary(lineSupplier, plainTextReaderPaths.toString(), dictPath.replace(".dict", ".info"), false, 0);
        if (dictionary == null) {
            return null;
        }
        return new MorfologikSpeller(dictionary, maxEditDistance);
    }

    private Dictionary getDictionary(Supplier<List<byte[]>> lines, String dictPath, String infoPath, boolean isUserDict, int userDictSize) throws IOException {
        List<byte[]> linesCopy;
        String cacheKey = dictPath + "|" + infoPath;
        Dictionary dictFromCache = dicPathToDict.get(cacheKey);
        if (!isUserDict && dictFromCache != null) {
            return dictFromCache;
        }
        if (isUserDict && this.userDictCacheSize != null) {
            userDictSizes.putIfAbsent(this.userDictCacheKey, new HashMap());
            userDictSizes.get(this.userDictCacheKey).put(this.userDictName, userDictSize);
            Cache<String, Dictionary> userDictCache = this.getUserDictCache();
            Dictionary userDict = (Dictionary)userDictCache.getIfPresent((Object)this.userDictName);
            if (userDict != null) {
                return userDict;
            }
        }
        if ((linesCopy = lines.get()).isEmpty()) {
            return null;
        }
        linesCopy.sort(FSABuilder.LEXICAL_ORDERING);
        FSA fsa = FSABuilder.build(linesCopy);
        ByteArrayOutputStream fsaOutStream = new CFSA2Serializer().serialize(fsa, new ByteArrayOutputStream());
        ByteArrayInputStream fsaInStream = new ByteArrayInputStream(fsaOutStream.toByteArray());
        InputStream metadata = new File(infoPath).exists() ? new FileInputStream(infoPath) : JLanguageTool.getDataBroker().getFromResourceDirAsStream(infoPath);
        Dictionary dict = Dictionary.read(fsaInStream, metadata);
        if (!isUserDict) {
            dicPathToDict.put(cacheKey, dict);
        } else if (this.userDictCacheSize != null) {
            this.getUserDictCache().put((Object)this.userDictName, (Object)dict);
        }
        return dict;
    }

    public boolean isMisspelled(String word) {
        for (MorfologikSpeller speller : this.spellers) {
            if (speller.isMisspelled(word)) continue;
            return false;
        }
        return true;
    }

    public int getFrequency(String word) {
        for (MorfologikSpeller speller : this.spellers) {
            int freq = speller.getFrequency(word);
            if (freq <= 0) continue;
            return freq;
        }
        return 0;
    }

    @NotNull
    private List<String> getSuggestionsFromSpellers(String word, List<MorfologikSpeller> spellerList) {
        ArrayList<WeightedSuggestion> result2 = new ArrayList<WeightedSuggestion>();
        HashSet<String> seenWords = new HashSet<String>();
        for (MorfologikSpeller speller : spellerList) {
            List<WeightedSuggestion> suggestions = speller.getSuggestions(word);
            for (WeightedSuggestion suggestion : suggestions) {
                if (!seenWords.contains(suggestion.getWord()) && !suggestion.getWord().equals(word)) {
                    result2.add(suggestion);
                }
                seenWords.add(suggestion.getWord());
            }
        }
        Collections.sort(result2);
        ArrayList<String> wordResults = new ArrayList<String>();
        for (WeightedSuggestion weightedSuggestion : result2) {
            wordResults.add(weightedSuggestion.getWord());
        }
        return wordResults;
    }

    public List<String> getSuggestions(String word) {
        return this.getSuggestionsFromSpellers(word, this.spellers);
    }

    public List<String> getSuggestionsFromUserDicts(String word) {
        return this.getSuggestionsFromSpellers(word, this.userDictSpellers);
    }

    public List<String> getSuggestionsFromDefaultDicts(String word) {
        return this.getSuggestionsFromSpellers(word, this.defaultDictSpellers);
    }

    public boolean convertsCase() {
        return this.convertsCase;
    }

    private static class UserDictCacheKey {
        private final long userId;
        private final String binaryDictPath;

        UserDictCacheKey(long userId, String binaryDictPath) {
            this.userId = userId;
            this.binaryDictPath = binaryDictPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UserDictCacheKey that = (UserDictCacheKey)o;
            return new EqualsBuilder().append(this.userId, that.userId).append((Object)this.binaryDictPath, (Object)that.binaryDictPath).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(43, 57).append(this.userId).append((Object)this.binaryDictPath).toHashCode();
        }
    }

    static class BufferedReaderWithSource {
        private final BufferedReader reader;
        private final String readerPath;
        private final BufferedReader languageVariantReader;
        private final String languageVariantPath;
        private final Language language;

        BufferedReaderWithSource(BufferedReader reader, String readerPath, BufferedReader languageVariantReader, String languageVariantPath, Language language) {
            this.reader = Objects.requireNonNull(reader);
            this.readerPath = Objects.requireNonNull(readerPath);
            this.languageVariantReader = languageVariantReader;
            this.languageVariantPath = languageVariantPath;
            this.language = language;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BufferedReaderWithSource that = (BufferedReaderWithSource)o;
            return Objects.equals(this.readerPath, that.readerPath) && Objects.equals(this.languageVariantPath, that.languageVariantPath);
        }

        public int hashCode() {
            return Objects.hash(this.readerPath, this.languageVariantPath);
        }
    }
}

