/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs;

import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.prettierjs.PrettierConfiguration;
import com.intellij.prettierjs.PrettierLanguageService;
import com.intellij.prettierjs.PrettierUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0081@\u00a2\u0006\u0002\u0010\u0004\u001a\u001e\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a8\u0006\f"}, d2={"resolveConfigForFile", "Lcom/intellij/prettierjs/PrettierLanguageService$ResolveConfigResult;", "file", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ensureConfigsSaved", "", "virtualFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.prettierJS"})
@SourceDebugExtension(value={"SMAP\nPrettierConfigUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrettierConfigUtil.kt\ncom/intellij/prettierjs/PrettierConfigUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,36:1\n1863#2,2:37\n*S KotlinDebug\n*F\n+ 1 PrettierConfigUtil.kt\ncom/intellij/prettierjs/PrettierConfigUtilKt\n*L\n30#1:37,2\n*E\n"})
public final class PrettierConfigUtilKt {
    @RequiresReadLock
    @Nullable
    public static final Object resolveConfigForFile(@NotNull PsiFile file, @NotNull Continuation<? super PrettierLanguageService.ResolveConfigResult> $completion) {
        String filePath;
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        String string = filePath = file.isValid() ? file.getVirtualFile().getPath() : null;
        if (filePath == null) {
            return null;
        }
        NodePackage nodePackage = PrettierConfiguration.getInstance(project2).getPackage((PsiElement)file);
        Intrinsics.checkNotNullExpressionValue((Object)nodePackage, (String)"getPackage(...)");
        NodePackage nodePackage2 = nodePackage;
        VirtualFile virtualFile = file.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        PrettierLanguageService service = PrettierLanguageService.Companion.getInstance(project2, virtualFile, nodePackage2);
        CompletableFuture<PrettierLanguageService.ResolveConfigResult> completableFuture = service.resolveConfig(filePath, nodePackage2);
        if (completableFuture == null) {
            return null;
        }
        CompletableFuture<PrettierLanguageService.ResolveConfigResult> future = completableFuture;
        return TimeoutKt.withTimeoutOrNull-KLykuaI((long)DurationKt.toDuration((int)500, (DurationUnit)DurationUnit.MILLISECONDS), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super PrettierLanguageService.ResolveConfigResult>, Object>(future, null){
            int label;
            final /* synthetic */ CompletableFuture<PrettierLanguageService.ResolveConfigResult> $future;
            {
                this.$future = $future;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FutureKt.await((CompletionStage)this.$future, (Continuation)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super PrettierLanguageService.ResolveConfigResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public static final void ensureConfigsSaved(@NotNull List<? extends VirtualFile> virtualFiles, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(virtualFiles, (String)"virtualFiles");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager documentManager = fileDocumentManager;
        Collection<VirtualFile> collection = PrettierUtil.lookupPossibleConfigFiles(virtualFiles, project);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"lookupPossibleConfigFiles(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile config = (VirtualFile)element$iv;
            boolean bl = false;
            Document document = documentManager.getCachedDocument(config);
            if (document == null || !documentManager.isDocumentUnsaved(document)) continue;
            documentManager.saveDocument(document);
        }
    }
}

