/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessService;
import com.intellij.execution.process.ProcessTreeKiller;
import com.intellij.execution.process.SelfKiller;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.execution.process.WinProcessTerminator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KillableProcessHandler
extends OSProcessHandler
implements KillableProcess {
    private static final Logger LOG = Logger.getInstance(KillableProcessHandler.class);
    private boolean myShouldKillProcessSoftly;
    private boolean myShouldKillProcessSoftlyWithWinP;

    public KillableProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            KillableProcessHandler.$$$reportNull$$$0(0);
        }
        super(commandLine);
        this.myShouldKillProcessSoftly = true;
        this.myShouldKillProcessSoftlyWithWinP = SystemInfo.isWin10OrNewer && Registry.is((String)"use.winp.for.graceful.process.termination");
    }

    protected KillableProcessHandler(@NotNull Process process, @NotNull GeneralCommandLine commandLine) {
        if (process == null) {
            KillableProcessHandler.$$$reportNull$$$0(1);
        }
        if (commandLine == null) {
            KillableProcessHandler.$$$reportNull$$$0(2);
        }
        super(process, commandLine.getCommandLineString(), commandLine.getCharset());
        this.myShouldKillProcessSoftly = true;
        this.myShouldKillProcessSoftlyWithWinP = SystemInfo.isWin10OrNewer && Registry.is((String)"use.winp.for.graceful.process.termination");
    }

    @Deprecated(forRemoval=true)
    public KillableProcessHandler(@NotNull GeneralCommandLine commandLine, boolean withMediator) throws ExecutionException {
        if (commandLine == null) {
            KillableProcessHandler.$$$reportNull$$$0(3);
        }
        this(commandLine);
    }

    public KillableProcessHandler(@NotNull Process process, String commandLine) {
        if (process == null) {
            KillableProcessHandler.$$$reportNull$$$0(4);
        }
        super(process, commandLine);
        this.myShouldKillProcessSoftly = true;
        this.myShouldKillProcessSoftlyWithWinP = SystemInfo.isWin10OrNewer && Registry.is((String)"use.winp.for.graceful.process.termination");
    }

    public KillableProcessHandler(@NotNull Process process, String commandLine, @NotNull Charset charset) {
        if (process == null) {
            KillableProcessHandler.$$$reportNull$$$0(5);
        }
        if (charset == null) {
            KillableProcessHandler.$$$reportNull$$$0(6);
        }
        this(process, commandLine, charset, (Set<File>)null);
    }

    public KillableProcessHandler(@NotNull Process process, String commandLine, @NotNull Charset charset, @Nullable Set<File> filesToDelete) {
        if (process == null) {
            KillableProcessHandler.$$$reportNull$$$0(7);
        }
        if (charset == null) {
            KillableProcessHandler.$$$reportNull$$$0(8);
        }
        super(process, commandLine, charset, filesToDelete);
        this.myShouldKillProcessSoftly = true;
        this.myShouldKillProcessSoftlyWithWinP = SystemInfo.isWin10OrNewer && Registry.is((String)"use.winp.for.graceful.process.termination");
    }

    public boolean shouldKillProcessSoftly() {
        return this.myShouldKillProcessSoftly;
    }

    public void setShouldKillProcessSoftly(boolean shouldKillProcessSoftly) {
        this.myShouldKillProcessSoftly = shouldKillProcessSoftly;
    }

    protected final boolean canDestroyProcessGracefully() {
        if (KillableProcessHandler.processCanBeKilledByOS(this.myProcess)) {
            if (SystemInfo.isWindows) {
                return this.hasPty() || this.canTerminateGracefullyWithWinP();
            }
            if (SystemInfo.isUnix) {
                return true;
            }
        }
        return false;
    }

    protected void destroyProcessImpl() {
        try {
            this.myProcess.getOutputStream().flush();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        finally {
            this.doDestroyProcess();
        }
    }

    @Override
    protected void doDestroyProcess() {
        boolean gracefulTerminationAttempted;
        Process process = this.myProcess;
        if (process instanceof SelfKiller) {
            SelfKiller selfKiller = (SelfKiller)((Object)process);
            if (!selfKiller.tryDestroyGracefully()) {
                super.doDestroyProcess();
            }
            return;
        }
        boolean bl = gracefulTerminationAttempted = this.shouldKillProcessSoftly() && this.canDestroyProcessGracefully() && this.destroyProcessGracefully();
        if (!gracefulTerminationAttempted) {
            super.doDestroyProcess();
        }
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Experimental
    public void setShouldKillProcessSoftlyWithWinP(boolean shouldKillProcessSoftlyWithWinP) {
        this.myShouldKillProcessSoftlyWithWinP = shouldKillProcessSoftlyWithWinP;
    }

    private boolean canTerminateGracefullyWithWinP() {
        return this.myShouldKillProcessSoftlyWithWinP && SystemInfo.isWin10OrNewer && !this.isWslProcess();
    }

    private boolean isWslProcess() {
        boolean wsl;
        List<String> command = KillableProcessHandler.getProcessService().getCommand(this.myProcess);
        String executable = (String)ContainerUtil.getFirstItem(command);
        boolean bl = wsl = executable != null && PathUtil.getFileName((String)executable).equals("wsl.exe");
        if (wsl) {
            LOG.info("WinP graceful termination does not work for WSL process: " + String.valueOf(command));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("[graceful termination with WinP] WSL process: " + wsl + ", process: " + String.valueOf(this.myProcess.getClass()) + ", command: " + String.valueOf(command));
        }
        return wsl;
    }

    protected boolean destroyProcessGracefully() {
        ProcessService processService = KillableProcessHandler.getProcessService();
        if (SystemInfo.isWindows) {
            if (processService.hasControllingTerminal(this.myProcess) && WinProcessTerminator.terminateWinProcessGracefully(this, processService, (Function0<Boolean>)((Function0)this::sendInterruptToPtyProcess))) {
                return true;
            }
            if (this.canTerminateGracefullyWithWinP() && !Registry.is((String)"disable.winp")) {
                try {
                    if (!this.myProcess.isAlive()) {
                        OSProcessUtil.logSkippedActionWithTerminatedProcess(this.myProcess, "destroy", this.getCommandLineForLog());
                        return true;
                    }
                    return WinProcessTerminator.terminateWinProcessGracefully(this, processService);
                }
                catch (Throwable e) {
                    if (!this.myProcess.isAlive()) {
                        OSProcessUtil.logSkippedActionWithTerminatedProcess(this.myProcess, "destroy", this.getCommandLineForLog());
                        return true;
                    }
                    String message = e.getMessage();
                    if (message != null && message.contains(".exe terminated with exit code 6,")) {
                        String msg = "Cannot send Ctrl+C to process without a console (fallback to default termination)";
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(msg + " " + this.getCommandLineForLog());
                        }
                        LOG.info(msg);
                    }
                    LOG.error("Cannot send Ctrl+C (fallback to default termination) " + this.getCommandLineForLog(), e);
                }
            }
        } else if (SystemInfo.isUnix) {
            if (processService.hasControllingTerminal(this.myProcess) && this.sendInterruptToPtyProcess()) {
                return true;
            }
            if (this.shouldDestroyProcessRecursively()) {
                return UnixProcessManager.sendSigIntToProcessTree((Process)this.myProcess);
            }
            return UnixProcessManager.sendSignal((int)UnixProcessManager.getProcessId((Process)this.myProcess), (int)2) == 0;
        }
        return false;
    }

    @NotNull
    private static ProcessService getProcessService() {
        ProcessService processService = (ProcessService)ProgressManager.getInstance().computeInNonCancelableSection(ProcessService::getInstance);
        if (processService == null) {
            KillableProcessHandler.$$$reportNull$$$0(9);
        }
        return processService;
    }

    private boolean sendInterruptToPtyProcess() {
        OutputStream outputStream = this.myProcess.getOutputStream();
        if (outputStream != null) {
            try {
                outputStream.write(3);
                outputStream.flush();
                return true;
            }
            catch (IOException e) {
                LOG.info("Failed to send Ctrl+C to PTY process. Fallback to default graceful termination.", (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public boolean canKillProcess() {
        return KillableProcessHandler.processCanBeKilledByOS(this.getProcess()) || this.getProcess() instanceof ProcessTreeKiller;
    }

    @Override
    public void killProcess() {
        if (KillableProcessHandler.processCanBeKilledByOS(this.getProcess())) {
            this.killProcessTree(this.getProcess());
        } else if (this.getProcess() instanceof ProcessTreeKiller) {
            ((ProcessTreeKiller)((Object)this.getProcess())).killProcessTree();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/KillableProcessHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/KillableProcessHandler";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }
}

