/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.Motion;
import androidx.compose.animation.core.PreconditionsKt;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003J-\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019R$\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\b\"\u0004\b\u000b\u0010\u0004R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\u0004\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001a"}, d2={"Landroidx/compose/animation/core/SpringSimulation;", "", "finalPosition", "", "(F)V", "value", "dampingRatio", "getDampingRatio", "()F", "setDampingRatio", "getFinalPosition", "setFinalPosition", "naturalFreq", "", "stiffness", "getStiffness", "setStiffness", "getAcceleration", "lastDisplacement", "lastVelocity", "updateValues", "Landroidx/compose/animation/core/Motion;", "timeElapsed", "", "updateValues-IJZedt4$animation_core", "(FFJ)J", "animation-core"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSpringSimulation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringSimulation.kt\nandroidx/compose/animation/core/SpringSimulation\n+ 2 SpringSimulation.kt\nandroidx/compose/animation/core/SpringSimulationKt\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n*L\n1#1,152:1\n38#2:153\n53#3,3:154\n*S KotlinDebug\n*F\n+ 1 SpringSimulation.kt\nandroidx/compose/animation/core/SpringSimulation\n*L\n149#1:153\n149#1:154,3\n*E\n"})
public final class SpringSimulation {
    private float finalPosition;
    private double naturalFreq;
    private float dampingRatio;
    public static final int $stable = 8;

    public SpringSimulation(float finalPosition) {
        this.finalPosition = finalPosition;
        this.naturalFreq = Math.sqrt(50.0);
        this.dampingRatio = 1.0f;
    }

    public final float getFinalPosition() {
        return this.finalPosition;
    }

    public final void setFinalPosition(float f) {
        this.finalPosition = f;
    }

    public final float getStiffness() {
        return (float)(this.naturalFreq * this.naturalFreq);
    }

    public final void setStiffness(float value) {
        if (this.getStiffness() <= 0.0f) {
            PreconditionsKt.throwIllegalArgumentException("Spring stiffness constant must be positive.");
        }
        this.naturalFreq = Math.sqrt(value);
    }

    public final float getDampingRatio() {
        return this.dampingRatio;
    }

    public final void setDampingRatio(float value) {
        if (value < 0.0f) {
            PreconditionsKt.throwIllegalArgumentException("Damping ratio must be non-negative");
        }
        this.dampingRatio = value;
    }

    public final float getAcceleration(float lastDisplacement, float lastVelocity) {
        float adjustedDisplacement = lastDisplacement - this.finalPosition;
        double k = this.naturalFreq * this.naturalFreq;
        double c = 2.0 * this.naturalFreq * (double)this.dampingRatio;
        return (float)(-k * (double)adjustedDisplacement - c * (double)lastVelocity);
    }

    public final long updateValues-IJZedt4$animation_core(float lastDisplacement, float lastVelocity, long timeElapsed) {
        float adjustedDisplacement = lastDisplacement - this.finalPosition;
        double deltaT = (double)timeElapsed / 1000.0;
        double dampingRatioSquared = (double)this.dampingRatio * (double)this.dampingRatio;
        double r = (double)(-this.dampingRatio) * this.naturalFreq;
        double displacement = 0.0;
        double currentVelocity = 0.0;
        if (this.dampingRatio > 1.0f) {
            double s = this.naturalFreq * Math.sqrt(dampingRatioSquared - 1.0);
            double gammaPlus = r + s;
            double gammaMinus = r - s;
            double coeffB = (gammaMinus * (double)adjustedDisplacement - (double)lastVelocity) / (gammaMinus - gammaPlus);
            double coeffA = (double)adjustedDisplacement - coeffB;
            displacement = coeffA * Math.exp(gammaMinus * deltaT) + coeffB * Math.exp(gammaPlus * deltaT);
            currentVelocity = coeffA * gammaMinus * Math.exp(gammaMinus * deltaT) + coeffB * gammaPlus * Math.exp(gammaPlus * deltaT);
        } else if (this.dampingRatio == 1.0f) {
            float coeffA = adjustedDisplacement;
            double coeffB = (double)lastVelocity + this.naturalFreq * (double)adjustedDisplacement;
            double nFdT = -this.naturalFreq * deltaT;
            displacement = ((double)coeffA + coeffB * deltaT) * Math.exp(nFdT);
            currentVelocity = ((double)coeffA + coeffB * deltaT) * Math.exp(nFdT) * -this.naturalFreq + coeffB * Math.exp(nFdT);
        } else {
            double dampedFreq = this.naturalFreq * Math.sqrt(1.0 - dampingRatioSquared);
            float cosCoeff = adjustedDisplacement;
            double sinCoeff = 1.0 / dampedFreq * (-r * (double)adjustedDisplacement + (double)lastVelocity);
            double dFdT = dampedFreq * deltaT;
            displacement = Math.exp(r * deltaT) * ((double)cosCoeff * Math.cos(dFdT) + sinCoeff * Math.sin(dFdT));
            currentVelocity = displacement * r + Math.exp(r * deltaT) * (-dampedFreq * (double)cosCoeff * Math.sin(dFdT) + dampedFreq * sinCoeff * Math.cos(dFdT));
        }
        float newValue = (float)(displacement + (double)this.finalPosition);
        float newVelocity = (float)currentVelocity;
        boolean $i$f$Motion = false;
        boolean $i$f$packFloats = false;
        long v1$iv$iv = Float.floatToRawIntBits(newValue);
        long v2$iv$iv = Float.floatToRawIntBits(newVelocity);
        return Motion.constructor-impl(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL);
    }
}

