/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.index;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CssIndexValue {
    COLOR{

        @Override
        public String indexKey(String key) {
            return key;
        }
    }
    ,
    ANIMATION{

        @Override
        public String indexKey(String key) {
            return "!".concat(key);
        }
    }
    ,
    KEYFRAMES{

        @Override
        public String indexKey(String key) {
            return "@".concat(key);
        }
    }
    ,
    FONT_FAMILY{

        @Override
        public String indexKey(String key) {
            return "^".concat(key);
        }
    }
    ,
    FONT_FAMILY_PACK{

        @Override
        public String indexKey(String key) {
            return "&".concat(key);
        }
    }
    ,
    COLOR_RGB{

        @Override
        public String indexKey(String key) {
            return "~".concat(key);
        }
    };


    public abstract String indexKey(String var1);

    public static String realKey(String s) {
        CssIndexValue value = CssIndexValue.keyType(s);
        return value != COLOR ? s.substring(1) : s;
    }

    public static CssIndexValue keyType(String key) {
        if (!key.isEmpty()) {
            return switch (key.charAt(0)) {
                case '!' -> ANIMATION;
                case '^' -> FONT_FAMILY;
                case '@' -> KEYFRAMES;
                case '&' -> FONT_FAMILY_PACK;
                case '~' -> COLOR_RGB;
                default -> COLOR;
            };
        }
        return COLOR;
    }
}

