/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.remote.jdbc.impl.ReflectionHelper;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableRunnable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JdbcNativeUtil {
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public static final int UNKNOWN_UPDATE_COUNT = -2;
    static final Pattern DEFAULT_VERSION_PATTERN = Pattern.compile("(\\d+(?:\\.\\d+)+)");

    public static void logInfo(@NotNull String s) {
        if (s == null) {
            JdbcNativeUtil.$$$reportNull$$$0(0);
        }
        System.out.println(s);
    }

    public static void logWarn(@Nullable String s, @Nullable Throwable t) {
        if (s != null) {
            System.err.println(s);
        }
        if (t != null) {
            t.printStackTrace(System.err);
        }
    }

    public static void closeRemoteStatementSafe(@Nullable RemoteStatement statement) {
        if (statement == null) {
            return;
        }
        JdbcNativeUtil.performSafe((ThrowableRunnable<? extends Exception>)((ThrowableRunnable)() -> statement.close()));
    }

    public static void performSafe(@NotNull ThrowableRunnable<? extends Exception> runnable) {
        if (runnable == null) {
            JdbcNativeUtil.$$$reportNull$$$0(1);
        }
        try {
            runnable.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    public static <T> T computeSafe(@NotNull ThrowableComputable<T, ? extends Exception> computable) {
        if (computable == null) {
            JdbcNativeUtil.$$$reportNull$$$0(2);
        }
        try {
            return (T)computable.compute();
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public static boolean getBooleanSafe(@NotNull ThrowableComputable<Boolean, ? extends Exception> computable) {
        Boolean res;
        if (computable == null) {
            JdbcNativeUtil.$$$reportNull$$$0(3);
        }
        return (res = JdbcNativeUtil.computeSafe(computable)) != null && res != false;
    }

    public static int getIntSafe(@NotNull ThrowableComputable<Integer, ? extends Exception> computable) {
        Integer res;
        if (computable == null) {
            JdbcNativeUtil.$$$reportNull$$$0(4);
        }
        return (res = JdbcNativeUtil.computeSafe(computable)) != null ? res : -1;
    }

    public static void performRemote(@NotNull ThrowableRunnable<? extends Exception> runnable) throws SQLException {
        if (runnable == null) {
            JdbcNativeUtil.$$$reportNull$$$0(5);
        }
        try {
            runnable.run();
        }
        catch (Throwable th) {
            JdbcNativeUtil.rethrowRemoteException(th);
        }
    }

    @Nullable
    public static <T> T computeRemote(@NotNull ThrowableComputable<T, ? extends Exception> computable) throws SQLException {
        if (computable == null) {
            JdbcNativeUtil.$$$reportNull$$$0(6);
        }
        try {
            return (T)computable.compute();
        }
        catch (Throwable th) {
            JdbcNativeUtil.rethrowRemoteException(th);
            return null;
        }
    }

    private static void rethrowRemoteException(Throwable th) throws SQLException {
        if (th instanceof RuntimeException) {
            throw (RuntimeException)th;
        }
        if (th instanceof SQLException) {
            throw (SQLException)th;
        }
        if (th instanceof Error) {
            if (th instanceof AssertionError) {
                return;
            }
            throw (Error)th;
        }
        if (ExceptionUtilRt.causedBy((Throwable)th, AbstractMethodError.class)) {
            return;
        }
        throw new SQLException(th);
    }

    @Nullable
    public static Object tryGetString(@NotNull Object o) {
        if (o == null) {
            JdbcNativeUtil.$$$reportNull$$$0(7);
        }
        return ReflectionHelper.tryInvokeMethod(o, "getString", null, null);
    }

    @Nullable
    public static Object tryGetBytes(@NotNull Object o) {
        if (o == null) {
            JdbcNativeUtil.$$$reportNull$$$0(8);
        }
        return ReflectionHelper.tryInvokeMethod(o, "getBytes", null, null);
    }

    static boolean detectString(@Nullable String product, @NotNull String part) {
        if (part == null) {
            JdbcNativeUtil.$$$reportNull$$$0(9);
        }
        return product != null && Pattern.compile("\\b" + part, 2).matcher(product).find();
    }

    @Nullable
    static String getString(@NotNull Connection delegate, @Language(value="SQL") @NotNull String sql) throws Exception {
        if (delegate == null) {
            JdbcNativeUtil.$$$reportNull$$$0(10);
        }
        if (sql == null) {
            JdbcNativeUtil.$$$reportNull$$$0(11);
        }
        return JdbcNativeUtil.getString(delegate, sql, 1);
    }

    @Nullable
    static String getString(@NotNull Connection delegate, @Language(value="SQL") @NotNull String sql, int col) throws Exception {
        if (delegate == null) {
            JdbcNativeUtil.$$$reportNull$$$0(12);
        }
        if (sql == null) {
            JdbcNativeUtil.$$$reportNull$$$0(13);
        }
        Ref res = Ref.create();
        JdbcNativeUtil.consume(delegate, sql, (ThrowableConsumer<? super ResultSet, ? extends Exception>)((ThrowableConsumer)rs -> res.set(rs.next() ? rs.getString(col) : null)));
        return (String)res.get();
    }

    static String @NotNull [] getStrings(@NotNull Connection delegate, @Language(value="SQL") @NotNull String sql) throws Exception {
        if (delegate == null) {
            JdbcNativeUtil.$$$reportNull$$$0(14);
        }
        if (sql == null) {
            JdbcNativeUtil.$$$reportNull$$$0(15);
        }
        Ref res = Ref.create();
        JdbcNativeUtil.consume(delegate, sql, (ThrowableConsumer<? super ResultSet, ? extends Exception>)((ThrowableConsumer)rs -> {
            if (!rs.next()) {
                return;
            }
            String[] cols = new String[rs.getMetaData().getColumnCount()];
            for (int i = 0; i < cols.length; ++i) {
                cols[i] = rs.getString(i + 1);
            }
            res.set((Object)cols);
        }));
        String[] stringArray = res.isNull() ? ArrayUtilRt.EMPTY_STRING_ARRAY : (String[])res.get();
        if (stringArray == null) {
            JdbcNativeUtil.$$$reportNull$$$0(16);
        }
        return stringArray;
    }

    static void consume(@NotNull Connection delegate, @Language(value="SQL") @NotNull String sql, @NotNull ThrowableConsumer<? super ResultSet, ? extends Exception> computable) throws Exception {
        if (delegate == null) {
            JdbcNativeUtil.$$$reportNull$$$0(17);
        }
        if (sql == null) {
            JdbcNativeUtil.$$$reportNull$$$0(18);
        }
        if (computable == null) {
            JdbcNativeUtil.$$$reportNull$$$0(19);
        }
        JdbcNativeUtil.prepared(delegate, sql, stmt -> {
            stmt.execute();
            try (ResultSet rs = stmt.getResultSet();){
                computable.consume((Object)rs);
            }
        });
    }

    static <E extends Exception> void prepared(@NotNull Connection delegate, @Language(value="SQL") @NotNull String sql, @NotNull ThrowableConsumer<? super PreparedStatement, E> computable) throws E, SQLException {
        if (delegate == null) {
            JdbcNativeUtil.$$$reportNull$$$0(20);
        }
        if (sql == null) {
            JdbcNativeUtil.$$$reportNull$$$0(21);
        }
        if (computable == null) {
            JdbcNativeUtil.$$$reportNull$$$0(22);
        }
        try (PreparedStatement stmt = delegate.prepareStatement(sql);){
            computable.consume((Object)stmt);
        }
    }

    @Nullable
    static String findVersion(@Nullable String versionStr, @NotNull Pattern pattern) {
        if (pattern == null) {
            JdbcNativeUtil.$$$reportNull$$$0(23);
        }
        if (versionStr == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(versionStr);
        return matcher.find() ? matcher.group(1) : null;
    }

    @NotNull
    public static Calendar getUtcCalendar() {
        Calendar calendar = Calendar.getInstance(UTC);
        if (calendar == null) {
            JdbcNativeUtil.$$$reportNull$$$0(24);
        }
        return calendar;
    }

    @NotNull
    public static Date createSqlDate(@NotNull java.util.Date value) {
        if (value == null) {
            JdbcNativeUtil.$$$reportNull$$$0(25);
        }
        return value instanceof Date ? (Date)value : new Date(value.getTime());
    }

    public static <T, C extends Collection<? super T>> C addAll(C c, T ... elements) {
        c.addAll(Arrays.asList(elements));
        return c;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sql";
                break;
            }
            case 16: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/JdbcNativeUtil";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/JdbcNativeUtil";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getStrings";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getUtcCalendar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "logInfo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "performSafe";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeSafe";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBooleanSafe";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIntSafe";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performRemote";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeRemote";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "tryGetString";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "tryGetBytes";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "detectString";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getString";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getStrings";
                break;
            }
            case 16: 
            case 24: {
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "consume";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "prepared";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findVersion";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createSqlDate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

