/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.connection.throwable.KnownDatabaseException;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.JdbcDriverManagerImpl;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseFastConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseSshTunnelEstablisher;
import com.intellij.database.dataSource.url.HostPort;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dialects.BaseDatabaseErrorHandler;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.openapi.util.Ref;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class SshConnectionInterceptor
extends DatabaseFastConnectionInterceptor {
    @Override
    public boolean interceptConnectionFast(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, boolean silent) {
        DatabaseConnectionPoint connectionPoint;
        JdbcDriverManager driverManager;
        List<DatabaseSshTunnelEstablisher.SshTunnel> tunnels;
        if (proto2 == null) {
            SshConnectionInterceptor.$$$reportNull$$$0(0);
        }
        if ((tunnels = (driverManager = JdbcDriverManager.getDriverManager(proto2.getProject())).getTunnels((connectionPoint = proto2.getConnectionPoint()).getDataSource())).isEmpty()) {
            DataSourceSshTunnelConfiguration ssh = DataSourceSshTunnelConfiguration.getEnabledSshConfiguration(proto2.getConnectionPoint());
            if (ssh != null && proto2.getDriver() != null) {
                RuntimeException exception = new RuntimeException("No SSH tunnel, available");
                BaseDatabaseErrorHandler.SshFailedErrorInfo info2 = new BaseDatabaseErrorHandler.SshFailedErrorInfo(proto2.getConnectionPoint().getDataSource(), exception, exception);
                throw new KnownDatabaseException(info2);
            }
            return false;
        }
        DatabaseDriver driver = connectionPoint.getDatabaseDriver();
        Ref parser2 = Ref.create();
        List<HostPort> hostsPorts = JdbcUrlParserUtil.extractHostsPorts(driver == null ? Collections.emptyList() : driver.getJDBCUrlParsers(), proto2.getUrl(), (Ref<JdbcUrlParser>)parser2);
        if (hostsPorts.isEmpty()) {
            return false;
        }
        ArrayList<JdbcSettings.PortForwarding> portForwardings = new ArrayList<JdbcSettings.PortForwarding>();
        int index = 0;
        for (DatabaseSshTunnelEstablisher.SshTunnel tunnel : tunnels) {
            HostPort localHostPort = new HostPort("localhost", tunnel.localPort);
            ((JdbcUrlParser)parser2.get()).setParameter("host", index, localHostPort.getHost());
            ((JdbcUrlParser)parser2.get()).setParameter("port", index, localHostPort.getPort());
            portForwardings.add(new JdbcSettings.PortForwarding(localHostPort.getHost(), localHostPort.getPort(), tunnel.remoteHostPort.getHost(), tunnel.remoteHostPort.getPort()));
            ++index;
        }
        proto2.setUrl(((JdbcUrlParser)parser2.get()).getUrlText());
        JdbcSettings.PORT_FORWARDINGS.put(proto2.getExtraProperties(), portForwardings);
        return true;
    }

    @Override
    public boolean handleConnectionFailureFast(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, @NotNull Throwable e, boolean silent, int attempt) {
        Throwable state;
        if (proto2 == null) {
            SshConnectionInterceptor.$$$reportNull$$$0(1);
        }
        if (e == null) {
            SshConnectionInterceptor.$$$reportNull$$$0(2);
        }
        if ((state = ((JdbcDriverManagerImpl)JdbcDriverManager.getDriverManager(proto2.getProject())).getTunnelsState(proto2.getConnectionPoint().getDataSource())) != null) {
            BaseDatabaseErrorHandler.SshFailedErrorInfo info2 = new BaseDatabaseErrorHandler.SshFailedErrorInfo(proto2.getConnectionPoint().getDataSource(), state, state);
            throw new KnownDatabaseException(info2);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proto";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/SshConnectionInterceptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "interceptConnectionFast";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "handleConnectionFailureFast";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

