/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystemCore;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorageService;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorageManager;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbSrcUtils
extends DbSrcUtilsCore {
    private DbSrcUtils() {
    }

    @NotNull
    public static String getProjectId(Project project) {
        String string = project == null ? "app" : project.getLocationHash();
        if (string == null) {
            DbSrcUtils.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public static ObjectKind getKind(@NotNull String path) {
        ObjectPath obj2;
        if (path == null) {
            DbSrcUtils.$$$reportNull$$$0(1);
        }
        return (obj2 = DbSrcUtils.getFullPath(path)) == null ? null : obj2.kind;
    }

    @Nullable
    public static BasicElement findElement(@Nullable Project hint, @NotNull String file) {
        if (file == null) {
            DbSrcUtils.$$$reportNull$$$0(2);
        }
        return DbSrcUtils.findObject(hint, file, BasicElement.class, true);
    }

    @Nullable
    public static <T extends DasObject> T findObject(@Nullable Project hint, @NotNull String file, @NotNull Class<? extends T> clazz) {
        if (file == null) {
            DbSrcUtils.$$$reportNull$$$0(3);
        }
        if (clazz == null) {
            DbSrcUtils.$$$reportNull$$$0(4);
        }
        return DbSrcUtils.findObject(hint, file, clazz, true);
    }

    @Nullable
    public static <T extends DasObject> T findObject(final @Nullable Project hint, @NotNull String file, final @NotNull Class<? extends T> clazz, final boolean strict) {
        if (file == null) {
            DbSrcUtils.$$$reportNull$$$0(5);
        }
        if (clazz == null) {
            DbSrcUtils.$$$reportNull$$$0(6);
        }
        return (T)((DasObject)DbSrcFileSystem.processPath(file, new DbSrcFileSystemCore.ItemProcessor<T>(){

            @Override
            public T processFile(@Nullable Project p2, @NotNull String dataSourceId, @NotNull ObjectPath path, @NotNull DbSrcFileSystemCore.ItemType type) {
                if (dataSourceId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (type == null) {
                    1.$$$reportNull$$$0(2);
                }
                DbDataSource dataSource = null;
                if (p2 == null && hint != null) {
                    p2 = hint;
                }
                if (p2 == null) {
                    for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                        if (project.isDefault() || !project.isOpen()) break;
                        dataSource = DbPsiFacade.getInstance(project).findDataSource(dataSourceId);
                    }
                } else {
                    dataSource = DbPsiFacade.getInstance(p2).findDataSource(dataSourceId);
                }
                if (dataSource == null) {
                    return null;
                }
                DasObject res2 = (DasObject)DbSqlUtilCore.findObjects(dataSource, path).filter(clazz).first();
                if (res2 != null || strict) {
                    return res2;
                }
                ObjectPath tmp = path.parent;
                while (tmp != null && res2 == null) {
                    res2 = (DasObject)DbSqlUtilCore.findObjects(dataSource, tmp).filter(clazz).first();
                    tmp = tmp.parent;
                }
                return res2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataSourceId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/dataSource/srcStorage/DbSrcUtils$1";
                objectArray[2] = "processFile";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }));
    }

    @Nullable
    public static VirtualFile findDbSrcFile(@NotNull DbElement object, boolean refresh) {
        if (object == null) {
            DbSrcUtils.$$$reportNull$$$0(7);
        }
        return DbSrcUtils.findDbSrcFile(object.getDataSource(), object, refresh);
    }

    @Nullable
    public static VirtualFile findDbSrcDir(@NotNull DbElement object) {
        DbDataSource dbDs;
        LocalDataSource ds;
        if (object == null) {
            DbSrcUtils.$$$reportNull$$$0(8);
        }
        return (ds = DbImplUtil.getMaybeLocalDataSource(dbDs = object.getDataSource())) == null ? null : DbSrcFileSystem.getInstance().findFileByPath(DbSrcUtils.getPath(object.getProject(), ds, object == dbDs ? null : object, ds.getModel(), null));
    }

    @Nullable
    public static VirtualFile findDbSrcFile(@NotNull DbDataSource dataSource, @Nullable DasObject object, boolean refresh) {
        LocalDataSource source;
        if (dataSource == null) {
            DbSrcUtils.$$$reportNull$$$0(9);
        }
        return (source = (LocalDataSource)ObjectUtils.tryCast((Object)dataSource.getDelegate(), LocalDataSource.class)) == null ? null : DbSrcUtils.findDbSrcFile(dataSource.getProject(), source, object == dataSource ? null : object, dataSource.getModel(), refresh);
    }

    @Nullable
    public static VirtualFile findDbSrcFile(@NotNull Project project, @NotNull LocalDataSource dataSource, @Nullable DbElement object, boolean refresh) {
        if (project == null) {
            DbSrcUtils.$$$reportNull$$$0(10);
        }
        if (dataSource == null) {
            DbSrcUtils.$$$reportNull$$$0(11);
        }
        DasModel casingProvider = object == null ? null : object.getDataSource().getModel();
        return DbSrcUtils.findDbSrcFile(project, dataSource, object, casingProvider, refresh);
    }

    @Nullable
    public static VirtualFile findDbSrcFile(@NotNull Project project, @NotNull LocalDataSource dataSource, @Nullable DasObject object, @Nullable CasingProvider casingProvider, boolean refresh) {
        DbSrcStorage storage;
        if (project == null) {
            DbSrcUtils.$$$reportNull$$$0(12);
        }
        if (dataSource == null) {
            DbSrcUtils.$$$reportNull$$$0(13);
        }
        String filePath = DbSrcUtils.getPath(project, dataSource, object, casingProvider, DbSrcFileSystemCore.ItemType.SRC);
        if (refresh && (storage = DbSrcStorageManager.getInstance(project).getStorage(dataSource.getUniqueId(), false)) != null) {
            storage.flushToFs(false);
        }
        return refresh ? DbSrcFileSystem.getInstance().refreshAndFindFileByPath(filePath) : DbSrcFileSystem.getInstance().findFileByPath(filePath);
    }

    @NotNull
    public static String getPath(@NotNull Project project, @NotNull LocalDataSource dataSource, @Nullable DasObject object, @Nullable CasingProvider casingProvider, @Nullable DbSrcFileSystemCore.ItemType type) {
        if (project == null) {
            DbSrcUtils.$$$reportNull$$$0(14);
        }
        if (dataSource == null) {
            DbSrcUtils.$$$reportNull$$$0(15);
        }
        String string = DbSrcFileSystem.getPath(dataSource.isGlobal() ? null : project, dataSource.getUniqueId(), object, casingProvider, type);
        if (string == null) {
            DbSrcUtils.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Nullable
    public static Ref<Project> getProject(@NotNull String file) {
        if (file == null) {
            DbSrcUtils.$$$reportNull$$$0(17);
        }
        return DbSrcFileSystem.processPath(file, new DbSrcFileSystemCore.ItemProcessor<Ref<Project>>(){

            @Override
            public Ref<Project> processProject(@Nullable Project project) {
                return Ref.create((Object)project);
            }

            @Override
            public Ref<Project> processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
                if (dataSourceId == null) {
                    2.$$$reportNull$$$0(0);
                }
                return Ref.create((Object)project);
            }

            @Override
            public Ref<Project> processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable ObjectPath path, @Nullable ObjectKind group) {
                if (dataSourceId == null) {
                    2.$$$reportNull$$$0(1);
                }
                return Ref.create((Object)project);
            }

            @Override
            public Ref<Project> processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, @NotNull DbSrcFileSystemCore.ItemType type) {
                if (dataSourceId == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (path == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (type == null) {
                    2.$$$reportNull$$$0(4);
                }
                return Ref.create((Object)project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSourceId";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcUtils$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processDataSource";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFolder";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFile";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static void refresh() {
        DbSrcFileSystem.getInstance().refresh(true);
    }

    public static void resolveMy(@NotNull Iterable<VirtualFile> files2) throws IOException {
        if (files2 == null) {
            DbSrcUtils.$$$reportNull$$$0(18);
        }
        MultiMap<DbSrcStorage, ObjectPath> items = DbSrcUtils.collectSrcFiles(files2);
        for (Map.Entry entry : items.entrySet()) {
            DbSrcStorage storage = (DbSrcStorage)entry.getKey();
            for (ObjectPath path : (Collection)entry.getValue()) {
                storage.removeBaseContent(path);
            }
        }
        FileDocumentManager.getInstance().reloadFiles(VfsUtilCore.toVirtualFileArray((Collection)ContainerUtil.newArrayList(files2)));
        DbSrcUtils.refresh();
    }

    public static void revert(@NotNull Iterable<VirtualFile> files2) throws IOException {
        if (files2 == null) {
            DbSrcUtils.$$$reportNull$$$0(19);
        }
        MultiMap<DbSrcStorage, ObjectPath> items = DbSrcUtils.collectSrcFiles(files2);
        for (Map.Entry entry : items.entrySet()) {
            DbSrcStorage storage = (DbSrcStorage)entry.getKey();
            for (ObjectPath path : (Collection)entry.getValue()) {
                storage.putUserContent(path, null);
            }
        }
        FileDocumentManager.getInstance().reloadFiles(VfsUtilCore.toVirtualFileArray((Collection)ContainerUtil.newArrayList(files2)));
        DbSrcUtils.refresh();
    }

    @NotNull
    private static MultiMap<DbSrcStorage, ObjectPath> collectSrcFiles(@NotNull Iterable<VirtualFile> files2) {
        if (files2 == null) {
            DbSrcUtils.$$$reportNull$$$0(20);
        }
        final MultiMap items = MultiMap.createLinked();
        for (VirtualFile file : files2) {
            DbSrcFileSystem.processPath(file, new DbSrcFileSystemCore.ItemProcessor<Void>(){

                @Override
                public Void processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, @NotNull DbSrcFileSystemCore.ItemType type) {
                    if (dataSourceId == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (path == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    if (type == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    if (type != DbSrcFileSystemCore.ItemType.SRC) {
                        return null;
                    }
                    DbSrcStorage storage = DbSrcStorageManager.getInstance(project).getStorage(dataSourceId, true);
                    items.putValue((Object)storage, (Object)path);
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "dataSourceId";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "path";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "type";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/database/dataSource/srcStorage/DbSrcUtils$3";
                    objectArray[2] = "processFile";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        MultiMap multiMap = items;
        if (multiMap == null) {
            DbSrcUtils.$$$reportNull$$$0(21);
        }
        return multiMap;
    }

    public static Icon getIcon(@Nullable Project hint, String path) {
        DasObject object = DbSrcUtils.findObject(hint, path, DasObject.class);
        if (object != null) {
            return DbPresentationCore.getIcon(object);
        }
        ObjectKind kind = DbSrcUtils.getKind(path);
        return kind == null ? null : DbPresentationCore.getIcon(kind);
    }

    private static int readMaximum(InputStream is, byte[] buffer) throws IOException {
        int read;
        for (int offs = 0; buffer.length != offs; offs += read) {
            read = is.read(buffer, offs, buffer.length - offs);
            if (read != -1) continue;
            return offs == 0 ? -1 : offs;
        }
        return buffer.length;
    }

    @NotNull
    public static DataSourceStorage getDataSourceStorage(@Nullable Project project) {
        DataSourceStorage dataSourceStorage = project == null ? DataSourceStorage.getStorage() : DataSourceStorage.getProjectStorage(project);
        if (dataSourceStorage == null) {
            DbSrcUtils.$$$reportNull$$$0(22);
        }
        return dataSourceStorage;
    }

    public static void moveStorage(@NotNull LocalDataSource dataSource, @Nullable Project from, @Nullable Project to) throws IOException {
        DbSrcModelStorage storage;
        if (dataSource == null) {
            DbSrcUtils.$$$reportNull$$$0(23);
        }
        String id = dataSource.getUniqueId();
        DbSrcUtils.moveStorage(id, from, to);
        BaseModel model = (BaseModel)ObjectUtils.tryCast((Object)dataSource.getModel(), BaseModel.class);
        DbSrcModelStorage dbSrcModelStorage = storage = model == null ? null : (DbSrcModelStorage)ObjectUtils.tryCast((Object)model.getTextStorage(), DbSrcModelStorage.class);
        if (storage != null) {
            model.setTextStorage(DbSrcModelStorageService.getInstance().createStorage(to, id));
            model.moveEntities();
        }
    }

    public static void moveStorage(@NotNull String dataSourceId, @Nullable Project from, @Nullable Project to) throws IOException {
        if (dataSourceId == null) {
            DbSrcUtils.$$$reportNull$$$0(24);
        }
        if (from == to) {
            return;
        }
        DbSrcStorageManager srcManager = DbSrcStorageManager.getInstance(from);
        DbSrcStorage src = srcManager.getStorage(dataSourceId, false);
        if (src == null) {
            return;
        }
        DbSrcStorage tgt = DbSrcStorageManager.getInstance(to).getStorage(dataSourceId, true);
        tgt.consume(src);
        src.flushToFs(true);
        tgt.flushToFs(true);
        srcManager.removeBackend(dataSourceId);
    }

    public static boolean contentDiffers(InputStream is1, InputStream is2) throws IOException {
        int r1;
        boolean differs;
        byte[] buffer1 = new byte[0x100000];
        byte[] buffer2 = new byte[0x100000];
        do {
            int r2;
            differs = (r1 = DbSrcUtils.readMaximum(is1, buffer1)) != (r2 = DbSrcUtils.readMaximum(is2, buffer2));
            for (int i2 = 0; i2 < r1 && !differs; ++i2) {
                differs = buffer1[i2] != buffer2[i2];
            }
        } while (!differs && r1 != -1);
        return differs;
    }

    public static boolean contentDiffers(InputStream is, byte[] data) throws IOException {
        byte[] buffer = new byte[0x100000];
        int offset = 0;
        int r1;
        while ((r1 = DbSrcUtils.readMaximum(is, buffer)) != -1) {
            int end = offset + r1;
            if (end > data.length) {
                return true;
            }
            for (int i2 = 0; i2 < r1; ++i2) {
                if (data[offset + i2] == buffer[i2]) continue;
                return true;
            }
            offset = end;
        }
        return offset != data.length;
    }

    public static boolean isOriginal(@NotNull VirtualFile file) {
        if (file == null) {
            DbSrcUtils.$$$reportNull$$$0(25);
        }
        return DbSrcFileSystemCore.ItemType.ORIG.is(file.getName());
    }

    public static boolean isSrc(@NotNull VirtualFile file) {
        if (file == null) {
            DbSrcUtils.$$$reportNull$$$0(26);
        }
        return DbSrcFileSystemCore.ItemType.SRC.is(file.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 18, 19, 20, 23, 24, 25, 26 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcUtils";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 17: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcUtils";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSrcFiles";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourceStorage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getKind";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findObject";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findDbSrcFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findDbSrcDir";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getProject";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolveMy";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "revert";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "collectSrcFiles";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "moveStorage";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isOriginal";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isSrc";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 18, 19, 20, 23, 24, 25, 26 -> new IllegalArgumentException(string);
        };
    }
}

