/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mysql;

import com.intellij.database.DatabaseBundle;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParser;
import com.intellij.sql.dialects.base.SqlParserUtil;
import com.intellij.sql.dialects.mysql.MysqlDdlParsing;
import com.intellij.sql.dialects.mysql.MysqlDialect;
import com.intellij.sql.dialects.mysql.MysqlDmlParsing;
import com.intellij.sql.dialects.mysql.MysqlElementTypes;
import com.intellij.sql.dialects.mysql.MysqlExpressionParsing;
import com.intellij.sql.dialects.mysql.MysqlGeneratedParser;
import com.intellij.sql.dialects.mysql.MysqlTokens;
import com.intellij.sql.injection.SqlSuggestedInjection;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlTokens;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class MysqlParser
extends SqlParser {
    public static final SqlSuggestedInjection MYSQL_INJECTION = new SqlSuggestedInjection("MySQL");
    private static final WhitespacesAndCommentsBinder LEFT_BINDER = MysqlParser.newControlCommentBinder(true);
    private static final WhitespacesAndCommentsBinder RIGHT_BINDER = MysqlParser.newControlCommentBinder(false);

    public MysqlParser() {
        super(MysqlDialect.INSTANCE);
    }

    protected MysqlParser(SqlLanguageDialectEx language) {
        super(language);
    }

    @Override
    public boolean allowStringsAsIdentifiers(@Nullable SqlReferenceElementType refType) {
        return true;
    }

    @Override
    protected boolean consumeIdentifierInner(PsiBuilder builder, boolean allowKeywords, boolean allowString, @Nullable SqlReferenceElementType refType) {
        if (this.isVariableReference(builder)) {
            boolean advance;
            IElementType type = builder.rawLookup(1);
            boolean bl = advance = type == SQL_IDENT || type == SQL_IDENT_DELIMITED || type == SQL_MODULE || type instanceof SqlKeywordTokenType || allowString && type == SQL_STRING_TOKEN;
            if (advance) {
                builder.advanceLexer();
                builder.advanceLexer();
                return true;
            }
        }
        return super.consumeIdentifierInner(builder, allowKeywords, allowString, refType);
    }

    @Override
    protected boolean allowNoopStringConcatenation(PsiBuilder builder, boolean first2) {
        return !first2 && SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_IDENT_DELIMITED) || super.allowNoopStringConcatenation(builder, first2);
    }

    @Override
    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference(builder, level, MysqlExpressionParsing::evaluable_expression);
    }

    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        GeneratedParserUtilBase.addVariant((PsiBuilder)builder, (String)"DELIMITER");
        if (SqlParserUtil.nextTokenIs(builder, (IElementType)MysqlTokens.MYSQL_DELIMITER)) {
            PsiBuilder.Marker mark2 = builder.mark();
            builder.advanceLexer();
            if (this.getLanguage().getStatementSeparators().contains(builder.getTokenType())) {
                builder.advanceLexer();
            } else {
                SqlParserUtil.consumeOptionalToken(builder, BAD_CHARACTER);
                builder.error(DatabaseBundle.message("parsing.error.delimiter.expected", new Object[0]));
            }
            mark2.done((IElementType)MysqlElementTypes.Misc.MYSQL_DELIMITER_STATEMENT);
            this.statementSeparatorParsed(builder);
            return true;
        }
        boolean inPragma = builder.rawLookup(-2) == MYSQL_PRAGMA_BEGIN;
        boolean result2 = MysqlGeneratedParser.statement(builder, level);
        if (result2) {
            LighterASTNode marker = Objects.requireNonNull(builder.getLatestDoneMarker());
            if (inPragma && builder.rawLookup(2) == MYSQL_PRAGMA_END && builder.rawLookup(-1) != MYSQL_PRAGMA_END && this.getLanguage().getStatementSeparators().contains(builder.getTokenType())) {
                builder.advanceLexer();
                this.statementSeparatorParsed(builder);
                IElementType tokenType = marker.getTokenType();
                PsiBuilder.Marker precede = ((PsiBuilder.Marker)marker).precede();
                ((PsiBuilder.Marker)marker).drop();
                precede.done(tokenType);
                marker = precede;
            }
            ((PsiBuilder.Marker)marker).setCustomEdgeTokenBinders(LEFT_BINDER, RIGHT_BINDER);
        }
        return result2;
    }

    @Override
    protected TokenSet[] getExtendsTokenSets() {
        return MysqlGeneratedParser.EXTENDS_SETS_;
    }

    @Override
    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return MysqlDmlParsing.top_query_expression(builder, level);
    }

    @Override
    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return MysqlDdlParsing.type_element(builder, level);
    }

    @Override
    protected boolean parseCastDataType(PsiBuilder builder, int level) {
        return MysqlExpressionParsing.cast_type_element(builder, level);
    }

    @Override
    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result2 = MysqlExpressionParsing.value_expression(builder, level);
        if (!result2 && !optional) {
            builder.error(DatabaseBundle.message("parsing.error.expression.expected", new Object[0]));
        }
        return result2;
    }

    @Override
    protected boolean allowAnyIdentifierInOdbc() {
        return true;
    }

    @Override
    protected boolean allowIdentifiersAsStrings(PsiBuilder builder) {
        return GeneratedParserUtilBase.nextTokenIsFast((PsiBuilder)builder, (IElementType)SQL_IDENT_DELIMITED) && builder.getOriginalText().charAt(builder.rawTokenTypeStart(0)) == '\"';
    }

    @Override
    public boolean parseParameterReferenceInner(PsiBuilder builder, IElementType resultType) {
        PsiBuilder.Marker mark2 = builder.mark();
        IElementType paramToken = builder.getTokenType();
        if (paramToken != SQL_IDENT) {
            builder.advanceLexer();
            this.parseIdentifier(builder, false);
        } else if (GeneratedParserUtilBase.nextTokenIsFast((PsiBuilder)builder, (String)"@@session") || GeneratedParserUtilBase.nextTokenIsFast((PsiBuilder)builder, (String)"@@global")) {
            if (SqlParserUtil.consumeToken(builder, (IElementType)SQL_IDENT) && SqlParserUtil.consumeToken(builder, (IElementType)SQL_PERIOD)) {
                this.parseIdentifier(builder, false);
            }
        } else {
            this.parseIdentifier(builder, false);
        }
        mark2.done(resultType);
        return true;
    }

    @Override
    @Nullable
    protected IElementType getVariableType(PsiBuilder builder) {
        IElementType type = super.getVariableType(builder);
        return type == SQL_VARIABLE_REFERENCE ? MysqlElementTypes.Extra.MYSQL_USER_VARIABLE_REFERENCE : type;
    }

    @Override
    protected boolean isQualified(SqlReferenceElementType refType) {
        return refType == SqlCompositeElementTypes.SQL_ROLE_REFERENCE || super.isQualified(refType);
    }

    @Override
    public boolean parseFunctionCallTail(PsiBuilder builder, int level) {
        LighterASTNode refMarker = Objects.requireNonNull(builder.getLatestDoneMarker());
        Pair<String, Boolean> name2 = this.extractString(builder, refMarker.getStartOffset(), refMarker.getEndOffset());
        if (!super.parseFunctionCallTail(builder, level)) {
            return false;
        }
        String functionName = ((String)name2.first).trim();
        if ("MATCH".equalsIgnoreCase(functionName)) {
            String against = "AGAINST";
            String text2 = builder.getTokenText();
            if (!against.equalsIgnoreCase(text2)) {
                SqlParserUtil.markTokenAsUnexpectedAndAdvance(builder, against);
            } else {
                PsiBuilder.Marker marker = GeneratedParserUtilBase.enter_section_((PsiBuilder)builder, (int)level, (int)0, (IElementType)SQL_FUNCTION_CALL, (String)"<function call expression>");
                this.parseReferenceExpression(builder, false, SQL_REFERENCE);
                this.parseFunctionCallTail(builder, level);
                GeneratedParserUtilBase.exit_section_((PsiBuilder)builder, (int)level, (PsiBuilder.Marker)marker, null, (boolean)true, (boolean)false, null);
            }
            return true;
        }
        MysqlGeneratedParser.from_first_last(builder, level);
        MysqlGeneratedParser.aggregate_clause(builder, level);
        MysqlGeneratedParser.analytic_clause(builder, level);
        return true;
    }

    @Override
    @Nullable
    public SqlSuggestedInjection getCurrentSqlInjection() {
        return MYSQL_INJECTION;
    }

    @Override
    public boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, MysqlExpressionParsing::parenthesized_values_expr, MysqlDmlParsing::top_query_expression, MysqlParser::parseTopQueryExpressionTail, MysqlExpressionParsing::row_element_list, (b, l) -> MysqlExpressionParsing.root_expr_0(b, l, -1) && MysqlExpressionParsing.row_element_list_separator(b, l) && MysqlExpressionParsing.row_element_list(b, l));
    }

    @Override
    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, MysqlDmlParsing::parenthesized_aliased_join_expression, MysqlDmlParsing::top_query_expression, MysqlParser::parseTopQueryExpressionTail, MysqlDmlParsing::comma_join_expression, MysqlParser::parsePJoinExpressionTail);
    }

    @Override
    protected boolean parseExtraRoots(IElementType root, PsiBuilder builder, int level) {
        return MysqlGeneratedParser.parse_root_(root, builder, level);
    }

    @Override
    public boolean parseForeignKeyRefList(PsiBuilder builder, int level) {
        return MysqlGeneratedParser.table_index_column_list(builder, level);
    }

    private static WhitespacesAndCommentsBinder newControlCommentBinder(final boolean left) {
        return new WhitespacesAndCommentsBinder(){

            public int getEdgePosition(List<? extends IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
                for (int i2 = 0; i2 < tokens.size(); ++i2) {
                    IElementType type = tokens.get(i2);
                    if (left && type == SqlTokens.MYSQL_PRAGMA_BEGIN) {
                        return i2;
                    }
                    if (!left && type == SqlTokens.MYSQL_PRAGMA_END) {
                        return i2 + 1;
                    }
                    if (left || SqlTokens.WS_OR_COMMENTS.contains(type)) continue;
                    return i2;
                }
                return left ? tokens.size() : 0;
            }
        };
    }

    private static boolean parsePJoinExpressionTail(PsiBuilder b, int l) {
        MysqlDmlParsing.join_expression_0(b, l, -1);
        MysqlDmlParsing.left_comma_join_expression(b, l);
        return true;
    }

    public static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        MysqlDmlParsing.query_expression_0(builder, level, -1);
        return MysqlDmlParsing.left_inner_table_op_tail(builder, level);
    }
}

