/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.util.DdlBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.FileViewProviderFactory;
import com.intellij.psi.LanguageFileViewProviders;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.intentions.UtilsKt;
import com.intellij.sql.psi.SqlCodeFragment;
import com.intellij.sql.psi.SqlCodeFragmentImpl;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlOrderByClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.impl.SqlPositionalReference;
import com.intellij.sql.psi.stubs.SqlFileElementType;
import com.intellij.testFramework.ReadOnlyLightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlPsiElementFactory {
    @Nullable
    public static SqlTypeElement createDataTypeFromText(String text2, @NotNull SqlLanguageDialect language, @NotNull PsiElement context) {
        if (language == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(1);
        }
        return SqlPsiElementFactory.createDataTypeFromText(text2, language, context.getProject(), context, false);
    }

    @Nullable
    public static SqlTypeElement createDataTypeFromText(String text2, @NotNull SqlLanguageDialect language, @NotNull Project project, @Nullable PsiElement context, boolean ext) {
        SqlElement element;
        if (language == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(2);
        }
        if (project == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(3);
        }
        if ((element = SqlPsiElementFactory.createElementFromText(text2, language, (IElementType)(ext ? SqlCompositeElementTypes.SQL_TYPE_ELEMENT_EXT : SqlCompositeElementTypes.SQL_TYPE_ELEMENT), project, context)) == null) {
            return null;
        }
        PsiElement child = element.getFirstChild();
        if (child instanceof SqlTypeElement) {
            SqlTypeElement typeElement = (SqlTypeElement)child;
            if (child == element.getLastChild()) {
                return typeElement;
            }
            if (PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)child) instanceof PsiErrorElement) {
                return typeElement;
            }
        }
        return (SqlTypeElement)element;
    }

    @Nullable
    public static SqlExpression createExpressionFromText(String text2, @NotNull SqlLanguageDialect language, @NotNull PsiElement context) {
        if (language == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(4);
        }
        if (context == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(5);
        }
        return (SqlExpression)SqlPsiElementFactory.createElementFromText(text2, language, (IElementType)SqlCompositeElementTypes.SQL_EXPRESSION, context.getProject(), context);
    }

    @Nullable
    public static SqlColumnDefinition createColumnFromText(String text2, @NotNull SqlLanguageDialect language, @NotNull Project project) {
        SqlCreateTableStatement tableStatement;
        if (language == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(6);
        }
        if (project == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(7);
        }
        List columns = (tableStatement = (SqlCreateTableStatement)SqlPsiElementFactory.createStatementFromText("create table foo(" + text2 + ");", language, project, null)) != null ? tableStatement.getDeclaredColumns() : Collections.emptyList();
        return (SqlColumnDefinition)ContainerUtil.getFirstItem((List)columns);
    }

    @Nullable
    public static SqlExpression createTableAliasFromText(String text2, @NotNull SqlLanguageDialect language, @NotNull PsiElement context) {
        SqlQueryExpression queryExpression;
        if (language == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(8);
        }
        if (context == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(9);
        }
        if ((queryExpression = (SqlQueryExpression)SqlPsiElementFactory.createQueryExpressionFromText("select * from " + text2, language, context)) == null) {
            return null;
        }
        SqlTableExpression tableExpression = queryExpression.getTableExpression();
        if (tableExpression == null) {
            return null;
        }
        SqlFromClause fromClause = tableExpression.getFromClause();
        if (fromClause == null) {
            return null;
        }
        return fromClause.getFromExpression();
    }

    @Nullable
    public static SqlExpression createColumnAliasFromText(String text2, @NotNull SqlLanguageDialect language, @NotNull PsiElement context) {
        SqlQueryExpression queryExpression;
        if (language == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(10);
        }
        if (context == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(11);
        }
        if ((queryExpression = (SqlQueryExpression)SqlPsiElementFactory.createQueryExpressionFromText("select " + text2, language, context)) == null) {
            return null;
        }
        SqlSelectClause selectClause = queryExpression.getSelectClause();
        if (selectClause == null) {
            return null;
        }
        return (SqlExpression)ContainerUtil.getFirstItem((List)selectClause.getExpressions());
    }

    @Nullable
    public static SqlExpression createExpressionFromText(String text2, @NotNull SqlLanguageDialect language, @NotNull Project project, @Nullable PsiElement context) {
        if (language == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(12);
        }
        if (project == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(13);
        }
        return (SqlExpression)SqlPsiElementFactory.createElementFromText(text2, language, (IElementType)SqlCompositeElementTypes.SQL_EXPRESSION, project, context);
    }

    @Nullable
    public static SqlReferenceExpression createReferenceFromText(String text2, @NotNull SqlLanguageDialect language, @NotNull SqlReferenceElementType type, @NotNull PsiElement context) {
        if (language == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(14);
        }
        if (type == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(15);
        }
        if (context == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(16);
        }
        return (SqlReferenceExpression)SqlPsiElementFactory.createElementFromText(text2, language, (IElementType)type, context.getProject(), context);
    }

    @Nullable
    public static SqlPositionalReference createPositionalReferenceFromText(int position, @NotNull SqlLanguageDialect language, @NotNull PsiElement context) {
        SqlSelectStatement selectStatement;
        if (language == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(17);
        }
        if (context == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(18);
        }
        SqlQueryExpression queryExpression = (selectStatement = (SqlSelectStatement)SqlPsiElementFactory.createElementFromText("select 1 from dual order by " + position, language, (IElementType)SqlCompositeElementTypes.SQL_STATEMENT, context.getProject(), context)) != null ? selectStatement.getQueryExpression() : null;
        SqlOrderByClause orderBy = (SqlOrderByClause)PsiTreeUtil.getChildOfType((PsiElement)queryExpression, SqlOrderByClause.class);
        return (SqlPositionalReference)PsiTreeUtil.getChildOfType((PsiElement)orderBy, SqlPositionalReference.class);
    }

    @Nullable
    public static SqlTableColumnsList createTableColumnListFromText(String text2, @NotNull SqlLanguageDialect language, @NotNull PsiElement context) {
        if (language == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(19);
        }
        if (context == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(20);
        }
        return (SqlTableColumnsList)SqlPsiElementFactory.createElementFromText(text2, language, (IElementType)SqlCompositeElementTypes.SQL_TABLE_COLUMNS_LIST, context.getProject(), context);
    }

    @Nullable
    public static SqlExpression createQueryExpressionFromText(String text2, @NotNull SqlLanguageDialect language, @NotNull PsiElement context) {
        if (language == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(21);
        }
        if (context == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(22);
        }
        return (SqlExpression)SqlPsiElementFactory.createElementFromText(text2, language, (IElementType)SqlCompositeElementTypes.SQL_QUERY_EXPRESSION, context.getProject(), context);
    }

    @Nullable
    public static SqlQueryExpression createQueryExpressionFromText(String text2, @NotNull SqlLanguageDialect language, @NotNull Project project) {
        if (language == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(23);
        }
        if (project == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(24);
        }
        return (SqlQueryExpression)SqlPsiElementFactory.createElementFromText(text2, language, (IElementType)SqlCompositeElementTypes.SQL_QUERY_EXPRESSION, project, null);
    }

    @Nullable
    public static SqlGroupByClause createGroupByClause(String expressions, @NotNull SqlLanguageDialect language, @NotNull Project project) {
        if (language == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(25);
        }
        if (project == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(26);
        }
        String text2 = new DdlBuilder().configureBuilder(project, language).keyword("group by ").plain(expressions).getStatement();
        return UtilsKt.getGroupByClause(SqlPsiElementFactory.createQueryExpressionFromText("select id from foo " + text2, language, project));
    }

    @Nullable
    public static SqlStatement createStatementFromText(String text2, @NotNull SqlLanguageDialect language, @NotNull Project project, @Nullable PsiElement context) {
        if (language == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(27);
        }
        if (project == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(28);
        }
        return (SqlStatement)SqlPsiElementFactory.createElementFromText(text2, language, (IElementType)SqlCompositeElementTypes.SQL_STATEMENT, project, context);
    }

    @Nullable
    public static SqlIdentifier createIdentifierFromText(@NotNull String text2, @NotNull SqlLanguageDialect language, @NotNull Project project) {
        if (text2 == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(29);
        }
        if (language == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(30);
        }
        if (project == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(31);
        }
        SqlFile fileFromText = (SqlFile)PsiFileFactory.getInstance((Project)project).createFileFromText("a.sql", (Language)language, (CharSequence)("select " + text2));
        return (SqlIdentifier)PsiTreeUtil.findChildOfType((PsiElement)fileFromText, SqlIdentifier.class);
    }

    @NotNull
    public static SqlCodeFragment createFragmentFromText(@NotNull String text2, @NotNull SqlLanguageDialect language, @NotNull IElementType type, @NotNull Project project, @Nullable PsiElement context) {
        if (text2 == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(32);
        }
        if (language == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(33);
        }
        if (type == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(34);
        }
        if (project == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(35);
        }
        ReadOnlyLightVirtualFile file = new ReadOnlyLightVirtualFile("a.sql", (Language)language, (CharSequence)text2);
        SingleRootFileViewProvider viewProvider = new SingleRootFileViewProvider(PsiManager.getInstance((Project)project), (VirtualFile)file, false);
        SqlCodeFragmentImpl fragment = new SqlCodeFragmentImpl((FileViewProvider)viewProvider, language, type, false);
        fragment.setContext(context);
        SqlCodeFragmentImpl sqlCodeFragmentImpl = fragment;
        if (sqlCodeFragmentImpl == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(36);
        }
        return sqlCodeFragmentImpl;
    }

    @Nullable
    static SqlElement createElementFromText(@NotNull String text2, @NotNull SqlLanguageDialect language, @NotNull IElementType type, @NotNull Project project, @Nullable PsiElement context) {
        SqlCodeFragment fragment;
        PsiElement result2;
        if (text2 == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(37);
        }
        if (language == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(38);
        }
        if (type == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(39);
        }
        if (project == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(40);
        }
        if (!((result2 = (fragment = SqlPsiElementFactory.createFragmentFromText(text2, language, type, project, context)).getFirstChild()) instanceof SqlElement)) {
            SqlDialectImplUtilCore.LOG.error(String.valueOf(language) + " [" + text2 + "]: " + String.valueOf(result2));
            return null;
        }
        return (SqlElement)result2;
    }

    @Nullable
    public static PsiComment createCommentFromText(@NotNull String text2, @NotNull SqlLanguageDialect language, @NotNull Project project) {
        if (text2 == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(41);
        }
        if (language == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(42);
        }
        if (project == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(43);
        }
        SqlFile fragment = SqlPsiElementFactory.createROFileFromText((CharSequence)text2, language, project, null);
        return (PsiComment)PsiTreeUtil.getChildOfType((PsiElement)fragment, PsiComment.class);
    }

    @NotNull
    public static SqlFile createROFileFromText(@NotNull CharSequence text2, @NotNull SqlLanguageDialect language, @NotNull Project project, @Nullable Language hostLanguage) {
        if (text2 == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(44);
        }
        if (language == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(45);
        }
        if (project == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(46);
        }
        return (SqlFile)SqlPsiElementFactory.createROFileFromText(text2, (Language)language, project, hostLanguage);
    }

    @NotNull
    public static PsiFile createROFileFromText(@NotNull CharSequence text2, @NotNull Language language, @NotNull Project project, @Nullable Language hostLanguage) {
        if (text2 == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(47);
        }
        if (language == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(48);
        }
        if (project == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(49);
        }
        return SqlPsiElementFactory.createROFileFromText("a.sql", text2, language, project, hostLanguage, false);
    }

    @NotNull
    public static SqlFile createROFileFromText(@NotNull String name2, @NotNull CharSequence text2, @NotNull SqlLanguageDialect language, @NotNull Project project, @Nullable Language hostLanguage) {
        if (name2 == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(50);
        }
        if (text2 == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(51);
        }
        if (language == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(52);
        }
        if (project == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(53);
        }
        return (SqlFile)SqlPsiElementFactory.createROFileFromText(name2, text2, (Language)language, project, hostLanguage, false);
    }

    @NotNull
    public static PsiFile createROFileFromText(@NotNull String name2, @NotNull CharSequence text2, @NotNull Language language, @NotNull Project project, @Nullable Language hostLanguage, boolean isPhysical) {
        if (name2 == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(54);
        }
        if (text2 == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(55);
        }
        if (language == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(56);
        }
        if (project == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(57);
        }
        ReadOnlyLightVirtualFile file = new ReadOnlyLightVirtualFile(name2, language, text2);
        SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)file);
        FileViewProviderFactory factory = (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language);
        Object viewProvider = factory != null ? factory.createFileViewProvider((VirtualFile)file, language, PsiManager.getInstance((Project)project), isPhysical) : new SingleRootFileViewProvider(PsiManager.getInstance((Project)project), (VirtualFile)file, isPhysical);
        PsiFile psi = viewProvider.getPsi(language);
        if (psi == null) {
            throw new AssertionError((Object)("dialect: " + language.getID() + "; text length: " + text2.length()));
        }
        if (hostLanguage != null) {
            psi.putUserData(SqlFileElementType.HOST_LANGUAGE, (Object)hostLanguage);
        }
        PsiFile psiFile = psi;
        if (psiFile == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(58);
        }
        return psiFile;
    }

    public static boolean isROFile(PsiElement element) {
        return element instanceof DummyHolder || element instanceof SqlFile && ((SqlFile)element).getViewProvider().getVirtualFile() instanceof ReadOnlyLightVirtualFile;
    }

    @NotNull
    public static PsiElement createLeafFromText(Project project, @NotNull SqlLanguageDialect language, @NotNull String text2) {
        if (language == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(59);
        }
        if (text2 == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(60);
        }
        SqlFile fileFromText = (SqlFile)PsiFileFactory.getInstance((Project)project).createFileFromText("a.sql", (Language)language, (CharSequence)text2);
        PsiElement psiElement = PsiTreeUtil.getDeepestFirst((PsiElement)fileFromText);
        if (psiElement == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(61);
        }
        return psiElement;
    }

    @NotNull
    public static PsiElement newLine(Project project) {
        PsiElement psiElement = PsiParserFacade.getInstance((Project)project).createWhiteSpaceFromText("\n");
        if (psiElement == null) {
            SqlPsiElementFactory.$$$reportNull$$$0(62);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 36, 58, 61, 62 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 11: 
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 7: 
            case 13: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 35: 
            case 40: 
            case 43: 
            case 46: 
            case 49: 
            case 53: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: 
            case 34: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 29: 
            case 32: 
            case 37: 
            case 41: 
            case 44: 
            case 47: 
            case 51: 
            case 55: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 36: 
            case 58: 
            case 61: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlPsiElementFactory";
                break;
            }
            case 50: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlPsiElementFactory";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createFragmentFromText";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "createROFileFromText";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "createLeafFromText";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "newLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDataTypeFromText";
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionFromText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createColumnFromText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTableAliasFromText";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createColumnAliasFromText";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceFromText";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createPositionalReferenceFromText";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createTableColumnListFromText";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createQueryExpressionFromText";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createGroupByClause";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createStatementFromText";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createIdentifierFromText";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createFragmentFromText";
                break;
            }
            case 36: 
            case 58: 
            case 61: 
            case 62: {
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createElementFromText";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createCommentFromText";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "createROFileFromText";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createLeafFromText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 36, 58, 61, 62 -> new IllegalStateException(string);
        };
    }
}

