/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.xml;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.SerializerXMLWriter;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class Xpp3Dom
implements Serializable {
    private static final long serialVersionUID = 2567894443061173996L;
    protected String name;
    protected String value;
    protected Map<String, String> attributes;
    protected final List<Xpp3Dom> childList;
    protected Xpp3Dom parent;
    protected Object inputLocation;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Xpp3Dom[] EMPTY_DOM_ARRAY = new Xpp3Dom[0];
    public static final String CHILDREN_COMBINATION_MODE_ATTRIBUTE = "combine.children";
    public static final String CHILDREN_COMBINATION_MERGE = "merge";
    public static final String CHILDREN_COMBINATION_APPEND = "append";
    public static final String DEFAULT_CHILDREN_COMBINATION_MODE = "merge";
    public static final String SELF_COMBINATION_MODE_ATTRIBUTE = "combine.self";
    public static final String SELF_COMBINATION_OVERRIDE = "override";
    public static final String SELF_COMBINATION_MERGE = "merge";
    public static final String SELF_COMBINATION_REMOVE = "remove";
    public static final String DEFAULT_SELF_COMBINATION_MODE = "merge";

    public Xpp3Dom(String name2) {
        this.name = name2;
        this.childList = new ArrayList<Xpp3Dom>();
    }

    public Xpp3Dom(String name2, Object inputLocation) {
        this(name2);
        this.inputLocation = inputLocation;
    }

    public Xpp3Dom(Xpp3Dom src) {
        this(src, src.getName());
    }

    public Xpp3Dom(Xpp3Dom src, String name2) {
        String[] attributeNames;
        this.name = name2;
        this.inputLocation = src.inputLocation;
        int childCount = src.getChildCount();
        this.childList = new ArrayList<Xpp3Dom>(childCount);
        this.setValue(src.getValue());
        for (String attributeName : attributeNames = src.getAttributeNames()) {
            this.setAttribute(attributeName, src.getAttribute(attributeName));
        }
        for (int i2 = 0; i2 < childCount; ++i2) {
            this.addChild(new Xpp3Dom(src.getChild(i2)));
        }
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String[] getAttributeNames() {
        if (null == this.attributes || this.attributes.isEmpty()) {
            return EMPTY_STRING_ARRAY;
        }
        return this.attributes.keySet().toArray(EMPTY_STRING_ARRAY);
    }

    public String getAttribute(String name2) {
        return null != this.attributes ? this.attributes.get(name2) : null;
    }

    public boolean removeAttribute(String name2) {
        return StringUtils.isEmpty(name2) ? false : this.attributes.remove(name2) == null;
    }

    public void setAttribute(String name2, String value) {
        if (null == value) {
            throw new NullPointerException("Attribute value can not be null");
        }
        if (null == name2) {
            throw new NullPointerException("Attribute name can not be null");
        }
        if (null == this.attributes) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(name2, value);
    }

    public Xpp3Dom getChild(int i2) {
        return this.childList.get(i2);
    }

    public Xpp3Dom getChild(String name2) {
        if (name2 != null) {
            ListIterator<Xpp3Dom> it = this.childList.listIterator(this.childList.size());
            while (it.hasPrevious()) {
                Xpp3Dom child = it.previous();
                if (!name2.equals(child.getName())) continue;
                return child;
            }
        }
        return null;
    }

    public void addChild(Xpp3Dom xpp3Dom) {
        xpp3Dom.setParent(this);
        this.childList.add(xpp3Dom);
    }

    public Xpp3Dom[] getChildren() {
        if (null == this.childList || this.childList.isEmpty()) {
            return EMPTY_DOM_ARRAY;
        }
        return this.childList.toArray(EMPTY_DOM_ARRAY);
    }

    public Xpp3Dom[] getChildren(String name2) {
        return this.getChildrenAsList(name2).toArray(EMPTY_DOM_ARRAY);
    }

    private List<Xpp3Dom> getChildrenAsList(String name2) {
        if (null == this.childList) {
            return Collections.emptyList();
        }
        ArrayList<Xpp3Dom> children2 = null;
        for (Xpp3Dom configuration : this.childList) {
            if (!name2.equals(configuration.getName())) continue;
            if (children2 == null) {
                children2 = new ArrayList<Xpp3Dom>();
            }
            children2.add(configuration);
        }
        if (children2 != null) {
            return children2;
        }
        return Collections.emptyList();
    }

    public int getChildCount() {
        if (null == this.childList) {
            return 0;
        }
        return this.childList.size();
    }

    public void removeChild(int i2) {
        Xpp3Dom child = this.getChild(i2);
        this.childList.remove(i2);
        child.setParent(null);
    }

    public void removeChild(Xpp3Dom child) {
        this.childList.remove(child);
        child.setParent(null);
    }

    public Xpp3Dom getParent() {
        return this.parent;
    }

    public void setParent(Xpp3Dom parent) {
        this.parent = parent;
    }

    public Object getInputLocation() {
        return this.inputLocation;
    }

    public void setInputLocation(Object inputLocation) {
        this.inputLocation = inputLocation;
    }

    public void writeToSerializer(String namespace, XmlSerializer serializer) throws IOException {
        SerializerXMLWriter xmlWriter = new SerializerXMLWriter(namespace, serializer);
        Xpp3DomWriter.write(xmlWriter, this);
        if (xmlWriter.getExceptions().size() > 0) {
            throw (IOException)xmlWriter.getExceptions().get(0);
        }
    }

    private static void mergeIntoXpp3Dom(Xpp3Dom dominant, Xpp3Dom recessive, Boolean childMergeOverride) {
        block17: {
            if (recessive == null) {
                return;
            }
            boolean mergeSelf = true;
            String selfMergeMode = dominant.getAttribute(SELF_COMBINATION_MODE_ATTRIBUTE);
            if (SELF_COMBINATION_OVERRIDE.equals(selfMergeMode)) {
                mergeSelf = false;
            }
            if (!mergeSelf) break block17;
            if (Xpp3Dom.isEmpty(dominant.getValue()) && !Xpp3Dom.isEmpty(recessive.getValue())) {
                dominant.setValue(recessive.getValue());
                dominant.setInputLocation(recessive.getInputLocation());
            }
            if (recessive.attributes != null) {
                for (String attr : recessive.attributes.keySet()) {
                    if (!Xpp3Dom.isEmpty(dominant.getAttribute(attr))) continue;
                    dominant.setAttribute(attr, recessive.getAttribute(attr));
                }
            }
            if (recessive.getChildCount() > 0) {
                boolean mergeChildren = true;
                if (childMergeOverride != null) {
                    mergeChildren = childMergeOverride;
                } else {
                    String childMergeMode = dominant.getAttribute(CHILDREN_COMBINATION_MODE_ATTRIBUTE);
                    if (CHILDREN_COMBINATION_APPEND.equals(childMergeMode)) {
                        mergeChildren = false;
                    }
                }
                if (!mergeChildren) {
                    Xpp3Dom[] dominantChildren = dominant.getChildren();
                    dominant.childList.clear();
                    int recessiveChildCount = recessive.getChildCount();
                    for (int i2 = 0; i2 < recessiveChildCount; ++i2) {
                        Xpp3Dom recessiveChild = recessive.getChild(i2);
                        dominant.addChild(new Xpp3Dom(recessiveChild));
                    }
                    for (Xpp3Dom aDominantChildren : dominantChildren) {
                        dominant.addChild(aDominantChildren);
                    }
                } else {
                    HashMap<String, Iterator<Xpp3Dom>> commonChildren = new HashMap<String, Iterator<Xpp3Dom>>();
                    for (Xpp3Dom recChild : recessive.childList) {
                        List<Xpp3Dom> dominantChildren;
                        if (commonChildren.containsKey(recChild.name) || (dominantChildren = dominant.getChildrenAsList(recChild.name)).size() <= 0) continue;
                        commonChildren.put(recChild.name, dominantChildren.iterator());
                    }
                    int recessiveChildCount = recessive.getChildCount();
                    for (int i3 = 0; i3 < recessiveChildCount; ++i3) {
                        Xpp3Dom recessiveChild = recessive.getChild(i3);
                        Iterator it = (Iterator)commonChildren.get(recessiveChild.getName());
                        if (it == null) {
                            dominant.addChild(new Xpp3Dom(recessiveChild));
                            continue;
                        }
                        if (!it.hasNext()) continue;
                        Xpp3Dom dominantChild = (Xpp3Dom)it.next();
                        String dominantChildCombinationMode = dominantChild.getAttribute(SELF_COMBINATION_MODE_ATTRIBUTE);
                        if (SELF_COMBINATION_REMOVE.equals(dominantChildCombinationMode)) {
                            dominant.removeChild(dominantChild);
                            continue;
                        }
                        Xpp3Dom.mergeIntoXpp3Dom(dominantChild, recessiveChild, childMergeOverride);
                    }
                }
            }
        }
    }

    public static Xpp3Dom mergeXpp3Dom(Xpp3Dom dominant, Xpp3Dom recessive, Boolean childMergeOverride) {
        if (dominant != null) {
            Xpp3Dom.mergeIntoXpp3Dom(dominant, recessive, childMergeOverride);
            return dominant;
        }
        return recessive;
    }

    public static Xpp3Dom mergeXpp3Dom(Xpp3Dom dominant, Xpp3Dom recessive) {
        if (dominant != null) {
            Xpp3Dom.mergeIntoXpp3Dom(dominant, recessive, null);
            return dominant;
        }
        return recessive;
    }

    public boolean equals(Object obj2) {
        if (obj2 == this) {
            return true;
        }
        if (!(obj2 instanceof Xpp3Dom)) {
            return false;
        }
        Xpp3Dom dom = (Xpp3Dom)obj2;
        if (this.name == null ? dom.name != null : !this.name.equals(dom.name)) {
            return false;
        }
        if (this.value == null ? dom.value != null : !this.value.equals(dom.value)) {
            return false;
        }
        if (this.attributes == null ? dom.attributes != null : !this.attributes.equals(dom.attributes)) {
            return false;
        }
        return !(this.childList == null ? dom.childList != null : !this.childList.equals(dom.childList));
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 37 * result2 + (this.name != null ? this.name.hashCode() : 0);
        result2 = 37 * result2 + (this.value != null ? this.value.hashCode() : 0);
        result2 = 37 * result2 + (this.attributes != null ? this.attributes.hashCode() : 0);
        result2 = 37 * result2 + (this.childList != null ? this.childList.hashCode() : 0);
        return result2;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        PrettyPrintXMLWriter xmlWriter = new PrettyPrintXMLWriter(writer, "UTF-8", null);
        Xpp3DomWriter.write(xmlWriter, this);
        return writer.toString();
    }

    public String toUnescapedString() {
        StringWriter writer = new StringWriter();
        PrettyPrintXMLWriter xmlWriter = new PrettyPrintXMLWriter(writer, "UTF-8", null);
        Xpp3DomWriter.write(xmlWriter, this, false);
        return writer.toString();
    }

    public static boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }
}

