/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.datum.Ellipsoid;
import org.locationtech.proj4j.proj.CylindricalProjection;

public class ExtendedTransverseMercatorProjection
extends CylindricalProjection {
    private static final long serialVersionUID = 1L;
    double Qn;
    double Zb;
    double[] cgb = new double[6];
    double[] cbg = new double[6];
    double[] utg = new double[6];
    double[] gtu = new double[6];
    protected boolean isSouth = false;
    private static final int PROJ_ETMERC_ORDER = 6;
    private static final double HUGE_VAL = Double.POSITIVE_INFINITY;

    public ExtendedTransverseMercatorProjection() {
        this.ellipsoid = Ellipsoid.GRS80;
        this.projectionLatitude = Math.toRadians(0.0);
        this.projectionLongitude = Math.toRadians(0.0);
        this.minLongitude = Math.toRadians(-90.0);
        this.maxLongitude = Math.toRadians(90.0);
        this.initialize();
    }

    public ExtendedTransverseMercatorProjection(Ellipsoid ellipsoid, double lon_0, double lat_0, double k, double x_0, double y_0) {
        this.setEllipsoid(ellipsoid);
        this.projectionLongitude = lon_0;
        this.projectionLatitude = lat_0;
        this.scaleFactor = k;
        this.falseEasting = x_0;
        this.falseNorthing = y_0;
        this.initialize();
    }

    @Override
    public void setSouthernHemisphere(boolean isSouth) {
        this.isSouth = isSouth;
    }

    @Override
    public boolean getSouthernHemisphere() {
        return this.isSouth;
    }

    static double log1py(double x) {
        double y = 1.0 + x;
        double z = y - 1.0;
        return z == 0.0 ? x : x * Math.log(y) / z;
    }

    static double asinhy(double x) {
        double y = Math.abs(x);
        y = ExtendedTransverseMercatorProjection.log1py(y * (1.0 + y / (Math.hypot(1.0, y) + 1.0)));
        return x < 0.0 ? -y : y;
    }

    static double gatg(double[] p1, int len_p1, double B) {
        double h = 0.0;
        double h2 = 0.0;
        double cos_2B = 2.0 * Math.cos(2.0 * B);
        int p1i = len_p1;
        double h1 = p1[--p1i];
        while (p1i > 0) {
            h = -h2 + cos_2B * h1 + p1[--p1i];
            h2 = h1;
            h1 = h;
        }
        return B + h * Math.sin(2.0 * B);
    }

    static double clenS(double[] a, int size, double arg_r, double arg_i, double[] R2, double[] I) {
        int ai = size;
        double sin_arg_r = Math.sin(arg_r);
        double cos_arg_r = Math.cos(arg_r);
        double sinh_arg_i = Math.sinh(arg_i);
        double cosh_arg_i = Math.cosh(arg_i);
        double r = 2.0 * cos_arg_r * cosh_arg_i;
        double i2 = -2.0 * sin_arg_r * sinh_arg_i;
        double hi = 0.0;
        double hr1 = 0.0;
        double hi1 = 0.0;
        double hr = a[--ai];
        while (ai > 0) {
            double hr2 = hr1;
            double hi2 = hi1;
            hr1 = hr;
            hi1 = hi;
            hr = -hr2 + r * hr1 - i2 * hi1 + a[--ai];
            hi = -hi2 + i2 * hr1 + r * hi1;
        }
        r = sin_arg_r * cosh_arg_i;
        i2 = cos_arg_r * sinh_arg_i;
        R2[0] = r * hr - i2 * hi;
        I[0] = r * hi + i2 * hr;
        return R2[0];
    }

    static double clens(double[] a, int size, double arg_r) {
        int ai = size;
        double cos_arg_r = Math.cos(arg_r);
        double r = 2.0 * cos_arg_r;
        double hr1 = 0.0;
        double hr = a[--ai];
        while (ai > 0) {
            double hr2 = hr1;
            hr1 = hr;
            hr = -hr2 + r * hr1 + a[--ai];
        }
        return Math.sin(arg_r) * hr;
    }

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate xy) {
        double[] dCn = new double[1];
        double[] dCe = new double[1];
        double Cn = lpphi;
        double Ce = lplam;
        Cn = ExtendedTransverseMercatorProjection.gatg(this.cbg, 6, Cn);
        double sin_Cn = Math.sin(Cn);
        double cos_Cn = Math.cos(Cn);
        double sin_Ce = Math.sin(Ce);
        double cos_Ce = Math.cos(Ce);
        Cn = Math.atan2(sin_Cn, cos_Ce * cos_Cn);
        Ce = Math.atan2(sin_Ce * cos_Cn, Math.hypot(sin_Cn, cos_Cn * cos_Ce));
        Ce = ExtendedTransverseMercatorProjection.asinhy(Math.tan(Ce));
        Cn += ExtendedTransverseMercatorProjection.clenS(this.gtu, 6, 2.0 * Cn, 2.0 * Ce, dCn, dCe);
        if (Math.abs(Ce += dCe[0]) <= 2.623395162778) {
            xy.y = this.Qn * Cn + this.Zb;
            xy.x = this.Qn * Ce;
        } else {
            xy.y = Double.POSITIVE_INFINITY;
            xy.x = Double.POSITIVE_INFINITY;
        }
        return xy;
    }

    @Override
    public ProjCoordinate projectInverse(double x, double y, ProjCoordinate out) {
        double[] dCn = new double[1];
        double[] dCe = new double[1];
        double Cn = y;
        double Ce = x;
        Cn = (Cn - this.Zb) / this.Qn;
        if (Math.abs(Ce /= this.Qn) <= 2.623395162778) {
            Cn += ExtendedTransverseMercatorProjection.clenS(this.utg, 6, 2.0 * Cn, 2.0 * Ce, dCn, dCe);
            Ce += dCe[0];
            Ce = Math.atan(Math.sinh(Ce));
            double sin_Cn = Math.sin(Cn);
            double cos_Cn = Math.cos(Cn);
            double sin_Ce = Math.sin(Ce);
            double cos_Ce = Math.cos(Ce);
            Ce = Math.atan2(sin_Ce, cos_Ce * cos_Cn);
            Cn = Math.atan2(sin_Cn * cos_Ce, Math.hypot(sin_Ce, cos_Ce * cos_Cn));
            out.y = ExtendedTransverseMercatorProjection.gatg(this.cgb, 6, Cn);
            out.x = Ce;
        }
        return out;
    }

    public void setUTMZone(int zone) {
        this.projectionLongitude = ((double)(--zone) + 0.5) * Math.PI / 30.0 - Math.PI;
        this.projectionLatitude = 0.0;
        this.scaleFactor = 0.9996;
        this.falseEasting = 500000.0;
        this.falseNorthing = this.isSouth ? 1.0E7 : 0.0;
        this.initialize();
    }

    @Override
    public void initialize() {
        double n;
        super.initialize();
        if (this.es <= 0.0) {
            return;
        }
        double f = this.es / (1.0 + Math.sqrt(1.0 - this.es));
        double np = n = f / (2.0 - f);
        this.cgb[0] = n * (2.0 + n * (-0.6666666666666666 + n * (-2.0 + n * (2.577777777777778 + n * (0.5777777777777777 + n * -4.228148148148148)))));
        this.cbg[0] = n * (-2.0 + n * (0.6666666666666666 + n * (1.3333333333333333 + n * (-1.8222222222222222 + n * (0.7111111111111111 + n * 0.9824338624338624)))));
        this.cgb[1] = (np *= n) * (2.3333333333333335 + n * (-1.6 + n * (-5.044444444444444 + n * (8.584126984126984 + n * 2.458201058201058))));
        this.cbg[1] = np * (1.6666666666666667 + n * (-1.0666666666666667 + n * (-1.4444444444444444 + n * (2.86984126984127 + n * -1.6105820105820106))));
        this.cgb[2] = (np *= n) * (3.7333333333333334 + n * (-3.8857142857142857 + n * (-12.019047619047619 + n * 26.03668430335097)));
        this.cbg[2] = np * (-1.7333333333333334 + n * (1.619047619047619 + n * (1.6 + n * -4.474779541446208)));
        this.cgb[3] = (np *= n) * (6.792063492063492 + n * (-9.485714285714286 + n * -28.188500881834216));
        this.cbg[3] = np * (1.9634920634920634 + n * (-2.4 + n * -1.7518165784832451));
        this.cgb[4] = (np *= n) * (13.250793650793652 + n * -23.22238255571589);
        this.cbg[4] = np * (-2.3301587301587303 + n * 3.5144460477793813);
        this.cgb[5] = (np *= n) * 27.011268237934903;
        this.cbg[5] = np * 2.8496841430174764;
        np = n * n;
        this.Qn = this.scaleFactor / (1.0 + n) * (1.0 + np * (0.25 + np * (0.015625 + np / 256.0)));
        this.utg[0] = n * (-0.5 + n * (0.6666666666666666 + n * (-0.3854166666666667 + n * (0.002777777777777778 + n * (0.158203125 + n * -0.15905919312169312)))));
        this.gtu[0] = n * (0.5 + n * (-0.6666666666666666 + n * (0.3125 + n * (0.22777777777777777 + n * (-0.4409722222222222 + n * 0.20875661375661375)))));
        this.utg[1] = np * (-0.020833333333333332 + n * (-0.06666666666666667 + n * (0.3034722222222222 + n * (-0.4380952380952381 + n * 0.2890188388723545))));
        this.gtu[1] = np * (0.2708333333333333 + n * (-0.6 + n * (0.38680555555555557 + n * (0.44603174603174606 + n * -1.0248393063822752))));
        this.utg[2] = (np *= n) * (-0.035416666666666666 + n * (0.04404761904761905 + n * (0.046651785714285715 + n * -0.06138668430335097)));
        this.gtu[2] = np * (0.25416666666666665 + n * (-0.7357142857142858 + n * (0.5603050595238095 + n * 0.9237378747795415)));
        this.utg[3] = (np *= n) * (-0.02726314484126984 + n * (0.021825396825396824 + n * 0.11439745921516754));
        this.gtu[3] = np * (0.30729786706349205 + n * (-1.0654761904761905 + n * 0.9096203979276896));
        this.utg[4] = (np *= n) * (-0.02841641865079365 + n * 0.027268468414301746);
        this.gtu[4] = np * (0.4306671626984127 + n * -1.713007555715889);
        this.utg[5] = (np *= n) * -0.03233083094085698;
        this.gtu[5] = np * 0.6650675310896665;
        double Z = ExtendedTransverseMercatorProjection.gatg(this.cbg, 6, this.projectionLatitude);
        this.Zb = -this.Qn * (Z + ExtendedTransverseMercatorProjection.clens(this.gtu, 6, 2.0 * Z));
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public boolean isRectilinear() {
        return false;
    }

    @Override
    public Object clone() {
        ExtendedTransverseMercatorProjection p2 = (ExtendedTransverseMercatorProjection)super.clone();
        if (this.cgb != null) {
            p2.cgb = (double[])this.cgb.clone();
        }
        if (this.cbg != null) {
            p2.cbg = (double[])this.cbg.clone();
        }
        if (this.utg != null) {
            p2.utg = (double[])this.utg.clone();
        }
        if (this.gtu != null) {
            p2.gtu = (double[])this.gtu.clone();
        }
        return p2;
    }

    @Override
    public String toString() {
        return "Extended Transverse Mercator";
    }
}

