/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import weka.core.Copyright;
import weka.core.Defaults;
import weka.core.Environment;
import weka.core.PluginManager;
import weka.core.Settings;
import weka.core.logging.Logger;
import weka.gui.AbstractPerspective;
import weka.gui.GUIApplication;
import weka.gui.LogPanel;
import weka.gui.Perspective;
import weka.gui.SettingsEditor;
import weka.gui.SimpleCLIPanel;
import weka.gui.WekaTaskMonitor;
import weka.gui.WrapLayout;
import weka.gui.knowledgeflow.MainKFPerspectiveToolBar;
import weka.gui.knowledgeflow.StepVisual;

public class PerspectiveManager
extends JPanel {
    public static final String PERSPECTIVE_INTERFACE = Perspective.class.getCanonicalName();
    public static final Settings.SettingKey VISIBLE_PERSPECTIVES_KEY = new Settings.SettingKey("perspective_manager.visible_perspectives", "Visible perspectives", "");
    private static final long serialVersionUID = -6099806469970666208L;
    protected JToolBar m_perspectiveToolBar = new JToolBar(0);
    protected ButtonGroup m_perspectiveGroup = new ButtonGroup();
    protected GUIApplication m_mainApp;
    protected Map<String, Perspective> m_perspectiveCache = new LinkedHashMap<String, Perspective>();
    protected Map<String, String> m_perspectiveNameLookup = new HashMap<String, String>();
    protected List<Perspective> m_perspectives = new ArrayList<Perspective>();
    protected LinkedHashSet<String> m_visiblePerspectives = new LinkedHashSet();
    protected List<String> m_allowedPerspectiveClassPrefixes = new ArrayList<String>();
    protected List<String> m_disallowedPerspectiveClassPrefixes = new ArrayList<String>();
    protected Perspective m_mainPerspective;
    protected boolean m_configAndPerspectivesVisible;
    protected JPanel m_configAndPerspectivesToolBar;
    protected JMenuBar m_appMenuBar = new JMenuBar();
    protected JMenu m_programMenu;
    protected JMenuItem m_togglePerspectivesToolBar;
    protected LogPanel m_LogPanel = new LogPanel(new WekaTaskMonitor());
    protected boolean m_logVisible;

    public PerspectiveManager(GUIApplication mainApp, String ... perspectivePrefixesToAllow) {
        this(mainApp, perspectivePrefixesToAllow, new String[0]);
    }

    public PerspectiveManager(GUIApplication mainApp, String[] perspectivePrefixesToAllow, String[] perspectivePrefixesToDisallow) {
        if (perspectivePrefixesToAllow != null) {
            for (String prefix : perspectivePrefixesToAllow) {
                this.m_allowedPerspectiveClassPrefixes.add(prefix);
            }
        }
        if (perspectivePrefixesToDisallow != null) {
            for (String prefix : perspectivePrefixesToDisallow) {
                this.m_disallowedPerspectiveClassPrefixes.add(prefix);
            }
        }
        this.m_mainApp = mainApp;
        Settings settings = this.m_mainApp.getApplicationSettings();
        this.m_mainPerspective = this.m_mainApp.getMainPerspective();
        settings.applyDefaults(this.m_mainPerspective.getDefaultSettings());
        this.setLayout(new BorderLayout());
        this.m_configAndPerspectivesToolBar = new JPanel();
        this.m_configAndPerspectivesToolBar.setLayout(new BorderLayout());
        this.m_perspectiveToolBar.setLayout(new WrapLayout(0, 0, 0));
        this.m_configAndPerspectivesToolBar.add((Component)this.m_perspectiveToolBar, "Center");
        this.m_mainPerspective.setMainApplication(this.m_mainApp);
        this.m_perspectives.add(this.m_mainPerspective);
        this.initPerspectivesCache(settings);
        this.initVisiblePerspectives(settings);
        this.add((Component)((JComponent)((Object)this.m_mainPerspective)), "Center");
        this.m_programMenu = this.initProgramMenu();
        String titleM = this.m_mainPerspective.getPerspectiveTitle();
        Icon icon = this.m_mainPerspective.getPerspectiveIcon();
        JToggleButton tBut = new JToggleButton(titleM, icon, true);
        tBut.setToolTipText(this.m_mainPerspective.getPerspectiveTipText());
        tBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component[] comps = PerspectiveManager.this.getComponents();
                Perspective current = null;
                int pIndex = 0;
                for (int i = 0; i < comps.length; ++i) {
                    if (!(comps[i] instanceof Perspective)) continue;
                    pIndex = i;
                    current = (Perspective)((Object)comps[i]);
                    break;
                }
                if (current == PerspectiveManager.this.m_mainPerspective) {
                    return;
                }
                current.setActive(false);
                PerspectiveManager.this.remove(pIndex);
                PerspectiveManager.this.add((Component)((JComponent)((Object)PerspectiveManager.this.m_mainPerspective)), "Center");
                PerspectiveManager.this.m_perspectives.get(0).setActive(true);
                PerspectiveManager.this.m_appMenuBar.removeAll();
                PerspectiveManager.this.m_appMenuBar.add(PerspectiveManager.this.m_programMenu);
                List<JMenu> mainMenus = PerspectiveManager.this.m_perspectives.get(0).getMenus();
                for (JMenu m : mainMenus) {
                    PerspectiveManager.this.m_appMenuBar.add(m);
                }
                PerspectiveManager.this.m_mainApp.revalidate();
            }
        });
        this.m_perspectiveToolBar.add(tBut);
        this.m_perspectiveGroup.add(tBut);
        this.setupUserPerspectives();
        this.initLogPanel(settings);
        if (this.m_mainPerspective.requiresLog()) {
            this.m_mainPerspective.setLog(this.m_LogPanel);
            this.add((Component)this.m_LogPanel, "South");
            this.m_logVisible = true;
        }
        this.m_mainPerspective.setActive(true);
        this.m_mainApp.settingsChanged();
    }

    public void terminate() {
        List<Perspective> perspectives = this.getLoadedPerspectives();
        for (Perspective p : perspectives) {
            if (p instanceof AbstractPerspective) {
                ((AbstractPerspective)p).terminate();
                continue;
            }
            if (!(p instanceof SimpleCLIPanel)) continue;
            ((SimpleCLIPanel)p).terminate();
        }
        if (this.m_mainPerspective instanceof AbstractPerspective) {
            ((AbstractPerspective)this.m_mainPerspective).terminate();
        }
        this.m_LogPanel.terminate();
        this.m_appMenuBar.removeAll();
    }

    protected void setLogSettings(Settings settings) {
        int fontSize = settings.getSetting(this.m_mainApp.getApplicationID(), new Settings.SettingKey(this.m_mainApp.getApplicationID() + ".logMessageFontSize", "", ""), -1);
        this.m_LogPanel.setLoggingFontSize(fontSize);
    }

    protected void initLogPanel(Settings settings) {
        this.setLogSettings(settings);
        String date = new SimpleDateFormat("EEEE, d MMMM yyyy").format(new Date());
        this.m_LogPanel.logMessage("Weka " + this.m_mainApp.getApplicationName());
        this.m_LogPanel.logMessage("(c) " + Copyright.getFromYear() + "-" + Copyright.getToYear() + " " + Copyright.getOwner() + ", " + Copyright.getAddress());
        this.m_LogPanel.logMessage("web: " + Copyright.getURL());
        this.m_LogPanel.logMessage("Started on " + date);
        this.m_LogPanel.statusMessage("Welcome to the Weka " + this.m_mainApp.getApplicationName());
    }

    public void setMainApplicationForAllPerspectives() {
        for (Map.Entry<String, Perspective> e : this.m_perspectiveCache.entrySet()) {
            e.getValue().setMainApplication(this.m_mainApp);
        }
        for (Map.Entry<String, Perspective> e : this.m_perspectiveCache.entrySet()) {
            e.getValue().instantiationComplete();
            if (!e.getValue().requiresLog()) continue;
            e.getValue().setLog(this.m_LogPanel);
        }
        this.m_mainPerspective.setMainApplication(this.m_mainApp);
        this.m_mainPerspective.instantiationComplete();
    }

    protected void notifySettingsChanged() {
        this.m_mainApp.settingsChanged();
        this.m_mainPerspective.settingsChanged();
        for (Map.Entry<String, Perspective> e : this.m_perspectiveCache.entrySet()) {
            e.getValue().settingsChanged();
        }
        this.setLogSettings(this.m_mainApp.getApplicationSettings());
    }

    protected JMenu initProgramMenu() {
        JMenu programMenu = new JMenu();
        this.m_togglePerspectivesToolBar = new JMenuItem("Toggle perspectives toolbar");
        KeyStroke hideKey = KeyStroke.getKeyStroke(80, 512);
        this.m_togglePerspectivesToolBar.setAccelerator(hideKey);
        this.m_togglePerspectivesToolBar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PerspectiveManager.this.m_mainApp.isPerspectivesToolBarVisible()) {
                    PerspectiveManager.this.m_mainApp.hidePerspectivesToolBar();
                } else {
                    PerspectiveManager.this.m_mainApp.showPerspectivesToolBar();
                }
                PerspectiveManager.this.m_mainApp.revalidate();
            }
        });
        programMenu.add(this.m_togglePerspectivesToolBar);
        programMenu.setText("Program");
        JMenuItem exitItem = new JMenuItem("Exit");
        KeyStroke exitKey = KeyStroke.getKeyStroke(81, 128);
        exitItem.setAccelerator(exitKey);
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Frame)((JComponent)((Object)PerspectiveManager.this.m_mainApp)).getTopLevelAncestor()).dispose();
                System.exit(0);
            }
        });
        programMenu.add(exitItem);
        this.m_appMenuBar.add(programMenu);
        List<JMenu> mainMenus = this.m_mainPerspective.getMenus();
        for (JMenu m : mainMenus) {
            this.m_appMenuBar.add(m);
        }
        return programMenu;
    }

    public void setPerspectiveToolbarAlwaysHidden(Settings settings) {
        SelectedPerspectivePreferences userVisiblePerspectives = settings.getSetting(this.m_mainApp.getApplicationID(), VISIBLE_PERSPECTIVES_KEY, new SelectedPerspectivePreferences(), Environment.getSystemWide());
        userVisiblePerspectives.setPerspectivesToolbarAlwaysHidden(true);
        this.setPerspectiveToolBarIsVisible(false);
        this.m_programMenu.remove(this.m_togglePerspectivesToolBar);
    }

    public void addSettingsMenuItemToProgramMenu(final Settings settings) {
        if (settings != null) {
            JMenuItem settingsM = new JMenuItem("Settings...");
            settingsM.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PerspectiveManager.this.popupSettingsDialog(settings);
                }
            });
            this.m_programMenu.insert(settingsM, 0);
        }
        JButton configB = new JButton(new ImageIcon(StepVisual.loadIcon(MainKFPerspectiveToolBar.ICON_PATH + "cog.png").getImage()));
        configB.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 1));
        configB.setToolTipText("Settings");
        this.m_configAndPerspectivesToolBar.add((Component)configB, "West");
        configB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PerspectiveManager.this.popupSettingsDialog(settings);
            }
        });
    }

    protected void popupSettingsDialog(Settings settings) {
        SettingsEditor settingsEditor = new SettingsEditor(settings, this.m_mainApp);
        try {
            int result = SettingsEditor.showApplicationSettingsEditor(settings, this.m_mainApp);
            if (result == 0) {
                this.initVisiblePerspectives(settings);
                this.setupUserPerspectives();
                this.notifySettingsChanged();
            }
        }
        catch (IOException ex) {
            this.m_mainApp.showErrorDialog(ex);
        }
    }

    protected void setupUserPerspectives() {
        for (int i = this.m_perspectiveToolBar.getComponentCount() - 1; i > 0; --i) {
            this.m_perspectiveToolBar.remove(i);
            this.m_perspectives.remove(i);
        }
        int index = 1;
        for (String c : this.m_visiblePerspectives) {
            String impl = this.m_perspectiveNameLookup.get(c);
            Perspective toAdd = this.m_perspectiveCache.get(impl);
            if (!(toAdd instanceof JComponent)) continue;
            toAdd.setLoaded(true);
            this.m_perspectives.add(toAdd);
            String titleM = toAdd.getPerspectiveTitle();
            Icon icon = toAdd.getPerspectiveIcon();
            JToggleButton tBut = null;
            tBut = icon != null ? new JToggleButton(titleM, icon, false) : new JToggleButton(titleM, false);
            tBut.setToolTipText(toAdd.getPerspectiveTipText());
            final int theIndex = index++;
            tBut.setEnabled(toAdd.okToBeActive());
            tBut.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PerspectiveManager.this.setActivePerspective(theIndex);
                }
            });
            this.m_perspectiveToolBar.add(tBut);
            this.m_perspectiveGroup.add(tBut);
        }
        Component[] comps = this.getComponents();
        Perspective current = null;
        int pIndex = 0;
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof Perspective)) continue;
            pIndex = i;
            current = (Perspective)((Object)comps[i]);
            break;
        }
        if (current != this.m_mainPerspective) {
            this.setActivePerspective(0);
        }
        this.m_mainApp.revalidate();
    }

    public void setActivePerspective(int theIndex) {
        if (theIndex < 0 || theIndex > this.m_perspectives.size() - 1) {
            return;
        }
        Component[] comps = this.getComponents();
        Perspective current = null;
        int pIndex = 0;
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof Perspective)) continue;
            pIndex = i;
            current = (Perspective)((Object)comps[i]);
            break;
        }
        current.setActive(false);
        this.remove(pIndex);
        this.add((Component)((JComponent)((Object)this.m_perspectives.get(theIndex))), "Center");
        this.m_perspectives.get(theIndex).setActive(true);
        ((JToggleButton)this.m_perspectiveToolBar.getComponent(theIndex)).setSelected(true);
        if (this.m_perspectives.get(theIndex).requiresLog() && !this.m_logVisible) {
            this.add((Component)this.m_LogPanel, "South");
            this.m_logVisible = true;
        } else if (!this.m_perspectives.get(theIndex).requiresLog() && this.m_logVisible) {
            this.remove(this.m_LogPanel);
            this.m_logVisible = false;
        }
        JMenu programMenu = this.m_appMenuBar.getMenu(0);
        this.m_appMenuBar.removeAll();
        this.m_appMenuBar.add(programMenu);
        List<JMenu> mainMenus = this.m_perspectives.get(theIndex).getMenus();
        if (mainMenus != null) {
            for (JMenu m : mainMenus) {
                this.m_appMenuBar.add(m);
            }
        }
        this.m_mainApp.revalidate();
    }

    public void setActivePerspective(String perspectiveID) {
        int index = -1;
        for (int i = 0; i < this.m_perspectives.size(); ++i) {
            if (!this.m_perspectives.get(i).getPerspectiveID().equals(perspectiveID)) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            this.setActivePerspective(index);
        }
    }

    public List<Perspective> getLoadedPerspectives() {
        ArrayList<Perspective> available = new ArrayList<Perspective>();
        for (Map.Entry<String, Perspective> e : this.m_perspectiveCache.entrySet()) {
            available.add(e.getValue());
        }
        return available;
    }

    public List<Perspective> getVisiblePerspectives() {
        ArrayList<Perspective> visible = new ArrayList<Perspective>();
        for (String pName : this.m_visiblePerspectives) {
            String impl = this.m_perspectiveNameLookup.get(pName);
            Perspective p = this.m_perspectiveCache.get(impl);
            if (p == null) continue;
            visible.add(p);
        }
        return visible;
    }

    protected void initPerspectivesCache(Settings settings) {
        Set<String> pluginPerspectiveImpls = PluginManager.getPluginNamesOfType(PERSPECTIVE_INTERFACE);
        if (pluginPerspectiveImpls != null) {
            for (String impl : pluginPerspectiveImpls) {
                if (impl.equals(this.m_mainPerspective.getClass().getCanonicalName())) continue;
                try {
                    Object perspective = PluginManager.getPluginInstance(PERSPECTIVE_INTERFACE, impl);
                    if (!(perspective instanceof Perspective)) {
                        Logger.log(Logger.Level.WARNING, "[PerspectiveManager] " + impl + " is not an instance" + PERSPECTIVE_INTERFACE + ". Skipping...");
                    }
                    boolean ok = true;
                    if (this.m_allowedPerspectiveClassPrefixes.size() > 0) {
                        ok = false;
                        for (String prefix : this.m_allowedPerspectiveClassPrefixes) {
                            if (!impl.startsWith(prefix)) continue;
                            ok = true;
                            break;
                        }
                    }
                    if (this.m_disallowedPerspectiveClassPrefixes.size() > 0) {
                        for (String prefix : this.m_disallowedPerspectiveClassPrefixes) {
                            if (!impl.startsWith(prefix)) continue;
                            ok = false;
                            break;
                        }
                    }
                    if (impl.equals(this.m_mainPerspective.getClass().getCanonicalName())) {
                        ok = false;
                    }
                    if (!ok) continue;
                    this.m_perspectiveCache.put(impl, (Perspective)perspective);
                    String perspectiveTitle = ((Perspective)perspective).getPerspectiveTitle();
                    this.m_perspectiveNameLookup.put(perspectiveTitle, impl);
                    settings.applyDefaults(((Perspective)perspective).getDefaultSettings());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.m_mainApp.showErrorDialog(e);
                }
            }
        }
    }

    protected void initVisiblePerspectives(Settings settings) {
        this.m_visiblePerspectives.clear();
        if (this.m_perspectiveCache.size() > 0) {
            LinkedHashMap<Settings.SettingKey, Object> defaults = new LinkedHashMap<Settings.SettingKey, Object>();
            SelectedPerspectivePreferences defaultEmpty = new SelectedPerspectivePreferences();
            defaults.put(VISIBLE_PERSPECTIVES_KEY, defaultEmpty);
            Defaults mainAppPerspectiveDefaults = new Defaults(this.m_mainApp.getApplicationID(), defaults);
            settings.applyDefaults(mainAppPerspectiveDefaults);
            SelectedPerspectivePreferences userVisiblePerspectives = settings.getSetting(this.m_mainApp.getApplicationID(), VISIBLE_PERSPECTIVES_KEY, new SelectedPerspectivePreferences(), Environment.getSystemWide());
            if (userVisiblePerspectives == defaultEmpty) {
                for (Map.Entry entry : this.m_perspectiveCache.entrySet()) {
                    userVisiblePerspectives.getUserVisiblePerspectives().add(((Perspective)entry.getValue()).getPerspectiveTitle());
                }
                userVisiblePerspectives.setPerspectivesToolbarVisibleOnStartup(true);
            }
            for (String string : userVisiblePerspectives.getUserVisiblePerspectives()) {
                this.m_visiblePerspectives.add(string);
            }
        }
    }

    public JPanel getPerspectiveToolBar() {
        return this.m_configAndPerspectivesToolBar;
    }

    public void disableAllPerspectiveTabs() {
        for (int i = 0; i < this.m_perspectiveToolBar.getComponentCount(); ++i) {
            this.m_perspectiveToolBar.getComponent(i).setEnabled(false);
        }
    }

    public void enableAllPerspectiveTabs() {
        for (int i = 0; i < this.m_perspectiveToolBar.getComponentCount(); ++i) {
            this.m_perspectiveToolBar.getComponent(i).setEnabled(true);
        }
    }

    public void setEnablePerspectiveTabs(List<String> perspectiveIDs, boolean enabled) {
        for (int i = 0; i < this.m_perspectives.size(); ++i) {
            Perspective p = this.m_perspectives.get(i);
            if (!perspectiveIDs.contains(p.getPerspectiveID())) continue;
            this.m_perspectiveToolBar.getComponent(i).setEnabled(enabled);
        }
    }

    public void setEnablePerspectiveTab(String perspectiveID, boolean enabled) {
        for (int i = 0; i < this.m_perspectives.size(); ++i) {
            Perspective p = this.m_perspectives.get(i);
            if (!p.getPerspectiveID().equals(perspectiveID) || !p.okToBeActive()) continue;
            this.m_perspectiveToolBar.getComponent(i).setEnabled(enabled);
        }
    }

    public boolean perspectiveToolBarIsVisible() {
        return this.m_configAndPerspectivesVisible;
    }

    public void setPerspectiveToolBarIsVisible(boolean v) {
        this.m_configAndPerspectivesVisible = v;
    }

    public Perspective getMainPerspective() {
        return this.m_mainPerspective;
    }

    public Perspective getPerspective(String ID2) {
        Perspective perspective = null;
        for (Perspective p : this.m_perspectives) {
            if (!p.getPerspectiveID().equals(ID2)) continue;
            perspective = p;
            break;
        }
        return perspective;
    }

    public void showMenuBar(JFrame topLevelAncestor) {
        topLevelAncestor.setJMenuBar(this.m_appMenuBar);
    }

    public boolean userRequestedPerspectiveToolbarVisibleOnStartup(Settings settings) {
        SelectedPerspectivePreferences perspectivePreferences = settings.getSetting(this.m_mainApp.getApplicationID(), VISIBLE_PERSPECTIVES_KEY, new SelectedPerspectivePreferences(), Environment.getSystemWide());
        return perspectivePreferences.getPerspectivesToolbarVisibleOnStartup();
    }

    public static class SelectedPerspectivePreferences
    implements Serializable {
        private static final long serialVersionUID = -2665480123235382483L;
        protected LinkedList<String> m_userVisiblePerspectives = new LinkedList();
        protected boolean m_perspectivesToolbarVisibleOnStartup;
        protected boolean m_perspectivesToolbarAlwaysHidden;

        public void setUserVisiblePerspectives(LinkedList<String> userVisiblePerspectives) {
            this.m_userVisiblePerspectives = userVisiblePerspectives;
        }

        public LinkedList<String> getUserVisiblePerspectives() {
            return this.m_userVisiblePerspectives;
        }

        public void setPerspectivesToolbarVisibleOnStartup(boolean v) {
            this.m_perspectivesToolbarVisibleOnStartup = v;
        }

        public boolean getPerspectivesToolbarVisibleOnStartup() {
            return this.m_perspectivesToolbarVisibleOnStartup;
        }

        public void setPerspectivesToolbarAlwaysHidden(boolean h) {
            this.m_perspectivesToolbarAlwaysHidden = h;
        }

        public boolean getPerspectivesToolbarAlwaysHidden() {
            return this.m_perspectivesToolbarAlwaysHidden;
        }
    }
}

