#ifndef ATL_ztGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,120,215,262,310,357,405,500,595,690,786,833,881,928,976,1071,1167,1357,1548,1929,2310,2691,3072,3119,3167,3214,3262,3357,3453,3643,3834,4215,4596,5358,6120
 * N : 25,120,215,262,310,357,405,500,595,690,786,833,881,928,976,1071,1167,1357,1548,1929,2310,2691,3072,3119,3167,3214,3262,3357,3453,3643,3834,4215,4596,5358,6120
 * NB : 1,1,8,28,32,36,43,44,45,45,51,54,55,56,59,60,63,63,67,67,79,82,83,84,85,85,86,86,87,87,91,94,95,96,99
 */
#define ATL_ztGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 167) (nb_) = 1; \
   else if ((n_) < 238) (nb_) = 8; \
   else if ((n_) < 286) (nb_) = 28; \
   else if ((n_) < 333) (nb_) = 32; \
   else if ((n_) < 381) (nb_) = 36; \
   else if ((n_) < 452) (nb_) = 43; \
   else if ((n_) < 547) (nb_) = 44; \
   else if ((n_) < 738) (nb_) = 45; \
   else if ((n_) < 809) (nb_) = 51; \
   else if ((n_) < 857) (nb_) = 54; \
   else if ((n_) < 904) (nb_) = 55; \
   else if ((n_) < 952) (nb_) = 56; \
   else if ((n_) < 1023) (nb_) = 59; \
   else if ((n_) < 1119) (nb_) = 60; \
   else if ((n_) < 1452) (nb_) = 63; \
   else if ((n_) < 2119) (nb_) = 67; \
   else if ((n_) < 2500) (nb_) = 79; \
   else if ((n_) < 2881) (nb_) = 82; \
   else if ((n_) < 3095) (nb_) = 83; \
   else if ((n_) < 3143) (nb_) = 84; \
   else if ((n_) < 3238) (nb_) = 85; \
   else if ((n_) < 3405) (nb_) = 86; \
   else if ((n_) < 3738) (nb_) = 87; \
   else if ((n_) < 4024) (nb_) = 91; \
   else if ((n_) < 4405) (nb_) = 94; \
   else if ((n_) < 4977) (nb_) = 95; \
   else if ((n_) < 5739) (nb_) = 96; \
   else (nb_) = 99; \
}


#endif    /* end ifndef ATL_ztGetNB_geqrf */
