#ifndef ATL_ctGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,87,149,211,273,521,583,645,707,769,1018,1266,1515,1639,1763,1887,2012,2509,3006,3254,3503,4000
 * N : 25,87,149,211,273,521,583,645,707,769,1018,1266,1515,1639,1763,1887,2012,2509,3006,3254,3503,4000
 * NB : 8,24,40,48,48,48,52,52,52,56,56,56,80,84,88,88,96,112,112,124,168,168
 */
#define ATL_ctGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 56) (nb_) = 8; \
   else if ((n_) < 118) (nb_) = 24; \
   else if ((n_) < 180) (nb_) = 40; \
   else if ((n_) < 552) (nb_) = 48; \
   else if ((n_) < 738) (nb_) = 52; \
   else if ((n_) < 1390) (nb_) = 56; \
   else if ((n_) < 1577) (nb_) = 80; \
   else if ((n_) < 1701) (nb_) = 84; \
   else if ((n_) < 1949) (nb_) = 88; \
   else if ((n_) < 2260) (nb_) = 96; \
   else if ((n_) < 3130) (nb_) = 112; \
   else if ((n_) < 3378) (nb_) = 124; \
   else (nb_) = 168; \
}


#endif    /* end ifndef ATL_ctGetNB_geqrf */
