/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.ArrayList;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class IntermediateClientRequestValue
implements Serializable {
    private static final byte TYPE_DOWNSTREAM_REQUEST = -96;
    private static final byte TYPE_DOWNSTREAM_CLIENT_ADDRESS = -127;
    private static final byte TYPE_DOWNSTREAM_CLIENT_SECURE = -126;
    private static final byte TYPE_CLIENT_IDENTITY = -125;
    private static final byte TYPE_CLIENT_NAME = -124;
    private static final byte TYPE_CLIENT_SESSION_ID = -123;
    private static final byte TYPE_CLIENT_REQUEST_ID = -122;
    private static final long serialVersionUID = -794887520013838259L;
    @Nullable
    private final Boolean downstreamClientSecure;
    @Nullable
    private final IntermediateClientRequestValue downstreamRequest;
    @Nullable
    private final String clientIdentity;
    @Nullable
    private final String downstreamClientAddress;
    @Nullable
    private final String clientName;
    @Nullable
    private final String clientRequestID;
    @Nullable
    private final String clientSessionID;

    public IntermediateClientRequestValue(@Nullable IntermediateClientRequestValue downstreamRequest, @Nullable String downstreamClientAddress, @Nullable Boolean downstreamClientSecure, @Nullable String clientIdentity, @Nullable String clientName, @Nullable String clientSessionID, @Nullable String clientRequestID) {
        this.downstreamRequest = downstreamRequest;
        this.downstreamClientAddress = downstreamClientAddress;
        this.downstreamClientSecure = downstreamClientSecure;
        this.clientIdentity = clientIdentity;
        this.clientName = clientName;
        this.clientSessionID = clientSessionID;
        this.clientRequestID = clientRequestID;
    }

    @Nullable
    public IntermediateClientRequestValue getDownstreamRequest() {
        return this.downstreamRequest;
    }

    @Nullable
    public String getClientIdentity() {
        return this.clientIdentity;
    }

    @Nullable
    public String getDownstreamClientAddress() {
        return this.downstreamClientAddress;
    }

    @Nullable
    public Boolean downstreamClientSecure() {
        return this.downstreamClientSecure;
    }

    @Nullable
    public String getClientName() {
        return this.clientName;
    }

    @Nullable
    public String getClientSessionID() {
        return this.clientSessionID;
    }

    @Nullable
    public String getClientRequestID() {
        return this.clientRequestID;
    }

    @NotNull
    public ASN1Sequence encode() {
        return this.encode((byte)48);
    }

    @NotNull
    private ASN1Sequence encode(byte type) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(7);
        if (this.downstreamRequest != null) {
            elements.add(this.downstreamRequest.encode((byte)-96));
        }
        if (this.downstreamClientAddress != null) {
            elements.add(new ASN1OctetString(-127, this.downstreamClientAddress));
        }
        if (this.downstreamClientSecure != null) {
            elements.add(new ASN1Boolean(-126, this.downstreamClientSecure));
        }
        if (this.clientIdentity != null) {
            elements.add(new ASN1OctetString(-125, this.clientIdentity));
        }
        if (this.clientName != null) {
            elements.add(new ASN1OctetString(-124, this.clientName));
        }
        if (this.clientSessionID != null) {
            elements.add(new ASN1OctetString(-123, this.clientSessionID));
        }
        if (this.clientRequestID != null) {
            elements.add(new ASN1OctetString(-122, this.clientRequestID));
        }
        return new ASN1Sequence(type, elements);
    }

    @NotNull
    public static IntermediateClientRequestValue decode(@NotNull ASN1Sequence sequence) throws LDAPException {
        Boolean downstreamClientSecure = null;
        IntermediateClientRequestValue downstreamRequest = null;
        String clientIdentity = null;
        String downstreamClientAddress = null;
        String clientName = null;
        String clientRequestID = null;
        String clientSessionID = null;
        block14: for (ASN1Element element : sequence.elements()) {
            switch (element.getType()) {
                case -96: {
                    try {
                        ASN1Sequence s = ASN1Sequence.decodeAsSequence(element);
                        downstreamRequest = IntermediateClientRequestValue.decode(s);
                        continue block14;
                    }
                    catch (LDAPException le) {
                        Debug.debugException(le);
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ICREQ_CANNOT_DECODE_DOWNSTREAM_REQUEST.get(le.getMessage()), le);
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ICREQ_CANNOT_DECODE_DOWNSTREAM_REQUEST.get(StaticUtils.getExceptionMessage(e)), e);
                    }
                }
                case -127: {
                    downstreamClientAddress = ASN1OctetString.decodeAsOctetString(element).stringValue();
                    continue block14;
                }
                case -126: {
                    try {
                        downstreamClientSecure = ASN1Boolean.decodeAsBoolean(element).booleanValue();
                        continue block14;
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ICREQ_CANNOT_DECODE_DOWNSTREAM_SECURE.get(StaticUtils.getExceptionMessage(e)), e);
                    }
                }
                case -125: {
                    clientIdentity = ASN1OctetString.decodeAsOctetString(element).stringValue();
                    continue block14;
                }
                case -124: {
                    clientName = ASN1OctetString.decodeAsOctetString(element).stringValue();
                    continue block14;
                }
                case -123: {
                    clientSessionID = ASN1OctetString.decodeAsOctetString(element).stringValue();
                    continue block14;
                }
                case -122: {
                    clientRequestID = ASN1OctetString.decodeAsOctetString(element).stringValue();
                    continue block14;
                }
                default: {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ICREQ_INVALID_ELEMENT_TYPE.get(StaticUtils.toHex(element.getType())));
                }
            }
        }
        return new IntermediateClientRequestValue(downstreamRequest, downstreamClientAddress, downstreamClientSecure, clientIdentity, clientName, clientSessionID, clientRequestID);
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.downstreamRequest != null) {
            hashCode += this.downstreamRequest.hashCode();
        }
        if (this.downstreamClientAddress != null) {
            hashCode += this.downstreamClientAddress.hashCode();
        }
        if (this.downstreamClientSecure != null) {
            hashCode += this.downstreamClientSecure.hashCode();
        }
        if (this.clientIdentity != null) {
            hashCode += this.clientIdentity.hashCode();
        }
        if (this.clientName != null) {
            hashCode += this.clientName.hashCode();
        }
        if (this.clientSessionID != null) {
            hashCode += this.clientSessionID.hashCode();
        }
        if (this.clientRequestID != null) {
            hashCode += this.clientRequestID.hashCode();
        }
        return hashCode;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof IntermediateClientRequestValue)) {
            return false;
        }
        IntermediateClientRequestValue v = (IntermediateClientRequestValue)o;
        if (this.downstreamRequest == null ? v.downstreamRequest != null : !this.downstreamRequest.equals(v.downstreamRequest)) {
            return false;
        }
        if (this.downstreamClientAddress == null ? v.downstreamClientAddress != null : !this.downstreamClientAddress.equals(v.downstreamClientAddress)) {
            return false;
        }
        if (this.downstreamClientSecure == null ? v.downstreamClientSecure != null : !this.downstreamClientSecure.equals(v.downstreamClientSecure)) {
            return false;
        }
        if (this.clientIdentity == null ? v.clientIdentity != null : !this.clientIdentity.equals(v.clientIdentity)) {
            return false;
        }
        if (this.clientName == null ? v.clientName != null : !this.clientName.equals(v.clientName)) {
            return false;
        }
        if (this.clientSessionID == null ? v.clientSessionID != null : !this.clientSessionID.equals(v.clientSessionID)) {
            return false;
        }
        return !(this.clientRequestID == null ? v.clientRequestID != null : !this.clientRequestID.equals(v.clientRequestID));
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("IntermediateClientRequestValue(");
        boolean added = false;
        if (this.downstreamRequest != null) {
            buffer.append("downstreamRequest=");
            this.downstreamRequest.toString(buffer);
            added = true;
        }
        if (this.clientIdentity != null) {
            if (added) {
                buffer.append(", ");
            } else {
                added = true;
            }
            buffer.append("clientIdentity='");
            buffer.append(this.clientIdentity);
            buffer.append('\'');
        }
        if (this.downstreamClientAddress != null) {
            if (added) {
                buffer.append(", ");
            } else {
                added = true;
            }
            buffer.append("downstreamClientAddress='");
            buffer.append(this.downstreamClientAddress);
            buffer.append('\'');
        }
        if (this.downstreamClientSecure != null) {
            if (added) {
                buffer.append(", ");
            } else {
                added = true;
            }
            buffer.append("downstreamClientSecure='");
            buffer.append(this.downstreamClientSecure);
            buffer.append('\'');
        }
        if (this.clientName != null) {
            if (added) {
                buffer.append(", ");
            } else {
                added = true;
            }
            buffer.append("clientName='");
            buffer.append(this.clientName);
            buffer.append('\'');
        }
        if (this.clientSessionID != null) {
            if (added) {
                buffer.append(", ");
            } else {
                added = true;
            }
            buffer.append("clientSessionID='");
            buffer.append(this.clientSessionID);
            buffer.append('\'');
        }
        if (this.clientRequestID != null) {
            if (added) {
                buffer.append(", ");
            } else {
                added = true;
            }
            buffer.append("clientRequestID='");
            buffer.append(this.clientRequestID);
            buffer.append('\'');
        }
        buffer.append(')');
    }
}

