
#ifndef GPgamepick
#define GPgamepick

#include <gtk/gtk.h>

/* configure these to your own systems */
/* or overide them with -c <conf file> */
static const gchar default_cmd_dir[] = ".";
static const gchar default_icon_dir[] = ".";
static const gchar default_gamepick_global_conf[] = "/etc/gamepick.conf";
static const gchar default_gamepick_home_conf[] = ".gamepick.conf";

enum browse_targets {bt_cmd, bt_icon};

typedef struct
{
  GString *tab_name;
  GtkWidget *box_widget;
  GList *game_list;
  gint game_count;
} tab_struct;

typedef struct gamepick_info gamepick_info;

typedef struct
{
  gamepick_info *info;
  GString *name, *cmd, *icon, *start_dir;
  gboolean syncvblank, cmd_found;
  gint fsaa, aitf, tab_pos, x_pos, y_pos;
  GtkWidget *icon_image, *button;
  
} game_struct;

struct gamepick_info
{
  GtkWidget *main_window, *tabs;
  GtkWidget *new_game_dialog, *new_game_table;
  GtkWidget *fsaa_combo, *aitf_combo, *vsync_check, *play_table, *play_button;
  GtkWidget *options_dialog, *options_table;
  GtkWidget *edits_dialog, *edits_table;
  GtkWidget *name_field, *start_field, *cmd_field, *icon_field;
  GtkWidget *edits_icon, *edits_fsaa_combo, *edits_aitf_combo, *edits_vsync;
  GtkWidget *browse_widget;
  GtkWidget *auto_dialog, *auto_tabs, *auto_table;
  gint auto_games_total, auto_games_count, auto_games_page;
  GtkWidget *new_tab_dialog, *new_tab_table, *new_tab_field;

  gboolean bad_conf, debug_window;
  GString *warnings;
  GList *tab_list;
  gint tab_count;
  gint options_enabled, conf_fallback_enabled;
  game_struct *current_game, *current_source, *current_edit;
  gint browse_target;

  GList *auto_games_list, *icon_dir_list, *auto_find_list;
 
  gint argc;
  gchar **argv;
  GString *conf_file, *home_conf, *cmd_dir, *icon_dir, *pwd;

  gint button_spacing, icon_spacing, x_icons, y_icons, max_line;
};

#endif
