
#include <string.h>
#include <stdlib.h>

#include <gtk/gtk.h>
#include <gdk/gdk.h>

#include "gamepick.h"
#include "add_games.h"
#include "edits.h"
#include "auto_games.h"
#include "save_lists.h"
#include "icons.h"
#include "gp_icon.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


void options_edit (GtkWidget *widget, gamepick_info *info)
{
  gtk_widget_destroy (info->options_dialog);
  edits_run (info, info->current_game);
}


void options_new (GtkWidget *widget, gamepick_info *info)
{
  gtk_widget_destroy (info->options_dialog);
  edits_run (info, NULL);
}


void options_auto_games (GtkWidget *widget, gamepick_info *info)
{
  gtk_widget_destroy (info->options_dialog);
  auto_games_run (info);
}


void delete_stuff (GtkWidget *widget, gamepick_info *info)
{
  GString *message;
  
  gtk_widget_destroy (info->options_dialog);
  message = g_string_new (NULL);
  g_string_sprintf (message,
    "The delete features are not coded, but you may\n"
    "edit the text configuration file.\n"
    "Gamepick is currently using this location:\n\n%s\n\n"
    "(Path may be relative to current working directory.)",
    info->conf_file->str);
  show_notice (message->str, info->main_window);
}


void options_debug (GtkWidget *widget, gamepick_info *info)
{
  GString *message;
  
  info->debug_window = !info->debug_window; 
  save_config (info);
  if (info->debug_window)
    message = g_string_new ("Debug window available on next launch.");
  else
    message = g_string_new ("No debug window on next launch.");
  show_notice (message->str, info->options_dialog);
}


void about (GtkWidget *widget, gamepick_info *info)
{
  GtkWidget *dialog, *table, *icon, *label, *field, *button;
  GdkPixbuf *pix_buf;
  GString *string;

  gtk_widget_destroy (info->options_dialog);
  
  dialog = gtk_dialog_new_with_buttons ("About",
    GTK_WINDOW (info->main_window), GTK_DIALOG_NO_SEPARATOR, NULL);
  gtk_window_set_transient_for (GTK_WINDOW (dialog),
    GTK_WINDOW (info->main_window));
  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
  gtk_container_set_border_width (GTK_CONTAINER (dialog),
    info->button_spacing);
  table = gtk_table_new (6, 5, FALSE);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), table);
  gtk_table_set_row_spacings (GTK_TABLE (table), info->button_spacing);
  gtk_table_set_col_spacings (GTK_TABLE (table), info->button_spacing);

  pix_buf = gdk_pixbuf_new_from_xpm_data (gp_icon());
  if (pix_buf)
  {
    icon = gtk_image_new_from_pixbuf (pix_buf);
    if (icon)
    {
      gtk_table_attach (GTK_TABLE (table), icon,
       0, 1, 2, 3, GTK_SHRINK, GTK_SHRINK, info->icon_spacing, 0);
      gtk_widget_show (icon);
    }
  }

  string = g_string_new (NULL);
  g_string_sprintf (string, "%s %s\n\n"
    "Distributed under the GPL this program is\n"
    "copyright (c) 2005, 2006 Graeme Sheppard.\n\n"
    "Visit the homepage for updates and 3rd\n"
    "party icons:\n", PACKAGE, VERSION);
  
  label = gtk_label_new (string->str);
  gtk_table_attach_defaults (GTK_TABLE (table), label, 2, 3, 2, 3);
  gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
  gtk_widget_show (label);

  field = gtk_entry_new();
  gtk_entry_set_text (GTK_ENTRY (field), "http://www.rillion.net/gamepick/");
  gtk_entry_set_editable (GTK_ENTRY (field), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), field, 2, 3, 3, 4);
  gtk_widget_show (field);

  button = gtk_button_new_with_label ("Dismiss");
  g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (close_dialog),
    dialog);
  gtk_table_attach (GTK_TABLE (table), button, 4, 5, 5, 6,
    GTK_SHRINK, GTK_SHRINK, 0, 0);
  gtk_widget_show (button);

  gtk_widget_show_all (dialog);
}


void accept_new_tab (GtkWidget *widget, gamepick_info *info)
{
  const gchar *text;
  
  text = gtk_entry_get_text (GTK_ENTRY (info->new_tab_field));
  if ((text == NULL) || (strcmp (text, "") == 0))
    return;
  add_tab (info, text);
  gtk_widget_destroy (info->new_tab_dialog);
  gtk_notebook_set_current_page (GTK_NOTEBOOK (info->tabs), -1);
  save_config (info);
}


void new_tab (GtkWidget *widget, gamepick_info *info)
{
  GtkWidget *label, *button;

  gtk_widget_destroy (info->options_dialog);
  info->new_tab_dialog = gtk_dialog_new_with_buttons ("New Tab",
    GTK_WINDOW (info->main_window), GTK_DIALOG_NO_SEPARATOR, NULL);
  gtk_window_set_transient_for (GTK_WINDOW (info->new_tab_dialog),
    GTK_WINDOW (info->main_window));
  gtk_window_set_modal (GTK_WINDOW (info->new_tab_dialog), TRUE);
  gtk_container_set_border_width (GTK_CONTAINER (info->new_tab_dialog),
    info->button_spacing);
  info->new_tab_table = gtk_table_new (3, 5, FALSE);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (info->new_tab_dialog)->vbox),
    info->new_tab_table);
  gtk_table_set_row_spacings (GTK_TABLE (info->new_tab_table),
    info->button_spacing);
  gtk_table_set_col_spacings (GTK_TABLE (info->new_tab_table),
    info->button_spacing);

  label = gtk_label_new ("New tab name:");
  gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
  gtk_table_attach_defaults (GTK_TABLE (info->new_tab_table), label,
    0, 1, 0, 1);
  gtk_widget_show (label);

  info->new_tab_field = gtk_entry_new();
  gtk_table_attach_defaults (GTK_TABLE (info->new_tab_table),
    info->new_tab_field, 2, 3, 0, 1);
  gtk_widget_show (info->new_tab_field);
  
  button = gtk_button_new_with_label ("Add");
  gtk_widget_show (button);
  g_signal_connect (G_OBJECT (button), "clicked",
    G_CALLBACK (accept_new_tab), info);
  gtk_table_attach_defaults (GTK_TABLE (info->new_tab_table), button,
    4, 5, 0, 1);
  gtk_widget_show (button);
  
  button = gtk_button_new_with_label ("Cancel");
  gtk_widget_show (button);
  g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (close_dialog),
    info->new_tab_dialog);
  gtk_table_attach_defaults (GTK_TABLE (info->new_tab_table), button,
    4, 5, 2, 3);
  gtk_widget_show (button);
  
  gtk_widget_show_all (info->new_tab_dialog);
}



void add_row (gamepick_info *info, gint row, const gchar *button_text,
  gchar *label_text, GCallback function)
{
  GtkWidget *button, *label;
  
  button = gtk_button_new_with_label (button_text);
  gtk_table_attach_defaults (GTK_TABLE (info->options_table), button,
    0, 1, row, row + 1);
  g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (function), info);
  gtk_widget_show (button);
  
  label = gtk_label_new (label_text);
  gtk_table_attach_defaults (GTK_TABLE (info->options_table), label,
    2, 3, row, row + 1);
  gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
  gtk_widget_show (label);
}


void options_run (GtkWidget *widget, gamepick_info *info)
{
  GtkWidget *button;
  GString *string;

  info->options_dialog = gtk_dialog_new_with_buttons ("Options",
    GTK_WINDOW (info->main_window), GTK_DIALOG_NO_SEPARATOR, NULL);
  gtk_window_set_transient_for (GTK_WINDOW (info->options_dialog),
    GTK_WINDOW (info->main_window));
  gtk_window_set_modal (GTK_WINDOW (info->options_dialog), TRUE);
  gtk_container_set_border_width (GTK_CONTAINER (info->options_dialog),
    info->button_spacing);
  info->options_table = gtk_table_new (10, 4, FALSE);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (info->options_dialog)->vbox),
    info->options_table);
  gtk_table_set_row_spacings (GTK_TABLE (info->options_table),
    info->button_spacing);
  gtk_table_set_col_spacings (GTK_TABLE (info->options_table),
    info->button_spacing);

  if (info->current_game)
  {
    string = g_string_new (NULL);
    g_string_sprintf (string, "Edit %s", info->current_game->name->str);
    add_row (info, 0, "Edit Game", string->str, G_CALLBACK (options_edit));
  }
  add_row (info, 1, "Auto Games", "Scan for known games",
    G_CALLBACK (options_auto_games));
  add_row (info, 2, "New Game", "Create a new game in the current tab",
    G_CALLBACK (options_new));
  add_row (info, 3, "New Tab", "Create a new, empty tab",
    G_CALLBACK (new_tab));
  add_row (info, 4, "Debug", "Toggle debug window",
    G_CALLBACK (options_debug));
  add_row (info, 5, "Delete", "How to remove objects",
    G_CALLBACK (delete_stuff));
  add_row (info, 6, "About", "",
    G_CALLBACK (about));
  
  button = gtk_button_new_with_label ("Cancel");
  g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (close_dialog),
    info->options_dialog);
  gtk_table_attach_defaults (GTK_TABLE (info->options_table), button,
    3, 4, 8, 9);
  gtk_widget_show (button);
  
  gtk_widget_show_all (info->options_dialog);
}

