/* blib - Library of useful things to hack the Blinkenlights
 *
 * Copyright (c) 2002  The Blinkenlights Crew
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __DIGITS_H__
#define __DIGITS_H__


typedef struct _BFont {
  gint width, height, advance, num_digits;

  guchar *digits_str;
  guchar *data[];
} BFont;


static const BFont b_digits_3x5 = {
   width: 3,
   height: 5,
   advance: 4,
   num_digits: 12,
   digits_str: "0123456789: ",
   data: 
      { /* 0 */
        "111"
        "101"
        "101"
        "101"
        "111",
        /* 1 */
        "010"
        "010"
        "010"
        "010"
        "010",
        /* 2 */
        "111"
        "001"
        "111"
        "100"
        "111",
        /* 3 */
        "111"
        "001"
        "111"
        "001"
        "111",
        /* 4 */
        "101"
        "101"
        "111"
        "001"
        "001",
        /* 5 */
        "111"
        "100"
        "111"
        "001"
        "111",
        /* 6 */
        "111"
        "100"
        "111"
        "101"
        "111",
        /* 7 */
        "111"
        "001"
        "010"
        "100"
        "100",
        /* 8 */
        "111"
        "101"
        "111"
        "101"
        "111",
        /* 9 */
        "111" 
        "101"
        "111"
        "001"
        "111",
        /* : */
        "000" 
        "010"
        "000"
        "010"
        "000",
        /*   */
        "000"
        "000"
        "000"
        "000"
        "000"
      }
};
           
static const BFont b_digits_5x7 = {
   width: 5,
   height: 7,
   advance: 6,
   num_digits: 12,
   digits_str: "0123456789: ",
   data: 
      { /* 0 */
        "01110"
        "10001"
        "10011"
        "10101"
        "11001"
        "10001"
        "01110",
        /* 1 */
        "00100"
        "01100"
        "00100"
        "00100"
        "00100"
        "00100"
        "01110",
        /* 2 */
        "01110"
        "10001"
        "00001"
        "00010"
        "00100"
        "01000"
        "11111",
        /* 3 */
        "11111"
        "00010"
        "00100"
        "00010"
        "00001"
        "10001"
        "01110",
        /* 4 */
        "00010"
        "00110"
        "01010"
        "10010"
        "11111"
        "00010"
        "00010",
        /* 5 */
        "11111"
        "10000"
        "11110"
        "00001"
        "00001"
        "10001"
        "01110",
        /* 6 */
        "00110"
        "01000"
        "10000"
        "11110"    
        "10001"
        "10001"
        "01110",
        /* 7 */
        "11111"
        "10001"
        "00001"
        "00010"
        "00100"
        "00100"
        "00100",
        /* 8 */
        "01110"
        "10001"
        "10001"
        "01110"
        "10001"
        "10001"
        "01110",
        /* 9 */
        "01110"
        "10001"
        "10001"
        "01111"
        "00001"
        "00010"
        "01100",
        /* : */
        "00000"
        "00000"
        "00100"
        "00000"
        "00100"
        "00000"
        "00000",
        /*   */
        "00000"
        "00000"
        "00000"
        "00000"
        "00000"
        "00000"
        "00000"
      }
};

static const BFont b_digits_8x7 = {
   width: 8,
   height: 7,
   advance: 9,
   num_digits: 12,
   digits_str: "0123456789: ",
   data: 
      { /* 0 */
        "01111110"
        "11000111"
        "11001011"
        "11001011"
        "11010011"
        "11100011"
        "01111110",
        /* 1 */
        "00011100"
        "01111100"
        "00011100"
        "00011100"
        "00011100"
        "00011100"
        "00011100",
        /* 2 */
        "00111100"
        "11111110"
        "00000110"
        "00001110"
        "00011100"
        "01111000"
        "11111111",
        /* 3 */
        "01111110"
        "11111111"
        "00000111"
        "00111111"
        "00000111"
        "11111111"
        "01111110",
        /* 4 */
        "00111111"
        "01110111"
        "11100111"
        "11111111"
        "00000111"
        "00000111"
        "00000111",
        /* 5 */
        "11111111"
        "11111111"
        "11100000"
        "11111110"
        "00000111"
        "01111111"
        "11111110",
        /* 6 */
        "01111110"
        "11100111"
        "11000000"
        "11111110"
        "11100111"
        "11100111"
        "01111110",
        /* 7 */
        "11111111"
        "11111111"
        "00000111"
        "00001110"
        "00011100"
        "00111000"
        "01110000",
        /* 8 */
        "00111100"
        "11100111"
        "11100111"
        "01111110"
        "11100111"
        "11100111"
        "00111100",
        /* 9 */
        "01111110"
        "11100111"
        "11100111"
        "01111111"
        "00000011"
        "11100111"
        "01111110",
        /* : */
        "00000000"
        "00111000"
        "00111000"
        "00000000"
        "00111000"
        "00111000"
        "00000000",
        /*   */
        "00000000"
        "00000000"
        "00000000"
        "00000000"
        "00000000"
        "00000000"
        "00000000"
      }
};

#endif /*  __DIGITS_H__  */
