/* File:      tetpitaprism.P
** Author(s): Fabrizio Riguzzi and Terrance Swift
**
*/


/*

Use
:-main.
to execute the tests

*/
:-[pitaindexc].

epsilon(0.0001).


close_to(V,T):-
	epsilon(E),
	TLow is T-E,
	THigh is T+E,
	TLow<V,
	V<THigh.

main:-
	files(F),
	test_files(F),
	write('Test successful\n').
main:-
	write('Test unsuccessful.\n').

test_files([]).

test_files([H|T]) :-
	atom_concat('examples/',H,NH),
	load(NH),
	findall(f(Q,P),test(H,Q,P),L),
	test_all(H,L),
	test_files(T).

test_all(_F,[]).

test_all(F, [ f(Q,P) | T ]) :-
	fmt_write("File: %S, qeury: %S, expected probability: %f\n",f(F,Q,P)),
	prob(Q,Prob,TC,TW),!,
	fmt_write("Actual probability: %fl\nCPU time: %f Wall time: %f\n\n",f(Prob,TC,TW)),
	close_to(Prob,P),
	test_all(F,T).


files([coin,coin2,alarm,light,mendel,hmm]).

test(alarm,alarm(t),0.3).

test(light,light,0.5).
test(light,replace,0.5).

test(hmm,hmm([a]),0.083350000).
test(hmm,hmm([a,a]),0.013890278).
test(hmm,hmm([a,a,a]),0.002314815).

test(mendel,cg(s,1,p),0.75).
test(mendel,cg(s,1,w),0.25).
test(mendel,cg(s,2,p),0.25).
test(mendel,cg(s,2,w),0.75).
test(mendel,cg(f,2,w),0.5).
test(mendel,cg(s,2,w),0.75).

test(coin,heads(coin),0.51).

test(coin2,heads(coin1),0.51).
test(coin2,heads(coin2),0.51).
test(coin2,tails(coin1),0.49).
test(coin2,tails(coin2),0.49).



