/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import java.io.File;
import java.net.URI;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.configuration.ApplyScriptPluginBuildOperationType;
import org.gradle.configuration.ConfigurationTargetIdentifier;
import org.gradle.configuration.ScriptPlugin;
import org.gradle.configuration.internal.UserCodeApplicationContext;
import org.gradle.configuration.internal.UserCodeApplicationId;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.resource.ResourceLocation;
import org.gradle.internal.resource.TextResource;

public class BuildOperationScriptPlugin
implements ScriptPlugin {
    private final ScriptPlugin decorated;
    private final BuildOperationExecutor buildOperationExecutor;
    private final UserCodeApplicationContext userCodeApplicationContext;
    private static final ApplyScriptPluginBuildOperationType.Result OPERATION_RESULT = new ApplyScriptPluginBuildOperationType.Result(){};

    public BuildOperationScriptPlugin(ScriptPlugin decorated, BuildOperationExecutor buildOperationExecutor, UserCodeApplicationContext userCodeApplicationContext) {
        this.decorated = decorated;
        this.buildOperationExecutor = buildOperationExecutor;
        this.userCodeApplicationContext = userCodeApplicationContext;
    }

    @Override
    public ScriptSource getSource() {
        return this.decorated.getSource();
    }

    @Override
    public void apply(final Object target) {
        TextResource resource = this.getSource().getResource();
        if (resource.isContentCached() && resource.getHasEmptyContent()) {
            this.decorated.apply(target);
        } else {
            this.userCodeApplicationContext.apply(this.getSource().getShortDisplayName(), (Action<? super UserCodeApplicationId>)((Action)userCodeApplicationId -> this.buildOperationExecutor.run(new RunnableBuildOperation((UserCodeApplicationId)userCodeApplicationId){
                final /* synthetic */ UserCodeApplicationId val$userCodeApplicationId;
                {
                    this.val$userCodeApplicationId = userCodeApplicationId;
                }

                public void run(BuildOperationContext context) {
                    BuildOperationScriptPlugin.this.decorated.apply(target);
                    context.setResult((Object)OPERATION_RESULT);
                }

                public BuildOperationDescriptor.Builder description() {
                    ScriptSource source = BuildOperationScriptPlugin.this.getSource();
                    ResourceLocation resourceLocation = source.getResource().getLocation();
                    File file = resourceLocation.getFile();
                    String name = "Apply " + source.getShortDisplayName();
                    String displayName = name + " to " + target;
                    return BuildOperationDescriptor.displayName((String)displayName).name(name).details((Object)new OperationDetails(file, resourceLocation, ConfigurationTargetIdentifier.of(target), this.val$userCodeApplicationId));
                }
            })));
        }
    }

    private static class OperationDetails
    implements ApplyScriptPluginBuildOperationType.Details {
        private final File file;
        private final ResourceLocation resourceLocation;
        private final ConfigurationTargetIdentifier identifier;
        private final UserCodeApplicationId applicationId;

        private OperationDetails(File file, ResourceLocation resourceLocation, @Nullable ConfigurationTargetIdentifier identifier, UserCodeApplicationId applicationId) {
            this.file = file;
            this.resourceLocation = resourceLocation;
            this.identifier = identifier;
            this.applicationId = applicationId;
        }

        @Nullable
        public String getFile() {
            return this.file == null ? null : this.file.getAbsolutePath();
        }

        @Nullable
        public String getUri() {
            if (this.file == null) {
                URI uri = this.resourceLocation.getURI();
                return uri == null ? null : uri.toASCIIString();
            }
            return null;
        }

        public String getTargetType() {
            return this.identifier == null ? null : this.identifier.getTargetType().label;
        }

        @Nullable
        public String getTargetPath() {
            return this.identifier == null ? null : this.identifier.getTargetPath();
        }

        public String getBuildPath() {
            return this.identifier == null ? null : this.identifier.getBuildPath();
        }

        public long getApplicationId() {
            return this.applicationId.longValue();
        }
    }
}

