# NAME

csv2 - Description of the csv2 zone file that MaraDNS uses 

# DESCRIPTION

The csv2 zone file format is MaraDNS' standard zone file format. This 
zone file format uses any kind of whitespace (space, tab, and carriage 
return), or the '|' character, to delimit fields. 

## Tilde delimitation

In newer MaraDNS releases, the tilde ('~') character is used to delimit 
records in csv2 zone files; in order to maintain maximum compatibility 
with older MaraDNS zone files, this feature is only enabled if a tilde 
is placed between the first and second record. Otherwise, tildes are 
not allowed in zone files (except in comments). 

Most older MaraDNS csv2 zone files without the tilde character are 
compatible with the updated csv2 parser, unless csv2_tilde_handling is 
set to 3. All older MaraDNS csv2 zone files will parse in MaraDNS if 
csv2_tilde_handling has a value of 0. Older MaraDNS releases also 
supported the csv2_tilde_handling variable (as long as it had a value 
of 0); this allowed the same configuration and zone files to be used in 
older and newer MaraDNS releases. 

## Resource record format

This zone file format has records in the following form: 

name [+ttl] [rtype] rdata ~ 

The name is the name of the record we will add, such as 
"www.example.net.". This must be placed at the beginning of a line. The 
rtype is the record type for the record, such as "A" (ipv4 IP address), 
"MX" (mail exchanger), or "AAAA" (ipv6 IP address). The ttl is how long 
other DNS servers should store this data in their memory (in seconds); 
this field needs a '+' as its initial character. The rdata is the 
actual data for this record; the format for the rdata is type-specific. 

Anything in square brackets is an optional field. If the ttl is not 
specified, the ttl is set to the default ttl value (see "Default TTL" 
below). If the rtype is not specified, it is set to be an "A" (ipv4 
address) record. 

The zone file supports comments; comments are specified by having a '#' 
anywhere between fields or records; when a '#' is seen, the csv2 parser 
ignores any character it sees (with the exception of the '{', which is 
not allowed in comments) until a newline. A '#' can usually be placed 
inside a field, and indicates the end of a field when placed there. 

A '{' character can never be placed in a comment. A '~' character is 
always allowed in a comment, and has no special meaning when placed in 
a comment. 

The following record types are supported; a description of the record 
data format accommodates the record type: 

## A

An A record stores an ipv4 address. This is the default record type 
should the record type not be specified. The record type has one field 
in it: the IP for the record. Examples:

```
a.example.net.              10.11.12.13 ~ 
b.example.net.        A     10.11.12.14 ~ 
c.example.net. +64000 A     10.11.12.15 ~ 
```

## PTR

A PTR record stores the name for a given ipv4 or ipv6 address, and is 
used for reverse DNS lookups. This record type has one field in it: The 
name for the record in question. Examples:

```
13.12.11.10.in-addr.arpa.        PTR    a.example.net. ~ 
14.12.11.10.in-addr.arpa.        PTR    b.example.net. ~ 
15.12.11.10.in-addr.arpa. +64000 PTR    c.example.net. ~ 
```

## MX

A MX record stores a mail exchange record, and is used for mail 
delivery. This record type has two fields in it: The priority (or 
"preference" in traditional DNS parlance) of the MX record (lower 
numbers get higher priority), and the name of the mail exchanger. 
Example of mail for example.net being mailed to mail.example.net, which 
has the IP "10.11.12.16":

```
example.net.      MX   10 mail.example.net. ~ 
mail.example.net.      10.11.12.16 ~ 
```

## AAAA

An AAAA record stores the ipv6 address for a given name. The IP is in 
standard ipv6 "colon delimited" format: eight 16-bit hexadecimal 
numbers are separated by colons. Two colons together indicate multiple 
streams of all-zero hex numbers. This record has only one field, the v6 
IP. Example:

```
a.example.net.   AAAA    2001:db8:dec:ade::f ~ 
```

## SRV

An SRV record stores a "service" definition. This record has four 
fields: Priority, weight, port, and target. For more information, 
please refer to RFC 2782. Example:

```
_http._tcp.% SRV 0 0 80 a.% ~ 
```

## NAPTR

A NAPTR record is described in RFC 2915. Example:

```
www.example.com. NAPTR 100 100 's';'http+I2R';'' _http._tcp.example.com. ~  
```

Note the semicolons. Because of a bug in MaraDNS 1.4.03 and 
earlier releases, NAPTR records will not parse unless a ~ is *not* used 
to separate records; a patch to fix this bug is available here. 

## NS

An NS record specifies the name servers for a given zone. If the name 
servers are not delegation name servers (in other words, if the name 
servers are the authoritative name servers for the zone), they need to 
be at the beginning of the zone, either as the first records in the 
zone, or right after the SOA record. The NS records are optional; if 
not present, MaraDNS will make an educated guess of that NS records 
should be there, based on the IPs the MaraDNS process is bound to. This 
record has one field: The name of the name server machine. Example:

```
example.net.    NS    ns1.example.net. ~ 
example.net.    NS    ns2.example.net. ~ 
```

## SOA

An SOA record stores the start of authority for a given zone file. This 
record is optional in a CSV2 zone file; should the record not be in the 
zone file, MaraDNS will synthesize an appropriate SOA record. This 
record can only exist once in a zone file: As the first record of the 
zone file. This record has seven fields: The name of the zone, the 
email address of the person responsible for the zone, and five numeric 
fields (serial, refresh, retry, expire, and minimum). Note that the SOA 
minimum does *not* affect other TTLs in MaraDNS. Example:

```
x.org. SOA x.org. email@x.org. 1 7200 3600 604800 1800 ~ 
```

If there is a '.' (dot) character in the part of the email 
address before the '@', it needs to be escaped thusly:

```
x.org. SOA x.org. john\.doe@x.org. 1 7200 3600 604800 1800 ~ 
```

Note that the csv2 parser will not allow more than one dot in a 
row; 'john\.\.doe@x.org' will cause a parse error. In addition, the dot 
character must be escaped with a backslash. 

The serial numeric field may be replaced by the string '/serial'; this 
string tells the CSV2 zone parser to synthesize a serial number for the 
zone based on the timestamp for the zone file. This allows one to have 
the serial number be automatically updated whenever the zone file is 
edited. Here is how this special field looks in a SOA record:

```
x.org. SOA x.org. email@x.org. /serial 7200 3600 604800 1800 ~ 
```

The '/serial' string is case-sensitive; only '/serial' in all 
lower case will parse. 

## TXT

A TXT record stores arbitrary text and/or binary data for a given host 
name. This record has one field: The text data for the record. 

A basic text record can be stored by placing ASCII data between two 
single quotes, as follows:

```
example.com. TXT 'This is an example text field' ~ 
```

Any binary data can be specified; see the **csv2_txt(5)** manual 
page for full details. 

If tildes are used to separate records, a TXT record can not contain a 
literal '|' (pipe) character, a '#' literal, a '~' literal, nor any 
ASCII control literal; these characters can be added to a TXT record 
via the use of escape sequences; read the csv2_txt man pagefor details. 

## SPF

A SPF record is, with the exception of the numeric rtype, identical to 
a TXT record. SPF records are designed to make it more difficult to 
forge email. 

Here is one example SPF record:

```
example.com. SPF 'v=spf1 +mx a:colo.example.com/28 -all' ~ 
```

Use '\x7e' to put a tilde ("~" character) in a SPF record:

```
example.com. SPF 'v=spf1 +mx a:colo.example.com/28 '\x7e'all' ~ 
```

More information about SPF records can be found in RFC4408, or by 
performing a web search for 'sender policy framework'. 

Note that SPF records never gained traction, and their role is handled 
by TXT records. 

## RAW

The RAW record is a special meta-record that allows any otherwise 
unsupported record type to be stored in a csv2 zone file. The syntax 
is:

```
RAW [numeric rtype] [data] ~ 
```

The numeric rtype is a decimal number. 

The data field can, among other thing, have backslashed hex sequences 
outside of quotes, concatenated by ASCII data inside quotes, such as 
the following example:

```
example.com. RAW 40 \x10\x01\x02'Kitchen sink'\x40' data' ~ 
```

The above example is a "Kitchen Sink" RR with a "meaning" of 16, 
a "coding" of 1, a "subcoding" of 2, and a data string of "Kitchen 
sink@ data" (since hex code 40 corresponds to a @ in ASCII). Note that 
unquoted hex sequences are concatenated with quoted ASCII data, and 
that spaces are *only* inside quoted data. 

The format for a data field in a RAW record is almost identical to the 
format for a TXT data field. Both formats are described in full in the 
**csv2_txt(5)** manual page. 

## FQDN4

The FQDN4 (short for "Fully Qualified Domain Name for IPv4") record is 
a special form of the "A" record (see above) that instructs MaraDNS to 
automatically create the corresponding PTR record. For example, the 
following is one way of setting up the reverse DNS lookup for 
x.example.net:

```
x.example.net. A 10.3.28.79 ~ 
79.28.3.10.in-addr.arpa. PTR x.example.net. ~ 
```

But the above two lines in a zone file can also be represented 
thusly:

```
x.example.net. FQDN4 10.3.28.79 ~ 
```

Note that the csv2 parser does not bother to check that any given 
IP only has a single FQDN4 record; it is up to the DNS administrator to 
ensure that a given IP has only one FQDN4 record. In the case of there 
being multiple FQDN4 records with the same IP, MaraDNS will have 
multiple entries in the corresponding PTR record, which is usually not 
the desired behavior. 

FQDN4 records are not permitted in a csv2_default_zonefile. If you do 
not know what a csv2_default_zonefile is, you do not have to worry 
about this limitation. 

## FQDN6

The FQDN6 (short for "Fully Qualified Domain Name for IPv6") record is 
the ipv6 form for the FQDN4 record. Like the FQDN4 record, this record 
creates both a "forward" and "reverse" DNS record for a given host 
name. For example, one may have:

```
x.example.net. AAAA 2001:db8:dec:ade::b:c:d ~ 
d.0.0.0.c.0.0.0.b.0.0.0.0.0.0.0.e.d.a.0.c.e.d.0.8.b.d.0.1.0.0.2 PTR  
x.example.net. ~ 
```

But the above two lines in a zone file can also be represented 
thusly:

```
x.example.net. FQDN6 2001:db8:dec:ade::b:c:d ~ 
```

Like FQDN4 records, it is the DNS administrator's duty to make 
sure only a single IP has a FQDN6 record. 

FQDN6 records are, like FQDN4 records, not permitted in a 
csv2_default_zonefile. If you do not know what a csv2_default_zonefile 
is, you do not have to worry about this limitation. 

FQDN6 records were implemented by Jean-Jacques Sarton. 

## CNAME

A CNAME record is a pointer to another host name. The CNAME record, in 
MaraDNS, affects any record type not already specified for a given host 
name. While MaraDNS allows CNAME and non-CNAME records to share the 
same host name, this is considered bad practice and is not compatible 
with some other DNS servers. 

CNAME records are not permitted in a csv2_default_zonefile. If you do 
not know what a csv2_default_zonefile is, this fact is of no relevance. 

# Historical and uncommon resource records

The following resource records are mainly of historical interest, or 
are not commonly used. 

## HINFO

*In light of RFC8482, using this record type is strongly discouraged.* 

An HINFO record is a description of the CPU (processor) and OS that a 
given host is using. The format for this record is identical to a TXT 
record, except that the field must have precisely two chunks. 

The first chunk of a HINFO record is the CPU the host is running; the 
second chunk is the OS the host is running. 

Example:

```
example.com. HINFO 'Intel Pentium III';'CentOS Linux 3.7' ~ 
```

This resource record is not actively used--the IANA has a list of 
CPUs and OSes that this record is supposed to have. However, this list 
has not been updated since 2002. 

Since MaraDNS has support for RFC8482, ANY queries sent to MaraDNS will 
return an HINFO record with a CPU of "RFC8482" and a blank OS name. 

## WKS

WKS records are historical records which have been superseded by SRV 
records. The format of the record is an IP, followed by a protocol 
number (6 means TCP), followed by a list of ports that a given server 
has available for services. 

For example, to advertise that example.net has the IP 10.1.2.3, and has 
a SSH, HTTP (web), and NNTP server:

```
example.net. WKS 10.1.2.3 6 22,80,119 ~ 
```

MaraDNS only allows up to 10 different port numbers in a WKS 
record, and requires that the listed port numbers not be higher than 
1023. 

## MD and MF

MD and MF records are RR types that existed before MX records, and were 
made obsolete by MX records. RFC1035 says that a DNS server can either 
reject these records or convert these records in to MX records. BIND 
rejects these records; MaraDNS converts them. 

Example:

```
example.net. MD a.example.net. ~ 
example.net. MF b.example.net. ~ 
```

Is equivalent to:

```
example.net. MX 0 a.example.net. ~ 
example.net. MX 10 b.example.net. ~ 
```

## MB, MG, MINFO, and MR

In the late 1980s, an alternative to MX records was proposed. This 
alternative utilized MB, MG, MINFO, and MR records. This alternative 
failed to gather popularity. However, these records were codified in 
RFC1035, and are supported by MaraDNS. Here is what the records look 
like:

```
example.net. MB mail.example.net. ~ 
example.net. MG mg@example.net. ~ 
example.net. MINFO rm@example.net. re@example.net. ~ 
example.net. MR mr@example.net. ~ 
```

More information about these records can be found in RFC1035. 

## AFSDB, RP, X25, ISDN, and RT

AFSDB, RP, X25, ISDN, and RT are resource records which were proposed 
in RFC1183. None of these resource records are widely used. 

With the exception of the ISDN record, the format of these records is 
identical to the examples in RFC1183. The format of the ISDN record is 
identical unless the record has a subaddress (SA). If an ISDN record 
has a subaddress, it is separated from the ISDN-address by a ';' 
instead of whitespace. 

If used, here is how the records would look in a csv2 zone file:

```
example.net. AFSDB 1 afsdb.example.net. ~ 
example.net. RP rp@example.net. rp.example.net. ~ 
example.net. RP rp2@example.net. . ~ 
example.net. X25 311061700956 ~ 
example.net. ISDN 150862028003217 ~ 
example.net. ISDN 150862028003217;004 ~ 
example.net. RT 10 relay.example.net. ~ 
```

## NSAP and NSAP-PTR

NSAP and NSAP-PTR records were proposed in RFC1706. A NSAP record is a 
hexadecimal number preceded by the string "0x" and with optional dots 
between bytes. This hexadecimal number is converted in to a binary 
number by MaraDNS. A NSAP-PTR record is identical to a PTR record, but 
has a different RTYPE. 

More information about these records can be obtained from RFC1706. 

If used, here is how the records would look in a csv2 zone file:

```
example.net. NSAP 0x47.0005.80.005a00.0000.0001.e133.ffffff000162.00 ~ 
example.net. NSAP-PTR nsap.example.net. ~ 
```

## PX

The PX RR is an obscure RR described in RFC2163. A PX record looks like 
this in a CSV2 zone file:

```
example.net. PX 15 px1.example.net. px2.example.net. ~ 
```

## GPOS

An GPOS record is a description of the location of a given server. The 
format for this record is identical to a TXT record, except that the 
field must have precisely three chunks. 

The first chunk of a GPOS record is the longitude; the second chunk is 
the latitude; the third chunk is the altitude (in meters). 

Example:

```
example.net. GPOS '-98.6502';'19.283';'2134' ~ 
```

More information about this record can be found in RFC1712. 

This resource record is not actively used; for the relatively few 
people who encode their position in DNS, the LOC record is far more 
common. 

## LOC

The LOC resource record is an uncommonly used resource record that 
describes the position of a given server. LOC records are described in 
RFC1876. 

Note that MaraDNS' LOC parser assumes that the altitude, size, 
horizontal, and vertical precision numbers are always expressed in 
meters. Also note that that sub-meter values for size, horizontal, and 
vertical precision are not allowed. Additionally, the altitude can not 
be greater than 21374836.47 meters. 

Example:

```
example.net. LOC 19 31 2.123 N 98 3 4 W 2000m 2m 4m 567m ~ 
```

## CAA

MaraDNS does not have direct support for CAA records. However, the RAW 
record type can generate CAA records. For example, to have 
"example.com" have a CAA record with the value of "issue 
letsencrypt.org":

```
example.com. RAW 257 \x00\x05'issueletsencrypt.org' ~ 
```

# STAR RECORDS

MaraDNS has support for star records in zone files:

```
*.example.net.  A		10.11.12.13 ~ 
```

In this example, anything.example.net will have the IP 
10.11.12.13. Note that this does not set the ip for "example.net", 
which needs a separate record:

```
example.net.  A                 10.11.12.13 ~ 
```

Note also that stars must be at the beginining of a name; to have 
stars at the end of a name, use the csv2_default_zonefile feature as 
described in the mararc man page. 

# PERCENT SYMBOL

Placing the percent symbol at the end of a record indicates that the 
percent should be replaced with the domain name for the zone. 

For example, in the zone for example.net. (e.g. one's mararc file has 
csv2["example.net."] = "db.example.net", and we are editing the 
"db.example.net" file):

```
www.%	A	10.10.10.10 ~ 
```

This will cause "www.example.net" to have the ip 10.10.10.10. 

# SLASH COMMANDS

In addition to being able to have resource records and comments, csv2 
zone files can also have special slash commands. These slash commands, 
with the exception of the '/serial' slash command (see "SOA" above), 
can only be placed where the name for a record would be placed. Like 
resource records, a tilde is to be placed after the slash command. Note 
also that slash commands are case-sensitive, and the command in 
question must be in all-lower-case. 

These commands are as follows: 

## Default TTL

The default TTL is the TTL for a resource record without a TTL 
specified. This can be changed with the '/ttl' slash command. This 
command takes only a single argument: The time, in seconds, for the new 
default TTL. The '/ttl' slash command only affects the TTL of records 
that follow the command. A zone file can have multiple '/ttl' slash 
commands. 

The default TTL is 86400 seconds (one day) until changed by the '/ttl' 
slash command. 

In the following example, a.ttl.example.com will have a TTL of 86400 
seconds (as long as the zone file with this record has not previously 
used the '/ttl' slash command), b.ttl.example.com and d.ttl.example.com 
will have a TTL of 3600 seconds, c.ttl.example.com will have a TTL of 
9600 seconds, and e.ttl.example.com will have a TTL of 7200 seconds:

```
a.ttl.example.com.       10.0.0.1 ~ 
/ttl 3600 ~ 
b.ttl.example.com.       10.0.0.2 ~ 
c.ttl.example.com. +9600 10.0.0.3 ~ 
d.ttl.example.com.       10.0.0.4 ~ 
/ttl 7200 ~ 
e.ttl.example.com.       10.0.0.5 ~ 
```

## Origin

It is possible to change the host name suffix that is used to 
substitute the percent in a csv2 zone file. This suffix is called, for 
historical and compatibility reasons, "origin". This is done as the 
slash command '/origin', taking the new origin as the one argument to 
this function. Note that changing the origin does *not* change the 
domain suffix used to determine whether a given domain name is 
authoritative. 

Here is one example usage of the '/origin' slash command:

```
/origin example.com. ~ 
www.% 10.1.0.1 ~ 
% MX 10 mail.% ~ 
mail.% 10.1.0.2 ~ 
/origin example.org. ~ 
www.% 10.2.0.1 ~ 
% MX 10 mail.% ~ 
mail.% 10.2.0.2 ~ 
```

Which is equivalent to:

```
www.example.com. 10.1.0.1 ~ 
example.com. MX 10 mail.example.com. ~ 
mail.example.com. 10.1.0.2 ~ 
www.example.org. 10.2.0.1 ~ 
example.org. MX 10 mail.example.org. ~ 
mail.example.org. 10.2.0.2 ~ 
```

It is also possible to make the current origin be part of the new 
origin:

```
/origin example.com. ~ 
% 10.3.2.1 ~ # example.com now has IP 10.3.2.1 
/origin mail.% ~ 
% 10.3.2.2 ~ # mail.example.com now has IP 10.3.2.2 
```

## Opush and Opop

The '/opush' and '/opop' slash commands use a stack to remember and 
later recall values for the origin (see origin above). The '/opush' 
command is used just like the '/origin' command; however, the current 
origin is placed on a stack instead of discarded. The '/opop' command 
removes ("pops") the top element from this stack and makes the element 
the origin. 

For example:

```
/origin example.com. ~ 
/opush mail.% ~ # origin is now mail.example.com; example.com is on stack 
a.% 10.4.0.1 ~ # a.mail.example.com has IP 10.4.0.1 
/opush web.example.com. ~ # mail.example.com and example.com are on stack 
a.% 10.5.0.1 ~ # a.web.example.com has IP 10.5.0.1 
b.% 10.5.0.2 ~ # b.web.example.com has IP 10.5.0.2 
/opop ~ # origin is now mail.example.com again 
b.% 10.4.0.2 ~ # b.mail.example.com has IP 10.4.0.2 
/opop ~ # origin is now example.com 
% MX 10 a.mail.% ~ # example.com. MX 10 a.mail.example.com. 
% MX 20 b.mail.% ~ # example.com. MX 20 b.mail.example.com. 
```

The opush/opop stack can have up to seven elements on it. 

## Read

The '/read' slash commands allows one to have the contents of another 
file in a zone. The '/read' command takes a single argument: A filename 
that one wishes to read. The filename is only allowed to have letters, 
numbers, the '-' character, the '_' character, and the '.' character in 
it. 

The file needs to be in the same directory as the zone file. The file 
will be read with the same privileges as the zone file; content in the 
file should come from a trusted source or be controlled by the system 
administrator. 

Let us suppose that we have the following in a zone file:

```
mail.foo.example.com. 10.3.2.1 ~ 
/read foo ~ 
foo.example.com. MX 10 mail.foo.example.com. ~ 
```

And a file foo with the following contents:

```
foo.example.com. 10.1.2.3 ~ 
foo.example.com. TXT 'Foomatic!' ~ 
```

Then foo.example.com will have an A record with the value 
10.1.2.3, a TXT value of 'Foomatic!', and a MX record with priority 10 
pointing to mail.foo.example.com. mail.foo.example.com will have the IP 
10.3.2.1. 

Note that no pre-processing nor post-processing of the origin is done 
by the '/read' command; should the file read change the origin, this 
changed value will affect any records after the '/read' command. For 
example, let us suppose db.example.com looks like this:

```
/origin foo.example.com. ~ 
% TXT 'Foomatic!' ~ 
/read foo ~ 
% MX 10 mail.foo.example.com. ~ 
```

And the file foo looks like this:

```
% 10.1.2.3 ~ 
/origin mail.% ~ 
% 10.3.2.1 ~ 
```

Then the following records will be created:

```
foo.example.com.      TXT   'Foomatic!' ~ 
foo.example.com.      A     10.1.2.3 ~ 
mail.foo.example.com. A     10.3.2.1 ~ 
mail.foo.example.com. MX 10 mail.foo.example.com. ~ 
```

To have something that works like '$INCLUDE filename' in a 
RFC1035 master file, do the following:

```
/opush % ~ 
/read filename ~ 
/opop ~ 
```

Or, for that matter, the equivalent of '$INCLUDE filename 
neworigin':

```
/opush neworigin. ~ 
/read filename ~ 
/opop ~ 
```

# EXAMPLE ZONE FILE

```
 
# This is an example csv2 zone file 
 
# First of all, csv2 zone files do not need an SOA record; however, if 
# one is provided, we will make it the SOA record for our zone 
# The SOA record needs to be the first record in the zone if provided 
# This is a commented out record and disabled. 
 
#% 	SOA	% email@% 1 7200 3600 604800 1800 ~ 
 
# Second of all, csv2 zone files do not need authoritative NS records. 
# If they aren't there, MaraDNS will synthesize them, based on the IP 
# addresses MaraDNS is bound to.  (She's pretty smart about this; if 
# Mara is bound to both public and private IPs, only the public IPs will 
# be synthesized as NS records)

#% 	NS 	a.% ~ 
#%	NS	b.% ~ 
 
# Here are some A (ipv4 address) records; since this is the most 
# common field, the zone file format allows a compact representation 
# of it. 
a.example.net. 	10.10.10.10 ~ 
# Here, you can see that a single name, "b.example.net." has multiple IPs 
# This can be used as a primitive form of load balancing; MaraDNS will 
# rotate the IPs so that first IP seen by a DNS client changes every time 
# a query for "b.example.net." is made 
b.example.net.  10.10.10.11 ~ 
b.example.net.  10.10.10.12 ~ 
 
# We can have the label in either case; it makes no difference 
Z.EXAMPLE.NET. 	10.2.3.4 ~ 
Y.EXAMPLE.net.  10.3.4.5 ~ 
 
# We can use the percent shortcut.  When the percent shortcut is present, 
# it indicates that the name in question should terminate with the name 
# of the zone we are processing. 
percent.%	a 		10.9.8.7 ~ 
 
# And we can have star records 
#*.example.net.  A		10.11.12.13 ~ 
 
# We can have a ttl in a record; however the ttl needs a '+' before it: 
# Note that the ttl has to be in seconds, and is before the RTYPE 
d.example.net. +86400 A 10.11.12.13 ~ 
 
f.example.net. # As you can see, records can span multiple lines 
        	A 	10.2.19.83 ~ 
 
# This allows well-commented records, like this: 
c.example.net. 		# Our C class machine 
        +86400  	# This record is stored for one day 
        A       	# A record 
        10.1.1.1 	# Where we are  
        ~               # End of record 
 
# We can even have something similar to csv1 if we want... 
e.example.net.|+86400|a|10.2.3.4|~ 
h.example.net.|a|10.9.8.7|~ 
# Here, we see we can specify the ttl but not the rtype if desired 
g.example.net.|+86400|10.11.9.8|~ 
 
# Here is a MX record 
# Note that "IN" is a pseudo-RR which means to ignore the RR type and 
# look at the next RR type in the zone file; this allows MaraDNS zone 
# files to look more like BIND zone files. 
% mx 10 mail.% ~ 
mail.% +86400 IN A 10.22.23.24 ~ 
 
# We even have a bit of ipv6 support 
a.example.net. 		aaaa 	2001:db8:1:2::3:f ~ 
 
# Not to mention support for SRV records 
_http._tcp.%    srv   0 0 80 a.% ~ 
 
# TXT records, naturally 
example.net.    txt 'This is some text' ~ 
 
# Starting with MaraDNS 1.2.08, there is also support for SPF records, 
# which are identical to TXT records.  See RFC4408 for more details. 
example.net.    spf 'v=spf1 +mx a:colo.example.com/28 -all' ~

```

# LEGAL DISCLAIMER

THIS SOFTWARE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY EXPRESS OR 
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR 
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE. 

# AUTHOR

Sam Trenholme http://www.samiam.org/ 

