/*
  Copyright (C) 2004-2005 Tommi Tervonen, Petteri Klemola, Pasi Orovuo

  This file is part of Kajaani Kombat.

  Kajaani Kombat is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  Kajaani Kombat is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with Kajaani Kombat; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __AUDIO_H
#define __AUDIO_H

#include "SDL_mixer.h"
#include "globals.h"
#include <string>
#include <cassert>

#define FADEIN_DUR 0 // fadein musics in 500 ms
#define FADEOUT_DUR 300 // fadeout music in 300 ms

using namespace std;


class audio
{
 public:
  audio() throw (string &){}
  virtual ~audio(){}
  //music
  virtual void play_intro_music()=0;
  virtual void play_cannonplace_music()=0;
  virtual void play_shooting_music()=0;
  virtual void play_repair_music()=0;
  virtual void stop_music()=0;
  
  //sound effects
  virtual void play_hit_sound(int pn)=0;
  virtual void play_hit_cannon_sound(int pn)=0;
  virtual void play_fire_sound(int pn)=0;
  virtual void play_block_down_sound()=0;
  virtual void play_block_rotate_sound()=0;
  virtual void play_cannon_down_sound(int pn)=0;
  virtual void play_select_castle_sound(int pn)=0;
  virtual void play_gui_navigation_sound()=0;
  virtual void play_gui_select_sound()=0;
  virtual void play_three_sec_warning_sound()=0;

 protected:
  static Mix_Music *load_mus(const string &fname) throw (string);
  static Mix_Chunk *load_sfx(const string &fname) throw (string);
};

class nullaudio : public audio
{
 public:
  nullaudio() throw (string &){}
  ~nullaudio(){}
  //music
  void play_intro_music(){}
  void play_cannonplace_music(){}
  void play_shooting_music(){}
  void play_repair_music(){}
  void stop_music(){}
  
  //sound effects
  void play_hit_sound(int pn){}
  void play_hit_cannon_sound(int pn){}
  void play_fire_sound(int pn){}
  void play_block_down_sound(){}
  void play_block_rotate_sound(){}
  void play_cannon_down_sound(int pn){};
  void play_select_castle_sound(int pn){}

  void play_gui_navigation_sound(){};
  void play_gui_select_sound(){};

  void play_three_sec_warning_sound(){}
};

class realaudio : public audio
{
 public:
  realaudio() throw (string &);
  ~realaudio();
  //music
  void play_intro_music();
  void play_cannonplace_music();
  void play_shooting_music();
  void play_repair_music();
  void stop_music();
  
  //sound effects
  void play_hit_sound(int pn);
  void play_hit_cannon_sound(int pn);
  void play_fire_sound(int pn);
  void play_block_down_sound();
  void play_block_rotate_sound();
  void play_cannon_down_sound(int pn);
  void play_select_castle_sound(int pn);

  void play_gui_navigation_sound();
  void play_gui_select_sound();

  void play_three_sec_warning_sound();

 protected:  
  Mix_Music *intro_mus;
  Mix_Music *shoot_mus;
  Mix_Music *repair_mus;
  Mix_Music *cannon_mus;

  //sound effects - 4 of each
  Mix_Chunk *fire[4];
  Mix_Chunk *hit[4]; // hit wall
  Mix_Chunk *hit_cannon[5];
  Mix_Chunk *select_castle[4];
  Mix_Chunk *cannon_down[4];

  Mix_Chunk *block_rotate;
  Mix_Chunk *block_down;
  Mix_Chunk *gui_navigation;
  Mix_Chunk *gui_select;
  Mix_Chunk *three_sec_warning;

 private:
  static const char *shootmus_file;
  static const char *intromus_file;
  static const char *repairmus_file;
  static const char *cannonmus_file;

  //sound effects
  static const char *hit_file;
  static const char *hit_cannon_file;
  static const char *fire_file;
  static const char *block_down_file;
  static const char *block_rotate_file;
  static const char *select_castle_file;
  static const char *cannon_down_file;

  static const char *gui_navigation_file;
  static const char *gui_select_file;

  static const char *three_sec_warning_file;
};

#endif
