/*
  Copyright (C) 2004-2005 Tommi Tervonen, Petteri Klemola, Pasi Orovuo

  This file is part of Kajaani Kombat.

  Kajaani Kombat is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  Kajaani Kombat is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with Kajaani Kombat; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "game_obj.h"


cannon_in::cannon_in(const coord & center, int _owner)
  :game_obj(center,_owner)

{}


cannon::cannon(const coord & center, int _owner)
  :cannon_in(center, _owner)
  //  : game_obj (center, _owner)
{
  ready = true;
  //game_obj(center,_owner);
}

cannon::cannon()
{
  ready = true;
}

void cannon::set_ready (bool rd)
{
  ready = rd;
}

bool cannon::is_ready () const
{
  return ready;
}

big_cannon::big_cannon(const coord & center, int _owner)
  : cannon_in (center, _owner)
{
  ready = true;
}

big_cannon::big_cannon()
{
  ready = true;
}

void big_cannon::set_ready (bool rd)
{
  ready = rd;
}

bool big_cannon::is_ready () const
{
  return ready;
}

game_obj::game_obj (const coord &_position, int _owner)
{
  position = _position;
  owner = _owner;
  age = 0;
}

game_obj::game_obj()
{
  position = coord::pc(0,0);
  owner = 0;
  age = 0;
}

moving_game_obj::moving_game_obj(const coord &_start_pos, const coord &_dest_pos, int _owner, int _alt, double _speed)
  : game_obj (_start_pos, _owner)
{
  start_pos = _start_pos;
  dest_pos = _dest_pos;
  alt = _alt;
  speed = _speed;
  landed = false;
}
moving_game_obj::moving_game_obj()
{
  start_pos = coord::pc(0,0);
  dest_pos = coord::pc(0,0);
  alt = 0;
  speed = 0.0;
  landed = false;
}

void moving_game_obj::move (Uint32 time)
{
  age += time;

  //  printf ("pos %d %d dest %d %d\n", position.x, position.y, dest_pos.x, dest_pos.y);
  if (position == dest_pos)
	{
	  landed = true;
	  alt = 0;
	  speed = 0.0;
	  return;
	}
  coord route = dest_pos - start_pos;
  double l = route.len();

  coord tmp = dest_pos - position;

  double dx = route.getPX() / l;
  double dy = route.getPY() / l;

  //  printf ("dx %f dy %f\n", dx, dy);
  position.setPX((int) (start_pos.getPX() + (dx * (double) age * speed)));
  position.setPY((int) (start_pos.getPY() + (dy * (double) age * speed)));
  //printf ("start_pos %d %d\n", start_pos.x, start_pos.y);
  //printf ("new pos %d %d\n", position.x, position.y);
  //  printf ("age %d speed %f\n", age, speed);
  // check if we have reached dest.
  if ((dest_pos.getPX() > start_pos.getPX() && position.getPX() > dest_pos.getPX()) ||
	  (dest_pos.getPX() < start_pos.getPX() && position.getPX() < dest_pos.getPX()))
	{
	  position.setPX(dest_pos.getPX());
	}
  if ((dest_pos.getPY() > start_pos.getPY() && position.getPY() > dest_pos.getPY()) ||
	  (dest_pos.getPY() < start_pos.getPY() && position.getPY() < dest_pos.getPY()))
	{
	  position.setPY(dest_pos.getPY());
	}
  route = dest_pos - start_pos;
  l = route.len();

  tmp = dest_pos - position;
  int pros_done = (int) (100.0 * (1.0 - (tmp.len() / l)));
  if (pros_done < 50)
	alt = pros_done;
  else
	alt = 100 - pros_done;

}

bool moving_game_obj::is_finished() const
{
  return landed;
}

const coord & moving_game_obj::get_start_position() const
{
  return start_pos;
}

ammo::ammo (const coord &_start, const coord &_dest, int _owner, int _size)
  :moving_game_obj (_start, _dest, _owner, 0, DEFAULT_AMMO_SPEED*_size)
{
  size=_size;
}

int ammo::get_size()
{
  return size;
}

ammo::ammo()
{  
}

moving_game_obj & moving_game_obj::operator= (const moving_game_obj & other)
{
  position = other.position;
  age = other.age;
  owner = other.owner;
  start_pos = other.start_pos;
  dest_pos = other.dest_pos;
  alt = other.alt;
  speed = other.speed;
  landed = other.landed;
  return *this;
}

text_object::text_object(const coord &pos, int owner, const string &_text, Uint32 _duration)
  : game_obj(pos, owner)
{
  text = _text;
  duration = _duration;
  color.r = 0xff;
  color.g = 0xff;
  color.b = 0xff;
  color.unused = 1;
}

text_object::text_object(const coord &pos, int owner, const string &_text, Uint32 _duration, Uint8 red, Uint8 green, Uint8 blue)
  : game_obj(pos, owner)
{
  text = _text;
  duration = _duration;
  color.r = red;
  color.g = green;
  color.b = blue;
  color.unused = 0;
  age =0;
}
text_object::text_object(const coord &pos, int owner, const string &_text, Uint32 _duration, SDL_Color _col)
  : game_obj(pos, owner)
{
  text = string(_text);
  duration = _duration;
  color = _col;
  age = 0;
}

text_object::text_object (text_object &to)
{
  text = string(to.text);
  duration = to.duration;
  color = to.color;
  position = to.position;
  owner = to.owner;
  age = to.age;
}

text_object::text_object(int owner, const string &_text, Uint32 _duration)
  : game_obj(coord::tc(-1,-1), owner)
{
  text = string(_text);
  duration = _duration;
  color.r = 0xff;
  color.g = 0xff;
  color.b = 0xff;
  color.unused = 1;
}

text_object::text_object(int owner, const string &_text, SDL_Color col, Uint32 _duration)
  : game_obj(coord::tc(-1,-1), owner)
{
  text = string(_text);
  duration = _duration;
  color = col;
}

bool text_object::has_unknown_position() const
{
  return (get_position() == coord::tc(-1,-1));
}

const string & text_object::get_text() const
{
  return text;
}

bool text_object::is_color_set() const
{
	return (!color.unused?true:false);
}

SDL_Color &text_object::get_color()
{
	return color;
}

bool text_object::is_finished() const
{
  return age >= duration;
}

void game_obj::move(Uint32 time)
{
  age += time;
}

text_object::~text_object()
{

}

bool cannon::is_finished() const
{
  return false;
}

bool big_cannon::is_finished() const
{
  return false;
}
