/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.border;

import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.border.Border;
import net.yura.mobile.gui.components.Component;

public class LineBorder
implements Border {
    private int color;
    private int thickness;
    private int stroke;
    private int insideColor;
    private boolean roundedCorners;

    public LineBorder() {
        this(-16777216);
    }

    public LineBorder(int c) {
        this(c, 1);
    }

    public LineBorder(int c, int t) {
        this(c, 0, t, false);
    }

    public LineBorder(int c, int c2, int t, boolean r) {
        this(c, c2, t, r, 0);
    }

    public LineBorder(int c, int c2, int t, boolean r, int s) {
        this.color = c;
        this.thickness = t;
        this.stroke = s;
        this.insideColor = c2;
        this.roundedCorners = r;
    }

    public void paintBorder(Component c, Graphics2D g, int width, int height) {
        if (!this.roundedCorners) {
            g.setColor(this.color);
            if (this.thickness == 1) {
                int oldStroke = g.getStrokeStyle();
                g.setStrokeStyle(this.stroke);
                g.drawRect(-1, -1, width + 1, height + 1);
                g.setStrokeStyle(oldStroke);
            } else {
                g.fillRect(-this.thickness, -this.thickness, width + this.thickness * 2, this.thickness);
                g.fillRect(-this.thickness, height, width + this.thickness * 2, this.thickness);
                g.fillRect(-this.thickness, 0, this.thickness, height);
                g.fillRect(width, 0, this.thickness, height);
            }
        } else {
            int a = this.thickness * 4;
            if (this.insideColor != 0) {
                g.setColor(this.insideColor);
                g.fillRoundRect(-this.thickness, -this.thickness, width + 2 * this.thickness - 1, height + 2 * this.thickness - 1, a, a);
            }
            g.setColor(this.color);
            g.drawRoundRect(-this.thickness, -this.thickness, width + 2 * this.thickness - 1, height + 2 * this.thickness - 1, a, a);
        }
    }

    public int getBottom() {
        return this.thickness;
    }

    public int getLeft() {
        return this.thickness;
    }

    public int getRight() {
        return this.thickness;
    }

    public int getTop() {
        return this.thickness;
    }

    public int getLineColor() {
        return this.color;
    }

    public void setLineColor(int color) {
        this.color = color;
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setThickness(int thickness) {
        this.thickness = thickness;
    }

    public boolean isBorderOpaque() {
        return false;
    }
}

