/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.layout;

import java.util.Vector;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.layout.Layout;

public class GridLayout
implements Layout {
    private int across;
    private int padding;
    private int down;

    public GridLayout(int rows, int cols) {
        this(rows, cols, DesktopPane.getDesktopPane().defaultSpace);
    }

    public GridLayout(int rows, int cols, int p) {
        this.across = cols;
        this.down = rows;
        this.padding = p;
    }

    public void layoutPanel(Panel panel) {
        Vector components = panel.getComponents();
        int ac = this.getCols(components);
        int de = this.getRows(components);
        if (ac == 0 || de == 0) {
            return;
        }
        int cwidth = (panel.getWidth() - ac * this.padding - this.padding) / ac;
        int cheight = (panel.getHeight() - de * this.padding - this.padding) / de;
        int a = 0;
        int d = 0;
        for (int i = 0; i < components.size(); ++i) {
            Component comp = (Component)components.elementAt(i);
            if (!comp.isVisible()) continue;
            comp.setBoundsWithBorder(a * cwidth + this.padding + this.padding * a, d * cheight + this.padding + this.padding * d, cwidth, cheight);
            if (++a != ac || i == components.size() - 1) continue;
            a = 0;
            ++d;
        }
    }

    public int getPreferredHeight(Panel panel) {
        Vector components = panel.getComponents();
        int cheight = 0;
        int de = this.getRows(components);
        for (int i = 0; i < components.size(); ++i) {
            Component comp = (Component)components.elementAt(i);
            if (!comp.isVisible() || comp.getHeightWithBorder() <= cheight) continue;
            cheight = comp.getHeightWithBorder();
        }
        return de * cheight + de * this.padding + this.padding;
    }

    public int getPreferredWidth(Panel panel) {
        Vector components = panel.getComponents();
        int cwidth = 0;
        int ac = this.getCols(components);
        for (int i = 0; i < components.size(); ++i) {
            Component comp = (Component)components.elementAt(i);
            if (!comp.isVisible() || comp.getWidthWithBorder() <= cwidth) continue;
            cwidth = comp.getWidthWithBorder();
        }
        return ac * cwidth + ac * this.padding + this.padding;
    }

    private int getCols(Vector components) {
        int ac;
        int count = this.getComponentsCount(components);
        if (count < (ac = this.across != 0 ? this.across : (count + (this.down - 1)) / this.down)) {
            ac = count;
        }
        return ac;
    }

    private int getRows(Vector components) {
        int de;
        int count = this.getComponentsCount(components);
        if (count < (de = this.down != 0 ? this.down : (count + (this.across - 1)) / this.across)) {
            de = count;
        }
        return de;
    }

    private int getComponentsCount(Vector components) {
        int count = 0;
        for (int c = 0; c < components.size(); ++c) {
            if (!((Component)components.elementAt(c)).isVisible()) continue;
            ++count;
        }
        return count;
    }
}

