/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.tools.mapeditor;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.util.Map;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.event.MouseInputListener;
import net.yura.domination.engine.core.Country;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.tools.mapeditor.MapEditor;

public class MapEditorPanel
extends JPanel
implements MouseInputListener,
MouseWheelListener {
    public static final int MODE_MOVE = 0;
    public static final int MODE_MOVEALL = 1;
    public static final int MODE_JOIN = 2;
    public static final int MODE_JOIN1WAY = 3;
    public static final int MODE_DISJOIN = 4;
    public static final int MODE_DRAW = 5;
    private RiskGame myMap;
    private BufferedImage pic;
    private BufferedImage map;
    private BufferedImage drawImage;
    private Country selected;
    private Rectangle box;
    private int mode;
    private int brush;
    private float alpha;
    private Point dragpoint;
    private int zoom;
    private MapEditor editor;
    int badness;
    private boolean xdrag;

    public MapEditorPanel(MapEditor a) {
        this.editor = a;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        this.mode = 0;
    }

    public BufferedImage getImageMap() {
        return this.map;
    }

    public BufferedImage getImagePic() {
        return this.pic;
    }

    public void zoom(int a) {
        this.zoom = a;
        if (this.pic != null) {
            Dimension size = new Dimension(this.pic.getWidth() * this.zoom, this.pic.getHeight() * this.zoom);
            this.setPreferredSize(size);
            this.setMinimumSize(size);
            this.setMaximumSize(size);
            this.revalidate();
            this.repaint();
        }
    }

    public void setImagePic(BufferedImage a, boolean checkmap) {
        int result;
        this.pic = a;
        if (a.getWidth() != 677 || a.getHeight() != 425) {
            // empty if block
        }
        if (checkmap && (this.pic.getWidth() != this.map.getWidth() || this.pic.getHeight() != this.map.getHeight()) && (result = JOptionPane.showConfirmDialog(this, "The image size does not match the size of the imgmap, would you like to update the imgmap size?", "?", 0)) == 0) {
            BufferedImage newmap = new BufferedImage(this.pic.getWidth(), this.pic.getHeight(), this.map.getType());
            Graphics g = newmap.getGraphics();
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, newmap.getWidth(), newmap.getHeight());
            g.drawImage(this.map, 0, 0, this);
            g.dispose();
            this.setImageMap(newmap);
        }
        this.zoom(this.zoom);
    }

    public void setImageMap(BufferedImage a) {
        if (a.getWidth() != this.pic.getWidth() || a.getHeight() != this.pic.getHeight()) {
            JOptionPane.showMessageDialog(this, "ImageMap does not match ImagePic size!\nPIC: " + this.pic.getWidth() + "x" + this.pic.getHeight() + "\n" + "MAP: " + a.getWidth() + "x" + a.getHeight() + "\n" + "They should match for the game to work!");
        }
        this.map = a;
        this.drawImage = new BufferedImage(a.getWidth(), a.getHeight(), 12, new IndexColorModel(1, 2, new byte[]{0, -1}, new byte[]{0, 0}, new byte[]{0, 0}, 0));
        this.box = new Rectangle(new Dimension(a.getWidth(), a.getHeight()));
    }

    public void setMap(RiskGame a) {
        this.myMap = a;
    }

    public void update(Map a) {
        int width = this.map.getWidth();
        int height = this.map.getHeight();
        int[] pixels = this.map.getRGB(0, 0, width, height, null, 0, width);
        for (int c = 0; c < pixels.length; ++c) {
            int newcolor;
            int oldcolor = pixels[c] & 0xFF;
            Object obj = a.get(new Integer(oldcolor));
            if (obj != null) {
                newcolor = (Integer)obj;
            } else {
                newcolor = oldcolor;
                System.out.println("bad color: " + oldcolor);
            }
            pixels[c] = (newcolor & 0xFF) << 16 | (newcolor & 0xFF) << 8 | (newcolor & 0xFF) << 0;
        }
        this.map.setRGB(0, 0, width, height, pixels, 0, width);
        this.repaint();
    }

    public void setCountry(Country a) {
        if (this.selected != a) {
            this.selected = a;
            this.repaintSelected();
        }
    }

    public void repaintSelected() {
        int width = this.map.getWidth();
        int height = this.map.getHeight();
        int[] pixels1 = this.map.getRGB(0, 0, width, height, null, 0, width);
        int[] pixels2 = this.drawImage.getRGB(0, 0, width, height, null, 0, width);
        int redColor = Color.RED.getRGB();
        for (int c = 0; c < pixels1.length; ++c) {
            pixels2[c] = this.selected != null && this.selected.getColor() == (pixels1[c] & 0xFF) ? redColor : 0;
        }
        this.drawImage.setRGB(0, 0, width, height, pixels2, 0, width);
        this.repaint();
    }

    public void setAlpha(int a) {
        this.alpha = (float)a / 100.0f;
    }

    public void setBrush(int a) {
        this.brush = a == 0 ? 1 : a;
    }

    public void setMode(int a) {
        this.mode = a;
        this.dragpoint = null;
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g0 = (Graphics2D)g;
        g0.scale(this.zoom, this.zoom);
        if (this.myMap != null) {
            if (this.alpha != 1.0f) {
                g.drawImage(this.pic, 0, 0, this);
                this.drawCountries(g);
            }
            if (this.alpha != 0.0f) {
                Graphics2D g2 = (Graphics2D)g.create();
                AlphaComposite ac = AlphaComposite.getInstance(3, this.alpha);
                g2.setComposite(ac);
                g2.drawImage((Image)this.map, 0, 0, this);
                g2.drawImage((Image)this.drawImage, 0, 0, this);
            }
            if (this.mode == 5 && this.dragpoint != null) {
                g.setXORMode(Color.WHITE);
                g.setColor(Color.BLACK);
                g.drawOval(this.dragpoint.x - this.brush / 2, this.dragpoint.y - this.brush / 2, this.brush, this.brush);
                g.setPaintMode();
            }
        }
    }

    private void drawCountries(Graphics g) {
        long time = System.currentTimeMillis();
        int d = this.myMap.getCircleSize();
        int width = this.pic.getWidth();
        Country[] countries = this.myMap.getCountries();
        for (int i = 0; i < countries.length; ++i) {
            boolean doXor;
            Country n = countries[i];
            int x = n.getX();
            int y = n.getY();
            g.setColor(new Color(n.getContinent().getColor()));
            int r = d / 2;
            g.fillOval(x - r, y - r, d, d);
            Vector ney = n.getNeighbours();
            for (int j = 0; j < ney.size(); ++j) {
                Country n1 = (Country)ney.get(j);
                int x1 = n1.getX();
                int y1 = n1.getY();
                if (n1.getNeighbours().contains(n)) {
                    g.setColor(Color.BLUE);
                } else {
                    g.setColor(Color.GREEN);
                }
                if (Math.abs(x - x1) > width / 2) {
                    if (x > width / 2) {
                        g.drawLine(x, y, x1 + width, y1);
                        g.drawLine(x - width, y, x1, y1);
                        continue;
                    }
                    g.drawLine(x, y, x1 - width, y1);
                    g.drawLine(x + width, y, x1, y1);
                    continue;
                }
                g.drawLine(x, y, x1, y1);
            }
            if (this.selected == n) {
                g.setColor(Color.RED);
            } else {
                g.setColor(Color.BLUE);
            }
            g.drawRect(x - 2, y - 2, 4, 4);
            g.drawRect(x - 3, y - 3, 6, 6);
            boolean bl = doXor = this.badness < 5;
            if (doXor) {
                g.setXORMode(Color.WHITE);
            }
            g.setColor(Color.BLACK);
            g.drawString(n.getIdString(), x, y);
            g.drawString(String.valueOf(i + 1), x, y + 10);
            if (!doXor) continue;
            g.setPaintMode();
        }
        long timeTaken = System.currentTimeMillis() - time;
        if (timeTaken > 100L) {
            System.out.println("XORMode Badness: " + timeTaken);
            ++this.badness;
        }
    }

    public boolean contains(int x, int y) {
        if (this.myMap != null) {
            Country mynode = this.getCountryAt(x / this.zoom, y / this.zoom);
            if (mynode != null) {
                String show = "<html><b>" + mynode.getIdString() + " (" + mynode.getColor() + ")</b><br>Location: (x=" + mynode.getX() + ",y=" + mynode.getY() + ")<br>" + "Continent: " + mynode.getContinent();
                Vector ney = mynode.getNeighbours();
                for (int j = 0; j < ney.size(); ++j) {
                    Country n1 = (Country)ney.get(j);
                    show = show + "<br>Neighbour: " + n1.getIdString() + " (" + n1.getColor() + ")";
                }
                show = show + "</html>";
                this.setToolTipText(show);
            } else {
                this.setToolTipText(null);
            }
            return true;
        }
        return false;
    }

    public void drawLine(Point a, Point b, boolean draw) {
        if (this.selected != null || !draw) {
            if (a.y > b.y) {
                Point z = a;
                a = b;
                b = z;
            }
            Graphics2D g1 = (Graphics2D)this.drawImage.getGraphics();
            Graphics2D g2 = (Graphics2D)this.map.getGraphics();
            BasicStroke bs = new BasicStroke(this.brush, 1, 1);
            g1.setStroke(bs);
            g2.setStroke(bs);
            if (draw) {
                g1.setColor(Color.RED);
                g2.setColor(new Color(this.selected.getColor(), this.selected.getColor(), this.selected.getColor()));
            } else {
                g1.setColor(Color.BLACK);
                g2.setColor(Color.WHITE);
            }
            g1.drawLine(a.x, a.y, b.x, b.y);
            g2.drawLine(a.x, a.y, b.x, b.y);
            g1.dispose();
            g2.dispose();
        }
    }

    public Country getCountryAt(int x, int y) {
        Country[] countries = this.myMap.getCountries();
        int size = 4;
        Country mynode = null;
        for (int i = 0; i < countries.length; ++i) {
            Country n = countries[i];
            int x1 = n.getX();
            int y1 = n.getY();
            if (x1 < x - size || y1 < y - size || x1 > x + size || y1 > y + size) continue;
            mynode = n;
            break;
        }
        return mynode;
    }

    public Point getPoint(MouseEvent e) {
        return new Point(e.getX() / this.zoom, e.getY() / this.zoom);
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getWheelRotation() < 0) {
            this.editor.zoom(true);
        } else {
            this.editor.zoom(false);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this.myMap != null) {
            Point point = this.getPoint(e);
            if ((e.getModifiers() & 4) == 4) {
                if (this.mode != 5) {
                    this.setCountry(null);
                }
            } else if ((e.getModifiers() & 0x10) == 16) {
                if (this.mode == 2) {
                    Country mynode = this.getCountryAt(point.x, point.y);
                    if (mynode != null && this.selected == null) {
                        this.setCountry(mynode);
                    } else if (mynode != null && mynode == this.selected) {
                        this.setCountry(null);
                    } else if (mynode != null) {
                        if (!this.selected.getNeighbours().contains(mynode)) {
                            this.selected.addNeighbour(mynode);
                        }
                        if (!mynode.getNeighbours().contains(this.selected)) {
                            mynode.addNeighbour(this.selected);
                        }
                        this.repaint();
                    }
                } else if (this.mode == 3) {
                    Country mynode = this.getCountryAt(point.x, point.y);
                    if (mynode != null && this.selected == null) {
                        this.setCountry(mynode);
                    } else if (mynode != null && mynode == this.selected) {
                        this.setCountry(null);
                    } else if (mynode != null) {
                        if (!this.selected.getNeighbours().contains(mynode)) {
                            this.selected.addNeighbour(mynode);
                        }
                        this.repaint();
                    }
                } else if (this.mode == 4) {
                    Country mynode = this.getCountryAt(point.x, point.y);
                    if (mynode != null && this.selected == null) {
                        this.setCountry(mynode);
                    } else if (mynode != null && mynode == this.selected) {
                        this.setCountry(null);
                    } else if (mynode != null) {
                        if (this.selected.getNeighbours().contains(mynode)) {
                            this.selected.getNeighbours().remove(mynode);
                        }
                        if (mynode.getNeighbours().contains(this.selected)) {
                            mynode.getNeighbours().remove(this.selected);
                        }
                        this.repaint();
                    }
                }
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.myMap != null && ((e.getModifiers() & 0x10) == 16 || (e.getModifiers() & 4) == 4)) {
            Point point = this.getPoint(e);
            if (this.mode == 0) {
                Country mynode = this.getCountryAt(point.x, point.y);
                if (mynode != null) {
                    this.setCountry(mynode);
                    this.xdrag = true;
                } else {
                    this.dragpoint = e.getPoint();
                    this.xdrag = false;
                }
            } else if (this.mode == 1) {
                this.dragpoint = point;
            } else if (this.mode == 5) {
                this.dragpoint = point;
                this.drawLine(this.dragpoint, this.dragpoint, (e.getModifiers() & 0x10) == 16);
                this.repaint();
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.mode == 0) {
            this.dragpoint = null;
        } else if (this.mode == 1) {
            this.dragpoint = null;
        } else if (this.mode == 5 && !this.getVisibleRect().contains(e.getPoint())) {
            this.dragpoint = null;
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.myMap != null) {
            Point point = this.getPoint(e);
            if (this.mode == 0) {
                if (this.xdrag && this.box != null && this.selected != null && this.box.contains(point.x, point.y)) {
                    this.selected.setX(point.x);
                    this.selected.setY(point.y);
                    this.scrollRectToVisible(new Rectangle(e.getX(), e.getY(), 1, 1));
                    this.repaint();
                } else if (!this.xdrag && this.dragpoint != null) {
                    Rectangle r = this.getVisibleRect();
                    r.translate(this.dragpoint.x - e.getX(), this.dragpoint.y - e.getY());
                    this.scrollRectToVisible(r);
                }
            } else if (this.mode == 1 && this.dragpoint != null) {
                int xdif = point.x - this.dragpoint.x;
                int ydif = point.y - this.dragpoint.y;
                Country[] countries = this.myMap.getCountries();
                for (int i = 0; i < countries.length; ++i) {
                    countries[i].setX(countries[i].getX() + xdif);
                    countries[i].setY(countries[i].getY() + ydif);
                }
                this.dragpoint = point;
                this.repaint();
            } else if (this.mode == 5 && this.dragpoint != null) {
                Point end = point;
                if ((e.getModifiers() & 0x10) == 16 || (e.getModifiers() & 4) == 4) {
                    this.drawLine(this.dragpoint, end, (e.getModifiers() & 0x10) == 16);
                }
                this.dragpoint = end;
                this.repaint();
            }
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.mode == 5 && (e.getModifiers() & 0x10) != 16 && (e.getModifiers() & 4) != 4) {
            this.dragpoint = null;
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (this.mode == 5) {
            this.dragpoint = this.getPoint(e);
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }
}

