// Copyright 2020-2022 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-apiclientgrpc. DO NOT EDIT.

package registryv1alpha1apiclientgrpc

import (
	context "context"
	v1alpha1 "github.com/bufbuild/buf/private/gen/proto/go/buf/alpha/registry/v1alpha1"
	zap "go.uber.org/zap"
)

type repositoryTrackService struct {
	logger          *zap.Logger
	client          v1alpha1.RepositoryTrackServiceClient
	contextModifier func(context.Context) context.Context
}

// CreateRepositoryTrack creates a new repository track.
func (s *repositoryTrackService) CreateRepositoryTrack(
	ctx context.Context,
	repositoryId string,
	name string,
) (repositoryTrack *v1alpha1.RepositoryTrack, _ error) {
	if s.contextModifier != nil {
		ctx = s.contextModifier(ctx)
	}
	response, err := s.client.CreateRepositoryTrack(
		ctx,
		&v1alpha1.CreateRepositoryTrackRequest{
			RepositoryId: repositoryId,
			Name:         name,
		},
	)
	if err != nil {
		return nil, err
	}
	return response.RepositoryTrack, nil
}

// ListRepositoryTracks lists the repository tracks associated with a repository.
func (s *repositoryTrackService) ListRepositoryTracks(
	ctx context.Context,
	repositoryId string,
	pageSize uint32,
	pageToken string,
	reverse bool,
) (repositoryTracks []*v1alpha1.RepositoryTrack, nextPageToken string, _ error) {
	if s.contextModifier != nil {
		ctx = s.contextModifier(ctx)
	}
	response, err := s.client.ListRepositoryTracks(
		ctx,
		&v1alpha1.ListRepositoryTracksRequest{
			RepositoryId: repositoryId,
			PageSize:     pageSize,
			PageToken:    pageToken,
			Reverse:      reverse,
		},
	)
	if err != nil {
		return nil, "", err
	}
	return response.RepositoryTracks, response.NextPageToken, nil
}

// DeleteRepositoryTrackByName deletes a repository track by name.
func (s *repositoryTrackService) DeleteRepositoryTrackByName(
	ctx context.Context,
	ownerName string,
	repositoryName string,
	name string,
) (_ error) {
	if s.contextModifier != nil {
		ctx = s.contextModifier(ctx)
	}
	_, err := s.client.DeleteRepositoryTrackByName(
		ctx,
		&v1alpha1.DeleteRepositoryTrackByNameRequest{
			OwnerName:      ownerName,
			RepositoryName: repositoryName,
			Name:           name,
		},
	)
	if err != nil {
		return err
	}
	return nil
}

// GetRepositoryTrackByName gets a repository track by name.
func (s *repositoryTrackService) GetRepositoryTrackByName(
	ctx context.Context,
	ownerName string,
	repositoryName string,
	name string,
) (repositoryTrack *v1alpha1.RepositoryTrack, _ error) {
	if s.contextModifier != nil {
		ctx = s.contextModifier(ctx)
	}
	response, err := s.client.GetRepositoryTrackByName(
		ctx,
		&v1alpha1.GetRepositoryTrackByNameRequest{
			OwnerName:      ownerName,
			RepositoryName: repositoryName,
			Name:           name,
		},
	)
	if err != nil {
		return nil, err
	}
	return response.RepositoryTrack, nil
}

// ListRepositoryTracksByRepositoryCommit lists the repository tracks associated with a repository commit.
func (s *repositoryTrackService) ListRepositoryTracksByRepositoryCommit(
	ctx context.Context,
	repositoryId string,
	commit string,
	pageSize uint32,
	pageToken string,
	reverse bool,
) (repositoryTracks []*v1alpha1.RepositoryTrack, nextPageToken string, _ error) {
	if s.contextModifier != nil {
		ctx = s.contextModifier(ctx)
	}
	response, err := s.client.ListRepositoryTracksByRepositoryCommit(
		ctx,
		&v1alpha1.ListRepositoryTracksByRepositoryCommitRequest{
			RepositoryId: repositoryId,
			Commit:       commit,
			PageSize:     pageSize,
			PageToken:    pageToken,
			Reverse:      reverse,
		},
	)
	if err != nil {
		return nil, "", err
	}
	return response.RepositoryTracks, response.NextPageToken, nil
}
