/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha2

// ResourceClaimStatusApplyConfiguration represents an declarative configuration of the ResourceClaimStatus type for use
// with apply.
type ResourceClaimStatusApplyConfiguration struct {
	DriverName            *string                                            `json:"driverName,omitempty"`
	Allocation            *AllocationResultApplyConfiguration                `json:"allocation,omitempty"`
	ReservedFor           []ResourceClaimConsumerReferenceApplyConfiguration `json:"reservedFor,omitempty"`
	DeallocationRequested *bool                                              `json:"deallocationRequested,omitempty"`
}

// ResourceClaimStatusApplyConfiguration constructs an declarative configuration of the ResourceClaimStatus type for use with
// apply.
func ResourceClaimStatus() *ResourceClaimStatusApplyConfiguration {
	return &ResourceClaimStatusApplyConfiguration{}
}

// WithDriverName sets the DriverName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DriverName field is set to the value of the last call.
func (b *ResourceClaimStatusApplyConfiguration) WithDriverName(value string) *ResourceClaimStatusApplyConfiguration {
	b.DriverName = &value
	return b
}

// WithAllocation sets the Allocation field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Allocation field is set to the value of the last call.
func (b *ResourceClaimStatusApplyConfiguration) WithAllocation(value *AllocationResultApplyConfiguration) *ResourceClaimStatusApplyConfiguration {
	b.Allocation = value
	return b
}

// WithReservedFor adds the given value to the ReservedFor field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the ReservedFor field.
func (b *ResourceClaimStatusApplyConfiguration) WithReservedFor(values ...*ResourceClaimConsumerReferenceApplyConfiguration) *ResourceClaimStatusApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithReservedFor")
		}
		b.ReservedFor = append(b.ReservedFor, *values[i])
	}
	return b
}

// WithDeallocationRequested sets the DeallocationRequested field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DeallocationRequested field is set to the value of the last call.
func (b *ResourceClaimStatusApplyConfiguration) WithDeallocationRequested(value bool) *ResourceClaimStatusApplyConfiguration {
	b.DeallocationRequested = &value
	return b
}
