/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2022 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

using Gtk;

namespace PreferencesDialog
{
    public void fill (Tepl.PrefsDialog prefs_dialog)
    {
        // reset all button
        Button reset_button = new Button.with_mnemonic (_("_Reset All"));
        reset_button.set_tooltip_text (_("Reset all preferences"));
        reset_button.show_all ();
        reset_button.clicked.connect (reset_all);
        HeaderBar headerbar = prefs_dialog.get_header_bar () as HeaderBar;
        headerbar.pack_start (reset_button);

        // content
        Gtk.Box content_area = prefs_dialog.get_content_area () as Gtk.Box;
        content_area.pack_start (Latexila.prefs_create_notebook ());
    }

    private void reset_all ()
    {
        Tepl.PrefsDialog prefs_dialog = Tepl.PrefsDialog.get_singleton ();

        Dialog dialog = new MessageDialog (prefs_dialog, DialogFlags.DESTROY_WITH_PARENT,
            MessageType.QUESTION, ButtonsType.NONE,
            "%s", _("Do you really want to reset all preferences?"));

        dialog.add_button (_("_Cancel"), ResponseType.CANCEL);
        dialog.add_button (_("_Reset All"), ResponseType.YES);

        int resp = dialog.run ();
        dialog.destroy ();
        if (resp != ResponseType.YES)
            return;

        string[] settings_str =
        {
            "org.gnome.gnome-latex.preferences.editor",
            "org.gnome.gnome-latex.preferences.latex"
        };

        foreach (string setting_str in settings_str)
        {
            GLib.Settings settings = new GLib.Settings (setting_str);
            string[] keys = settings.list_keys ();
            foreach (string key in keys)
                settings.reset (key);
        }
    }
}
