/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iot.control;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.iot.IoTManager;
import org.jivesoftware.smackx.iot.Thing;
import org.jivesoftware.smackx.iot.control.ThingControlRequest;
import org.jivesoftware.smackx.iot.control.element.IoTSetRequest;
import org.jivesoftware.smackx.iot.control.element.IoTSetResponse;
import org.jivesoftware.smackx.iot.control.element.SetData;
import org.jivesoftware.smackx.iot.element.NodeInfo;
import org.jxmpp.jid.FullJid;

public final class IoTControlManager
extends IoTManager {
    private static final Map<XMPPConnection, IoTControlManager> INSTANCES = new WeakHashMap<XMPPConnection, IoTControlManager>();
    private final Map<NodeInfo, Thing> things = new ConcurrentHashMap<NodeInfo, Thing>();

    public static synchronized IoTControlManager getInstanceFor(XMPPConnection connection) {
        IoTControlManager manager = INSTANCES.get(connection);
        if (manager == null) {
            manager = new IoTControlManager(connection);
            INSTANCES.put(connection, manager);
        }
        return manager;
    }

    private IoTControlManager(XMPPConnection connection) {
        super(connection);
        connection.registerIQRequestHandler(new IoTManager.IoTIqRequestHandler("set", "urn:xmpp:iot:control", IQ.Type.set, IQRequestHandler.Mode.async){

            @Override
            public IQ handleIoTIqRequest(IQ iqRequest) {
                IoTSetRequest iotSetRequest = (IoTSetRequest)iqRequest;
                Thing thing = IoTControlManager.this.things.get(NodeInfo.EMPTY);
                if (thing == null) {
                    return null;
                }
                ThingControlRequest controlRequest = thing.getControlRequestHandler();
                if (controlRequest == null) {
                    return null;
                }
                try {
                    controlRequest.processRequest(iotSetRequest.getFrom(), iotSetRequest.getSetData());
                }
                catch (XMPPException.XMPPErrorException e) {
                    return IQ.createErrorResponse((IQ)iotSetRequest, e.getStanzaError());
                }
                return new IoTSetResponse(iotSetRequest);
            }
        });
    }

    public IoTSetResponse setUsingIq(FullJid jid, SetData data) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.setUsingIq(jid, Collections.singleton(data));
    }

    public IoTSetResponse setUsingIq(FullJid jid, Collection<? extends SetData> data) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        IoTSetRequest request = new IoTSetRequest(data);
        request.setTo(jid);
        IoTSetResponse response = (IoTSetResponse)this.connection().sendIqRequestAndWaitForResponse(request);
        return response;
    }

    public void installThing(Thing thing) {
        this.things.put(thing.getNodeInfo(), thing);
    }

    public Thing uninstallThing(Thing thing) {
        return this.uninstallThing(thing.getNodeInfo());
    }

    public Thing uninstallThing(NodeInfo nodeInfo) {
        return this.things.remove(nodeInfo);
    }
}

