/*
 * Decompiled with CFR 0.152.
 */
package os.shaded_org_apache_tools_zip;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.ZipException;
import os.shaded_org_apache_tools_zip.GeneralPurposeBit;
import os.shaded_org_apache_tools_zip.UnicodeCommentExtraField;
import os.shaded_org_apache_tools_zip.UnicodePathExtraField;
import os.shaded_org_apache_tools_zip.Zip64ExtendedInformationExtraField;
import os.shaded_org_apache_tools_zip.Zip64Mode;
import os.shaded_org_apache_tools_zip.Zip64RequiredException;
import os.shaded_org_apache_tools_zip.ZipEightByteInteger;
import os.shaded_org_apache_tools_zip.ZipEncoding;
import os.shaded_org_apache_tools_zip.ZipEncodingHelper;
import os.shaded_org_apache_tools_zip.ZipEntry;
import os.shaded_org_apache_tools_zip.ZipLong;
import os.shaded_org_apache_tools_zip.ZipShort;
import os.shaded_org_apache_tools_zip.ZipUtil;

public class ZipOutputStream
extends FilterOutputStream {
    private static final int BUFFER_SIZE = 512;
    private static final int LFH_SIG_OFFSET = 0;
    private static final int LFH_VERSION_NEEDED_OFFSET = 4;
    private static final int LFH_GPB_OFFSET = 6;
    private static final int LFH_METHOD_OFFSET = 8;
    private static final int LFH_TIME_OFFSET = 10;
    private static final int LFH_CRC_OFFSET = 14;
    private static final int LFH_COMPRESSED_SIZE_OFFSET = 18;
    private static final int LFH_ORIGINAL_SIZE_OFFSET = 22;
    private static final int LFH_FILENAME_LENGTH_OFFSET = 26;
    private static final int LFH_EXTRA_LENGTH_OFFSET = 28;
    private static final int LFH_FILENAME_OFFSET = 30;
    private static final int CFH_SIG_OFFSET = 0;
    private static final int CFH_VERSION_MADE_BY_OFFSET = 4;
    private static final int CFH_VERSION_NEEDED_OFFSET = 6;
    private static final int CFH_GPB_OFFSET = 8;
    private static final int CFH_METHOD_OFFSET = 10;
    private static final int CFH_TIME_OFFSET = 12;
    private static final int CFH_CRC_OFFSET = 16;
    private static final int CFH_COMPRESSED_SIZE_OFFSET = 20;
    private static final int CFH_ORIGINAL_SIZE_OFFSET = 24;
    private static final int CFH_FILENAME_LENGTH_OFFSET = 28;
    private static final int CFH_EXTRA_LENGTH_OFFSET = 30;
    private static final int CFH_COMMENT_LENGTH_OFFSET = 32;
    private static final int CFH_DISK_NUMBER_OFFSET = 34;
    private static final int CFH_INTERNAL_ATTRIBUTES_OFFSET = 36;
    private static final int CFH_EXTERNAL_ATTRIBUTES_OFFSET = 38;
    private static final int CFH_LFH_OFFSET = 42;
    private static final int CFH_FILENAME_OFFSET = 46;
    private boolean finished = false;
    private static final int DEFLATER_BLOCK_SIZE = 8192;
    public static final int DEFLATED = 8;
    public static final int DEFAULT_COMPRESSION = -1;
    public static final int STORED = 0;
    static final String DEFAULT_ENCODING = null;
    @Deprecated
    public static final int EFS_FLAG = 2048;
    private static final byte[] EMPTY = new byte[0];
    private CurrentEntry entry;
    private String comment = "";
    private int level = -1;
    private boolean hasCompressionLevelChanged = false;
    private int method = 8;
    private final List<ZipEntry> entries = new LinkedList<ZipEntry>();
    private final CRC32 crc = new CRC32();
    private long written = 0L;
    private long cdOffset = 0L;
    private long cdLength = 0L;
    private static final byte[] ZERO = new byte[]{0, 0};
    private static final byte[] LZERO = new byte[]{0, 0, 0, 0};
    private static final byte[] ONE = ZipLong.getBytes(1L);
    private final Map<ZipEntry, Long> offsets = new HashMap<ZipEntry, Long>();
    private String encoding = null;
    private ZipEncoding zipEncoding = ZipEncodingHelper.getZipEncoding(DEFAULT_ENCODING);
    protected final Deflater def = new Deflater(this.level, true);
    protected byte[] buf = new byte[512];
    private final RandomAccessFile raf;
    private boolean useUTF8Flag = true;
    private boolean fallbackToUTF8 = false;
    private UnicodeExtraFieldPolicy createUnicodeExtraFields = UnicodeExtraFieldPolicy.NEVER;
    private boolean hasUsedZip64 = false;
    private Zip64Mode zip64Mode = Zip64Mode.AsNeeded;
    private final Calendar calendarInstance = Calendar.getInstance();
    private final byte[] oneByte = new byte[1];
    protected static final byte[] LFH_SIG = ZipLong.LFH_SIG.getBytes();
    protected static final byte[] DD_SIG = ZipLong.DD_SIG.getBytes();
    protected static final byte[] CFH_SIG = ZipLong.CFH_SIG.getBytes();
    protected static final byte[] EOCD_SIG = ZipLong.getBytes(101010256L);
    static final byte[] ZIP64_EOCD_SIG = ZipLong.getBytes(101075792L);
    static final byte[] ZIP64_EOCD_LOC_SIG = ZipLong.getBytes(117853008L);

    public ZipOutputStream(OutputStream outputStream) {
        super(outputStream);
        this.raf = null;
    }

    public ZipOutputStream(File file) throws IOException {
        super(null);
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.setLength(0L);
        }
        catch (IOException iOException) {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                randomAccessFile = null;
            }
            this.out = Files.newOutputStream(file.toPath(), new OpenOption[0]);
        }
        this.raf = randomAccessFile;
    }

    public boolean isSeekable() {
        return this.raf != null;
    }

    public void setEncoding(String string2) {
        this.encoding = string2;
        this.zipEncoding = ZipEncodingHelper.getZipEncoding(string2);
        if (this.useUTF8Flag && !ZipEncodingHelper.isUTF8(string2)) {
            this.useUTF8Flag = false;
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setUseLanguageEncodingFlag(boolean bl) {
        this.useUTF8Flag = bl && ZipEncodingHelper.isUTF8(this.encoding);
    }

    public void setCreateUnicodeExtraFields(UnicodeExtraFieldPolicy unicodeExtraFieldPolicy) {
        this.createUnicodeExtraFields = unicodeExtraFieldPolicy;
    }

    public void setFallbackToUTF8(boolean bl) {
        this.fallbackToUTF8 = bl;
    }

    public void setUseZip64(Zip64Mode zip64Mode) {
        this.zip64Mode = zip64Mode;
    }

    public void finish() throws IOException {
        if (this.finished) {
            throw new IOException("This archive has already been finished");
        }
        if (this.entry != null) {
            this.closeEntry();
        }
        this.cdOffset = this.written;
        this.writeCentralDirectoryInChunks();
        this.cdLength = this.written - this.cdOffset;
        this.writeZip64CentralDirectory();
        this.writeCentralDirectoryEnd();
        this.offsets.clear();
        this.entries.clear();
        this.def.end();
        this.finished = true;
    }

    private void writeCentralDirectoryInChunks() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(70000);
        int n = 0;
        for (ZipEntry zipEntry : this.entries) {
            byteArrayOutputStream.write(this.createCentralFileHeader(zipEntry));
            if (++n <= 1000) continue;
            this.writeCounted(byteArrayOutputStream.toByteArray());
            byteArrayOutputStream.reset();
            n = 0;
        }
        this.writeCounted(byteArrayOutputStream.toByteArray());
    }

    public void closeEntry() throws IOException {
        this.preClose();
        this.flushDeflater();
        Zip64Mode zip64Mode = this.getEffectiveZip64Mode(this.entry.entry);
        long l = this.written - this.entry.dataStart;
        long l2 = this.crc.getValue();
        this.crc.reset();
        boolean bl = this.handleSizesAndCrc(l, l2, zip64Mode);
        this.closeEntry(bl);
    }

    private void closeEntry(boolean bl) throws IOException {
        if (this.raf != null) {
            this.rewriteSizesAndCrc(bl);
        }
        this.writeDataDescriptor(this.entry.entry);
        this.entry = null;
    }

    private void preClose() throws IOException {
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        if (this.entry == null) {
            throw new IOException("No current entry to close");
        }
        if (!this.entry.hasWritten) {
            this.write(EMPTY, 0, 0);
        }
    }

    private void flushDeflater() throws IOException {
        if (this.entry.entry.getMethod() == 8) {
            this.def.finish();
            while (!this.def.finished()) {
                this.deflate();
            }
        }
    }

    private boolean handleSizesAndCrc(long l, long l2, Zip64Mode zip64Mode) throws ZipException {
        if (this.entry.entry.getMethod() == 8) {
            this.entry.entry.setSize(this.entry.bytesRead);
            this.entry.entry.setCompressedSize(l);
            this.entry.entry.setCrc(l2);
            this.def.reset();
        } else if (this.raf == null) {
            if (this.entry.entry.getCrc() != l2) {
                throw new ZipException("bad CRC checksum for entry " + this.entry.entry.getName() + ": " + Long.toHexString(this.entry.entry.getCrc()) + " instead of " + Long.toHexString(l2));
            }
            if (this.entry.entry.getSize() != l) {
                throw new ZipException("bad size for entry " + this.entry.entry.getName() + ": " + this.entry.entry.getSize() + " instead of " + l);
            }
        } else {
            this.entry.entry.setSize(l);
            this.entry.entry.setCompressedSize(l);
            this.entry.entry.setCrc(l2);
        }
        return this.checkIfNeedsZip64(zip64Mode);
    }

    private boolean checkIfNeedsZip64(Zip64Mode zip64Mode) throws ZipException {
        boolean bl = this.isZip64Required(this.entry.entry, zip64Mode);
        if (bl && zip64Mode == Zip64Mode.Never) {
            throw new Zip64RequiredException(Zip64RequiredException.getEntryTooBigMessage(this.entry.entry));
        }
        return bl;
    }

    private boolean isZip64Required(ZipEntry zipEntry, Zip64Mode zip64Mode) {
        return zip64Mode == Zip64Mode.Always || this.isTooLageForZip32(zipEntry);
    }

    private boolean isTooLageForZip32(ZipEntry zipEntry) {
        return zipEntry.getSize() >= 0xFFFFFFFFL || zipEntry.getCompressedSize() >= 0xFFFFFFFFL;
    }

    private void rewriteSizesAndCrc(boolean bl) throws IOException {
        long l = this.raf.getFilePointer();
        this.raf.seek(this.entry.localDataStart);
        this.writeOut(ZipLong.getBytes(this.entry.entry.getCrc()));
        if (!this.hasZip64Extra(this.entry.entry) || !bl) {
            this.writeOut(ZipLong.getBytes(this.entry.entry.getCompressedSize()));
            this.writeOut(ZipLong.getBytes(this.entry.entry.getSize()));
        } else {
            this.writeOut(ZipLong.ZIP64_MAGIC.getBytes());
            this.writeOut(ZipLong.ZIP64_MAGIC.getBytes());
        }
        if (this.hasZip64Extra(this.entry.entry)) {
            this.raf.seek(this.entry.localDataStart + 12L + 4L + (long)this.getName(this.entry.entry).limit() + 4L);
            this.writeOut(ZipEightByteInteger.getBytes(this.entry.entry.getSize()));
            this.writeOut(ZipEightByteInteger.getBytes(this.entry.entry.getCompressedSize()));
            if (!bl) {
                this.raf.seek(this.entry.localDataStart - 10L);
                this.writeOut(ZipShort.getBytes(10));
                this.entry.entry.removeExtraField(Zip64ExtendedInformationExtraField.HEADER_ID);
                this.entry.entry.setExtra();
                if (this.entry.causedUseOfZip64) {
                    this.hasUsedZip64 = false;
                }
            }
        }
        this.raf.seek(l);
    }

    public void putNextEntry(ZipEntry zipEntry) throws IOException {
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        if (this.entry != null) {
            this.closeEntry();
        }
        this.entry = new CurrentEntry(zipEntry);
        this.entries.add(this.entry.entry);
        this.setDefaults(this.entry.entry);
        Zip64Mode zip64Mode = this.getEffectiveZip64Mode(this.entry.entry);
        this.validateSizeInformation(zip64Mode);
        if (this.shouldAddZip64Extra(this.entry.entry, zip64Mode)) {
            Zip64ExtendedInformationExtraField zip64ExtendedInformationExtraField = this.getZip64Extra(this.entry.entry);
            ZipEightByteInteger zipEightByteInteger = ZipEightByteInteger.ZERO;
            ZipEightByteInteger zipEightByteInteger2 = ZipEightByteInteger.ZERO;
            if (this.entry.entry.getMethod() == 0 && this.entry.entry.getSize() != -1L) {
                zipEightByteInteger2 = zipEightByteInteger = new ZipEightByteInteger(this.entry.entry.getSize());
            }
            zip64ExtendedInformationExtraField.setSize(zipEightByteInteger);
            zip64ExtendedInformationExtraField.setCompressedSize(zipEightByteInteger2);
            this.entry.entry.setExtra();
        }
        if (this.entry.entry.getMethod() == 8 && this.hasCompressionLevelChanged) {
            this.def.setLevel(this.level);
            this.hasCompressionLevelChanged = false;
        }
        this.writeLocalFileHeader(this.entry.entry);
    }

    private void setDefaults(ZipEntry zipEntry) {
        if (zipEntry.getMethod() == -1) {
            zipEntry.setMethod(this.method);
        }
        if (zipEntry.getTime() == -1L) {
            zipEntry.setTime(System.currentTimeMillis());
        }
    }

    private void validateSizeInformation(Zip64Mode zip64Mode) throws ZipException {
        if (this.entry.entry.getMethod() == 0 && this.raf == null) {
            if (this.entry.entry.getSize() == -1L) {
                throw new ZipException("uncompressed size is required for STORED method when not writing to a file");
            }
            if (this.entry.entry.getCrc() == -1L) {
                throw new ZipException("crc checksum is required for STORED method when not writing to a file");
            }
            this.entry.entry.setCompressedSize(this.entry.entry.getSize());
        }
        if ((this.entry.entry.getSize() >= 0xFFFFFFFFL || this.entry.entry.getCompressedSize() >= 0xFFFFFFFFL) && zip64Mode == Zip64Mode.Never) {
            throw new Zip64RequiredException(Zip64RequiredException.getEntryTooBigMessage(this.entry.entry));
        }
    }

    private boolean shouldAddZip64Extra(ZipEntry zipEntry, Zip64Mode zip64Mode) {
        return zip64Mode == Zip64Mode.Always || zipEntry.getSize() >= 0xFFFFFFFFL || zipEntry.getCompressedSize() >= 0xFFFFFFFFL || zipEntry.getSize() == -1L && this.raf != null && zip64Mode != Zip64Mode.Never;
    }

    public void setComment(String string2) {
        this.comment = string2;
    }

    public void setLevel(int n) {
        if (n < -1 || n > 9) {
            throw new IllegalArgumentException("Invalid compression level: " + n);
        }
        if (this.level == n) {
            return;
        }
        this.hasCompressionLevelChanged = true;
        this.level = n;
    }

    public void setMethod(int n) {
        this.method = n;
    }

    public boolean canWriteEntryData(ZipEntry zipEntry) {
        return ZipUtil.canHandleEntryData(zipEntry);
    }

    @Override
    public void write(int n) throws IOException {
        this.oneByte[0] = (byte)(n & 0xFF);
        this.write(this.oneByte, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.entry == null) {
            throw new IllegalStateException("No current entry");
        }
        ZipUtil.checkRequestedFeatures(this.entry.entry);
        this.entry.hasWritten = true;
        if (this.entry.entry.getMethod() == 8) {
            this.writeDeflated(byArray, n, n2);
        } else {
            this.writeCounted(byArray, n, n2);
        }
        this.crc.update(byArray, n, n2);
    }

    private void writeCounted(byte[] byArray) throws IOException {
        this.writeCounted(byArray, 0, byArray.length);
    }

    private void writeCounted(byte[] byArray, int n, int n2) throws IOException {
        this.writeOut(byArray, n, n2);
        this.written += (long)n2;
    }

    private void writeDeflated(byte[] byArray, int n, int n2) throws IOException {
        if (n2 > 0 && !this.def.finished()) {
            this.entry.bytesRead += (long)n2;
            if (n2 <= 8192) {
                this.def.setInput(byArray, n, n2);
                this.deflateUntilInputIsNeeded();
            } else {
                int n3;
                int n4 = n2 / 8192;
                for (n3 = 0; n3 < n4; ++n3) {
                    this.def.setInput(byArray, n + n3 * 8192, 8192);
                    this.deflateUntilInputIsNeeded();
                }
                n3 = n4 * 8192;
                if (n3 < n2) {
                    this.def.setInput(byArray, n + n3, n2 - n3);
                    this.deflateUntilInputIsNeeded();
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.finished) {
            this.finish();
        }
        this.destroy();
    }

    @Override
    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    protected final void deflate() throws IOException {
        int n = this.def.deflate(this.buf, 0, this.buf.length);
        if (n > 0) {
            this.writeCounted(this.buf, 0, n);
        }
    }

    protected void writeLocalFileHeader(ZipEntry zipEntry) throws IOException {
        boolean bl = this.zipEncoding.canEncode(zipEntry.getName());
        ByteBuffer byteBuffer = this.getName(zipEntry);
        if (this.createUnicodeExtraFields != UnicodeExtraFieldPolicy.NEVER) {
            this.addUnicodeExtraFields(zipEntry, bl, byteBuffer);
        }
        byte[] byArray = this.createLocalFileHeader(zipEntry, byteBuffer, bl);
        long l = this.written;
        this.offsets.put(zipEntry, l);
        this.entry.localDataStart = l + 14L;
        this.writeCounted(byArray);
        this.entry.dataStart = this.written;
    }

    private byte[] createLocalFileHeader(ZipEntry zipEntry, ByteBuffer byteBuffer, boolean bl) {
        byte[] byArray = zipEntry.getLocalFileDataExtra();
        int n = byteBuffer.limit() - byteBuffer.position();
        int n2 = 30 + n + byArray.length;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(LFH_SIG, 0, byArray2, 0, 4);
        int n3 = zipEntry.getMethod();
        ZipShort.putShort(this.versionNeededToExtract(n3, this.hasZip64Extra(zipEntry)), byArray2, 4);
        GeneralPurposeBit generalPurposeBit = this.getGeneralPurposeBits(n3, !bl && this.fallbackToUTF8);
        generalPurposeBit.encode(byArray2, 6);
        ZipShort.putShort(n3, byArray2, 8);
        ZipUtil.toDosTime(this.calendarInstance, zipEntry.getTime(), byArray2, 10);
        if (n3 == 8 || this.raf != null) {
            System.arraycopy(LZERO, 0, byArray2, 14, 4);
        } else {
            ZipLong.putLong(zipEntry.getCrc(), byArray2, 14);
        }
        if (this.hasZip64Extra(this.entry.entry)) {
            ZipLong.ZIP64_MAGIC.putLong(byArray2, 18);
            ZipLong.ZIP64_MAGIC.putLong(byArray2, 22);
        } else if (n3 == 8 || this.raf != null) {
            System.arraycopy(LZERO, 0, byArray2, 18, 4);
            System.arraycopy(LZERO, 0, byArray2, 22, 4);
        } else {
            ZipLong.putLong(zipEntry.getSize(), byArray2, 18);
            ZipLong.putLong(zipEntry.getSize(), byArray2, 22);
        }
        ZipShort.putShort(n, byArray2, 26);
        ZipShort.putShort(byArray.length, byArray2, 28);
        System.arraycopy(byteBuffer.array(), byteBuffer.arrayOffset(), byArray2, 30, n);
        System.arraycopy(byArray, 0, byArray2, 30 + n, byArray.length);
        return byArray2;
    }

    private void addUnicodeExtraFields(ZipEntry zipEntry, boolean bl, ByteBuffer byteBuffer) throws IOException {
        String string2;
        if (this.createUnicodeExtraFields == UnicodeExtraFieldPolicy.ALWAYS || !bl) {
            zipEntry.addExtraField(new UnicodePathExtraField(zipEntry.getName(), byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit() - byteBuffer.position()));
        }
        if ((string2 = zipEntry.getComment()) == null || string2.isEmpty()) {
            return;
        }
        if (this.createUnicodeExtraFields == UnicodeExtraFieldPolicy.ALWAYS || !this.zipEncoding.canEncode(string2)) {
            ByteBuffer byteBuffer2 = this.getEntryEncoding(zipEntry).encode(string2);
            zipEntry.addExtraField(new UnicodeCommentExtraField(string2, byteBuffer2.array(), byteBuffer2.arrayOffset(), byteBuffer2.limit() - byteBuffer2.position()));
        }
    }

    protected void writeDataDescriptor(ZipEntry zipEntry) throws IOException {
        if (zipEntry.getMethod() != 8 || this.raf != null) {
            return;
        }
        this.writeCounted(DD_SIG);
        this.writeCounted(ZipLong.getBytes(zipEntry.getCrc()));
        if (!this.hasZip64Extra(zipEntry)) {
            this.writeCounted(ZipLong.getBytes(zipEntry.getCompressedSize()));
            this.writeCounted(ZipLong.getBytes(zipEntry.getSize()));
        } else {
            this.writeCounted(ZipEightByteInteger.getBytes(zipEntry.getCompressedSize()));
            this.writeCounted(ZipEightByteInteger.getBytes(zipEntry.getSize()));
        }
    }

    protected void writeCentralFileHeader(ZipEntry zipEntry) throws IOException {
        byte[] byArray = this.createCentralFileHeader(zipEntry);
        this.writeCounted(byArray);
    }

    private byte[] createCentralFileHeader(ZipEntry zipEntry) throws IOException {
        boolean bl;
        long l = this.offsets.get(zipEntry);
        boolean bl2 = bl = this.hasZip64Extra(zipEntry) || zipEntry.getCompressedSize() >= 0xFFFFFFFFL || zipEntry.getSize() >= 0xFFFFFFFFL || l >= 0xFFFFFFFFL || this.zip64Mode == Zip64Mode.Always;
        if (bl && this.zip64Mode == Zip64Mode.Never) {
            throw new Zip64RequiredException("archive's size exceeds the limit of 4GByte.");
        }
        this.handleZip64Extra(zipEntry, l, bl);
        return this.createCentralFileHeader(zipEntry, this.getName(zipEntry), l, bl);
    }

    private byte[] createCentralFileHeader(ZipEntry zipEntry, ByteBuffer byteBuffer, long l, boolean bl) throws IOException {
        byte[] byArray = zipEntry.getCentralDirectoryExtra();
        String string2 = zipEntry.getComment();
        if (string2 == null) {
            string2 = "";
        }
        ByteBuffer byteBuffer2 = this.getEntryEncoding(zipEntry).encode(string2);
        int n = byteBuffer.limit() - byteBuffer.position();
        int n2 = byteBuffer2.limit() - byteBuffer2.position();
        int n3 = 46 + n + byArray.length + n2;
        byte[] byArray2 = new byte[n3];
        System.arraycopy(CFH_SIG, 0, byArray2, 0, 4);
        ZipShort.putShort(zipEntry.getPlatform() << 8 | (!this.hasUsedZip64 ? 20 : 45), byArray2, 4);
        int n4 = zipEntry.getMethod();
        boolean bl2 = this.zipEncoding.canEncode(zipEntry.getName());
        ZipShort.putShort(this.versionNeededToExtract(n4, bl), byArray2, 6);
        this.getGeneralPurposeBits(n4, !bl2 && this.fallbackToUTF8).encode(byArray2, 8);
        ZipShort.putShort(n4, byArray2, 10);
        ZipUtil.toDosTime(this.calendarInstance, zipEntry.getTime(), byArray2, 12);
        ZipLong.putLong(zipEntry.getCrc(), byArray2, 16);
        if (zipEntry.getCompressedSize() >= 0xFFFFFFFFL || zipEntry.getSize() >= 0xFFFFFFFFL || this.zip64Mode == Zip64Mode.Always) {
            ZipLong.ZIP64_MAGIC.putLong(byArray2, 20);
            ZipLong.ZIP64_MAGIC.putLong(byArray2, 24);
        } else {
            ZipLong.putLong(zipEntry.getCompressedSize(), byArray2, 20);
            ZipLong.putLong(zipEntry.getSize(), byArray2, 24);
        }
        ZipShort.putShort(n, byArray2, 28);
        ZipShort.putShort(byArray.length, byArray2, 30);
        ZipShort.putShort(n2, byArray2, 32);
        System.arraycopy(ZERO, 0, byArray2, 34, 2);
        ZipShort.putShort(zipEntry.getInternalAttributes(), byArray2, 36);
        ZipLong.putLong(zipEntry.getExternalAttributes(), byArray2, 38);
        if (l >= 0xFFFFFFFFL || this.zip64Mode == Zip64Mode.Always) {
            ZipLong.putLong(0xFFFFFFFFL, byArray2, 42);
        } else {
            ZipLong.putLong(Math.min(l, 0xFFFFFFFFL), byArray2, 42);
        }
        System.arraycopy(byteBuffer.array(), byteBuffer.arrayOffset(), byArray2, 46, n);
        int n5 = 46 + n;
        System.arraycopy(byArray, 0, byArray2, n5, byArray.length);
        int n6 = n5 + byArray.length;
        System.arraycopy(byteBuffer2.array(), byteBuffer2.arrayOffset(), byArray2, n6, n2);
        return byArray2;
    }

    private void handleZip64Extra(ZipEntry zipEntry, long l, boolean bl) {
        if (bl) {
            Zip64ExtendedInformationExtraField zip64ExtendedInformationExtraField = this.getZip64Extra(zipEntry);
            if (zipEntry.getCompressedSize() >= 0xFFFFFFFFL || zipEntry.getSize() >= 0xFFFFFFFFL || this.zip64Mode == Zip64Mode.Always) {
                zip64ExtendedInformationExtraField.setCompressedSize(new ZipEightByteInteger(zipEntry.getCompressedSize()));
                zip64ExtendedInformationExtraField.setSize(new ZipEightByteInteger(zipEntry.getSize()));
            } else {
                zip64ExtendedInformationExtraField.setCompressedSize(null);
                zip64ExtendedInformationExtraField.setSize(null);
            }
            if (l >= 0xFFFFFFFFL || this.zip64Mode == Zip64Mode.Always) {
                zip64ExtendedInformationExtraField.setRelativeHeaderOffset(new ZipEightByteInteger(l));
            }
            zipEntry.setExtra();
        }
    }

    protected void writeCentralDirectoryEnd() throws IOException {
        this.writeCounted(EOCD_SIG);
        this.writeCounted(ZERO);
        this.writeCounted(ZERO);
        int n = this.entries.size();
        if (n > 65535 && this.zip64Mode == Zip64Mode.Never) {
            throw new Zip64RequiredException("archive contains more than 65535 entries.");
        }
        if (this.cdOffset > 0xFFFFFFFFL && this.zip64Mode == Zip64Mode.Never) {
            throw new Zip64RequiredException("archive's size exceeds the limit of 4GByte.");
        }
        byte[] byArray = ZipShort.getBytes(Math.min(n, 65535));
        this.writeCounted(byArray);
        this.writeCounted(byArray);
        this.writeCounted(ZipLong.getBytes(Math.min(this.cdLength, 0xFFFFFFFFL)));
        this.writeCounted(ZipLong.getBytes(Math.min(this.cdOffset, 0xFFFFFFFFL)));
        ByteBuffer byteBuffer = this.zipEncoding.encode(this.comment);
        int n2 = byteBuffer.limit() - byteBuffer.position();
        this.writeCounted(ZipShort.getBytes(n2));
        this.writeCounted(byteBuffer.array(), byteBuffer.arrayOffset(), n2);
    }

    @Deprecated
    protected static ZipLong toDosTime(Date date) {
        return ZipUtil.toDosTime(date);
    }

    @Deprecated
    protected static byte[] toDosTime(long l) {
        return ZipUtil.toDosTime(l);
    }

    protected byte[] getBytes(String string2) throws ZipException {
        try {
            ByteBuffer byteBuffer = ZipEncodingHelper.getZipEncoding(this.encoding).encode(string2);
            byte[] byArray = new byte[byteBuffer.limit()];
            System.arraycopy(byteBuffer.array(), byteBuffer.arrayOffset(), byArray, 0, byArray.length);
            return byArray;
        }
        catch (IOException iOException) {
            throw new ZipException("Failed to encode name: " + iOException.getMessage());
        }
    }

    protected void writeZip64CentralDirectory() throws IOException {
        if (this.zip64Mode == Zip64Mode.Never) {
            return;
        }
        if (!(this.hasUsedZip64 || this.cdOffset < 0xFFFFFFFFL && this.cdLength < 0xFFFFFFFFL && this.entries.size() < 65535)) {
            this.hasUsedZip64 = true;
        }
        if (!this.hasUsedZip64) {
            return;
        }
        long l = this.written;
        this.writeOut(ZIP64_EOCD_SIG);
        this.writeOut(ZipEightByteInteger.getBytes(44L));
        this.writeOut(ZipShort.getBytes(45));
        this.writeOut(ZipShort.getBytes(45));
        this.writeOut(LZERO);
        this.writeOut(LZERO);
        byte[] byArray = ZipEightByteInteger.getBytes(this.entries.size());
        this.writeOut(byArray);
        this.writeOut(byArray);
        this.writeOut(ZipEightByteInteger.getBytes(this.cdLength));
        this.writeOut(ZipEightByteInteger.getBytes(this.cdOffset));
        this.writeOut(ZIP64_EOCD_LOC_SIG);
        this.writeOut(LZERO);
        this.writeOut(ZipEightByteInteger.getBytes(l));
        this.writeOut(ONE);
    }

    protected final void writeOut(byte[] byArray) throws IOException {
        this.writeOut(byArray, 0, byArray.length);
    }

    protected final void writeOut(byte[] byArray, int n, int n2) throws IOException {
        if (this.raf != null) {
            this.raf.write(byArray, n, n2);
        } else {
            this.out.write(byArray, n, n2);
        }
    }

    @Deprecated
    protected static long adjustToLong(int n) {
        return ZipUtil.adjustToLong(n);
    }

    private void deflateUntilInputIsNeeded() throws IOException {
        while (!this.def.needsInput()) {
            this.deflate();
        }
    }

    private GeneralPurposeBit getGeneralPurposeBits(int n, boolean bl) {
        GeneralPurposeBit generalPurposeBit = new GeneralPurposeBit();
        generalPurposeBit.useUTF8ForNames(this.useUTF8Flag || bl);
        if (this.isDeflatedToOutputStream(n)) {
            generalPurposeBit.useDataDescriptor(true);
        }
        return generalPurposeBit;
    }

    private int versionNeededToExtract(int n, boolean bl) {
        if (bl) {
            return 45;
        }
        return this.isDeflatedToOutputStream(n) ? 20 : 10;
    }

    private boolean isDeflatedToOutputStream(int n) {
        return n == 8 && this.raf == null;
    }

    private Zip64ExtendedInformationExtraField getZip64Extra(ZipEntry zipEntry) {
        if (this.entry != null) {
            this.entry.causedUseOfZip64 = !this.hasUsedZip64;
        }
        this.hasUsedZip64 = true;
        Zip64ExtendedInformationExtraField zip64ExtendedInformationExtraField = (Zip64ExtendedInformationExtraField)zipEntry.getExtraField(Zip64ExtendedInformationExtraField.HEADER_ID);
        if (zip64ExtendedInformationExtraField == null) {
            zip64ExtendedInformationExtraField = new Zip64ExtendedInformationExtraField();
        }
        zipEntry.addAsFirstExtraField(zip64ExtendedInformationExtraField);
        return zip64ExtendedInformationExtraField;
    }

    private boolean hasZip64Extra(ZipEntry zipEntry) {
        return zipEntry.getExtraField(Zip64ExtendedInformationExtraField.HEADER_ID) != null;
    }

    private Zip64Mode getEffectiveZip64Mode(ZipEntry zipEntry) {
        if (this.zip64Mode != Zip64Mode.AsNeeded || this.raf != null || zipEntry.getMethod() != 8 || zipEntry.getSize() != -1L) {
            return this.zip64Mode;
        }
        return Zip64Mode.Never;
    }

    private ZipEncoding getEntryEncoding(ZipEntry zipEntry) {
        boolean bl = this.zipEncoding.canEncode(zipEntry.getName());
        return !bl && this.fallbackToUTF8 ? ZipEncodingHelper.UTF8_ZIP_ENCODING : this.zipEncoding;
    }

    private ByteBuffer getName(ZipEntry zipEntry) throws IOException {
        return this.getEntryEncoding(zipEntry).encode(zipEntry.getName());
    }

    void destroy() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
        if (this.out != null) {
            this.out.close();
        }
    }

    private static final class CurrentEntry {
        private final ZipEntry entry;
        private long localDataStart = 0L;
        private long dataStart = 0L;
        private long bytesRead = 0L;
        private boolean causedUseOfZip64 = false;
        private boolean hasWritten;

        private CurrentEntry(ZipEntry zipEntry) {
            this.entry = zipEntry;
        }
    }

    public static final class UnicodeExtraFieldPolicy {
        public static final UnicodeExtraFieldPolicy ALWAYS = new UnicodeExtraFieldPolicy("always");
        public static final UnicodeExtraFieldPolicy NEVER = new UnicodeExtraFieldPolicy("never");
        public static final UnicodeExtraFieldPolicy NOT_ENCODEABLE = new UnicodeExtraFieldPolicy("not encodeable");
        private final String name;

        private UnicodeExtraFieldPolicy(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }
}

