var autoprefixer = (function () {
  'use strict';

  var global$1 = (typeof global !== "undefined" ? global :
    typeof self !== "undefined" ? self :
    typeof window !== "undefined" ? window : {});

  // shim for using process in browser
  // based off https://github.com/defunctzombie/node-process/blob/master/browser.js

  function defaultSetTimout() {
      throw new Error('setTimeout has not been defined');
  }
  function defaultClearTimeout () {
      throw new Error('clearTimeout has not been defined');
  }
  var cachedSetTimeout = defaultSetTimout;
  var cachedClearTimeout = defaultClearTimeout;
  if (typeof global$1.setTimeout === 'function') {
      cachedSetTimeout = setTimeout;
  }
  if (typeof global$1.clearTimeout === 'function') {
      cachedClearTimeout = clearTimeout;
  }

  function runTimeout(fun) {
      if (cachedSetTimeout === setTimeout) {
          //normal enviroments in sane situations
          return setTimeout(fun, 0);
      }
      // if setTimeout wasn't available but was latter defined
      if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
          cachedSetTimeout = setTimeout;
          return setTimeout(fun, 0);
      }
      try {
          // when when somebody has screwed with setTimeout but no I.E. maddness
          return cachedSetTimeout(fun, 0);
      } catch(e){
          try {
              // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
              return cachedSetTimeout.call(null, fun, 0);
          } catch(e){
              // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
              return cachedSetTimeout.call(this, fun, 0);
          }
      }


  }
  function runClearTimeout(marker) {
      if (cachedClearTimeout === clearTimeout) {
          //normal enviroments in sane situations
          return clearTimeout(marker);
      }
      // if clearTimeout wasn't available but was latter defined
      if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
          cachedClearTimeout = clearTimeout;
          return clearTimeout(marker);
      }
      try {
          // when when somebody has screwed with setTimeout but no I.E. maddness
          return cachedClearTimeout(marker);
      } catch (e){
          try {
              // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
              return cachedClearTimeout.call(null, marker);
          } catch (e){
              // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
              // Some versions of I.E. have different rules for clearTimeout vs setTimeout
              return cachedClearTimeout.call(this, marker);
          }
      }



  }
  var queue = [];
  var draining = false;
  var currentQueue;
  var queueIndex = -1;

  function cleanUpNextTick() {
      if (!draining || !currentQueue) {
          return;
      }
      draining = false;
      if (currentQueue.length) {
          queue = currentQueue.concat(queue);
      } else {
          queueIndex = -1;
      }
      if (queue.length) {
          drainQueue();
      }
  }

  function drainQueue() {
      if (draining) {
          return;
      }
      var timeout = runTimeout(cleanUpNextTick);
      draining = true;

      var len = queue.length;
      while(len) {
          currentQueue = queue;
          queue = [];
          while (++queueIndex < len) {
              if (currentQueue) {
                  currentQueue[queueIndex].run();
              }
          }
          queueIndex = -1;
          len = queue.length;
      }
      currentQueue = null;
      draining = false;
      runClearTimeout(timeout);
  }
  function nextTick(fun) {
      var args = new Array(arguments.length - 1);
      if (arguments.length > 1) {
          for (var i = 1; i < arguments.length; i++) {
              args[i - 1] = arguments[i];
          }
      }
      queue.push(new Item(fun, args));
      if (queue.length === 1 && !draining) {
          runTimeout(drainQueue);
      }
  }
  // v8 likes predictible objects
  function Item(fun, array) {
      this.fun = fun;
      this.array = array;
  }
  Item.prototype.run = function () {
      this.fun.apply(null, this.array);
  };
  var title = 'browser';
  var platform = 'browser';
  var browser$1 = true;
  var env = {};
  var argv = [];
  var version = ''; // empty string to avoid regexp issues
  var versions$3 = {};
  var release = {};
  var config = {};

  function noop$1() {}

  var on = noop$1;
  var addListener = noop$1;
  var once = noop$1;
  var off = noop$1;
  var removeListener = noop$1;
  var removeAllListeners = noop$1;
  var emit = noop$1;

  function binding(name) {
      throw new Error('process.binding is not supported');
  }

  function cwd () { return '/' }
  function chdir (dir) {
      throw new Error('process.chdir is not supported');
  }function umask() { return 0; }

  // from https://github.com/kumavis/browser-process-hrtime/blob/master/index.js
  var performance = global$1.performance || {};
  var performanceNow =
    performance.now        ||
    performance.mozNow     ||
    performance.msNow      ||
    performance.oNow       ||
    performance.webkitNow  ||
    function(){ return (new Date()).getTime() };

  // generate timestamp or delta
  // see http://nodejs.org/api/process.html#process_process_hrtime
  function hrtime(previousTimestamp){
    var clocktime = performanceNow.call(performance)*1e-3;
    var seconds = Math.floor(clocktime);
    var nanoseconds = Math.floor((clocktime%1)*1e9);
    if (previousTimestamp) {
      seconds = seconds - previousTimestamp[0];
      nanoseconds = nanoseconds - previousTimestamp[1];
      if (nanoseconds<0) {
        seconds--;
        nanoseconds += 1e9;
      }
    }
    return [seconds,nanoseconds]
  }

  var startTime = new Date();
  function uptime() {
    var currentTime = new Date();
    var dif = currentTime - startTime;
    return dif / 1000;
  }

  var browser$1$1 = {
    nextTick: nextTick,
    title: title,
    browser: browser$1,
    env: env,
    argv: argv,
    version: version,
    versions: versions$3,
    on: on,
    addListener: addListener,
    once: once,
    off: off,
    removeListener: removeListener,
    removeAllListeners: removeAllListeners,
    emit: emit,
    binding: binding,
    cwd: cwd,
    chdir: chdir,
    umask: umask,
    hrtime: hrtime,
    platform: platform,
    release: release,
    config: config,
    uptime: uptime
  };

  var process = browser$1$1;

  var _nodeResolve_empty = {};

  var _nodeResolve_empty$1 = /*#__PURE__*/Object.freeze({
    __proto__: null,
    'default': _nodeResolve_empty
  });

  var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

  function getAugmentedNamespace(n) {
  	if (n.__esModule) return n;
  	var a = Object.defineProperty({}, '__esModule', {value: true});
  	Object.keys(n).forEach(function (k) {
  		var d = Object.getOwnPropertyDescriptor(n, k);
  		Object.defineProperty(a, k, d.get ? d : {
  			enumerable: true,
  			get: function () {
  				return n[k];
  			}
  		});
  	});
  	return a;
  }

  function createCommonjsModule(fn) {
    var module = { exports: {} };
  	return fn(module, module.exports), module.exports;
  }

  var path$2 = /*@__PURE__*/getAugmentedNamespace(_nodeResolve_empty$1);

  let { red, bold, gray, options: colorette } = path$2;



  class CssSyntaxError extends Error {
    constructor (message, line, column, source, file, plugin) {
      super(message);
      this.name = 'CssSyntaxError';
      this.reason = message;

      if (file) {
        this.file = file;
      }
      if (source) {
        this.source = source;
      }
      if (plugin) {
        this.plugin = plugin;
      }
      if (typeof line !== 'undefined' && typeof column !== 'undefined') {
        this.line = line;
        this.column = column;
      }

      this.setMessage();

      if (Error.captureStackTrace) {
        Error.captureStackTrace(this, CssSyntaxError);
      }
    }

    setMessage () {
      this.message = this.plugin ? this.plugin + ': ' : '';
      this.message += this.file ? this.file : '<css input>';
      if (typeof this.line !== 'undefined') {
        this.message += ':' + this.line + ':' + this.column;
      }
      this.message += ': ' + this.reason;
    }

    showSourceCode (color) {
      if (!this.source) return ''

      let css = this.source;
      if (color == null) color = null;
      if (path$2) {
        if (color) css = path$2(css);
      }

      let lines = css.split(/\r?\n/);
      let start = Math.max(this.line - 3, 0);
      let end = Math.min(this.line + 2, lines.length);

      let maxWidth = String(end).length;

      let mark, aside;
      if (color) {
        mark = text => bold(red(text));
        aside = text => gray(text);
      } else {
        mark = aside = str => str;
      }

      return lines
        .slice(start, end)
        .map((line, index) => {
          let number = start + 1 + index;
          let gutter = ' ' + (' ' + number).slice(-maxWidth) + ' | ';
          if (number === this.line) {
            let spacing =
              aside(gutter.replace(/\d/g, ' ')) +
              line.slice(0, this.column - 1).replace(/[^\t]/g, ' ');
            return mark('>') + aside(gutter) + line + '\n ' + spacing + mark('^')
          }
          return ' ' + aside(gutter) + line
        })
        .join('\n')
    }

    toString () {
      let code = this.showSourceCode();
      if (code) {
        code = '\n\n' + code + '\n';
      }
      return this.name + ': ' + this.message + code
    }
  }

  var cssSyntaxError = CssSyntaxError;
  CssSyntaxError.default = CssSyntaxError;

  const DEFAULT_RAW = {
    colon: ': ',
    indent: '    ',
    beforeDecl: '\n',
    beforeRule: '\n',
    beforeOpen: ' ',
    beforeClose: '\n',
    beforeComment: '\n',
    after: '\n',
    emptyBody: '',
    commentLeft: ' ',
    commentRight: ' ',
    semicolon: false
  };

  function capitalize$1 (str) {
    return str[0].toUpperCase() + str.slice(1)
  }

  class Stringifier {
    constructor (builder) {
      this.builder = builder;
    }

    stringify (node, semicolon) {
      /* istanbul ignore if */
      if (!this[node.type]) {
        throw new Error(
          'Unknown AST node type ' +
            node.type +
            '. ' +
            'Maybe you need to change PostCSS stringifier.'
        )
      }
      this[node.type](node, semicolon);
    }

    root (node) {
      this.body(node);
      if (node.raws.after) this.builder(node.raws.after);
    }

    comment (node) {
      let left = this.raw(node, 'left', 'commentLeft');
      let right = this.raw(node, 'right', 'commentRight');
      this.builder('/*' + left + node.text + right + '*/', node);
    }

    decl (node, semicolon) {
      let between = this.raw(node, 'between', 'colon');
      let string = node.prop + between + this.rawValue(node, 'value');

      if (node.important) {
        string += node.raws.important || ' !important';
      }

      if (semicolon) string += ';';
      this.builder(string, node);
    }

    rule (node) {
      this.block(node, this.rawValue(node, 'selector'));
      if (node.raws.ownSemicolon) {
        this.builder(node.raws.ownSemicolon, node, 'end');
      }
    }

    atrule (node, semicolon) {
      let name = '@' + node.name;
      let params = node.params ? this.rawValue(node, 'params') : '';

      if (typeof node.raws.afterName !== 'undefined') {
        name += node.raws.afterName;
      } else if (params) {
        name += ' ';
      }

      if (node.nodes) {
        this.block(node, name + params);
      } else {
        let end = (node.raws.between || '') + (semicolon ? ';' : '');
        this.builder(name + params + end, node);
      }
    }

    body (node) {
      let last = node.nodes.length - 1;
      while (last > 0) {
        if (node.nodes[last].type !== 'comment') break
        last -= 1;
      }

      let semicolon = this.raw(node, 'semicolon');
      for (let i = 0; i < node.nodes.length; i++) {
        let child = node.nodes[i];
        let before = this.raw(child, 'before');
        if (before) this.builder(before);
        this.stringify(child, last !== i || semicolon);
      }
    }

    block (node, start) {
      let between = this.raw(node, 'between', 'beforeOpen');
      this.builder(start + between + '{', node, 'start');

      let after;
      if (node.nodes && node.nodes.length) {
        this.body(node);
        after = this.raw(node, 'after');
      } else {
        after = this.raw(node, 'after', 'emptyBody');
      }

      if (after) this.builder(after);
      this.builder('}', node, 'end');
    }

    raw (node, own, detect) {
      let value;
      if (!detect) detect = own;

      // Already had
      if (own) {
        value = node.raws[own];
        if (typeof value !== 'undefined') return value
      }

      let parent = node.parent;

      // Hack for first rule in CSS
      if (detect === 'before') {
        if (!parent || (parent.type === 'root' && parent.first === node)) {
          return ''
        }
      }

      // Floating child without parent
      if (!parent) return DEFAULT_RAW[detect]

      // Detect style by other nodes
      let root = node.root();
      if (!root.rawCache) root.rawCache = {};
      if (typeof root.rawCache[detect] !== 'undefined') {
        return root.rawCache[detect]
      }

      if (detect === 'before' || detect === 'after') {
        return this.beforeAfter(node, detect)
      } else {
        let method = 'raw' + capitalize$1(detect);
        if (this[method]) {
          value = this[method](root, node);
        } else {
          root.walk(i => {
            value = i.raws[own];
            if (typeof value !== 'undefined') return false
          });
        }
      }

      if (typeof value === 'undefined') value = DEFAULT_RAW[detect];

      root.rawCache[detect] = value;
      return value
    }

    rawSemicolon (root) {
      let value;
      root.walk(i => {
        if (i.nodes && i.nodes.length && i.last.type === 'decl') {
          value = i.raws.semicolon;
          if (typeof value !== 'undefined') return false
        }
      });
      return value
    }

    rawEmptyBody (root) {
      let value;
      root.walk(i => {
        if (i.nodes && i.nodes.length === 0) {
          value = i.raws.after;
          if (typeof value !== 'undefined') return false
        }
      });
      return value
    }

    rawIndent (root) {
      if (root.raws.indent) return root.raws.indent
      let value;
      root.walk(i => {
        let p = i.parent;
        if (p && p !== root && p.parent && p.parent === root) {
          if (typeof i.raws.before !== 'undefined') {
            let parts = i.raws.before.split('\n');
            value = parts[parts.length - 1];
            value = value.replace(/\S/g, '');
            return false
          }
        }
      });
      return value
    }

    rawBeforeComment (root, node) {
      let value;
      root.walkComments(i => {
        if (typeof i.raws.before !== 'undefined') {
          value = i.raws.before;
          if (value.includes('\n')) {
            value = value.replace(/[^\n]+$/, '');
          }
          return false
        }
      });
      if (typeof value === 'undefined') {
        value = this.raw(node, null, 'beforeDecl');
      } else if (value) {
        value = value.replace(/\S/g, '');
      }
      return value
    }

    rawBeforeDecl (root, node) {
      let value;
      root.walkDecls(i => {
        if (typeof i.raws.before !== 'undefined') {
          value = i.raws.before;
          if (value.includes('\n')) {
            value = value.replace(/[^\n]+$/, '');
          }
          return false
        }
      });
      if (typeof value === 'undefined') {
        value = this.raw(node, null, 'beforeRule');
      } else if (value) {
        value = value.replace(/\S/g, '');
      }
      return value
    }

    rawBeforeRule (root) {
      let value;
      root.walk(i => {
        if (i.nodes && (i.parent !== root || root.first !== i)) {
          if (typeof i.raws.before !== 'undefined') {
            value = i.raws.before;
            if (value.includes('\n')) {
              value = value.replace(/[^\n]+$/, '');
            }
            return false
          }
        }
      });
      if (value) value = value.replace(/\S/g, '');
      return value
    }

    rawBeforeClose (root) {
      let value;
      root.walk(i => {
        if (i.nodes && i.nodes.length > 0) {
          if (typeof i.raws.after !== 'undefined') {
            value = i.raws.after;
            if (value.includes('\n')) {
              value = value.replace(/[^\n]+$/, '');
            }
            return false
          }
        }
      });
      if (value) value = value.replace(/\S/g, '');
      return value
    }

    rawBeforeOpen (root) {
      let value;
      root.walk(i => {
        if (i.type !== 'decl') {
          value = i.raws.between;
          if (typeof value !== 'undefined') return false
        }
      });
      return value
    }

    rawColon (root) {
      let value;
      root.walkDecls(i => {
        if (typeof i.raws.between !== 'undefined') {
          value = i.raws.between.replace(/[^\s:]/g, '');
          return false
        }
      });
      return value
    }

    beforeAfter (node, detect) {
      let value;
      if (node.type === 'decl') {
        value = this.raw(node, null, 'beforeDecl');
      } else if (node.type === 'comment') {
        value = this.raw(node, null, 'beforeComment');
      } else if (detect === 'before') {
        value = this.raw(node, null, 'beforeRule');
      } else {
        value = this.raw(node, null, 'beforeClose');
      }

      let buf = node.parent;
      let depth = 0;
      while (buf && buf.type !== 'root') {
        depth += 1;
        buf = buf.parent;
      }

      if (value.includes('\n')) {
        let indent = this.raw(node, null, 'indent');
        if (indent.length) {
          for (let step = 0; step < depth; step++) value += indent;
        }
      }

      return value
    }

    rawValue (node, prop) {
      let value = node[prop];
      let raw = node.raws[prop];
      if (raw && raw.value === value) {
        return raw.raw
      }

      return value
    }
  }

  var stringifier = Stringifier;

  var isClean$3 = Symbol('isClean');

  var symbols = {
  	isClean: isClean$3
  };

  function stringify$2 (node, builder) {
    let str = new stringifier(builder);
    str.stringify(node);
  }

  var stringify_1$1 = stringify$2;
  stringify$2.default = stringify$2;

  let { isClean: isClean$2 } = symbols;


  function cloneNode (obj, parent) {
    let cloned = new obj.constructor();

    for (let i in obj) {
      if (!Object.prototype.hasOwnProperty.call(obj, i)) {
        // istanbul ignore next
        continue
      }
      if (i === 'proxyCache') continue
      let value = obj[i];
      let type = typeof value;

      if (i === 'parent' && type === 'object') {
        if (parent) cloned[i] = parent;
      } else if (i === 'source') {
        cloned[i] = value;
      } else if (Array.isArray(value)) {
        cloned[i] = value.map(j => cloneNode(j, cloned));
      } else {
        if (type === 'object' && value !== null) value = cloneNode(value);
        cloned[i] = value;
      }
    }

    return cloned
  }

  class Node {
    constructor (defaults = {}) {
      this.raws = {};
      this[isClean$2] = false;

      for (let name in defaults) {
        if (name === 'nodes') {
          this.nodes = [];
          for (let node of defaults[name]) {
            if (typeof node.clone === 'function') {
              this.append(node.clone());
            } else {
              this.append(node);
            }
          }
        } else {
          this[name] = defaults[name];
        }
      }
    }

    error (message, opts = {}) {
      if (this.source) {
        let pos = this.positionBy(opts);
        return this.source.input.error(message, pos.line, pos.column, opts)
      }
      return new cssSyntaxError(message)
    }

    warn (result, text, opts) {
      let data = { node: this };
      for (let i in opts) data[i] = opts[i];
      return result.warn(text, data)
    }

    remove () {
      if (this.parent) {
        this.parent.removeChild(this);
      }
      this.parent = undefined;
      return this
    }

    toString (stringifier = stringify_1$1) {
      if (stringifier.stringify) stringifier = stringifier.stringify;
      let result = '';
      stringifier(this, i => {
        result += i;
      });
      return result
    }

    clone (overrides = {}) {
      let cloned = cloneNode(this);
      for (let name in overrides) {
        cloned[name] = overrides[name];
      }
      return cloned
    }

    cloneBefore (overrides = {}) {
      let cloned = this.clone(overrides);
      this.parent.insertBefore(this, cloned);
      return cloned
    }

    cloneAfter (overrides = {}) {
      let cloned = this.clone(overrides);
      this.parent.insertAfter(this, cloned);
      return cloned
    }

    replaceWith (...nodes) {
      if (this.parent) {
        let bookmark = this;
        let foundSelf = false;
        for (let node of nodes) {
          if (node === this) {
            foundSelf = true;
          } else if (foundSelf) {
            this.parent.insertAfter(bookmark, node);
            bookmark = node;
          } else {
            this.parent.insertBefore(bookmark, node);
          }
        }

        if (!foundSelf) {
          this.remove();
        }
      }

      return this
    }

    next () {
      if (!this.parent) return undefined
      let index = this.parent.index(this);
      return this.parent.nodes[index + 1]
    }

    prev () {
      if (!this.parent) return undefined
      let index = this.parent.index(this);
      return this.parent.nodes[index - 1]
    }

    before (add) {
      this.parent.insertBefore(this, add);
      return this
    }

    after (add) {
      this.parent.insertAfter(this, add);
      return this
    }

    root () {
      let result = this;
      while (result.parent) result = result.parent;
      return result
    }

    raw (prop, defaultType) {
      let str = new stringifier();
      return str.raw(this, prop, defaultType)
    }

    cleanRaws (keepBetween) {
      delete this.raws.before;
      delete this.raws.after;
      if (!keepBetween) delete this.raws.between;
    }

    toJSON (_, inputs) {
      let fixed = {};
      let emitInputs = inputs == null;
      inputs = inputs || new Map();
      let inputsNextIndex = 0;

      for (let name in this) {
        if (!Object.prototype.hasOwnProperty.call(this, name)) {
          // istanbul ignore next
          continue
        }
        if (name === 'parent') continue
        let value = this[name];

        if (Array.isArray(value)) {
          fixed[name] = value.map(i => {
            if (typeof i === 'object' && i.toJSON) {
              return i.toJSON(null, inputs)
            } else {
              return i
            }
          });
        } else if (typeof value === 'object' && value.toJSON) {
          fixed[name] = value.toJSON(null, inputs);
        } else if (name === 'source') {
          let inputId = inputs.get(value.input);
          if (inputId == null) {
            inputId = inputsNextIndex;
            inputs.set(value.input, inputsNextIndex);
            inputsNextIndex++;
          }
          fixed[name] = {
            inputId,
            start: value.start,
            end: value.end
          };
        } else {
          fixed[name] = value;
        }
      }

      if (emitInputs) {
        fixed.inputs = [...inputs.keys()].map(input => input.toJSON());
      }

      return fixed
    }

    positionInside (index) {
      let string = this.toString();
      let column = this.source.start.column;
      let line = this.source.start.line;

      for (let i = 0; i < index; i++) {
        if (string[i] === '\n') {
          column = 1;
          line += 1;
        } else {
          column += 1;
        }
      }

      return { line, column }
    }

    positionBy (opts) {
      let pos = this.source.start;
      if (opts.index) {
        pos = this.positionInside(opts.index);
      } else if (opts.word) {
        let index = this.toString().indexOf(opts.word);
        if (index !== -1) pos = this.positionInside(index);
      }
      return pos
    }

    getProxyProcessor () {
      return {
        set (node, prop, value) {
          if (node[prop] === value) return true
          node[prop] = value;
          if (
            prop === 'prop' ||
            prop === 'value' ||
            prop === 'name' ||
            prop === 'params' ||
            prop === 'important' ||
            prop === 'text'
          ) {
            node.markDirty();
          }
          return true
        },

        get (node, prop) {
          if (prop === 'proxyOf') {
            return node
          } else if (prop === 'root') {
            return () => node.root().toProxy()
          } else {
            return node[prop]
          }
        }
      }
    }

    toProxy () {
      if (!this.proxyCache) {
        this.proxyCache = new Proxy(this, this.getProxyProcessor());
      }
      return this.proxyCache
    }

    addToError (error) {
      error.postcssNode = this;
      if (error.stack && this.source && /\n\s{4}at /.test(error.stack)) {
        let s = this.source;
        error.stack = error.stack.replace(
          /\n\s{4}at /,
          `$&${s.input.from}:${s.start.line}:${s.start.column}$&`
        );
      }
      return error
    }

    markDirty () {
      if (this[isClean$2]) {
        this[isClean$2] = false;
        let next = this;
        while ((next = next.parent)) {
          next[isClean$2] = false;
        }
      }
    }

    get proxyOf () {
      return this
    }
  }

  var node_1 = Node;
  Node.default = Node;

  class Declaration$1 extends node_1 {
    constructor (defaults) {
      if (
        defaults &&
        typeof defaults.value !== 'undefined' &&
        typeof defaults.value !== 'string'
      ) {
        defaults = { ...defaults, value: String(defaults.value) };
      }
      super(defaults);
      this.type = 'decl';
    }

    get variable () {
      return this.prop.startsWith('--') || this.prop[0] === '$'
    }
  }

  var declaration$1 = Declaration$1;
  Declaration$1.default = Declaration$1;

  var lookup = [];
  var revLookup = [];
  var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array;
  var inited = false;
  function init () {
    inited = true;
    var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
    for (var i = 0, len = code.length; i < len; ++i) {
      lookup[i] = code[i];
      revLookup[code.charCodeAt(i)] = i;
    }

    revLookup['-'.charCodeAt(0)] = 62;
    revLookup['_'.charCodeAt(0)] = 63;
  }

  function toByteArray (b64) {
    if (!inited) {
      init();
    }
    var i, j, l, tmp, placeHolders, arr;
    var len = b64.length;

    if (len % 4 > 0) {
      throw new Error('Invalid string. Length must be a multiple of 4')
    }

    // the number of equal signs (place holders)
    // if there are two placeholders, than the two characters before it
    // represent one byte
    // if there is only one, then the three characters before it represent 2 bytes
    // this is just a cheap hack to not do indexOf twice
    placeHolders = b64[len - 2] === '=' ? 2 : b64[len - 1] === '=' ? 1 : 0;

    // base64 is 4/3 + up to two characters of the original data
    arr = new Arr(len * 3 / 4 - placeHolders);

    // if there are placeholders, only get up to the last complete 4 chars
    l = placeHolders > 0 ? len - 4 : len;

    var L = 0;

    for (i = 0, j = 0; i < l; i += 4, j += 3) {
      tmp = (revLookup[b64.charCodeAt(i)] << 18) | (revLookup[b64.charCodeAt(i + 1)] << 12) | (revLookup[b64.charCodeAt(i + 2)] << 6) | revLookup[b64.charCodeAt(i + 3)];
      arr[L++] = (tmp >> 16) & 0xFF;
      arr[L++] = (tmp >> 8) & 0xFF;
      arr[L++] = tmp & 0xFF;
    }

    if (placeHolders === 2) {
      tmp = (revLookup[b64.charCodeAt(i)] << 2) | (revLookup[b64.charCodeAt(i + 1)] >> 4);
      arr[L++] = tmp & 0xFF;
    } else if (placeHolders === 1) {
      tmp = (revLookup[b64.charCodeAt(i)] << 10) | (revLookup[b64.charCodeAt(i + 1)] << 4) | (revLookup[b64.charCodeAt(i + 2)] >> 2);
      arr[L++] = (tmp >> 8) & 0xFF;
      arr[L++] = tmp & 0xFF;
    }

    return arr
  }

  function tripletToBase64 (num) {
    return lookup[num >> 18 & 0x3F] + lookup[num >> 12 & 0x3F] + lookup[num >> 6 & 0x3F] + lookup[num & 0x3F]
  }

  function encodeChunk (uint8, start, end) {
    var tmp;
    var output = [];
    for (var i = start; i < end; i += 3) {
      tmp = (uint8[i] << 16) + (uint8[i + 1] << 8) + (uint8[i + 2]);
      output.push(tripletToBase64(tmp));
    }
    return output.join('')
  }

  function fromByteArray (uint8) {
    if (!inited) {
      init();
    }
    var tmp;
    var len = uint8.length;
    var extraBytes = len % 3; // if we have 1 byte left, pad 2 bytes
    var output = '';
    var parts = [];
    var maxChunkLength = 16383; // must be multiple of 3

    // go through the array every three bytes, we'll deal with trailing stuff later
    for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
      parts.push(encodeChunk(uint8, i, (i + maxChunkLength) > len2 ? len2 : (i + maxChunkLength)));
    }

    // pad the end with zeros, but make sure to not forget the extra bytes
    if (extraBytes === 1) {
      tmp = uint8[len - 1];
      output += lookup[tmp >> 2];
      output += lookup[(tmp << 4) & 0x3F];
      output += '==';
    } else if (extraBytes === 2) {
      tmp = (uint8[len - 2] << 8) + (uint8[len - 1]);
      output += lookup[tmp >> 10];
      output += lookup[(tmp >> 4) & 0x3F];
      output += lookup[(tmp << 2) & 0x3F];
      output += '=';
    }

    parts.push(output);

    return parts.join('')
  }

  function read (buffer, offset, isLE, mLen, nBytes) {
    var e, m;
    var eLen = nBytes * 8 - mLen - 1;
    var eMax = (1 << eLen) - 1;
    var eBias = eMax >> 1;
    var nBits = -7;
    var i = isLE ? (nBytes - 1) : 0;
    var d = isLE ? -1 : 1;
    var s = buffer[offset + i];

    i += d;

    e = s & ((1 << (-nBits)) - 1);
    s >>= (-nBits);
    nBits += eLen;
    for (; nBits > 0; e = e * 256 + buffer[offset + i], i += d, nBits -= 8) {}

    m = e & ((1 << (-nBits)) - 1);
    e >>= (-nBits);
    nBits += mLen;
    for (; nBits > 0; m = m * 256 + buffer[offset + i], i += d, nBits -= 8) {}

    if (e === 0) {
      e = 1 - eBias;
    } else if (e === eMax) {
      return m ? NaN : ((s ? -1 : 1) * Infinity)
    } else {
      m = m + Math.pow(2, mLen);
      e = e - eBias;
    }
    return (s ? -1 : 1) * m * Math.pow(2, e - mLen)
  }

  function write (buffer, value, offset, isLE, mLen, nBytes) {
    var e, m, c;
    var eLen = nBytes * 8 - mLen - 1;
    var eMax = (1 << eLen) - 1;
    var eBias = eMax >> 1;
    var rt = (mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0);
    var i = isLE ? 0 : (nBytes - 1);
    var d = isLE ? 1 : -1;
    var s = value < 0 || (value === 0 && 1 / value < 0) ? 1 : 0;

    value = Math.abs(value);

    if (isNaN(value) || value === Infinity) {
      m = isNaN(value) ? 1 : 0;
      e = eMax;
    } else {
      e = Math.floor(Math.log(value) / Math.LN2);
      if (value * (c = Math.pow(2, -e)) < 1) {
        e--;
        c *= 2;
      }
      if (e + eBias >= 1) {
        value += rt / c;
      } else {
        value += rt * Math.pow(2, 1 - eBias);
      }
      if (value * c >= 2) {
        e++;
        c /= 2;
      }

      if (e + eBias >= eMax) {
        m = 0;
        e = eMax;
      } else if (e + eBias >= 1) {
        m = (value * c - 1) * Math.pow(2, mLen);
        e = e + eBias;
      } else {
        m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen);
        e = 0;
      }
    }

    for (; mLen >= 8; buffer[offset + i] = m & 0xff, i += d, m /= 256, mLen -= 8) {}

    e = (e << mLen) | m;
    eLen += mLen;
    for (; eLen > 0; buffer[offset + i] = e & 0xff, i += d, e /= 256, eLen -= 8) {}

    buffer[offset + i - d] |= s * 128;
  }

  var toString = {}.toString;

  var isArray$1 = Array.isArray || function (arr) {
    return toString.call(arr) == '[object Array]';
  };

  /*!
   * The buffer module from node.js, for the browser.
   *
   * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
   * @license  MIT
   */

  var INSPECT_MAX_BYTES = 50;

  /**
   * If `Buffer.TYPED_ARRAY_SUPPORT`:
   *   === true    Use Uint8Array implementation (fastest)
   *   === false   Use Object implementation (most compatible, even IE6)
   *
   * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
   * Opera 11.6+, iOS 4.2+.
   *
   * Due to various browser bugs, sometimes the Object implementation will be used even
   * when the browser supports typed arrays.
   *
   * Note:
   *
   *   - Firefox 4-29 lacks support for adding new properties to `Uint8Array` instances,
   *     See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438.
   *
   *   - Chrome 9-10 is missing the `TypedArray.prototype.subarray` function.
   *
   *   - IE10 has a broken `TypedArray.prototype.subarray` function which returns arrays of
   *     incorrect length in some situations.

   * We detect these buggy browsers and set `Buffer.TYPED_ARRAY_SUPPORT` to `false` so they
   * get the Object implementation, which is slower but behaves correctly.
   */
  Buffer.TYPED_ARRAY_SUPPORT = global$1.TYPED_ARRAY_SUPPORT !== undefined
    ? global$1.TYPED_ARRAY_SUPPORT
    : true;

  /*
   * Export kMaxLength after typed array support is determined.
   */
  kMaxLength();

  function kMaxLength () {
    return Buffer.TYPED_ARRAY_SUPPORT
      ? 0x7fffffff
      : 0x3fffffff
  }

  function createBuffer (that, length) {
    if (kMaxLength() < length) {
      throw new RangeError('Invalid typed array length')
    }
    if (Buffer.TYPED_ARRAY_SUPPORT) {
      // Return an augmented `Uint8Array` instance, for best performance
      that = new Uint8Array(length);
      that.__proto__ = Buffer.prototype;
    } else {
      // Fallback: Return an object instance of the Buffer class
      if (that === null) {
        that = new Buffer(length);
      }
      that.length = length;
    }

    return that
  }

  /**
   * The Buffer constructor returns instances of `Uint8Array` that have their
   * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
   * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
   * and the `Uint8Array` methods. Square bracket notation works as expected -- it
   * returns a single octet.
   *
   * The `Uint8Array` prototype remains unmodified.
   */

  function Buffer (arg, encodingOrOffset, length) {
    if (!Buffer.TYPED_ARRAY_SUPPORT && !(this instanceof Buffer)) {
      return new Buffer(arg, encodingOrOffset, length)
    }

    // Common case.
    if (typeof arg === 'number') {
      if (typeof encodingOrOffset === 'string') {
        throw new Error(
          'If encoding is specified then the first argument must be a string'
        )
      }
      return allocUnsafe(this, arg)
    }
    return from(this, arg, encodingOrOffset, length)
  }

  Buffer.poolSize = 8192; // not used by this implementation

  // TODO: Legacy, not needed anymore. Remove in next major version.
  Buffer._augment = function (arr) {
    arr.__proto__ = Buffer.prototype;
    return arr
  };

  function from (that, value, encodingOrOffset, length) {
    if (typeof value === 'number') {
      throw new TypeError('"value" argument must not be a number')
    }

    if (typeof ArrayBuffer !== 'undefined' && value instanceof ArrayBuffer) {
      return fromArrayBuffer(that, value, encodingOrOffset, length)
    }

    if (typeof value === 'string') {
      return fromString(that, value, encodingOrOffset)
    }

    return fromObject(that, value)
  }

  /**
   * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
   * if value is a number.
   * Buffer.from(str[, encoding])
   * Buffer.from(array)
   * Buffer.from(buffer)
   * Buffer.from(arrayBuffer[, byteOffset[, length]])
   **/
  Buffer.from = function (value, encodingOrOffset, length) {
    return from(null, value, encodingOrOffset, length)
  };

  if (Buffer.TYPED_ARRAY_SUPPORT) {
    Buffer.prototype.__proto__ = Uint8Array.prototype;
    Buffer.__proto__ = Uint8Array;
  }

  function assertSize (size) {
    if (typeof size !== 'number') {
      throw new TypeError('"size" argument must be a number')
    } else if (size < 0) {
      throw new RangeError('"size" argument must not be negative')
    }
  }

  function alloc (that, size, fill, encoding) {
    assertSize(size);
    if (size <= 0) {
      return createBuffer(that, size)
    }
    if (fill !== undefined) {
      // Only pay attention to encoding if it's a string. This
      // prevents accidentally sending in a number that would
      // be interpretted as a start offset.
      return typeof encoding === 'string'
        ? createBuffer(that, size).fill(fill, encoding)
        : createBuffer(that, size).fill(fill)
    }
    return createBuffer(that, size)
  }

  /**
   * Creates a new filled Buffer instance.
   * alloc(size[, fill[, encoding]])
   **/
  Buffer.alloc = function (size, fill, encoding) {
    return alloc(null, size, fill, encoding)
  };

  function allocUnsafe (that, size) {
    assertSize(size);
    that = createBuffer(that, size < 0 ? 0 : checked(size) | 0);
    if (!Buffer.TYPED_ARRAY_SUPPORT) {
      for (var i = 0; i < size; ++i) {
        that[i] = 0;
      }
    }
    return that
  }

  /**
   * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
   * */
  Buffer.allocUnsafe = function (size) {
    return allocUnsafe(null, size)
  };
  /**
   * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
   */
  Buffer.allocUnsafeSlow = function (size) {
    return allocUnsafe(null, size)
  };

  function fromString (that, string, encoding) {
    if (typeof encoding !== 'string' || encoding === '') {
      encoding = 'utf8';
    }

    if (!Buffer.isEncoding(encoding)) {
      throw new TypeError('"encoding" must be a valid string encoding')
    }

    var length = byteLength(string, encoding) | 0;
    that = createBuffer(that, length);

    var actual = that.write(string, encoding);

    if (actual !== length) {
      // Writing a hex string, for example, that contains invalid characters will
      // cause everything after the first invalid character to be ignored. (e.g.
      // 'abxxcd' will be treated as 'ab')
      that = that.slice(0, actual);
    }

    return that
  }

  function fromArrayLike (that, array) {
    var length = array.length < 0 ? 0 : checked(array.length) | 0;
    that = createBuffer(that, length);
    for (var i = 0; i < length; i += 1) {
      that[i] = array[i] & 255;
    }
    return that
  }

  function fromArrayBuffer (that, array, byteOffset, length) {
    array.byteLength; // this throws if `array` is not a valid ArrayBuffer

    if (byteOffset < 0 || array.byteLength < byteOffset) {
      throw new RangeError('\'offset\' is out of bounds')
    }

    if (array.byteLength < byteOffset + (length || 0)) {
      throw new RangeError('\'length\' is out of bounds')
    }

    if (byteOffset === undefined && length === undefined) {
      array = new Uint8Array(array);
    } else if (length === undefined) {
      array = new Uint8Array(array, byteOffset);
    } else {
      array = new Uint8Array(array, byteOffset, length);
    }

    if (Buffer.TYPED_ARRAY_SUPPORT) {
      // Return an augmented `Uint8Array` instance, for best performance
      that = array;
      that.__proto__ = Buffer.prototype;
    } else {
      // Fallback: Return an object instance of the Buffer class
      that = fromArrayLike(that, array);
    }
    return that
  }

  function fromObject (that, obj) {
    if (internalIsBuffer(obj)) {
      var len = checked(obj.length) | 0;
      that = createBuffer(that, len);

      if (that.length === 0) {
        return that
      }

      obj.copy(that, 0, 0, len);
      return that
    }

    if (obj) {
      if ((typeof ArrayBuffer !== 'undefined' &&
          obj.buffer instanceof ArrayBuffer) || 'length' in obj) {
        if (typeof obj.length !== 'number' || isnan(obj.length)) {
          return createBuffer(that, 0)
        }
        return fromArrayLike(that, obj)
      }

      if (obj.type === 'Buffer' && isArray$1(obj.data)) {
        return fromArrayLike(that, obj.data)
      }
    }

    throw new TypeError('First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.')
  }

  function checked (length) {
    // Note: cannot use `length < kMaxLength()` here because that fails when
    // length is NaN (which is otherwise coerced to zero.)
    if (length >= kMaxLength()) {
      throw new RangeError('Attempt to allocate Buffer larger than maximum ' +
                           'size: 0x' + kMaxLength().toString(16) + ' bytes')
    }
    return length | 0
  }
  Buffer.isBuffer = isBuffer;
  function internalIsBuffer (b) {
    return !!(b != null && b._isBuffer)
  }

  Buffer.compare = function compare (a, b) {
    if (!internalIsBuffer(a) || !internalIsBuffer(b)) {
      throw new TypeError('Arguments must be Buffers')
    }

    if (a === b) return 0

    var x = a.length;
    var y = b.length;

    for (var i = 0, len = Math.min(x, y); i < len; ++i) {
      if (a[i] !== b[i]) {
        x = a[i];
        y = b[i];
        break
      }
    }

    if (x < y) return -1
    if (y < x) return 1
    return 0
  };

  Buffer.isEncoding = function isEncoding (encoding) {
    switch (String(encoding).toLowerCase()) {
      case 'hex':
      case 'utf8':
      case 'utf-8':
      case 'ascii':
      case 'latin1':
      case 'binary':
      case 'base64':
      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return true
      default:
        return false
    }
  };

  Buffer.concat = function concat (list, length) {
    if (!isArray$1(list)) {
      throw new TypeError('"list" argument must be an Array of Buffers')
    }

    if (list.length === 0) {
      return Buffer.alloc(0)
    }

    var i;
    if (length === undefined) {
      length = 0;
      for (i = 0; i < list.length; ++i) {
        length += list[i].length;
      }
    }

    var buffer = Buffer.allocUnsafe(length);
    var pos = 0;
    for (i = 0; i < list.length; ++i) {
      var buf = list[i];
      if (!internalIsBuffer(buf)) {
        throw new TypeError('"list" argument must be an Array of Buffers')
      }
      buf.copy(buffer, pos);
      pos += buf.length;
    }
    return buffer
  };

  function byteLength (string, encoding) {
    if (internalIsBuffer(string)) {
      return string.length
    }
    if (typeof ArrayBuffer !== 'undefined' && typeof ArrayBuffer.isView === 'function' &&
        (ArrayBuffer.isView(string) || string instanceof ArrayBuffer)) {
      return string.byteLength
    }
    if (typeof string !== 'string') {
      string = '' + string;
    }

    var len = string.length;
    if (len === 0) return 0

    // Use a for loop to avoid recursion
    var loweredCase = false;
    for (;;) {
      switch (encoding) {
        case 'ascii':
        case 'latin1':
        case 'binary':
          return len
        case 'utf8':
        case 'utf-8':
        case undefined:
          return utf8ToBytes(string).length
        case 'ucs2':
        case 'ucs-2':
        case 'utf16le':
        case 'utf-16le':
          return len * 2
        case 'hex':
          return len >>> 1
        case 'base64':
          return base64ToBytes(string).length
        default:
          if (loweredCase) return utf8ToBytes(string).length // assume utf8
          encoding = ('' + encoding).toLowerCase();
          loweredCase = true;
      }
    }
  }
  Buffer.byteLength = byteLength;

  function slowToString (encoding, start, end) {
    var loweredCase = false;

    // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
    // property of a typed array.

    // This behaves neither like String nor Uint8Array in that we set start/end
    // to their upper/lower bounds if the value passed is out of range.
    // undefined is handled specially as per ECMA-262 6th Edition,
    // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
    if (start === undefined || start < 0) {
      start = 0;
    }
    // Return early if start > this.length. Done here to prevent potential uint32
    // coercion fail below.
    if (start > this.length) {
      return ''
    }

    if (end === undefined || end > this.length) {
      end = this.length;
    }

    if (end <= 0) {
      return ''
    }

    // Force coersion to uint32. This will also coerce falsey/NaN values to 0.
    end >>>= 0;
    start >>>= 0;

    if (end <= start) {
      return ''
    }

    if (!encoding) encoding = 'utf8';

    while (true) {
      switch (encoding) {
        case 'hex':
          return hexSlice(this, start, end)

        case 'utf8':
        case 'utf-8':
          return utf8Slice(this, start, end)

        case 'ascii':
          return asciiSlice(this, start, end)

        case 'latin1':
        case 'binary':
          return latin1Slice(this, start, end)

        case 'base64':
          return base64Slice(this, start, end)

        case 'ucs2':
        case 'ucs-2':
        case 'utf16le':
        case 'utf-16le':
          return utf16leSlice(this, start, end)

        default:
          if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
          encoding = (encoding + '').toLowerCase();
          loweredCase = true;
      }
    }
  }

  // The property is used by `Buffer.isBuffer` and `is-buffer` (in Safari 5-7) to detect
  // Buffer instances.
  Buffer.prototype._isBuffer = true;

  function swap$1 (b, n, m) {
    var i = b[n];
    b[n] = b[m];
    b[m] = i;
  }

  Buffer.prototype.swap16 = function swap16 () {
    var len = this.length;
    if (len % 2 !== 0) {
      throw new RangeError('Buffer size must be a multiple of 16-bits')
    }
    for (var i = 0; i < len; i += 2) {
      swap$1(this, i, i + 1);
    }
    return this
  };

  Buffer.prototype.swap32 = function swap32 () {
    var len = this.length;
    if (len % 4 !== 0) {
      throw new RangeError('Buffer size must be a multiple of 32-bits')
    }
    for (var i = 0; i < len; i += 4) {
      swap$1(this, i, i + 3);
      swap$1(this, i + 1, i + 2);
    }
    return this
  };

  Buffer.prototype.swap64 = function swap64 () {
    var len = this.length;
    if (len % 8 !== 0) {
      throw new RangeError('Buffer size must be a multiple of 64-bits')
    }
    for (var i = 0; i < len; i += 8) {
      swap$1(this, i, i + 7);
      swap$1(this, i + 1, i + 6);
      swap$1(this, i + 2, i + 5);
      swap$1(this, i + 3, i + 4);
    }
    return this
  };

  Buffer.prototype.toString = function toString () {
    var length = this.length | 0;
    if (length === 0) return ''
    if (arguments.length === 0) return utf8Slice(this, 0, length)
    return slowToString.apply(this, arguments)
  };

  Buffer.prototype.equals = function equals (b) {
    if (!internalIsBuffer(b)) throw new TypeError('Argument must be a Buffer')
    if (this === b) return true
    return Buffer.compare(this, b) === 0
  };

  Buffer.prototype.inspect = function inspect () {
    var str = '';
    var max = INSPECT_MAX_BYTES;
    if (this.length > 0) {
      str = this.toString('hex', 0, max).match(/.{2}/g).join(' ');
      if (this.length > max) str += ' ... ';
    }
    return '<Buffer ' + str + '>'
  };

  Buffer.prototype.compare = function compare (target, start, end, thisStart, thisEnd) {
    if (!internalIsBuffer(target)) {
      throw new TypeError('Argument must be a Buffer')
    }

    if (start === undefined) {
      start = 0;
    }
    if (end === undefined) {
      end = target ? target.length : 0;
    }
    if (thisStart === undefined) {
      thisStart = 0;
    }
    if (thisEnd === undefined) {
      thisEnd = this.length;
    }

    if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
      throw new RangeError('out of range index')
    }

    if (thisStart >= thisEnd && start >= end) {
      return 0
    }
    if (thisStart >= thisEnd) {
      return -1
    }
    if (start >= end) {
      return 1
    }

    start >>>= 0;
    end >>>= 0;
    thisStart >>>= 0;
    thisEnd >>>= 0;

    if (this === target) return 0

    var x = thisEnd - thisStart;
    var y = end - start;
    var len = Math.min(x, y);

    var thisCopy = this.slice(thisStart, thisEnd);
    var targetCopy = target.slice(start, end);

    for (var i = 0; i < len; ++i) {
      if (thisCopy[i] !== targetCopy[i]) {
        x = thisCopy[i];
        y = targetCopy[i];
        break
      }
    }

    if (x < y) return -1
    if (y < x) return 1
    return 0
  };

  // Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
  // OR the last index of `val` in `buffer` at offset <= `byteOffset`.
  //
  // Arguments:
  // - buffer - a Buffer to search
  // - val - a string, Buffer, or number
  // - byteOffset - an index into `buffer`; will be clamped to an int32
  // - encoding - an optional encoding, relevant is val is a string
  // - dir - true for indexOf, false for lastIndexOf
  function bidirectionalIndexOf (buffer, val, byteOffset, encoding, dir) {
    // Empty buffer means no match
    if (buffer.length === 0) return -1

    // Normalize byteOffset
    if (typeof byteOffset === 'string') {
      encoding = byteOffset;
      byteOffset = 0;
    } else if (byteOffset > 0x7fffffff) {
      byteOffset = 0x7fffffff;
    } else if (byteOffset < -0x80000000) {
      byteOffset = -0x80000000;
    }
    byteOffset = +byteOffset;  // Coerce to Number.
    if (isNaN(byteOffset)) {
      // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
      byteOffset = dir ? 0 : (buffer.length - 1);
    }

    // Normalize byteOffset: negative offsets start from the end of the buffer
    if (byteOffset < 0) byteOffset = buffer.length + byteOffset;
    if (byteOffset >= buffer.length) {
      if (dir) return -1
      else byteOffset = buffer.length - 1;
    } else if (byteOffset < 0) {
      if (dir) byteOffset = 0;
      else return -1
    }

    // Normalize val
    if (typeof val === 'string') {
      val = Buffer.from(val, encoding);
    }

    // Finally, search either indexOf (if dir is true) or lastIndexOf
    if (internalIsBuffer(val)) {
      // Special case: looking for empty string/buffer always fails
      if (val.length === 0) {
        return -1
      }
      return arrayIndexOf(buffer, val, byteOffset, encoding, dir)
    } else if (typeof val === 'number') {
      val = val & 0xFF; // Search for a byte value [0-255]
      if (Buffer.TYPED_ARRAY_SUPPORT &&
          typeof Uint8Array.prototype.indexOf === 'function') {
        if (dir) {
          return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset)
        } else {
          return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset)
        }
      }
      return arrayIndexOf(buffer, [ val ], byteOffset, encoding, dir)
    }

    throw new TypeError('val must be string, number or Buffer')
  }

  function arrayIndexOf (arr, val, byteOffset, encoding, dir) {
    var indexSize = 1;
    var arrLength = arr.length;
    var valLength = val.length;

    if (encoding !== undefined) {
      encoding = String(encoding).toLowerCase();
      if (encoding === 'ucs2' || encoding === 'ucs-2' ||
          encoding === 'utf16le' || encoding === 'utf-16le') {
        if (arr.length < 2 || val.length < 2) {
          return -1
        }
        indexSize = 2;
        arrLength /= 2;
        valLength /= 2;
        byteOffset /= 2;
      }
    }

    function read (buf, i) {
      if (indexSize === 1) {
        return buf[i]
      } else {
        return buf.readUInt16BE(i * indexSize)
      }
    }

    var i;
    if (dir) {
      var foundIndex = -1;
      for (i = byteOffset; i < arrLength; i++) {
        if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
          if (foundIndex === -1) foundIndex = i;
          if (i - foundIndex + 1 === valLength) return foundIndex * indexSize
        } else {
          if (foundIndex !== -1) i -= i - foundIndex;
          foundIndex = -1;
        }
      }
    } else {
      if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength;
      for (i = byteOffset; i >= 0; i--) {
        var found = true;
        for (var j = 0; j < valLength; j++) {
          if (read(arr, i + j) !== read(val, j)) {
            found = false;
            break
          }
        }
        if (found) return i
      }
    }

    return -1
  }

  Buffer.prototype.includes = function includes (val, byteOffset, encoding) {
    return this.indexOf(val, byteOffset, encoding) !== -1
  };

  Buffer.prototype.indexOf = function indexOf (val, byteOffset, encoding) {
    return bidirectionalIndexOf(this, val, byteOffset, encoding, true)
  };

  Buffer.prototype.lastIndexOf = function lastIndexOf (val, byteOffset, encoding) {
    return bidirectionalIndexOf(this, val, byteOffset, encoding, false)
  };

  function hexWrite (buf, string, offset, length) {
    offset = Number(offset) || 0;
    var remaining = buf.length - offset;
    if (!length) {
      length = remaining;
    } else {
      length = Number(length);
      if (length > remaining) {
        length = remaining;
      }
    }

    // must be an even number of digits
    var strLen = string.length;
    if (strLen % 2 !== 0) throw new TypeError('Invalid hex string')

    if (length > strLen / 2) {
      length = strLen / 2;
    }
    for (var i = 0; i < length; ++i) {
      var parsed = parseInt(string.substr(i * 2, 2), 16);
      if (isNaN(parsed)) return i
      buf[offset + i] = parsed;
    }
    return i
  }

  function utf8Write (buf, string, offset, length) {
    return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length)
  }

  function asciiWrite (buf, string, offset, length) {
    return blitBuffer(asciiToBytes(string), buf, offset, length)
  }

  function latin1Write (buf, string, offset, length) {
    return asciiWrite(buf, string, offset, length)
  }

  function base64Write (buf, string, offset, length) {
    return blitBuffer(base64ToBytes(string), buf, offset, length)
  }

  function ucs2Write (buf, string, offset, length) {
    return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length)
  }

  Buffer.prototype.write = function write (string, offset, length, encoding) {
    // Buffer#write(string)
    if (offset === undefined) {
      encoding = 'utf8';
      length = this.length;
      offset = 0;
    // Buffer#write(string, encoding)
    } else if (length === undefined && typeof offset === 'string') {
      encoding = offset;
      length = this.length;
      offset = 0;
    // Buffer#write(string, offset[, length][, encoding])
    } else if (isFinite(offset)) {
      offset = offset | 0;
      if (isFinite(length)) {
        length = length | 0;
        if (encoding === undefined) encoding = 'utf8';
      } else {
        encoding = length;
        length = undefined;
      }
    // legacy write(string, encoding, offset, length) - remove in v0.13
    } else {
      throw new Error(
        'Buffer.write(string, encoding, offset[, length]) is no longer supported'
      )
    }

    var remaining = this.length - offset;
    if (length === undefined || length > remaining) length = remaining;

    if ((string.length > 0 && (length < 0 || offset < 0)) || offset > this.length) {
      throw new RangeError('Attempt to write outside buffer bounds')
    }

    if (!encoding) encoding = 'utf8';

    var loweredCase = false;
    for (;;) {
      switch (encoding) {
        case 'hex':
          return hexWrite(this, string, offset, length)

        case 'utf8':
        case 'utf-8':
          return utf8Write(this, string, offset, length)

        case 'ascii':
          return asciiWrite(this, string, offset, length)

        case 'latin1':
        case 'binary':
          return latin1Write(this, string, offset, length)

        case 'base64':
          // Warning: maxLength not taken into account in base64Write
          return base64Write(this, string, offset, length)

        case 'ucs2':
        case 'ucs-2':
        case 'utf16le':
        case 'utf-16le':
          return ucs2Write(this, string, offset, length)

        default:
          if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
          encoding = ('' + encoding).toLowerCase();
          loweredCase = true;
      }
    }
  };

  Buffer.prototype.toJSON = function toJSON () {
    return {
      type: 'Buffer',
      data: Array.prototype.slice.call(this._arr || this, 0)
    }
  };

  function base64Slice (buf, start, end) {
    if (start === 0 && end === buf.length) {
      return fromByteArray(buf)
    } else {
      return fromByteArray(buf.slice(start, end))
    }
  }

  function utf8Slice (buf, start, end) {
    end = Math.min(buf.length, end);
    var res = [];

    var i = start;
    while (i < end) {
      var firstByte = buf[i];
      var codePoint = null;
      var bytesPerSequence = (firstByte > 0xEF) ? 4
        : (firstByte > 0xDF) ? 3
        : (firstByte > 0xBF) ? 2
        : 1;

      if (i + bytesPerSequence <= end) {
        var secondByte, thirdByte, fourthByte, tempCodePoint;

        switch (bytesPerSequence) {
          case 1:
            if (firstByte < 0x80) {
              codePoint = firstByte;
            }
            break
          case 2:
            secondByte = buf[i + 1];
            if ((secondByte & 0xC0) === 0x80) {
              tempCodePoint = (firstByte & 0x1F) << 0x6 | (secondByte & 0x3F);
              if (tempCodePoint > 0x7F) {
                codePoint = tempCodePoint;
              }
            }
            break
          case 3:
            secondByte = buf[i + 1];
            thirdByte = buf[i + 2];
            if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {
              tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | (thirdByte & 0x3F);
              if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {
                codePoint = tempCodePoint;
              }
            }
            break
          case 4:
            secondByte = buf[i + 1];
            thirdByte = buf[i + 2];
            fourthByte = buf[i + 3];
            if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {
              tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | (fourthByte & 0x3F);
              if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {
                codePoint = tempCodePoint;
              }
            }
        }
      }

      if (codePoint === null) {
        // we did not generate a valid codePoint so insert a
        // replacement char (U+FFFD) and advance only 1 byte
        codePoint = 0xFFFD;
        bytesPerSequence = 1;
      } else if (codePoint > 0xFFFF) {
        // encode to utf16 (surrogate pair dance)
        codePoint -= 0x10000;
        res.push(codePoint >>> 10 & 0x3FF | 0xD800);
        codePoint = 0xDC00 | codePoint & 0x3FF;
      }

      res.push(codePoint);
      i += bytesPerSequence;
    }

    return decodeCodePointsArray(res)
  }

  // Based on http://stackoverflow.com/a/22747272/680742, the browser with
  // the lowest limit is Chrome, with 0x10000 args.
  // We go 1 magnitude less, for safety
  var MAX_ARGUMENTS_LENGTH = 0x1000;

  function decodeCodePointsArray (codePoints) {
    var len = codePoints.length;
    if (len <= MAX_ARGUMENTS_LENGTH) {
      return String.fromCharCode.apply(String, codePoints) // avoid extra slice()
    }

    // Decode in chunks to avoid "call stack size exceeded".
    var res = '';
    var i = 0;
    while (i < len) {
      res += String.fromCharCode.apply(
        String,
        codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH)
      );
    }
    return res
  }

  function asciiSlice (buf, start, end) {
    var ret = '';
    end = Math.min(buf.length, end);

    for (var i = start; i < end; ++i) {
      ret += String.fromCharCode(buf[i] & 0x7F);
    }
    return ret
  }

  function latin1Slice (buf, start, end) {
    var ret = '';
    end = Math.min(buf.length, end);

    for (var i = start; i < end; ++i) {
      ret += String.fromCharCode(buf[i]);
    }
    return ret
  }

  function hexSlice (buf, start, end) {
    var len = buf.length;

    if (!start || start < 0) start = 0;
    if (!end || end < 0 || end > len) end = len;

    var out = '';
    for (var i = start; i < end; ++i) {
      out += toHex(buf[i]);
    }
    return out
  }

  function utf16leSlice (buf, start, end) {
    var bytes = buf.slice(start, end);
    var res = '';
    for (var i = 0; i < bytes.length; i += 2) {
      res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256);
    }
    return res
  }

  Buffer.prototype.slice = function slice (start, end) {
    var len = this.length;
    start = ~~start;
    end = end === undefined ? len : ~~end;

    if (start < 0) {
      start += len;
      if (start < 0) start = 0;
    } else if (start > len) {
      start = len;
    }

    if (end < 0) {
      end += len;
      if (end < 0) end = 0;
    } else if (end > len) {
      end = len;
    }

    if (end < start) end = start;

    var newBuf;
    if (Buffer.TYPED_ARRAY_SUPPORT) {
      newBuf = this.subarray(start, end);
      newBuf.__proto__ = Buffer.prototype;
    } else {
      var sliceLen = end - start;
      newBuf = new Buffer(sliceLen, undefined);
      for (var i = 0; i < sliceLen; ++i) {
        newBuf[i] = this[i + start];
      }
    }

    return newBuf
  };

  /*
   * Need to make sure that buffer isn't trying to write out of bounds.
   */
  function checkOffset (offset, ext, length) {
    if ((offset % 1) !== 0 || offset < 0) throw new RangeError('offset is not uint')
    if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length')
  }

  Buffer.prototype.readUIntLE = function readUIntLE (offset, byteLength, noAssert) {
    offset = offset | 0;
    byteLength = byteLength | 0;
    if (!noAssert) checkOffset(offset, byteLength, this.length);

    var val = this[offset];
    var mul = 1;
    var i = 0;
    while (++i < byteLength && (mul *= 0x100)) {
      val += this[offset + i] * mul;
    }

    return val
  };

  Buffer.prototype.readUIntBE = function readUIntBE (offset, byteLength, noAssert) {
    offset = offset | 0;
    byteLength = byteLength | 0;
    if (!noAssert) {
      checkOffset(offset, byteLength, this.length);
    }

    var val = this[offset + --byteLength];
    var mul = 1;
    while (byteLength > 0 && (mul *= 0x100)) {
      val += this[offset + --byteLength] * mul;
    }

    return val
  };

  Buffer.prototype.readUInt8 = function readUInt8 (offset, noAssert) {
    if (!noAssert) checkOffset(offset, 1, this.length);
    return this[offset]
  };

  Buffer.prototype.readUInt16LE = function readUInt16LE (offset, noAssert) {
    if (!noAssert) checkOffset(offset, 2, this.length);
    return this[offset] | (this[offset + 1] << 8)
  };

  Buffer.prototype.readUInt16BE = function readUInt16BE (offset, noAssert) {
    if (!noAssert) checkOffset(offset, 2, this.length);
    return (this[offset] << 8) | this[offset + 1]
  };

  Buffer.prototype.readUInt32LE = function readUInt32LE (offset, noAssert) {
    if (!noAssert) checkOffset(offset, 4, this.length);

    return ((this[offset]) |
        (this[offset + 1] << 8) |
        (this[offset + 2] << 16)) +
        (this[offset + 3] * 0x1000000)
  };

  Buffer.prototype.readUInt32BE = function readUInt32BE (offset, noAssert) {
    if (!noAssert) checkOffset(offset, 4, this.length);

    return (this[offset] * 0x1000000) +
      ((this[offset + 1] << 16) |
      (this[offset + 2] << 8) |
      this[offset + 3])
  };

  Buffer.prototype.readIntLE = function readIntLE (offset, byteLength, noAssert) {
    offset = offset | 0;
    byteLength = byteLength | 0;
    if (!noAssert) checkOffset(offset, byteLength, this.length);

    var val = this[offset];
    var mul = 1;
    var i = 0;
    while (++i < byteLength && (mul *= 0x100)) {
      val += this[offset + i] * mul;
    }
    mul *= 0x80;

    if (val >= mul) val -= Math.pow(2, 8 * byteLength);

    return val
  };

  Buffer.prototype.readIntBE = function readIntBE (offset, byteLength, noAssert) {
    offset = offset | 0;
    byteLength = byteLength | 0;
    if (!noAssert) checkOffset(offset, byteLength, this.length);

    var i = byteLength;
    var mul = 1;
    var val = this[offset + --i];
    while (i > 0 && (mul *= 0x100)) {
      val += this[offset + --i] * mul;
    }
    mul *= 0x80;

    if (val >= mul) val -= Math.pow(2, 8 * byteLength);

    return val
  };

  Buffer.prototype.readInt8 = function readInt8 (offset, noAssert) {
    if (!noAssert) checkOffset(offset, 1, this.length);
    if (!(this[offset] & 0x80)) return (this[offset])
    return ((0xff - this[offset] + 1) * -1)
  };

  Buffer.prototype.readInt16LE = function readInt16LE (offset, noAssert) {
    if (!noAssert) checkOffset(offset, 2, this.length);
    var val = this[offset] | (this[offset + 1] << 8);
    return (val & 0x8000) ? val | 0xFFFF0000 : val
  };

  Buffer.prototype.readInt16BE = function readInt16BE (offset, noAssert) {
    if (!noAssert) checkOffset(offset, 2, this.length);
    var val = this[offset + 1] | (this[offset] << 8);
    return (val & 0x8000) ? val | 0xFFFF0000 : val
  };

  Buffer.prototype.readInt32LE = function readInt32LE (offset, noAssert) {
    if (!noAssert) checkOffset(offset, 4, this.length);

    return (this[offset]) |
      (this[offset + 1] << 8) |
      (this[offset + 2] << 16) |
      (this[offset + 3] << 24)
  };

  Buffer.prototype.readInt32BE = function readInt32BE (offset, noAssert) {
    if (!noAssert) checkOffset(offset, 4, this.length);

    return (this[offset] << 24) |
      (this[offset + 1] << 16) |
      (this[offset + 2] << 8) |
      (this[offset + 3])
  };

  Buffer.prototype.readFloatLE = function readFloatLE (offset, noAssert) {
    if (!noAssert) checkOffset(offset, 4, this.length);
    return read(this, offset, true, 23, 4)
  };

  Buffer.prototype.readFloatBE = function readFloatBE (offset, noAssert) {
    if (!noAssert) checkOffset(offset, 4, this.length);
    return read(this, offset, false, 23, 4)
  };

  Buffer.prototype.readDoubleLE = function readDoubleLE (offset, noAssert) {
    if (!noAssert) checkOffset(offset, 8, this.length);
    return read(this, offset, true, 52, 8)
  };

  Buffer.prototype.readDoubleBE = function readDoubleBE (offset, noAssert) {
    if (!noAssert) checkOffset(offset, 8, this.length);
    return read(this, offset, false, 52, 8)
  };

  function checkInt (buf, value, offset, ext, max, min) {
    if (!internalIsBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance')
    if (value > max || value < min) throw new RangeError('"value" argument is out of bounds')
    if (offset + ext > buf.length) throw new RangeError('Index out of range')
  }

  Buffer.prototype.writeUIntLE = function writeUIntLE (value, offset, byteLength, noAssert) {
    value = +value;
    offset = offset | 0;
    byteLength = byteLength | 0;
    if (!noAssert) {
      var maxBytes = Math.pow(2, 8 * byteLength) - 1;
      checkInt(this, value, offset, byteLength, maxBytes, 0);
    }

    var mul = 1;
    var i = 0;
    this[offset] = value & 0xFF;
    while (++i < byteLength && (mul *= 0x100)) {
      this[offset + i] = (value / mul) & 0xFF;
    }

    return offset + byteLength
  };

  Buffer.prototype.writeUIntBE = function writeUIntBE (value, offset, byteLength, noAssert) {
    value = +value;
    offset = offset | 0;
    byteLength = byteLength | 0;
    if (!noAssert) {
      var maxBytes = Math.pow(2, 8 * byteLength) - 1;
      checkInt(this, value, offset, byteLength, maxBytes, 0);
    }

    var i = byteLength - 1;
    var mul = 1;
    this[offset + i] = value & 0xFF;
    while (--i >= 0 && (mul *= 0x100)) {
      this[offset + i] = (value / mul) & 0xFF;
    }

    return offset + byteLength
  };

  Buffer.prototype.writeUInt8 = function writeUInt8 (value, offset, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0);
    if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value);
    this[offset] = (value & 0xff);
    return offset + 1
  };

  function objectWriteUInt16 (buf, value, offset, littleEndian) {
    if (value < 0) value = 0xffff + value + 1;
    for (var i = 0, j = Math.min(buf.length - offset, 2); i < j; ++i) {
      buf[offset + i] = (value & (0xff << (8 * (littleEndian ? i : 1 - i)))) >>>
        (littleEndian ? i : 1 - i) * 8;
    }
  }

  Buffer.prototype.writeUInt16LE = function writeUInt16LE (value, offset, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0);
    if (Buffer.TYPED_ARRAY_SUPPORT) {
      this[offset] = (value & 0xff);
      this[offset + 1] = (value >>> 8);
    } else {
      objectWriteUInt16(this, value, offset, true);
    }
    return offset + 2
  };

  Buffer.prototype.writeUInt16BE = function writeUInt16BE (value, offset, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0);
    if (Buffer.TYPED_ARRAY_SUPPORT) {
      this[offset] = (value >>> 8);
      this[offset + 1] = (value & 0xff);
    } else {
      objectWriteUInt16(this, value, offset, false);
    }
    return offset + 2
  };

  function objectWriteUInt32 (buf, value, offset, littleEndian) {
    if (value < 0) value = 0xffffffff + value + 1;
    for (var i = 0, j = Math.min(buf.length - offset, 4); i < j; ++i) {
      buf[offset + i] = (value >>> (littleEndian ? i : 3 - i) * 8) & 0xff;
    }
  }

  Buffer.prototype.writeUInt32LE = function writeUInt32LE (value, offset, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0);
    if (Buffer.TYPED_ARRAY_SUPPORT) {
      this[offset + 3] = (value >>> 24);
      this[offset + 2] = (value >>> 16);
      this[offset + 1] = (value >>> 8);
      this[offset] = (value & 0xff);
    } else {
      objectWriteUInt32(this, value, offset, true);
    }
    return offset + 4
  };

  Buffer.prototype.writeUInt32BE = function writeUInt32BE (value, offset, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0);
    if (Buffer.TYPED_ARRAY_SUPPORT) {
      this[offset] = (value >>> 24);
      this[offset + 1] = (value >>> 16);
      this[offset + 2] = (value >>> 8);
      this[offset + 3] = (value & 0xff);
    } else {
      objectWriteUInt32(this, value, offset, false);
    }
    return offset + 4
  };

  Buffer.prototype.writeIntLE = function writeIntLE (value, offset, byteLength, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) {
      var limit = Math.pow(2, 8 * byteLength - 1);

      checkInt(this, value, offset, byteLength, limit - 1, -limit);
    }

    var i = 0;
    var mul = 1;
    var sub = 0;
    this[offset] = value & 0xFF;
    while (++i < byteLength && (mul *= 0x100)) {
      if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
        sub = 1;
      }
      this[offset + i] = ((value / mul) >> 0) - sub & 0xFF;
    }

    return offset + byteLength
  };

  Buffer.prototype.writeIntBE = function writeIntBE (value, offset, byteLength, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) {
      var limit = Math.pow(2, 8 * byteLength - 1);

      checkInt(this, value, offset, byteLength, limit - 1, -limit);
    }

    var i = byteLength - 1;
    var mul = 1;
    var sub = 0;
    this[offset + i] = value & 0xFF;
    while (--i >= 0 && (mul *= 0x100)) {
      if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
        sub = 1;
      }
      this[offset + i] = ((value / mul) >> 0) - sub & 0xFF;
    }

    return offset + byteLength
  };

  Buffer.prototype.writeInt8 = function writeInt8 (value, offset, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -0x80);
    if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value);
    if (value < 0) value = 0xff + value + 1;
    this[offset] = (value & 0xff);
    return offset + 1
  };

  Buffer.prototype.writeInt16LE = function writeInt16LE (value, offset, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000);
    if (Buffer.TYPED_ARRAY_SUPPORT) {
      this[offset] = (value & 0xff);
      this[offset + 1] = (value >>> 8);
    } else {
      objectWriteUInt16(this, value, offset, true);
    }
    return offset + 2
  };

  Buffer.prototype.writeInt16BE = function writeInt16BE (value, offset, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000);
    if (Buffer.TYPED_ARRAY_SUPPORT) {
      this[offset] = (value >>> 8);
      this[offset + 1] = (value & 0xff);
    } else {
      objectWriteUInt16(this, value, offset, false);
    }
    return offset + 2
  };

  Buffer.prototype.writeInt32LE = function writeInt32LE (value, offset, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000);
    if (Buffer.TYPED_ARRAY_SUPPORT) {
      this[offset] = (value & 0xff);
      this[offset + 1] = (value >>> 8);
      this[offset + 2] = (value >>> 16);
      this[offset + 3] = (value >>> 24);
    } else {
      objectWriteUInt32(this, value, offset, true);
    }
    return offset + 4
  };

  Buffer.prototype.writeInt32BE = function writeInt32BE (value, offset, noAssert) {
    value = +value;
    offset = offset | 0;
    if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000);
    if (value < 0) value = 0xffffffff + value + 1;
    if (Buffer.TYPED_ARRAY_SUPPORT) {
      this[offset] = (value >>> 24);
      this[offset + 1] = (value >>> 16);
      this[offset + 2] = (value >>> 8);
      this[offset + 3] = (value & 0xff);
    } else {
      objectWriteUInt32(this, value, offset, false);
    }
    return offset + 4
  };

  function checkIEEE754 (buf, value, offset, ext, max, min) {
    if (offset + ext > buf.length) throw new RangeError('Index out of range')
    if (offset < 0) throw new RangeError('Index out of range')
  }

  function writeFloat (buf, value, offset, littleEndian, noAssert) {
    if (!noAssert) {
      checkIEEE754(buf, value, offset, 4);
    }
    write(buf, value, offset, littleEndian, 23, 4);
    return offset + 4
  }

  Buffer.prototype.writeFloatLE = function writeFloatLE (value, offset, noAssert) {
    return writeFloat(this, value, offset, true, noAssert)
  };

  Buffer.prototype.writeFloatBE = function writeFloatBE (value, offset, noAssert) {
    return writeFloat(this, value, offset, false, noAssert)
  };

  function writeDouble (buf, value, offset, littleEndian, noAssert) {
    if (!noAssert) {
      checkIEEE754(buf, value, offset, 8);
    }
    write(buf, value, offset, littleEndian, 52, 8);
    return offset + 8
  }

  Buffer.prototype.writeDoubleLE = function writeDoubleLE (value, offset, noAssert) {
    return writeDouble(this, value, offset, true, noAssert)
  };

  Buffer.prototype.writeDoubleBE = function writeDoubleBE (value, offset, noAssert) {
    return writeDouble(this, value, offset, false, noAssert)
  };

  // copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)
  Buffer.prototype.copy = function copy (target, targetStart, start, end) {
    if (!start) start = 0;
    if (!end && end !== 0) end = this.length;
    if (targetStart >= target.length) targetStart = target.length;
    if (!targetStart) targetStart = 0;
    if (end > 0 && end < start) end = start;

    // Copy 0 bytes; we're done
    if (end === start) return 0
    if (target.length === 0 || this.length === 0) return 0

    // Fatal error conditions
    if (targetStart < 0) {
      throw new RangeError('targetStart out of bounds')
    }
    if (start < 0 || start >= this.length) throw new RangeError('sourceStart out of bounds')
    if (end < 0) throw new RangeError('sourceEnd out of bounds')

    // Are we oob?
    if (end > this.length) end = this.length;
    if (target.length - targetStart < end - start) {
      end = target.length - targetStart + start;
    }

    var len = end - start;
    var i;

    if (this === target && start < targetStart && targetStart < end) {
      // descending copy from end
      for (i = len - 1; i >= 0; --i) {
        target[i + targetStart] = this[i + start];
      }
    } else if (len < 1000 || !Buffer.TYPED_ARRAY_SUPPORT) {
      // ascending copy from start
      for (i = 0; i < len; ++i) {
        target[i + targetStart] = this[i + start];
      }
    } else {
      Uint8Array.prototype.set.call(
        target,
        this.subarray(start, start + len),
        targetStart
      );
    }

    return len
  };

  // Usage:
  //    buffer.fill(number[, offset[, end]])
  //    buffer.fill(buffer[, offset[, end]])
  //    buffer.fill(string[, offset[, end]][, encoding])
  Buffer.prototype.fill = function fill (val, start, end, encoding) {
    // Handle string cases:
    if (typeof val === 'string') {
      if (typeof start === 'string') {
        encoding = start;
        start = 0;
        end = this.length;
      } else if (typeof end === 'string') {
        encoding = end;
        end = this.length;
      }
      if (val.length === 1) {
        var code = val.charCodeAt(0);
        if (code < 256) {
          val = code;
        }
      }
      if (encoding !== undefined && typeof encoding !== 'string') {
        throw new TypeError('encoding must be a string')
      }
      if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {
        throw new TypeError('Unknown encoding: ' + encoding)
      }
    } else if (typeof val === 'number') {
      val = val & 255;
    }

    // Invalid ranges are not set to a default, so can range check early.
    if (start < 0 || this.length < start || this.length < end) {
      throw new RangeError('Out of range index')
    }

    if (end <= start) {
      return this
    }

    start = start >>> 0;
    end = end === undefined ? this.length : end >>> 0;

    if (!val) val = 0;

    var i;
    if (typeof val === 'number') {
      for (i = start; i < end; ++i) {
        this[i] = val;
      }
    } else {
      var bytes = internalIsBuffer(val)
        ? val
        : utf8ToBytes(new Buffer(val, encoding).toString());
      var len = bytes.length;
      for (i = 0; i < end - start; ++i) {
        this[i + start] = bytes[i % len];
      }
    }

    return this
  };

  // HELPER FUNCTIONS
  // ================

  var INVALID_BASE64_RE = /[^+\/0-9A-Za-z-_]/g;

  function base64clean (str) {
    // Node strips out invalid characters like \n and \t from the string, base64-js does not
    str = stringtrim(str).replace(INVALID_BASE64_RE, '');
    // Node converts strings with length < 2 to ''
    if (str.length < 2) return ''
    // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not
    while (str.length % 4 !== 0) {
      str = str + '=';
    }
    return str
  }

  function stringtrim (str) {
    if (str.trim) return str.trim()
    return str.replace(/^\s+|\s+$/g, '')
  }

  function toHex (n) {
    if (n < 16) return '0' + n.toString(16)
    return n.toString(16)
  }

  function utf8ToBytes (string, units) {
    units = units || Infinity;
    var codePoint;
    var length = string.length;
    var leadSurrogate = null;
    var bytes = [];

    for (var i = 0; i < length; ++i) {
      codePoint = string.charCodeAt(i);

      // is surrogate component
      if (codePoint > 0xD7FF && codePoint < 0xE000) {
        // last char was a lead
        if (!leadSurrogate) {
          // no lead yet
          if (codePoint > 0xDBFF) {
            // unexpected trail
            if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
            continue
          } else if (i + 1 === length) {
            // unpaired lead
            if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
            continue
          }

          // valid lead
          leadSurrogate = codePoint;

          continue
        }

        // 2 leads in a row
        if (codePoint < 0xDC00) {
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
          leadSurrogate = codePoint;
          continue
        }

        // valid surrogate pair
        codePoint = (leadSurrogate - 0xD800 << 10 | codePoint - 0xDC00) + 0x10000;
      } else if (leadSurrogate) {
        // valid bmp char, but last char was a lead
        if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
      }

      leadSurrogate = null;

      // encode utf8
      if (codePoint < 0x80) {
        if ((units -= 1) < 0) break
        bytes.push(codePoint);
      } else if (codePoint < 0x800) {
        if ((units -= 2) < 0) break
        bytes.push(
          codePoint >> 0x6 | 0xC0,
          codePoint & 0x3F | 0x80
        );
      } else if (codePoint < 0x10000) {
        if ((units -= 3) < 0) break
        bytes.push(
          codePoint >> 0xC | 0xE0,
          codePoint >> 0x6 & 0x3F | 0x80,
          codePoint & 0x3F | 0x80
        );
      } else if (codePoint < 0x110000) {
        if ((units -= 4) < 0) break
        bytes.push(
          codePoint >> 0x12 | 0xF0,
          codePoint >> 0xC & 0x3F | 0x80,
          codePoint >> 0x6 & 0x3F | 0x80,
          codePoint & 0x3F | 0x80
        );
      } else {
        throw new Error('Invalid code point')
      }
    }

    return bytes
  }

  function asciiToBytes (str) {
    var byteArray = [];
    for (var i = 0; i < str.length; ++i) {
      // Node's code seems to be doing this and not & 0x7F..
      byteArray.push(str.charCodeAt(i) & 0xFF);
    }
    return byteArray
  }

  function utf16leToBytes (str, units) {
    var c, hi, lo;
    var byteArray = [];
    for (var i = 0; i < str.length; ++i) {
      if ((units -= 2) < 0) break

      c = str.charCodeAt(i);
      hi = c >> 8;
      lo = c % 256;
      byteArray.push(lo);
      byteArray.push(hi);
    }

    return byteArray
  }


  function base64ToBytes (str) {
    return toByteArray(base64clean(str))
  }

  function blitBuffer (src, dst, offset, length) {
    for (var i = 0; i < length; ++i) {
      if ((i + offset >= dst.length) || (i >= src.length)) break
      dst[i + offset] = src[i];
    }
    return i
  }

  function isnan (val) {
    return val !== val // eslint-disable-line no-self-compare
  }


  // the following is from is-buffer, also by Feross Aboukhadijeh and with same lisence
  // The _isBuffer check is for Safari 5-7 support, because it's missing
  // Object.prototype.constructor. Remove this eventually
  function isBuffer(obj) {
    return obj != null && (!!obj._isBuffer || isFastBuffer(obj) || isSlowBuffer(obj))
  }

  function isFastBuffer (obj) {
    return !!obj.constructor && typeof obj.constructor.isBuffer === 'function' && obj.constructor.isBuffer(obj)
  }

  // For Node v0.10 support. Remove this eventually.
  function isSlowBuffer (obj) {
    return typeof obj.readFloatLE === 'function' && typeof obj.slice === 'function' && isFastBuffer(obj.slice(0, 0))
  }

  // Copyright Joyent, Inc. and other Node contributors.
  //
  // Permission is hereby granted, free of charge, to any person obtaining a
  // copy of this software and associated documentation files (the
  // "Software"), to deal in the Software without restriction, including
  // without limitation the rights to use, copy, modify, merge, publish,
  // distribute, sublicense, and/or sell copies of the Software, and to permit
  // persons to whom the Software is furnished to do so, subject to the
  // following conditions:
  //
  // The above copyright notice and this permission notice shall be included
  // in all copies or substantial portions of the Software.
  //
  // THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  // OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  // MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
  // NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
  // DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
  // OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
  // USE OR OTHER DEALINGS IN THE SOFTWARE.

  // resolves . and .. elements in a path array with directory names there
  // must be no slashes, empty elements, or device names (c:\) in the array
  // (so also no leading and trailing slashes - it does not distinguish
  // relative and absolute paths)
  function normalizeArray(parts, allowAboveRoot) {
    // if the path tries to go above the root, `up` ends up > 0
    var up = 0;
    for (var i = parts.length - 1; i >= 0; i--) {
      var last = parts[i];
      if (last === '.') {
        parts.splice(i, 1);
      } else if (last === '..') {
        parts.splice(i, 1);
        up++;
      } else if (up) {
        parts.splice(i, 1);
        up--;
      }
    }

    // if the path is allowed to go above the root, restore leading ..s
    if (allowAboveRoot) {
      for (; up--; up) {
        parts.unshift('..');
      }
    }

    return parts;
  }

  // Split a filename into [root, dir, basename, ext], unix version
  // 'root' is just a slash, or nothing.
  var splitPathRe =
      /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
  var splitPath = function(filename) {
    return splitPathRe.exec(filename).slice(1);
  };

  // path.resolve([from ...], to)
  // posix version
  function resolve$3() {
    var resolvedPath = '',
        resolvedAbsolute = false;

    for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
      var path = (i >= 0) ? arguments[i] : '/';

      // Skip empty and invalid entries
      if (typeof path !== 'string') {
        throw new TypeError('Arguments to path.resolve must be strings');
      } else if (!path) {
        continue;
      }

      resolvedPath = path + '/' + resolvedPath;
      resolvedAbsolute = path.charAt(0) === '/';
    }

    // At this point the path should be resolved to a full absolute path, but
    // handle relative paths to be safe (might happen when process.cwd() fails)

    // Normalize the path
    resolvedPath = normalizeArray(filter$1(resolvedPath.split('/'), function(p) {
      return !!p;
    }), !resolvedAbsolute).join('/');

    return ((resolvedAbsolute ? '/' : '') + resolvedPath) || '.';
  }
  // path.normalize(path)
  // posix version
  function normalize$1(path) {
    var isPathAbsolute = isAbsolute$1(path),
        trailingSlash = substr(path, -1) === '/';

    // Normalize the path
    path = normalizeArray(filter$1(path.split('/'), function(p) {
      return !!p;
    }), !isPathAbsolute).join('/');

    if (!path && !isPathAbsolute) {
      path = '.';
    }
    if (path && trailingSlash) {
      path += '/';
    }

    return (isPathAbsolute ? '/' : '') + path;
  }
  // posix version
  function isAbsolute$1(path) {
    return path.charAt(0) === '/';
  }

  // posix version
  function join$1() {
    var paths = Array.prototype.slice.call(arguments, 0);
    return normalize$1(filter$1(paths, function(p, index) {
      if (typeof p !== 'string') {
        throw new TypeError('Arguments to path.join must be strings');
      }
      return p;
    }).join('/'));
  }


  // path.relative(from, to)
  // posix version
  function relative$1(from, to) {
    from = resolve$3(from).substr(1);
    to = resolve$3(to).substr(1);

    function trim(arr) {
      var start = 0;
      for (; start < arr.length; start++) {
        if (arr[start] !== '') break;
      }

      var end = arr.length - 1;
      for (; end >= 0; end--) {
        if (arr[end] !== '') break;
      }

      if (start > end) return [];
      return arr.slice(start, end - start + 1);
    }

    var fromParts = trim(from.split('/'));
    var toParts = trim(to.split('/'));

    var length = Math.min(fromParts.length, toParts.length);
    var samePartsLength = length;
    for (var i = 0; i < length; i++) {
      if (fromParts[i] !== toParts[i]) {
        samePartsLength = i;
        break;
      }
    }

    var outputParts = [];
    for (var i = samePartsLength; i < fromParts.length; i++) {
      outputParts.push('..');
    }

    outputParts = outputParts.concat(toParts.slice(samePartsLength));

    return outputParts.join('/');
  }

  var sep$1 = '/';
  var delimiter$1 = ':';

  function dirname$2(path) {
    var result = splitPath(path),
        root = result[0],
        dir = result[1];

    if (!root && !dir) {
      // No dirname whatsoever
      return '.';
    }

    if (dir) {
      // It has a dirname, strip trailing slash
      dir = dir.substr(0, dir.length - 1);
    }

    return root + dir;
  }

  function basename(path, ext) {
    var f = splitPath(path)[2];
    // TODO: make this comparison case-insensitive on windows?
    if (ext && f.substr(-1 * ext.length) === ext) {
      f = f.substr(0, f.length - ext.length);
    }
    return f;
  }


  function extname(path) {
    return splitPath(path)[3];
  }
  var path = {
    extname: extname,
    basename: basename,
    dirname: dirname$2,
    sep: sep$1,
    delimiter: delimiter$1,
    relative: relative$1,
    join: join$1,
    isAbsolute: isAbsolute$1,
    normalize: normalize$1,
    resolve: resolve$3
  };
  function filter$1 (xs, f) {
      if (xs.filter) return xs.filter(f);
      var res = [];
      for (var i = 0; i < xs.length; i++) {
          if (f(xs[i], i, xs)) res.push(xs[i]);
      }
      return res;
  }

  // String.prototype.substr - negative index don't work in IE8
  var substr = 'ab'.substr(-1) === 'b' ?
      function (str, start, len) { return str.substr(start, len) } :
      function (str, start, len) {
          if (start < 0) start = str.length + start;
          return str.substr(start, len);
      }
  ;

  var path$1 = /*#__PURE__*/Object.freeze({
    __proto__: null,
    resolve: resolve$3,
    normalize: normalize$1,
    isAbsolute: isAbsolute$1,
    join: join$1,
    relative: relative$1,
    sep: sep$1,
    delimiter: delimiter$1,
    dirname: dirname$2,
    basename: basename,
    extname: extname,
    'default': path
  });

  /** Highest positive signed 32-bit float value */
  const maxInt = 2147483647; // aka. 0x7FFFFFFF or 2^31-1

  /** Bootstring parameters */
  const base = 36;
  const tMin = 1;
  const tMax = 26;
  const skew = 38;
  const damp = 700;
  const initialBias = 72;
  const initialN = 128; // 0x80
  const delimiter = '-'; // '\x2D'

  /** Regular expressions */
  const regexPunycode = /^xn--/;
  const regexNonASCII = /[^\0-\x7E]/; // non-ASCII chars
  const regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g; // RFC 3490 separators

  /** Error messages */
  const errors = {
  	'overflow': 'Overflow: input needs wider integers to process',
  	'not-basic': 'Illegal input >= 0x80 (not a basic code point)',
  	'invalid-input': 'Invalid input'
  };

  /** Convenience shortcuts */
  const baseMinusTMin = base - tMin;
  const floor = Math.floor;
  const stringFromCharCode = String.fromCharCode;

  /*--------------------------------------------------------------------------*/

  /**
   * A generic error utility function.
   * @private
   * @param {String} type The error type.
   * @returns {Error} Throws a `RangeError` with the applicable error message.
   */
  function error$2(type) {
  	throw new RangeError(errors[type]);
  }

  /**
   * A generic `Array#map` utility function.
   * @private
   * @param {Array} array The array to iterate over.
   * @param {Function} callback The function that gets called for every array
   * item.
   * @returns {Array} A new array of values returned by the callback function.
   */
  function map$1(array, fn) {
  	const result = [];
  	let length = array.length;
  	while (length--) {
  		result[length] = fn(array[length]);
  	}
  	return result;
  }

  /**
   * A simple `Array#map`-like wrapper to work with domain name strings or email
   * addresses.
   * @private
   * @param {String} domain The domain name or email address.
   * @param {Function} callback The function that gets called for every
   * character.
   * @returns {Array} A new string of characters returned by the callback
   * function.
   */
  function mapDomain(string, fn) {
  	const parts = string.split('@');
  	let result = '';
  	if (parts.length > 1) {
  		// In email addresses, only the domain name should be punycoded. Leave
  		// the local part (i.e. everything up to `@`) intact.
  		result = parts[0] + '@';
  		string = parts[1];
  	}
  	// Avoid `split(regex)` for IE8 compatibility. See #17.
  	string = string.replace(regexSeparators, '\x2E');
  	const labels = string.split('.');
  	const encoded = map$1(labels, fn).join('.');
  	return result + encoded;
  }

  /**
   * Creates an array containing the numeric code points of each Unicode
   * character in the string. While JavaScript uses UCS-2 internally,
   * this function will convert a pair of surrogate halves (each of which
   * UCS-2 exposes as separate characters) into a single code point,
   * matching UTF-16.
   * @see `punycode.ucs2.encode`
   * @see <https://mathiasbynens.be/notes/javascript-encoding>
   * @memberOf punycode.ucs2
   * @name decode
   * @param {String} string The Unicode input string (UCS-2).
   * @returns {Array} The new array of code points.
   */
  function ucs2decode(string) {
  	const output = [];
  	let counter = 0;
  	const length = string.length;
  	while (counter < length) {
  		const value = string.charCodeAt(counter++);
  		if (value >= 0xD800 && value <= 0xDBFF && counter < length) {
  			// It's a high surrogate, and there is a next character.
  			const extra = string.charCodeAt(counter++);
  			if ((extra & 0xFC00) == 0xDC00) { // Low surrogate.
  				output.push(((value & 0x3FF) << 10) + (extra & 0x3FF) + 0x10000);
  			} else {
  				// It's an unmatched surrogate; only append this code unit, in case the
  				// next code unit is the high surrogate of a surrogate pair.
  				output.push(value);
  				counter--;
  			}
  		} else {
  			output.push(value);
  		}
  	}
  	return output;
  }

  /**
   * Creates a string based on an array of numeric code points.
   * @see `punycode.ucs2.decode`
   * @memberOf punycode.ucs2
   * @name encode
   * @param {Array} codePoints The array of numeric code points.
   * @returns {String} The new Unicode string (UCS-2).
   */
  const ucs2encode = array => String.fromCodePoint(...array);

  /**
   * Converts a basic code point into a digit/integer.
   * @see `digitToBasic()`
   * @private
   * @param {Number} codePoint The basic numeric code point value.
   * @returns {Number} The numeric value of a basic code point (for use in
   * representing integers) in the range `0` to `base - 1`, or `base` if
   * the code point does not represent a value.
   */
  const basicToDigit = function(codePoint) {
  	if (codePoint - 0x30 < 0x0A) {
  		return codePoint - 0x16;
  	}
  	if (codePoint - 0x41 < 0x1A) {
  		return codePoint - 0x41;
  	}
  	if (codePoint - 0x61 < 0x1A) {
  		return codePoint - 0x61;
  	}
  	return base;
  };

  /**
   * Converts a digit/integer into a basic code point.
   * @see `basicToDigit()`
   * @private
   * @param {Number} digit The numeric value of a basic code point.
   * @returns {Number} The basic code point whose value (when used for
   * representing integers) is `digit`, which needs to be in the range
   * `0` to `base - 1`. If `flag` is non-zero, the uppercase form is
   * used; else, the lowercase form is used. The behavior is undefined
   * if `flag` is non-zero and `digit` has no uppercase form.
   */
  const digitToBasic = function(digit, flag) {
  	//  0..25 map to ASCII a..z or A..Z
  	// 26..35 map to ASCII 0..9
  	return digit + 22 + 75 * (digit < 26) - ((flag != 0) << 5);
  };

  /**
   * Bias adaptation function as per section 3.4 of RFC 3492.
   * https://tools.ietf.org/html/rfc3492#section-3.4
   * @private
   */
  const adapt = function(delta, numPoints, firstTime) {
  	let k = 0;
  	delta = firstTime ? floor(delta / damp) : delta >> 1;
  	delta += floor(delta / numPoints);
  	for (/* no initialization */; delta > baseMinusTMin * tMax >> 1; k += base) {
  		delta = floor(delta / baseMinusTMin);
  	}
  	return floor(k + (baseMinusTMin + 1) * delta / (delta + skew));
  };

  /**
   * Converts a Punycode string of ASCII-only symbols to a string of Unicode
   * symbols.
   * @memberOf punycode
   * @param {String} input The Punycode string of ASCII-only symbols.
   * @returns {String} The resulting string of Unicode symbols.
   */
  const decode$2 = function(input) {
  	// Don't use UCS-2.
  	const output = [];
  	const inputLength = input.length;
  	let i = 0;
  	let n = initialN;
  	let bias = initialBias;

  	// Handle the basic code points: let `basic` be the number of input code
  	// points before the last delimiter, or `0` if there is none, then copy
  	// the first basic code points to the output.

  	let basic = input.lastIndexOf(delimiter);
  	if (basic < 0) {
  		basic = 0;
  	}

  	for (let j = 0; j < basic; ++j) {
  		// if it's not a basic code point
  		if (input.charCodeAt(j) >= 0x80) {
  			error$2('not-basic');
  		}
  		output.push(input.charCodeAt(j));
  	}

  	// Main decoding loop: start just after the last delimiter if any basic code
  	// points were copied; start at the beginning otherwise.

  	for (let index = basic > 0 ? basic + 1 : 0; index < inputLength; /* no final expression */) {

  		// `index` is the index of the next character to be consumed.
  		// Decode a generalized variable-length integer into `delta`,
  		// which gets added to `i`. The overflow checking is easier
  		// if we increase `i` as we go, then subtract off its starting
  		// value at the end to obtain `delta`.
  		let oldi = i;
  		for (let w = 1, k = base; /* no condition */; k += base) {

  			if (index >= inputLength) {
  				error$2('invalid-input');
  			}

  			const digit = basicToDigit(input.charCodeAt(index++));

  			if (digit >= base || digit > floor((maxInt - i) / w)) {
  				error$2('overflow');
  			}

  			i += digit * w;
  			const t = k <= bias ? tMin : (k >= bias + tMax ? tMax : k - bias);

  			if (digit < t) {
  				break;
  			}

  			const baseMinusT = base - t;
  			if (w > floor(maxInt / baseMinusT)) {
  				error$2('overflow');
  			}

  			w *= baseMinusT;

  		}

  		const out = output.length + 1;
  		bias = adapt(i - oldi, out, oldi == 0);

  		// `i` was supposed to wrap around from `out` to `0`,
  		// incrementing `n` each time, so we'll fix that now:
  		if (floor(i / out) > maxInt - n) {
  			error$2('overflow');
  		}

  		n += floor(i / out);
  		i %= out;

  		// Insert `n` at position `i` of the output.
  		output.splice(i++, 0, n);

  	}

  	return String.fromCodePoint(...output);
  };

  /**
   * Converts a string of Unicode symbols (e.g. a domain name label) to a
   * Punycode string of ASCII-only symbols.
   * @memberOf punycode
   * @param {String} input The string of Unicode symbols.
   * @returns {String} The resulting Punycode string of ASCII-only symbols.
   */
  const encode$2 = function(input) {
  	const output = [];

  	// Convert the input in UCS-2 to an array of Unicode code points.
  	input = ucs2decode(input);

  	// Cache the length.
  	let inputLength = input.length;

  	// Initialize the state.
  	let n = initialN;
  	let delta = 0;
  	let bias = initialBias;

  	// Handle the basic code points.
  	for (const currentValue of input) {
  		if (currentValue < 0x80) {
  			output.push(stringFromCharCode(currentValue));
  		}
  	}

  	let basicLength = output.length;
  	let handledCPCount = basicLength;

  	// `handledCPCount` is the number of code points that have been handled;
  	// `basicLength` is the number of basic code points.

  	// Finish the basic string with a delimiter unless it's empty.
  	if (basicLength) {
  		output.push(delimiter);
  	}

  	// Main encoding loop:
  	while (handledCPCount < inputLength) {

  		// All non-basic code points < n have been handled already. Find the next
  		// larger one:
  		let m = maxInt;
  		for (const currentValue of input) {
  			if (currentValue >= n && currentValue < m) {
  				m = currentValue;
  			}
  		}

  		// Increase `delta` enough to advance the decoder's <n,i> state to <m,0>,
  		// but guard against overflow.
  		const handledCPCountPlusOne = handledCPCount + 1;
  		if (m - n > floor((maxInt - delta) / handledCPCountPlusOne)) {
  			error$2('overflow');
  		}

  		delta += (m - n) * handledCPCountPlusOne;
  		n = m;

  		for (const currentValue of input) {
  			if (currentValue < n && ++delta > maxInt) {
  				error$2('overflow');
  			}
  			if (currentValue == n) {
  				// Represent delta as a generalized variable-length integer.
  				let q = delta;
  				for (let k = base; /* no condition */; k += base) {
  					const t = k <= bias ? tMin : (k >= bias + tMax ? tMax : k - bias);
  					if (q < t) {
  						break;
  					}
  					const qMinusT = q - t;
  					const baseMinusT = base - t;
  					output.push(
  						stringFromCharCode(digitToBasic(t + qMinusT % baseMinusT, 0))
  					);
  					q = floor(qMinusT / baseMinusT);
  				}

  				output.push(stringFromCharCode(digitToBasic(q, 0)));
  				bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
  				delta = 0;
  				++handledCPCount;
  			}
  		}

  		++delta;
  		++n;

  	}
  	return output.join('');
  };

  /**
   * Converts a Punycode string representing a domain name or an email address
   * to Unicode. Only the Punycoded parts of the input will be converted, i.e.
   * it doesn't matter if you call it on a string that has already been
   * converted to Unicode.
   * @memberOf punycode
   * @param {String} input The Punycoded domain name or email address to
   * convert to Unicode.
   * @returns {String} The Unicode representation of the given Punycode
   * string.
   */
  const toUnicode$1 = function(input) {
  	return mapDomain(input, function(string) {
  		return regexPunycode.test(string)
  			? decode$2(string.slice(4).toLowerCase())
  			: string;
  	});
  };

  /**
   * Converts a Unicode string representing a domain name or an email address to
   * Punycode. Only the non-ASCII parts of the domain name will be converted,
   * i.e. it doesn't matter if you call it with a domain that's already in
   * ASCII.
   * @memberOf punycode
   * @param {String} input The domain name or email address to convert, as a
   * Unicode string.
   * @returns {String} The Punycode representation of the given domain name or
   * email address.
   */
  const toASCII$1 = function(input) {
  	return mapDomain(input, function(string) {
  		return regexNonASCII.test(string)
  			? 'xn--' + encode$2(string)
  			: string;
  	});
  };

  /*--------------------------------------------------------------------------*/

  /** Define the public API */
  const punycode$1 = {
  	/**
  	 * A string representing the current Punycode.js version number.
  	 * @memberOf punycode
  	 * @type String
  	 */
  	'version': '2.1.0',
  	/**
  	 * An object of methods to convert from JavaScript's internal character
  	 * representation (UCS-2) to Unicode code points, and back.
  	 * @see <https://mathiasbynens.be/notes/javascript-encoding>
  	 * @memberOf punycode
  	 * @type Object
  	 */
  	'ucs2': {
  		'decode': ucs2decode,
  		'encode': ucs2encode
  	},
  	'decode': decode$2,
  	'encode': encode$2,
  	'toASCII': toASCII$1,
  	'toUnicode': toUnicode$1
  };

  var punycode_es6 = /*#__PURE__*/Object.freeze({
    __proto__: null,
    ucs2decode: ucs2decode,
    ucs2encode: ucs2encode,
    decode: decode$2,
    encode: encode$2,
    toASCII: toASCII$1,
    toUnicode: toUnicode$1,
    'default': punycode$1
  });

  function isNull(arg) {
    return arg === null;
  }

  function isNullOrUndefined(arg) {
    return arg == null;
  }

  function isString(arg) {
    return typeof arg === 'string';
  }

  function isObject(arg) {
    return typeof arg === 'object' && arg !== null;
  }

  // Copyright Joyent, Inc. and other Node contributors.
  //
  // Permission is hereby granted, free of charge, to any person obtaining a
  // copy of this software and associated documentation files (the
  // "Software"), to deal in the Software without restriction, including
  // without limitation the rights to use, copy, modify, merge, publish,
  // distribute, sublicense, and/or sell copies of the Software, and to permit
  // persons to whom the Software is furnished to do so, subject to the
  // following conditions:
  //
  // The above copyright notice and this permission notice shall be included
  // in all copies or substantial portions of the Software.
  //
  // THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  // OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  // MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
  // NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
  // DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
  // OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
  // USE OR OTHER DEALINGS IN THE SOFTWARE.


  // If obj.hasOwnProperty has been overridden, then calling
  // obj.hasOwnProperty(prop) will break.
  // See: https://github.com/joyent/node/issues/1707
  function hasOwnProperty(obj, prop) {
    return Object.prototype.hasOwnProperty.call(obj, prop);
  }
  var isArray = Array.isArray || function (xs) {
    return Object.prototype.toString.call(xs) === '[object Array]';
  };
  function stringifyPrimitive(v) {
    switch (typeof v) {
      case 'string':
        return v;

      case 'boolean':
        return v ? 'true' : 'false';

      case 'number':
        return isFinite(v) ? v : '';

      default:
        return '';
    }
  }

  function stringify$1 (obj, sep, eq, name) {
    sep = sep || '&';
    eq = eq || '=';
    if (obj === null) {
      obj = undefined;
    }

    if (typeof obj === 'object') {
      return map(objectKeys(obj), function(k) {
        var ks = encodeURIComponent(stringifyPrimitive(k)) + eq;
        if (isArray(obj[k])) {
          return map(obj[k], function(v) {
            return ks + encodeURIComponent(stringifyPrimitive(v));
          }).join(sep);
        } else {
          return ks + encodeURIComponent(stringifyPrimitive(obj[k]));
        }
      }).join(sep);

    }

    if (!name) return '';
    return encodeURIComponent(stringifyPrimitive(name)) + eq +
           encodeURIComponent(stringifyPrimitive(obj));
  }
  function map (xs, f) {
    if (xs.map) return xs.map(f);
    var res = [];
    for (var i = 0; i < xs.length; i++) {
      res.push(f(xs[i], i));
    }
    return res;
  }

  var objectKeys = Object.keys || function (obj) {
    var res = [];
    for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) res.push(key);
    }
    return res;
  };

  function parse$7(qs, sep, eq, options) {
    sep = sep || '&';
    eq = eq || '=';
    var obj = {};

    if (typeof qs !== 'string' || qs.length === 0) {
      return obj;
    }

    var regexp = /\+/g;
    qs = qs.split(sep);

    var maxKeys = 1000;
    if (options && typeof options.maxKeys === 'number') {
      maxKeys = options.maxKeys;
    }

    var len = qs.length;
    // maxKeys <= 0 means that we should not limit keys count
    if (maxKeys > 0 && len > maxKeys) {
      len = maxKeys;
    }

    for (var i = 0; i < len; ++i) {
      var x = qs[i].replace(regexp, '%20'),
          idx = x.indexOf(eq),
          kstr, vstr, k, v;

      if (idx >= 0) {
        kstr = x.substr(0, idx);
        vstr = x.substr(idx + 1);
      } else {
        kstr = x;
        vstr = '';
      }

      k = decodeURIComponent(kstr);
      v = decodeURIComponent(vstr);

      if (!hasOwnProperty(obj, k)) {
        obj[k] = v;
      } else if (isArray(obj[k])) {
        obj[k].push(v);
      } else {
        obj[k] = [obj[k], v];
      }
    }

    return obj;
  }

  // Copyright Joyent, Inc. and other Node contributors.
  var url$1 = {
    parse: urlParse,
    resolve: urlResolve,
    resolveObject: urlResolveObject,
    format: urlFormat,
    Url: Url
  };
  function Url() {
    this.protocol = null;
    this.slashes = null;
    this.auth = null;
    this.host = null;
    this.port = null;
    this.hostname = null;
    this.hash = null;
    this.search = null;
    this.query = null;
    this.pathname = null;
    this.path = null;
    this.href = null;
  }

  // Reference: RFC 3986, RFC 1808, RFC 2396

  // define these here so at least they only have to be
  // compiled once on the first module load.
  var protocolPattern = /^([a-z0-9.+-]+:)/i,
    portPattern = /:[0-9]*$/,

    // Special case for a simple path URL
    simplePathPattern = /^(\/\/?(?!\/)[^\?\s]*)(\?[^\s]*)?$/,

    // RFC 2396: characters reserved for delimiting URLs.
    // We actually just auto-escape these.
    delims = ['<', '>', '"', '`', ' ', '\r', '\n', '\t'],

    // RFC 2396: characters not allowed for various reasons.
    unwise = ['{', '}', '|', '\\', '^', '`'].concat(delims),

    // Allowed by RFCs, but cause of XSS attacks.  Always escape these.
    autoEscape = ['\''].concat(unwise),
    // Characters that are never ever allowed in a hostname.
    // Note that any invalid chars are also handled, but these
    // are the ones that are *expected* to be seen, so we fast-path
    // them.
    nonHostChars = ['%', '/', '?', ';', '#'].concat(autoEscape),
    hostEndingChars = ['/', '?', '#'],
    hostnameMaxLen = 255,
    hostnamePartPattern = /^[+a-z0-9A-Z_-]{0,63}$/,
    hostnamePartStart = /^([+a-z0-9A-Z_-]{0,63})(.*)$/,
    // protocols that can allow "unsafe" and "unwise" chars.
    unsafeProtocol = {
      'javascript': true,
      'javascript:': true
    },
    // protocols that never have a hostname.
    hostlessProtocol = {
      'javascript': true,
      'javascript:': true
    },
    // protocols that always contain a // bit.
    slashedProtocol = {
      'http': true,
      'https': true,
      'ftp': true,
      'gopher': true,
      'file': true,
      'http:': true,
      'https:': true,
      'ftp:': true,
      'gopher:': true,
      'file:': true
    };

  function urlParse(url, parseQueryString, slashesDenoteHost) {
    if (url && isObject(url) && url instanceof Url) return url;

    var u = new Url;
    u.parse(url, parseQueryString, slashesDenoteHost);
    return u;
  }
  Url.prototype.parse = function(url, parseQueryString, slashesDenoteHost) {
    return parse$6(this, url, parseQueryString, slashesDenoteHost);
  };

  function parse$6(self, url, parseQueryString, slashesDenoteHost) {
    if (!isString(url)) {
      throw new TypeError('Parameter \'url\' must be a string, not ' + typeof url);
    }

    // Copy chrome, IE, opera backslash-handling behavior.
    // Back slashes before the query string get converted to forward slashes
    // See: https://code.google.com/p/chromium/issues/detail?id=25916
    var queryIndex = url.indexOf('?'),
      splitter =
      (queryIndex !== -1 && queryIndex < url.indexOf('#')) ? '?' : '#',
      uSplit = url.split(splitter),
      slashRegex = /\\/g;
    uSplit[0] = uSplit[0].replace(slashRegex, '/');
    url = uSplit.join(splitter);

    var rest = url;

    // trim before proceeding.
    // This is to support parse stuff like "  http://foo.com  \n"
    rest = rest.trim();

    if (!slashesDenoteHost && url.split('#').length === 1) {
      // Try fast path regexp
      var simplePath = simplePathPattern.exec(rest);
      if (simplePath) {
        self.path = rest;
        self.href = rest;
        self.pathname = simplePath[1];
        if (simplePath[2]) {
          self.search = simplePath[2];
          if (parseQueryString) {
            self.query = parse$7(self.search.substr(1));
          } else {
            self.query = self.search.substr(1);
          }
        } else if (parseQueryString) {
          self.search = '';
          self.query = {};
        }
        return self;
      }
    }

    var proto = protocolPattern.exec(rest);
    if (proto) {
      proto = proto[0];
      var lowerProto = proto.toLowerCase();
      self.protocol = lowerProto;
      rest = rest.substr(proto.length);
    }

    // figure out if it's got a host
    // user@server is *always* interpreted as a hostname, and url
    // resolution will treat //foo/bar as host=foo,path=bar because that's
    // how the browser resolves relative URLs.
    if (slashesDenoteHost || proto || rest.match(/^\/\/[^@\/]+@[^@\/]+/)) {
      var slashes = rest.substr(0, 2) === '//';
      if (slashes && !(proto && hostlessProtocol[proto])) {
        rest = rest.substr(2);
        self.slashes = true;
      }
    }
    var i, hec, l, p;
    if (!hostlessProtocol[proto] &&
      (slashes || (proto && !slashedProtocol[proto]))) {

      // there's a hostname.
      // the first instance of /, ?, ;, or # ends the host.
      //
      // If there is an @ in the hostname, then non-host chars *are* allowed
      // to the left of the last @ sign, unless some host-ending character
      // comes *before* the @-sign.
      // URLs are obnoxious.
      //
      // ex:
      // http://a@b@c/ => user:a@b host:c
      // http://a@b?@c => user:a host:c path:/?@c

      // v0.12 TODO(isaacs): This is not quite how Chrome does things.
      // Review our test case against browsers more comprehensively.

      // find the first instance of any hostEndingChars
      var hostEnd = -1;
      for (i = 0; i < hostEndingChars.length; i++) {
        hec = rest.indexOf(hostEndingChars[i]);
        if (hec !== -1 && (hostEnd === -1 || hec < hostEnd))
          hostEnd = hec;
      }

      // at this point, either we have an explicit point where the
      // auth portion cannot go past, or the last @ char is the decider.
      var auth, atSign;
      if (hostEnd === -1) {
        // atSign can be anywhere.
        atSign = rest.lastIndexOf('@');
      } else {
        // atSign must be in auth portion.
        // http://a@b/c@d => host:b auth:a path:/c@d
        atSign = rest.lastIndexOf('@', hostEnd);
      }

      // Now we have a portion which is definitely the auth.
      // Pull that off.
      if (atSign !== -1) {
        auth = rest.slice(0, atSign);
        rest = rest.slice(atSign + 1);
        self.auth = decodeURIComponent(auth);
      }

      // the host is the remaining to the left of the first non-host char
      hostEnd = -1;
      for (i = 0; i < nonHostChars.length; i++) {
        hec = rest.indexOf(nonHostChars[i]);
        if (hec !== -1 && (hostEnd === -1 || hec < hostEnd))
          hostEnd = hec;
      }
      // if we still have not hit it, then the entire thing is a host.
      if (hostEnd === -1)
        hostEnd = rest.length;

      self.host = rest.slice(0, hostEnd);
      rest = rest.slice(hostEnd);

      // pull out port.
      parseHost(self);

      // we've indicated that there is a hostname,
      // so even if it's empty, it has to be present.
      self.hostname = self.hostname || '';

      // if hostname begins with [ and ends with ]
      // assume that it's an IPv6 address.
      var ipv6Hostname = self.hostname[0] === '[' &&
        self.hostname[self.hostname.length - 1] === ']';

      // validate a little.
      if (!ipv6Hostname) {
        var hostparts = self.hostname.split(/\./);
        for (i = 0, l = hostparts.length; i < l; i++) {
          var part = hostparts[i];
          if (!part) continue;
          if (!part.match(hostnamePartPattern)) {
            var newpart = '';
            for (var j = 0, k = part.length; j < k; j++) {
              if (part.charCodeAt(j) > 127) {
                // we replace non-ASCII char with a temporary placeholder
                // we need this to make sure size of hostname is not
                // broken by replacing non-ASCII by nothing
                newpart += 'x';
              } else {
                newpart += part[j];
              }
            }
            // we test again with ASCII char only
            if (!newpart.match(hostnamePartPattern)) {
              var validParts = hostparts.slice(0, i);
              var notHost = hostparts.slice(i + 1);
              var bit = part.match(hostnamePartStart);
              if (bit) {
                validParts.push(bit[1]);
                notHost.unshift(bit[2]);
              }
              if (notHost.length) {
                rest = '/' + notHost.join('.') + rest;
              }
              self.hostname = validParts.join('.');
              break;
            }
          }
        }
      }

      if (self.hostname.length > hostnameMaxLen) {
        self.hostname = '';
      } else {
        // hostnames are always lower case.
        self.hostname = self.hostname.toLowerCase();
      }

      if (!ipv6Hostname) {
        // IDNA Support: Returns a punycoded representation of "domain".
        // It only converts parts of the domain name that
        // have non-ASCII characters, i.e. it doesn't matter if
        // you call it with a domain that already is ASCII-only.
        self.hostname = toASCII$1(self.hostname);
      }

      p = self.port ? ':' + self.port : '';
      var h = self.hostname || '';
      self.host = h + p;
      self.href += self.host;

      // strip [ and ] from the hostname
      // the host field still retains them, though
      if (ipv6Hostname) {
        self.hostname = self.hostname.substr(1, self.hostname.length - 2);
        if (rest[0] !== '/') {
          rest = '/' + rest;
        }
      }
    }

    // now rest is set to the post-host stuff.
    // chop off any delim chars.
    if (!unsafeProtocol[lowerProto]) {

      // First, make 100% sure that any "autoEscape" chars get
      // escaped, even if encodeURIComponent doesn't think they
      // need to be.
      for (i = 0, l = autoEscape.length; i < l; i++) {
        var ae = autoEscape[i];
        if (rest.indexOf(ae) === -1)
          continue;
        var esc = encodeURIComponent(ae);
        if (esc === ae) {
          esc = escape(ae);
        }
        rest = rest.split(ae).join(esc);
      }
    }


    // chop off from the tail first.
    var hash = rest.indexOf('#');
    if (hash !== -1) {
      // got a fragment string.
      self.hash = rest.substr(hash);
      rest = rest.slice(0, hash);
    }
    var qm = rest.indexOf('?');
    if (qm !== -1) {
      self.search = rest.substr(qm);
      self.query = rest.substr(qm + 1);
      if (parseQueryString) {
        self.query = parse$7(self.query);
      }
      rest = rest.slice(0, qm);
    } else if (parseQueryString) {
      // no query string, but parseQueryString still requested
      self.search = '';
      self.query = {};
    }
    if (rest) self.pathname = rest;
    if (slashedProtocol[lowerProto] &&
      self.hostname && !self.pathname) {
      self.pathname = '/';
    }

    //to support http.request
    if (self.pathname || self.search) {
      p = self.pathname || '';
      var s = self.search || '';
      self.path = p + s;
    }

    // finally, reconstruct the href based on what has been validated.
    self.href = format(self);
    return self;
  }

  // format a parsed object into a url string
  function urlFormat(obj) {
    // ensure it's an object, and not a string url.
    // If it's an obj, this is a no-op.
    // this way, you can call url_format() on strings
    // to clean up potentially wonky urls.
    if (isString(obj)) obj = parse$6({}, obj);
    return format(obj);
  }

  function format(self) {
    var auth = self.auth || '';
    if (auth) {
      auth = encodeURIComponent(auth);
      auth = auth.replace(/%3A/i, ':');
      auth += '@';
    }

    var protocol = self.protocol || '',
      pathname = self.pathname || '',
      hash = self.hash || '',
      host = false,
      query = '';

    if (self.host) {
      host = auth + self.host;
    } else if (self.hostname) {
      host = auth + (self.hostname.indexOf(':') === -1 ?
        self.hostname :
        '[' + this.hostname + ']');
      if (self.port) {
        host += ':' + self.port;
      }
    }

    if (self.query &&
      isObject(self.query) &&
      Object.keys(self.query).length) {
      query = stringify$1(self.query);
    }

    var search = self.search || (query && ('?' + query)) || '';

    if (protocol && protocol.substr(-1) !== ':') protocol += ':';

    // only the slashedProtocols get the //.  Not mailto:, xmpp:, etc.
    // unless they had them to begin with.
    if (self.slashes ||
      (!protocol || slashedProtocol[protocol]) && host !== false) {
      host = '//' + (host || '');
      if (pathname && pathname.charAt(0) !== '/') pathname = '/' + pathname;
    } else if (!host) {
      host = '';
    }

    if (hash && hash.charAt(0) !== '#') hash = '#' + hash;
    if (search && search.charAt(0) !== '?') search = '?' + search;

    pathname = pathname.replace(/[?#]/g, function(match) {
      return encodeURIComponent(match);
    });
    search = search.replace('#', '%23');

    return protocol + host + pathname + search + hash;
  }

  Url.prototype.format = function() {
    return format(this);
  };

  function urlResolve(source, relative) {
    return urlParse(source, false, true).resolve(relative);
  }

  Url.prototype.resolve = function(relative) {
    return this.resolveObject(urlParse(relative, false, true)).format();
  };

  function urlResolveObject(source, relative) {
    if (!source) return relative;
    return urlParse(source, false, true).resolveObject(relative);
  }

  Url.prototype.resolveObject = function(relative) {
    if (isString(relative)) {
      var rel = new Url();
      rel.parse(relative, false, true);
      relative = rel;
    }

    var result = new Url();
    var tkeys = Object.keys(this);
    for (var tk = 0; tk < tkeys.length; tk++) {
      var tkey = tkeys[tk];
      result[tkey] = this[tkey];
    }

    // hash is always overridden, no matter what.
    // even href="" will remove it.
    result.hash = relative.hash;

    // if the relative url is empty, then there's nothing left to do here.
    if (relative.href === '') {
      result.href = result.format();
      return result;
    }

    // hrefs like //foo/bar always cut to the protocol.
    if (relative.slashes && !relative.protocol) {
      // take everything except the protocol from relative
      var rkeys = Object.keys(relative);
      for (var rk = 0; rk < rkeys.length; rk++) {
        var rkey = rkeys[rk];
        if (rkey !== 'protocol')
          result[rkey] = relative[rkey];
      }

      //urlParse appends trailing / to urls like http://www.example.com
      if (slashedProtocol[result.protocol] &&
        result.hostname && !result.pathname) {
        result.path = result.pathname = '/';
      }

      result.href = result.format();
      return result;
    }
    var relPath;
    if (relative.protocol && relative.protocol !== result.protocol) {
      // if it's a known url protocol, then changing
      // the protocol does weird things
      // first, if it's not file:, then we MUST have a host,
      // and if there was a path
      // to begin with, then we MUST have a path.
      // if it is file:, then the host is dropped,
      // because that's known to be hostless.
      // anything else is assumed to be absolute.
      if (!slashedProtocol[relative.protocol]) {
        var keys = Object.keys(relative);
        for (var v = 0; v < keys.length; v++) {
          var k = keys[v];
          result[k] = relative[k];
        }
        result.href = result.format();
        return result;
      }

      result.protocol = relative.protocol;
      if (!relative.host && !hostlessProtocol[relative.protocol]) {
        relPath = (relative.pathname || '').split('/');
        while (relPath.length && !(relative.host = relPath.shift()));
        if (!relative.host) relative.host = '';
        if (!relative.hostname) relative.hostname = '';
        if (relPath[0] !== '') relPath.unshift('');
        if (relPath.length < 2) relPath.unshift('');
        result.pathname = relPath.join('/');
      } else {
        result.pathname = relative.pathname;
      }
      result.search = relative.search;
      result.query = relative.query;
      result.host = relative.host || '';
      result.auth = relative.auth;
      result.hostname = relative.hostname || relative.host;
      result.port = relative.port;
      // to support http.request
      if (result.pathname || result.search) {
        var p = result.pathname || '';
        var s = result.search || '';
        result.path = p + s;
      }
      result.slashes = result.slashes || relative.slashes;
      result.href = result.format();
      return result;
    }

    var isSourceAbs = (result.pathname && result.pathname.charAt(0) === '/'),
      isRelAbs = (
        relative.host ||
        relative.pathname && relative.pathname.charAt(0) === '/'
      ),
      mustEndAbs = (isRelAbs || isSourceAbs ||
        (result.host && relative.pathname)),
      removeAllDots = mustEndAbs,
      srcPath = result.pathname && result.pathname.split('/') || [],
      psychotic = result.protocol && !slashedProtocol[result.protocol];
    relPath = relative.pathname && relative.pathname.split('/') || [];
    // if the url is a non-slashed url, then relative
    // links like ../.. should be able
    // to crawl up to the hostname, as well.  This is strange.
    // result.protocol has already been set by now.
    // Later on, put the first path part into the host field.
    if (psychotic) {
      result.hostname = '';
      result.port = null;
      if (result.host) {
        if (srcPath[0] === '') srcPath[0] = result.host;
        else srcPath.unshift(result.host);
      }
      result.host = '';
      if (relative.protocol) {
        relative.hostname = null;
        relative.port = null;
        if (relative.host) {
          if (relPath[0] === '') relPath[0] = relative.host;
          else relPath.unshift(relative.host);
        }
        relative.host = null;
      }
      mustEndAbs = mustEndAbs && (relPath[0] === '' || srcPath[0] === '');
    }
    var authInHost;
    if (isRelAbs) {
      // it's absolute.
      result.host = (relative.host || relative.host === '') ?
        relative.host : result.host;
      result.hostname = (relative.hostname || relative.hostname === '') ?
        relative.hostname : result.hostname;
      result.search = relative.search;
      result.query = relative.query;
      srcPath = relPath;
      // fall through to the dot-handling below.
    } else if (relPath.length) {
      // it's relative
      // throw away the existing file, and take the new path instead.
      if (!srcPath) srcPath = [];
      srcPath.pop();
      srcPath = srcPath.concat(relPath);
      result.search = relative.search;
      result.query = relative.query;
    } else if (!isNullOrUndefined(relative.search)) {
      // just pull out the search.
      // like href='?foo'.
      // Put this after the other two cases because it simplifies the booleans
      if (psychotic) {
        result.hostname = result.host = srcPath.shift();
        //occationaly the auth can get stuck only in host
        //this especially happens in cases like
        //url.resolveObject('mailto:local1@domain1', 'local2@domain2')
        authInHost = result.host && result.host.indexOf('@') > 0 ?
          result.host.split('@') : false;
        if (authInHost) {
          result.auth = authInHost.shift();
          result.host = result.hostname = authInHost.shift();
        }
      }
      result.search = relative.search;
      result.query = relative.query;
      //to support http.request
      if (!isNull(result.pathname) || !isNull(result.search)) {
        result.path = (result.pathname ? result.pathname : '') +
          (result.search ? result.search : '');
      }
      result.href = result.format();
      return result;
    }

    if (!srcPath.length) {
      // no path at all.  easy.
      // we've already handled the other stuff above.
      result.pathname = null;
      //to support http.request
      if (result.search) {
        result.path = '/' + result.search;
      } else {
        result.path = null;
      }
      result.href = result.format();
      return result;
    }

    // if a url ENDs in . or .., then it must get a trailing slash.
    // however, if it ends in anything else non-slashy,
    // then it must NOT get a trailing slash.
    var last = srcPath.slice(-1)[0];
    var hasTrailingSlash = (
      (result.host || relative.host || srcPath.length > 1) &&
      (last === '.' || last === '..') || last === '');

    // strip single dots, resolve double dots to parent dir
    // if the path tries to go above the root, `up` ends up > 0
    var up = 0;
    for (var i = srcPath.length; i >= 0; i--) {
      last = srcPath[i];
      if (last === '.') {
        srcPath.splice(i, 1);
      } else if (last === '..') {
        srcPath.splice(i, 1);
        up++;
      } else if (up) {
        srcPath.splice(i, 1);
        up--;
      }
    }

    // if the path is allowed to go above the root, restore leading ..s
    if (!mustEndAbs && !removeAllDots) {
      for (; up--; up) {
        srcPath.unshift('..');
      }
    }

    if (mustEndAbs && srcPath[0] !== '' &&
      (!srcPath[0] || srcPath[0].charAt(0) !== '/')) {
      srcPath.unshift('');
    }

    if (hasTrailingSlash && (srcPath.join('/').substr(-1) !== '/')) {
      srcPath.push('');
    }

    var isAbsolute = srcPath[0] === '' ||
      (srcPath[0] && srcPath[0].charAt(0) === '/');

    // put the host back
    if (psychotic) {
      result.hostname = result.host = isAbsolute ? '' :
        srcPath.length ? srcPath.shift() : '';
      //occationaly the auth can get stuck only in host
      //this especially happens in cases like
      //url.resolveObject('mailto:local1@domain1', 'local2@domain2')
      authInHost = result.host && result.host.indexOf('@') > 0 ?
        result.host.split('@') : false;
      if (authInHost) {
        result.auth = authInHost.shift();
        result.host = result.hostname = authInHost.shift();
      }
    }

    mustEndAbs = mustEndAbs || (result.host && srcPath.length);

    if (mustEndAbs && !isAbsolute) {
      srcPath.unshift('');
    }

    if (!srcPath.length) {
      result.pathname = null;
      result.path = null;
    } else {
      result.pathname = srcPath.join('/');
    }

    //to support request.http
    if (!isNull(result.pathname) || !isNull(result.search)) {
      result.path = (result.pathname ? result.pathname : '') +
        (result.search ? result.search : '');
    }
    result.auth = relative.auth || result.auth;
    result.slashes = result.slashes || relative.slashes;
    result.href = result.format();
    return result;
  };

  Url.prototype.parseHost = function() {
    return parseHost(this);
  };

  function parseHost(self) {
    var host = self.host;
    var port = portPattern.exec(host);
    if (port) {
      port = port[0];
      if (port !== ':') {
        self.port = port.substr(1);
      }
      host = host.substr(0, host.length - port.length);
    }
    if (host) self.hostname = host;
  }

  var url$2 = /*#__PURE__*/Object.freeze({
    __proto__: null,
    parse: urlParse,
    resolve: urlResolve,
    resolveObject: urlResolveObject,
    format: urlFormat,
    'default': url$1,
    Url: Url
  });

  var require$$0 = /*@__PURE__*/getAugmentedNamespace(url$2);

  var url = Object.assign(
    {},
    require$$0,
    {
      pathToFileURL: (path)=> { return `file:///${encodeURIComponent(path)}` },
      fileURLToPath: (fileURL)=> { return decodeURIComponent(fileURL.toString().replace(/^file:\/\/\//, '')) }
    }
  );

  /* -*- Mode: js; js-indent-level: 2; -*- */
  /*
   * Copyright 2011 Mozilla Foundation and contributors
   * Licensed under the New BSD license. See LICENSE or:
   * http://opensource.org/licenses/BSD-3-Clause
   */

  var intToCharMap = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'.split('');

  /**
   * Encode an integer in the range of 0 to 63 to a single base 64 digit.
   */
  var encode$1 = function (number) {
    if (0 <= number && number < intToCharMap.length) {
      return intToCharMap[number];
    }
    throw new TypeError("Must be between 0 and 63: " + number);
  };

  /**
   * Decode a single base 64 character code digit to an integer. Returns -1 on
   * failure.
   */
  var decode$1 = function (charCode) {
    var bigA = 65;     // 'A'
    var bigZ = 90;     // 'Z'

    var littleA = 97;  // 'a'
    var littleZ = 122; // 'z'

    var zero = 48;     // '0'
    var nine = 57;     // '9'

    var plus = 43;     // '+'
    var slash = 47;    // '/'

    var littleOffset = 26;
    var numberOffset = 52;

    // 0 - 25: ABCDEFGHIJKLMNOPQRSTUVWXYZ
    if (bigA <= charCode && charCode <= bigZ) {
      return (charCode - bigA);
    }

    // 26 - 51: abcdefghijklmnopqrstuvwxyz
    if (littleA <= charCode && charCode <= littleZ) {
      return (charCode - littleA + littleOffset);
    }

    // 52 - 61: 0123456789
    if (zero <= charCode && charCode <= nine) {
      return (charCode - zero + numberOffset);
    }

    // 62: +
    if (charCode == plus) {
      return 62;
    }

    // 63: /
    if (charCode == slash) {
      return 63;
    }

    // Invalid base64 digit.
    return -1;
  };

  var base64 = {
  	encode: encode$1,
  	decode: decode$1
  };

  /* -*- Mode: js; js-indent-level: 2; -*- */

  /*
   * Copyright 2011 Mozilla Foundation and contributors
   * Licensed under the New BSD license. See LICENSE or:
   * http://opensource.org/licenses/BSD-3-Clause
   *
   * Based on the Base 64 VLQ implementation in Closure Compiler:
   * https://code.google.com/p/closure-compiler/source/browse/trunk/src/com/google/debugging/sourcemap/Base64VLQ.java
   *
   * Copyright 2011 The Closure Compiler Authors. All rights reserved.
   * Redistribution and use in source and binary forms, with or without
   * modification, are permitted provided that the following conditions are
   * met:
   *
   *  * Redistributions of source code must retain the above copyright
   *    notice, this list of conditions and the following disclaimer.
   *  * Redistributions in binary form must reproduce the above
   *    copyright notice, this list of conditions and the following
   *    disclaimer in the documentation and/or other materials provided
   *    with the distribution.
   *  * Neither the name of Google Inc. nor the names of its
   *    contributors may be used to endorse or promote products derived
   *    from this software without specific prior written permission.
   *
   * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
   * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
   * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
   * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
   * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
   * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
   * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
   * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
   */



  // A single base 64 digit can contain 6 bits of data. For the base 64 variable
  // length quantities we use in the source map spec, the first bit is the sign,
  // the next four bits are the actual value, and the 6th bit is the
  // continuation bit. The continuation bit tells us whether there are more
  // digits in this value following this digit.
  //
  //   Continuation
  //   |    Sign
  //   |    |
  //   V    V
  //   101011

  var VLQ_BASE_SHIFT = 5;

  // binary: 100000
  var VLQ_BASE = 1 << VLQ_BASE_SHIFT;

  // binary: 011111
  var VLQ_BASE_MASK = VLQ_BASE - 1;

  // binary: 100000
  var VLQ_CONTINUATION_BIT = VLQ_BASE;

  /**
   * Converts from a two-complement value to a value where the sign bit is
   * placed in the least significant bit.  For example, as decimals:
   *   1 becomes 2 (10 binary), -1 becomes 3 (11 binary)
   *   2 becomes 4 (100 binary), -2 becomes 5 (101 binary)
   */
  function toVLQSigned(aValue) {
    return aValue < 0
      ? ((-aValue) << 1) + 1
      : (aValue << 1) + 0;
  }

  /**
   * Converts to a two-complement value from a value where the sign bit is
   * placed in the least significant bit.  For example, as decimals:
   *   2 (10 binary) becomes 1, 3 (11 binary) becomes -1
   *   4 (100 binary) becomes 2, 5 (101 binary) becomes -2
   */
  function fromVLQSigned(aValue) {
    var isNegative = (aValue & 1) === 1;
    var shifted = aValue >> 1;
    return isNegative
      ? -shifted
      : shifted;
  }

  /**
   * Returns the base 64 VLQ encoded value.
   */
  var encode = function base64VLQ_encode(aValue) {
    var encoded = "";
    var digit;

    var vlq = toVLQSigned(aValue);

    do {
      digit = vlq & VLQ_BASE_MASK;
      vlq >>>= VLQ_BASE_SHIFT;
      if (vlq > 0) {
        // There are still more digits in this value, so we must make sure the
        // continuation bit is marked.
        digit |= VLQ_CONTINUATION_BIT;
      }
      encoded += base64.encode(digit);
    } while (vlq > 0);

    return encoded;
  };

  /**
   * Decodes the next base 64 VLQ value from the given string and returns the
   * value and the rest of the string via the out parameter.
   */
  var decode = function base64VLQ_decode(aStr, aIndex, aOutParam) {
    var strLen = aStr.length;
    var result = 0;
    var shift = 0;
    var continuation, digit;

    do {
      if (aIndex >= strLen) {
        throw new Error("Expected more digits in base 64 VLQ value.");
      }

      digit = base64.decode(aStr.charCodeAt(aIndex++));
      if (digit === -1) {
        throw new Error("Invalid base64 digit: " + aStr.charAt(aIndex - 1));
      }

      continuation = !!(digit & VLQ_CONTINUATION_BIT);
      digit &= VLQ_BASE_MASK;
      result = result + (digit << shift);
      shift += VLQ_BASE_SHIFT;
    } while (continuation);

    aOutParam.value = fromVLQSigned(result);
    aOutParam.rest = aIndex;
  };

  var base64Vlq = {
  	encode: encode,
  	decode: decode
  };

  /* -*- Mode: js; js-indent-level: 2; -*- */

  var util = createCommonjsModule(function (module, exports) {
  /*
   * Copyright 2011 Mozilla Foundation and contributors
   * Licensed under the New BSD license. See LICENSE or:
   * http://opensource.org/licenses/BSD-3-Clause
   */

  /**
   * This is a helper function for getting values from parameter/options
   * objects.
   *
   * @param args The object we are extracting values from
   * @param name The name of the property we are getting.
   * @param defaultValue An optional value to return if the property is missing
   * from the object. If this is not specified and the property is missing, an
   * error will be thrown.
   */
  function getArg(aArgs, aName, aDefaultValue) {
    if (aName in aArgs) {
      return aArgs[aName];
    } else if (arguments.length === 3) {
      return aDefaultValue;
    } else {
      throw new Error('"' + aName + '" is a required argument.');
    }
  }
  exports.getArg = getArg;

  var urlRegexp = /^(?:([\w+\-.]+):)?\/\/(?:(\w+:\w+)@)?([\w.-]*)(?::(\d+))?(.*)$/;
  var dataUrlRegexp = /^data:.+\,.+$/;

  function urlParse(aUrl) {
    var match = aUrl.match(urlRegexp);
    if (!match) {
      return null;
    }
    return {
      scheme: match[1],
      auth: match[2],
      host: match[3],
      port: match[4],
      path: match[5]
    };
  }
  exports.urlParse = urlParse;

  function urlGenerate(aParsedUrl) {
    var url = '';
    if (aParsedUrl.scheme) {
      url += aParsedUrl.scheme + ':';
    }
    url += '//';
    if (aParsedUrl.auth) {
      url += aParsedUrl.auth + '@';
    }
    if (aParsedUrl.host) {
      url += aParsedUrl.host;
    }
    if (aParsedUrl.port) {
      url += ":" + aParsedUrl.port;
    }
    if (aParsedUrl.path) {
      url += aParsedUrl.path;
    }
    return url;
  }
  exports.urlGenerate = urlGenerate;

  /**
   * Normalizes a path, or the path portion of a URL:
   *
   * - Replaces consecutive slashes with one slash.
   * - Removes unnecessary '.' parts.
   * - Removes unnecessary '<dir>/..' parts.
   *
   * Based on code in the Node.js 'path' core module.
   *
   * @param aPath The path or url to normalize.
   */
  function normalize(aPath) {
    var path = aPath;
    var url = urlParse(aPath);
    if (url) {
      if (!url.path) {
        return aPath;
      }
      path = url.path;
    }
    var isAbsolute = exports.isAbsolute(path);

    var parts = path.split(/\/+/);
    for (var part, up = 0, i = parts.length - 1; i >= 0; i--) {
      part = parts[i];
      if (part === '.') {
        parts.splice(i, 1);
      } else if (part === '..') {
        up++;
      } else if (up > 0) {
        if (part === '') {
          // The first part is blank if the path is absolute. Trying to go
          // above the root is a no-op. Therefore we can remove all '..' parts
          // directly after the root.
          parts.splice(i + 1, up);
          up = 0;
        } else {
          parts.splice(i, 2);
          up--;
        }
      }
    }
    path = parts.join('/');

    if (path === '') {
      path = isAbsolute ? '/' : '.';
    }

    if (url) {
      url.path = path;
      return urlGenerate(url);
    }
    return path;
  }
  exports.normalize = normalize;

  /**
   * Joins two paths/URLs.
   *
   * @param aRoot The root path or URL.
   * @param aPath The path or URL to be joined with the root.
   *
   * - If aPath is a URL or a data URI, aPath is returned, unless aPath is a
   *   scheme-relative URL: Then the scheme of aRoot, if any, is prepended
   *   first.
   * - Otherwise aPath is a path. If aRoot is a URL, then its path portion
   *   is updated with the result and aRoot is returned. Otherwise the result
   *   is returned.
   *   - If aPath is absolute, the result is aPath.
   *   - Otherwise the two paths are joined with a slash.
   * - Joining for example 'http://' and 'www.example.com' is also supported.
   */
  function join(aRoot, aPath) {
    if (aRoot === "") {
      aRoot = ".";
    }
    if (aPath === "") {
      aPath = ".";
    }
    var aPathUrl = urlParse(aPath);
    var aRootUrl = urlParse(aRoot);
    if (aRootUrl) {
      aRoot = aRootUrl.path || '/';
    }

    // `join(foo, '//www.example.org')`
    if (aPathUrl && !aPathUrl.scheme) {
      if (aRootUrl) {
        aPathUrl.scheme = aRootUrl.scheme;
      }
      return urlGenerate(aPathUrl);
    }

    if (aPathUrl || aPath.match(dataUrlRegexp)) {
      return aPath;
    }

    // `join('http://', 'www.example.com')`
    if (aRootUrl && !aRootUrl.host && !aRootUrl.path) {
      aRootUrl.host = aPath;
      return urlGenerate(aRootUrl);
    }

    var joined = aPath.charAt(0) === '/'
      ? aPath
      : normalize(aRoot.replace(/\/+$/, '') + '/' + aPath);

    if (aRootUrl) {
      aRootUrl.path = joined;
      return urlGenerate(aRootUrl);
    }
    return joined;
  }
  exports.join = join;

  exports.isAbsolute = function (aPath) {
    return aPath.charAt(0) === '/' || urlRegexp.test(aPath);
  };

  /**
   * Make a path relative to a URL or another path.
   *
   * @param aRoot The root path or URL.
   * @param aPath The path or URL to be made relative to aRoot.
   */
  function relative(aRoot, aPath) {
    if (aRoot === "") {
      aRoot = ".";
    }

    aRoot = aRoot.replace(/\/$/, '');

    // It is possible for the path to be above the root. In this case, simply
    // checking whether the root is a prefix of the path won't work. Instead, we
    // need to remove components from the root one by one, until either we find
    // a prefix that fits, or we run out of components to remove.
    var level = 0;
    while (aPath.indexOf(aRoot + '/') !== 0) {
      var index = aRoot.lastIndexOf("/");
      if (index < 0) {
        return aPath;
      }

      // If the only part of the root that is left is the scheme (i.e. http://,
      // file:///, etc.), one or more slashes (/), or simply nothing at all, we
      // have exhausted all components, so the path is not relative to the root.
      aRoot = aRoot.slice(0, index);
      if (aRoot.match(/^([^\/]+:\/)?\/*$/)) {
        return aPath;
      }

      ++level;
    }

    // Make sure we add a "../" for each component we removed from the root.
    return Array(level + 1).join("../") + aPath.substr(aRoot.length + 1);
  }
  exports.relative = relative;

  var supportsNullProto = (function () {
    var obj = Object.create(null);
    return !('__proto__' in obj);
  }());

  function identity (s) {
    return s;
  }

  /**
   * Because behavior goes wacky when you set `__proto__` on objects, we
   * have to prefix all the strings in our set with an arbitrary character.
   *
   * See https://github.com/mozilla/source-map/pull/31 and
   * https://github.com/mozilla/source-map/issues/30
   *
   * @param String aStr
   */
  function toSetString(aStr) {
    if (isProtoString(aStr)) {
      return '$' + aStr;
    }

    return aStr;
  }
  exports.toSetString = supportsNullProto ? identity : toSetString;

  function fromSetString(aStr) {
    if (isProtoString(aStr)) {
      return aStr.slice(1);
    }

    return aStr;
  }
  exports.fromSetString = supportsNullProto ? identity : fromSetString;

  function isProtoString(s) {
    if (!s) {
      return false;
    }

    var length = s.length;

    if (length < 9 /* "__proto__".length */) {
      return false;
    }

    if (s.charCodeAt(length - 1) !== 95  /* '_' */ ||
        s.charCodeAt(length - 2) !== 95  /* '_' */ ||
        s.charCodeAt(length - 3) !== 111 /* 'o' */ ||
        s.charCodeAt(length - 4) !== 116 /* 't' */ ||
        s.charCodeAt(length - 5) !== 111 /* 'o' */ ||
        s.charCodeAt(length - 6) !== 114 /* 'r' */ ||
        s.charCodeAt(length - 7) !== 112 /* 'p' */ ||
        s.charCodeAt(length - 8) !== 95  /* '_' */ ||
        s.charCodeAt(length - 9) !== 95  /* '_' */) {
      return false;
    }

    for (var i = length - 10; i >= 0; i--) {
      if (s.charCodeAt(i) !== 36 /* '$' */) {
        return false;
      }
    }

    return true;
  }

  /**
   * Comparator between two mappings where the original positions are compared.
   *
   * Optionally pass in `true` as `onlyCompareGenerated` to consider two
   * mappings with the same original source/line/column, but different generated
   * line and column the same. Useful when searching for a mapping with a
   * stubbed out mapping.
   */
  function compareByOriginalPositions(mappingA, mappingB, onlyCompareOriginal) {
    var cmp = strcmp(mappingA.source, mappingB.source);
    if (cmp !== 0) {
      return cmp;
    }

    cmp = mappingA.originalLine - mappingB.originalLine;
    if (cmp !== 0) {
      return cmp;
    }

    cmp = mappingA.originalColumn - mappingB.originalColumn;
    if (cmp !== 0 || onlyCompareOriginal) {
      return cmp;
    }

    cmp = mappingA.generatedColumn - mappingB.generatedColumn;
    if (cmp !== 0) {
      return cmp;
    }

    cmp = mappingA.generatedLine - mappingB.generatedLine;
    if (cmp !== 0) {
      return cmp;
    }

    return strcmp(mappingA.name, mappingB.name);
  }
  exports.compareByOriginalPositions = compareByOriginalPositions;

  /**
   * Comparator between two mappings with deflated source and name indices where
   * the generated positions are compared.
   *
   * Optionally pass in `true` as `onlyCompareGenerated` to consider two
   * mappings with the same generated line and column, but different
   * source/name/original line and column the same. Useful when searching for a
   * mapping with a stubbed out mapping.
   */
  function compareByGeneratedPositionsDeflated(mappingA, mappingB, onlyCompareGenerated) {
    var cmp = mappingA.generatedLine - mappingB.generatedLine;
    if (cmp !== 0) {
      return cmp;
    }

    cmp = mappingA.generatedColumn - mappingB.generatedColumn;
    if (cmp !== 0 || onlyCompareGenerated) {
      return cmp;
    }

    cmp = strcmp(mappingA.source, mappingB.source);
    if (cmp !== 0) {
      return cmp;
    }

    cmp = mappingA.originalLine - mappingB.originalLine;
    if (cmp !== 0) {
      return cmp;
    }

    cmp = mappingA.originalColumn - mappingB.originalColumn;
    if (cmp !== 0) {
      return cmp;
    }

    return strcmp(mappingA.name, mappingB.name);
  }
  exports.compareByGeneratedPositionsDeflated = compareByGeneratedPositionsDeflated;

  function strcmp(aStr1, aStr2) {
    if (aStr1 === aStr2) {
      return 0;
    }

    if (aStr1 === null) {
      return 1; // aStr2 !== null
    }

    if (aStr2 === null) {
      return -1; // aStr1 !== null
    }

    if (aStr1 > aStr2) {
      return 1;
    }

    return -1;
  }

  /**
   * Comparator between two mappings with inflated source and name strings where
   * the generated positions are compared.
   */
  function compareByGeneratedPositionsInflated(mappingA, mappingB) {
    var cmp = mappingA.generatedLine - mappingB.generatedLine;
    if (cmp !== 0) {
      return cmp;
    }

    cmp = mappingA.generatedColumn - mappingB.generatedColumn;
    if (cmp !== 0) {
      return cmp;
    }

    cmp = strcmp(mappingA.source, mappingB.source);
    if (cmp !== 0) {
      return cmp;
    }

    cmp = mappingA.originalLine - mappingB.originalLine;
    if (cmp !== 0) {
      return cmp;
    }

    cmp = mappingA.originalColumn - mappingB.originalColumn;
    if (cmp !== 0) {
      return cmp;
    }

    return strcmp(mappingA.name, mappingB.name);
  }
  exports.compareByGeneratedPositionsInflated = compareByGeneratedPositionsInflated;

  /**
   * Strip any JSON XSSI avoidance prefix from the string (as documented
   * in the source maps specification), and then parse the string as
   * JSON.
   */
  function parseSourceMapInput(str) {
    return JSON.parse(str.replace(/^\)]}'[^\n]*\n/, ''));
  }
  exports.parseSourceMapInput = parseSourceMapInput;

  /**
   * Compute the URL of a source given the the source root, the source's
   * URL, and the source map's URL.
   */
  function computeSourceURL(sourceRoot, sourceURL, sourceMapURL) {
    sourceURL = sourceURL || '';

    if (sourceRoot) {
      // This follows what Chrome does.
      if (sourceRoot[sourceRoot.length - 1] !== '/' && sourceURL[0] !== '/') {
        sourceRoot += '/';
      }
      // The spec says:
      //   Line 4: An optional source root, useful for relocating source
      //   files on a server or removing repeated values in the
      //   “sources” entry.  This value is prepended to the individual
      //   entries in the “source” field.
      sourceURL = sourceRoot + sourceURL;
    }

    // Historically, SourceMapConsumer did not take the sourceMapURL as
    // a parameter.  This mode is still somewhat supported, which is why
    // this code block is conditional.  However, it's preferable to pass
    // the source map URL to SourceMapConsumer, so that this function
    // can implement the source URL resolution algorithm as outlined in
    // the spec.  This block is basically the equivalent of:
    //    new URL(sourceURL, sourceMapURL).toString()
    // ... except it avoids using URL, which wasn't available in the
    // older releases of node still supported by this library.
    //
    // The spec says:
    //   If the sources are not absolute URLs after prepending of the
    //   “sourceRoot”, the sources are resolved relative to the
    //   SourceMap (like resolving script src in a html document).
    if (sourceMapURL) {
      var parsed = urlParse(sourceMapURL);
      if (!parsed) {
        throw new Error("sourceMapURL could not be parsed");
      }
      if (parsed.path) {
        // Strip the last path component, but keep the "/".
        var index = parsed.path.lastIndexOf('/');
        if (index >= 0) {
          parsed.path = parsed.path.substring(0, index + 1);
        }
      }
      sourceURL = join(urlGenerate(parsed), sourceURL);
    }

    return normalize(sourceURL);
  }
  exports.computeSourceURL = computeSourceURL;
  });

  /* -*- Mode: js; js-indent-level: 2; -*- */

  /*
   * Copyright 2011 Mozilla Foundation and contributors
   * Licensed under the New BSD license. See LICENSE or:
   * http://opensource.org/licenses/BSD-3-Clause
   */


  var has = Object.prototype.hasOwnProperty;
  var hasNativeMap = typeof Map !== "undefined";

  /**
   * A data structure which is a combination of an array and a set. Adding a new
   * member is O(1), testing for membership is O(1), and finding the index of an
   * element is O(1). Removing elements from the set is not supported. Only
   * strings are supported for membership.
   */
  function ArraySet$2() {
    this._array = [];
    this._set = hasNativeMap ? new Map() : Object.create(null);
  }

  /**
   * Static method for creating ArraySet instances from an existing array.
   */
  ArraySet$2.fromArray = function ArraySet_fromArray(aArray, aAllowDuplicates) {
    var set = new ArraySet$2();
    for (var i = 0, len = aArray.length; i < len; i++) {
      set.add(aArray[i], aAllowDuplicates);
    }
    return set;
  };

  /**
   * Return how many unique items are in this ArraySet. If duplicates have been
   * added, than those do not count towards the size.
   *
   * @returns Number
   */
  ArraySet$2.prototype.size = function ArraySet_size() {
    return hasNativeMap ? this._set.size : Object.getOwnPropertyNames(this._set).length;
  };

  /**
   * Add the given string to this set.
   *
   * @param String aStr
   */
  ArraySet$2.prototype.add = function ArraySet_add(aStr, aAllowDuplicates) {
    var sStr = hasNativeMap ? aStr : util.toSetString(aStr);
    var isDuplicate = hasNativeMap ? this.has(aStr) : has.call(this._set, sStr);
    var idx = this._array.length;
    if (!isDuplicate || aAllowDuplicates) {
      this._array.push(aStr);
    }
    if (!isDuplicate) {
      if (hasNativeMap) {
        this._set.set(aStr, idx);
      } else {
        this._set[sStr] = idx;
      }
    }
  };

  /**
   * Is the given string a member of this set?
   *
   * @param String aStr
   */
  ArraySet$2.prototype.has = function ArraySet_has(aStr) {
    if (hasNativeMap) {
      return this._set.has(aStr);
    } else {
      var sStr = util.toSetString(aStr);
      return has.call(this._set, sStr);
    }
  };

  /**
   * What is the index of the given string in the array?
   *
   * @param String aStr
   */
  ArraySet$2.prototype.indexOf = function ArraySet_indexOf(aStr) {
    if (hasNativeMap) {
      var idx = this._set.get(aStr);
      if (idx >= 0) {
          return idx;
      }
    } else {
      var sStr = util.toSetString(aStr);
      if (has.call(this._set, sStr)) {
        return this._set[sStr];
      }
    }

    throw new Error('"' + aStr + '" is not in the set.');
  };

  /**
   * What is the element at the given index?
   *
   * @param Number aIdx
   */
  ArraySet$2.prototype.at = function ArraySet_at(aIdx) {
    if (aIdx >= 0 && aIdx < this._array.length) {
      return this._array[aIdx];
    }
    throw new Error('No element indexed by ' + aIdx);
  };

  /**
   * Returns the array representation of this set (which has the proper indices
   * indicated by indexOf). Note that this is a copy of the internal array used
   * for storing the members so that no one can mess with internal state.
   */
  ArraySet$2.prototype.toArray = function ArraySet_toArray() {
    return this._array.slice();
  };

  var ArraySet_1 = ArraySet$2;

  var arraySet = {
  	ArraySet: ArraySet_1
  };

  /* -*- Mode: js; js-indent-level: 2; -*- */

  /*
   * Copyright 2014 Mozilla Foundation and contributors
   * Licensed under the New BSD license. See LICENSE or:
   * http://opensource.org/licenses/BSD-3-Clause
   */



  /**
   * Determine whether mappingB is after mappingA with respect to generated
   * position.
   */
  function generatedPositionAfter(mappingA, mappingB) {
    // Optimized for most common case
    var lineA = mappingA.generatedLine;
    var lineB = mappingB.generatedLine;
    var columnA = mappingA.generatedColumn;
    var columnB = mappingB.generatedColumn;
    return lineB > lineA || lineB == lineA && columnB >= columnA ||
           util.compareByGeneratedPositionsInflated(mappingA, mappingB) <= 0;
  }

  /**
   * A data structure to provide a sorted view of accumulated mappings in a
   * performance conscious manner. It trades a neglibable overhead in general
   * case for a large speedup in case of mappings being added in order.
   */
  function MappingList$1() {
    this._array = [];
    this._sorted = true;
    // Serves as infimum
    this._last = {generatedLine: -1, generatedColumn: 0};
  }

  /**
   * Iterate through internal items. This method takes the same arguments that
   * `Array.prototype.forEach` takes.
   *
   * NOTE: The order of the mappings is NOT guaranteed.
   */
  MappingList$1.prototype.unsortedForEach =
    function MappingList_forEach(aCallback, aThisArg) {
      this._array.forEach(aCallback, aThisArg);
    };

  /**
   * Add the given source mapping.
   *
   * @param Object aMapping
   */
  MappingList$1.prototype.add = function MappingList_add(aMapping) {
    if (generatedPositionAfter(this._last, aMapping)) {
      this._last = aMapping;
      this._array.push(aMapping);
    } else {
      this._sorted = false;
      this._array.push(aMapping);
    }
  };

  /**
   * Returns the flat, sorted array of mappings. The mappings are sorted by
   * generated position.
   *
   * WARNING: This method returns internal data without copying, for
   * performance. The return value must NOT be mutated, and should be treated as
   * an immutable borrow. If you want to take ownership, you must make your own
   * copy.
   */
  MappingList$1.prototype.toArray = function MappingList_toArray() {
    if (!this._sorted) {
      this._array.sort(util.compareByGeneratedPositionsInflated);
      this._sorted = true;
    }
    return this._array;
  };

  var MappingList_1 = MappingList$1;

  var mappingList = {
  	MappingList: MappingList_1
  };

  /* -*- Mode: js; js-indent-level: 2; -*- */

  /*
   * Copyright 2011 Mozilla Foundation and contributors
   * Licensed under the New BSD license. See LICENSE or:
   * http://opensource.org/licenses/BSD-3-Clause
   */



  var ArraySet$1 = arraySet.ArraySet;
  var MappingList = mappingList.MappingList;

  /**
   * An instance of the SourceMapGenerator represents a source map which is
   * being built incrementally. You may pass an object with the following
   * properties:
   *
   *   - file: The filename of the generated source.
   *   - sourceRoot: A root for all relative URLs in this source map.
   */
  function SourceMapGenerator$2(aArgs) {
    if (!aArgs) {
      aArgs = {};
    }
    this._file = util.getArg(aArgs, 'file', null);
    this._sourceRoot = util.getArg(aArgs, 'sourceRoot', null);
    this._skipValidation = util.getArg(aArgs, 'skipValidation', false);
    this._sources = new ArraySet$1();
    this._names = new ArraySet$1();
    this._mappings = new MappingList();
    this._sourcesContents = null;
  }

  SourceMapGenerator$2.prototype._version = 3;

  /**
   * Creates a new SourceMapGenerator based on a SourceMapConsumer
   *
   * @param aSourceMapConsumer The SourceMap.
   */
  SourceMapGenerator$2.fromSourceMap =
    function SourceMapGenerator_fromSourceMap(aSourceMapConsumer) {
      var sourceRoot = aSourceMapConsumer.sourceRoot;
      var generator = new SourceMapGenerator$2({
        file: aSourceMapConsumer.file,
        sourceRoot: sourceRoot
      });
      aSourceMapConsumer.eachMapping(function (mapping) {
        var newMapping = {
          generated: {
            line: mapping.generatedLine,
            column: mapping.generatedColumn
          }
        };

        if (mapping.source != null) {
          newMapping.source = mapping.source;
          if (sourceRoot != null) {
            newMapping.source = util.relative(sourceRoot, newMapping.source);
          }

          newMapping.original = {
            line: mapping.originalLine,
            column: mapping.originalColumn
          };

          if (mapping.name != null) {
            newMapping.name = mapping.name;
          }
        }

        generator.addMapping(newMapping);
      });
      aSourceMapConsumer.sources.forEach(function (sourceFile) {
        var sourceRelative = sourceFile;
        if (sourceRoot !== null) {
          sourceRelative = util.relative(sourceRoot, sourceFile);
        }

        if (!generator._sources.has(sourceRelative)) {
          generator._sources.add(sourceRelative);
        }

        var content = aSourceMapConsumer.sourceContentFor(sourceFile);
        if (content != null) {
          generator.setSourceContent(sourceFile, content);
        }
      });
      return generator;
    };

  /**
   * Add a single mapping from original source line and column to the generated
   * source's line and column for this source map being created. The mapping
   * object should have the following properties:
   *
   *   - generated: An object with the generated line and column positions.
   *   - original: An object with the original line and column positions.
   *   - source: The original source file (relative to the sourceRoot).
   *   - name: An optional original token name for this mapping.
   */
  SourceMapGenerator$2.prototype.addMapping =
    function SourceMapGenerator_addMapping(aArgs) {
      var generated = util.getArg(aArgs, 'generated');
      var original = util.getArg(aArgs, 'original', null);
      var source = util.getArg(aArgs, 'source', null);
      var name = util.getArg(aArgs, 'name', null);

      if (!this._skipValidation) {
        this._validateMapping(generated, original, source, name);
      }

      if (source != null) {
        source = String(source);
        if (!this._sources.has(source)) {
          this._sources.add(source);
        }
      }

      if (name != null) {
        name = String(name);
        if (!this._names.has(name)) {
          this._names.add(name);
        }
      }

      this._mappings.add({
        generatedLine: generated.line,
        generatedColumn: generated.column,
        originalLine: original != null && original.line,
        originalColumn: original != null && original.column,
        source: source,
        name: name
      });
    };

  /**
   * Set the source content for a source file.
   */
  SourceMapGenerator$2.prototype.setSourceContent =
    function SourceMapGenerator_setSourceContent(aSourceFile, aSourceContent) {
      var source = aSourceFile;
      if (this._sourceRoot != null) {
        source = util.relative(this._sourceRoot, source);
      }

      if (aSourceContent != null) {
        // Add the source content to the _sourcesContents map.
        // Create a new _sourcesContents map if the property is null.
        if (!this._sourcesContents) {
          this._sourcesContents = Object.create(null);
        }
        this._sourcesContents[util.toSetString(source)] = aSourceContent;
      } else if (this._sourcesContents) {
        // Remove the source file from the _sourcesContents map.
        // If the _sourcesContents map is empty, set the property to null.
        delete this._sourcesContents[util.toSetString(source)];
        if (Object.keys(this._sourcesContents).length === 0) {
          this._sourcesContents = null;
        }
      }
    };

  /**
   * Applies the mappings of a sub-source-map for a specific source file to the
   * source map being generated. Each mapping to the supplied source file is
   * rewritten using the supplied source map. Note: The resolution for the
   * resulting mappings is the minimium of this map and the supplied map.
   *
   * @param aSourceMapConsumer The source map to be applied.
   * @param aSourceFile Optional. The filename of the source file.
   *        If omitted, SourceMapConsumer's file property will be used.
   * @param aSourceMapPath Optional. The dirname of the path to the source map
   *        to be applied. If relative, it is relative to the SourceMapConsumer.
   *        This parameter is needed when the two source maps aren't in the same
   *        directory, and the source map to be applied contains relative source
   *        paths. If so, those relative source paths need to be rewritten
   *        relative to the SourceMapGenerator.
   */
  SourceMapGenerator$2.prototype.applySourceMap =
    function SourceMapGenerator_applySourceMap(aSourceMapConsumer, aSourceFile, aSourceMapPath) {
      var sourceFile = aSourceFile;
      // If aSourceFile is omitted, we will use the file property of the SourceMap
      if (aSourceFile == null) {
        if (aSourceMapConsumer.file == null) {
          throw new Error(
            'SourceMapGenerator.prototype.applySourceMap requires either an explicit source file, ' +
            'or the source map\'s "file" property. Both were omitted.'
          );
        }
        sourceFile = aSourceMapConsumer.file;
      }
      var sourceRoot = this._sourceRoot;
      // Make "sourceFile" relative if an absolute Url is passed.
      if (sourceRoot != null) {
        sourceFile = util.relative(sourceRoot, sourceFile);
      }
      // Applying the SourceMap can add and remove items from the sources and
      // the names array.
      var newSources = new ArraySet$1();
      var newNames = new ArraySet$1();

      // Find mappings for the "sourceFile"
      this._mappings.unsortedForEach(function (mapping) {
        if (mapping.source === sourceFile && mapping.originalLine != null) {
          // Check if it can be mapped by the source map, then update the mapping.
          var original = aSourceMapConsumer.originalPositionFor({
            line: mapping.originalLine,
            column: mapping.originalColumn
          });
          if (original.source != null) {
            // Copy mapping
            mapping.source = original.source;
            if (aSourceMapPath != null) {
              mapping.source = util.join(aSourceMapPath, mapping.source);
            }
            if (sourceRoot != null) {
              mapping.source = util.relative(sourceRoot, mapping.source);
            }
            mapping.originalLine = original.line;
            mapping.originalColumn = original.column;
            if (original.name != null) {
              mapping.name = original.name;
            }
          }
        }

        var source = mapping.source;
        if (source != null && !newSources.has(source)) {
          newSources.add(source);
        }

        var name = mapping.name;
        if (name != null && !newNames.has(name)) {
          newNames.add(name);
        }

      }, this);
      this._sources = newSources;
      this._names = newNames;

      // Copy sourcesContents of applied map.
      aSourceMapConsumer.sources.forEach(function (sourceFile) {
        var content = aSourceMapConsumer.sourceContentFor(sourceFile);
        if (content != null) {
          if (aSourceMapPath != null) {
            sourceFile = util.join(aSourceMapPath, sourceFile);
          }
          if (sourceRoot != null) {
            sourceFile = util.relative(sourceRoot, sourceFile);
          }
          this.setSourceContent(sourceFile, content);
        }
      }, this);
    };

  /**
   * A mapping can have one of the three levels of data:
   *
   *   1. Just the generated position.
   *   2. The Generated position, original position, and original source.
   *   3. Generated and original position, original source, as well as a name
   *      token.
   *
   * To maintain consistency, we validate that any new mapping being added falls
   * in to one of these categories.
   */
  SourceMapGenerator$2.prototype._validateMapping =
    function SourceMapGenerator_validateMapping(aGenerated, aOriginal, aSource,
                                                aName) {
      // When aOriginal is truthy but has empty values for .line and .column,
      // it is most likely a programmer error. In this case we throw a very
      // specific error message to try to guide them the right way.
      // For example: https://github.com/Polymer/polymer-bundler/pull/519
      if (aOriginal && typeof aOriginal.line !== 'number' && typeof aOriginal.column !== 'number') {
          throw new Error(
              'original.line and original.column are not numbers -- you probably meant to omit ' +
              'the original mapping entirely and only map the generated position. If so, pass ' +
              'null for the original mapping instead of an object with empty or null values.'
          );
      }

      if (aGenerated && 'line' in aGenerated && 'column' in aGenerated
          && aGenerated.line > 0 && aGenerated.column >= 0
          && !aOriginal && !aSource && !aName) {
        // Case 1.
        return;
      }
      else if (aGenerated && 'line' in aGenerated && 'column' in aGenerated
               && aOriginal && 'line' in aOriginal && 'column' in aOriginal
               && aGenerated.line > 0 && aGenerated.column >= 0
               && aOriginal.line > 0 && aOriginal.column >= 0
               && aSource) {
        // Cases 2 and 3.
        return;
      }
      else {
        throw new Error('Invalid mapping: ' + JSON.stringify({
          generated: aGenerated,
          source: aSource,
          original: aOriginal,
          name: aName
        }));
      }
    };

  /**
   * Serialize the accumulated mappings in to the stream of base 64 VLQs
   * specified by the source map format.
   */
  SourceMapGenerator$2.prototype._serializeMappings =
    function SourceMapGenerator_serializeMappings() {
      var previousGeneratedColumn = 0;
      var previousGeneratedLine = 1;
      var previousOriginalColumn = 0;
      var previousOriginalLine = 0;
      var previousName = 0;
      var previousSource = 0;
      var result = '';
      var next;
      var mapping;
      var nameIdx;
      var sourceIdx;

      var mappings = this._mappings.toArray();
      for (var i = 0, len = mappings.length; i < len; i++) {
        mapping = mappings[i];
        next = '';

        if (mapping.generatedLine !== previousGeneratedLine) {
          previousGeneratedColumn = 0;
          while (mapping.generatedLine !== previousGeneratedLine) {
            next += ';';
            previousGeneratedLine++;
          }
        }
        else {
          if (i > 0) {
            if (!util.compareByGeneratedPositionsInflated(mapping, mappings[i - 1])) {
              continue;
            }
            next += ',';
          }
        }

        next += base64Vlq.encode(mapping.generatedColumn
                                   - previousGeneratedColumn);
        previousGeneratedColumn = mapping.generatedColumn;

        if (mapping.source != null) {
          sourceIdx = this._sources.indexOf(mapping.source);
          next += base64Vlq.encode(sourceIdx - previousSource);
          previousSource = sourceIdx;

          // lines are stored 0-based in SourceMap spec version 3
          next += base64Vlq.encode(mapping.originalLine - 1
                                     - previousOriginalLine);
          previousOriginalLine = mapping.originalLine - 1;

          next += base64Vlq.encode(mapping.originalColumn
                                     - previousOriginalColumn);
          previousOriginalColumn = mapping.originalColumn;

          if (mapping.name != null) {
            nameIdx = this._names.indexOf(mapping.name);
            next += base64Vlq.encode(nameIdx - previousName);
            previousName = nameIdx;
          }
        }

        result += next;
      }

      return result;
    };

  SourceMapGenerator$2.prototype._generateSourcesContent =
    function SourceMapGenerator_generateSourcesContent(aSources, aSourceRoot) {
      return aSources.map(function (source) {
        if (!this._sourcesContents) {
          return null;
        }
        if (aSourceRoot != null) {
          source = util.relative(aSourceRoot, source);
        }
        var key = util.toSetString(source);
        return Object.prototype.hasOwnProperty.call(this._sourcesContents, key)
          ? this._sourcesContents[key]
          : null;
      }, this);
    };

  /**
   * Externalize the source map.
   */
  SourceMapGenerator$2.prototype.toJSON =
    function SourceMapGenerator_toJSON() {
      var map = {
        version: this._version,
        sources: this._sources.toArray(),
        names: this._names.toArray(),
        mappings: this._serializeMappings()
      };
      if (this._file != null) {
        map.file = this._file;
      }
      if (this._sourceRoot != null) {
        map.sourceRoot = this._sourceRoot;
      }
      if (this._sourcesContents) {
        map.sourcesContent = this._generateSourcesContent(map.sources, map.sourceRoot);
      }

      return map;
    };

  /**
   * Render the source map being generated to a string.
   */
  SourceMapGenerator$2.prototype.toString =
    function SourceMapGenerator_toString() {
      return JSON.stringify(this.toJSON());
    };

  var SourceMapGenerator_1 = SourceMapGenerator$2;

  var sourceMapGenerator = {
  	SourceMapGenerator: SourceMapGenerator_1
  };

  /* -*- Mode: js; js-indent-level: 2; -*- */

  var binarySearch = createCommonjsModule(function (module, exports) {
  /*
   * Copyright 2011 Mozilla Foundation and contributors
   * Licensed under the New BSD license. See LICENSE or:
   * http://opensource.org/licenses/BSD-3-Clause
   */

  exports.GREATEST_LOWER_BOUND = 1;
  exports.LEAST_UPPER_BOUND = 2;

  /**
   * Recursive implementation of binary search.
   *
   * @param aLow Indices here and lower do not contain the needle.
   * @param aHigh Indices here and higher do not contain the needle.
   * @param aNeedle The element being searched for.
   * @param aHaystack The non-empty array being searched.
   * @param aCompare Function which takes two elements and returns -1, 0, or 1.
   * @param aBias Either 'binarySearch.GREATEST_LOWER_BOUND' or
   *     'binarySearch.LEAST_UPPER_BOUND'. Specifies whether to return the
   *     closest element that is smaller than or greater than the one we are
   *     searching for, respectively, if the exact element cannot be found.
   */
  function recursiveSearch(aLow, aHigh, aNeedle, aHaystack, aCompare, aBias) {
    // This function terminates when one of the following is true:
    //
    //   1. We find the exact element we are looking for.
    //
    //   2. We did not find the exact element, but we can return the index of
    //      the next-closest element.
    //
    //   3. We did not find the exact element, and there is no next-closest
    //      element than the one we are searching for, so we return -1.
    var mid = Math.floor((aHigh - aLow) / 2) + aLow;
    var cmp = aCompare(aNeedle, aHaystack[mid], true);
    if (cmp === 0) {
      // Found the element we are looking for.
      return mid;
    }
    else if (cmp > 0) {
      // Our needle is greater than aHaystack[mid].
      if (aHigh - mid > 1) {
        // The element is in the upper half.
        return recursiveSearch(mid, aHigh, aNeedle, aHaystack, aCompare, aBias);
      }

      // The exact needle element was not found in this haystack. Determine if
      // we are in termination case (3) or (2) and return the appropriate thing.
      if (aBias == exports.LEAST_UPPER_BOUND) {
        return aHigh < aHaystack.length ? aHigh : -1;
      } else {
        return mid;
      }
    }
    else {
      // Our needle is less than aHaystack[mid].
      if (mid - aLow > 1) {
        // The element is in the lower half.
        return recursiveSearch(aLow, mid, aNeedle, aHaystack, aCompare, aBias);
      }

      // we are in termination case (3) or (2) and return the appropriate thing.
      if (aBias == exports.LEAST_UPPER_BOUND) {
        return mid;
      } else {
        return aLow < 0 ? -1 : aLow;
      }
    }
  }

  /**
   * This is an implementation of binary search which will always try and return
   * the index of the closest element if there is no exact hit. This is because
   * mappings between original and generated line/col pairs are single points,
   * and there is an implicit region between each of them, so a miss just means
   * that you aren't on the very start of a region.
   *
   * @param aNeedle The element you are looking for.
   * @param aHaystack The array that is being searched.
   * @param aCompare A function which takes the needle and an element in the
   *     array and returns -1, 0, or 1 depending on whether the needle is less
   *     than, equal to, or greater than the element, respectively.
   * @param aBias Either 'binarySearch.GREATEST_LOWER_BOUND' or
   *     'binarySearch.LEAST_UPPER_BOUND'. Specifies whether to return the
   *     closest element that is smaller than or greater than the one we are
   *     searching for, respectively, if the exact element cannot be found.
   *     Defaults to 'binarySearch.GREATEST_LOWER_BOUND'.
   */
  exports.search = function search(aNeedle, aHaystack, aCompare, aBias) {
    if (aHaystack.length === 0) {
      return -1;
    }

    var index = recursiveSearch(-1, aHaystack.length, aNeedle, aHaystack,
                                aCompare, aBias || exports.GREATEST_LOWER_BOUND);
    if (index < 0) {
      return -1;
    }

    // We have found either the exact element, or the next-closest element than
    // the one we are searching for. However, there may be more than one such
    // element. Make sure we always return the smallest of these.
    while (index - 1 >= 0) {
      if (aCompare(aHaystack[index], aHaystack[index - 1], true) !== 0) {
        break;
      }
      --index;
    }

    return index;
  };
  });

  /* -*- Mode: js; js-indent-level: 2; -*- */
  /*
   * Copyright 2011 Mozilla Foundation and contributors
   * Licensed under the New BSD license. See LICENSE or:
   * http://opensource.org/licenses/BSD-3-Clause
   */

  // It turns out that some (most?) JavaScript engines don't self-host
  // `Array.prototype.sort`. This makes sense because C++ will likely remain
  // faster than JS when doing raw CPU-intensive sorting. However, when using a
  // custom comparator function, calling back and forth between the VM's C++ and
  // JIT'd JS is rather slow *and* loses JIT type information, resulting in
  // worse generated code for the comparator function than would be optimal. In
  // fact, when sorting with a comparator, these costs outweigh the benefits of
  // sorting in C++. By using our own JS-implemented Quick Sort (below), we get
  // a ~3500ms mean speed-up in `bench/bench.html`.

  /**
   * Swap the elements indexed by `x` and `y` in the array `ary`.
   *
   * @param {Array} ary
   *        The array.
   * @param {Number} x
   *        The index of the first item.
   * @param {Number} y
   *        The index of the second item.
   */
  function swap(ary, x, y) {
    var temp = ary[x];
    ary[x] = ary[y];
    ary[y] = temp;
  }

  /**
   * Returns a random integer within the range `low .. high` inclusive.
   *
   * @param {Number} low
   *        The lower bound on the range.
   * @param {Number} high
   *        The upper bound on the range.
   */
  function randomIntInRange(low, high) {
    return Math.round(low + (Math.random() * (high - low)));
  }

  /**
   * The Quick Sort algorithm.
   *
   * @param {Array} ary
   *        An array to sort.
   * @param {function} comparator
   *        Function to use to compare two items.
   * @param {Number} p
   *        Start index of the array
   * @param {Number} r
   *        End index of the array
   */
  function doQuickSort(ary, comparator, p, r) {
    // If our lower bound is less than our upper bound, we (1) partition the
    // array into two pieces and (2) recurse on each half. If it is not, this is
    // the empty array and our base case.

    if (p < r) {
      // (1) Partitioning.
      //
      // The partitioning chooses a pivot between `p` and `r` and moves all
      // elements that are less than or equal to the pivot to the before it, and
      // all the elements that are greater than it after it. The effect is that
      // once partition is done, the pivot is in the exact place it will be when
      // the array is put in sorted order, and it will not need to be moved
      // again. This runs in O(n) time.

      // Always choose a random pivot so that an input array which is reverse
      // sorted does not cause O(n^2) running time.
      var pivotIndex = randomIntInRange(p, r);
      var i = p - 1;

      swap(ary, pivotIndex, r);
      var pivot = ary[r];

      // Immediately after `j` is incremented in this loop, the following hold
      // true:
      //
      //   * Every element in `ary[p .. i]` is less than or equal to the pivot.
      //
      //   * Every element in `ary[i+1 .. j-1]` is greater than the pivot.
      for (var j = p; j < r; j++) {
        if (comparator(ary[j], pivot) <= 0) {
          i += 1;
          swap(ary, i, j);
        }
      }

      swap(ary, i + 1, j);
      var q = i + 1;

      // (2) Recurse on each half.

      doQuickSort(ary, comparator, p, q - 1);
      doQuickSort(ary, comparator, q + 1, r);
    }
  }

  /**
   * Sort the given array in-place with the given comparator function.
   *
   * @param {Array} ary
   *        An array to sort.
   * @param {function} comparator
   *        Function to use to compare two items.
   */
  var quickSort_1 = function (ary, comparator) {
    doQuickSort(ary, comparator, 0, ary.length - 1);
  };

  var quickSort$1 = {
  	quickSort: quickSort_1
  };

  /* -*- Mode: js; js-indent-level: 2; -*- */

  /*
   * Copyright 2011 Mozilla Foundation and contributors
   * Licensed under the New BSD license. See LICENSE or:
   * http://opensource.org/licenses/BSD-3-Clause
   */



  var ArraySet = arraySet.ArraySet;

  var quickSort = quickSort$1.quickSort;

  function SourceMapConsumer$1(aSourceMap, aSourceMapURL) {
    var sourceMap = aSourceMap;
    if (typeof aSourceMap === 'string') {
      sourceMap = util.parseSourceMapInput(aSourceMap);
    }

    return sourceMap.sections != null
      ? new IndexedSourceMapConsumer(sourceMap, aSourceMapURL)
      : new BasicSourceMapConsumer(sourceMap, aSourceMapURL);
  }

  SourceMapConsumer$1.fromSourceMap = function(aSourceMap, aSourceMapURL) {
    return BasicSourceMapConsumer.fromSourceMap(aSourceMap, aSourceMapURL);
  };

  /**
   * The version of the source mapping spec that we are consuming.
   */
  SourceMapConsumer$1.prototype._version = 3;

  // `__generatedMappings` and `__originalMappings` are arrays that hold the
  // parsed mapping coordinates from the source map's "mappings" attribute. They
  // are lazily instantiated, accessed via the `_generatedMappings` and
  // `_originalMappings` getters respectively, and we only parse the mappings
  // and create these arrays once queried for a source location. We jump through
  // these hoops because there can be many thousands of mappings, and parsing
  // them is expensive, so we only want to do it if we must.
  //
  // Each object in the arrays is of the form:
  //
  //     {
  //       generatedLine: The line number in the generated code,
  //       generatedColumn: The column number in the generated code,
  //       source: The path to the original source file that generated this
  //               chunk of code,
  //       originalLine: The line number in the original source that
  //                     corresponds to this chunk of generated code,
  //       originalColumn: The column number in the original source that
  //                       corresponds to this chunk of generated code,
  //       name: The name of the original symbol which generated this chunk of
  //             code.
  //     }
  //
  // All properties except for `generatedLine` and `generatedColumn` can be
  // `null`.
  //
  // `_generatedMappings` is ordered by the generated positions.
  //
  // `_originalMappings` is ordered by the original positions.

  SourceMapConsumer$1.prototype.__generatedMappings = null;
  Object.defineProperty(SourceMapConsumer$1.prototype, '_generatedMappings', {
    configurable: true,
    enumerable: true,
    get: function () {
      if (!this.__generatedMappings) {
        this._parseMappings(this._mappings, this.sourceRoot);
      }

      return this.__generatedMappings;
    }
  });

  SourceMapConsumer$1.prototype.__originalMappings = null;
  Object.defineProperty(SourceMapConsumer$1.prototype, '_originalMappings', {
    configurable: true,
    enumerable: true,
    get: function () {
      if (!this.__originalMappings) {
        this._parseMappings(this._mappings, this.sourceRoot);
      }

      return this.__originalMappings;
    }
  });

  SourceMapConsumer$1.prototype._charIsMappingSeparator =
    function SourceMapConsumer_charIsMappingSeparator(aStr, index) {
      var c = aStr.charAt(index);
      return c === ";" || c === ",";
    };

  /**
   * Parse the mappings in a string in to a data structure which we can easily
   * query (the ordered arrays in the `this.__generatedMappings` and
   * `this.__originalMappings` properties).
   */
  SourceMapConsumer$1.prototype._parseMappings =
    function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
      throw new Error("Subclasses must implement _parseMappings");
    };

  SourceMapConsumer$1.GENERATED_ORDER = 1;
  SourceMapConsumer$1.ORIGINAL_ORDER = 2;

  SourceMapConsumer$1.GREATEST_LOWER_BOUND = 1;
  SourceMapConsumer$1.LEAST_UPPER_BOUND = 2;

  /**
   * Iterate over each mapping between an original source/line/column and a
   * generated line/column in this source map.
   *
   * @param Function aCallback
   *        The function that is called with each mapping.
   * @param Object aContext
   *        Optional. If specified, this object will be the value of `this` every
   *        time that `aCallback` is called.
   * @param aOrder
   *        Either `SourceMapConsumer.GENERATED_ORDER` or
   *        `SourceMapConsumer.ORIGINAL_ORDER`. Specifies whether you want to
   *        iterate over the mappings sorted by the generated file's line/column
   *        order or the original's source/line/column order, respectively. Defaults to
   *        `SourceMapConsumer.GENERATED_ORDER`.
   */
  SourceMapConsumer$1.prototype.eachMapping =
    function SourceMapConsumer_eachMapping(aCallback, aContext, aOrder) {
      var context = aContext || null;
      var order = aOrder || SourceMapConsumer$1.GENERATED_ORDER;

      var mappings;
      switch (order) {
      case SourceMapConsumer$1.GENERATED_ORDER:
        mappings = this._generatedMappings;
        break;
      case SourceMapConsumer$1.ORIGINAL_ORDER:
        mappings = this._originalMappings;
        break;
      default:
        throw new Error("Unknown order of iteration.");
      }

      var sourceRoot = this.sourceRoot;
      mappings.map(function (mapping) {
        var source = mapping.source === null ? null : this._sources.at(mapping.source);
        source = util.computeSourceURL(sourceRoot, source, this._sourceMapURL);
        return {
          source: source,
          generatedLine: mapping.generatedLine,
          generatedColumn: mapping.generatedColumn,
          originalLine: mapping.originalLine,
          originalColumn: mapping.originalColumn,
          name: mapping.name === null ? null : this._names.at(mapping.name)
        };
      }, this).forEach(aCallback, context);
    };

  /**
   * Returns all generated line and column information for the original source,
   * line, and column provided. If no column is provided, returns all mappings
   * corresponding to a either the line we are searching for or the next
   * closest line that has any mappings. Otherwise, returns all mappings
   * corresponding to the given line and either the column we are searching for
   * or the next closest column that has any offsets.
   *
   * The only argument is an object with the following properties:
   *
   *   - source: The filename of the original source.
   *   - line: The line number in the original source.  The line number is 1-based.
   *   - column: Optional. the column number in the original source.
   *    The column number is 0-based.
   *
   * and an array of objects is returned, each with the following properties:
   *
   *   - line: The line number in the generated source, or null.  The
   *    line number is 1-based.
   *   - column: The column number in the generated source, or null.
   *    The column number is 0-based.
   */
  SourceMapConsumer$1.prototype.allGeneratedPositionsFor =
    function SourceMapConsumer_allGeneratedPositionsFor(aArgs) {
      var line = util.getArg(aArgs, 'line');

      // When there is no exact match, BasicSourceMapConsumer.prototype._findMapping
      // returns the index of the closest mapping less than the needle. By
      // setting needle.originalColumn to 0, we thus find the last mapping for
      // the given line, provided such a mapping exists.
      var needle = {
        source: util.getArg(aArgs, 'source'),
        originalLine: line,
        originalColumn: util.getArg(aArgs, 'column', 0)
      };

      needle.source = this._findSourceIndex(needle.source);
      if (needle.source < 0) {
        return [];
      }

      var mappings = [];

      var index = this._findMapping(needle,
                                    this._originalMappings,
                                    "originalLine",
                                    "originalColumn",
                                    util.compareByOriginalPositions,
                                    binarySearch.LEAST_UPPER_BOUND);
      if (index >= 0) {
        var mapping = this._originalMappings[index];

        if (aArgs.column === undefined) {
          var originalLine = mapping.originalLine;

          // Iterate until either we run out of mappings, or we run into
          // a mapping for a different line than the one we found. Since
          // mappings are sorted, this is guaranteed to find all mappings for
          // the line we found.
          while (mapping && mapping.originalLine === originalLine) {
            mappings.push({
              line: util.getArg(mapping, 'generatedLine', null),
              column: util.getArg(mapping, 'generatedColumn', null),
              lastColumn: util.getArg(mapping, 'lastGeneratedColumn', null)
            });

            mapping = this._originalMappings[++index];
          }
        } else {
          var originalColumn = mapping.originalColumn;

          // Iterate until either we run out of mappings, or we run into
          // a mapping for a different line than the one we were searching for.
          // Since mappings are sorted, this is guaranteed to find all mappings for
          // the line we are searching for.
          while (mapping &&
                 mapping.originalLine === line &&
                 mapping.originalColumn == originalColumn) {
            mappings.push({
              line: util.getArg(mapping, 'generatedLine', null),
              column: util.getArg(mapping, 'generatedColumn', null),
              lastColumn: util.getArg(mapping, 'lastGeneratedColumn', null)
            });

            mapping = this._originalMappings[++index];
          }
        }
      }

      return mappings;
    };

  var SourceMapConsumer_1 = SourceMapConsumer$1;

  /**
   * A BasicSourceMapConsumer instance represents a parsed source map which we can
   * query for information about the original file positions by giving it a file
   * position in the generated source.
   *
   * The first parameter is the raw source map (either as a JSON string, or
   * already parsed to an object). According to the spec, source maps have the
   * following attributes:
   *
   *   - version: Which version of the source map spec this map is following.
   *   - sources: An array of URLs to the original source files.
   *   - names: An array of identifiers which can be referrenced by individual mappings.
   *   - sourceRoot: Optional. The URL root from which all sources are relative.
   *   - sourcesContent: Optional. An array of contents of the original source files.
   *   - mappings: A string of base64 VLQs which contain the actual mappings.
   *   - file: Optional. The generated file this source map is associated with.
   *
   * Here is an example source map, taken from the source map spec[0]:
   *
   *     {
   *       version : 3,
   *       file: "out.js",
   *       sourceRoot : "",
   *       sources: ["foo.js", "bar.js"],
   *       names: ["src", "maps", "are", "fun"],
   *       mappings: "AA,AB;;ABCDE;"
   *     }
   *
   * The second parameter, if given, is a string whose value is the URL
   * at which the source map was found.  This URL is used to compute the
   * sources array.
   *
   * [0]: https://docs.google.com/document/d/1U1RGAehQwRypUTovF1KRlpiOFze0b-_2gc6fAH0KY0k/edit?pli=1#
   */
  function BasicSourceMapConsumer(aSourceMap, aSourceMapURL) {
    var sourceMap = aSourceMap;
    if (typeof aSourceMap === 'string') {
      sourceMap = util.parseSourceMapInput(aSourceMap);
    }

    var version = util.getArg(sourceMap, 'version');
    var sources = util.getArg(sourceMap, 'sources');
    // Sass 3.3 leaves out the 'names' array, so we deviate from the spec (which
    // requires the array) to play nice here.
    var names = util.getArg(sourceMap, 'names', []);
    var sourceRoot = util.getArg(sourceMap, 'sourceRoot', null);
    var sourcesContent = util.getArg(sourceMap, 'sourcesContent', null);
    var mappings = util.getArg(sourceMap, 'mappings');
    var file = util.getArg(sourceMap, 'file', null);

    // Once again, Sass deviates from the spec and supplies the version as a
    // string rather than a number, so we use loose equality checking here.
    if (version != this._version) {
      throw new Error('Unsupported version: ' + version);
    }

    if (sourceRoot) {
      sourceRoot = util.normalize(sourceRoot);
    }

    sources = sources
      .map(String)
      // Some source maps produce relative source paths like "./foo.js" instead of
      // "foo.js".  Normalize these first so that future comparisons will succeed.
      // See bugzil.la/1090768.
      .map(util.normalize)
      // Always ensure that absolute sources are internally stored relative to
      // the source root, if the source root is absolute. Not doing this would
      // be particularly problematic when the source root is a prefix of the
      // source (valid, but why??). See github issue #199 and bugzil.la/1188982.
      .map(function (source) {
        return sourceRoot && util.isAbsolute(sourceRoot) && util.isAbsolute(source)
          ? util.relative(sourceRoot, source)
          : source;
      });

    // Pass `true` below to allow duplicate names and sources. While source maps
    // are intended to be compressed and deduplicated, the TypeScript compiler
    // sometimes generates source maps with duplicates in them. See Github issue
    // #72 and bugzil.la/889492.
    this._names = ArraySet.fromArray(names.map(String), true);
    this._sources = ArraySet.fromArray(sources, true);

    this._absoluteSources = this._sources.toArray().map(function (s) {
      return util.computeSourceURL(sourceRoot, s, aSourceMapURL);
    });

    this.sourceRoot = sourceRoot;
    this.sourcesContent = sourcesContent;
    this._mappings = mappings;
    this._sourceMapURL = aSourceMapURL;
    this.file = file;
  }

  BasicSourceMapConsumer.prototype = Object.create(SourceMapConsumer$1.prototype);
  BasicSourceMapConsumer.prototype.consumer = SourceMapConsumer$1;

  /**
   * Utility function to find the index of a source.  Returns -1 if not
   * found.
   */
  BasicSourceMapConsumer.prototype._findSourceIndex = function(aSource) {
    var relativeSource = aSource;
    if (this.sourceRoot != null) {
      relativeSource = util.relative(this.sourceRoot, relativeSource);
    }

    if (this._sources.has(relativeSource)) {
      return this._sources.indexOf(relativeSource);
    }

    // Maybe aSource is an absolute URL as returned by |sources|.  In
    // this case we can't simply undo the transform.
    var i;
    for (i = 0; i < this._absoluteSources.length; ++i) {
      if (this._absoluteSources[i] == aSource) {
        return i;
      }
    }

    return -1;
  };

  /**
   * Create a BasicSourceMapConsumer from a SourceMapGenerator.
   *
   * @param SourceMapGenerator aSourceMap
   *        The source map that will be consumed.
   * @param String aSourceMapURL
   *        The URL at which the source map can be found (optional)
   * @returns BasicSourceMapConsumer
   */
  BasicSourceMapConsumer.fromSourceMap =
    function SourceMapConsumer_fromSourceMap(aSourceMap, aSourceMapURL) {
      var smc = Object.create(BasicSourceMapConsumer.prototype);

      var names = smc._names = ArraySet.fromArray(aSourceMap._names.toArray(), true);
      var sources = smc._sources = ArraySet.fromArray(aSourceMap._sources.toArray(), true);
      smc.sourceRoot = aSourceMap._sourceRoot;
      smc.sourcesContent = aSourceMap._generateSourcesContent(smc._sources.toArray(),
                                                              smc.sourceRoot);
      smc.file = aSourceMap._file;
      smc._sourceMapURL = aSourceMapURL;
      smc._absoluteSources = smc._sources.toArray().map(function (s) {
        return util.computeSourceURL(smc.sourceRoot, s, aSourceMapURL);
      });

      // Because we are modifying the entries (by converting string sources and
      // names to indices into the sources and names ArraySets), we have to make
      // a copy of the entry or else bad things happen. Shared mutable state
      // strikes again! See github issue #191.

      var generatedMappings = aSourceMap._mappings.toArray().slice();
      var destGeneratedMappings = smc.__generatedMappings = [];
      var destOriginalMappings = smc.__originalMappings = [];

      for (var i = 0, length = generatedMappings.length; i < length; i++) {
        var srcMapping = generatedMappings[i];
        var destMapping = new Mapping;
        destMapping.generatedLine = srcMapping.generatedLine;
        destMapping.generatedColumn = srcMapping.generatedColumn;

        if (srcMapping.source) {
          destMapping.source = sources.indexOf(srcMapping.source);
          destMapping.originalLine = srcMapping.originalLine;
          destMapping.originalColumn = srcMapping.originalColumn;

          if (srcMapping.name) {
            destMapping.name = names.indexOf(srcMapping.name);
          }

          destOriginalMappings.push(destMapping);
        }

        destGeneratedMappings.push(destMapping);
      }

      quickSort(smc.__originalMappings, util.compareByOriginalPositions);

      return smc;
    };

  /**
   * The version of the source mapping spec that we are consuming.
   */
  BasicSourceMapConsumer.prototype._version = 3;

  /**
   * The list of original sources.
   */
  Object.defineProperty(BasicSourceMapConsumer.prototype, 'sources', {
    get: function () {
      return this._absoluteSources.slice();
    }
  });

  /**
   * Provide the JIT with a nice shape / hidden class.
   */
  function Mapping() {
    this.generatedLine = 0;
    this.generatedColumn = 0;
    this.source = null;
    this.originalLine = null;
    this.originalColumn = null;
    this.name = null;
  }

  /**
   * Parse the mappings in a string in to a data structure which we can easily
   * query (the ordered arrays in the `this.__generatedMappings` and
   * `this.__originalMappings` properties).
   */
  BasicSourceMapConsumer.prototype._parseMappings =
    function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
      var generatedLine = 1;
      var previousGeneratedColumn = 0;
      var previousOriginalLine = 0;
      var previousOriginalColumn = 0;
      var previousSource = 0;
      var previousName = 0;
      var length = aStr.length;
      var index = 0;
      var cachedSegments = {};
      var temp = {};
      var originalMappings = [];
      var generatedMappings = [];
      var mapping, str, segment, end, value;

      while (index < length) {
        if (aStr.charAt(index) === ';') {
          generatedLine++;
          index++;
          previousGeneratedColumn = 0;
        }
        else if (aStr.charAt(index) === ',') {
          index++;
        }
        else {
          mapping = new Mapping();
          mapping.generatedLine = generatedLine;

          // Because each offset is encoded relative to the previous one,
          // many segments often have the same encoding. We can exploit this
          // fact by caching the parsed variable length fields of each segment,
          // allowing us to avoid a second parse if we encounter the same
          // segment again.
          for (end = index; end < length; end++) {
            if (this._charIsMappingSeparator(aStr, end)) {
              break;
            }
          }
          str = aStr.slice(index, end);

          segment = cachedSegments[str];
          if (segment) {
            index += str.length;
          } else {
            segment = [];
            while (index < end) {
              base64Vlq.decode(aStr, index, temp);
              value = temp.value;
              index = temp.rest;
              segment.push(value);
            }

            if (segment.length === 2) {
              throw new Error('Found a source, but no line and column');
            }

            if (segment.length === 3) {
              throw new Error('Found a source and line, but no column');
            }

            cachedSegments[str] = segment;
          }

          // Generated column.
          mapping.generatedColumn = previousGeneratedColumn + segment[0];
          previousGeneratedColumn = mapping.generatedColumn;

          if (segment.length > 1) {
            // Original source.
            mapping.source = previousSource + segment[1];
            previousSource += segment[1];

            // Original line.
            mapping.originalLine = previousOriginalLine + segment[2];
            previousOriginalLine = mapping.originalLine;
            // Lines are stored 0-based
            mapping.originalLine += 1;

            // Original column.
            mapping.originalColumn = previousOriginalColumn + segment[3];
            previousOriginalColumn = mapping.originalColumn;

            if (segment.length > 4) {
              // Original name.
              mapping.name = previousName + segment[4];
              previousName += segment[4];
            }
          }

          generatedMappings.push(mapping);
          if (typeof mapping.originalLine === 'number') {
            originalMappings.push(mapping);
          }
        }
      }

      quickSort(generatedMappings, util.compareByGeneratedPositionsDeflated);
      this.__generatedMappings = generatedMappings;

      quickSort(originalMappings, util.compareByOriginalPositions);
      this.__originalMappings = originalMappings;
    };

  /**
   * Find the mapping that best matches the hypothetical "needle" mapping that
   * we are searching for in the given "haystack" of mappings.
   */
  BasicSourceMapConsumer.prototype._findMapping =
    function SourceMapConsumer_findMapping(aNeedle, aMappings, aLineName,
                                           aColumnName, aComparator, aBias) {
      // To return the position we are searching for, we must first find the
      // mapping for the given position and then return the opposite position it
      // points to. Because the mappings are sorted, we can use binary search to
      // find the best mapping.

      if (aNeedle[aLineName] <= 0) {
        throw new TypeError('Line must be greater than or equal to 1, got '
                            + aNeedle[aLineName]);
      }
      if (aNeedle[aColumnName] < 0) {
        throw new TypeError('Column must be greater than or equal to 0, got '
                            + aNeedle[aColumnName]);
      }

      return binarySearch.search(aNeedle, aMappings, aComparator, aBias);
    };

  /**
   * Compute the last column for each generated mapping. The last column is
   * inclusive.
   */
  BasicSourceMapConsumer.prototype.computeColumnSpans =
    function SourceMapConsumer_computeColumnSpans() {
      for (var index = 0; index < this._generatedMappings.length; ++index) {
        var mapping = this._generatedMappings[index];

        // Mappings do not contain a field for the last generated columnt. We
        // can come up with an optimistic estimate, however, by assuming that
        // mappings are contiguous (i.e. given two consecutive mappings, the
        // first mapping ends where the second one starts).
        if (index + 1 < this._generatedMappings.length) {
          var nextMapping = this._generatedMappings[index + 1];

          if (mapping.generatedLine === nextMapping.generatedLine) {
            mapping.lastGeneratedColumn = nextMapping.generatedColumn - 1;
            continue;
          }
        }

        // The last mapping for each line spans the entire line.
        mapping.lastGeneratedColumn = Infinity;
      }
    };

  /**
   * Returns the original source, line, and column information for the generated
   * source's line and column positions provided. The only argument is an object
   * with the following properties:
   *
   *   - line: The line number in the generated source.  The line number
   *     is 1-based.
   *   - column: The column number in the generated source.  The column
   *     number is 0-based.
   *   - bias: Either 'SourceMapConsumer.GREATEST_LOWER_BOUND' or
   *     'SourceMapConsumer.LEAST_UPPER_BOUND'. Specifies whether to return the
   *     closest element that is smaller than or greater than the one we are
   *     searching for, respectively, if the exact element cannot be found.
   *     Defaults to 'SourceMapConsumer.GREATEST_LOWER_BOUND'.
   *
   * and an object is returned with the following properties:
   *
   *   - source: The original source file, or null.
   *   - line: The line number in the original source, or null.  The
   *     line number is 1-based.
   *   - column: The column number in the original source, or null.  The
   *     column number is 0-based.
   *   - name: The original identifier, or null.
   */
  BasicSourceMapConsumer.prototype.originalPositionFor =
    function SourceMapConsumer_originalPositionFor(aArgs) {
      var needle = {
        generatedLine: util.getArg(aArgs, 'line'),
        generatedColumn: util.getArg(aArgs, 'column')
      };

      var index = this._findMapping(
        needle,
        this._generatedMappings,
        "generatedLine",
        "generatedColumn",
        util.compareByGeneratedPositionsDeflated,
        util.getArg(aArgs, 'bias', SourceMapConsumer$1.GREATEST_LOWER_BOUND)
      );

      if (index >= 0) {
        var mapping = this._generatedMappings[index];

        if (mapping.generatedLine === needle.generatedLine) {
          var source = util.getArg(mapping, 'source', null);
          if (source !== null) {
            source = this._sources.at(source);
            source = util.computeSourceURL(this.sourceRoot, source, this._sourceMapURL);
          }
          var name = util.getArg(mapping, 'name', null);
          if (name !== null) {
            name = this._names.at(name);
          }
          return {
            source: source,
            line: util.getArg(mapping, 'originalLine', null),
            column: util.getArg(mapping, 'originalColumn', null),
            name: name
          };
        }
      }

      return {
        source: null,
        line: null,
        column: null,
        name: null
      };
    };

  /**
   * Return true if we have the source content for every source in the source
   * map, false otherwise.
   */
  BasicSourceMapConsumer.prototype.hasContentsOfAllSources =
    function BasicSourceMapConsumer_hasContentsOfAllSources() {
      if (!this.sourcesContent) {
        return false;
      }
      return this.sourcesContent.length >= this._sources.size() &&
        !this.sourcesContent.some(function (sc) { return sc == null; });
    };

  /**
   * Returns the original source content. The only argument is the url of the
   * original source file. Returns null if no original source content is
   * available.
   */
  BasicSourceMapConsumer.prototype.sourceContentFor =
    function SourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
      if (!this.sourcesContent) {
        return null;
      }

      var index = this._findSourceIndex(aSource);
      if (index >= 0) {
        return this.sourcesContent[index];
      }

      var relativeSource = aSource;
      if (this.sourceRoot != null) {
        relativeSource = util.relative(this.sourceRoot, relativeSource);
      }

      var url;
      if (this.sourceRoot != null
          && (url = util.urlParse(this.sourceRoot))) {
        // XXX: file:// URIs and absolute paths lead to unexpected behavior for
        // many users. We can help them out when they expect file:// URIs to
        // behave like it would if they were running a local HTTP server. See
        // https://bugzilla.mozilla.org/show_bug.cgi?id=885597.
        var fileUriAbsPath = relativeSource.replace(/^file:\/\//, "");
        if (url.scheme == "file"
            && this._sources.has(fileUriAbsPath)) {
          return this.sourcesContent[this._sources.indexOf(fileUriAbsPath)]
        }

        if ((!url.path || url.path == "/")
            && this._sources.has("/" + relativeSource)) {
          return this.sourcesContent[this._sources.indexOf("/" + relativeSource)];
        }
      }

      // This function is used recursively from
      // IndexedSourceMapConsumer.prototype.sourceContentFor. In that case, we
      // don't want to throw if we can't find the source - we just want to
      // return null, so we provide a flag to exit gracefully.
      if (nullOnMissing) {
        return null;
      }
      else {
        throw new Error('"' + relativeSource + '" is not in the SourceMap.');
      }
    };

  /**
   * Returns the generated line and column information for the original source,
   * line, and column positions provided. The only argument is an object with
   * the following properties:
   *
   *   - source: The filename of the original source.
   *   - line: The line number in the original source.  The line number
   *     is 1-based.
   *   - column: The column number in the original source.  The column
   *     number is 0-based.
   *   - bias: Either 'SourceMapConsumer.GREATEST_LOWER_BOUND' or
   *     'SourceMapConsumer.LEAST_UPPER_BOUND'. Specifies whether to return the
   *     closest element that is smaller than or greater than the one we are
   *     searching for, respectively, if the exact element cannot be found.
   *     Defaults to 'SourceMapConsumer.GREATEST_LOWER_BOUND'.
   *
   * and an object is returned with the following properties:
   *
   *   - line: The line number in the generated source, or null.  The
   *     line number is 1-based.
   *   - column: The column number in the generated source, or null.
   *     The column number is 0-based.
   */
  BasicSourceMapConsumer.prototype.generatedPositionFor =
    function SourceMapConsumer_generatedPositionFor(aArgs) {
      var source = util.getArg(aArgs, 'source');
      source = this._findSourceIndex(source);
      if (source < 0) {
        return {
          line: null,
          column: null,
          lastColumn: null
        };
      }

      var needle = {
        source: source,
        originalLine: util.getArg(aArgs, 'line'),
        originalColumn: util.getArg(aArgs, 'column')
      };

      var index = this._findMapping(
        needle,
        this._originalMappings,
        "originalLine",
        "originalColumn",
        util.compareByOriginalPositions,
        util.getArg(aArgs, 'bias', SourceMapConsumer$1.GREATEST_LOWER_BOUND)
      );

      if (index >= 0) {
        var mapping = this._originalMappings[index];

        if (mapping.source === needle.source) {
          return {
            line: util.getArg(mapping, 'generatedLine', null),
            column: util.getArg(mapping, 'generatedColumn', null),
            lastColumn: util.getArg(mapping, 'lastGeneratedColumn', null)
          };
        }
      }

      return {
        line: null,
        column: null,
        lastColumn: null
      };
    };

  var BasicSourceMapConsumer_1 = BasicSourceMapConsumer;

  /**
   * An IndexedSourceMapConsumer instance represents a parsed source map which
   * we can query for information. It differs from BasicSourceMapConsumer in
   * that it takes "indexed" source maps (i.e. ones with a "sections" field) as
   * input.
   *
   * The first parameter is a raw source map (either as a JSON string, or already
   * parsed to an object). According to the spec for indexed source maps, they
   * have the following attributes:
   *
   *   - version: Which version of the source map spec this map is following.
   *   - file: Optional. The generated file this source map is associated with.
   *   - sections: A list of section definitions.
   *
   * Each value under the "sections" field has two fields:
   *   - offset: The offset into the original specified at which this section
   *       begins to apply, defined as an object with a "line" and "column"
   *       field.
   *   - map: A source map definition. This source map could also be indexed,
   *       but doesn't have to be.
   *
   * Instead of the "map" field, it's also possible to have a "url" field
   * specifying a URL to retrieve a source map from, but that's currently
   * unsupported.
   *
   * Here's an example source map, taken from the source map spec[0], but
   * modified to omit a section which uses the "url" field.
   *
   *  {
   *    version : 3,
   *    file: "app.js",
   *    sections: [{
   *      offset: {line:100, column:10},
   *      map: {
   *        version : 3,
   *        file: "section.js",
   *        sources: ["foo.js", "bar.js"],
   *        names: ["src", "maps", "are", "fun"],
   *        mappings: "AAAA,E;;ABCDE;"
   *      }
   *    }],
   *  }
   *
   * The second parameter, if given, is a string whose value is the URL
   * at which the source map was found.  This URL is used to compute the
   * sources array.
   *
   * [0]: https://docs.google.com/document/d/1U1RGAehQwRypUTovF1KRlpiOFze0b-_2gc6fAH0KY0k/edit#heading=h.535es3xeprgt
   */
  function IndexedSourceMapConsumer(aSourceMap, aSourceMapURL) {
    var sourceMap = aSourceMap;
    if (typeof aSourceMap === 'string') {
      sourceMap = util.parseSourceMapInput(aSourceMap);
    }

    var version = util.getArg(sourceMap, 'version');
    var sections = util.getArg(sourceMap, 'sections');

    if (version != this._version) {
      throw new Error('Unsupported version: ' + version);
    }

    this._sources = new ArraySet();
    this._names = new ArraySet();

    var lastOffset = {
      line: -1,
      column: 0
    };
    this._sections = sections.map(function (s) {
      if (s.url) {
        // The url field will require support for asynchronicity.
        // See https://github.com/mozilla/source-map/issues/16
        throw new Error('Support for url field in sections not implemented.');
      }
      var offset = util.getArg(s, 'offset');
      var offsetLine = util.getArg(offset, 'line');
      var offsetColumn = util.getArg(offset, 'column');

      if (offsetLine < lastOffset.line ||
          (offsetLine === lastOffset.line && offsetColumn < lastOffset.column)) {
        throw new Error('Section offsets must be ordered and non-overlapping.');
      }
      lastOffset = offset;

      return {
        generatedOffset: {
          // The offset fields are 0-based, but we use 1-based indices when
          // encoding/decoding from VLQ.
          generatedLine: offsetLine + 1,
          generatedColumn: offsetColumn + 1
        },
        consumer: new SourceMapConsumer$1(util.getArg(s, 'map'), aSourceMapURL)
      }
    });
  }

  IndexedSourceMapConsumer.prototype = Object.create(SourceMapConsumer$1.prototype);
  IndexedSourceMapConsumer.prototype.constructor = SourceMapConsumer$1;

  /**
   * The version of the source mapping spec that we are consuming.
   */
  IndexedSourceMapConsumer.prototype._version = 3;

  /**
   * The list of original sources.
   */
  Object.defineProperty(IndexedSourceMapConsumer.prototype, 'sources', {
    get: function () {
      var sources = [];
      for (var i = 0; i < this._sections.length; i++) {
        for (var j = 0; j < this._sections[i].consumer.sources.length; j++) {
          sources.push(this._sections[i].consumer.sources[j]);
        }
      }
      return sources;
    }
  });

  /**
   * Returns the original source, line, and column information for the generated
   * source's line and column positions provided. The only argument is an object
   * with the following properties:
   *
   *   - line: The line number in the generated source.  The line number
   *     is 1-based.
   *   - column: The column number in the generated source.  The column
   *     number is 0-based.
   *
   * and an object is returned with the following properties:
   *
   *   - source: The original source file, or null.
   *   - line: The line number in the original source, or null.  The
   *     line number is 1-based.
   *   - column: The column number in the original source, or null.  The
   *     column number is 0-based.
   *   - name: The original identifier, or null.
   */
  IndexedSourceMapConsumer.prototype.originalPositionFor =
    function IndexedSourceMapConsumer_originalPositionFor(aArgs) {
      var needle = {
        generatedLine: util.getArg(aArgs, 'line'),
        generatedColumn: util.getArg(aArgs, 'column')
      };

      // Find the section containing the generated position we're trying to map
      // to an original position.
      var sectionIndex = binarySearch.search(needle, this._sections,
        function(needle, section) {
          var cmp = needle.generatedLine - section.generatedOffset.generatedLine;
          if (cmp) {
            return cmp;
          }

          return (needle.generatedColumn -
                  section.generatedOffset.generatedColumn);
        });
      var section = this._sections[sectionIndex];

      if (!section) {
        return {
          source: null,
          line: null,
          column: null,
          name: null
        };
      }

      return section.consumer.originalPositionFor({
        line: needle.generatedLine -
          (section.generatedOffset.generatedLine - 1),
        column: needle.generatedColumn -
          (section.generatedOffset.generatedLine === needle.generatedLine
           ? section.generatedOffset.generatedColumn - 1
           : 0),
        bias: aArgs.bias
      });
    };

  /**
   * Return true if we have the source content for every source in the source
   * map, false otherwise.
   */
  IndexedSourceMapConsumer.prototype.hasContentsOfAllSources =
    function IndexedSourceMapConsumer_hasContentsOfAllSources() {
      return this._sections.every(function (s) {
        return s.consumer.hasContentsOfAllSources();
      });
    };

  /**
   * Returns the original source content. The only argument is the url of the
   * original source file. Returns null if no original source content is
   * available.
   */
  IndexedSourceMapConsumer.prototype.sourceContentFor =
    function IndexedSourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
      for (var i = 0; i < this._sections.length; i++) {
        var section = this._sections[i];

        var content = section.consumer.sourceContentFor(aSource, true);
        if (content) {
          return content;
        }
      }
      if (nullOnMissing) {
        return null;
      }
      else {
        throw new Error('"' + aSource + '" is not in the SourceMap.');
      }
    };

  /**
   * Returns the generated line and column information for the original source,
   * line, and column positions provided. The only argument is an object with
   * the following properties:
   *
   *   - source: The filename of the original source.
   *   - line: The line number in the original source.  The line number
   *     is 1-based.
   *   - column: The column number in the original source.  The column
   *     number is 0-based.
   *
   * and an object is returned with the following properties:
   *
   *   - line: The line number in the generated source, or null.  The
   *     line number is 1-based. 
   *   - column: The column number in the generated source, or null.
   *     The column number is 0-based.
   */
  IndexedSourceMapConsumer.prototype.generatedPositionFor =
    function IndexedSourceMapConsumer_generatedPositionFor(aArgs) {
      for (var i = 0; i < this._sections.length; i++) {
        var section = this._sections[i];

        // Only consider this section if the requested source is in the list of
        // sources of the consumer.
        if (section.consumer._findSourceIndex(util.getArg(aArgs, 'source')) === -1) {
          continue;
        }
        var generatedPosition = section.consumer.generatedPositionFor(aArgs);
        if (generatedPosition) {
          var ret = {
            line: generatedPosition.line +
              (section.generatedOffset.generatedLine - 1),
            column: generatedPosition.column +
              (section.generatedOffset.generatedLine === generatedPosition.line
               ? section.generatedOffset.generatedColumn - 1
               : 0)
          };
          return ret;
        }
      }

      return {
        line: null,
        column: null
      };
    };

  /**
   * Parse the mappings in a string in to a data structure which we can easily
   * query (the ordered arrays in the `this.__generatedMappings` and
   * `this.__originalMappings` properties).
   */
  IndexedSourceMapConsumer.prototype._parseMappings =
    function IndexedSourceMapConsumer_parseMappings(aStr, aSourceRoot) {
      this.__generatedMappings = [];
      this.__originalMappings = [];
      for (var i = 0; i < this._sections.length; i++) {
        var section = this._sections[i];
        var sectionMappings = section.consumer._generatedMappings;
        for (var j = 0; j < sectionMappings.length; j++) {
          var mapping = sectionMappings[j];

          var source = section.consumer._sources.at(mapping.source);
          source = util.computeSourceURL(section.consumer.sourceRoot, source, this._sourceMapURL);
          this._sources.add(source);
          source = this._sources.indexOf(source);

          var name = null;
          if (mapping.name) {
            name = section.consumer._names.at(mapping.name);
            this._names.add(name);
            name = this._names.indexOf(name);
          }

          // The mappings coming from the consumer for the section have
          // generated positions relative to the start of the section, so we
          // need to offset them to be relative to the start of the concatenated
          // generated file.
          var adjustedMapping = {
            source: source,
            generatedLine: mapping.generatedLine +
              (section.generatedOffset.generatedLine - 1),
            generatedColumn: mapping.generatedColumn +
              (section.generatedOffset.generatedLine === mapping.generatedLine
              ? section.generatedOffset.generatedColumn - 1
              : 0),
            originalLine: mapping.originalLine,
            originalColumn: mapping.originalColumn,
            name: name
          };

          this.__generatedMappings.push(adjustedMapping);
          if (typeof adjustedMapping.originalLine === 'number') {
            this.__originalMappings.push(adjustedMapping);
          }
        }
      }

      quickSort(this.__generatedMappings, util.compareByGeneratedPositionsDeflated);
      quickSort(this.__originalMappings, util.compareByOriginalPositions);
    };

  var IndexedSourceMapConsumer_1 = IndexedSourceMapConsumer;

  var sourceMapConsumer = {
  	SourceMapConsumer: SourceMapConsumer_1,
  	BasicSourceMapConsumer: BasicSourceMapConsumer_1,
  	IndexedSourceMapConsumer: IndexedSourceMapConsumer_1
  };

  /* -*- Mode: js; js-indent-level: 2; -*- */

  /*
   * Copyright 2011 Mozilla Foundation and contributors
   * Licensed under the New BSD license. See LICENSE or:
   * http://opensource.org/licenses/BSD-3-Clause
   */

  var SourceMapGenerator$1 = sourceMapGenerator.SourceMapGenerator;


  // Matches a Windows-style `\r\n` newline or a `\n` newline used by all other
  // operating systems these days (capturing the result).
  var REGEX_NEWLINE = /(\r?\n)/;

  // Newline character code for charCodeAt() comparisons
  var NEWLINE_CODE = 10;

  // Private symbol for identifying `SourceNode`s when multiple versions of
  // the source-map library are loaded. This MUST NOT CHANGE across
  // versions!
  var isSourceNode = "$$$isSourceNode$$$";

  /**
   * SourceNodes provide a way to abstract over interpolating/concatenating
   * snippets of generated JavaScript source code while maintaining the line and
   * column information associated with the original source code.
   *
   * @param aLine The original line number.
   * @param aColumn The original column number.
   * @param aSource The original source's filename.
   * @param aChunks Optional. An array of strings which are snippets of
   *        generated JS, or other SourceNodes.
   * @param aName The original identifier.
   */
  function SourceNode$1(aLine, aColumn, aSource, aChunks, aName) {
    this.children = [];
    this.sourceContents = {};
    this.line = aLine == null ? null : aLine;
    this.column = aColumn == null ? null : aColumn;
    this.source = aSource == null ? null : aSource;
    this.name = aName == null ? null : aName;
    this[isSourceNode] = true;
    if (aChunks != null) this.add(aChunks);
  }

  /**
   * Creates a SourceNode from generated code and a SourceMapConsumer.
   *
   * @param aGeneratedCode The generated code
   * @param aSourceMapConsumer The SourceMap for the generated code
   * @param aRelativePath Optional. The path that relative sources in the
   *        SourceMapConsumer should be relative to.
   */
  SourceNode$1.fromStringWithSourceMap =
    function SourceNode_fromStringWithSourceMap(aGeneratedCode, aSourceMapConsumer, aRelativePath) {
      // The SourceNode we want to fill with the generated code
      // and the SourceMap
      var node = new SourceNode$1();

      // All even indices of this array are one line of the generated code,
      // while all odd indices are the newlines between two adjacent lines
      // (since `REGEX_NEWLINE` captures its match).
      // Processed fragments are accessed by calling `shiftNextLine`.
      var remainingLines = aGeneratedCode.split(REGEX_NEWLINE);
      var remainingLinesIndex = 0;
      var shiftNextLine = function() {
        var lineContents = getNextLine();
        // The last line of a file might not have a newline.
        var newLine = getNextLine() || "";
        return lineContents + newLine;

        function getNextLine() {
          return remainingLinesIndex < remainingLines.length ?
              remainingLines[remainingLinesIndex++] : undefined;
        }
      };

      // We need to remember the position of "remainingLines"
      var lastGeneratedLine = 1, lastGeneratedColumn = 0;

      // The generate SourceNodes we need a code range.
      // To extract it current and last mapping is used.
      // Here we store the last mapping.
      var lastMapping = null;

      aSourceMapConsumer.eachMapping(function (mapping) {
        if (lastMapping !== null) {
          // We add the code from "lastMapping" to "mapping":
          // First check if there is a new line in between.
          if (lastGeneratedLine < mapping.generatedLine) {
            // Associate first line with "lastMapping"
            addMappingWithCode(lastMapping, shiftNextLine());
            lastGeneratedLine++;
            lastGeneratedColumn = 0;
            // The remaining code is added without mapping
          } else {
            // There is no new line in between.
            // Associate the code between "lastGeneratedColumn" and
            // "mapping.generatedColumn" with "lastMapping"
            var nextLine = remainingLines[remainingLinesIndex] || '';
            var code = nextLine.substr(0, mapping.generatedColumn -
                                          lastGeneratedColumn);
            remainingLines[remainingLinesIndex] = nextLine.substr(mapping.generatedColumn -
                                                lastGeneratedColumn);
            lastGeneratedColumn = mapping.generatedColumn;
            addMappingWithCode(lastMapping, code);
            // No more remaining code, continue
            lastMapping = mapping;
            return;
          }
        }
        // We add the generated code until the first mapping
        // to the SourceNode without any mapping.
        // Each line is added as separate string.
        while (lastGeneratedLine < mapping.generatedLine) {
          node.add(shiftNextLine());
          lastGeneratedLine++;
        }
        if (lastGeneratedColumn < mapping.generatedColumn) {
          var nextLine = remainingLines[remainingLinesIndex] || '';
          node.add(nextLine.substr(0, mapping.generatedColumn));
          remainingLines[remainingLinesIndex] = nextLine.substr(mapping.generatedColumn);
          lastGeneratedColumn = mapping.generatedColumn;
        }
        lastMapping = mapping;
      }, this);
      // We have processed all mappings.
      if (remainingLinesIndex < remainingLines.length) {
        if (lastMapping) {
          // Associate the remaining code in the current line with "lastMapping"
          addMappingWithCode(lastMapping, shiftNextLine());
        }
        // and add the remaining lines without any mapping
        node.add(remainingLines.splice(remainingLinesIndex).join(""));
      }

      // Copy sourcesContent into SourceNode
      aSourceMapConsumer.sources.forEach(function (sourceFile) {
        var content = aSourceMapConsumer.sourceContentFor(sourceFile);
        if (content != null) {
          if (aRelativePath != null) {
            sourceFile = util.join(aRelativePath, sourceFile);
          }
          node.setSourceContent(sourceFile, content);
        }
      });

      return node;

      function addMappingWithCode(mapping, code) {
        if (mapping === null || mapping.source === undefined) {
          node.add(code);
        } else {
          var source = aRelativePath
            ? util.join(aRelativePath, mapping.source)
            : mapping.source;
          node.add(new SourceNode$1(mapping.originalLine,
                                  mapping.originalColumn,
                                  source,
                                  code,
                                  mapping.name));
        }
      }
    };

  /**
   * Add a chunk of generated JS to this source node.
   *
   * @param aChunk A string snippet of generated JS code, another instance of
   *        SourceNode, or an array where each member is one of those things.
   */
  SourceNode$1.prototype.add = function SourceNode_add(aChunk) {
    if (Array.isArray(aChunk)) {
      aChunk.forEach(function (chunk) {
        this.add(chunk);
      }, this);
    }
    else if (aChunk[isSourceNode] || typeof aChunk === "string") {
      if (aChunk) {
        this.children.push(aChunk);
      }
    }
    else {
      throw new TypeError(
        "Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk
      );
    }
    return this;
  };

  /**
   * Add a chunk of generated JS to the beginning of this source node.
   *
   * @param aChunk A string snippet of generated JS code, another instance of
   *        SourceNode, or an array where each member is one of those things.
   */
  SourceNode$1.prototype.prepend = function SourceNode_prepend(aChunk) {
    if (Array.isArray(aChunk)) {
      for (var i = aChunk.length-1; i >= 0; i--) {
        this.prepend(aChunk[i]);
      }
    }
    else if (aChunk[isSourceNode] || typeof aChunk === "string") {
      this.children.unshift(aChunk);
    }
    else {
      throw new TypeError(
        "Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk
      );
    }
    return this;
  };

  /**
   * Walk over the tree of JS snippets in this node and its children. The
   * walking function is called once for each snippet of JS and is passed that
   * snippet and the its original associated source's line/column location.
   *
   * @param aFn The traversal function.
   */
  SourceNode$1.prototype.walk = function SourceNode_walk(aFn) {
    var chunk;
    for (var i = 0, len = this.children.length; i < len; i++) {
      chunk = this.children[i];
      if (chunk[isSourceNode]) {
        chunk.walk(aFn);
      }
      else {
        if (chunk !== '') {
          aFn(chunk, { source: this.source,
                       line: this.line,
                       column: this.column,
                       name: this.name });
        }
      }
    }
  };

  /**
   * Like `String.prototype.join` except for SourceNodes. Inserts `aStr` between
   * each of `this.children`.
   *
   * @param aSep The separator.
   */
  SourceNode$1.prototype.join = function SourceNode_join(aSep) {
    var newChildren;
    var i;
    var len = this.children.length;
    if (len > 0) {
      newChildren = [];
      for (i = 0; i < len-1; i++) {
        newChildren.push(this.children[i]);
        newChildren.push(aSep);
      }
      newChildren.push(this.children[i]);
      this.children = newChildren;
    }
    return this;
  };

  /**
   * Call String.prototype.replace on the very right-most source snippet. Useful
   * for trimming whitespace from the end of a source node, etc.
   *
   * @param aPattern The pattern to replace.
   * @param aReplacement The thing to replace the pattern with.
   */
  SourceNode$1.prototype.replaceRight = function SourceNode_replaceRight(aPattern, aReplacement) {
    var lastChild = this.children[this.children.length - 1];
    if (lastChild[isSourceNode]) {
      lastChild.replaceRight(aPattern, aReplacement);
    }
    else if (typeof lastChild === 'string') {
      this.children[this.children.length - 1] = lastChild.replace(aPattern, aReplacement);
    }
    else {
      this.children.push(''.replace(aPattern, aReplacement));
    }
    return this;
  };

  /**
   * Set the source content for a source file. This will be added to the SourceMapGenerator
   * in the sourcesContent field.
   *
   * @param aSourceFile The filename of the source file
   * @param aSourceContent The content of the source file
   */
  SourceNode$1.prototype.setSourceContent =
    function SourceNode_setSourceContent(aSourceFile, aSourceContent) {
      this.sourceContents[util.toSetString(aSourceFile)] = aSourceContent;
    };

  /**
   * Walk over the tree of SourceNodes. The walking function is called for each
   * source file content and is passed the filename and source content.
   *
   * @param aFn The traversal function.
   */
  SourceNode$1.prototype.walkSourceContents =
    function SourceNode_walkSourceContents(aFn) {
      for (var i = 0, len = this.children.length; i < len; i++) {
        if (this.children[i][isSourceNode]) {
          this.children[i].walkSourceContents(aFn);
        }
      }

      var sources = Object.keys(this.sourceContents);
      for (var i = 0, len = sources.length; i < len; i++) {
        aFn(util.fromSetString(sources[i]), this.sourceContents[sources[i]]);
      }
    };

  /**
   * Return the string representation of this source node. Walks over the tree
   * and concatenates all the various snippets together to one string.
   */
  SourceNode$1.prototype.toString = function SourceNode_toString() {
    var str = "";
    this.walk(function (chunk) {
      str += chunk;
    });
    return str;
  };

  /**
   * Returns the string representation of this source node along with a source
   * map.
   */
  SourceNode$1.prototype.toStringWithSourceMap = function SourceNode_toStringWithSourceMap(aArgs) {
    var generated = {
      code: "",
      line: 1,
      column: 0
    };
    var map = new SourceMapGenerator$1(aArgs);
    var sourceMappingActive = false;
    var lastOriginalSource = null;
    var lastOriginalLine = null;
    var lastOriginalColumn = null;
    var lastOriginalName = null;
    this.walk(function (chunk, original) {
      generated.code += chunk;
      if (original.source !== null
          && original.line !== null
          && original.column !== null) {
        if(lastOriginalSource !== original.source
           || lastOriginalLine !== original.line
           || lastOriginalColumn !== original.column
           || lastOriginalName !== original.name) {
          map.addMapping({
            source: original.source,
            original: {
              line: original.line,
              column: original.column
            },
            generated: {
              line: generated.line,
              column: generated.column
            },
            name: original.name
          });
        }
        lastOriginalSource = original.source;
        lastOriginalLine = original.line;
        lastOriginalColumn = original.column;
        lastOriginalName = original.name;
        sourceMappingActive = true;
      } else if (sourceMappingActive) {
        map.addMapping({
          generated: {
            line: generated.line,
            column: generated.column
          }
        });
        lastOriginalSource = null;
        sourceMappingActive = false;
      }
      for (var idx = 0, length = chunk.length; idx < length; idx++) {
        if (chunk.charCodeAt(idx) === NEWLINE_CODE) {
          generated.line++;
          generated.column = 0;
          // Mappings end at eol
          if (idx + 1 === length) {
            lastOriginalSource = null;
            sourceMappingActive = false;
          } else if (sourceMappingActive) {
            map.addMapping({
              source: original.source,
              original: {
                line: original.line,
                column: original.column
              },
              generated: {
                line: generated.line,
                column: generated.column
              },
              name: original.name
            });
          }
        } else {
          generated.column++;
        }
      }
    });
    this.walkSourceContents(function (sourceFile, sourceContent) {
      map.setSourceContent(sourceFile, sourceContent);
    });

    return { code: generated.code, map: map };
  };

  var SourceNode_1 = SourceNode$1;

  var sourceNode = {
  	SourceNode: SourceNode_1
  };

  /*
   * Copyright 2009-2011 Mozilla Foundation and contributors
   * Licensed under the New BSD license. See LICENSE.txt or:
   * http://opensource.org/licenses/BSD-3-Clause
   */

  var SourceMapGenerator = sourceMapGenerator.SourceMapGenerator;
  var SourceMapConsumer = sourceMapConsumer.SourceMapConsumer;
  var SourceNode = sourceNode.SourceNode;

  var sourceMap = {
  	SourceMapGenerator: SourceMapGenerator,
  	SourceMapConsumer: SourceMapConsumer,
  	SourceNode: SourceNode
  };

  var require$$1 = /*@__PURE__*/getAugmentedNamespace(path$1);

  let { dirname: dirname$1, resolve: resolve$2, relative, sep } = require$$1;
  let { pathToFileURL: pathToFileURL$1 } = url;


  class MapGenerator {
    constructor (stringify, root, opts) {
      this.stringify = stringify;
      this.mapOpts = opts.map || {};
      this.root = root;
      this.opts = opts;
    }

    isMap () {
      if (typeof this.opts.map !== 'undefined') {
        return !!this.opts.map
      }
      return this.previous().length > 0
    }

    previous () {
      if (!this.previousMaps) {
        this.previousMaps = [];
        this.root.walk(node => {
          if (node.source && node.source.input.map) {
            let map = node.source.input.map;
            if (!this.previousMaps.includes(map)) {
              this.previousMaps.push(map);
            }
          }
        });
      }

      return this.previousMaps
    }

    isInline () {
      if (typeof this.mapOpts.inline !== 'undefined') {
        return this.mapOpts.inline
      }

      let annotation = this.mapOpts.annotation;
      if (typeof annotation !== 'undefined' && annotation !== true) {
        return false
      }

      if (this.previous().length) {
        return this.previous().some(i => i.inline)
      }
      return true
    }

    isSourcesContent () {
      if (typeof this.mapOpts.sourcesContent !== 'undefined') {
        return this.mapOpts.sourcesContent
      }
      if (this.previous().length) {
        return this.previous().some(i => i.withContent())
      }
      return true
    }

    clearAnnotation () {
      if (this.mapOpts.annotation === false) return

      let node;
      for (let i = this.root.nodes.length - 1; i >= 0; i--) {
        node = this.root.nodes[i];
        if (node.type !== 'comment') continue
        if (node.text.indexOf('# sourceMappingURL=') === 0) {
          this.root.removeChild(i);
        }
      }
    }

    setSourcesContent () {
      let already = {};
      this.root.walk(node => {
        if (node.source) {
          let from = node.source.input.from;
          if (from && !already[from]) {
            already[from] = true;
            this.map.setSourceContent(
              this.toUrl(this.path(from)),
              node.source.input.css
            );
          }
        }
      });
    }

    applyPrevMaps () {
      for (let prev of this.previous()) {
        let from = this.toUrl(this.path(prev.file));
        let root = prev.root || dirname$1(prev.file);
        let map;

        if (this.mapOpts.sourcesContent === false) {
          map = new sourceMap.SourceMapConsumer(prev.text);
          if (map.sourcesContent) {
            map.sourcesContent = map.sourcesContent.map(() => null);
          }
        } else {
          map = prev.consumer();
        }

        this.map.applySourceMap(map, from, this.toUrl(this.path(root)));
      }
    }

    isAnnotation () {
      if (this.isInline()) {
        return true
      }
      if (typeof this.mapOpts.annotation !== 'undefined') {
        return this.mapOpts.annotation
      }
      if (this.previous().length) {
        return this.previous().some(i => i.annotation)
      }
      return true
    }

    toBase64 (str) {
      if (Buffer) {
        return Buffer.from(str).toString('base64')
      } else {
        // istanbul ignore next
        return window.btoa(unescape(encodeURIComponent(str)))
      }
    }

    addAnnotation () {
      let content;

      if (this.isInline()) {
        content =
          'data:application/json;base64,' + this.toBase64(this.map.toString());
      } else if (typeof this.mapOpts.annotation === 'string') {
        content = this.mapOpts.annotation;
      } else if (typeof this.mapOpts.annotation === 'function') {
        content = this.mapOpts.annotation(this.opts.to, this.root);
      } else {
        content = this.outputFile() + '.map';
      }

      let eol = '\n';
      if (this.css.includes('\r\n')) eol = '\r\n';

      this.css += eol + '/*# sourceMappingURL=' + content + ' */';
    }

    outputFile () {
      if (this.opts.to) {
        return this.path(this.opts.to)
      }
      if (this.opts.from) {
        return this.path(this.opts.from)
      }
      return 'to.css'
    }

    generateMap () {
      this.generateString();
      if (this.isSourcesContent()) this.setSourcesContent();
      if (this.previous().length > 0) this.applyPrevMaps();
      if (this.isAnnotation()) this.addAnnotation();

      if (this.isInline()) {
        return [this.css]
      }
      return [this.css, this.map]
    }

    path (file) {
      if (file.indexOf('<') === 0) return file
      if (/^\w+:\/\//.test(file)) return file
      if (this.mapOpts.absolute) return file

      let from = this.opts.to ? dirname$1(this.opts.to) : '.';

      if (typeof this.mapOpts.annotation === 'string') {
        from = dirname$1(resolve$2(from, this.mapOpts.annotation));
      }

      file = relative(from, file);
      return file
    }

    toUrl (path) {
      if (sep === '\\') {
        // istanbul ignore next
        path = path.replace(/\\/g, '/');
      }
      return encodeURI(path).replace(/[#?]/g, encodeURIComponent)
    }

    sourcePath (node) {
      if (this.mapOpts.from) {
        return this.toUrl(this.mapOpts.from)
      } else if (this.mapOpts.absolute) {
        return pathToFileURL$1(node.source.input.from).toString()
      } else {
        return this.toUrl(this.path(node.source.input.from))
      }
    }

    generateString () {
      this.css = '';
      this.map = new sourceMap.SourceMapGenerator({ file: this.outputFile() });

      let line = 1;
      let column = 1;

      let lines, last;
      this.stringify(this.root, (str, node, type) => {
        this.css += str;

        if (node && type !== 'end') {
          if (node.source && node.source.start) {
            this.map.addMapping({
              source: this.sourcePath(node),
              generated: { line, column: column - 1 },
              original: {
                line: node.source.start.line,
                column: node.source.start.column - 1
              }
            });
          } else {
            this.map.addMapping({
              source: '<no source>',
              original: { line: 1, column: 0 },
              generated: { line, column: column - 1 }
            });
          }
        }

        lines = str.match(/\n/g);
        if (lines) {
          line += lines.length;
          last = str.lastIndexOf('\n');
          column = str.length - last;
        } else {
          column += str.length;
        }

        if (node && type !== 'start') {
          let p = node.parent || { raws: {} };
          if (node.type !== 'decl' || node !== p.last || p.raws.semicolon) {
            if (node.source && node.source.end) {
              this.map.addMapping({
                source: this.sourcePath(node),
                generated: { line, column: column - 2 },
                original: {
                  line: node.source.end.line,
                  column: node.source.end.column - 1
                }
              });
            } else {
              this.map.addMapping({
                source: '<no source>',
                original: { line: 1, column: 0 },
                generated: { line, column: column - 1 }
              });
            }
          }
        }
      });
    }

    generate () {
      this.clearAnnotation();

      if (this.isMap()) {
        return this.generateMap()
      }

      let result = '';
      this.stringify(this.root, i => {
        result += i;
      });
      return [result]
    }
  }

  var mapGenerator = MapGenerator;

  let printed = {};

  var warnOnce = function warnOnce (message) {
    if (printed[message]) return
    printed[message] = true;

    if (typeof console !== 'undefined' && console.warn) {
      console.warn(message);
    }
  };

  class Warning {
    constructor (text, opts = {}) {
      this.type = 'warning';
      this.text = text;

      if (opts.node && opts.node.source) {
        let pos = opts.node.positionBy(opts);
        this.line = pos.line;
        this.column = pos.column;
      }

      for (let opt in opts) this[opt] = opts[opt];
    }

    toString () {
      if (this.node) {
        return this.node.error(this.text, {
          plugin: this.plugin,
          index: this.index,
          word: this.word
        }).message
      }

      if (this.plugin) {
        return this.plugin + ': ' + this.text
      }

      return this.text
    }
  }

  var warning = Warning;
  Warning.default = Warning;

  class Result {
    constructor (processor, root, opts) {
      this.processor = processor;
      this.messages = [];
      this.root = root;
      this.opts = opts;
      this.css = undefined;
      this.map = undefined;
    }

    toString () {
      return this.css
    }

    warn (text, opts = {}) {
      if (!opts.plugin) {
        if (this.lastPlugin && this.lastPlugin.postcssPlugin) {
          opts.plugin = this.lastPlugin.postcssPlugin;
        }
      }

      let warning$1 = new warning(text, opts);
      this.messages.push(warning$1);

      return warning$1
    }

    warnings () {
      return this.messages.filter(i => i.type === 'warning')
    }

    get content () {
      return this.css
    }
  }

  var result$1 = Result;
  Result.default = Result;

  class Comment extends node_1 {
    constructor (defaults) {
      super(defaults);
      this.type = 'comment';
    }
  }

  var comment = Comment;
  Comment.default = Comment;

  let { isClean: isClean$1 } = symbols;



  let parse$5, Rule$1, AtRule$2;

  function cleanSource (nodes) {
    return nodes.map(i => {
      if (i.nodes) i.nodes = cleanSource(i.nodes);
      delete i.source;
      return i
    })
  }

  function markDirtyUp (node) {
    node[isClean$1] = false;
    if (node.proxyOf.nodes) {
      for (let i of node.proxyOf.nodes) {
        markDirtyUp(i);
      }
    }
  }

  // istanbul ignore next
  function rebuild (node) {
    if (node.type === 'atrule') {
      Object.setPrototypeOf(node, AtRule$2.prototype);
    } else if (node.type === 'rule') {
      Object.setPrototypeOf(node, Rule$1.prototype);
    } else if (node.type === 'decl') {
      Object.setPrototypeOf(node, declaration$1.prototype);
    } else if (node.type === 'comment') {
      Object.setPrototypeOf(node, comment.prototype);
    }

    if (node.nodes) {
      node.nodes.forEach(child => {
        rebuild(child);
      });
    }
  }

  class Container extends node_1 {
    push (child) {
      child.parent = this;
      this.proxyOf.nodes.push(child);
      return this
    }

    each (callback) {
      if (!this.proxyOf.nodes) return undefined
      let iterator = this.getIterator();

      let index, result;
      while (this.indexes[iterator] < this.proxyOf.nodes.length) {
        index = this.indexes[iterator];
        result = callback(this.proxyOf.nodes[index], index);
        if (result === false) break

        this.indexes[iterator] += 1;
      }

      delete this.indexes[iterator];
      return result
    }

    walk (callback) {
      return this.each((child, i) => {
        let result;
        try {
          result = callback(child, i);
        } catch (e) {
          throw child.addToError(e)
        }
        if (result !== false && child.walk) {
          result = child.walk(callback);
        }

        return result
      })
    }

    walkDecls (prop, callback) {
      if (!callback) {
        callback = prop;
        return this.walk((child, i) => {
          if (child.type === 'decl') {
            return callback(child, i)
          }
        })
      }
      if (prop instanceof RegExp) {
        return this.walk((child, i) => {
          if (child.type === 'decl' && prop.test(child.prop)) {
            return callback(child, i)
          }
        })
      }
      return this.walk((child, i) => {
        if (child.type === 'decl' && child.prop === prop) {
          return callback(child, i)
        }
      })
    }

    walkRules (selector, callback) {
      if (!callback) {
        callback = selector;

        return this.walk((child, i) => {
          if (child.type === 'rule') {
            return callback(child, i)
          }
        })
      }
      if (selector instanceof RegExp) {
        return this.walk((child, i) => {
          if (child.type === 'rule' && selector.test(child.selector)) {
            return callback(child, i)
          }
        })
      }
      return this.walk((child, i) => {
        if (child.type === 'rule' && child.selector === selector) {
          return callback(child, i)
        }
      })
    }

    walkAtRules (name, callback) {
      if (!callback) {
        callback = name;
        return this.walk((child, i) => {
          if (child.type === 'atrule') {
            return callback(child, i)
          }
        })
      }
      if (name instanceof RegExp) {
        return this.walk((child, i) => {
          if (child.type === 'atrule' && name.test(child.name)) {
            return callback(child, i)
          }
        })
      }
      return this.walk((child, i) => {
        if (child.type === 'atrule' && child.name === name) {
          return callback(child, i)
        }
      })
    }

    walkComments (callback) {
      return this.walk((child, i) => {
        if (child.type === 'comment') {
          return callback(child, i)
        }
      })
    }

    append (...children) {
      for (let child of children) {
        let nodes = this.normalize(child, this.last);
        for (let node of nodes) this.proxyOf.nodes.push(node);
      }

      this.markDirty();

      return this
    }

    prepend (...children) {
      children = children.reverse();
      for (let child of children) {
        let nodes = this.normalize(child, this.first, 'prepend').reverse();
        for (let node of nodes) this.proxyOf.nodes.unshift(node);
        for (let id in this.indexes) {
          this.indexes[id] = this.indexes[id] + nodes.length;
        }
      }

      this.markDirty();

      return this
    }

    cleanRaws (keepBetween) {
      super.cleanRaws(keepBetween);
      if (this.nodes) {
        for (let node of this.nodes) node.cleanRaws(keepBetween);
      }
    }

    insertBefore (exist, add) {
      exist = this.index(exist);

      let type = exist === 0 ? 'prepend' : false;
      let nodes = this.normalize(add, this.proxyOf.nodes[exist], type).reverse();
      for (let node of nodes) this.proxyOf.nodes.splice(exist, 0, node);

      let index;
      for (let id in this.indexes) {
        index = this.indexes[id];
        if (exist <= index) {
          this.indexes[id] = index + nodes.length;
        }
      }

      this.markDirty();

      return this
    }

    insertAfter (exist, add) {
      exist = this.index(exist);

      let nodes = this.normalize(add, this.proxyOf.nodes[exist]).reverse();
      for (let node of nodes) this.proxyOf.nodes.splice(exist + 1, 0, node);

      let index;
      for (let id in this.indexes) {
        index = this.indexes[id];
        if (exist < index) {
          this.indexes[id] = index + nodes.length;
        }
      }

      this.markDirty();

      return this
    }

    removeChild (child) {
      child = this.index(child);
      this.proxyOf.nodes[child].parent = undefined;
      this.proxyOf.nodes.splice(child, 1);

      let index;
      for (let id in this.indexes) {
        index = this.indexes[id];
        if (index >= child) {
          this.indexes[id] = index - 1;
        }
      }

      this.markDirty();

      return this
    }

    removeAll () {
      for (let node of this.proxyOf.nodes) node.parent = undefined;
      this.proxyOf.nodes = [];

      this.markDirty();

      return this
    }

    replaceValues (pattern, opts, callback) {
      if (!callback) {
        callback = opts;
        opts = {};
      }

      this.walkDecls(decl => {
        if (opts.props && !opts.props.includes(decl.prop)) return
        if (opts.fast && !decl.value.includes(opts.fast)) return

        decl.value = decl.value.replace(pattern, callback);
      });

      this.markDirty();

      return this
    }

    every (condition) {
      return this.nodes.every(condition)
    }

    some (condition) {
      return this.nodes.some(condition)
    }

    index (child) {
      if (typeof child === 'number') return child
      if (child.proxyOf) child = child.proxyOf;
      return this.proxyOf.nodes.indexOf(child)
    }

    get first () {
      if (!this.proxyOf.nodes) return undefined
      return this.proxyOf.nodes[0]
    }

    get last () {
      if (!this.proxyOf.nodes) return undefined
      return this.proxyOf.nodes[this.proxyOf.nodes.length - 1]
    }

    normalize (nodes, sample) {
      if (typeof nodes === 'string') {
        nodes = cleanSource(parse$5(nodes).nodes);
      } else if (Array.isArray(nodes)) {
        nodes = nodes.slice(0);
        for (let i of nodes) {
          if (i.parent) i.parent.removeChild(i, 'ignore');
        }
      } else if (nodes.type === 'root') {
        nodes = nodes.nodes.slice(0);
        for (let i of nodes) {
          if (i.parent) i.parent.removeChild(i, 'ignore');
        }
      } else if (nodes.type) {
        nodes = [nodes];
      } else if (nodes.prop) {
        if (typeof nodes.value === 'undefined') {
          throw new Error('Value field is missed in node creation')
        } else if (typeof nodes.value !== 'string') {
          nodes.value = String(nodes.value);
        }
        nodes = [new declaration$1(nodes)];
      } else if (nodes.selector) {
        nodes = [new Rule$1(nodes)];
      } else if (nodes.name) {
        nodes = [new AtRule$2(nodes)];
      } else if (nodes.text) {
        nodes = [new comment(nodes)];
      } else {
        throw new Error('Unknown node type in node creation')
      }

      let processed = nodes.map(i => {
        // istanbul ignore next
        if (typeof i.markDirty !== 'function') rebuild(i);
        i = i.proxyOf;
        if (i.parent) i.parent.removeChild(i);
        if (i[isClean$1]) markDirtyUp(i);
        if (typeof i.raws.before === 'undefined') {
          if (sample && typeof sample.raws.before !== 'undefined') {
            i.raws.before = sample.raws.before.replace(/\S/g, '');
          }
        }
        i.parent = this;
        return i
      });

      return processed
    }

    getProxyProcessor () {
      return {
        set (node, prop, value) {
          if (node[prop] === value) return true
          node[prop] = value;
          if (prop === 'name' || prop === 'params' || prop === 'selector') {
            node.markDirty();
          }
          return true
        },

        get (node, prop) {
          if (prop === 'proxyOf') {
            return node
          } else if (!node[prop]) {
            return node[prop]
          } else if (
            prop === 'each' ||
            (typeof prop === 'string' && prop.startsWith('walk'))
          ) {
            return (...args) => {
              return node[prop](
                ...args.map(i => {
                  if (typeof i === 'function') {
                    return (child, index) => i(child.toProxy(), index)
                  } else {
                    return i
                  }
                })
              )
            }
          } else if (prop === 'every' || prop === 'some') {
            return cb => {
              return node[prop]((child, ...other) =>
                cb(child.toProxy(), ...other)
              )
            }
          } else if (prop === 'root') {
            return () => node.root().toProxy()
          } else if (prop === 'nodes') {
            return node.nodes.map(i => i.toProxy())
          } else if (prop === 'first' || prop === 'last') {
            return node[prop].toProxy()
          } else {
            return node[prop]
          }
        }
      }
    }

    getIterator () {
      if (!this.lastEach) this.lastEach = 0;
      if (!this.indexes) this.indexes = {};

      this.lastEach += 1;
      let iterator = this.lastEach;
      this.indexes[iterator] = 0;

      return iterator
    }
  }

  Container.registerParse = dependant => {
    parse$5 = dependant;
  };

  Container.registerRule = dependant => {
    Rule$1 = dependant;
  };

  Container.registerAtRule = dependant => {
    AtRule$2 = dependant;
  };

  var container = Container;
  Container.default = Container;

  const SINGLE_QUOTE = "'".charCodeAt(0);
  const DOUBLE_QUOTE = '"'.charCodeAt(0);
  const BACKSLASH = '\\'.charCodeAt(0);
  const SLASH = '/'.charCodeAt(0);
  const NEWLINE = '\n'.charCodeAt(0);
  const SPACE = ' '.charCodeAt(0);
  const FEED = '\f'.charCodeAt(0);
  const TAB = '\t'.charCodeAt(0);
  const CR = '\r'.charCodeAt(0);
  const OPEN_SQUARE = '['.charCodeAt(0);
  const CLOSE_SQUARE = ']'.charCodeAt(0);
  const OPEN_PARENTHESES = '('.charCodeAt(0);
  const CLOSE_PARENTHESES = ')'.charCodeAt(0);
  const OPEN_CURLY = '{'.charCodeAt(0);
  const CLOSE_CURLY = '}'.charCodeAt(0);
  const SEMICOLON = ';'.charCodeAt(0);
  const ASTERISK = '*'.charCodeAt(0);
  const COLON = ':'.charCodeAt(0);
  const AT = '@'.charCodeAt(0);

  const RE_AT_END = /[\t\n\f\r "#'()/;[\\\]{}]/g;
  const RE_WORD_END = /[\t\n\f\r !"#'():;@[\\\]{}]|\/(?=\*)/g;
  const RE_BAD_BRACKET = /.[\n"'(/\\]/;
  const RE_HEX_ESCAPE = /[\da-f]/i;

  var tokenize = function tokenizer (input, options = {}) {
    let css = input.css.valueOf();
    let ignore = options.ignoreErrors;

    let code, next, quote, content, escape;
    let escaped, escapePos, prev, n, currentToken;

    let length = css.length;
    let pos = 0;
    let buffer = [];
    let returned = [];

    function position () {
      return pos
    }

    function unclosed (what) {
      throw input.error('Unclosed ' + what, pos)
    }

    function endOfFile () {
      return returned.length === 0 && pos >= length
    }

    function nextToken (opts) {
      if (returned.length) return returned.pop()
      if (pos >= length) return

      let ignoreUnclosed = opts ? opts.ignoreUnclosed : false;

      code = css.charCodeAt(pos);

      switch (code) {
        case NEWLINE:
        case SPACE:
        case TAB:
        case CR:
        case FEED: {
          next = pos;
          do {
            next += 1;
            code = css.charCodeAt(next);
          } while (
            code === SPACE ||
            code === NEWLINE ||
            code === TAB ||
            code === CR ||
            code === FEED
          )

          currentToken = ['space', css.slice(pos, next)];
          pos = next - 1;
          break
        }

        case OPEN_SQUARE:
        case CLOSE_SQUARE:
        case OPEN_CURLY:
        case CLOSE_CURLY:
        case COLON:
        case SEMICOLON:
        case CLOSE_PARENTHESES: {
          let controlChar = String.fromCharCode(code);
          currentToken = [controlChar, controlChar, pos];
          break
        }

        case OPEN_PARENTHESES: {
          prev = buffer.length ? buffer.pop()[1] : '';
          n = css.charCodeAt(pos + 1);
          if (
            prev === 'url' &&
            n !== SINGLE_QUOTE &&
            n !== DOUBLE_QUOTE &&
            n !== SPACE &&
            n !== NEWLINE &&
            n !== TAB &&
            n !== FEED &&
            n !== CR
          ) {
            next = pos;
            do {
              escaped = false;
              next = css.indexOf(')', next + 1);
              if (next === -1) {
                if (ignore || ignoreUnclosed) {
                  next = pos;
                  break
                } else {
                  unclosed('bracket');
                }
              }
              escapePos = next;
              while (css.charCodeAt(escapePos - 1) === BACKSLASH) {
                escapePos -= 1;
                escaped = !escaped;
              }
            } while (escaped)

            currentToken = ['brackets', css.slice(pos, next + 1), pos, next];

            pos = next;
          } else {
            next = css.indexOf(')', pos + 1);
            content = css.slice(pos, next + 1);

            if (next === -1 || RE_BAD_BRACKET.test(content)) {
              currentToken = ['(', '(', pos];
            } else {
              currentToken = ['brackets', content, pos, next];
              pos = next;
            }
          }

          break
        }

        case SINGLE_QUOTE:
        case DOUBLE_QUOTE: {
          quote = code === SINGLE_QUOTE ? "'" : '"';
          next = pos;
          do {
            escaped = false;
            next = css.indexOf(quote, next + 1);
            if (next === -1) {
              if (ignore || ignoreUnclosed) {
                next = pos + 1;
                break
              } else {
                unclosed('string');
              }
            }
            escapePos = next;
            while (css.charCodeAt(escapePos - 1) === BACKSLASH) {
              escapePos -= 1;
              escaped = !escaped;
            }
          } while (escaped)

          currentToken = ['string', css.slice(pos, next + 1), pos, next];
          pos = next;
          break
        }

        case AT: {
          RE_AT_END.lastIndex = pos + 1;
          RE_AT_END.test(css);
          if (RE_AT_END.lastIndex === 0) {
            next = css.length - 1;
          } else {
            next = RE_AT_END.lastIndex - 2;
          }

          currentToken = ['at-word', css.slice(pos, next + 1), pos, next];

          pos = next;
          break
        }

        case BACKSLASH: {
          next = pos;
          escape = true;
          while (css.charCodeAt(next + 1) === BACKSLASH) {
            next += 1;
            escape = !escape;
          }
          code = css.charCodeAt(next + 1);
          if (
            escape &&
            code !== SLASH &&
            code !== SPACE &&
            code !== NEWLINE &&
            code !== TAB &&
            code !== CR &&
            code !== FEED
          ) {
            next += 1;
            if (RE_HEX_ESCAPE.test(css.charAt(next))) {
              while (RE_HEX_ESCAPE.test(css.charAt(next + 1))) {
                next += 1;
              }
              if (css.charCodeAt(next + 1) === SPACE) {
                next += 1;
              }
            }
          }

          currentToken = ['word', css.slice(pos, next + 1), pos, next];

          pos = next;
          break
        }

        default: {
          if (code === SLASH && css.charCodeAt(pos + 1) === ASTERISK) {
            next = css.indexOf('*/', pos + 2) + 1;
            if (next === 0) {
              if (ignore || ignoreUnclosed) {
                next = css.length;
              } else {
                unclosed('comment');
              }
            }

            currentToken = ['comment', css.slice(pos, next + 1), pos, next];
            pos = next;
          } else {
            RE_WORD_END.lastIndex = pos + 1;
            RE_WORD_END.test(css);
            if (RE_WORD_END.lastIndex === 0) {
              next = css.length - 1;
            } else {
              next = RE_WORD_END.lastIndex - 2;
            }

            currentToken = ['word', css.slice(pos, next + 1), pos, next];
            buffer.push(currentToken);
            pos = next;
          }

          break
        }
      }

      pos++;
      return currentToken
    }

    function back (token) {
      returned.push(token);
    }

    return {
      back,
      nextToken,
      endOfFile,
      position
    }
  };

  class AtRule$1 extends container {
    constructor (defaults) {
      super(defaults);
      this.type = 'atrule';
    }

    append (...children) {
      if (!this.proxyOf.nodes) this.nodes = [];
      return super.append(...children)
    }

    prepend (...children) {
      if (!this.proxyOf.nodes) this.nodes = [];
      return super.prepend(...children)
    }
  }

  var atRule$1 = AtRule$1;
  AtRule$1.default = AtRule$1;

  container.registerAtRule(AtRule$1);

  let LazyResult$1, Processor$2;

  class Root extends container {
    constructor (defaults) {
      super(defaults);
      this.type = 'root';
      if (!this.nodes) this.nodes = [];
    }

    removeChild (child, ignore) {
      let index = this.index(child);

      if (!ignore && index === 0 && this.nodes.length > 1) {
        this.nodes[1].raws.before = this.nodes[index].raws.before;
      }

      return super.removeChild(child)
    }

    normalize (child, sample, type) {
      let nodes = super.normalize(child);

      if (sample) {
        if (type === 'prepend') {
          if (this.nodes.length > 1) {
            sample.raws.before = this.nodes[1].raws.before;
          } else {
            delete sample.raws.before;
          }
        } else if (this.first !== sample) {
          for (let node of nodes) {
            node.raws.before = sample.raws.before;
          }
        }
      }

      return nodes
    }

    toResult (opts = {}) {
      let lazy = new LazyResult$1(new Processor$2(), this, opts);
      return lazy.stringify()
    }
  }

  Root.registerLazyResult = dependant => {
    LazyResult$1 = dependant;
  };

  Root.registerProcessor = dependant => {
    Processor$2 = dependant;
  };

  var root = Root;
  Root.default = Root;

  let list$6 = {
    split (string, separators, last) {
      let array = [];
      let current = '';
      let split = false;

      let func = 0;
      let quote = false;
      let escape = false;

      for (let letter of string) {
        if (quote) {
          if (escape) {
            escape = false;
          } else if (letter === '\\') {
            escape = true;
          } else if (letter === quote) {
            quote = false;
          }
        } else if (letter === '"' || letter === "'") {
          quote = letter;
        } else if (letter === '(') {
          func += 1;
        } else if (letter === ')') {
          if (func > 0) func -= 1;
        } else if (func === 0) {
          if (separators.includes(letter)) split = true;
        }

        if (split) {
          if (current !== '') array.push(current.trim());
          current = '';
          split = false;
        } else {
          current += letter;
        }
      }

      if (last || current !== '') array.push(current.trim());
      return array
    },

    space (string) {
      let spaces = [' ', '\n', '\t'];
      return list$6.split(string, spaces)
    },

    comma (string) {
      return list$6.split(string, [','], true)
    }
  };

  var list_1 = list$6;
  list$6.default = list$6;

  class Rule extends container {
    constructor (defaults) {
      super(defaults);
      this.type = 'rule';
      if (!this.nodes) this.nodes = [];
    }

    get selectors () {
      return list_1.comma(this.selector)
    }

    set selectors (values) {
      let match = this.selector ? this.selector.match(/,\s*/) : null;
      let sep = match ? match[0] : ',' + this.raw('between', 'beforeOpen');
      this.selector = values.join(sep);
    }
  }

  var rule = Rule;
  Rule.default = Rule;

  container.registerRule(Rule);

  class Parser {
    constructor (input) {
      this.input = input;

      this.root = new root();
      this.current = this.root;
      this.spaces = '';
      this.semicolon = false;
      this.customProperty = false;

      this.createTokenizer();
      this.root.source = { input, start: { offset: 0, line: 1, column: 1 } };
    }

    createTokenizer () {
      this.tokenizer = tokenize(this.input);
    }

    parse () {
      let token;
      while (!this.tokenizer.endOfFile()) {
        token = this.tokenizer.nextToken();

        switch (token[0]) {
          case 'space':
            this.spaces += token[1];
            break

          case ';':
            this.freeSemicolon(token);
            break

          case '}':
            this.end(token);
            break

          case 'comment':
            this.comment(token);
            break

          case 'at-word':
            this.atrule(token);
            break

          case '{':
            this.emptyRule(token);
            break

          default:
            this.other(token);
            break
        }
      }
      this.endFile();
    }

    comment (token) {
      let node = new comment();
      this.init(node, token[2]);
      node.source.end = this.getPosition(token[3] || token[2]);

      let text = token[1].slice(2, -2);
      if (/^\s*$/.test(text)) {
        node.text = '';
        node.raws.left = text;
        node.raws.right = '';
      } else {
        let match = text.match(/^(\s*)([^]*\S)(\s*)$/);
        node.text = match[2];
        node.raws.left = match[1];
        node.raws.right = match[3];
      }
    }

    emptyRule (token) {
      let node = new rule();
      this.init(node, token[2]);
      node.selector = '';
      node.raws.between = '';
      this.current = node;
    }

    other (start) {
      let end = false;
      let type = null;
      let colon = false;
      let bracket = null;
      let brackets = [];
      let customProperty = start[1].startsWith('--');

      let tokens = [];
      let token = start;
      while (token) {
        type = token[0];
        tokens.push(token);

        if (type === '(' || type === '[') {
          if (!bracket) bracket = token;
          brackets.push(type === '(' ? ')' : ']');
        } else if (customProperty && colon && type === '{') {
          if (!bracket) bracket = token;
          brackets.push('}');
        } else if (brackets.length === 0) {
          if (type === ';') {
            if (colon) {
              this.decl(tokens, customProperty);
              return
            } else {
              break
            }
          } else if (type === '{') {
            this.rule(tokens);
            return
          } else if (type === '}') {
            this.tokenizer.back(tokens.pop());
            end = true;
            break
          } else if (type === ':') {
            colon = true;
          }
        } else if (type === brackets[brackets.length - 1]) {
          brackets.pop();
          if (brackets.length === 0) bracket = null;
        }

        token = this.tokenizer.nextToken();
      }

      if (this.tokenizer.endOfFile()) end = true;
      if (brackets.length > 0) this.unclosedBracket(bracket);

      if (end && colon) {
        while (tokens.length) {
          token = tokens[tokens.length - 1][0];
          if (token !== 'space' && token !== 'comment') break
          this.tokenizer.back(tokens.pop());
        }
        this.decl(tokens, customProperty);
      } else {
        this.unknownWord(tokens);
      }
    }

    rule (tokens) {
      tokens.pop();

      let node = new rule();
      this.init(node, tokens[0][2]);

      node.raws.between = this.spacesAndCommentsFromEnd(tokens);
      this.raw(node, 'selector', tokens);
      this.current = node;
    }

    decl (tokens, customProperty) {
      let node = new declaration$1();
      this.init(node, tokens[0][2]);

      let last = tokens[tokens.length - 1];
      if (last[0] === ';') {
        this.semicolon = true;
        tokens.pop();
      }
      node.source.end = this.getPosition(last[3] || last[2]);

      while (tokens[0][0] !== 'word') {
        if (tokens.length === 1) this.unknownWord(tokens);
        node.raws.before += tokens.shift()[1];
      }
      node.source.start = this.getPosition(tokens[0][2]);

      node.prop = '';
      while (tokens.length) {
        let type = tokens[0][0];
        if (type === ':' || type === 'space' || type === 'comment') {
          break
        }
        node.prop += tokens.shift()[1];
      }

      node.raws.between = '';

      let token;
      while (tokens.length) {
        token = tokens.shift();

        if (token[0] === ':') {
          node.raws.between += token[1];
          break
        } else {
          if (token[0] === 'word' && /\w/.test(token[1])) {
            this.unknownWord([token]);
          }
          node.raws.between += token[1];
        }
      }

      if (node.prop[0] === '_' || node.prop[0] === '*') {
        node.raws.before += node.prop[0];
        node.prop = node.prop.slice(1);
      }
      let firstSpaces = this.spacesAndCommentsFromStart(tokens);
      this.precheckMissedSemicolon(tokens);

      for (let i = tokens.length - 1; i >= 0; i--) {
        token = tokens[i];
        if (token[1].toLowerCase() === '!important') {
          node.important = true;
          let string = this.stringFrom(tokens, i);
          string = this.spacesFromEnd(tokens) + string;
          if (string !== ' !important') node.raws.important = string;
          break
        } else if (token[1].toLowerCase() === 'important') {
          let cache = tokens.slice(0);
          let str = '';
          for (let j = i; j > 0; j--) {
            let type = cache[j][0];
            if (str.trim().indexOf('!') === 0 && type !== 'space') {
              break
            }
            str = cache.pop()[1] + str;
          }
          if (str.trim().indexOf('!') === 0) {
            node.important = true;
            node.raws.important = str;
            tokens = cache;
          }
        }

        if (token[0] !== 'space' && token[0] !== 'comment') {
          break
        }
      }

      let hasWord = tokens.some(i => i[0] !== 'space' && i[0] !== 'comment');
      this.raw(node, 'value', tokens);
      if (hasWord) {
        node.raws.between += firstSpaces;
      } else {
        node.value = firstSpaces + node.value;
      }

      if (node.value.includes(':') && !customProperty) {
        this.checkMissedSemicolon(tokens);
      }
    }

    atrule (token) {
      let node = new atRule$1();
      node.name = token[1].slice(1);
      if (node.name === '') {
        this.unnamedAtrule(node, token);
      }
      this.init(node, token[2]);

      let type;
      let prev;
      let shift;
      let last = false;
      let open = false;
      let params = [];
      let brackets = [];

      while (!this.tokenizer.endOfFile()) {
        token = this.tokenizer.nextToken();
        type = token[0];

        if (type === '(' || type === '[') {
          brackets.push(type === '(' ? ')' : ']');
        } else if (type === '{' && brackets.length > 0) {
          brackets.push('}');
        } else if (type === brackets[brackets.length - 1]) {
          brackets.pop();
        }

        if (brackets.length === 0) {
          if (type === ';') {
            node.source.end = this.getPosition(token[2]);
            this.semicolon = true;
            break
          } else if (type === '{') {
            open = true;
            break
          } else if (type === '}') {
            if (params.length > 0) {
              shift = params.length - 1;
              prev = params[shift];
              while (prev && prev[0] === 'space') {
                prev = params[--shift];
              }
              if (prev) {
                node.source.end = this.getPosition(prev[3] || prev[2]);
              }
            }
            this.end(token);
            break
          } else {
            params.push(token);
          }
        } else {
          params.push(token);
        }

        if (this.tokenizer.endOfFile()) {
          last = true;
          break
        }
      }

      node.raws.between = this.spacesAndCommentsFromEnd(params);
      if (params.length) {
        node.raws.afterName = this.spacesAndCommentsFromStart(params);
        this.raw(node, 'params', params);
        if (last) {
          token = params[params.length - 1];
          node.source.end = this.getPosition(token[3] || token[2]);
          this.spaces = node.raws.between;
          node.raws.between = '';
        }
      } else {
        node.raws.afterName = '';
        node.params = '';
      }

      if (open) {
        node.nodes = [];
        this.current = node;
      }
    }

    end (token) {
      if (this.current.nodes && this.current.nodes.length) {
        this.current.raws.semicolon = this.semicolon;
      }
      this.semicolon = false;

      this.current.raws.after = (this.current.raws.after || '') + this.spaces;
      this.spaces = '';

      if (this.current.parent) {
        this.current.source.end = this.getPosition(token[2]);
        this.current = this.current.parent;
      } else {
        this.unexpectedClose(token);
      }
    }

    endFile () {
      if (this.current.parent) this.unclosedBlock();
      if (this.current.nodes && this.current.nodes.length) {
        this.current.raws.semicolon = this.semicolon;
      }
      this.current.raws.after = (this.current.raws.after || '') + this.spaces;
    }

    freeSemicolon (token) {
      this.spaces += token[1];
      if (this.current.nodes) {
        let prev = this.current.nodes[this.current.nodes.length - 1];
        if (prev && prev.type === 'rule' && !prev.raws.ownSemicolon) {
          prev.raws.ownSemicolon = this.spaces;
          this.spaces = '';
        }
      }
    }

    // Helpers

    getPosition (offset) {
      let pos = this.input.fromOffset(offset);
      return {
        offset,
        line: pos.line,
        column: pos.col
      }
    }

    init (node, offset) {
      this.current.push(node);
      node.source = {
        start: this.getPosition(offset),
        input: this.input
      };
      node.raws.before = this.spaces;
      this.spaces = '';
      if (node.type !== 'comment') this.semicolon = false;
    }

    raw (node, prop, tokens) {
      let token, type;
      let length = tokens.length;
      let value = '';
      let clean = true;
      let next, prev;
      let pattern = /^([#.|])?(\w)+/i;

      for (let i = 0; i < length; i += 1) {
        token = tokens[i];
        type = token[0];

        if (type === 'comment' && node.type === 'rule') {
          prev = tokens[i - 1];
          next = tokens[i + 1];

          if (
            prev[0] !== 'space' &&
            next[0] !== 'space' &&
            pattern.test(prev[1]) &&
            pattern.test(next[1])
          ) {
            value += token[1];
          } else {
            clean = false;
          }

          continue
        }

        if (type === 'comment' || (type === 'space' && i === length - 1)) {
          clean = false;
        } else {
          value += token[1];
        }
      }
      if (!clean) {
        let raw = tokens.reduce((all, i) => all + i[1], '');
        node.raws[prop] = { value, raw };
      }
      node[prop] = value;
    }

    spacesAndCommentsFromEnd (tokens) {
      let lastTokenType;
      let spaces = '';
      while (tokens.length) {
        lastTokenType = tokens[tokens.length - 1][0];
        if (lastTokenType !== 'space' && lastTokenType !== 'comment') break
        spaces = tokens.pop()[1] + spaces;
      }
      return spaces
    }

    spacesAndCommentsFromStart (tokens) {
      let next;
      let spaces = '';
      while (tokens.length) {
        next = tokens[0][0];
        if (next !== 'space' && next !== 'comment') break
        spaces += tokens.shift()[1];
      }
      return spaces
    }

    spacesFromEnd (tokens) {
      let lastTokenType;
      let spaces = '';
      while (tokens.length) {
        lastTokenType = tokens[tokens.length - 1][0];
        if (lastTokenType !== 'space') break
        spaces = tokens.pop()[1] + spaces;
      }
      return spaces
    }

    stringFrom (tokens, from) {
      let result = '';
      for (let i = from; i < tokens.length; i++) {
        result += tokens[i][1];
      }
      tokens.splice(from, tokens.length - from);
      return result
    }

    colon (tokens) {
      let brackets = 0;
      let token, type, prev;
      for (let [i, element] of tokens.entries()) {
        token = element;
        type = token[0];

        if (type === '(') {
          brackets += 1;
        }
        if (type === ')') {
          brackets -= 1;
        }
        if (brackets === 0 && type === ':') {
          if (!prev) {
            this.doubleColon(token);
          } else if (prev[0] === 'word' && prev[1] === 'progid') {
            continue
          } else {
            return i
          }
        }

        prev = token;
      }
      return false
    }

    // Errors

    unclosedBracket (bracket) {
      throw this.input.error('Unclosed bracket', bracket[2])
    }

    unknownWord (tokens) {
      throw this.input.error('Unknown word', tokens[0][2])
    }

    unexpectedClose (token) {
      throw this.input.error('Unexpected }', token[2])
    }

    unclosedBlock () {
      let pos = this.current.source.start;
      throw this.input.error('Unclosed block', pos.line, pos.column)
    }

    doubleColon (token) {
      throw this.input.error('Double colon', token[2])
    }

    unnamedAtrule (node, token) {
      throw this.input.error('At-rule without name', token[2])
    }

    precheckMissedSemicolon (/* tokens */) {
      // Hook for Safe Parser
    }

    checkMissedSemicolon (tokens) {
      let colon = this.colon(tokens);
      if (colon === false) return

      let founded = 0;
      let token;
      for (let j = colon - 1; j >= 0; j--) {
        token = tokens[j];
        if (token[0] !== 'space') {
          founded += 1;
          if (founded === 2) break
        }
      }
      throw this.input.error('Missed semicolon', token[2])
    }
  }

  var parser = Parser;

  var lib$1 = createCommonjsModule(function (module, exports) {

  function makeException(ErrorType, message, opts = {}) {
      if (opts.globals) {
          ErrorType = opts.globals[ErrorType.name];
      }
      return new ErrorType(`${opts.context ? opts.context : "Value"} ${message}.`);
  }

  function toNumber(value, opts = {}) {
      if (!opts.globals) {
          return +value;
      }
      if (typeof value === "bigint") {
          throw opts.globals.TypeError("Cannot convert a BigInt value to a number");
      }
      return opts.globals.Number(value);
  }

  function type(V) {
      if (V === null) {
          return "Null";
      }
      switch (typeof V) {
          case "undefined":
              return "Undefined";
          case "boolean":
              return "Boolean";
          case "number":
              return "Number";
          case "string":
              return "String";
          case "symbol":
              return "Symbol";
          case "bigint":
              return "BigInt";
          case "object":
              // Falls through
          case "function":
              // Falls through
          default:
              // Per ES spec, typeof returns an implemention-defined value that is not any of the existing ones for
              // uncallable non-standard exotic objects. Yet Type() which the Web IDL spec depends on returns Object for
              // such cases. So treat the default case as an object.
              return "Object";
      }
  }

  // Round x to the nearest integer, choosing the even integer if it lies halfway between two.
  function evenRound(x) {
      // There are four cases for numbers with fractional part being .5:
      //
      // case |     x     | floor(x) | round(x) | expected | x <> 0 | x % 1 | x & 1 |   example
      //   1  |  2n + 0.5 |  2n      |  2n + 1  |  2n      |   >    |  0.5  |   0   |  0.5 ->  0
      //   2  |  2n + 1.5 |  2n + 1  |  2n + 2  |  2n + 2  |   >    |  0.5  |   1   |  1.5 ->  2
      //   3  | -2n - 0.5 | -2n - 1  | -2n      | -2n      |   <    | -0.5  |   0   | -0.5 ->  0
      //   4  | -2n - 1.5 | -2n - 2  | -2n - 1  | -2n - 2  |   <    | -0.5  |   1   | -1.5 -> -2
      // (where n is a non-negative integer)
      //
      // Branch here for cases 1 and 4
      if ((x > 0 && (x % 1) === +0.5 && (x & 1) === 0) ||
          (x < 0 && (x % 1) === -0.5 && (x & 1) === 1)) {
          return censorNegativeZero(Math.floor(x));
      }

      return censorNegativeZero(Math.round(x));
  }

  function integerPart(n) {
      return censorNegativeZero(Math.trunc(n));
  }

  function sign(x) {
      return x < 0 ? -1 : 1;
  }

  function modulo(x, y) {
      // https://tc39.github.io/ecma262/#eqn-modulo
      // Note that http://stackoverflow.com/a/4467559/3191 does NOT work for large modulos
      const signMightNotMatch = x % y;
      if (sign(y) !== sign(signMightNotMatch)) {
          return signMightNotMatch + y;
      }
      return signMightNotMatch;
  }

  function censorNegativeZero(x) {
      return x === 0 ? 0 : x;
  }

  function createIntegerConversion(bitLength, typeOpts) {
      const isSigned = !typeOpts.unsigned;

      let lowerBound;
      let upperBound;
      if (bitLength === 64) {
          upperBound = Number.MAX_SAFE_INTEGER;
          lowerBound = !isSigned ? 0 : Number.MIN_SAFE_INTEGER;
      } else if (!isSigned) {
          lowerBound = 0;
          upperBound = Math.pow(2, bitLength) - 1;
      } else {
          lowerBound = -Math.pow(2, bitLength - 1);
          upperBound = Math.pow(2, bitLength - 1) - 1;
      }

      const twoToTheBitLength = Math.pow(2, bitLength);
      const twoToOneLessThanTheBitLength = Math.pow(2, bitLength - 1);

      return (V, opts = {}) => {
          let x = toNumber(V, opts);
          x = censorNegativeZero(x);

          if (opts.enforceRange) {
              if (!Number.isFinite(x)) {
                  throw makeException(TypeError, "is not a finite number", opts);
              }

              x = integerPart(x);

              if (x < lowerBound || x > upperBound) {
                  throw makeException(TypeError,
                      `is outside the accepted range of ${lowerBound} to ${upperBound}, inclusive`, opts);
              }

              return x;
          }

          if (!Number.isNaN(x) && opts.clamp) {
              x = Math.min(Math.max(x, lowerBound), upperBound);
              x = evenRound(x);
              return x;
          }

          if (!Number.isFinite(x) || x === 0) {
              return 0;
          }
          x = integerPart(x);

          // Math.pow(2, 64) is not accurately representable in JavaScript, so try to avoid these per-spec operations if
          // possible. Hopefully it's an optimization for the non-64-bitLength cases too.
          if (x >= lowerBound && x <= upperBound) {
              return x;
          }

          // These will not work great for bitLength of 64, but oh well. See the README for more details.
          x = modulo(x, twoToTheBitLength);
          if (isSigned && x >= twoToOneLessThanTheBitLength) {
              return x - twoToTheBitLength;
          }
          return x;
      };
  }

  function createLongLongConversion(bitLength, { unsigned }) {
      const upperBound = Number.MAX_SAFE_INTEGER;
      const lowerBound = unsigned ? 0 : Number.MIN_SAFE_INTEGER;
      const asBigIntN = unsigned ? BigInt.asUintN : BigInt.asIntN;

      return (V, opts = {}) => {
          if (opts === undefined) {
              opts = {};
          }

          let x = toNumber(V, opts);
          x = censorNegativeZero(x);

          if (opts.enforceRange) {
              if (!Number.isFinite(x)) {
                  throw makeException(TypeError, "is not a finite number", opts);
              }

              x = integerPart(x);

              if (x < lowerBound || x > upperBound) {
                  throw makeException(TypeError,
                      `is outside the accepted range of ${lowerBound} to ${upperBound}, inclusive`, opts);
              }

              return x;
          }

          if (!Number.isNaN(x) && opts.clamp) {
              x = Math.min(Math.max(x, lowerBound), upperBound);
              x = evenRound(x);
              return x;
          }

          if (!Number.isFinite(x) || x === 0) {
              return 0;
          }

          let xBigInt = BigInt(integerPart(x));
          xBigInt = asBigIntN(bitLength, xBigInt);
          return Number(xBigInt);
      };
  }

  exports.any = V => {
      return V;
  };

  exports.void = function () {
      return undefined;
  };

  exports.boolean = function (val) {
      return !!val;
  };

  exports.byte = createIntegerConversion(8, { unsigned: false });
  exports.octet = createIntegerConversion(8, { unsigned: true });

  exports.short = createIntegerConversion(16, { unsigned: false });
  exports["unsigned short"] = createIntegerConversion(16, { unsigned: true });

  exports.long = createIntegerConversion(32, { unsigned: false });
  exports["unsigned long"] = createIntegerConversion(32, { unsigned: true });

  exports["long long"] = createLongLongConversion(64, { unsigned: false });
  exports["unsigned long long"] = createLongLongConversion(64, { unsigned: true });

  exports.double = (V, opts) => {
      const x = toNumber(V, opts);

      if (!Number.isFinite(x)) {
          throw makeException(TypeError, "is not a finite floating-point value", opts);
      }

      return x;
  };

  exports["unrestricted double"] = (V, opts) => {
      const x = toNumber(V, opts);

      return x;
  };

  exports.float = (V, opts) => {
      const x = toNumber(V, opts);

      if (!Number.isFinite(x)) {
          throw makeException(TypeError, "is not a finite floating-point value", opts);
      }

      if (Object.is(x, -0)) {
          return x;
      }

      const y = Math.fround(x);

      if (!Number.isFinite(y)) {
          throw makeException(TypeError, "is outside the range of a single-precision floating-point value", opts);
      }

      return y;
  };

  exports["unrestricted float"] = (V, opts) => {
      const x = toNumber(V, opts);

      if (isNaN(x)) {
          return x;
      }

      if (Object.is(x, -0)) {
          return x;
      }

      return Math.fround(x);
  };

  exports.DOMString = function (V, opts = {}) {
      if (opts.treatNullAsEmptyString && V === null) {
          return "";
      }

      if (typeof V === "symbol") {
          throw makeException(TypeError, "is a symbol, which cannot be converted to a string", opts);
      }

      const StringCtor = opts.globals ? opts.globals.String : String;
      return StringCtor(V);
  };

  exports.ByteString = (V, opts) => {
      const x = exports.DOMString(V, opts);
      let c;
      for (let i = 0; (c = x.codePointAt(i)) !== undefined; ++i) {
          if (c > 255) {
              throw makeException(TypeError, "is not a valid ByteString", opts);
          }
      }

      return x;
  };

  exports.USVString = (V, opts) => {
      const S = exports.DOMString(V, opts);
      const n = S.length;
      const U = [];
      for (let i = 0; i < n; ++i) {
          const c = S.charCodeAt(i);
          if (c < 0xD800 || c > 0xDFFF) {
              U.push(String.fromCodePoint(c));
          } else if (0xDC00 <= c && c <= 0xDFFF) {
              U.push(String.fromCodePoint(0xFFFD));
          } else if (i === n - 1) {
              U.push(String.fromCodePoint(0xFFFD));
          } else {
              const d = S.charCodeAt(i + 1);
              if (0xDC00 <= d && d <= 0xDFFF) {
                  const a = c & 0x3FF;
                  const b = d & 0x3FF;
                  U.push(String.fromCodePoint((2 << 15) + ((2 << 9) * a) + b));
                  ++i;
              } else {
                  U.push(String.fromCodePoint(0xFFFD));
              }
          }
      }

      return U.join("");
  };

  exports.object = (V, opts) => {
      if (type(V) !== "Object") {
          throw makeException(TypeError, "is not an object", opts);
      }

      return V;
  };

  // Not exported, but used in Function and VoidFunction.

  // Neither Function nor VoidFunction is defined with [TreatNonObjectAsNull], so
  // handling for that is omitted.
  function convertCallbackFunction(V, opts) {
      if (typeof V !== "function") {
          throw makeException(TypeError, "is not a function", opts);
      }
      return V;
  }

  const abByteLengthGetter =
      Object.getOwnPropertyDescriptor(ArrayBuffer.prototype, "byteLength").get;
  const sabByteLengthGetter =
      Object.getOwnPropertyDescriptor(SharedArrayBuffer.prototype, "byteLength").get;

  function isNonSharedArrayBuffer(V) {
      try {
          // This will throw on SharedArrayBuffers, but not detached ArrayBuffers.
          // (The spec says it should throw, but the spec conflicts with implementations: https://github.com/tc39/ecma262/issues/678)
          abByteLengthGetter.call(V);

          return true;
      } catch {
          return false;
      }
  }

  function isSharedArrayBuffer(V) {
      try {
          sabByteLengthGetter.call(V);
          return true;
      } catch {
          return false;
      }
  }

  function isArrayBufferDetached(V) {
      try {
          // eslint-disable-next-line no-new
          new Uint8Array(V);
          return false;
      } catch {
          return true;
      }
  }

  exports.ArrayBuffer = (V, opts = {}) => {
      if (!isNonSharedArrayBuffer(V)) {
          if (opts.allowShared && !isSharedArrayBuffer(V)) {
              throw makeException(TypeError, "is not an ArrayBuffer or SharedArrayBuffer", opts);
          }
          throw makeException(TypeError, "is not an ArrayBuffer", opts);
      }
      if (isArrayBufferDetached(V)) {
          throw makeException(TypeError, "is a detached ArrayBuffer", opts);
      }

      return V;
  };

  const dvByteLengthGetter =
      Object.getOwnPropertyDescriptor(DataView.prototype, "byteLength").get;
  exports.DataView = (V, opts = {}) => {
      try {
          dvByteLengthGetter.call(V);
      } catch (e) {
          throw makeException(TypeError, "is not a DataView", opts);
      }

      if (!opts.allowShared && isSharedArrayBuffer(V.buffer)) {
          throw makeException(TypeError, "is backed by a SharedArrayBuffer, which is not allowed", opts);
      }
      if (isArrayBufferDetached(V.buffer)) {
          throw makeException(TypeError, "is backed by a detached ArrayBuffer", opts);
      }

      return V;
  };

  // Returns the unforgeable `TypedArray` constructor name or `undefined`,
  // if the `this` value isn't a valid `TypedArray` object.
  //
  // https://tc39.es/ecma262/#sec-get-%typedarray%.prototype-@@tostringtag
  const typedArrayNameGetter = Object.getOwnPropertyDescriptor(
      Object.getPrototypeOf(Uint8Array).prototype,
      Symbol.toStringTag
  ).get;
  [
      Int8Array, Int16Array, Int32Array, Uint8Array,
      Uint16Array, Uint32Array, Uint8ClampedArray, Float32Array, Float64Array
  ].forEach(func => {
      const name = func.name;
      const article = /^[AEIOU]/.test(name) ? "an" : "a";
      exports[name] = (V, opts = {}) => {
          if (!ArrayBuffer.isView(V) || typedArrayNameGetter.call(V) !== name) {
              throw makeException(TypeError, `is not ${article} ${name} object`, opts);
          }
          if (!opts.allowShared && isSharedArrayBuffer(V.buffer)) {
              throw makeException(TypeError, "is a view on a SharedArrayBuffer, which is not allowed", opts);
          }
          if (isArrayBufferDetached(V.buffer)) {
              throw makeException(TypeError, "is a view on a detached ArrayBuffer", opts);
          }

          return V;
      };
  });

  // Common definitions

  exports.ArrayBufferView = (V, opts = {}) => {
      if (!ArrayBuffer.isView(V)) {
          throw makeException(TypeError, "is not a view on an ArrayBuffer or SharedArrayBuffer", opts);
      }

      if (!opts.allowShared && isSharedArrayBuffer(V.buffer)) {
          throw makeException(TypeError, "is a view on a SharedArrayBuffer, which is not allowed", opts);
      }

      if (isArrayBufferDetached(V.buffer)) {
          throw makeException(TypeError, "is a view on a detached ArrayBuffer", opts);
      }
      return V;
  };

  exports.BufferSource = (V, opts = {}) => {
      if (ArrayBuffer.isView(V)) {
          if (!opts.allowShared && isSharedArrayBuffer(V.buffer)) {
              throw makeException(TypeError, "is a view on a SharedArrayBuffer, which is not allowed", opts);
          }

          if (isArrayBufferDetached(V.buffer)) {
              throw makeException(TypeError, "is a view on a detached ArrayBuffer", opts);
          }
          return V;
      }

      if (!opts.allowShared && !isNonSharedArrayBuffer(V)) {
          throw makeException(TypeError, "is not an ArrayBuffer or a view on one", opts);
      }
      if (opts.allowShared && !isSharedArrayBuffer(V) && !isNonSharedArrayBuffer(V)) {
          throw makeException(TypeError, "is not an ArrayBuffer, SharedArrayBufer, or a view on one", opts);
      }
      if (isArrayBufferDetached(V)) {
          throw makeException(TypeError, "is a detached ArrayBuffer", opts);
      }

      return V;
  };

  exports.DOMTimeStamp = exports["unsigned long long"];

  exports.Function = convertCallbackFunction;

  exports.VoidFunction = convertCallbackFunction;
  });

  var utils$1 = createCommonjsModule(function (module, exports) {

  // Returns "Type(value) is Object" in ES terminology.
  function isObject(value) {
    return typeof value === "object" && value !== null || typeof value === "function";
  }

  const hasOwn = Function.prototype.call.bind(Object.prototype.hasOwnProperty);

  const wrapperSymbol = Symbol("wrapper");
  const implSymbol = Symbol("impl");
  const sameObjectCaches = Symbol("SameObject caches");
  const ctorRegistrySymbol = Symbol.for("[webidl2js]  constructor registry");

  function getSameObject(wrapper, prop, creator) {
    if (!wrapper[sameObjectCaches]) {
      wrapper[sameObjectCaches] = Object.create(null);
    }

    if (prop in wrapper[sameObjectCaches]) {
      return wrapper[sameObjectCaches][prop];
    }

    wrapper[sameObjectCaches][prop] = creator();
    return wrapper[sameObjectCaches][prop];
  }

  function wrapperForImpl(impl) {
    return impl ? impl[wrapperSymbol] : null;
  }

  function implForWrapper(wrapper) {
    return wrapper ? wrapper[implSymbol] : null;
  }

  function tryWrapperForImpl(impl) {
    const wrapper = wrapperForImpl(impl);
    return wrapper ? wrapper : impl;
  }

  function tryImplForWrapper(wrapper) {
    const impl = implForWrapper(wrapper);
    return impl ? impl : wrapper;
  }

  const iterInternalSymbol = Symbol("internal");
  const IteratorPrototype = Object.getPrototypeOf(Object.getPrototypeOf([][Symbol.iterator]()));
  const AsyncIteratorPrototype = Object.getPrototypeOf(Object.getPrototypeOf(async function* () {}).prototype);

  function isArrayIndexPropName(P) {
    if (typeof P !== "string") {
      return false;
    }
    const i = P >>> 0;
    if (i === Math.pow(2, 32) - 1) {
      return false;
    }
    const s = `${i}`;
    if (P !== s) {
      return false;
    }
    return true;
  }

  const byteLengthGetter =
      Object.getOwnPropertyDescriptor(ArrayBuffer.prototype, "byteLength").get;
  function isArrayBuffer(value) {
    try {
      byteLengthGetter.call(value);
      return true;
    } catch (e) {
      return false;
    }
  }

  function iteratorResult([key, value], kind) {
    let result;
    switch (kind) {
      case "key":
        result = key;
        break;
      case "value":
        result = value;
        break;
      case "key+value":
        result = [key, value];
        break;
    }
    return { value: result, done: false };
  }

  const supportsPropertyIndex = Symbol("supports property index");
  const supportedPropertyIndices = Symbol("supported property indices");
  const supportsPropertyName = Symbol("supports property name");
  const supportedPropertyNames = Symbol("supported property names");
  const indexedGet = Symbol("indexed property get");
  const indexedSetNew = Symbol("indexed property set new");
  const indexedSetExisting = Symbol("indexed property set existing");
  const namedGet = Symbol("named property get");
  const namedSetNew = Symbol("named property set new");
  const namedSetExisting = Symbol("named property set existing");
  const namedDelete = Symbol("named property delete");

  const asyncIteratorNext = Symbol("async iterator get the next iteration result");
  const asyncIteratorReturn = Symbol("async iterator return steps");
  const asyncIteratorInit = Symbol("async iterator initialization steps");
  const asyncIteratorEOI = Symbol("async iterator end of iteration");

  module.exports = {
    isObject,
    hasOwn,
    wrapperSymbol,
    implSymbol,
    getSameObject,
    ctorRegistrySymbol,
    wrapperForImpl,
    implForWrapper,
    tryWrapperForImpl,
    tryImplForWrapper,
    iterInternalSymbol,
    IteratorPrototype,
    AsyncIteratorPrototype,
    isArrayBuffer,
    isArrayIndexPropName,
    supportsPropertyIndex,
    supportedPropertyIndices,
    supportsPropertyName,
    supportedPropertyNames,
    indexedGet,
    indexedSetNew,
    indexedSetExisting,
    namedGet,
    namedSetNew,
    namedSetExisting,
    namedDelete,
    asyncIteratorNext,
    asyncIteratorReturn,
    asyncIteratorInit,
    asyncIteratorEOI,
    iteratorResult
  };
  });

  const combiningMarks = /[\u0300-\u036F\u0483-\u0489\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u0610-\u061A\u064B-\u065F\u0670\u06D6-\u06DC\u06DF-\u06E4\u06E7\u06E8\u06EA-\u06ED\u0711\u0730-\u074A\u07A6-\u07B0\u07EB-\u07F3\u07FD\u0816-\u0819\u081B-\u0823\u0825-\u0827\u0829-\u082D\u0859-\u085B\u08D3-\u08E1\u08E3-\u0903\u093A-\u093C\u093E-\u094F\u0951-\u0957\u0962\u0963\u0981-\u0983\u09BC\u09BE-\u09C4\u09C7\u09C8\u09CB-\u09CD\u09D7\u09E2\u09E3\u09FE\u0A01-\u0A03\u0A3C\u0A3E-\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A70\u0A71\u0A75\u0A81-\u0A83\u0ABC\u0ABE-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACD\u0AE2\u0AE3\u0AFA-\u0AFF\u0B01-\u0B03\u0B3C\u0B3E-\u0B44\u0B47\u0B48\u0B4B-\u0B4D\u0B55-\u0B57\u0B62\u0B63\u0B82\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD\u0BD7\u0C00-\u0C04\u0C3E-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C62\u0C63\u0C81-\u0C83\u0CBC\u0CBE-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5\u0CD6\u0CE2\u0CE3\u0D00-\u0D03\u0D3B\u0D3C\u0D3E-\u0D44\u0D46-\u0D48\u0D4A-\u0D4D\u0D57\u0D62\u0D63\u0D81-\u0D83\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DF2\u0DF3\u0E31\u0E34-\u0E3A\u0E47-\u0E4E\u0EB1\u0EB4-\u0EBC\u0EC8-\u0ECD\u0F18\u0F19\u0F35\u0F37\u0F39\u0F3E\u0F3F\u0F71-\u0F84\u0F86\u0F87\u0F8D-\u0F97\u0F99-\u0FBC\u0FC6\u102B-\u103E\u1056-\u1059\u105E-\u1060\u1062-\u1064\u1067-\u106D\u1071-\u1074\u1082-\u108D\u108F\u109A-\u109D\u135D-\u135F\u1712-\u1714\u1732-\u1734\u1752\u1753\u1772\u1773\u17B4-\u17D3\u17DD\u180B-\u180D\u1885\u1886\u18A9\u1920-\u192B\u1930-\u193B\u1A17-\u1A1B\u1A55-\u1A5E\u1A60-\u1A7C\u1A7F\u1AB0-\u1AC0\u1B00-\u1B04\u1B34-\u1B44\u1B6B-\u1B73\u1B80-\u1B82\u1BA1-\u1BAD\u1BE6-\u1BF3\u1C24-\u1C37\u1CD0-\u1CD2\u1CD4-\u1CE8\u1CED\u1CF4\u1CF7-\u1CF9\u1DC0-\u1DF9\u1DFB-\u1DFF\u20D0-\u20F0\u2CEF-\u2CF1\u2D7F\u2DE0-\u2DFF\u302A-\u302F\u3099\u309A\uA66F-\uA672\uA674-\uA67D\uA69E\uA69F\uA6F0\uA6F1\uA802\uA806\uA80B\uA823-\uA827\uA82C\uA880\uA881\uA8B4-\uA8C5\uA8E0-\uA8F1\uA8FF\uA926-\uA92D\uA947-\uA953\uA980-\uA983\uA9B3-\uA9C0\uA9E5\uAA29-\uAA36\uAA43\uAA4C\uAA4D\uAA7B-\uAA7D\uAAB0\uAAB2-\uAAB4\uAAB7\uAAB8\uAABE\uAABF\uAAC1\uAAEB-\uAAEF\uAAF5\uAAF6\uABE3-\uABEA\uABEC\uABED\uFB1E\uFE00-\uFE0F\uFE20-\uFE2F\u{101FD}\u{102E0}\u{10376}-\u{1037A}\u{10A01}-\u{10A03}\u{10A05}\u{10A06}\u{10A0C}-\u{10A0F}\u{10A38}-\u{10A3A}\u{10A3F}\u{10AE5}\u{10AE6}\u{10D24}-\u{10D27}\u{10EAB}\u{10EAC}\u{10F46}-\u{10F50}\u{11000}-\u{11002}\u{11038}-\u{11046}\u{1107F}-\u{11082}\u{110B0}-\u{110BA}\u{11100}-\u{11102}\u{11127}-\u{11134}\u{11145}\u{11146}\u{11173}\u{11180}-\u{11182}\u{111B3}-\u{111C0}\u{111C9}-\u{111CC}\u{111CE}\u{111CF}\u{1122C}-\u{11237}\u{1123E}\u{112DF}-\u{112EA}\u{11300}-\u{11303}\u{1133B}\u{1133C}\u{1133E}-\u{11344}\u{11347}\u{11348}\u{1134B}-\u{1134D}\u{11357}\u{11362}\u{11363}\u{11366}-\u{1136C}\u{11370}-\u{11374}\u{11435}-\u{11446}\u{1145E}\u{114B0}-\u{114C3}\u{115AF}-\u{115B5}\u{115B8}-\u{115C0}\u{115DC}\u{115DD}\u{11630}-\u{11640}\u{116AB}-\u{116B7}\u{1171D}-\u{1172B}\u{1182C}-\u{1183A}\u{11930}-\u{11935}\u{11937}\u{11938}\u{1193B}-\u{1193E}\u{11940}\u{11942}\u{11943}\u{119D1}-\u{119D7}\u{119DA}-\u{119E0}\u{119E4}\u{11A01}-\u{11A0A}\u{11A33}-\u{11A39}\u{11A3B}-\u{11A3E}\u{11A47}\u{11A51}-\u{11A5B}\u{11A8A}-\u{11A99}\u{11C2F}-\u{11C36}\u{11C38}-\u{11C3F}\u{11C92}-\u{11CA7}\u{11CA9}-\u{11CB6}\u{11D31}-\u{11D36}\u{11D3A}\u{11D3C}\u{11D3D}\u{11D3F}-\u{11D45}\u{11D47}\u{11D8A}-\u{11D8E}\u{11D90}\u{11D91}\u{11D93}-\u{11D97}\u{11EF3}-\u{11EF6}\u{16AF0}-\u{16AF4}\u{16B30}-\u{16B36}\u{16F4F}\u{16F51}-\u{16F87}\u{16F8F}-\u{16F92}\u{16FE4}\u{16FF0}\u{16FF1}\u{1BC9D}\u{1BC9E}\u{1D165}-\u{1D169}\u{1D16D}-\u{1D172}\u{1D17B}-\u{1D182}\u{1D185}-\u{1D18B}\u{1D1AA}-\u{1D1AD}\u{1D242}-\u{1D244}\u{1DA00}-\u{1DA36}\u{1DA3B}-\u{1DA6C}\u{1DA75}\u{1DA84}\u{1DA9B}-\u{1DA9F}\u{1DAA1}-\u{1DAAF}\u{1E000}-\u{1E006}\u{1E008}-\u{1E018}\u{1E01B}-\u{1E021}\u{1E023}\u{1E024}\u{1E026}-\u{1E02A}\u{1E130}-\u{1E136}\u{1E2EC}-\u{1E2EF}\u{1E8D0}-\u{1E8D6}\u{1E944}-\u{1E94A}\u{E0100}-\u{E01EF}]/u;
  const combiningClassVirama = /[\u094D\u09CD\u0A4D\u0ACD\u0B4D\u0BCD\u0C4D\u0CCD\u0D3B\u0D3C\u0D4D\u0DCA\u0E3A\u0EBA\u0F84\u1039\u103A\u1714\u1734\u17D2\u1A60\u1B44\u1BAA\u1BAB\u1BF2\u1BF3\u2D7F\uA806\uA8C4\uA953\uA9C0\uAAF6\uABED\u{10A3F}\u{11046}\u{1107F}\u{110B9}\u{11133}\u{11134}\u{111C0}\u{11235}\u{112EA}\u{1134D}\u{11442}\u{114C2}\u{115BF}\u{1163F}\u{116B6}\u{1172B}\u{11839}\u{119E0}\u{11A34}\u{11A47}\u{11A99}\u{11C3F}\u{11D44}\u{11D45}\u{11D97}]/u;
  const validZWNJ = /[\u0620\u0626\u0628\u062A-\u062E\u0633-\u063F\u0641-\u0647\u0649\u064A\u066E\u066F\u0678-\u0687\u069A-\u06BF\u06C1\u06C2\u06CC\u06CE\u06D0\u06D1\u06FA-\u06FC\u06FF\u0712-\u0714\u071A-\u071D\u071F-\u0727\u0729\u072B\u072D\u072E\u074E-\u0758\u075C-\u076A\u076D-\u0770\u0772\u0775-\u0777\u077A-\u077F\u07CA-\u07EA\u0841-\u0845\u0848\u084A-\u0853\u0855\u0860\u0862-\u0865\u0868\u08A0-\u08A9\u08AF\u08B0\u08B3\u08B4\u08B6-\u08B8\u08BA-\u08BD\u1807\u1820-\u1878\u1887-\u18A8\u18AA\uA840-\uA872\u{10AC0}-\u{10AC4}\u{10ACD}\u{10AD3}-\u{10ADC}\u{10ADE}-\u{10AE0}\u{10AEB}-\u{10AEE}\u{10B80}\u{10B82}\u{10B86}-\u{10B88}\u{10B8A}\u{10B8B}\u{10B8D}\u{10B90}\u{10BAD}\u{10BAE}\u{10D00}-\u{10D21}\u{10D23}\u{10F30}-\u{10F32}\u{10F34}-\u{10F44}\u{10F51}-\u{10F53}\u{1E900}-\u{1E943}][\xAD\u0300-\u036F\u0483-\u0489\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u0610-\u061A\u061C\u064B-\u065F\u0670\u06D6-\u06DC\u06DF-\u06E4\u06E7\u06E8\u06EA-\u06ED\u070F\u0711\u0730-\u074A\u07A6-\u07B0\u07EB-\u07F3\u07FD\u0816-\u0819\u081B-\u0823\u0825-\u0827\u0829-\u082D\u0859-\u085B\u08D3-\u08E1\u08E3-\u0902\u093A\u093C\u0941-\u0948\u094D\u0951-\u0957\u0962\u0963\u0981\u09BC\u09C1-\u09C4\u09CD\u09E2\u09E3\u09FE\u0A01\u0A02\u0A3C\u0A41\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A70\u0A71\u0A75\u0A81\u0A82\u0ABC\u0AC1-\u0AC5\u0AC7\u0AC8\u0ACD\u0AE2\u0AE3\u0AFA-\u0AFF\u0B01\u0B3C\u0B3F\u0B41-\u0B44\u0B4D\u0B56\u0B62\u0B63\u0B82\u0BC0\u0BCD\u0C00\u0C04\u0C3E-\u0C40\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C62\u0C63\u0C81\u0CBC\u0CBF\u0CC6\u0CCC\u0CCD\u0CE2\u0CE3\u0D00\u0D01\u0D3B\u0D3C\u0D41-\u0D44\u0D4D\u0D62\u0D63\u0DCA\u0DD2-\u0DD4\u0DD6\u0E31\u0E34-\u0E3A\u0E47-\u0E4E\u0EB1\u0EB4-\u0EBC\u0EC8-\u0ECD\u0F18\u0F19\u0F35\u0F37\u0F39\u0F71-\u0F7E\u0F80-\u0F84\u0F86\u0F87\u0F8D-\u0F97\u0F99-\u0FBC\u0FC6\u102D-\u1030\u1032-\u1037\u1039\u103A\u103D\u103E\u1058\u1059\u105E-\u1060\u1071-\u1074\u1082\u1085\u1086\u108D\u109D\u135D-\u135F\u1712-\u1714\u1732-\u1734\u1752\u1753\u1772\u1773\u17B4\u17B5\u17B7-\u17BD\u17C6\u17C9-\u17D3\u17DD\u180B-\u180D\u1885\u1886\u18A9\u1920-\u1922\u1927\u1928\u1932\u1939-\u193B\u1A17\u1A18\u1A1B\u1A56\u1A58-\u1A5E\u1A60\u1A62\u1A65-\u1A6C\u1A73-\u1A7C\u1A7F\u1AB0-\u1ABE\u1B00-\u1B03\u1B34\u1B36-\u1B3A\u1B3C\u1B42\u1B6B-\u1B73\u1B80\u1B81\u1BA2-\u1BA5\u1BA8\u1BA9\u1BAB-\u1BAD\u1BE6\u1BE8\u1BE9\u1BED\u1BEF-\u1BF1\u1C2C-\u1C33\u1C36\u1C37\u1CD0-\u1CD2\u1CD4-\u1CE0\u1CE2-\u1CE8\u1CED\u1CF4\u1CF8\u1CF9\u1DC0-\u1DF9\u1DFB-\u1DFF\u200B\u200E\u200F\u202A-\u202E\u2060-\u2064\u206A-\u206F\u20D0-\u20F0\u2CEF-\u2CF1\u2D7F\u2DE0-\u2DFF\u302A-\u302D\u3099\u309A\uA66F-\uA672\uA674-\uA67D\uA69E\uA69F\uA6F0\uA6F1\uA802\uA806\uA80B\uA825\uA826\uA8C4\uA8C5\uA8E0-\uA8F1\uA8FF\uA926-\uA92D\uA947-\uA951\uA980-\uA982\uA9B3\uA9B6-\uA9B9\uA9BC\uA9BD\uA9E5\uAA29-\uAA2E\uAA31\uAA32\uAA35\uAA36\uAA43\uAA4C\uAA7C\uAAB0\uAAB2-\uAAB4\uAAB7\uAAB8\uAABE\uAABF\uAAC1\uAAEC\uAAED\uAAF6\uABE5\uABE8\uABED\uFB1E\uFE00-\uFE0F\uFE20-\uFE2F\uFEFF\uFFF9-\uFFFB\u{101FD}\u{102E0}\u{10376}-\u{1037A}\u{10A01}-\u{10A03}\u{10A05}\u{10A06}\u{10A0C}-\u{10A0F}\u{10A38}-\u{10A3A}\u{10A3F}\u{10AE5}\u{10AE6}\u{10D24}-\u{10D27}\u{10F46}-\u{10F50}\u{11001}\u{11038}-\u{11046}\u{1107F}-\u{11081}\u{110B3}-\u{110B6}\u{110B9}\u{110BA}\u{11100}-\u{11102}\u{11127}-\u{1112B}\u{1112D}-\u{11134}\u{11173}\u{11180}\u{11181}\u{111B6}-\u{111BE}\u{111C9}-\u{111CC}\u{1122F}-\u{11231}\u{11234}\u{11236}\u{11237}\u{1123E}\u{112DF}\u{112E3}-\u{112EA}\u{11300}\u{11301}\u{1133B}\u{1133C}\u{11340}\u{11366}-\u{1136C}\u{11370}-\u{11374}\u{11438}-\u{1143F}\u{11442}-\u{11444}\u{11446}\u{1145E}\u{114B3}-\u{114B8}\u{114BA}\u{114BF}\u{114C0}\u{114C2}\u{114C3}\u{115B2}-\u{115B5}\u{115BC}\u{115BD}\u{115BF}\u{115C0}\u{115DC}\u{115DD}\u{11633}-\u{1163A}\u{1163D}\u{1163F}\u{11640}\u{116AB}\u{116AD}\u{116B0}-\u{116B5}\u{116B7}\u{1171D}-\u{1171F}\u{11722}-\u{11725}\u{11727}-\u{1172B}\u{1182F}-\u{11837}\u{11839}\u{1183A}\u{119D4}-\u{119D7}\u{119DA}\u{119DB}\u{119E0}\u{11A01}-\u{11A0A}\u{11A33}-\u{11A38}\u{11A3B}-\u{11A3E}\u{11A47}\u{11A51}-\u{11A56}\u{11A59}-\u{11A5B}\u{11A8A}-\u{11A96}\u{11A98}\u{11A99}\u{11C30}-\u{11C36}\u{11C38}-\u{11C3D}\u{11C3F}\u{11C92}-\u{11CA7}\u{11CAA}-\u{11CB0}\u{11CB2}\u{11CB3}\u{11CB5}\u{11CB6}\u{11D31}-\u{11D36}\u{11D3A}\u{11D3C}\u{11D3D}\u{11D3F}-\u{11D45}\u{11D47}\u{11D90}\u{11D91}\u{11D95}\u{11D97}\u{11EF3}\u{11EF4}\u{13430}-\u{13438}\u{16AF0}-\u{16AF4}\u{16B30}-\u{16B36}\u{16F4F}\u{16F8F}-\u{16F92}\u{1BC9D}\u{1BC9E}\u{1BCA0}-\u{1BCA3}\u{1D167}-\u{1D169}\u{1D173}-\u{1D182}\u{1D185}-\u{1D18B}\u{1D1AA}-\u{1D1AD}\u{1D242}-\u{1D244}\u{1DA00}-\u{1DA36}\u{1DA3B}-\u{1DA6C}\u{1DA75}\u{1DA84}\u{1DA9B}-\u{1DA9F}\u{1DAA1}-\u{1DAAF}\u{1E000}-\u{1E006}\u{1E008}-\u{1E018}\u{1E01B}-\u{1E021}\u{1E023}\u{1E024}\u{1E026}-\u{1E02A}\u{1E130}-\u{1E136}\u{1E2EC}-\u{1E2EF}\u{1E8D0}-\u{1E8D6}\u{1E944}-\u{1E94B}\u{E0001}\u{E0020}-\u{E007F}\u{E0100}-\u{E01EF}]*\u200C[\xAD\u0300-\u036F\u0483-\u0489\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u0610-\u061A\u061C\u064B-\u065F\u0670\u06D6-\u06DC\u06DF-\u06E4\u06E7\u06E8\u06EA-\u06ED\u070F\u0711\u0730-\u074A\u07A6-\u07B0\u07EB-\u07F3\u07FD\u0816-\u0819\u081B-\u0823\u0825-\u0827\u0829-\u082D\u0859-\u085B\u08D3-\u08E1\u08E3-\u0902\u093A\u093C\u0941-\u0948\u094D\u0951-\u0957\u0962\u0963\u0981\u09BC\u09C1-\u09C4\u09CD\u09E2\u09E3\u09FE\u0A01\u0A02\u0A3C\u0A41\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A70\u0A71\u0A75\u0A81\u0A82\u0ABC\u0AC1-\u0AC5\u0AC7\u0AC8\u0ACD\u0AE2\u0AE3\u0AFA-\u0AFF\u0B01\u0B3C\u0B3F\u0B41-\u0B44\u0B4D\u0B56\u0B62\u0B63\u0B82\u0BC0\u0BCD\u0C00\u0C04\u0C3E-\u0C40\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C62\u0C63\u0C81\u0CBC\u0CBF\u0CC6\u0CCC\u0CCD\u0CE2\u0CE3\u0D00\u0D01\u0D3B\u0D3C\u0D41-\u0D44\u0D4D\u0D62\u0D63\u0DCA\u0DD2-\u0DD4\u0DD6\u0E31\u0E34-\u0E3A\u0E47-\u0E4E\u0EB1\u0EB4-\u0EBC\u0EC8-\u0ECD\u0F18\u0F19\u0F35\u0F37\u0F39\u0F71-\u0F7E\u0F80-\u0F84\u0F86\u0F87\u0F8D-\u0F97\u0F99-\u0FBC\u0FC6\u102D-\u1030\u1032-\u1037\u1039\u103A\u103D\u103E\u1058\u1059\u105E-\u1060\u1071-\u1074\u1082\u1085\u1086\u108D\u109D\u135D-\u135F\u1712-\u1714\u1732-\u1734\u1752\u1753\u1772\u1773\u17B4\u17B5\u17B7-\u17BD\u17C6\u17C9-\u17D3\u17DD\u180B-\u180D\u1885\u1886\u18A9\u1920-\u1922\u1927\u1928\u1932\u1939-\u193B\u1A17\u1A18\u1A1B\u1A56\u1A58-\u1A5E\u1A60\u1A62\u1A65-\u1A6C\u1A73-\u1A7C\u1A7F\u1AB0-\u1ABE\u1B00-\u1B03\u1B34\u1B36-\u1B3A\u1B3C\u1B42\u1B6B-\u1B73\u1B80\u1B81\u1BA2-\u1BA5\u1BA8\u1BA9\u1BAB-\u1BAD\u1BE6\u1BE8\u1BE9\u1BED\u1BEF-\u1BF1\u1C2C-\u1C33\u1C36\u1C37\u1CD0-\u1CD2\u1CD4-\u1CE0\u1CE2-\u1CE8\u1CED\u1CF4\u1CF8\u1CF9\u1DC0-\u1DF9\u1DFB-\u1DFF\u200B\u200E\u200F\u202A-\u202E\u2060-\u2064\u206A-\u206F\u20D0-\u20F0\u2CEF-\u2CF1\u2D7F\u2DE0-\u2DFF\u302A-\u302D\u3099\u309A\uA66F-\uA672\uA674-\uA67D\uA69E\uA69F\uA6F0\uA6F1\uA802\uA806\uA80B\uA825\uA826\uA8C4\uA8C5\uA8E0-\uA8F1\uA8FF\uA926-\uA92D\uA947-\uA951\uA980-\uA982\uA9B3\uA9B6-\uA9B9\uA9BC\uA9BD\uA9E5\uAA29-\uAA2E\uAA31\uAA32\uAA35\uAA36\uAA43\uAA4C\uAA7C\uAAB0\uAAB2-\uAAB4\uAAB7\uAAB8\uAABE\uAABF\uAAC1\uAAEC\uAAED\uAAF6\uABE5\uABE8\uABED\uFB1E\uFE00-\uFE0F\uFE20-\uFE2F\uFEFF\uFFF9-\uFFFB\u{101FD}\u{102E0}\u{10376}-\u{1037A}\u{10A01}-\u{10A03}\u{10A05}\u{10A06}\u{10A0C}-\u{10A0F}\u{10A38}-\u{10A3A}\u{10A3F}\u{10AE5}\u{10AE6}\u{10D24}-\u{10D27}\u{10F46}-\u{10F50}\u{11001}\u{11038}-\u{11046}\u{1107F}-\u{11081}\u{110B3}-\u{110B6}\u{110B9}\u{110BA}\u{11100}-\u{11102}\u{11127}-\u{1112B}\u{1112D}-\u{11134}\u{11173}\u{11180}\u{11181}\u{111B6}-\u{111BE}\u{111C9}-\u{111CC}\u{1122F}-\u{11231}\u{11234}\u{11236}\u{11237}\u{1123E}\u{112DF}\u{112E3}-\u{112EA}\u{11300}\u{11301}\u{1133B}\u{1133C}\u{11340}\u{11366}-\u{1136C}\u{11370}-\u{11374}\u{11438}-\u{1143F}\u{11442}-\u{11444}\u{11446}\u{1145E}\u{114B3}-\u{114B8}\u{114BA}\u{114BF}\u{114C0}\u{114C2}\u{114C3}\u{115B2}-\u{115B5}\u{115BC}\u{115BD}\u{115BF}\u{115C0}\u{115DC}\u{115DD}\u{11633}-\u{1163A}\u{1163D}\u{1163F}\u{11640}\u{116AB}\u{116AD}\u{116B0}-\u{116B5}\u{116B7}\u{1171D}-\u{1171F}\u{11722}-\u{11725}\u{11727}-\u{1172B}\u{1182F}-\u{11837}\u{11839}\u{1183A}\u{119D4}-\u{119D7}\u{119DA}\u{119DB}\u{119E0}\u{11A01}-\u{11A0A}\u{11A33}-\u{11A38}\u{11A3B}-\u{11A3E}\u{11A47}\u{11A51}-\u{11A56}\u{11A59}-\u{11A5B}\u{11A8A}-\u{11A96}\u{11A98}\u{11A99}\u{11C30}-\u{11C36}\u{11C38}-\u{11C3D}\u{11C3F}\u{11C92}-\u{11CA7}\u{11CAA}-\u{11CB0}\u{11CB2}\u{11CB3}\u{11CB5}\u{11CB6}\u{11D31}-\u{11D36}\u{11D3A}\u{11D3C}\u{11D3D}\u{11D3F}-\u{11D45}\u{11D47}\u{11D90}\u{11D91}\u{11D95}\u{11D97}\u{11EF3}\u{11EF4}\u{13430}-\u{13438}\u{16AF0}-\u{16AF4}\u{16B30}-\u{16B36}\u{16F4F}\u{16F8F}-\u{16F92}\u{1BC9D}\u{1BC9E}\u{1BCA0}-\u{1BCA3}\u{1D167}-\u{1D169}\u{1D173}-\u{1D182}\u{1D185}-\u{1D18B}\u{1D1AA}-\u{1D1AD}\u{1D242}-\u{1D244}\u{1DA00}-\u{1DA36}\u{1DA3B}-\u{1DA6C}\u{1DA75}\u{1DA84}\u{1DA9B}-\u{1DA9F}\u{1DAA1}-\u{1DAAF}\u{1E000}-\u{1E006}\u{1E008}-\u{1E018}\u{1E01B}-\u{1E021}\u{1E023}\u{1E024}\u{1E026}-\u{1E02A}\u{1E130}-\u{1E136}\u{1E2EC}-\u{1E2EF}\u{1E8D0}-\u{1E8D6}\u{1E944}-\u{1E94B}\u{E0001}\u{E0020}-\u{E007F}\u{E0100}-\u{E01EF}]*[\u0620\u0622-\u063F\u0641-\u064A\u066E\u066F\u0671-\u0673\u0675-\u06D3\u06D5\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u077F\u07CA-\u07EA\u0840-\u0855\u0860\u0862-\u0865\u0867-\u086A\u08A0-\u08AC\u08AE-\u08B4\u08B6-\u08BD\u1807\u1820-\u1878\u1887-\u18A8\u18AA\uA840-\uA871\u{10AC0}-\u{10AC5}\u{10AC7}\u{10AC9}\u{10ACA}\u{10ACE}-\u{10AD6}\u{10AD8}-\u{10AE1}\u{10AE4}\u{10AEB}-\u{10AEF}\u{10B80}-\u{10B91}\u{10BA9}-\u{10BAE}\u{10D01}-\u{10D23}\u{10F30}-\u{10F44}\u{10F51}-\u{10F54}\u{1E900}-\u{1E943}]/u;
  const bidiDomain = /[\u05BE\u05C0\u05C3\u05C6\u05D0-\u05EA\u05EF-\u05F4\u0600-\u0605\u0608\u060B\u060D\u061B\u061C\u061E-\u064A\u0660-\u0669\u066B-\u066F\u0671-\u06D5\u06DD\u06E5\u06E6\u06EE\u06EF\u06FA-\u070D\u070F\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07C0-\u07EA\u07F4\u07F5\u07FA\u07FE-\u0815\u081A\u0824\u0828\u0830-\u083E\u0840-\u0858\u085E\u0860-\u086A\u08A0-\u08B4\u08B6-\u08C7\u08E2\u200F\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBC1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFC\uFE70-\uFE74\uFE76-\uFEFC\u{10800}-\u{10805}\u{10808}\u{1080A}-\u{10835}\u{10837}\u{10838}\u{1083C}\u{1083F}-\u{10855}\u{10857}-\u{1089E}\u{108A7}-\u{108AF}\u{108E0}-\u{108F2}\u{108F4}\u{108F5}\u{108FB}-\u{1091B}\u{10920}-\u{10939}\u{1093F}\u{10980}-\u{109B7}\u{109BC}-\u{109CF}\u{109D2}-\u{10A00}\u{10A10}-\u{10A13}\u{10A15}-\u{10A17}\u{10A19}-\u{10A35}\u{10A40}-\u{10A48}\u{10A50}-\u{10A58}\u{10A60}-\u{10A9F}\u{10AC0}-\u{10AE4}\u{10AEB}-\u{10AF6}\u{10B00}-\u{10B35}\u{10B40}-\u{10B55}\u{10B58}-\u{10B72}\u{10B78}-\u{10B91}\u{10B99}-\u{10B9C}\u{10BA9}-\u{10BAF}\u{10C00}-\u{10C48}\u{10C80}-\u{10CB2}\u{10CC0}-\u{10CF2}\u{10CFA}-\u{10D23}\u{10D30}-\u{10D39}\u{10E60}-\u{10E7E}\u{10E80}-\u{10EA9}\u{10EAD}\u{10EB0}\u{10EB1}\u{10F00}-\u{10F27}\u{10F30}-\u{10F45}\u{10F51}-\u{10F59}\u{10FB0}-\u{10FCB}\u{10FE0}-\u{10FF6}\u{1E800}-\u{1E8C4}\u{1E8C7}-\u{1E8CF}\u{1E900}-\u{1E943}\u{1E94B}\u{1E950}-\u{1E959}\u{1E95E}\u{1E95F}\u{1EC71}-\u{1ECB4}\u{1ED01}-\u{1ED3D}\u{1EE00}-\u{1EE03}\u{1EE05}-\u{1EE1F}\u{1EE21}\u{1EE22}\u{1EE24}\u{1EE27}\u{1EE29}-\u{1EE32}\u{1EE34}-\u{1EE37}\u{1EE39}\u{1EE3B}\u{1EE42}\u{1EE47}\u{1EE49}\u{1EE4B}\u{1EE4D}-\u{1EE4F}\u{1EE51}\u{1EE52}\u{1EE54}\u{1EE57}\u{1EE59}\u{1EE5B}\u{1EE5D}\u{1EE5F}\u{1EE61}\u{1EE62}\u{1EE64}\u{1EE67}-\u{1EE6A}\u{1EE6C}-\u{1EE72}\u{1EE74}-\u{1EE77}\u{1EE79}-\u{1EE7C}\u{1EE7E}\u{1EE80}-\u{1EE89}\u{1EE8B}-\u{1EE9B}\u{1EEA1}-\u{1EEA3}\u{1EEA5}-\u{1EEA9}\u{1EEAB}-\u{1EEBB}]/u;
  const bidiS1LTR = /[A-Za-z\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02B8\u02BB-\u02C1\u02D0\u02D1\u02E0-\u02E4\u02EE\u0370-\u0373\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0482\u048A-\u052F\u0531-\u0556\u0559-\u0589\u0903-\u0939\u093B\u093D-\u0940\u0949-\u094C\u094E-\u0950\u0958-\u0961\u0964-\u0980\u0982\u0983\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD-\u09C0\u09C7\u09C8\u09CB\u09CC\u09CE\u09D7\u09DC\u09DD\u09DF-\u09E1\u09E6-\u09F1\u09F4-\u09FA\u09FC\u09FD\u0A03\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A3E-\u0A40\u0A59-\u0A5C\u0A5E\u0A66-\u0A6F\u0A72-\u0A74\u0A76\u0A83\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD-\u0AC0\u0AC9\u0ACB\u0ACC\u0AD0\u0AE0\u0AE1\u0AE6-\u0AF0\u0AF9\u0B02\u0B03\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B3E\u0B40\u0B47\u0B48\u0B4B\u0B4C\u0B57\u0B5C\u0B5D\u0B5F-\u0B61\u0B66-\u0B77\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BBE\u0BBF\u0BC1\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCC\u0BD0\u0BD7\u0BE6-\u0BF2\u0C01-\u0C03\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C41-\u0C44\u0C58-\u0C5A\u0C60\u0C61\u0C66-\u0C6F\u0C77\u0C7F\u0C80\u0C82-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD-\u0CC4\u0CC6-\u0CC8\u0CCA\u0CCB\u0CD5\u0CD6\u0CDE\u0CE0\u0CE1\u0CE6-\u0CEF\u0CF1\u0CF2\u0D02-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D-\u0D40\u0D46-\u0D48\u0D4A-\u0D4C\u0D4E\u0D4F\u0D54-\u0D61\u0D66-\u0D7F\u0D82\u0D83\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0DCF-\u0DD1\u0DD8-\u0DDF\u0DE6-\u0DEF\u0DF2-\u0DF4\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E4F-\u0E5B\u0E81\u0E82\u0E84\u0E86-\u0E8A\u0E8C-\u0EA3\u0EA5\u0EA7-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0ED0-\u0ED9\u0EDC-\u0EDF\u0F00-\u0F17\u0F1A-\u0F34\u0F36\u0F38\u0F3E-\u0F47\u0F49-\u0F6C\u0F7F\u0F85\u0F88-\u0F8C\u0FBE-\u0FC5\u0FC7-\u0FCC\u0FCE-\u0FDA\u1000-\u102C\u1031\u1038\u103B\u103C\u103F-\u1057\u105A-\u105D\u1061-\u1070\u1075-\u1081\u1083\u1084\u1087-\u108C\u108E-\u109C\u109E-\u10C5\u10C7\u10CD\u10D0-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1360-\u137C\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u167F\u1681-\u169A\u16A0-\u16F8\u1700-\u170C\u170E-\u1711\u1720-\u1731\u1735\u1736\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17B6\u17BE-\u17C5\u17C7\u17C8\u17D4-\u17DA\u17DC\u17E0-\u17E9\u1810-\u1819\u1820-\u1878\u1880-\u1884\u1887-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1923-\u1926\u1929-\u192B\u1930\u1931\u1933-\u1938\u1946-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u19D0-\u19DA\u1A00-\u1A16\u1A19\u1A1A\u1A1E-\u1A55\u1A57\u1A61\u1A63\u1A64\u1A6D-\u1A72\u1A80-\u1A89\u1A90-\u1A99\u1AA0-\u1AAD\u1B04-\u1B33\u1B35\u1B3B\u1B3D-\u1B41\u1B43-\u1B4B\u1B50-\u1B6A\u1B74-\u1B7C\u1B82-\u1BA1\u1BA6\u1BA7\u1BAA\u1BAE-\u1BE5\u1BE7\u1BEA-\u1BEC\u1BEE\u1BF2\u1BF3\u1BFC-\u1C2B\u1C34\u1C35\u1C3B-\u1C49\u1C4D-\u1C88\u1C90-\u1CBA\u1CBD-\u1CC7\u1CD3\u1CE1\u1CE9-\u1CEC\u1CEE-\u1CF3\u1CF5-\u1CF7\u1CFA\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u200E\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u214F\u2160-\u2188\u2336-\u237A\u2395\u249C-\u24E9\u26AC\u2800-\u28FF\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D70\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u3005-\u3007\u3021-\u3029\u302E\u302F\u3031-\u3035\u3038-\u303C\u3041-\u3096\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312F\u3131-\u318E\u3190-\u31BF\u31F0-\u321C\u3220-\u324F\u3260-\u327B\u327F-\u32B0\u32C0-\u32CB\u32D0-\u3376\u337B-\u33DD\u33E0-\u33FE\u3400-\u4DBF\u4E00-\u9FFC\uA000-\uA48C\uA4D0-\uA60C\uA610-\uA62B\uA640-\uA66E\uA680-\uA69D\uA6A0-\uA6EF\uA6F2-\uA6F7\uA722-\uA787\uA789-\uA7BF\uA7C2-\uA7CA\uA7F5-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA824\uA827\uA830-\uA837\uA840-\uA873\uA880-\uA8C3\uA8CE-\uA8D9\uA8F2-\uA8FE\uA900-\uA925\uA92E-\uA946\uA952\uA953\uA95F-\uA97C\uA983-\uA9B2\uA9B4\uA9B5\uA9BA\uA9BB\uA9BE-\uA9CD\uA9CF-\uA9D9\uA9DE-\uA9E4\uA9E6-\uA9FE\uAA00-\uAA28\uAA2F\uAA30\uAA33\uAA34\uAA40-\uAA42\uAA44-\uAA4B\uAA4D\uAA50-\uAA59\uAA5C-\uAA7B\uAA7D-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAAEB\uAAEE-\uAAF5\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB69\uAB70-\uABE4\uABE6\uABE7\uABE9-\uABEC\uABF0-\uABF9\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uD800-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC\u{10000}-\u{1000B}\u{1000D}-\u{10026}\u{10028}-\u{1003A}\u{1003C}\u{1003D}\u{1003F}-\u{1004D}\u{10050}-\u{1005D}\u{10080}-\u{100FA}\u{10100}\u{10102}\u{10107}-\u{10133}\u{10137}-\u{1013F}\u{1018D}\u{1018E}\u{101D0}-\u{101FC}\u{10280}-\u{1029C}\u{102A0}-\u{102D0}\u{10300}-\u{10323}\u{1032D}-\u{1034A}\u{10350}-\u{10375}\u{10380}-\u{1039D}\u{1039F}-\u{103C3}\u{103C8}-\u{103D5}\u{10400}-\u{1049D}\u{104A0}-\u{104A9}\u{104B0}-\u{104D3}\u{104D8}-\u{104FB}\u{10500}-\u{10527}\u{10530}-\u{10563}\u{1056F}\u{10600}-\u{10736}\u{10740}-\u{10755}\u{10760}-\u{10767}\u{11000}\u{11002}-\u{11037}\u{11047}-\u{1104D}\u{11066}-\u{1106F}\u{11082}-\u{110B2}\u{110B7}\u{110B8}\u{110BB}-\u{110C1}\u{110CD}\u{110D0}-\u{110E8}\u{110F0}-\u{110F9}\u{11103}-\u{11126}\u{1112C}\u{11136}-\u{11147}\u{11150}-\u{11172}\u{11174}-\u{11176}\u{11182}-\u{111B5}\u{111BF}-\u{111C8}\u{111CD}\u{111CE}\u{111D0}-\u{111DF}\u{111E1}-\u{111F4}\u{11200}-\u{11211}\u{11213}-\u{1122E}\u{11232}\u{11233}\u{11235}\u{11238}-\u{1123D}\u{11280}-\u{11286}\u{11288}\u{1128A}-\u{1128D}\u{1128F}-\u{1129D}\u{1129F}-\u{112A9}\u{112B0}-\u{112DE}\u{112E0}-\u{112E2}\u{112F0}-\u{112F9}\u{11302}\u{11303}\u{11305}-\u{1130C}\u{1130F}\u{11310}\u{11313}-\u{11328}\u{1132A}-\u{11330}\u{11332}\u{11333}\u{11335}-\u{11339}\u{1133D}-\u{1133F}\u{11341}-\u{11344}\u{11347}\u{11348}\u{1134B}-\u{1134D}\u{11350}\u{11357}\u{1135D}-\u{11363}\u{11400}-\u{11437}\u{11440}\u{11441}\u{11445}\u{11447}-\u{1145B}\u{1145D}\u{1145F}-\u{11461}\u{11480}-\u{114B2}\u{114B9}\u{114BB}-\u{114BE}\u{114C1}\u{114C4}-\u{114C7}\u{114D0}-\u{114D9}\u{11580}-\u{115B1}\u{115B8}-\u{115BB}\u{115BE}\u{115C1}-\u{115DB}\u{11600}-\u{11632}\u{1163B}\u{1163C}\u{1163E}\u{11641}-\u{11644}\u{11650}-\u{11659}\u{11680}-\u{116AA}\u{116AC}\u{116AE}\u{116AF}\u{116B6}\u{116B8}\u{116C0}-\u{116C9}\u{11700}-\u{1171A}\u{11720}\u{11721}\u{11726}\u{11730}-\u{1173F}\u{11800}-\u{1182E}\u{11838}\u{1183B}\u{118A0}-\u{118F2}\u{118FF}-\u{11906}\u{11909}\u{1190C}-\u{11913}\u{11915}\u{11916}\u{11918}-\u{11935}\u{11937}\u{11938}\u{1193D}\u{1193F}-\u{11942}\u{11944}-\u{11946}\u{11950}-\u{11959}\u{119A0}-\u{119A7}\u{119AA}-\u{119D3}\u{119DC}-\u{119DF}\u{119E1}-\u{119E4}\u{11A00}\u{11A07}\u{11A08}\u{11A0B}-\u{11A32}\u{11A39}\u{11A3A}\u{11A3F}-\u{11A46}\u{11A50}\u{11A57}\u{11A58}\u{11A5C}-\u{11A89}\u{11A97}\u{11A9A}-\u{11AA2}\u{11AC0}-\u{11AF8}\u{11C00}-\u{11C08}\u{11C0A}-\u{11C2F}\u{11C3E}-\u{11C45}\u{11C50}-\u{11C6C}\u{11C70}-\u{11C8F}\u{11CA9}\u{11CB1}\u{11CB4}\u{11D00}-\u{11D06}\u{11D08}\u{11D09}\u{11D0B}-\u{11D30}\u{11D46}\u{11D50}-\u{11D59}\u{11D60}-\u{11D65}\u{11D67}\u{11D68}\u{11D6A}-\u{11D8E}\u{11D93}\u{11D94}\u{11D96}\u{11D98}\u{11DA0}-\u{11DA9}\u{11EE0}-\u{11EF2}\u{11EF5}-\u{11EF8}\u{11FB0}\u{11FC0}-\u{11FD4}\u{11FFF}-\u{12399}\u{12400}-\u{1246E}\u{12470}-\u{12474}\u{12480}-\u{12543}\u{13000}-\u{1342E}\u{13430}-\u{13438}\u{14400}-\u{14646}\u{16800}-\u{16A38}\u{16A40}-\u{16A5E}\u{16A60}-\u{16A69}\u{16A6E}\u{16A6F}\u{16AD0}-\u{16AED}\u{16AF5}\u{16B00}-\u{16B2F}\u{16B37}-\u{16B45}\u{16B50}-\u{16B59}\u{16B5B}-\u{16B61}\u{16B63}-\u{16B77}\u{16B7D}-\u{16B8F}\u{16E40}-\u{16E9A}\u{16F00}-\u{16F4A}\u{16F50}-\u{16F87}\u{16F93}-\u{16F9F}\u{16FE0}\u{16FE1}\u{16FE3}\u{16FF0}\u{16FF1}\u{17000}-\u{187F7}\u{18800}-\u{18CD5}\u{18D00}-\u{18D08}\u{1B000}-\u{1B11E}\u{1B150}-\u{1B152}\u{1B164}-\u{1B167}\u{1B170}-\u{1B2FB}\u{1BC00}-\u{1BC6A}\u{1BC70}-\u{1BC7C}\u{1BC80}-\u{1BC88}\u{1BC90}-\u{1BC99}\u{1BC9C}\u{1BC9F}\u{1D000}-\u{1D0F5}\u{1D100}-\u{1D126}\u{1D129}-\u{1D166}\u{1D16A}-\u{1D172}\u{1D183}\u{1D184}\u{1D18C}-\u{1D1A9}\u{1D1AE}-\u{1D1E8}\u{1D2E0}-\u{1D2F3}\u{1D360}-\u{1D378}\u{1D400}-\u{1D454}\u{1D456}-\u{1D49C}\u{1D49E}\u{1D49F}\u{1D4A2}\u{1D4A5}\u{1D4A6}\u{1D4A9}-\u{1D4AC}\u{1D4AE}-\u{1D4B9}\u{1D4BB}\u{1D4BD}-\u{1D4C3}\u{1D4C5}-\u{1D505}\u{1D507}-\u{1D50A}\u{1D50D}-\u{1D514}\u{1D516}-\u{1D51C}\u{1D51E}-\u{1D539}\u{1D53B}-\u{1D53E}\u{1D540}-\u{1D544}\u{1D546}\u{1D54A}-\u{1D550}\u{1D552}-\u{1D6A5}\u{1D6A8}-\u{1D6DA}\u{1D6DC}-\u{1D714}\u{1D716}-\u{1D74E}\u{1D750}-\u{1D788}\u{1D78A}-\u{1D7C2}\u{1D7C4}-\u{1D7CB}\u{1D800}-\u{1D9FF}\u{1DA37}-\u{1DA3A}\u{1DA6D}-\u{1DA74}\u{1DA76}-\u{1DA83}\u{1DA85}-\u{1DA8B}\u{1E100}-\u{1E12C}\u{1E137}-\u{1E13D}\u{1E140}-\u{1E149}\u{1E14E}\u{1E14F}\u{1E2C0}-\u{1E2EB}\u{1E2F0}-\u{1E2F9}\u{1F110}-\u{1F12E}\u{1F130}-\u{1F169}\u{1F170}-\u{1F1AC}\u{1F1E6}-\u{1F202}\u{1F210}-\u{1F23B}\u{1F240}-\u{1F248}\u{1F250}\u{1F251}\u{20000}-\u{2A6DD}\u{2A700}-\u{2B734}\u{2B740}-\u{2B81D}\u{2B820}-\u{2CEA1}\u{2CEB0}-\u{2EBE0}\u{2F800}-\u{2FA1D}\u{30000}-\u{3134A}\u{F0000}-\u{FFFFD}\u{100000}-\u{10FFFD}]/u;
  const bidiS1RTL = /[\u05BE\u05C0\u05C3\u05C6\u05D0-\u05EA\u05EF-\u05F4\u0608\u060B\u060D\u061B\u061C\u061E-\u064A\u066D-\u066F\u0671-\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u070D\u070F\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07C0-\u07EA\u07F4\u07F5\u07FA\u07FE-\u0815\u081A\u0824\u0828\u0830-\u083E\u0840-\u0858\u085E\u0860-\u086A\u08A0-\u08B4\u08B6-\u08C7\u200F\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBC1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFC\uFE70-\uFE74\uFE76-\uFEFC\u{10800}-\u{10805}\u{10808}\u{1080A}-\u{10835}\u{10837}\u{10838}\u{1083C}\u{1083F}-\u{10855}\u{10857}-\u{1089E}\u{108A7}-\u{108AF}\u{108E0}-\u{108F2}\u{108F4}\u{108F5}\u{108FB}-\u{1091B}\u{10920}-\u{10939}\u{1093F}\u{10980}-\u{109B7}\u{109BC}-\u{109CF}\u{109D2}-\u{10A00}\u{10A10}-\u{10A13}\u{10A15}-\u{10A17}\u{10A19}-\u{10A35}\u{10A40}-\u{10A48}\u{10A50}-\u{10A58}\u{10A60}-\u{10A9F}\u{10AC0}-\u{10AE4}\u{10AEB}-\u{10AF6}\u{10B00}-\u{10B35}\u{10B40}-\u{10B55}\u{10B58}-\u{10B72}\u{10B78}-\u{10B91}\u{10B99}-\u{10B9C}\u{10BA9}-\u{10BAF}\u{10C00}-\u{10C48}\u{10C80}-\u{10CB2}\u{10CC0}-\u{10CF2}\u{10CFA}-\u{10D23}\u{10E80}-\u{10EA9}\u{10EAD}\u{10EB0}\u{10EB1}\u{10F00}-\u{10F27}\u{10F30}-\u{10F45}\u{10F51}-\u{10F59}\u{10FB0}-\u{10FCB}\u{10FE0}-\u{10FF6}\u{1E800}-\u{1E8C4}\u{1E8C7}-\u{1E8CF}\u{1E900}-\u{1E943}\u{1E94B}\u{1E950}-\u{1E959}\u{1E95E}\u{1E95F}\u{1EC71}-\u{1ECB4}\u{1ED01}-\u{1ED3D}\u{1EE00}-\u{1EE03}\u{1EE05}-\u{1EE1F}\u{1EE21}\u{1EE22}\u{1EE24}\u{1EE27}\u{1EE29}-\u{1EE32}\u{1EE34}-\u{1EE37}\u{1EE39}\u{1EE3B}\u{1EE42}\u{1EE47}\u{1EE49}\u{1EE4B}\u{1EE4D}-\u{1EE4F}\u{1EE51}\u{1EE52}\u{1EE54}\u{1EE57}\u{1EE59}\u{1EE5B}\u{1EE5D}\u{1EE5F}\u{1EE61}\u{1EE62}\u{1EE64}\u{1EE67}-\u{1EE6A}\u{1EE6C}-\u{1EE72}\u{1EE74}-\u{1EE77}\u{1EE79}-\u{1EE7C}\u{1EE7E}\u{1EE80}-\u{1EE89}\u{1EE8B}-\u{1EE9B}\u{1EEA1}-\u{1EEA3}\u{1EEA5}-\u{1EEA9}\u{1EEAB}-\u{1EEBB}]/u;
  const bidiS2 = /^[\0-\x08\x0E-\x1B!-@\[-`\{-\x84\x86-\xA9\xAB-\xB4\xB6-\xB9\xBB-\xBF\xD7\xF7\u02B9\u02BA\u02C2-\u02CF\u02D2-\u02DF\u02E5-\u02ED\u02EF-\u036F\u0374\u0375\u037E\u0384\u0385\u0387\u03F6\u0483-\u0489\u058A\u058D-\u058F\u0591-\u05C7\u05D0-\u05EA\u05EF-\u05F4\u0600-\u061C\u061E-\u070D\u070F-\u074A\u074D-\u07B1\u07C0-\u07FA\u07FD-\u082D\u0830-\u083E\u0840-\u085B\u085E\u0860-\u086A\u08A0-\u08B4\u08B6-\u08C7\u08D3-\u0902\u093A\u093C\u0941-\u0948\u094D\u0951-\u0957\u0962\u0963\u0981\u09BC\u09C1-\u09C4\u09CD\u09E2\u09E3\u09F2\u09F3\u09FB\u09FE\u0A01\u0A02\u0A3C\u0A41\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A70\u0A71\u0A75\u0A81\u0A82\u0ABC\u0AC1-\u0AC5\u0AC7\u0AC8\u0ACD\u0AE2\u0AE3\u0AF1\u0AFA-\u0AFF\u0B01\u0B3C\u0B3F\u0B41-\u0B44\u0B4D\u0B55\u0B56\u0B62\u0B63\u0B82\u0BC0\u0BCD\u0BF3-\u0BFA\u0C00\u0C04\u0C3E-\u0C40\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C62\u0C63\u0C78-\u0C7E\u0C81\u0CBC\u0CCC\u0CCD\u0CE2\u0CE3\u0D00\u0D01\u0D3B\u0D3C\u0D41-\u0D44\u0D4D\u0D62\u0D63\u0D81\u0DCA\u0DD2-\u0DD4\u0DD6\u0E31\u0E34-\u0E3A\u0E3F\u0E47-\u0E4E\u0EB1\u0EB4-\u0EBC\u0EC8-\u0ECD\u0F18\u0F19\u0F35\u0F37\u0F39-\u0F3D\u0F71-\u0F7E\u0F80-\u0F84\u0F86\u0F87\u0F8D-\u0F97\u0F99-\u0FBC\u0FC6\u102D-\u1030\u1032-\u1037\u1039\u103A\u103D\u103E\u1058\u1059\u105E-\u1060\u1071-\u1074\u1082\u1085\u1086\u108D\u109D\u135D-\u135F\u1390-\u1399\u1400\u169B\u169C\u1712-\u1714\u1732-\u1734\u1752\u1753\u1772\u1773\u17B4\u17B5\u17B7-\u17BD\u17C6\u17C9-\u17D3\u17DB\u17DD\u17F0-\u17F9\u1800-\u180E\u1885\u1886\u18A9\u1920-\u1922\u1927\u1928\u1932\u1939-\u193B\u1940\u1944\u1945\u19DE-\u19FF\u1A17\u1A18\u1A1B\u1A56\u1A58-\u1A5E\u1A60\u1A62\u1A65-\u1A6C\u1A73-\u1A7C\u1A7F\u1AB0-\u1AC0\u1B00-\u1B03\u1B34\u1B36-\u1B3A\u1B3C\u1B42\u1B6B-\u1B73\u1B80\u1B81\u1BA2-\u1BA5\u1BA8\u1BA9\u1BAB-\u1BAD\u1BE6\u1BE8\u1BE9\u1BED\u1BEF-\u1BF1\u1C2C-\u1C33\u1C36\u1C37\u1CD0-\u1CD2\u1CD4-\u1CE0\u1CE2-\u1CE8\u1CED\u1CF4\u1CF8\u1CF9\u1DC0-\u1DF9\u1DFB-\u1DFF\u1FBD\u1FBF-\u1FC1\u1FCD-\u1FCF\u1FDD-\u1FDF\u1FED-\u1FEF\u1FFD\u1FFE\u200B-\u200D\u200F-\u2027\u202F-\u205E\u2060-\u2064\u206A-\u2070\u2074-\u207E\u2080-\u208E\u20A0-\u20BF\u20D0-\u20F0\u2100\u2101\u2103-\u2106\u2108\u2109\u2114\u2116-\u2118\u211E-\u2123\u2125\u2127\u2129\u212E\u213A\u213B\u2140-\u2144\u214A-\u214D\u2150-\u215F\u2189-\u218B\u2190-\u2335\u237B-\u2394\u2396-\u2426\u2440-\u244A\u2460-\u249B\u24EA-\u26AB\u26AD-\u27FF\u2900-\u2B73\u2B76-\u2B95\u2B97-\u2BFF\u2CE5-\u2CEA\u2CEF-\u2CF1\u2CF9-\u2CFF\u2D7F\u2DE0-\u2E52\u2E80-\u2E99\u2E9B-\u2EF3\u2F00-\u2FD5\u2FF0-\u2FFB\u3001-\u3004\u3008-\u3020\u302A-\u302D\u3030\u3036\u3037\u303D-\u303F\u3099-\u309C\u30A0\u30FB\u31C0-\u31E3\u321D\u321E\u3250-\u325F\u327C-\u327E\u32B1-\u32BF\u32CC-\u32CF\u3377-\u337A\u33DE\u33DF\u33FF\u4DC0-\u4DFF\uA490-\uA4C6\uA60D-\uA60F\uA66F-\uA67F\uA69E\uA69F\uA6F0\uA6F1\uA700-\uA721\uA788\uA802\uA806\uA80B\uA825\uA826\uA828-\uA82C\uA838\uA839\uA874-\uA877\uA8C4\uA8C5\uA8E0-\uA8F1\uA8FF\uA926-\uA92D\uA947-\uA951\uA980-\uA982\uA9B3\uA9B6-\uA9B9\uA9BC\uA9BD\uA9E5\uAA29-\uAA2E\uAA31\uAA32\uAA35\uAA36\uAA43\uAA4C\uAA7C\uAAB0\uAAB2-\uAAB4\uAAB7\uAAB8\uAABE\uAABF\uAAC1\uAAEC\uAAED\uAAF6\uAB6A\uAB6B\uABE5\uABE8\uABED\uFB1D-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBC1\uFBD3-\uFD3F\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFD\uFE00-\uFE19\uFE20-\uFE52\uFE54-\uFE66\uFE68-\uFE6B\uFE70-\uFE74\uFE76-\uFEFC\uFEFF\uFF01-\uFF20\uFF3B-\uFF40\uFF5B-\uFF65\uFFE0-\uFFE6\uFFE8-\uFFEE\uFFF9-\uFFFD\u{10101}\u{10140}-\u{1018C}\u{10190}-\u{1019C}\u{101A0}\u{101FD}\u{102E0}-\u{102FB}\u{10376}-\u{1037A}\u{10800}-\u{10805}\u{10808}\u{1080A}-\u{10835}\u{10837}\u{10838}\u{1083C}\u{1083F}-\u{10855}\u{10857}-\u{1089E}\u{108A7}-\u{108AF}\u{108E0}-\u{108F2}\u{108F4}\u{108F5}\u{108FB}-\u{1091B}\u{1091F}-\u{10939}\u{1093F}\u{10980}-\u{109B7}\u{109BC}-\u{109CF}\u{109D2}-\u{10A03}\u{10A05}\u{10A06}\u{10A0C}-\u{10A13}\u{10A15}-\u{10A17}\u{10A19}-\u{10A35}\u{10A38}-\u{10A3A}\u{10A3F}-\u{10A48}\u{10A50}-\u{10A58}\u{10A60}-\u{10A9F}\u{10AC0}-\u{10AE6}\u{10AEB}-\u{10AF6}\u{10B00}-\u{10B35}\u{10B39}-\u{10B55}\u{10B58}-\u{10B72}\u{10B78}-\u{10B91}\u{10B99}-\u{10B9C}\u{10BA9}-\u{10BAF}\u{10C00}-\u{10C48}\u{10C80}-\u{10CB2}\u{10CC0}-\u{10CF2}\u{10CFA}-\u{10D27}\u{10D30}-\u{10D39}\u{10E60}-\u{10E7E}\u{10E80}-\u{10EA9}\u{10EAB}-\u{10EAD}\u{10EB0}\u{10EB1}\u{10F00}-\u{10F27}\u{10F30}-\u{10F59}\u{10FB0}-\u{10FCB}\u{10FE0}-\u{10FF6}\u{11001}\u{11038}-\u{11046}\u{11052}-\u{11065}\u{1107F}-\u{11081}\u{110B3}-\u{110B6}\u{110B9}\u{110BA}\u{11100}-\u{11102}\u{11127}-\u{1112B}\u{1112D}-\u{11134}\u{11173}\u{11180}\u{11181}\u{111B6}-\u{111BE}\u{111C9}-\u{111CC}\u{111CF}\u{1122F}-\u{11231}\u{11234}\u{11236}\u{11237}\u{1123E}\u{112DF}\u{112E3}-\u{112EA}\u{11300}\u{11301}\u{1133B}\u{1133C}\u{11340}\u{11366}-\u{1136C}\u{11370}-\u{11374}\u{11438}-\u{1143F}\u{11442}-\u{11444}\u{11446}\u{1145E}\u{114B3}-\u{114B8}\u{114BA}\u{114BF}\u{114C0}\u{114C2}\u{114C3}\u{115B2}-\u{115B5}\u{115BC}\u{115BD}\u{115BF}\u{115C0}\u{115DC}\u{115DD}\u{11633}-\u{1163A}\u{1163D}\u{1163F}\u{11640}\u{11660}-\u{1166C}\u{116AB}\u{116AD}\u{116B0}-\u{116B5}\u{116B7}\u{1171D}-\u{1171F}\u{11722}-\u{11725}\u{11727}-\u{1172B}\u{1182F}-\u{11837}\u{11839}\u{1183A}\u{1193B}\u{1193C}\u{1193E}\u{11943}\u{119D4}-\u{119D7}\u{119DA}\u{119DB}\u{119E0}\u{11A01}-\u{11A06}\u{11A09}\u{11A0A}\u{11A33}-\u{11A38}\u{11A3B}-\u{11A3E}\u{11A47}\u{11A51}-\u{11A56}\u{11A59}-\u{11A5B}\u{11A8A}-\u{11A96}\u{11A98}\u{11A99}\u{11C30}-\u{11C36}\u{11C38}-\u{11C3D}\u{11C92}-\u{11CA7}\u{11CAA}-\u{11CB0}\u{11CB2}\u{11CB3}\u{11CB5}\u{11CB6}\u{11D31}-\u{11D36}\u{11D3A}\u{11D3C}\u{11D3D}\u{11D3F}-\u{11D45}\u{11D47}\u{11D90}\u{11D91}\u{11D95}\u{11D97}\u{11EF3}\u{11EF4}\u{11FD5}-\u{11FF1}\u{16AF0}-\u{16AF4}\u{16B30}-\u{16B36}\u{16F4F}\u{16F8F}-\u{16F92}\u{16FE2}\u{16FE4}\u{1BC9D}\u{1BC9E}\u{1BCA0}-\u{1BCA3}\u{1D167}-\u{1D169}\u{1D173}-\u{1D182}\u{1D185}-\u{1D18B}\u{1D1AA}-\u{1D1AD}\u{1D200}-\u{1D245}\u{1D300}-\u{1D356}\u{1D6DB}\u{1D715}\u{1D74F}\u{1D789}\u{1D7C3}\u{1D7CE}-\u{1D7FF}\u{1DA00}-\u{1DA36}\u{1DA3B}-\u{1DA6C}\u{1DA75}\u{1DA84}\u{1DA9B}-\u{1DA9F}\u{1DAA1}-\u{1DAAF}\u{1E000}-\u{1E006}\u{1E008}-\u{1E018}\u{1E01B}-\u{1E021}\u{1E023}\u{1E024}\u{1E026}-\u{1E02A}\u{1E130}-\u{1E136}\u{1E2EC}-\u{1E2EF}\u{1E2FF}\u{1E800}-\u{1E8C4}\u{1E8C7}-\u{1E8D6}\u{1E900}-\u{1E94B}\u{1E950}-\u{1E959}\u{1E95E}\u{1E95F}\u{1EC71}-\u{1ECB4}\u{1ED01}-\u{1ED3D}\u{1EE00}-\u{1EE03}\u{1EE05}-\u{1EE1F}\u{1EE21}\u{1EE22}\u{1EE24}\u{1EE27}\u{1EE29}-\u{1EE32}\u{1EE34}-\u{1EE37}\u{1EE39}\u{1EE3B}\u{1EE42}\u{1EE47}\u{1EE49}\u{1EE4B}\u{1EE4D}-\u{1EE4F}\u{1EE51}\u{1EE52}\u{1EE54}\u{1EE57}\u{1EE59}\u{1EE5B}\u{1EE5D}\u{1EE5F}\u{1EE61}\u{1EE62}\u{1EE64}\u{1EE67}-\u{1EE6A}\u{1EE6C}-\u{1EE72}\u{1EE74}-\u{1EE77}\u{1EE79}-\u{1EE7C}\u{1EE7E}\u{1EE80}-\u{1EE89}\u{1EE8B}-\u{1EE9B}\u{1EEA1}-\u{1EEA3}\u{1EEA5}-\u{1EEA9}\u{1EEAB}-\u{1EEBB}\u{1EEF0}\u{1EEF1}\u{1F000}-\u{1F02B}\u{1F030}-\u{1F093}\u{1F0A0}-\u{1F0AE}\u{1F0B1}-\u{1F0BF}\u{1F0C1}-\u{1F0CF}\u{1F0D1}-\u{1F0F5}\u{1F100}-\u{1F10F}\u{1F12F}\u{1F16A}-\u{1F16F}\u{1F1AD}\u{1F260}-\u{1F265}\u{1F300}-\u{1F6D7}\u{1F6E0}-\u{1F6EC}\u{1F6F0}-\u{1F6FC}\u{1F700}-\u{1F773}\u{1F780}-\u{1F7D8}\u{1F7E0}-\u{1F7EB}\u{1F800}-\u{1F80B}\u{1F810}-\u{1F847}\u{1F850}-\u{1F859}\u{1F860}-\u{1F887}\u{1F890}-\u{1F8AD}\u{1F8B0}\u{1F8B1}\u{1F900}-\u{1F978}\u{1F97A}-\u{1F9CB}\u{1F9CD}-\u{1FA53}\u{1FA60}-\u{1FA6D}\u{1FA70}-\u{1FA74}\u{1FA78}-\u{1FA7A}\u{1FA80}-\u{1FA86}\u{1FA90}-\u{1FAA8}\u{1FAB0}-\u{1FAB6}\u{1FAC0}-\u{1FAC2}\u{1FAD0}-\u{1FAD6}\u{1FB00}-\u{1FB92}\u{1FB94}-\u{1FBCA}\u{1FBF0}-\u{1FBF9}\u{E0001}\u{E0020}-\u{E007F}\u{E0100}-\u{E01EF}]*$/u;
  const bidiS3 = /[0-9\xB2\xB3\xB9\u05BE\u05C0\u05C3\u05C6\u05D0-\u05EA\u05EF-\u05F4\u0600-\u0605\u0608\u060B\u060D\u061B\u061C\u061E-\u064A\u0660-\u0669\u066B-\u066F\u0671-\u06D5\u06DD\u06E5\u06E6\u06EE-\u070D\u070F\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07C0-\u07EA\u07F4\u07F5\u07FA\u07FE-\u0815\u081A\u0824\u0828\u0830-\u083E\u0840-\u0858\u085E\u0860-\u086A\u08A0-\u08B4\u08B6-\u08C7\u08E2\u200F\u2070\u2074-\u2079\u2080-\u2089\u2488-\u249B\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBC1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFC\uFE70-\uFE74\uFE76-\uFEFC\uFF10-\uFF19\u{102E1}-\u{102FB}\u{10800}-\u{10805}\u{10808}\u{1080A}-\u{10835}\u{10837}\u{10838}\u{1083C}\u{1083F}-\u{10855}\u{10857}-\u{1089E}\u{108A7}-\u{108AF}\u{108E0}-\u{108F2}\u{108F4}\u{108F5}\u{108FB}-\u{1091B}\u{10920}-\u{10939}\u{1093F}\u{10980}-\u{109B7}\u{109BC}-\u{109CF}\u{109D2}-\u{10A00}\u{10A10}-\u{10A13}\u{10A15}-\u{10A17}\u{10A19}-\u{10A35}\u{10A40}-\u{10A48}\u{10A50}-\u{10A58}\u{10A60}-\u{10A9F}\u{10AC0}-\u{10AE4}\u{10AEB}-\u{10AF6}\u{10B00}-\u{10B35}\u{10B40}-\u{10B55}\u{10B58}-\u{10B72}\u{10B78}-\u{10B91}\u{10B99}-\u{10B9C}\u{10BA9}-\u{10BAF}\u{10C00}-\u{10C48}\u{10C80}-\u{10CB2}\u{10CC0}-\u{10CF2}\u{10CFA}-\u{10D23}\u{10D30}-\u{10D39}\u{10E60}-\u{10E7E}\u{10E80}-\u{10EA9}\u{10EAD}\u{10EB0}\u{10EB1}\u{10F00}-\u{10F27}\u{10F30}-\u{10F45}\u{10F51}-\u{10F59}\u{10FB0}-\u{10FCB}\u{10FE0}-\u{10FF6}\u{1D7CE}-\u{1D7FF}\u{1E800}-\u{1E8C4}\u{1E8C7}-\u{1E8CF}\u{1E900}-\u{1E943}\u{1E94B}\u{1E950}-\u{1E959}\u{1E95E}\u{1E95F}\u{1EC71}-\u{1ECB4}\u{1ED01}-\u{1ED3D}\u{1EE00}-\u{1EE03}\u{1EE05}-\u{1EE1F}\u{1EE21}\u{1EE22}\u{1EE24}\u{1EE27}\u{1EE29}-\u{1EE32}\u{1EE34}-\u{1EE37}\u{1EE39}\u{1EE3B}\u{1EE42}\u{1EE47}\u{1EE49}\u{1EE4B}\u{1EE4D}-\u{1EE4F}\u{1EE51}\u{1EE52}\u{1EE54}\u{1EE57}\u{1EE59}\u{1EE5B}\u{1EE5D}\u{1EE5F}\u{1EE61}\u{1EE62}\u{1EE64}\u{1EE67}-\u{1EE6A}\u{1EE6C}-\u{1EE72}\u{1EE74}-\u{1EE77}\u{1EE79}-\u{1EE7C}\u{1EE7E}\u{1EE80}-\u{1EE89}\u{1EE8B}-\u{1EE9B}\u{1EEA1}-\u{1EEA3}\u{1EEA5}-\u{1EEA9}\u{1EEAB}-\u{1EEBB}\u{1F100}-\u{1F10A}\u{1FBF0}-\u{1FBF9}][\u0300-\u036F\u0483-\u0489\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u0610-\u061A\u064B-\u065F\u0670\u06D6-\u06DC\u06DF-\u06E4\u06E7\u06E8\u06EA-\u06ED\u0711\u0730-\u074A\u07A6-\u07B0\u07EB-\u07F3\u07FD\u0816-\u0819\u081B-\u0823\u0825-\u0827\u0829-\u082D\u0859-\u085B\u08D3-\u08E1\u08E3-\u0902\u093A\u093C\u0941-\u0948\u094D\u0951-\u0957\u0962\u0963\u0981\u09BC\u09C1-\u09C4\u09CD\u09E2\u09E3\u09FE\u0A01\u0A02\u0A3C\u0A41\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A70\u0A71\u0A75\u0A81\u0A82\u0ABC\u0AC1-\u0AC5\u0AC7\u0AC8\u0ACD\u0AE2\u0AE3\u0AFA-\u0AFF\u0B01\u0B3C\u0B3F\u0B41-\u0B44\u0B4D\u0B55\u0B56\u0B62\u0B63\u0B82\u0BC0\u0BCD\u0C00\u0C04\u0C3E-\u0C40\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C62\u0C63\u0C81\u0CBC\u0CCC\u0CCD\u0CE2\u0CE3\u0D00\u0D01\u0D3B\u0D3C\u0D41-\u0D44\u0D4D\u0D62\u0D63\u0D81\u0DCA\u0DD2-\u0DD4\u0DD6\u0E31\u0E34-\u0E3A\u0E47-\u0E4E\u0EB1\u0EB4-\u0EBC\u0EC8-\u0ECD\u0F18\u0F19\u0F35\u0F37\u0F39\u0F71-\u0F7E\u0F80-\u0F84\u0F86\u0F87\u0F8D-\u0F97\u0F99-\u0FBC\u0FC6\u102D-\u1030\u1032-\u1037\u1039\u103A\u103D\u103E\u1058\u1059\u105E-\u1060\u1071-\u1074\u1082\u1085\u1086\u108D\u109D\u135D-\u135F\u1712-\u1714\u1732-\u1734\u1752\u1753\u1772\u1773\u17B4\u17B5\u17B7-\u17BD\u17C6\u17C9-\u17D3\u17DD\u180B-\u180D\u1885\u1886\u18A9\u1920-\u1922\u1927\u1928\u1932\u1939-\u193B\u1A17\u1A18\u1A1B\u1A56\u1A58-\u1A5E\u1A60\u1A62\u1A65-\u1A6C\u1A73-\u1A7C\u1A7F\u1AB0-\u1AC0\u1B00-\u1B03\u1B34\u1B36-\u1B3A\u1B3C\u1B42\u1B6B-\u1B73\u1B80\u1B81\u1BA2-\u1BA5\u1BA8\u1BA9\u1BAB-\u1BAD\u1BE6\u1BE8\u1BE9\u1BED\u1BEF-\u1BF1\u1C2C-\u1C33\u1C36\u1C37\u1CD0-\u1CD2\u1CD4-\u1CE0\u1CE2-\u1CE8\u1CED\u1CF4\u1CF8\u1CF9\u1DC0-\u1DF9\u1DFB-\u1DFF\u20D0-\u20F0\u2CEF-\u2CF1\u2D7F\u2DE0-\u2DFF\u302A-\u302D\u3099\u309A\uA66F-\uA672\uA674-\uA67D\uA69E\uA69F\uA6F0\uA6F1\uA802\uA806\uA80B\uA825\uA826\uA82C\uA8C4\uA8C5\uA8E0-\uA8F1\uA8FF\uA926-\uA92D\uA947-\uA951\uA980-\uA982\uA9B3\uA9B6-\uA9B9\uA9BC\uA9BD\uA9E5\uAA29-\uAA2E\uAA31\uAA32\uAA35\uAA36\uAA43\uAA4C\uAA7C\uAAB0\uAAB2-\uAAB4\uAAB7\uAAB8\uAABE\uAABF\uAAC1\uAAEC\uAAED\uAAF6\uABE5\uABE8\uABED\uFB1E\uFE00-\uFE0F\uFE20-\uFE2F\u{101FD}\u{102E0}\u{10376}-\u{1037A}\u{10A01}-\u{10A03}\u{10A05}\u{10A06}\u{10A0C}-\u{10A0F}\u{10A38}-\u{10A3A}\u{10A3F}\u{10AE5}\u{10AE6}\u{10D24}-\u{10D27}\u{10EAB}\u{10EAC}\u{10F46}-\u{10F50}\u{11001}\u{11038}-\u{11046}\u{1107F}-\u{11081}\u{110B3}-\u{110B6}\u{110B9}\u{110BA}\u{11100}-\u{11102}\u{11127}-\u{1112B}\u{1112D}-\u{11134}\u{11173}\u{11180}\u{11181}\u{111B6}-\u{111BE}\u{111C9}-\u{111CC}\u{111CF}\u{1122F}-\u{11231}\u{11234}\u{11236}\u{11237}\u{1123E}\u{112DF}\u{112E3}-\u{112EA}\u{11300}\u{11301}\u{1133B}\u{1133C}\u{11340}\u{11366}-\u{1136C}\u{11370}-\u{11374}\u{11438}-\u{1143F}\u{11442}-\u{11444}\u{11446}\u{1145E}\u{114B3}-\u{114B8}\u{114BA}\u{114BF}\u{114C0}\u{114C2}\u{114C3}\u{115B2}-\u{115B5}\u{115BC}\u{115BD}\u{115BF}\u{115C0}\u{115DC}\u{115DD}\u{11633}-\u{1163A}\u{1163D}\u{1163F}\u{11640}\u{116AB}\u{116AD}\u{116B0}-\u{116B5}\u{116B7}\u{1171D}-\u{1171F}\u{11722}-\u{11725}\u{11727}-\u{1172B}\u{1182F}-\u{11837}\u{11839}\u{1183A}\u{1193B}\u{1193C}\u{1193E}\u{11943}\u{119D4}-\u{119D7}\u{119DA}\u{119DB}\u{119E0}\u{11A01}-\u{11A06}\u{11A09}\u{11A0A}\u{11A33}-\u{11A38}\u{11A3B}-\u{11A3E}\u{11A47}\u{11A51}-\u{11A56}\u{11A59}-\u{11A5B}\u{11A8A}-\u{11A96}\u{11A98}\u{11A99}\u{11C30}-\u{11C36}\u{11C38}-\u{11C3D}\u{11C92}-\u{11CA7}\u{11CAA}-\u{11CB0}\u{11CB2}\u{11CB3}\u{11CB5}\u{11CB6}\u{11D31}-\u{11D36}\u{11D3A}\u{11D3C}\u{11D3D}\u{11D3F}-\u{11D45}\u{11D47}\u{11D90}\u{11D91}\u{11D95}\u{11D97}\u{11EF3}\u{11EF4}\u{16AF0}-\u{16AF4}\u{16B30}-\u{16B36}\u{16F4F}\u{16F8F}-\u{16F92}\u{16FE4}\u{1BC9D}\u{1BC9E}\u{1D167}-\u{1D169}\u{1D17B}-\u{1D182}\u{1D185}-\u{1D18B}\u{1D1AA}-\u{1D1AD}\u{1D242}-\u{1D244}\u{1DA00}-\u{1DA36}\u{1DA3B}-\u{1DA6C}\u{1DA75}\u{1DA84}\u{1DA9B}-\u{1DA9F}\u{1DAA1}-\u{1DAAF}\u{1E000}-\u{1E006}\u{1E008}-\u{1E018}\u{1E01B}-\u{1E021}\u{1E023}\u{1E024}\u{1E026}-\u{1E02A}\u{1E130}-\u{1E136}\u{1E2EC}-\u{1E2EF}\u{1E8D0}-\u{1E8D6}\u{1E944}-\u{1E94A}\u{E0100}-\u{E01EF}]*$/u;
  const bidiS4EN = /[0-9\xB2\xB3\xB9\u06F0-\u06F9\u2070\u2074-\u2079\u2080-\u2089\u2488-\u249B\uFF10-\uFF19\u{102E1}-\u{102FB}\u{1D7CE}-\u{1D7FF}\u{1F100}-\u{1F10A}\u{1FBF0}-\u{1FBF9}]/u;
  const bidiS4AN = /[\u0600-\u0605\u0660-\u0669\u066B\u066C\u06DD\u08E2\u{10D30}-\u{10D39}\u{10E60}-\u{10E7E}]/u;
  const bidiS5 = /^[\0-\x08\x0E-\x1B!-\x84\x86-\u0377\u037A-\u037F\u0384-\u038A\u038C\u038E-\u03A1\u03A3-\u052F\u0531-\u0556\u0559-\u058A\u058D-\u058F\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u0606\u0607\u0609\u060A\u060C\u060E-\u061A\u064B-\u065F\u066A\u0670\u06D6-\u06DC\u06DE-\u06E4\u06E7-\u06ED\u06F0-\u06F9\u0711\u0730-\u074A\u07A6-\u07B0\u07EB-\u07F3\u07F6-\u07F9\u07FD\u0816-\u0819\u081B-\u0823\u0825-\u0827\u0829-\u082D\u0859-\u085B\u08D3-\u08E1\u08E3-\u0983\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BC-\u09C4\u09C7\u09C8\u09CB-\u09CE\u09D7\u09DC\u09DD\u09DF-\u09E3\u09E6-\u09FE\u0A01-\u0A03\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A3C\u0A3E-\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A59-\u0A5C\u0A5E\u0A66-\u0A76\u0A81-\u0A83\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABC-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACD\u0AD0\u0AE0-\u0AE3\u0AE6-\u0AF1\u0AF9-\u0AFF\u0B01-\u0B03\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3C-\u0B44\u0B47\u0B48\u0B4B-\u0B4D\u0B55-\u0B57\u0B5C\u0B5D\u0B5F-\u0B63\u0B66-\u0B77\u0B82\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD\u0BD0\u0BD7\u0BE6-\u0BFA\u0C00-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C58-\u0C5A\u0C60-\u0C63\u0C66-\u0C6F\u0C77-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBC-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5\u0CD6\u0CDE\u0CE0-\u0CE3\u0CE6-\u0CEF\u0CF1\u0CF2\u0D00-\u0D0C\u0D0E-\u0D10\u0D12-\u0D44\u0D46-\u0D48\u0D4A-\u0D4F\u0D54-\u0D63\u0D66-\u0D7F\u0D81-\u0D83\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DE6-\u0DEF\u0DF2-\u0DF4\u0E01-\u0E3A\u0E3F-\u0E5B\u0E81\u0E82\u0E84\u0E86-\u0E8A\u0E8C-\u0EA3\u0EA5\u0EA7-\u0EBD\u0EC0-\u0EC4\u0EC6\u0EC8-\u0ECD\u0ED0-\u0ED9\u0EDC-\u0EDF\u0F00-\u0F47\u0F49-\u0F6C\u0F71-\u0F97\u0F99-\u0FBC\u0FBE-\u0FCC\u0FCE-\u0FDA\u1000-\u10C5\u10C7\u10CD\u10D0-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u135D-\u137C\u1380-\u1399\u13A0-\u13F5\u13F8-\u13FD\u1400-\u167F\u1681-\u169C\u16A0-\u16F8\u1700-\u170C\u170E-\u1714\u1720-\u1736\u1740-\u1753\u1760-\u176C\u176E-\u1770\u1772\u1773\u1780-\u17DD\u17E0-\u17E9\u17F0-\u17F9\u1800-\u180E\u1810-\u1819\u1820-\u1878\u1880-\u18AA\u18B0-\u18F5\u1900-\u191E\u1920-\u192B\u1930-\u193B\u1940\u1944-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u19D0-\u19DA\u19DE-\u1A1B\u1A1E-\u1A5E\u1A60-\u1A7C\u1A7F-\u1A89\u1A90-\u1A99\u1AA0-\u1AAD\u1AB0-\u1AC0\u1B00-\u1B4B\u1B50-\u1B7C\u1B80-\u1BF3\u1BFC-\u1C37\u1C3B-\u1C49\u1C4D-\u1C88\u1C90-\u1CBA\u1CBD-\u1CC7\u1CD0-\u1CFA\u1D00-\u1DF9\u1DFB-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FC4\u1FC6-\u1FD3\u1FD6-\u1FDB\u1FDD-\u1FEF\u1FF2-\u1FF4\u1FF6-\u1FFE\u200B-\u200E\u2010-\u2027\u202F-\u205E\u2060-\u2064\u206A-\u2071\u2074-\u208E\u2090-\u209C\u20A0-\u20BF\u20D0-\u20F0\u2100-\u218B\u2190-\u2426\u2440-\u244A\u2460-\u2B73\u2B76-\u2B95\u2B97-\u2C2E\u2C30-\u2C5E\u2C60-\u2CF3\u2CF9-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D70\u2D7F-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2DE0-\u2E52\u2E80-\u2E99\u2E9B-\u2EF3\u2F00-\u2FD5\u2FF0-\u2FFB\u3001-\u303F\u3041-\u3096\u3099-\u30FF\u3105-\u312F\u3131-\u318E\u3190-\u31E3\u31F0-\u321E\u3220-\u9FFC\uA000-\uA48C\uA490-\uA4C6\uA4D0-\uA62B\uA640-\uA6F7\uA700-\uA7BF\uA7C2-\uA7CA\uA7F5-\uA82C\uA830-\uA839\uA840-\uA877\uA880-\uA8C5\uA8CE-\uA8D9\uA8E0-\uA953\uA95F-\uA97C\uA980-\uA9CD\uA9CF-\uA9D9\uA9DE-\uA9FE\uAA00-\uAA36\uAA40-\uAA4D\uAA50-\uAA59\uAA5C-\uAAC2\uAADB-\uAAF6\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB6B\uAB70-\uABED\uABF0-\uABF9\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uD800-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1E\uFB29\uFD3E\uFD3F\uFDFD\uFE00-\uFE19\uFE20-\uFE52\uFE54-\uFE66\uFE68-\uFE6B\uFEFF\uFF01-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC\uFFE0-\uFFE6\uFFE8-\uFFEE\uFFF9-\uFFFD\u{10000}-\u{1000B}\u{1000D}-\u{10026}\u{10028}-\u{1003A}\u{1003C}\u{1003D}\u{1003F}-\u{1004D}\u{10050}-\u{1005D}\u{10080}-\u{100FA}\u{10100}-\u{10102}\u{10107}-\u{10133}\u{10137}-\u{1018E}\u{10190}-\u{1019C}\u{101A0}\u{101D0}-\u{101FD}\u{10280}-\u{1029C}\u{102A0}-\u{102D0}\u{102E0}-\u{102FB}\u{10300}-\u{10323}\u{1032D}-\u{1034A}\u{10350}-\u{1037A}\u{10380}-\u{1039D}\u{1039F}-\u{103C3}\u{103C8}-\u{103D5}\u{10400}-\u{1049D}\u{104A0}-\u{104A9}\u{104B0}-\u{104D3}\u{104D8}-\u{104FB}\u{10500}-\u{10527}\u{10530}-\u{10563}\u{1056F}\u{10600}-\u{10736}\u{10740}-\u{10755}\u{10760}-\u{10767}\u{1091F}\u{10A01}-\u{10A03}\u{10A05}\u{10A06}\u{10A0C}-\u{10A0F}\u{10A38}-\u{10A3A}\u{10A3F}\u{10AE5}\u{10AE6}\u{10B39}-\u{10B3F}\u{10D24}-\u{10D27}\u{10EAB}\u{10EAC}\u{10F46}-\u{10F50}\u{11000}-\u{1104D}\u{11052}-\u{1106F}\u{1107F}-\u{110C1}\u{110CD}\u{110D0}-\u{110E8}\u{110F0}-\u{110F9}\u{11100}-\u{11134}\u{11136}-\u{11147}\u{11150}-\u{11176}\u{11180}-\u{111DF}\u{111E1}-\u{111F4}\u{11200}-\u{11211}\u{11213}-\u{1123E}\u{11280}-\u{11286}\u{11288}\u{1128A}-\u{1128D}\u{1128F}-\u{1129D}\u{1129F}-\u{112A9}\u{112B0}-\u{112EA}\u{112F0}-\u{112F9}\u{11300}-\u{11303}\u{11305}-\u{1130C}\u{1130F}\u{11310}\u{11313}-\u{11328}\u{1132A}-\u{11330}\u{11332}\u{11333}\u{11335}-\u{11339}\u{1133B}-\u{11344}\u{11347}\u{11348}\u{1134B}-\u{1134D}\u{11350}\u{11357}\u{1135D}-\u{11363}\u{11366}-\u{1136C}\u{11370}-\u{11374}\u{11400}-\u{1145B}\u{1145D}-\u{11461}\u{11480}-\u{114C7}\u{114D0}-\u{114D9}\u{11580}-\u{115B5}\u{115B8}-\u{115DD}\u{11600}-\u{11644}\u{11650}-\u{11659}\u{11660}-\u{1166C}\u{11680}-\u{116B8}\u{116C0}-\u{116C9}\u{11700}-\u{1171A}\u{1171D}-\u{1172B}\u{11730}-\u{1173F}\u{11800}-\u{1183B}\u{118A0}-\u{118F2}\u{118FF}-\u{11906}\u{11909}\u{1190C}-\u{11913}\u{11915}\u{11916}\u{11918}-\u{11935}\u{11937}\u{11938}\u{1193B}-\u{11946}\u{11950}-\u{11959}\u{119A0}-\u{119A7}\u{119AA}-\u{119D7}\u{119DA}-\u{119E4}\u{11A00}-\u{11A47}\u{11A50}-\u{11AA2}\u{11AC0}-\u{11AF8}\u{11C00}-\u{11C08}\u{11C0A}-\u{11C36}\u{11C38}-\u{11C45}\u{11C50}-\u{11C6C}\u{11C70}-\u{11C8F}\u{11C92}-\u{11CA7}\u{11CA9}-\u{11CB6}\u{11D00}-\u{11D06}\u{11D08}\u{11D09}\u{11D0B}-\u{11D36}\u{11D3A}\u{11D3C}\u{11D3D}\u{11D3F}-\u{11D47}\u{11D50}-\u{11D59}\u{11D60}-\u{11D65}\u{11D67}\u{11D68}\u{11D6A}-\u{11D8E}\u{11D90}\u{11D91}\u{11D93}-\u{11D98}\u{11DA0}-\u{11DA9}\u{11EE0}-\u{11EF8}\u{11FB0}\u{11FC0}-\u{11FF1}\u{11FFF}-\u{12399}\u{12400}-\u{1246E}\u{12470}-\u{12474}\u{12480}-\u{12543}\u{13000}-\u{1342E}\u{13430}-\u{13438}\u{14400}-\u{14646}\u{16800}-\u{16A38}\u{16A40}-\u{16A5E}\u{16A60}-\u{16A69}\u{16A6E}\u{16A6F}\u{16AD0}-\u{16AED}\u{16AF0}-\u{16AF5}\u{16B00}-\u{16B45}\u{16B50}-\u{16B59}\u{16B5B}-\u{16B61}\u{16B63}-\u{16B77}\u{16B7D}-\u{16B8F}\u{16E40}-\u{16E9A}\u{16F00}-\u{16F4A}\u{16F4F}-\u{16F87}\u{16F8F}-\u{16F9F}\u{16FE0}-\u{16FE4}\u{16FF0}\u{16FF1}\u{17000}-\u{187F7}\u{18800}-\u{18CD5}\u{18D00}-\u{18D08}\u{1B000}-\u{1B11E}\u{1B150}-\u{1B152}\u{1B164}-\u{1B167}\u{1B170}-\u{1B2FB}\u{1BC00}-\u{1BC6A}\u{1BC70}-\u{1BC7C}\u{1BC80}-\u{1BC88}\u{1BC90}-\u{1BC99}\u{1BC9C}-\u{1BCA3}\u{1D000}-\u{1D0F5}\u{1D100}-\u{1D126}\u{1D129}-\u{1D1E8}\u{1D200}-\u{1D245}\u{1D2E0}-\u{1D2F3}\u{1D300}-\u{1D356}\u{1D360}-\u{1D378}\u{1D400}-\u{1D454}\u{1D456}-\u{1D49C}\u{1D49E}\u{1D49F}\u{1D4A2}\u{1D4A5}\u{1D4A6}\u{1D4A9}-\u{1D4AC}\u{1D4AE}-\u{1D4B9}\u{1D4BB}\u{1D4BD}-\u{1D4C3}\u{1D4C5}-\u{1D505}\u{1D507}-\u{1D50A}\u{1D50D}-\u{1D514}\u{1D516}-\u{1D51C}\u{1D51E}-\u{1D539}\u{1D53B}-\u{1D53E}\u{1D540}-\u{1D544}\u{1D546}\u{1D54A}-\u{1D550}\u{1D552}-\u{1D6A5}\u{1D6A8}-\u{1D7CB}\u{1D7CE}-\u{1DA8B}\u{1DA9B}-\u{1DA9F}\u{1DAA1}-\u{1DAAF}\u{1E000}-\u{1E006}\u{1E008}-\u{1E018}\u{1E01B}-\u{1E021}\u{1E023}\u{1E024}\u{1E026}-\u{1E02A}\u{1E100}-\u{1E12C}\u{1E130}-\u{1E13D}\u{1E140}-\u{1E149}\u{1E14E}\u{1E14F}\u{1E2C0}-\u{1E2F9}\u{1E2FF}\u{1E8D0}-\u{1E8D6}\u{1E944}-\u{1E94A}\u{1EEF0}\u{1EEF1}\u{1F000}-\u{1F02B}\u{1F030}-\u{1F093}\u{1F0A0}-\u{1F0AE}\u{1F0B1}-\u{1F0BF}\u{1F0C1}-\u{1F0CF}\u{1F0D1}-\u{1F0F5}\u{1F100}-\u{1F1AD}\u{1F1E6}-\u{1F202}\u{1F210}-\u{1F23B}\u{1F240}-\u{1F248}\u{1F250}\u{1F251}\u{1F260}-\u{1F265}\u{1F300}-\u{1F6D7}\u{1F6E0}-\u{1F6EC}\u{1F6F0}-\u{1F6FC}\u{1F700}-\u{1F773}\u{1F780}-\u{1F7D8}\u{1F7E0}-\u{1F7EB}\u{1F800}-\u{1F80B}\u{1F810}-\u{1F847}\u{1F850}-\u{1F859}\u{1F860}-\u{1F887}\u{1F890}-\u{1F8AD}\u{1F8B0}\u{1F8B1}\u{1F900}-\u{1F978}\u{1F97A}-\u{1F9CB}\u{1F9CD}-\u{1FA53}\u{1FA60}-\u{1FA6D}\u{1FA70}-\u{1FA74}\u{1FA78}-\u{1FA7A}\u{1FA80}-\u{1FA86}\u{1FA90}-\u{1FAA8}\u{1FAB0}-\u{1FAB6}\u{1FAC0}-\u{1FAC2}\u{1FAD0}-\u{1FAD6}\u{1FB00}-\u{1FB92}\u{1FB94}-\u{1FBCA}\u{1FBF0}-\u{1FBF9}\u{20000}-\u{2A6DD}\u{2A700}-\u{2B734}\u{2B740}-\u{2B81D}\u{2B820}-\u{2CEA1}\u{2CEB0}-\u{2EBE0}\u{2F800}-\u{2FA1D}\u{30000}-\u{3134A}\u{E0001}\u{E0020}-\u{E007F}\u{E0100}-\u{E01EF}\u{F0000}-\u{FFFFD}\u{100000}-\u{10FFFD}]*$/u;
  const bidiS6 = /[0-9A-Za-z\xAA\xB2\xB3\xB5\xB9\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02B8\u02BB-\u02C1\u02D0\u02D1\u02E0-\u02E4\u02EE\u0370-\u0373\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0482\u048A-\u052F\u0531-\u0556\u0559-\u0589\u06F0-\u06F9\u0903-\u0939\u093B\u093D-\u0940\u0949-\u094C\u094E-\u0950\u0958-\u0961\u0964-\u0980\u0982\u0983\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD-\u09C0\u09C7\u09C8\u09CB\u09CC\u09CE\u09D7\u09DC\u09DD\u09DF-\u09E1\u09E6-\u09F1\u09F4-\u09FA\u09FC\u09FD\u0A03\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A3E-\u0A40\u0A59-\u0A5C\u0A5E\u0A66-\u0A6F\u0A72-\u0A74\u0A76\u0A83\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD-\u0AC0\u0AC9\u0ACB\u0ACC\u0AD0\u0AE0\u0AE1\u0AE6-\u0AF0\u0AF9\u0B02\u0B03\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B3E\u0B40\u0B47\u0B48\u0B4B\u0B4C\u0B57\u0B5C\u0B5D\u0B5F-\u0B61\u0B66-\u0B77\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BBE\u0BBF\u0BC1\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCC\u0BD0\u0BD7\u0BE6-\u0BF2\u0C01-\u0C03\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C41-\u0C44\u0C58-\u0C5A\u0C60\u0C61\u0C66-\u0C6F\u0C77\u0C7F\u0C80\u0C82-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD-\u0CC4\u0CC6-\u0CC8\u0CCA\u0CCB\u0CD5\u0CD6\u0CDE\u0CE0\u0CE1\u0CE6-\u0CEF\u0CF1\u0CF2\u0D02-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D-\u0D40\u0D46-\u0D48\u0D4A-\u0D4C\u0D4E\u0D4F\u0D54-\u0D61\u0D66-\u0D7F\u0D82\u0D83\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0DCF-\u0DD1\u0DD8-\u0DDF\u0DE6-\u0DEF\u0DF2-\u0DF4\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E4F-\u0E5B\u0E81\u0E82\u0E84\u0E86-\u0E8A\u0E8C-\u0EA3\u0EA5\u0EA7-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0ED0-\u0ED9\u0EDC-\u0EDF\u0F00-\u0F17\u0F1A-\u0F34\u0F36\u0F38\u0F3E-\u0F47\u0F49-\u0F6C\u0F7F\u0F85\u0F88-\u0F8C\u0FBE-\u0FC5\u0FC7-\u0FCC\u0FCE-\u0FDA\u1000-\u102C\u1031\u1038\u103B\u103C\u103F-\u1057\u105A-\u105D\u1061-\u1070\u1075-\u1081\u1083\u1084\u1087-\u108C\u108E-\u109C\u109E-\u10C5\u10C7\u10CD\u10D0-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1360-\u137C\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u167F\u1681-\u169A\u16A0-\u16F8\u1700-\u170C\u170E-\u1711\u1720-\u1731\u1735\u1736\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17B6\u17BE-\u17C5\u17C7\u17C8\u17D4-\u17DA\u17DC\u17E0-\u17E9\u1810-\u1819\u1820-\u1878\u1880-\u1884\u1887-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1923-\u1926\u1929-\u192B\u1930\u1931\u1933-\u1938\u1946-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u19D0-\u19DA\u1A00-\u1A16\u1A19\u1A1A\u1A1E-\u1A55\u1A57\u1A61\u1A63\u1A64\u1A6D-\u1A72\u1A80-\u1A89\u1A90-\u1A99\u1AA0-\u1AAD\u1B04-\u1B33\u1B35\u1B3B\u1B3D-\u1B41\u1B43-\u1B4B\u1B50-\u1B6A\u1B74-\u1B7C\u1B82-\u1BA1\u1BA6\u1BA7\u1BAA\u1BAE-\u1BE5\u1BE7\u1BEA-\u1BEC\u1BEE\u1BF2\u1BF3\u1BFC-\u1C2B\u1C34\u1C35\u1C3B-\u1C49\u1C4D-\u1C88\u1C90-\u1CBA\u1CBD-\u1CC7\u1CD3\u1CE1\u1CE9-\u1CEC\u1CEE-\u1CF3\u1CF5-\u1CF7\u1CFA\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u200E\u2070\u2071\u2074-\u2079\u207F-\u2089\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u214F\u2160-\u2188\u2336-\u237A\u2395\u2488-\u24E9\u26AC\u2800-\u28FF\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D70\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u3005-\u3007\u3021-\u3029\u302E\u302F\u3031-\u3035\u3038-\u303C\u3041-\u3096\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312F\u3131-\u318E\u3190-\u31BF\u31F0-\u321C\u3220-\u324F\u3260-\u327B\u327F-\u32B0\u32C0-\u32CB\u32D0-\u3376\u337B-\u33DD\u33E0-\u33FE\u3400-\u4DBF\u4E00-\u9FFC\uA000-\uA48C\uA4D0-\uA60C\uA610-\uA62B\uA640-\uA66E\uA680-\uA69D\uA6A0-\uA6EF\uA6F2-\uA6F7\uA722-\uA787\uA789-\uA7BF\uA7C2-\uA7CA\uA7F5-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA824\uA827\uA830-\uA837\uA840-\uA873\uA880-\uA8C3\uA8CE-\uA8D9\uA8F2-\uA8FE\uA900-\uA925\uA92E-\uA946\uA952\uA953\uA95F-\uA97C\uA983-\uA9B2\uA9B4\uA9B5\uA9BA\uA9BB\uA9BE-\uA9CD\uA9CF-\uA9D9\uA9DE-\uA9E4\uA9E6-\uA9FE\uAA00-\uAA28\uAA2F\uAA30\uAA33\uAA34\uAA40-\uAA42\uAA44-\uAA4B\uAA4D\uAA50-\uAA59\uAA5C-\uAA7B\uAA7D-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAAEB\uAAEE-\uAAF5\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB69\uAB70-\uABE4\uABE6\uABE7\uABE9-\uABEC\uABF0-\uABF9\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uD800-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFF10-\uFF19\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC\u{10000}-\u{1000B}\u{1000D}-\u{10026}\u{10028}-\u{1003A}\u{1003C}\u{1003D}\u{1003F}-\u{1004D}\u{10050}-\u{1005D}\u{10080}-\u{100FA}\u{10100}\u{10102}\u{10107}-\u{10133}\u{10137}-\u{1013F}\u{1018D}\u{1018E}\u{101D0}-\u{101FC}\u{10280}-\u{1029C}\u{102A0}-\u{102D0}\u{102E1}-\u{102FB}\u{10300}-\u{10323}\u{1032D}-\u{1034A}\u{10350}-\u{10375}\u{10380}-\u{1039D}\u{1039F}-\u{103C3}\u{103C8}-\u{103D5}\u{10400}-\u{1049D}\u{104A0}-\u{104A9}\u{104B0}-\u{104D3}\u{104D8}-\u{104FB}\u{10500}-\u{10527}\u{10530}-\u{10563}\u{1056F}\u{10600}-\u{10736}\u{10740}-\u{10755}\u{10760}-\u{10767}\u{11000}\u{11002}-\u{11037}\u{11047}-\u{1104D}\u{11066}-\u{1106F}\u{11082}-\u{110B2}\u{110B7}\u{110B8}\u{110BB}-\u{110C1}\u{110CD}\u{110D0}-\u{110E8}\u{110F0}-\u{110F9}\u{11103}-\u{11126}\u{1112C}\u{11136}-\u{11147}\u{11150}-\u{11172}\u{11174}-\u{11176}\u{11182}-\u{111B5}\u{111BF}-\u{111C8}\u{111CD}\u{111CE}\u{111D0}-\u{111DF}\u{111E1}-\u{111F4}\u{11200}-\u{11211}\u{11213}-\u{1122E}\u{11232}\u{11233}\u{11235}\u{11238}-\u{1123D}\u{11280}-\u{11286}\u{11288}\u{1128A}-\u{1128D}\u{1128F}-\u{1129D}\u{1129F}-\u{112A9}\u{112B0}-\u{112DE}\u{112E0}-\u{112E2}\u{112F0}-\u{112F9}\u{11302}\u{11303}\u{11305}-\u{1130C}\u{1130F}\u{11310}\u{11313}-\u{11328}\u{1132A}-\u{11330}\u{11332}\u{11333}\u{11335}-\u{11339}\u{1133D}-\u{1133F}\u{11341}-\u{11344}\u{11347}\u{11348}\u{1134B}-\u{1134D}\u{11350}\u{11357}\u{1135D}-\u{11363}\u{11400}-\u{11437}\u{11440}\u{11441}\u{11445}\u{11447}-\u{1145B}\u{1145D}\u{1145F}-\u{11461}\u{11480}-\u{114B2}\u{114B9}\u{114BB}-\u{114BE}\u{114C1}\u{114C4}-\u{114C7}\u{114D0}-\u{114D9}\u{11580}-\u{115B1}\u{115B8}-\u{115BB}\u{115BE}\u{115C1}-\u{115DB}\u{11600}-\u{11632}\u{1163B}\u{1163C}\u{1163E}\u{11641}-\u{11644}\u{11650}-\u{11659}\u{11680}-\u{116AA}\u{116AC}\u{116AE}\u{116AF}\u{116B6}\u{116B8}\u{116C0}-\u{116C9}\u{11700}-\u{1171A}\u{11720}\u{11721}\u{11726}\u{11730}-\u{1173F}\u{11800}-\u{1182E}\u{11838}\u{1183B}\u{118A0}-\u{118F2}\u{118FF}-\u{11906}\u{11909}\u{1190C}-\u{11913}\u{11915}\u{11916}\u{11918}-\u{11935}\u{11937}\u{11938}\u{1193D}\u{1193F}-\u{11942}\u{11944}-\u{11946}\u{11950}-\u{11959}\u{119A0}-\u{119A7}\u{119AA}-\u{119D3}\u{119DC}-\u{119DF}\u{119E1}-\u{119E4}\u{11A00}\u{11A07}\u{11A08}\u{11A0B}-\u{11A32}\u{11A39}\u{11A3A}\u{11A3F}-\u{11A46}\u{11A50}\u{11A57}\u{11A58}\u{11A5C}-\u{11A89}\u{11A97}\u{11A9A}-\u{11AA2}\u{11AC0}-\u{11AF8}\u{11C00}-\u{11C08}\u{11C0A}-\u{11C2F}\u{11C3E}-\u{11C45}\u{11C50}-\u{11C6C}\u{11C70}-\u{11C8F}\u{11CA9}\u{11CB1}\u{11CB4}\u{11D00}-\u{11D06}\u{11D08}\u{11D09}\u{11D0B}-\u{11D30}\u{11D46}\u{11D50}-\u{11D59}\u{11D60}-\u{11D65}\u{11D67}\u{11D68}\u{11D6A}-\u{11D8E}\u{11D93}\u{11D94}\u{11D96}\u{11D98}\u{11DA0}-\u{11DA9}\u{11EE0}-\u{11EF2}\u{11EF5}-\u{11EF8}\u{11FB0}\u{11FC0}-\u{11FD4}\u{11FFF}-\u{12399}\u{12400}-\u{1246E}\u{12470}-\u{12474}\u{12480}-\u{12543}\u{13000}-\u{1342E}\u{13430}-\u{13438}\u{14400}-\u{14646}\u{16800}-\u{16A38}\u{16A40}-\u{16A5E}\u{16A60}-\u{16A69}\u{16A6E}\u{16A6F}\u{16AD0}-\u{16AED}\u{16AF5}\u{16B00}-\u{16B2F}\u{16B37}-\u{16B45}\u{16B50}-\u{16B59}\u{16B5B}-\u{16B61}\u{16B63}-\u{16B77}\u{16B7D}-\u{16B8F}\u{16E40}-\u{16E9A}\u{16F00}-\u{16F4A}\u{16F50}-\u{16F87}\u{16F93}-\u{16F9F}\u{16FE0}\u{16FE1}\u{16FE3}\u{16FF0}\u{16FF1}\u{17000}-\u{187F7}\u{18800}-\u{18CD5}\u{18D00}-\u{18D08}\u{1B000}-\u{1B11E}\u{1B150}-\u{1B152}\u{1B164}-\u{1B167}\u{1B170}-\u{1B2FB}\u{1BC00}-\u{1BC6A}\u{1BC70}-\u{1BC7C}\u{1BC80}-\u{1BC88}\u{1BC90}-\u{1BC99}\u{1BC9C}\u{1BC9F}\u{1D000}-\u{1D0F5}\u{1D100}-\u{1D126}\u{1D129}-\u{1D166}\u{1D16A}-\u{1D172}\u{1D183}\u{1D184}\u{1D18C}-\u{1D1A9}\u{1D1AE}-\u{1D1E8}\u{1D2E0}-\u{1D2F3}\u{1D360}-\u{1D378}\u{1D400}-\u{1D454}\u{1D456}-\u{1D49C}\u{1D49E}\u{1D49F}\u{1D4A2}\u{1D4A5}\u{1D4A6}\u{1D4A9}-\u{1D4AC}\u{1D4AE}-\u{1D4B9}\u{1D4BB}\u{1D4BD}-\u{1D4C3}\u{1D4C5}-\u{1D505}\u{1D507}-\u{1D50A}\u{1D50D}-\u{1D514}\u{1D516}-\u{1D51C}\u{1D51E}-\u{1D539}\u{1D53B}-\u{1D53E}\u{1D540}-\u{1D544}\u{1D546}\u{1D54A}-\u{1D550}\u{1D552}-\u{1D6A5}\u{1D6A8}-\u{1D6DA}\u{1D6DC}-\u{1D714}\u{1D716}-\u{1D74E}\u{1D750}-\u{1D788}\u{1D78A}-\u{1D7C2}\u{1D7C4}-\u{1D7CB}\u{1D7CE}-\u{1D9FF}\u{1DA37}-\u{1DA3A}\u{1DA6D}-\u{1DA74}\u{1DA76}-\u{1DA83}\u{1DA85}-\u{1DA8B}\u{1E100}-\u{1E12C}\u{1E137}-\u{1E13D}\u{1E140}-\u{1E149}\u{1E14E}\u{1E14F}\u{1E2C0}-\u{1E2EB}\u{1E2F0}-\u{1E2F9}\u{1F100}-\u{1F10A}\u{1F110}-\u{1F12E}\u{1F130}-\u{1F169}\u{1F170}-\u{1F1AC}\u{1F1E6}-\u{1F202}\u{1F210}-\u{1F23B}\u{1F240}-\u{1F248}\u{1F250}\u{1F251}\u{1FBF0}-\u{1FBF9}\u{20000}-\u{2A6DD}\u{2A700}-\u{2B734}\u{2B740}-\u{2B81D}\u{2B820}-\u{2CEA1}\u{2CEB0}-\u{2EBE0}\u{2F800}-\u{2FA1D}\u{30000}-\u{3134A}\u{F0000}-\u{FFFFD}\u{100000}-\u{10FFFD}][\u0300-\u036F\u0483-\u0489\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u0610-\u061A\u064B-\u065F\u0670\u06D6-\u06DC\u06DF-\u06E4\u06E7\u06E8\u06EA-\u06ED\u0711\u0730-\u074A\u07A6-\u07B0\u07EB-\u07F3\u07FD\u0816-\u0819\u081B-\u0823\u0825-\u0827\u0829-\u082D\u0859-\u085B\u08D3-\u08E1\u08E3-\u0902\u093A\u093C\u0941-\u0948\u094D\u0951-\u0957\u0962\u0963\u0981\u09BC\u09C1-\u09C4\u09CD\u09E2\u09E3\u09FE\u0A01\u0A02\u0A3C\u0A41\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A70\u0A71\u0A75\u0A81\u0A82\u0ABC\u0AC1-\u0AC5\u0AC7\u0AC8\u0ACD\u0AE2\u0AE3\u0AFA-\u0AFF\u0B01\u0B3C\u0B3F\u0B41-\u0B44\u0B4D\u0B55\u0B56\u0B62\u0B63\u0B82\u0BC0\u0BCD\u0C00\u0C04\u0C3E-\u0C40\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C62\u0C63\u0C81\u0CBC\u0CCC\u0CCD\u0CE2\u0CE3\u0D00\u0D01\u0D3B\u0D3C\u0D41-\u0D44\u0D4D\u0D62\u0D63\u0D81\u0DCA\u0DD2-\u0DD4\u0DD6\u0E31\u0E34-\u0E3A\u0E47-\u0E4E\u0EB1\u0EB4-\u0EBC\u0EC8-\u0ECD\u0F18\u0F19\u0F35\u0F37\u0F39\u0F71-\u0F7E\u0F80-\u0F84\u0F86\u0F87\u0F8D-\u0F97\u0F99-\u0FBC\u0FC6\u102D-\u1030\u1032-\u1037\u1039\u103A\u103D\u103E\u1058\u1059\u105E-\u1060\u1071-\u1074\u1082\u1085\u1086\u108D\u109D\u135D-\u135F\u1712-\u1714\u1732-\u1734\u1752\u1753\u1772\u1773\u17B4\u17B5\u17B7-\u17BD\u17C6\u17C9-\u17D3\u17DD\u180B-\u180D\u1885\u1886\u18A9\u1920-\u1922\u1927\u1928\u1932\u1939-\u193B\u1A17\u1A18\u1A1B\u1A56\u1A58-\u1A5E\u1A60\u1A62\u1A65-\u1A6C\u1A73-\u1A7C\u1A7F\u1AB0-\u1AC0\u1B00-\u1B03\u1B34\u1B36-\u1B3A\u1B3C\u1B42\u1B6B-\u1B73\u1B80\u1B81\u1BA2-\u1BA5\u1BA8\u1BA9\u1BAB-\u1BAD\u1BE6\u1BE8\u1BE9\u1BED\u1BEF-\u1BF1\u1C2C-\u1C33\u1C36\u1C37\u1CD0-\u1CD2\u1CD4-\u1CE0\u1CE2-\u1CE8\u1CED\u1CF4\u1CF8\u1CF9\u1DC0-\u1DF9\u1DFB-\u1DFF\u20D0-\u20F0\u2CEF-\u2CF1\u2D7F\u2DE0-\u2DFF\u302A-\u302D\u3099\u309A\uA66F-\uA672\uA674-\uA67D\uA69E\uA69F\uA6F0\uA6F1\uA802\uA806\uA80B\uA825\uA826\uA82C\uA8C4\uA8C5\uA8E0-\uA8F1\uA8FF\uA926-\uA92D\uA947-\uA951\uA980-\uA982\uA9B3\uA9B6-\uA9B9\uA9BC\uA9BD\uA9E5\uAA29-\uAA2E\uAA31\uAA32\uAA35\uAA36\uAA43\uAA4C\uAA7C\uAAB0\uAAB2-\uAAB4\uAAB7\uAAB8\uAABE\uAABF\uAAC1\uAAEC\uAAED\uAAF6\uABE5\uABE8\uABED\uFB1E\uFE00-\uFE0F\uFE20-\uFE2F\u{101FD}\u{102E0}\u{10376}-\u{1037A}\u{10A01}-\u{10A03}\u{10A05}\u{10A06}\u{10A0C}-\u{10A0F}\u{10A38}-\u{10A3A}\u{10A3F}\u{10AE5}\u{10AE6}\u{10D24}-\u{10D27}\u{10EAB}\u{10EAC}\u{10F46}-\u{10F50}\u{11001}\u{11038}-\u{11046}\u{1107F}-\u{11081}\u{110B3}-\u{110B6}\u{110B9}\u{110BA}\u{11100}-\u{11102}\u{11127}-\u{1112B}\u{1112D}-\u{11134}\u{11173}\u{11180}\u{11181}\u{111B6}-\u{111BE}\u{111C9}-\u{111CC}\u{111CF}\u{1122F}-\u{11231}\u{11234}\u{11236}\u{11237}\u{1123E}\u{112DF}\u{112E3}-\u{112EA}\u{11300}\u{11301}\u{1133B}\u{1133C}\u{11340}\u{11366}-\u{1136C}\u{11370}-\u{11374}\u{11438}-\u{1143F}\u{11442}-\u{11444}\u{11446}\u{1145E}\u{114B3}-\u{114B8}\u{114BA}\u{114BF}\u{114C0}\u{114C2}\u{114C3}\u{115B2}-\u{115B5}\u{115BC}\u{115BD}\u{115BF}\u{115C0}\u{115DC}\u{115DD}\u{11633}-\u{1163A}\u{1163D}\u{1163F}\u{11640}\u{116AB}\u{116AD}\u{116B0}-\u{116B5}\u{116B7}\u{1171D}-\u{1171F}\u{11722}-\u{11725}\u{11727}-\u{1172B}\u{1182F}-\u{11837}\u{11839}\u{1183A}\u{1193B}\u{1193C}\u{1193E}\u{11943}\u{119D4}-\u{119D7}\u{119DA}\u{119DB}\u{119E0}\u{11A01}-\u{11A06}\u{11A09}\u{11A0A}\u{11A33}-\u{11A38}\u{11A3B}-\u{11A3E}\u{11A47}\u{11A51}-\u{11A56}\u{11A59}-\u{11A5B}\u{11A8A}-\u{11A96}\u{11A98}\u{11A99}\u{11C30}-\u{11C36}\u{11C38}-\u{11C3D}\u{11C92}-\u{11CA7}\u{11CAA}-\u{11CB0}\u{11CB2}\u{11CB3}\u{11CB5}\u{11CB6}\u{11D31}-\u{11D36}\u{11D3A}\u{11D3C}\u{11D3D}\u{11D3F}-\u{11D45}\u{11D47}\u{11D90}\u{11D91}\u{11D95}\u{11D97}\u{11EF3}\u{11EF4}\u{16AF0}-\u{16AF4}\u{16B30}-\u{16B36}\u{16F4F}\u{16F8F}-\u{16F92}\u{16FE4}\u{1BC9D}\u{1BC9E}\u{1D167}-\u{1D169}\u{1D17B}-\u{1D182}\u{1D185}-\u{1D18B}\u{1D1AA}-\u{1D1AD}\u{1D242}-\u{1D244}\u{1DA00}-\u{1DA36}\u{1DA3B}-\u{1DA6C}\u{1DA75}\u{1DA84}\u{1DA9B}-\u{1DA9F}\u{1DAA1}-\u{1DAAF}\u{1E000}-\u{1E006}\u{1E008}-\u{1E018}\u{1E01B}-\u{1E021}\u{1E023}\u{1E024}\u{1E026}-\u{1E02A}\u{1E130}-\u{1E136}\u{1E2EC}-\u{1E2EF}\u{1E8D0}-\u{1E8D6}\u{1E944}-\u{1E94A}\u{E0100}-\u{E01EF}]*$/u;

  var regexes = {
    combiningMarks,
    combiningClassVirama,
    validZWNJ,
    bidiDomain,
    bidiS1LTR,
    bidiS1RTL,
    bidiS2,
    bidiS3,
    bidiS4EN,
    bidiS4AN,
    bidiS5,
    bidiS6
  };

  var mappingTable = [
  	[
  		[
  			0,
  			44
  		],
  		4
  	],
  	[
  		[
  			45,
  			46
  		],
  		2
  	],
  	[
  		47,
  		4
  	],
  	[
  		[
  			48,
  			57
  		],
  		2
  	],
  	[
  		[
  			58,
  			64
  		],
  		4
  	],
  	[
  		65,
  		1,
  		"a"
  	],
  	[
  		66,
  		1,
  		"b"
  	],
  	[
  		67,
  		1,
  		"c"
  	],
  	[
  		68,
  		1,
  		"d"
  	],
  	[
  		69,
  		1,
  		"e"
  	],
  	[
  		70,
  		1,
  		"f"
  	],
  	[
  		71,
  		1,
  		"g"
  	],
  	[
  		72,
  		1,
  		"h"
  	],
  	[
  		73,
  		1,
  		"i"
  	],
  	[
  		74,
  		1,
  		"j"
  	],
  	[
  		75,
  		1,
  		"k"
  	],
  	[
  		76,
  		1,
  		"l"
  	],
  	[
  		77,
  		1,
  		"m"
  	],
  	[
  		78,
  		1,
  		"n"
  	],
  	[
  		79,
  		1,
  		"o"
  	],
  	[
  		80,
  		1,
  		"p"
  	],
  	[
  		81,
  		1,
  		"q"
  	],
  	[
  		82,
  		1,
  		"r"
  	],
  	[
  		83,
  		1,
  		"s"
  	],
  	[
  		84,
  		1,
  		"t"
  	],
  	[
  		85,
  		1,
  		"u"
  	],
  	[
  		86,
  		1,
  		"v"
  	],
  	[
  		87,
  		1,
  		"w"
  	],
  	[
  		88,
  		1,
  		"x"
  	],
  	[
  		89,
  		1,
  		"y"
  	],
  	[
  		90,
  		1,
  		"z"
  	],
  	[
  		[
  			91,
  			96
  		],
  		4
  	],
  	[
  		[
  			97,
  			122
  		],
  		2
  	],
  	[
  		[
  			123,
  			127
  		],
  		4
  	],
  	[
  		[
  			128,
  			159
  		],
  		3
  	],
  	[
  		160,
  		5,
  		" "
  	],
  	[
  		[
  			161,
  			167
  		],
  		2
  	],
  	[
  		168,
  		5,
  		" ̈"
  	],
  	[
  		169,
  		2
  	],
  	[
  		170,
  		1,
  		"a"
  	],
  	[
  		[
  			171,
  			172
  		],
  		2
  	],
  	[
  		173,
  		7
  	],
  	[
  		174,
  		2
  	],
  	[
  		175,
  		5,
  		" ̄"
  	],
  	[
  		[
  			176,
  			177
  		],
  		2
  	],
  	[
  		178,
  		1,
  		"2"
  	],
  	[
  		179,
  		1,
  		"3"
  	],
  	[
  		180,
  		5,
  		" ́"
  	],
  	[
  		181,
  		1,
  		"μ"
  	],
  	[
  		182,
  		2
  	],
  	[
  		183,
  		2
  	],
  	[
  		184,
  		5,
  		" ̧"
  	],
  	[
  		185,
  		1,
  		"1"
  	],
  	[
  		186,
  		1,
  		"o"
  	],
  	[
  		187,
  		2
  	],
  	[
  		188,
  		1,
  		"1⁄4"
  	],
  	[
  		189,
  		1,
  		"1⁄2"
  	],
  	[
  		190,
  		1,
  		"3⁄4"
  	],
  	[
  		191,
  		2
  	],
  	[
  		192,
  		1,
  		"à"
  	],
  	[
  		193,
  		1,
  		"á"
  	],
  	[
  		194,
  		1,
  		"â"
  	],
  	[
  		195,
  		1,
  		"ã"
  	],
  	[
  		196,
  		1,
  		"ä"
  	],
  	[
  		197,
  		1,
  		"å"
  	],
  	[
  		198,
  		1,
  		"æ"
  	],
  	[
  		199,
  		1,
  		"ç"
  	],
  	[
  		200,
  		1,
  		"è"
  	],
  	[
  		201,
  		1,
  		"é"
  	],
  	[
  		202,
  		1,
  		"ê"
  	],
  	[
  		203,
  		1,
  		"ë"
  	],
  	[
  		204,
  		1,
  		"ì"
  	],
  	[
  		205,
  		1,
  		"í"
  	],
  	[
  		206,
  		1,
  		"î"
  	],
  	[
  		207,
  		1,
  		"ï"
  	],
  	[
  		208,
  		1,
  		"ð"
  	],
  	[
  		209,
  		1,
  		"ñ"
  	],
  	[
  		210,
  		1,
  		"ò"
  	],
  	[
  		211,
  		1,
  		"ó"
  	],
  	[
  		212,
  		1,
  		"ô"
  	],
  	[
  		213,
  		1,
  		"õ"
  	],
  	[
  		214,
  		1,
  		"ö"
  	],
  	[
  		215,
  		2
  	],
  	[
  		216,
  		1,
  		"ø"
  	],
  	[
  		217,
  		1,
  		"ù"
  	],
  	[
  		218,
  		1,
  		"ú"
  	],
  	[
  		219,
  		1,
  		"û"
  	],
  	[
  		220,
  		1,
  		"ü"
  	],
  	[
  		221,
  		1,
  		"ý"
  	],
  	[
  		222,
  		1,
  		"þ"
  	],
  	[
  		223,
  		6,
  		"ss"
  	],
  	[
  		[
  			224,
  			246
  		],
  		2
  	],
  	[
  		247,
  		2
  	],
  	[
  		[
  			248,
  			255
  		],
  		2
  	],
  	[
  		256,
  		1,
  		"ā"
  	],
  	[
  		257,
  		2
  	],
  	[
  		258,
  		1,
  		"ă"
  	],
  	[
  		259,
  		2
  	],
  	[
  		260,
  		1,
  		"ą"
  	],
  	[
  		261,
  		2
  	],
  	[
  		262,
  		1,
  		"ć"
  	],
  	[
  		263,
  		2
  	],
  	[
  		264,
  		1,
  		"ĉ"
  	],
  	[
  		265,
  		2
  	],
  	[
  		266,
  		1,
  		"ċ"
  	],
  	[
  		267,
  		2
  	],
  	[
  		268,
  		1,
  		"č"
  	],
  	[
  		269,
  		2
  	],
  	[
  		270,
  		1,
  		"ď"
  	],
  	[
  		271,
  		2
  	],
  	[
  		272,
  		1,
  		"đ"
  	],
  	[
  		273,
  		2
  	],
  	[
  		274,
  		1,
  		"ē"
  	],
  	[
  		275,
  		2
  	],
  	[
  		276,
  		1,
  		"ĕ"
  	],
  	[
  		277,
  		2
  	],
  	[
  		278,
  		1,
  		"ė"
  	],
  	[
  		279,
  		2
  	],
  	[
  		280,
  		1,
  		"ę"
  	],
  	[
  		281,
  		2
  	],
  	[
  		282,
  		1,
  		"ě"
  	],
  	[
  		283,
  		2
  	],
  	[
  		284,
  		1,
  		"ĝ"
  	],
  	[
  		285,
  		2
  	],
  	[
  		286,
  		1,
  		"ğ"
  	],
  	[
  		287,
  		2
  	],
  	[
  		288,
  		1,
  		"ġ"
  	],
  	[
  		289,
  		2
  	],
  	[
  		290,
  		1,
  		"ģ"
  	],
  	[
  		291,
  		2
  	],
  	[
  		292,
  		1,
  		"ĥ"
  	],
  	[
  		293,
  		2
  	],
  	[
  		294,
  		1,
  		"ħ"
  	],
  	[
  		295,
  		2
  	],
  	[
  		296,
  		1,
  		"ĩ"
  	],
  	[
  		297,
  		2
  	],
  	[
  		298,
  		1,
  		"ī"
  	],
  	[
  		299,
  		2
  	],
  	[
  		300,
  		1,
  		"ĭ"
  	],
  	[
  		301,
  		2
  	],
  	[
  		302,
  		1,
  		"į"
  	],
  	[
  		303,
  		2
  	],
  	[
  		304,
  		1,
  		"i̇"
  	],
  	[
  		305,
  		2
  	],
  	[
  		[
  			306,
  			307
  		],
  		1,
  		"ij"
  	],
  	[
  		308,
  		1,
  		"ĵ"
  	],
  	[
  		309,
  		2
  	],
  	[
  		310,
  		1,
  		"ķ"
  	],
  	[
  		[
  			311,
  			312
  		],
  		2
  	],
  	[
  		313,
  		1,
  		"ĺ"
  	],
  	[
  		314,
  		2
  	],
  	[
  		315,
  		1,
  		"ļ"
  	],
  	[
  		316,
  		2
  	],
  	[
  		317,
  		1,
  		"ľ"
  	],
  	[
  		318,
  		2
  	],
  	[
  		[
  			319,
  			320
  		],
  		1,
  		"l·"
  	],
  	[
  		321,
  		1,
  		"ł"
  	],
  	[
  		322,
  		2
  	],
  	[
  		323,
  		1,
  		"ń"
  	],
  	[
  		324,
  		2
  	],
  	[
  		325,
  		1,
  		"ņ"
  	],
  	[
  		326,
  		2
  	],
  	[
  		327,
  		1,
  		"ň"
  	],
  	[
  		328,
  		2
  	],
  	[
  		329,
  		1,
  		"ʼn"
  	],
  	[
  		330,
  		1,
  		"ŋ"
  	],
  	[
  		331,
  		2
  	],
  	[
  		332,
  		1,
  		"ō"
  	],
  	[
  		333,
  		2
  	],
  	[
  		334,
  		1,
  		"ŏ"
  	],
  	[
  		335,
  		2
  	],
  	[
  		336,
  		1,
  		"ő"
  	],
  	[
  		337,
  		2
  	],
  	[
  		338,
  		1,
  		"œ"
  	],
  	[
  		339,
  		2
  	],
  	[
  		340,
  		1,
  		"ŕ"
  	],
  	[
  		341,
  		2
  	],
  	[
  		342,
  		1,
  		"ŗ"
  	],
  	[
  		343,
  		2
  	],
  	[
  		344,
  		1,
  		"ř"
  	],
  	[
  		345,
  		2
  	],
  	[
  		346,
  		1,
  		"ś"
  	],
  	[
  		347,
  		2
  	],
  	[
  		348,
  		1,
  		"ŝ"
  	],
  	[
  		349,
  		2
  	],
  	[
  		350,
  		1,
  		"ş"
  	],
  	[
  		351,
  		2
  	],
  	[
  		352,
  		1,
  		"š"
  	],
  	[
  		353,
  		2
  	],
  	[
  		354,
  		1,
  		"ţ"
  	],
  	[
  		355,
  		2
  	],
  	[
  		356,
  		1,
  		"ť"
  	],
  	[
  		357,
  		2
  	],
  	[
  		358,
  		1,
  		"ŧ"
  	],
  	[
  		359,
  		2
  	],
  	[
  		360,
  		1,
  		"ũ"
  	],
  	[
  		361,
  		2
  	],
  	[
  		362,
  		1,
  		"ū"
  	],
  	[
  		363,
  		2
  	],
  	[
  		364,
  		1,
  		"ŭ"
  	],
  	[
  		365,
  		2
  	],
  	[
  		366,
  		1,
  		"ů"
  	],
  	[
  		367,
  		2
  	],
  	[
  		368,
  		1,
  		"ű"
  	],
  	[
  		369,
  		2
  	],
  	[
  		370,
  		1,
  		"ų"
  	],
  	[
  		371,
  		2
  	],
  	[
  		372,
  		1,
  		"ŵ"
  	],
  	[
  		373,
  		2
  	],
  	[
  		374,
  		1,
  		"ŷ"
  	],
  	[
  		375,
  		2
  	],
  	[
  		376,
  		1,
  		"ÿ"
  	],
  	[
  		377,
  		1,
  		"ź"
  	],
  	[
  		378,
  		2
  	],
  	[
  		379,
  		1,
  		"ż"
  	],
  	[
  		380,
  		2
  	],
  	[
  		381,
  		1,
  		"ž"
  	],
  	[
  		382,
  		2
  	],
  	[
  		383,
  		1,
  		"s"
  	],
  	[
  		384,
  		2
  	],
  	[
  		385,
  		1,
  		"ɓ"
  	],
  	[
  		386,
  		1,
  		"ƃ"
  	],
  	[
  		387,
  		2
  	],
  	[
  		388,
  		1,
  		"ƅ"
  	],
  	[
  		389,
  		2
  	],
  	[
  		390,
  		1,
  		"ɔ"
  	],
  	[
  		391,
  		1,
  		"ƈ"
  	],
  	[
  		392,
  		2
  	],
  	[
  		393,
  		1,
  		"ɖ"
  	],
  	[
  		394,
  		1,
  		"ɗ"
  	],
  	[
  		395,
  		1,
  		"ƌ"
  	],
  	[
  		[
  			396,
  			397
  		],
  		2
  	],
  	[
  		398,
  		1,
  		"ǝ"
  	],
  	[
  		399,
  		1,
  		"ə"
  	],
  	[
  		400,
  		1,
  		"ɛ"
  	],
  	[
  		401,
  		1,
  		"ƒ"
  	],
  	[
  		402,
  		2
  	],
  	[
  		403,
  		1,
  		"ɠ"
  	],
  	[
  		404,
  		1,
  		"ɣ"
  	],
  	[
  		405,
  		2
  	],
  	[
  		406,
  		1,
  		"ɩ"
  	],
  	[
  		407,
  		1,
  		"ɨ"
  	],
  	[
  		408,
  		1,
  		"ƙ"
  	],
  	[
  		[
  			409,
  			411
  		],
  		2
  	],
  	[
  		412,
  		1,
  		"ɯ"
  	],
  	[
  		413,
  		1,
  		"ɲ"
  	],
  	[
  		414,
  		2
  	],
  	[
  		415,
  		1,
  		"ɵ"
  	],
  	[
  		416,
  		1,
  		"ơ"
  	],
  	[
  		417,
  		2
  	],
  	[
  		418,
  		1,
  		"ƣ"
  	],
  	[
  		419,
  		2
  	],
  	[
  		420,
  		1,
  		"ƥ"
  	],
  	[
  		421,
  		2
  	],
  	[
  		422,
  		1,
  		"ʀ"
  	],
  	[
  		423,
  		1,
  		"ƨ"
  	],
  	[
  		424,
  		2
  	],
  	[
  		425,
  		1,
  		"ʃ"
  	],
  	[
  		[
  			426,
  			427
  		],
  		2
  	],
  	[
  		428,
  		1,
  		"ƭ"
  	],
  	[
  		429,
  		2
  	],
  	[
  		430,
  		1,
  		"ʈ"
  	],
  	[
  		431,
  		1,
  		"ư"
  	],
  	[
  		432,
  		2
  	],
  	[
  		433,
  		1,
  		"ʊ"
  	],
  	[
  		434,
  		1,
  		"ʋ"
  	],
  	[
  		435,
  		1,
  		"ƴ"
  	],
  	[
  		436,
  		2
  	],
  	[
  		437,
  		1,
  		"ƶ"
  	],
  	[
  		438,
  		2
  	],
  	[
  		439,
  		1,
  		"ʒ"
  	],
  	[
  		440,
  		1,
  		"ƹ"
  	],
  	[
  		[
  			441,
  			443
  		],
  		2
  	],
  	[
  		444,
  		1,
  		"ƽ"
  	],
  	[
  		[
  			445,
  			451
  		],
  		2
  	],
  	[
  		[
  			452,
  			454
  		],
  		1,
  		"dž"
  	],
  	[
  		[
  			455,
  			457
  		],
  		1,
  		"lj"
  	],
  	[
  		[
  			458,
  			460
  		],
  		1,
  		"nj"
  	],
  	[
  		461,
  		1,
  		"ǎ"
  	],
  	[
  		462,
  		2
  	],
  	[
  		463,
  		1,
  		"ǐ"
  	],
  	[
  		464,
  		2
  	],
  	[
  		465,
  		1,
  		"ǒ"
  	],
  	[
  		466,
  		2
  	],
  	[
  		467,
  		1,
  		"ǔ"
  	],
  	[
  		468,
  		2
  	],
  	[
  		469,
  		1,
  		"ǖ"
  	],
  	[
  		470,
  		2
  	],
  	[
  		471,
  		1,
  		"ǘ"
  	],
  	[
  		472,
  		2
  	],
  	[
  		473,
  		1,
  		"ǚ"
  	],
  	[
  		474,
  		2
  	],
  	[
  		475,
  		1,
  		"ǜ"
  	],
  	[
  		[
  			476,
  			477
  		],
  		2
  	],
  	[
  		478,
  		1,
  		"ǟ"
  	],
  	[
  		479,
  		2
  	],
  	[
  		480,
  		1,
  		"ǡ"
  	],
  	[
  		481,
  		2
  	],
  	[
  		482,
  		1,
  		"ǣ"
  	],
  	[
  		483,
  		2
  	],
  	[
  		484,
  		1,
  		"ǥ"
  	],
  	[
  		485,
  		2
  	],
  	[
  		486,
  		1,
  		"ǧ"
  	],
  	[
  		487,
  		2
  	],
  	[
  		488,
  		1,
  		"ǩ"
  	],
  	[
  		489,
  		2
  	],
  	[
  		490,
  		1,
  		"ǫ"
  	],
  	[
  		491,
  		2
  	],
  	[
  		492,
  		1,
  		"ǭ"
  	],
  	[
  		493,
  		2
  	],
  	[
  		494,
  		1,
  		"ǯ"
  	],
  	[
  		[
  			495,
  			496
  		],
  		2
  	],
  	[
  		[
  			497,
  			499
  		],
  		1,
  		"dz"
  	],
  	[
  		500,
  		1,
  		"ǵ"
  	],
  	[
  		501,
  		2
  	],
  	[
  		502,
  		1,
  		"ƕ"
  	],
  	[
  		503,
  		1,
  		"ƿ"
  	],
  	[
  		504,
  		1,
  		"ǹ"
  	],
  	[
  		505,
  		2
  	],
  	[
  		506,
  		1,
  		"ǻ"
  	],
  	[
  		507,
  		2
  	],
  	[
  		508,
  		1,
  		"ǽ"
  	],
  	[
  		509,
  		2
  	],
  	[
  		510,
  		1,
  		"ǿ"
  	],
  	[
  		511,
  		2
  	],
  	[
  		512,
  		1,
  		"ȁ"
  	],
  	[
  		513,
  		2
  	],
  	[
  		514,
  		1,
  		"ȃ"
  	],
  	[
  		515,
  		2
  	],
  	[
  		516,
  		1,
  		"ȅ"
  	],
  	[
  		517,
  		2
  	],
  	[
  		518,
  		1,
  		"ȇ"
  	],
  	[
  		519,
  		2
  	],
  	[
  		520,
  		1,
  		"ȉ"
  	],
  	[
  		521,
  		2
  	],
  	[
  		522,
  		1,
  		"ȋ"
  	],
  	[
  		523,
  		2
  	],
  	[
  		524,
  		1,
  		"ȍ"
  	],
  	[
  		525,
  		2
  	],
  	[
  		526,
  		1,
  		"ȏ"
  	],
  	[
  		527,
  		2
  	],
  	[
  		528,
  		1,
  		"ȑ"
  	],
  	[
  		529,
  		2
  	],
  	[
  		530,
  		1,
  		"ȓ"
  	],
  	[
  		531,
  		2
  	],
  	[
  		532,
  		1,
  		"ȕ"
  	],
  	[
  		533,
  		2
  	],
  	[
  		534,
  		1,
  		"ȗ"
  	],
  	[
  		535,
  		2
  	],
  	[
  		536,
  		1,
  		"ș"
  	],
  	[
  		537,
  		2
  	],
  	[
  		538,
  		1,
  		"ț"
  	],
  	[
  		539,
  		2
  	],
  	[
  		540,
  		1,
  		"ȝ"
  	],
  	[
  		541,
  		2
  	],
  	[
  		542,
  		1,
  		"ȟ"
  	],
  	[
  		543,
  		2
  	],
  	[
  		544,
  		1,
  		"ƞ"
  	],
  	[
  		545,
  		2
  	],
  	[
  		546,
  		1,
  		"ȣ"
  	],
  	[
  		547,
  		2
  	],
  	[
  		548,
  		1,
  		"ȥ"
  	],
  	[
  		549,
  		2
  	],
  	[
  		550,
  		1,
  		"ȧ"
  	],
  	[
  		551,
  		2
  	],
  	[
  		552,
  		1,
  		"ȩ"
  	],
  	[
  		553,
  		2
  	],
  	[
  		554,
  		1,
  		"ȫ"
  	],
  	[
  		555,
  		2
  	],
  	[
  		556,
  		1,
  		"ȭ"
  	],
  	[
  		557,
  		2
  	],
  	[
  		558,
  		1,
  		"ȯ"
  	],
  	[
  		559,
  		2
  	],
  	[
  		560,
  		1,
  		"ȱ"
  	],
  	[
  		561,
  		2
  	],
  	[
  		562,
  		1,
  		"ȳ"
  	],
  	[
  		563,
  		2
  	],
  	[
  		[
  			564,
  			566
  		],
  		2
  	],
  	[
  		[
  			567,
  			569
  		],
  		2
  	],
  	[
  		570,
  		1,
  		"ⱥ"
  	],
  	[
  		571,
  		1,
  		"ȼ"
  	],
  	[
  		572,
  		2
  	],
  	[
  		573,
  		1,
  		"ƚ"
  	],
  	[
  		574,
  		1,
  		"ⱦ"
  	],
  	[
  		[
  			575,
  			576
  		],
  		2
  	],
  	[
  		577,
  		1,
  		"ɂ"
  	],
  	[
  		578,
  		2
  	],
  	[
  		579,
  		1,
  		"ƀ"
  	],
  	[
  		580,
  		1,
  		"ʉ"
  	],
  	[
  		581,
  		1,
  		"ʌ"
  	],
  	[
  		582,
  		1,
  		"ɇ"
  	],
  	[
  		583,
  		2
  	],
  	[
  		584,
  		1,
  		"ɉ"
  	],
  	[
  		585,
  		2
  	],
  	[
  		586,
  		1,
  		"ɋ"
  	],
  	[
  		587,
  		2
  	],
  	[
  		588,
  		1,
  		"ɍ"
  	],
  	[
  		589,
  		2
  	],
  	[
  		590,
  		1,
  		"ɏ"
  	],
  	[
  		591,
  		2
  	],
  	[
  		[
  			592,
  			680
  		],
  		2
  	],
  	[
  		[
  			681,
  			685
  		],
  		2
  	],
  	[
  		[
  			686,
  			687
  		],
  		2
  	],
  	[
  		688,
  		1,
  		"h"
  	],
  	[
  		689,
  		1,
  		"ɦ"
  	],
  	[
  		690,
  		1,
  		"j"
  	],
  	[
  		691,
  		1,
  		"r"
  	],
  	[
  		692,
  		1,
  		"ɹ"
  	],
  	[
  		693,
  		1,
  		"ɻ"
  	],
  	[
  		694,
  		1,
  		"ʁ"
  	],
  	[
  		695,
  		1,
  		"w"
  	],
  	[
  		696,
  		1,
  		"y"
  	],
  	[
  		[
  			697,
  			705
  		],
  		2
  	],
  	[
  		[
  			706,
  			709
  		],
  		2
  	],
  	[
  		[
  			710,
  			721
  		],
  		2
  	],
  	[
  		[
  			722,
  			727
  		],
  		2
  	],
  	[
  		728,
  		5,
  		" ̆"
  	],
  	[
  		729,
  		5,
  		" ̇"
  	],
  	[
  		730,
  		5,
  		" ̊"
  	],
  	[
  		731,
  		5,
  		" ̨"
  	],
  	[
  		732,
  		5,
  		" ̃"
  	],
  	[
  		733,
  		5,
  		" ̋"
  	],
  	[
  		734,
  		2
  	],
  	[
  		735,
  		2
  	],
  	[
  		736,
  		1,
  		"ɣ"
  	],
  	[
  		737,
  		1,
  		"l"
  	],
  	[
  		738,
  		1,
  		"s"
  	],
  	[
  		739,
  		1,
  		"x"
  	],
  	[
  		740,
  		1,
  		"ʕ"
  	],
  	[
  		[
  			741,
  			745
  		],
  		2
  	],
  	[
  		[
  			746,
  			747
  		],
  		2
  	],
  	[
  		748,
  		2
  	],
  	[
  		749,
  		2
  	],
  	[
  		750,
  		2
  	],
  	[
  		[
  			751,
  			767
  		],
  		2
  	],
  	[
  		[
  			768,
  			831
  		],
  		2
  	],
  	[
  		832,
  		1,
  		"̀"
  	],
  	[
  		833,
  		1,
  		"́"
  	],
  	[
  		834,
  		2
  	],
  	[
  		835,
  		1,
  		"̓"
  	],
  	[
  		836,
  		1,
  		"̈́"
  	],
  	[
  		837,
  		1,
  		"ι"
  	],
  	[
  		[
  			838,
  			846
  		],
  		2
  	],
  	[
  		847,
  		7
  	],
  	[
  		[
  			848,
  			855
  		],
  		2
  	],
  	[
  		[
  			856,
  			860
  		],
  		2
  	],
  	[
  		[
  			861,
  			863
  		],
  		2
  	],
  	[
  		[
  			864,
  			865
  		],
  		2
  	],
  	[
  		866,
  		2
  	],
  	[
  		[
  			867,
  			879
  		],
  		2
  	],
  	[
  		880,
  		1,
  		"ͱ"
  	],
  	[
  		881,
  		2
  	],
  	[
  		882,
  		1,
  		"ͳ"
  	],
  	[
  		883,
  		2
  	],
  	[
  		884,
  		1,
  		"ʹ"
  	],
  	[
  		885,
  		2
  	],
  	[
  		886,
  		1,
  		"ͷ"
  	],
  	[
  		887,
  		2
  	],
  	[
  		[
  			888,
  			889
  		],
  		3
  	],
  	[
  		890,
  		5,
  		" ι"
  	],
  	[
  		[
  			891,
  			893
  		],
  		2
  	],
  	[
  		894,
  		5,
  		";"
  	],
  	[
  		895,
  		1,
  		"ϳ"
  	],
  	[
  		[
  			896,
  			899
  		],
  		3
  	],
  	[
  		900,
  		5,
  		" ́"
  	],
  	[
  		901,
  		5,
  		" ̈́"
  	],
  	[
  		902,
  		1,
  		"ά"
  	],
  	[
  		903,
  		1,
  		"·"
  	],
  	[
  		904,
  		1,
  		"έ"
  	],
  	[
  		905,
  		1,
  		"ή"
  	],
  	[
  		906,
  		1,
  		"ί"
  	],
  	[
  		907,
  		3
  	],
  	[
  		908,
  		1,
  		"ό"
  	],
  	[
  		909,
  		3
  	],
  	[
  		910,
  		1,
  		"ύ"
  	],
  	[
  		911,
  		1,
  		"ώ"
  	],
  	[
  		912,
  		2
  	],
  	[
  		913,
  		1,
  		"α"
  	],
  	[
  		914,
  		1,
  		"β"
  	],
  	[
  		915,
  		1,
  		"γ"
  	],
  	[
  		916,
  		1,
  		"δ"
  	],
  	[
  		917,
  		1,
  		"ε"
  	],
  	[
  		918,
  		1,
  		"ζ"
  	],
  	[
  		919,
  		1,
  		"η"
  	],
  	[
  		920,
  		1,
  		"θ"
  	],
  	[
  		921,
  		1,
  		"ι"
  	],
  	[
  		922,
  		1,
  		"κ"
  	],
  	[
  		923,
  		1,
  		"λ"
  	],
  	[
  		924,
  		1,
  		"μ"
  	],
  	[
  		925,
  		1,
  		"ν"
  	],
  	[
  		926,
  		1,
  		"ξ"
  	],
  	[
  		927,
  		1,
  		"ο"
  	],
  	[
  		928,
  		1,
  		"π"
  	],
  	[
  		929,
  		1,
  		"ρ"
  	],
  	[
  		930,
  		3
  	],
  	[
  		931,
  		1,
  		"σ"
  	],
  	[
  		932,
  		1,
  		"τ"
  	],
  	[
  		933,
  		1,
  		"υ"
  	],
  	[
  		934,
  		1,
  		"φ"
  	],
  	[
  		935,
  		1,
  		"χ"
  	],
  	[
  		936,
  		1,
  		"ψ"
  	],
  	[
  		937,
  		1,
  		"ω"
  	],
  	[
  		938,
  		1,
  		"ϊ"
  	],
  	[
  		939,
  		1,
  		"ϋ"
  	],
  	[
  		[
  			940,
  			961
  		],
  		2
  	],
  	[
  		962,
  		6,
  		"σ"
  	],
  	[
  		[
  			963,
  			974
  		],
  		2
  	],
  	[
  		975,
  		1,
  		"ϗ"
  	],
  	[
  		976,
  		1,
  		"β"
  	],
  	[
  		977,
  		1,
  		"θ"
  	],
  	[
  		978,
  		1,
  		"υ"
  	],
  	[
  		979,
  		1,
  		"ύ"
  	],
  	[
  		980,
  		1,
  		"ϋ"
  	],
  	[
  		981,
  		1,
  		"φ"
  	],
  	[
  		982,
  		1,
  		"π"
  	],
  	[
  		983,
  		2
  	],
  	[
  		984,
  		1,
  		"ϙ"
  	],
  	[
  		985,
  		2
  	],
  	[
  		986,
  		1,
  		"ϛ"
  	],
  	[
  		987,
  		2
  	],
  	[
  		988,
  		1,
  		"ϝ"
  	],
  	[
  		989,
  		2
  	],
  	[
  		990,
  		1,
  		"ϟ"
  	],
  	[
  		991,
  		2
  	],
  	[
  		992,
  		1,
  		"ϡ"
  	],
  	[
  		993,
  		2
  	],
  	[
  		994,
  		1,
  		"ϣ"
  	],
  	[
  		995,
  		2
  	],
  	[
  		996,
  		1,
  		"ϥ"
  	],
  	[
  		997,
  		2
  	],
  	[
  		998,
  		1,
  		"ϧ"
  	],
  	[
  		999,
  		2
  	],
  	[
  		1000,
  		1,
  		"ϩ"
  	],
  	[
  		1001,
  		2
  	],
  	[
  		1002,
  		1,
  		"ϫ"
  	],
  	[
  		1003,
  		2
  	],
  	[
  		1004,
  		1,
  		"ϭ"
  	],
  	[
  		1005,
  		2
  	],
  	[
  		1006,
  		1,
  		"ϯ"
  	],
  	[
  		1007,
  		2
  	],
  	[
  		1008,
  		1,
  		"κ"
  	],
  	[
  		1009,
  		1,
  		"ρ"
  	],
  	[
  		1010,
  		1,
  		"σ"
  	],
  	[
  		1011,
  		2
  	],
  	[
  		1012,
  		1,
  		"θ"
  	],
  	[
  		1013,
  		1,
  		"ε"
  	],
  	[
  		1014,
  		2
  	],
  	[
  		1015,
  		1,
  		"ϸ"
  	],
  	[
  		1016,
  		2
  	],
  	[
  		1017,
  		1,
  		"σ"
  	],
  	[
  		1018,
  		1,
  		"ϻ"
  	],
  	[
  		1019,
  		2
  	],
  	[
  		1020,
  		2
  	],
  	[
  		1021,
  		1,
  		"ͻ"
  	],
  	[
  		1022,
  		1,
  		"ͼ"
  	],
  	[
  		1023,
  		1,
  		"ͽ"
  	],
  	[
  		1024,
  		1,
  		"ѐ"
  	],
  	[
  		1025,
  		1,
  		"ё"
  	],
  	[
  		1026,
  		1,
  		"ђ"
  	],
  	[
  		1027,
  		1,
  		"ѓ"
  	],
  	[
  		1028,
  		1,
  		"є"
  	],
  	[
  		1029,
  		1,
  		"ѕ"
  	],
  	[
  		1030,
  		1,
  		"і"
  	],
  	[
  		1031,
  		1,
  		"ї"
  	],
  	[
  		1032,
  		1,
  		"ј"
  	],
  	[
  		1033,
  		1,
  		"љ"
  	],
  	[
  		1034,
  		1,
  		"њ"
  	],
  	[
  		1035,
  		1,
  		"ћ"
  	],
  	[
  		1036,
  		1,
  		"ќ"
  	],
  	[
  		1037,
  		1,
  		"ѝ"
  	],
  	[
  		1038,
  		1,
  		"ў"
  	],
  	[
  		1039,
  		1,
  		"џ"
  	],
  	[
  		1040,
  		1,
  		"а"
  	],
  	[
  		1041,
  		1,
  		"б"
  	],
  	[
  		1042,
  		1,
  		"в"
  	],
  	[
  		1043,
  		1,
  		"г"
  	],
  	[
  		1044,
  		1,
  		"д"
  	],
  	[
  		1045,
  		1,
  		"е"
  	],
  	[
  		1046,
  		1,
  		"ж"
  	],
  	[
  		1047,
  		1,
  		"з"
  	],
  	[
  		1048,
  		1,
  		"и"
  	],
  	[
  		1049,
  		1,
  		"й"
  	],
  	[
  		1050,
  		1,
  		"к"
  	],
  	[
  		1051,
  		1,
  		"л"
  	],
  	[
  		1052,
  		1,
  		"м"
  	],
  	[
  		1053,
  		1,
  		"н"
  	],
  	[
  		1054,
  		1,
  		"о"
  	],
  	[
  		1055,
  		1,
  		"п"
  	],
  	[
  		1056,
  		1,
  		"р"
  	],
  	[
  		1057,
  		1,
  		"с"
  	],
  	[
  		1058,
  		1,
  		"т"
  	],
  	[
  		1059,
  		1,
  		"у"
  	],
  	[
  		1060,
  		1,
  		"ф"
  	],
  	[
  		1061,
  		1,
  		"х"
  	],
  	[
  		1062,
  		1,
  		"ц"
  	],
  	[
  		1063,
  		1,
  		"ч"
  	],
  	[
  		1064,
  		1,
  		"ш"
  	],
  	[
  		1065,
  		1,
  		"щ"
  	],
  	[
  		1066,
  		1,
  		"ъ"
  	],
  	[
  		1067,
  		1,
  		"ы"
  	],
  	[
  		1068,
  		1,
  		"ь"
  	],
  	[
  		1069,
  		1,
  		"э"
  	],
  	[
  		1070,
  		1,
  		"ю"
  	],
  	[
  		1071,
  		1,
  		"я"
  	],
  	[
  		[
  			1072,
  			1103
  		],
  		2
  	],
  	[
  		1104,
  		2
  	],
  	[
  		[
  			1105,
  			1116
  		],
  		2
  	],
  	[
  		1117,
  		2
  	],
  	[
  		[
  			1118,
  			1119
  		],
  		2
  	],
  	[
  		1120,
  		1,
  		"ѡ"
  	],
  	[
  		1121,
  		2
  	],
  	[
  		1122,
  		1,
  		"ѣ"
  	],
  	[
  		1123,
  		2
  	],
  	[
  		1124,
  		1,
  		"ѥ"
  	],
  	[
  		1125,
  		2
  	],
  	[
  		1126,
  		1,
  		"ѧ"
  	],
  	[
  		1127,
  		2
  	],
  	[
  		1128,
  		1,
  		"ѩ"
  	],
  	[
  		1129,
  		2
  	],
  	[
  		1130,
  		1,
  		"ѫ"
  	],
  	[
  		1131,
  		2
  	],
  	[
  		1132,
  		1,
  		"ѭ"
  	],
  	[
  		1133,
  		2
  	],
  	[
  		1134,
  		1,
  		"ѯ"
  	],
  	[
  		1135,
  		2
  	],
  	[
  		1136,
  		1,
  		"ѱ"
  	],
  	[
  		1137,
  		2
  	],
  	[
  		1138,
  		1,
  		"ѳ"
  	],
  	[
  		1139,
  		2
  	],
  	[
  		1140,
  		1,
  		"ѵ"
  	],
  	[
  		1141,
  		2
  	],
  	[
  		1142,
  		1,
  		"ѷ"
  	],
  	[
  		1143,
  		2
  	],
  	[
  		1144,
  		1,
  		"ѹ"
  	],
  	[
  		1145,
  		2
  	],
  	[
  		1146,
  		1,
  		"ѻ"
  	],
  	[
  		1147,
  		2
  	],
  	[
  		1148,
  		1,
  		"ѽ"
  	],
  	[
  		1149,
  		2
  	],
  	[
  		1150,
  		1,
  		"ѿ"
  	],
  	[
  		1151,
  		2
  	],
  	[
  		1152,
  		1,
  		"ҁ"
  	],
  	[
  		1153,
  		2
  	],
  	[
  		1154,
  		2
  	],
  	[
  		[
  			1155,
  			1158
  		],
  		2
  	],
  	[
  		1159,
  		2
  	],
  	[
  		[
  			1160,
  			1161
  		],
  		2
  	],
  	[
  		1162,
  		1,
  		"ҋ"
  	],
  	[
  		1163,
  		2
  	],
  	[
  		1164,
  		1,
  		"ҍ"
  	],
  	[
  		1165,
  		2
  	],
  	[
  		1166,
  		1,
  		"ҏ"
  	],
  	[
  		1167,
  		2
  	],
  	[
  		1168,
  		1,
  		"ґ"
  	],
  	[
  		1169,
  		2
  	],
  	[
  		1170,
  		1,
  		"ғ"
  	],
  	[
  		1171,
  		2
  	],
  	[
  		1172,
  		1,
  		"ҕ"
  	],
  	[
  		1173,
  		2
  	],
  	[
  		1174,
  		1,
  		"җ"
  	],
  	[
  		1175,
  		2
  	],
  	[
  		1176,
  		1,
  		"ҙ"
  	],
  	[
  		1177,
  		2
  	],
  	[
  		1178,
  		1,
  		"қ"
  	],
  	[
  		1179,
  		2
  	],
  	[
  		1180,
  		1,
  		"ҝ"
  	],
  	[
  		1181,
  		2
  	],
  	[
  		1182,
  		1,
  		"ҟ"
  	],
  	[
  		1183,
  		2
  	],
  	[
  		1184,
  		1,
  		"ҡ"
  	],
  	[
  		1185,
  		2
  	],
  	[
  		1186,
  		1,
  		"ң"
  	],
  	[
  		1187,
  		2
  	],
  	[
  		1188,
  		1,
  		"ҥ"
  	],
  	[
  		1189,
  		2
  	],
  	[
  		1190,
  		1,
  		"ҧ"
  	],
  	[
  		1191,
  		2
  	],
  	[
  		1192,
  		1,
  		"ҩ"
  	],
  	[
  		1193,
  		2
  	],
  	[
  		1194,
  		1,
  		"ҫ"
  	],
  	[
  		1195,
  		2
  	],
  	[
  		1196,
  		1,
  		"ҭ"
  	],
  	[
  		1197,
  		2
  	],
  	[
  		1198,
  		1,
  		"ү"
  	],
  	[
  		1199,
  		2
  	],
  	[
  		1200,
  		1,
  		"ұ"
  	],
  	[
  		1201,
  		2
  	],
  	[
  		1202,
  		1,
  		"ҳ"
  	],
  	[
  		1203,
  		2
  	],
  	[
  		1204,
  		1,
  		"ҵ"
  	],
  	[
  		1205,
  		2
  	],
  	[
  		1206,
  		1,
  		"ҷ"
  	],
  	[
  		1207,
  		2
  	],
  	[
  		1208,
  		1,
  		"ҹ"
  	],
  	[
  		1209,
  		2
  	],
  	[
  		1210,
  		1,
  		"һ"
  	],
  	[
  		1211,
  		2
  	],
  	[
  		1212,
  		1,
  		"ҽ"
  	],
  	[
  		1213,
  		2
  	],
  	[
  		1214,
  		1,
  		"ҿ"
  	],
  	[
  		1215,
  		2
  	],
  	[
  		1216,
  		3
  	],
  	[
  		1217,
  		1,
  		"ӂ"
  	],
  	[
  		1218,
  		2
  	],
  	[
  		1219,
  		1,
  		"ӄ"
  	],
  	[
  		1220,
  		2
  	],
  	[
  		1221,
  		1,
  		"ӆ"
  	],
  	[
  		1222,
  		2
  	],
  	[
  		1223,
  		1,
  		"ӈ"
  	],
  	[
  		1224,
  		2
  	],
  	[
  		1225,
  		1,
  		"ӊ"
  	],
  	[
  		1226,
  		2
  	],
  	[
  		1227,
  		1,
  		"ӌ"
  	],
  	[
  		1228,
  		2
  	],
  	[
  		1229,
  		1,
  		"ӎ"
  	],
  	[
  		1230,
  		2
  	],
  	[
  		1231,
  		2
  	],
  	[
  		1232,
  		1,
  		"ӑ"
  	],
  	[
  		1233,
  		2
  	],
  	[
  		1234,
  		1,
  		"ӓ"
  	],
  	[
  		1235,
  		2
  	],
  	[
  		1236,
  		1,
  		"ӕ"
  	],
  	[
  		1237,
  		2
  	],
  	[
  		1238,
  		1,
  		"ӗ"
  	],
  	[
  		1239,
  		2
  	],
  	[
  		1240,
  		1,
  		"ә"
  	],
  	[
  		1241,
  		2
  	],
  	[
  		1242,
  		1,
  		"ӛ"
  	],
  	[
  		1243,
  		2
  	],
  	[
  		1244,
  		1,
  		"ӝ"
  	],
  	[
  		1245,
  		2
  	],
  	[
  		1246,
  		1,
  		"ӟ"
  	],
  	[
  		1247,
  		2
  	],
  	[
  		1248,
  		1,
  		"ӡ"
  	],
  	[
  		1249,
  		2
  	],
  	[
  		1250,
  		1,
  		"ӣ"
  	],
  	[
  		1251,
  		2
  	],
  	[
  		1252,
  		1,
  		"ӥ"
  	],
  	[
  		1253,
  		2
  	],
  	[
  		1254,
  		1,
  		"ӧ"
  	],
  	[
  		1255,
  		2
  	],
  	[
  		1256,
  		1,
  		"ө"
  	],
  	[
  		1257,
  		2
  	],
  	[
  		1258,
  		1,
  		"ӫ"
  	],
  	[
  		1259,
  		2
  	],
  	[
  		1260,
  		1,
  		"ӭ"
  	],
  	[
  		1261,
  		2
  	],
  	[
  		1262,
  		1,
  		"ӯ"
  	],
  	[
  		1263,
  		2
  	],
  	[
  		1264,
  		1,
  		"ӱ"
  	],
  	[
  		1265,
  		2
  	],
  	[
  		1266,
  		1,
  		"ӳ"
  	],
  	[
  		1267,
  		2
  	],
  	[
  		1268,
  		1,
  		"ӵ"
  	],
  	[
  		1269,
  		2
  	],
  	[
  		1270,
  		1,
  		"ӷ"
  	],
  	[
  		1271,
  		2
  	],
  	[
  		1272,
  		1,
  		"ӹ"
  	],
  	[
  		1273,
  		2
  	],
  	[
  		1274,
  		1,
  		"ӻ"
  	],
  	[
  		1275,
  		2
  	],
  	[
  		1276,
  		1,
  		"ӽ"
  	],
  	[
  		1277,
  		2
  	],
  	[
  		1278,
  		1,
  		"ӿ"
  	],
  	[
  		1279,
  		2
  	],
  	[
  		1280,
  		1,
  		"ԁ"
  	],
  	[
  		1281,
  		2
  	],
  	[
  		1282,
  		1,
  		"ԃ"
  	],
  	[
  		1283,
  		2
  	],
  	[
  		1284,
  		1,
  		"ԅ"
  	],
  	[
  		1285,
  		2
  	],
  	[
  		1286,
  		1,
  		"ԇ"
  	],
  	[
  		1287,
  		2
  	],
  	[
  		1288,
  		1,
  		"ԉ"
  	],
  	[
  		1289,
  		2
  	],
  	[
  		1290,
  		1,
  		"ԋ"
  	],
  	[
  		1291,
  		2
  	],
  	[
  		1292,
  		1,
  		"ԍ"
  	],
  	[
  		1293,
  		2
  	],
  	[
  		1294,
  		1,
  		"ԏ"
  	],
  	[
  		1295,
  		2
  	],
  	[
  		1296,
  		1,
  		"ԑ"
  	],
  	[
  		1297,
  		2
  	],
  	[
  		1298,
  		1,
  		"ԓ"
  	],
  	[
  		1299,
  		2
  	],
  	[
  		1300,
  		1,
  		"ԕ"
  	],
  	[
  		1301,
  		2
  	],
  	[
  		1302,
  		1,
  		"ԗ"
  	],
  	[
  		1303,
  		2
  	],
  	[
  		1304,
  		1,
  		"ԙ"
  	],
  	[
  		1305,
  		2
  	],
  	[
  		1306,
  		1,
  		"ԛ"
  	],
  	[
  		1307,
  		2
  	],
  	[
  		1308,
  		1,
  		"ԝ"
  	],
  	[
  		1309,
  		2
  	],
  	[
  		1310,
  		1,
  		"ԟ"
  	],
  	[
  		1311,
  		2
  	],
  	[
  		1312,
  		1,
  		"ԡ"
  	],
  	[
  		1313,
  		2
  	],
  	[
  		1314,
  		1,
  		"ԣ"
  	],
  	[
  		1315,
  		2
  	],
  	[
  		1316,
  		1,
  		"ԥ"
  	],
  	[
  		1317,
  		2
  	],
  	[
  		1318,
  		1,
  		"ԧ"
  	],
  	[
  		1319,
  		2
  	],
  	[
  		1320,
  		1,
  		"ԩ"
  	],
  	[
  		1321,
  		2
  	],
  	[
  		1322,
  		1,
  		"ԫ"
  	],
  	[
  		1323,
  		2
  	],
  	[
  		1324,
  		1,
  		"ԭ"
  	],
  	[
  		1325,
  		2
  	],
  	[
  		1326,
  		1,
  		"ԯ"
  	],
  	[
  		1327,
  		2
  	],
  	[
  		1328,
  		3
  	],
  	[
  		1329,
  		1,
  		"ա"
  	],
  	[
  		1330,
  		1,
  		"բ"
  	],
  	[
  		1331,
  		1,
  		"գ"
  	],
  	[
  		1332,
  		1,
  		"դ"
  	],
  	[
  		1333,
  		1,
  		"ե"
  	],
  	[
  		1334,
  		1,
  		"զ"
  	],
  	[
  		1335,
  		1,
  		"է"
  	],
  	[
  		1336,
  		1,
  		"ը"
  	],
  	[
  		1337,
  		1,
  		"թ"
  	],
  	[
  		1338,
  		1,
  		"ժ"
  	],
  	[
  		1339,
  		1,
  		"ի"
  	],
  	[
  		1340,
  		1,
  		"լ"
  	],
  	[
  		1341,
  		1,
  		"խ"
  	],
  	[
  		1342,
  		1,
  		"ծ"
  	],
  	[
  		1343,
  		1,
  		"կ"
  	],
  	[
  		1344,
  		1,
  		"հ"
  	],
  	[
  		1345,
  		1,
  		"ձ"
  	],
  	[
  		1346,
  		1,
  		"ղ"
  	],
  	[
  		1347,
  		1,
  		"ճ"
  	],
  	[
  		1348,
  		1,
  		"մ"
  	],
  	[
  		1349,
  		1,
  		"յ"
  	],
  	[
  		1350,
  		1,
  		"ն"
  	],
  	[
  		1351,
  		1,
  		"շ"
  	],
  	[
  		1352,
  		1,
  		"ո"
  	],
  	[
  		1353,
  		1,
  		"չ"
  	],
  	[
  		1354,
  		1,
  		"պ"
  	],
  	[
  		1355,
  		1,
  		"ջ"
  	],
  	[
  		1356,
  		1,
  		"ռ"
  	],
  	[
  		1357,
  		1,
  		"ս"
  	],
  	[
  		1358,
  		1,
  		"վ"
  	],
  	[
  		1359,
  		1,
  		"տ"
  	],
  	[
  		1360,
  		1,
  		"ր"
  	],
  	[
  		1361,
  		1,
  		"ց"
  	],
  	[
  		1362,
  		1,
  		"ւ"
  	],
  	[
  		1363,
  		1,
  		"փ"
  	],
  	[
  		1364,
  		1,
  		"ք"
  	],
  	[
  		1365,
  		1,
  		"օ"
  	],
  	[
  		1366,
  		1,
  		"ֆ"
  	],
  	[
  		[
  			1367,
  			1368
  		],
  		3
  	],
  	[
  		1369,
  		2
  	],
  	[
  		[
  			1370,
  			1375
  		],
  		2
  	],
  	[
  		1376,
  		2
  	],
  	[
  		[
  			1377,
  			1414
  		],
  		2
  	],
  	[
  		1415,
  		1,
  		"եւ"
  	],
  	[
  		1416,
  		2
  	],
  	[
  		1417,
  		2
  	],
  	[
  		1418,
  		2
  	],
  	[
  		[
  			1419,
  			1420
  		],
  		3
  	],
  	[
  		[
  			1421,
  			1422
  		],
  		2
  	],
  	[
  		1423,
  		2
  	],
  	[
  		1424,
  		3
  	],
  	[
  		[
  			1425,
  			1441
  		],
  		2
  	],
  	[
  		1442,
  		2
  	],
  	[
  		[
  			1443,
  			1455
  		],
  		2
  	],
  	[
  		[
  			1456,
  			1465
  		],
  		2
  	],
  	[
  		1466,
  		2
  	],
  	[
  		[
  			1467,
  			1469
  		],
  		2
  	],
  	[
  		1470,
  		2
  	],
  	[
  		1471,
  		2
  	],
  	[
  		1472,
  		2
  	],
  	[
  		[
  			1473,
  			1474
  		],
  		2
  	],
  	[
  		1475,
  		2
  	],
  	[
  		1476,
  		2
  	],
  	[
  		1477,
  		2
  	],
  	[
  		1478,
  		2
  	],
  	[
  		1479,
  		2
  	],
  	[
  		[
  			1480,
  			1487
  		],
  		3
  	],
  	[
  		[
  			1488,
  			1514
  		],
  		2
  	],
  	[
  		[
  			1515,
  			1518
  		],
  		3
  	],
  	[
  		1519,
  		2
  	],
  	[
  		[
  			1520,
  			1524
  		],
  		2
  	],
  	[
  		[
  			1525,
  			1535
  		],
  		3
  	],
  	[
  		[
  			1536,
  			1539
  		],
  		3
  	],
  	[
  		1540,
  		3
  	],
  	[
  		1541,
  		3
  	],
  	[
  		[
  			1542,
  			1546
  		],
  		2
  	],
  	[
  		1547,
  		2
  	],
  	[
  		1548,
  		2
  	],
  	[
  		[
  			1549,
  			1551
  		],
  		2
  	],
  	[
  		[
  			1552,
  			1557
  		],
  		2
  	],
  	[
  		[
  			1558,
  			1562
  		],
  		2
  	],
  	[
  		1563,
  		2
  	],
  	[
  		1564,
  		3
  	],
  	[
  		1565,
  		3
  	],
  	[
  		1566,
  		2
  	],
  	[
  		1567,
  		2
  	],
  	[
  		1568,
  		2
  	],
  	[
  		[
  			1569,
  			1594
  		],
  		2
  	],
  	[
  		[
  			1595,
  			1599
  		],
  		2
  	],
  	[
  		1600,
  		2
  	],
  	[
  		[
  			1601,
  			1618
  		],
  		2
  	],
  	[
  		[
  			1619,
  			1621
  		],
  		2
  	],
  	[
  		[
  			1622,
  			1624
  		],
  		2
  	],
  	[
  		[
  			1625,
  			1630
  		],
  		2
  	],
  	[
  		1631,
  		2
  	],
  	[
  		[
  			1632,
  			1641
  		],
  		2
  	],
  	[
  		[
  			1642,
  			1645
  		],
  		2
  	],
  	[
  		[
  			1646,
  			1647
  		],
  		2
  	],
  	[
  		[
  			1648,
  			1652
  		],
  		2
  	],
  	[
  		1653,
  		1,
  		"اٴ"
  	],
  	[
  		1654,
  		1,
  		"وٴ"
  	],
  	[
  		1655,
  		1,
  		"ۇٴ"
  	],
  	[
  		1656,
  		1,
  		"يٴ"
  	],
  	[
  		[
  			1657,
  			1719
  		],
  		2
  	],
  	[
  		[
  			1720,
  			1721
  		],
  		2
  	],
  	[
  		[
  			1722,
  			1726
  		],
  		2
  	],
  	[
  		1727,
  		2
  	],
  	[
  		[
  			1728,
  			1742
  		],
  		2
  	],
  	[
  		1743,
  		2
  	],
  	[
  		[
  			1744,
  			1747
  		],
  		2
  	],
  	[
  		1748,
  		2
  	],
  	[
  		[
  			1749,
  			1756
  		],
  		2
  	],
  	[
  		1757,
  		3
  	],
  	[
  		1758,
  		2
  	],
  	[
  		[
  			1759,
  			1768
  		],
  		2
  	],
  	[
  		1769,
  		2
  	],
  	[
  		[
  			1770,
  			1773
  		],
  		2
  	],
  	[
  		[
  			1774,
  			1775
  		],
  		2
  	],
  	[
  		[
  			1776,
  			1785
  		],
  		2
  	],
  	[
  		[
  			1786,
  			1790
  		],
  		2
  	],
  	[
  		1791,
  		2
  	],
  	[
  		[
  			1792,
  			1805
  		],
  		2
  	],
  	[
  		1806,
  		3
  	],
  	[
  		1807,
  		3
  	],
  	[
  		[
  			1808,
  			1836
  		],
  		2
  	],
  	[
  		[
  			1837,
  			1839
  		],
  		2
  	],
  	[
  		[
  			1840,
  			1866
  		],
  		2
  	],
  	[
  		[
  			1867,
  			1868
  		],
  		3
  	],
  	[
  		[
  			1869,
  			1871
  		],
  		2
  	],
  	[
  		[
  			1872,
  			1901
  		],
  		2
  	],
  	[
  		[
  			1902,
  			1919
  		],
  		2
  	],
  	[
  		[
  			1920,
  			1968
  		],
  		2
  	],
  	[
  		1969,
  		2
  	],
  	[
  		[
  			1970,
  			1983
  		],
  		3
  	],
  	[
  		[
  			1984,
  			2037
  		],
  		2
  	],
  	[
  		[
  			2038,
  			2042
  		],
  		2
  	],
  	[
  		[
  			2043,
  			2044
  		],
  		3
  	],
  	[
  		2045,
  		2
  	],
  	[
  		[
  			2046,
  			2047
  		],
  		2
  	],
  	[
  		[
  			2048,
  			2093
  		],
  		2
  	],
  	[
  		[
  			2094,
  			2095
  		],
  		3
  	],
  	[
  		[
  			2096,
  			2110
  		],
  		2
  	],
  	[
  		2111,
  		3
  	],
  	[
  		[
  			2112,
  			2139
  		],
  		2
  	],
  	[
  		[
  			2140,
  			2141
  		],
  		3
  	],
  	[
  		2142,
  		2
  	],
  	[
  		2143,
  		3
  	],
  	[
  		[
  			2144,
  			2154
  		],
  		2
  	],
  	[
  		[
  			2155,
  			2207
  		],
  		3
  	],
  	[
  		2208,
  		2
  	],
  	[
  		2209,
  		2
  	],
  	[
  		[
  			2210,
  			2220
  		],
  		2
  	],
  	[
  		[
  			2221,
  			2226
  		],
  		2
  	],
  	[
  		[
  			2227,
  			2228
  		],
  		2
  	],
  	[
  		2229,
  		3
  	],
  	[
  		[
  			2230,
  			2237
  		],
  		2
  	],
  	[
  		[
  			2238,
  			2247
  		],
  		2
  	],
  	[
  		[
  			2248,
  			2258
  		],
  		3
  	],
  	[
  		2259,
  		2
  	],
  	[
  		[
  			2260,
  			2273
  		],
  		2
  	],
  	[
  		2274,
  		3
  	],
  	[
  		2275,
  		2
  	],
  	[
  		[
  			2276,
  			2302
  		],
  		2
  	],
  	[
  		2303,
  		2
  	],
  	[
  		2304,
  		2
  	],
  	[
  		[
  			2305,
  			2307
  		],
  		2
  	],
  	[
  		2308,
  		2
  	],
  	[
  		[
  			2309,
  			2361
  		],
  		2
  	],
  	[
  		[
  			2362,
  			2363
  		],
  		2
  	],
  	[
  		[
  			2364,
  			2381
  		],
  		2
  	],
  	[
  		2382,
  		2
  	],
  	[
  		2383,
  		2
  	],
  	[
  		[
  			2384,
  			2388
  		],
  		2
  	],
  	[
  		2389,
  		2
  	],
  	[
  		[
  			2390,
  			2391
  		],
  		2
  	],
  	[
  		2392,
  		1,
  		"क़"
  	],
  	[
  		2393,
  		1,
  		"ख़"
  	],
  	[
  		2394,
  		1,
  		"ग़"
  	],
  	[
  		2395,
  		1,
  		"ज़"
  	],
  	[
  		2396,
  		1,
  		"ड़"
  	],
  	[
  		2397,
  		1,
  		"ढ़"
  	],
  	[
  		2398,
  		1,
  		"फ़"
  	],
  	[
  		2399,
  		1,
  		"य़"
  	],
  	[
  		[
  			2400,
  			2403
  		],
  		2
  	],
  	[
  		[
  			2404,
  			2405
  		],
  		2
  	],
  	[
  		[
  			2406,
  			2415
  		],
  		2
  	],
  	[
  		2416,
  		2
  	],
  	[
  		[
  			2417,
  			2418
  		],
  		2
  	],
  	[
  		[
  			2419,
  			2423
  		],
  		2
  	],
  	[
  		2424,
  		2
  	],
  	[
  		[
  			2425,
  			2426
  		],
  		2
  	],
  	[
  		[
  			2427,
  			2428
  		],
  		2
  	],
  	[
  		2429,
  		2
  	],
  	[
  		[
  			2430,
  			2431
  		],
  		2
  	],
  	[
  		2432,
  		2
  	],
  	[
  		[
  			2433,
  			2435
  		],
  		2
  	],
  	[
  		2436,
  		3
  	],
  	[
  		[
  			2437,
  			2444
  		],
  		2
  	],
  	[
  		[
  			2445,
  			2446
  		],
  		3
  	],
  	[
  		[
  			2447,
  			2448
  		],
  		2
  	],
  	[
  		[
  			2449,
  			2450
  		],
  		3
  	],
  	[
  		[
  			2451,
  			2472
  		],
  		2
  	],
  	[
  		2473,
  		3
  	],
  	[
  		[
  			2474,
  			2480
  		],
  		2
  	],
  	[
  		2481,
  		3
  	],
  	[
  		2482,
  		2
  	],
  	[
  		[
  			2483,
  			2485
  		],
  		3
  	],
  	[
  		[
  			2486,
  			2489
  		],
  		2
  	],
  	[
  		[
  			2490,
  			2491
  		],
  		3
  	],
  	[
  		2492,
  		2
  	],
  	[
  		2493,
  		2
  	],
  	[
  		[
  			2494,
  			2500
  		],
  		2
  	],
  	[
  		[
  			2501,
  			2502
  		],
  		3
  	],
  	[
  		[
  			2503,
  			2504
  		],
  		2
  	],
  	[
  		[
  			2505,
  			2506
  		],
  		3
  	],
  	[
  		[
  			2507,
  			2509
  		],
  		2
  	],
  	[
  		2510,
  		2
  	],
  	[
  		[
  			2511,
  			2518
  		],
  		3
  	],
  	[
  		2519,
  		2
  	],
  	[
  		[
  			2520,
  			2523
  		],
  		3
  	],
  	[
  		2524,
  		1,
  		"ড়"
  	],
  	[
  		2525,
  		1,
  		"ঢ়"
  	],
  	[
  		2526,
  		3
  	],
  	[
  		2527,
  		1,
  		"য়"
  	],
  	[
  		[
  			2528,
  			2531
  		],
  		2
  	],
  	[
  		[
  			2532,
  			2533
  		],
  		3
  	],
  	[
  		[
  			2534,
  			2545
  		],
  		2
  	],
  	[
  		[
  			2546,
  			2554
  		],
  		2
  	],
  	[
  		2555,
  		2
  	],
  	[
  		2556,
  		2
  	],
  	[
  		2557,
  		2
  	],
  	[
  		2558,
  		2
  	],
  	[
  		[
  			2559,
  			2560
  		],
  		3
  	],
  	[
  		2561,
  		2
  	],
  	[
  		2562,
  		2
  	],
  	[
  		2563,
  		2
  	],
  	[
  		2564,
  		3
  	],
  	[
  		[
  			2565,
  			2570
  		],
  		2
  	],
  	[
  		[
  			2571,
  			2574
  		],
  		3
  	],
  	[
  		[
  			2575,
  			2576
  		],
  		2
  	],
  	[
  		[
  			2577,
  			2578
  		],
  		3
  	],
  	[
  		[
  			2579,
  			2600
  		],
  		2
  	],
  	[
  		2601,
  		3
  	],
  	[
  		[
  			2602,
  			2608
  		],
  		2
  	],
  	[
  		2609,
  		3
  	],
  	[
  		2610,
  		2
  	],
  	[
  		2611,
  		1,
  		"ਲ਼"
  	],
  	[
  		2612,
  		3
  	],
  	[
  		2613,
  		2
  	],
  	[
  		2614,
  		1,
  		"ਸ਼"
  	],
  	[
  		2615,
  		3
  	],
  	[
  		[
  			2616,
  			2617
  		],
  		2
  	],
  	[
  		[
  			2618,
  			2619
  		],
  		3
  	],
  	[
  		2620,
  		2
  	],
  	[
  		2621,
  		3
  	],
  	[
  		[
  			2622,
  			2626
  		],
  		2
  	],
  	[
  		[
  			2627,
  			2630
  		],
  		3
  	],
  	[
  		[
  			2631,
  			2632
  		],
  		2
  	],
  	[
  		[
  			2633,
  			2634
  		],
  		3
  	],
  	[
  		[
  			2635,
  			2637
  		],
  		2
  	],
  	[
  		[
  			2638,
  			2640
  		],
  		3
  	],
  	[
  		2641,
  		2
  	],
  	[
  		[
  			2642,
  			2648
  		],
  		3
  	],
  	[
  		2649,
  		1,
  		"ਖ਼"
  	],
  	[
  		2650,
  		1,
  		"ਗ਼"
  	],
  	[
  		2651,
  		1,
  		"ਜ਼"
  	],
  	[
  		2652,
  		2
  	],
  	[
  		2653,
  		3
  	],
  	[
  		2654,
  		1,
  		"ਫ਼"
  	],
  	[
  		[
  			2655,
  			2661
  		],
  		3
  	],
  	[
  		[
  			2662,
  			2676
  		],
  		2
  	],
  	[
  		2677,
  		2
  	],
  	[
  		2678,
  		2
  	],
  	[
  		[
  			2679,
  			2688
  		],
  		3
  	],
  	[
  		[
  			2689,
  			2691
  		],
  		2
  	],
  	[
  		2692,
  		3
  	],
  	[
  		[
  			2693,
  			2699
  		],
  		2
  	],
  	[
  		2700,
  		2
  	],
  	[
  		2701,
  		2
  	],
  	[
  		2702,
  		3
  	],
  	[
  		[
  			2703,
  			2705
  		],
  		2
  	],
  	[
  		2706,
  		3
  	],
  	[
  		[
  			2707,
  			2728
  		],
  		2
  	],
  	[
  		2729,
  		3
  	],
  	[
  		[
  			2730,
  			2736
  		],
  		2
  	],
  	[
  		2737,
  		3
  	],
  	[
  		[
  			2738,
  			2739
  		],
  		2
  	],
  	[
  		2740,
  		3
  	],
  	[
  		[
  			2741,
  			2745
  		],
  		2
  	],
  	[
  		[
  			2746,
  			2747
  		],
  		3
  	],
  	[
  		[
  			2748,
  			2757
  		],
  		2
  	],
  	[
  		2758,
  		3
  	],
  	[
  		[
  			2759,
  			2761
  		],
  		2
  	],
  	[
  		2762,
  		3
  	],
  	[
  		[
  			2763,
  			2765
  		],
  		2
  	],
  	[
  		[
  			2766,
  			2767
  		],
  		3
  	],
  	[
  		2768,
  		2
  	],
  	[
  		[
  			2769,
  			2783
  		],
  		3
  	],
  	[
  		2784,
  		2
  	],
  	[
  		[
  			2785,
  			2787
  		],
  		2
  	],
  	[
  		[
  			2788,
  			2789
  		],
  		3
  	],
  	[
  		[
  			2790,
  			2799
  		],
  		2
  	],
  	[
  		2800,
  		2
  	],
  	[
  		2801,
  		2
  	],
  	[
  		[
  			2802,
  			2808
  		],
  		3
  	],
  	[
  		2809,
  		2
  	],
  	[
  		[
  			2810,
  			2815
  		],
  		2
  	],
  	[
  		2816,
  		3
  	],
  	[
  		[
  			2817,
  			2819
  		],
  		2
  	],
  	[
  		2820,
  		3
  	],
  	[
  		[
  			2821,
  			2828
  		],
  		2
  	],
  	[
  		[
  			2829,
  			2830
  		],
  		3
  	],
  	[
  		[
  			2831,
  			2832
  		],
  		2
  	],
  	[
  		[
  			2833,
  			2834
  		],
  		3
  	],
  	[
  		[
  			2835,
  			2856
  		],
  		2
  	],
  	[
  		2857,
  		3
  	],
  	[
  		[
  			2858,
  			2864
  		],
  		2
  	],
  	[
  		2865,
  		3
  	],
  	[
  		[
  			2866,
  			2867
  		],
  		2
  	],
  	[
  		2868,
  		3
  	],
  	[
  		2869,
  		2
  	],
  	[
  		[
  			2870,
  			2873
  		],
  		2
  	],
  	[
  		[
  			2874,
  			2875
  		],
  		3
  	],
  	[
  		[
  			2876,
  			2883
  		],
  		2
  	],
  	[
  		2884,
  		2
  	],
  	[
  		[
  			2885,
  			2886
  		],
  		3
  	],
  	[
  		[
  			2887,
  			2888
  		],
  		2
  	],
  	[
  		[
  			2889,
  			2890
  		],
  		3
  	],
  	[
  		[
  			2891,
  			2893
  		],
  		2
  	],
  	[
  		[
  			2894,
  			2900
  		],
  		3
  	],
  	[
  		2901,
  		2
  	],
  	[
  		[
  			2902,
  			2903
  		],
  		2
  	],
  	[
  		[
  			2904,
  			2907
  		],
  		3
  	],
  	[
  		2908,
  		1,
  		"ଡ଼"
  	],
  	[
  		2909,
  		1,
  		"ଢ଼"
  	],
  	[
  		2910,
  		3
  	],
  	[
  		[
  			2911,
  			2913
  		],
  		2
  	],
  	[
  		[
  			2914,
  			2915
  		],
  		2
  	],
  	[
  		[
  			2916,
  			2917
  		],
  		3
  	],
  	[
  		[
  			2918,
  			2927
  		],
  		2
  	],
  	[
  		2928,
  		2
  	],
  	[
  		2929,
  		2
  	],
  	[
  		[
  			2930,
  			2935
  		],
  		2
  	],
  	[
  		[
  			2936,
  			2945
  		],
  		3
  	],
  	[
  		[
  			2946,
  			2947
  		],
  		2
  	],
  	[
  		2948,
  		3
  	],
  	[
  		[
  			2949,
  			2954
  		],
  		2
  	],
  	[
  		[
  			2955,
  			2957
  		],
  		3
  	],
  	[
  		[
  			2958,
  			2960
  		],
  		2
  	],
  	[
  		2961,
  		3
  	],
  	[
  		[
  			2962,
  			2965
  		],
  		2
  	],
  	[
  		[
  			2966,
  			2968
  		],
  		3
  	],
  	[
  		[
  			2969,
  			2970
  		],
  		2
  	],
  	[
  		2971,
  		3
  	],
  	[
  		2972,
  		2
  	],
  	[
  		2973,
  		3
  	],
  	[
  		[
  			2974,
  			2975
  		],
  		2
  	],
  	[
  		[
  			2976,
  			2978
  		],
  		3
  	],
  	[
  		[
  			2979,
  			2980
  		],
  		2
  	],
  	[
  		[
  			2981,
  			2983
  		],
  		3
  	],
  	[
  		[
  			2984,
  			2986
  		],
  		2
  	],
  	[
  		[
  			2987,
  			2989
  		],
  		3
  	],
  	[
  		[
  			2990,
  			2997
  		],
  		2
  	],
  	[
  		2998,
  		2
  	],
  	[
  		[
  			2999,
  			3001
  		],
  		2
  	],
  	[
  		[
  			3002,
  			3005
  		],
  		3
  	],
  	[
  		[
  			3006,
  			3010
  		],
  		2
  	],
  	[
  		[
  			3011,
  			3013
  		],
  		3
  	],
  	[
  		[
  			3014,
  			3016
  		],
  		2
  	],
  	[
  		3017,
  		3
  	],
  	[
  		[
  			3018,
  			3021
  		],
  		2
  	],
  	[
  		[
  			3022,
  			3023
  		],
  		3
  	],
  	[
  		3024,
  		2
  	],
  	[
  		[
  			3025,
  			3030
  		],
  		3
  	],
  	[
  		3031,
  		2
  	],
  	[
  		[
  			3032,
  			3045
  		],
  		3
  	],
  	[
  		3046,
  		2
  	],
  	[
  		[
  			3047,
  			3055
  		],
  		2
  	],
  	[
  		[
  			3056,
  			3058
  		],
  		2
  	],
  	[
  		[
  			3059,
  			3066
  		],
  		2
  	],
  	[
  		[
  			3067,
  			3071
  		],
  		3
  	],
  	[
  		3072,
  		2
  	],
  	[
  		[
  			3073,
  			3075
  		],
  		2
  	],
  	[
  		3076,
  		2
  	],
  	[
  		[
  			3077,
  			3084
  		],
  		2
  	],
  	[
  		3085,
  		3
  	],
  	[
  		[
  			3086,
  			3088
  		],
  		2
  	],
  	[
  		3089,
  		3
  	],
  	[
  		[
  			3090,
  			3112
  		],
  		2
  	],
  	[
  		3113,
  		3
  	],
  	[
  		[
  			3114,
  			3123
  		],
  		2
  	],
  	[
  		3124,
  		2
  	],
  	[
  		[
  			3125,
  			3129
  		],
  		2
  	],
  	[
  		[
  			3130,
  			3132
  		],
  		3
  	],
  	[
  		3133,
  		2
  	],
  	[
  		[
  			3134,
  			3140
  		],
  		2
  	],
  	[
  		3141,
  		3
  	],
  	[
  		[
  			3142,
  			3144
  		],
  		2
  	],
  	[
  		3145,
  		3
  	],
  	[
  		[
  			3146,
  			3149
  		],
  		2
  	],
  	[
  		[
  			3150,
  			3156
  		],
  		3
  	],
  	[
  		[
  			3157,
  			3158
  		],
  		2
  	],
  	[
  		3159,
  		3
  	],
  	[
  		[
  			3160,
  			3161
  		],
  		2
  	],
  	[
  		3162,
  		2
  	],
  	[
  		[
  			3163,
  			3167
  		],
  		3
  	],
  	[
  		[
  			3168,
  			3169
  		],
  		2
  	],
  	[
  		[
  			3170,
  			3171
  		],
  		2
  	],
  	[
  		[
  			3172,
  			3173
  		],
  		3
  	],
  	[
  		[
  			3174,
  			3183
  		],
  		2
  	],
  	[
  		[
  			3184,
  			3190
  		],
  		3
  	],
  	[
  		3191,
  		2
  	],
  	[
  		[
  			3192,
  			3199
  		],
  		2
  	],
  	[
  		3200,
  		2
  	],
  	[
  		3201,
  		2
  	],
  	[
  		[
  			3202,
  			3203
  		],
  		2
  	],
  	[
  		3204,
  		2
  	],
  	[
  		[
  			3205,
  			3212
  		],
  		2
  	],
  	[
  		3213,
  		3
  	],
  	[
  		[
  			3214,
  			3216
  		],
  		2
  	],
  	[
  		3217,
  		3
  	],
  	[
  		[
  			3218,
  			3240
  		],
  		2
  	],
  	[
  		3241,
  		3
  	],
  	[
  		[
  			3242,
  			3251
  		],
  		2
  	],
  	[
  		3252,
  		3
  	],
  	[
  		[
  			3253,
  			3257
  		],
  		2
  	],
  	[
  		[
  			3258,
  			3259
  		],
  		3
  	],
  	[
  		[
  			3260,
  			3261
  		],
  		2
  	],
  	[
  		[
  			3262,
  			3268
  		],
  		2
  	],
  	[
  		3269,
  		3
  	],
  	[
  		[
  			3270,
  			3272
  		],
  		2
  	],
  	[
  		3273,
  		3
  	],
  	[
  		[
  			3274,
  			3277
  		],
  		2
  	],
  	[
  		[
  			3278,
  			3284
  		],
  		3
  	],
  	[
  		[
  			3285,
  			3286
  		],
  		2
  	],
  	[
  		[
  			3287,
  			3293
  		],
  		3
  	],
  	[
  		3294,
  		2
  	],
  	[
  		3295,
  		3
  	],
  	[
  		[
  			3296,
  			3297
  		],
  		2
  	],
  	[
  		[
  			3298,
  			3299
  		],
  		2
  	],
  	[
  		[
  			3300,
  			3301
  		],
  		3
  	],
  	[
  		[
  			3302,
  			3311
  		],
  		2
  	],
  	[
  		3312,
  		3
  	],
  	[
  		[
  			3313,
  			3314
  		],
  		2
  	],
  	[
  		[
  			3315,
  			3327
  		],
  		3
  	],
  	[
  		3328,
  		2
  	],
  	[
  		3329,
  		2
  	],
  	[
  		[
  			3330,
  			3331
  		],
  		2
  	],
  	[
  		3332,
  		2
  	],
  	[
  		[
  			3333,
  			3340
  		],
  		2
  	],
  	[
  		3341,
  		3
  	],
  	[
  		[
  			3342,
  			3344
  		],
  		2
  	],
  	[
  		3345,
  		3
  	],
  	[
  		[
  			3346,
  			3368
  		],
  		2
  	],
  	[
  		3369,
  		2
  	],
  	[
  		[
  			3370,
  			3385
  		],
  		2
  	],
  	[
  		3386,
  		2
  	],
  	[
  		[
  			3387,
  			3388
  		],
  		2
  	],
  	[
  		3389,
  		2
  	],
  	[
  		[
  			3390,
  			3395
  		],
  		2
  	],
  	[
  		3396,
  		2
  	],
  	[
  		3397,
  		3
  	],
  	[
  		[
  			3398,
  			3400
  		],
  		2
  	],
  	[
  		3401,
  		3
  	],
  	[
  		[
  			3402,
  			3405
  		],
  		2
  	],
  	[
  		3406,
  		2
  	],
  	[
  		3407,
  		2
  	],
  	[
  		[
  			3408,
  			3411
  		],
  		3
  	],
  	[
  		[
  			3412,
  			3414
  		],
  		2
  	],
  	[
  		3415,
  		2
  	],
  	[
  		[
  			3416,
  			3422
  		],
  		2
  	],
  	[
  		3423,
  		2
  	],
  	[
  		[
  			3424,
  			3425
  		],
  		2
  	],
  	[
  		[
  			3426,
  			3427
  		],
  		2
  	],
  	[
  		[
  			3428,
  			3429
  		],
  		3
  	],
  	[
  		[
  			3430,
  			3439
  		],
  		2
  	],
  	[
  		[
  			3440,
  			3445
  		],
  		2
  	],
  	[
  		[
  			3446,
  			3448
  		],
  		2
  	],
  	[
  		3449,
  		2
  	],
  	[
  		[
  			3450,
  			3455
  		],
  		2
  	],
  	[
  		3456,
  		3
  	],
  	[
  		3457,
  		2
  	],
  	[
  		[
  			3458,
  			3459
  		],
  		2
  	],
  	[
  		3460,
  		3
  	],
  	[
  		[
  			3461,
  			3478
  		],
  		2
  	],
  	[
  		[
  			3479,
  			3481
  		],
  		3
  	],
  	[
  		[
  			3482,
  			3505
  		],
  		2
  	],
  	[
  		3506,
  		3
  	],
  	[
  		[
  			3507,
  			3515
  		],
  		2
  	],
  	[
  		3516,
  		3
  	],
  	[
  		3517,
  		2
  	],
  	[
  		[
  			3518,
  			3519
  		],
  		3
  	],
  	[
  		[
  			3520,
  			3526
  		],
  		2
  	],
  	[
  		[
  			3527,
  			3529
  		],
  		3
  	],
  	[
  		3530,
  		2
  	],
  	[
  		[
  			3531,
  			3534
  		],
  		3
  	],
  	[
  		[
  			3535,
  			3540
  		],
  		2
  	],
  	[
  		3541,
  		3
  	],
  	[
  		3542,
  		2
  	],
  	[
  		3543,
  		3
  	],
  	[
  		[
  			3544,
  			3551
  		],
  		2
  	],
  	[
  		[
  			3552,
  			3557
  		],
  		3
  	],
  	[
  		[
  			3558,
  			3567
  		],
  		2
  	],
  	[
  		[
  			3568,
  			3569
  		],
  		3
  	],
  	[
  		[
  			3570,
  			3571
  		],
  		2
  	],
  	[
  		3572,
  		2
  	],
  	[
  		[
  			3573,
  			3584
  		],
  		3
  	],
  	[
  		[
  			3585,
  			3634
  		],
  		2
  	],
  	[
  		3635,
  		1,
  		"ํา"
  	],
  	[
  		[
  			3636,
  			3642
  		],
  		2
  	],
  	[
  		[
  			3643,
  			3646
  		],
  		3
  	],
  	[
  		3647,
  		2
  	],
  	[
  		[
  			3648,
  			3662
  		],
  		2
  	],
  	[
  		3663,
  		2
  	],
  	[
  		[
  			3664,
  			3673
  		],
  		2
  	],
  	[
  		[
  			3674,
  			3675
  		],
  		2
  	],
  	[
  		[
  			3676,
  			3712
  		],
  		3
  	],
  	[
  		[
  			3713,
  			3714
  		],
  		2
  	],
  	[
  		3715,
  		3
  	],
  	[
  		3716,
  		2
  	],
  	[
  		3717,
  		3
  	],
  	[
  		3718,
  		2
  	],
  	[
  		[
  			3719,
  			3720
  		],
  		2
  	],
  	[
  		3721,
  		2
  	],
  	[
  		3722,
  		2
  	],
  	[
  		3723,
  		3
  	],
  	[
  		3724,
  		2
  	],
  	[
  		3725,
  		2
  	],
  	[
  		[
  			3726,
  			3731
  		],
  		2
  	],
  	[
  		[
  			3732,
  			3735
  		],
  		2
  	],
  	[
  		3736,
  		2
  	],
  	[
  		[
  			3737,
  			3743
  		],
  		2
  	],
  	[
  		3744,
  		2
  	],
  	[
  		[
  			3745,
  			3747
  		],
  		2
  	],
  	[
  		3748,
  		3
  	],
  	[
  		3749,
  		2
  	],
  	[
  		3750,
  		3
  	],
  	[
  		3751,
  		2
  	],
  	[
  		[
  			3752,
  			3753
  		],
  		2
  	],
  	[
  		[
  			3754,
  			3755
  		],
  		2
  	],
  	[
  		3756,
  		2
  	],
  	[
  		[
  			3757,
  			3762
  		],
  		2
  	],
  	[
  		3763,
  		1,
  		"ໍາ"
  	],
  	[
  		[
  			3764,
  			3769
  		],
  		2
  	],
  	[
  		3770,
  		2
  	],
  	[
  		[
  			3771,
  			3773
  		],
  		2
  	],
  	[
  		[
  			3774,
  			3775
  		],
  		3
  	],
  	[
  		[
  			3776,
  			3780
  		],
  		2
  	],
  	[
  		3781,
  		3
  	],
  	[
  		3782,
  		2
  	],
  	[
  		3783,
  		3
  	],
  	[
  		[
  			3784,
  			3789
  		],
  		2
  	],
  	[
  		[
  			3790,
  			3791
  		],
  		3
  	],
  	[
  		[
  			3792,
  			3801
  		],
  		2
  	],
  	[
  		[
  			3802,
  			3803
  		],
  		3
  	],
  	[
  		3804,
  		1,
  		"ຫນ"
  	],
  	[
  		3805,
  		1,
  		"ຫມ"
  	],
  	[
  		[
  			3806,
  			3807
  		],
  		2
  	],
  	[
  		[
  			3808,
  			3839
  		],
  		3
  	],
  	[
  		3840,
  		2
  	],
  	[
  		[
  			3841,
  			3850
  		],
  		2
  	],
  	[
  		3851,
  		2
  	],
  	[
  		3852,
  		1,
  		"་"
  	],
  	[
  		[
  			3853,
  			3863
  		],
  		2
  	],
  	[
  		[
  			3864,
  			3865
  		],
  		2
  	],
  	[
  		[
  			3866,
  			3871
  		],
  		2
  	],
  	[
  		[
  			3872,
  			3881
  		],
  		2
  	],
  	[
  		[
  			3882,
  			3892
  		],
  		2
  	],
  	[
  		3893,
  		2
  	],
  	[
  		3894,
  		2
  	],
  	[
  		3895,
  		2
  	],
  	[
  		3896,
  		2
  	],
  	[
  		3897,
  		2
  	],
  	[
  		[
  			3898,
  			3901
  		],
  		2
  	],
  	[
  		[
  			3902,
  			3906
  		],
  		2
  	],
  	[
  		3907,
  		1,
  		"གྷ"
  	],
  	[
  		[
  			3908,
  			3911
  		],
  		2
  	],
  	[
  		3912,
  		3
  	],
  	[
  		[
  			3913,
  			3916
  		],
  		2
  	],
  	[
  		3917,
  		1,
  		"ཌྷ"
  	],
  	[
  		[
  			3918,
  			3921
  		],
  		2
  	],
  	[
  		3922,
  		1,
  		"དྷ"
  	],
  	[
  		[
  			3923,
  			3926
  		],
  		2
  	],
  	[
  		3927,
  		1,
  		"བྷ"
  	],
  	[
  		[
  			3928,
  			3931
  		],
  		2
  	],
  	[
  		3932,
  		1,
  		"ཛྷ"
  	],
  	[
  		[
  			3933,
  			3944
  		],
  		2
  	],
  	[
  		3945,
  		1,
  		"ཀྵ"
  	],
  	[
  		3946,
  		2
  	],
  	[
  		[
  			3947,
  			3948
  		],
  		2
  	],
  	[
  		[
  			3949,
  			3952
  		],
  		3
  	],
  	[
  		[
  			3953,
  			3954
  		],
  		2
  	],
  	[
  		3955,
  		1,
  		"ཱི"
  	],
  	[
  		3956,
  		2
  	],
  	[
  		3957,
  		1,
  		"ཱུ"
  	],
  	[
  		3958,
  		1,
  		"ྲྀ"
  	],
  	[
  		3959,
  		1,
  		"ྲཱྀ"
  	],
  	[
  		3960,
  		1,
  		"ླྀ"
  	],
  	[
  		3961,
  		1,
  		"ླཱྀ"
  	],
  	[
  		[
  			3962,
  			3968
  		],
  		2
  	],
  	[
  		3969,
  		1,
  		"ཱྀ"
  	],
  	[
  		[
  			3970,
  			3972
  		],
  		2
  	],
  	[
  		3973,
  		2
  	],
  	[
  		[
  			3974,
  			3979
  		],
  		2
  	],
  	[
  		[
  			3980,
  			3983
  		],
  		2
  	],
  	[
  		[
  			3984,
  			3986
  		],
  		2
  	],
  	[
  		3987,
  		1,
  		"ྒྷ"
  	],
  	[
  		[
  			3988,
  			3989
  		],
  		2
  	],
  	[
  		3990,
  		2
  	],
  	[
  		3991,
  		2
  	],
  	[
  		3992,
  		3
  	],
  	[
  		[
  			3993,
  			3996
  		],
  		2
  	],
  	[
  		3997,
  		1,
  		"ྜྷ"
  	],
  	[
  		[
  			3998,
  			4001
  		],
  		2
  	],
  	[
  		4002,
  		1,
  		"ྡྷ"
  	],
  	[
  		[
  			4003,
  			4006
  		],
  		2
  	],
  	[
  		4007,
  		1,
  		"ྦྷ"
  	],
  	[
  		[
  			4008,
  			4011
  		],
  		2
  	],
  	[
  		4012,
  		1,
  		"ྫྷ"
  	],
  	[
  		4013,
  		2
  	],
  	[
  		[
  			4014,
  			4016
  		],
  		2
  	],
  	[
  		[
  			4017,
  			4023
  		],
  		2
  	],
  	[
  		4024,
  		2
  	],
  	[
  		4025,
  		1,
  		"ྐྵ"
  	],
  	[
  		[
  			4026,
  			4028
  		],
  		2
  	],
  	[
  		4029,
  		3
  	],
  	[
  		[
  			4030,
  			4037
  		],
  		2
  	],
  	[
  		4038,
  		2
  	],
  	[
  		[
  			4039,
  			4044
  		],
  		2
  	],
  	[
  		4045,
  		3
  	],
  	[
  		4046,
  		2
  	],
  	[
  		4047,
  		2
  	],
  	[
  		[
  			4048,
  			4049
  		],
  		2
  	],
  	[
  		[
  			4050,
  			4052
  		],
  		2
  	],
  	[
  		[
  			4053,
  			4056
  		],
  		2
  	],
  	[
  		[
  			4057,
  			4058
  		],
  		2
  	],
  	[
  		[
  			4059,
  			4095
  		],
  		3
  	],
  	[
  		[
  			4096,
  			4129
  		],
  		2
  	],
  	[
  		4130,
  		2
  	],
  	[
  		[
  			4131,
  			4135
  		],
  		2
  	],
  	[
  		4136,
  		2
  	],
  	[
  		[
  			4137,
  			4138
  		],
  		2
  	],
  	[
  		4139,
  		2
  	],
  	[
  		[
  			4140,
  			4146
  		],
  		2
  	],
  	[
  		[
  			4147,
  			4149
  		],
  		2
  	],
  	[
  		[
  			4150,
  			4153
  		],
  		2
  	],
  	[
  		[
  			4154,
  			4159
  		],
  		2
  	],
  	[
  		[
  			4160,
  			4169
  		],
  		2
  	],
  	[
  		[
  			4170,
  			4175
  		],
  		2
  	],
  	[
  		[
  			4176,
  			4185
  		],
  		2
  	],
  	[
  		[
  			4186,
  			4249
  		],
  		2
  	],
  	[
  		[
  			4250,
  			4253
  		],
  		2
  	],
  	[
  		[
  			4254,
  			4255
  		],
  		2
  	],
  	[
  		[
  			4256,
  			4293
  		],
  		3
  	],
  	[
  		4294,
  		3
  	],
  	[
  		4295,
  		1,
  		"ⴧ"
  	],
  	[
  		[
  			4296,
  			4300
  		],
  		3
  	],
  	[
  		4301,
  		1,
  		"ⴭ"
  	],
  	[
  		[
  			4302,
  			4303
  		],
  		3
  	],
  	[
  		[
  			4304,
  			4342
  		],
  		2
  	],
  	[
  		[
  			4343,
  			4344
  		],
  		2
  	],
  	[
  		[
  			4345,
  			4346
  		],
  		2
  	],
  	[
  		4347,
  		2
  	],
  	[
  		4348,
  		1,
  		"ნ"
  	],
  	[
  		[
  			4349,
  			4351
  		],
  		2
  	],
  	[
  		[
  			4352,
  			4441
  		],
  		2
  	],
  	[
  		[
  			4442,
  			4446
  		],
  		2
  	],
  	[
  		[
  			4447,
  			4448
  		],
  		3
  	],
  	[
  		[
  			4449,
  			4514
  		],
  		2
  	],
  	[
  		[
  			4515,
  			4519
  		],
  		2
  	],
  	[
  		[
  			4520,
  			4601
  		],
  		2
  	],
  	[
  		[
  			4602,
  			4607
  		],
  		2
  	],
  	[
  		[
  			4608,
  			4614
  		],
  		2
  	],
  	[
  		4615,
  		2
  	],
  	[
  		[
  			4616,
  			4678
  		],
  		2
  	],
  	[
  		4679,
  		2
  	],
  	[
  		4680,
  		2
  	],
  	[
  		4681,
  		3
  	],
  	[
  		[
  			4682,
  			4685
  		],
  		2
  	],
  	[
  		[
  			4686,
  			4687
  		],
  		3
  	],
  	[
  		[
  			4688,
  			4694
  		],
  		2
  	],
  	[
  		4695,
  		3
  	],
  	[
  		4696,
  		2
  	],
  	[
  		4697,
  		3
  	],
  	[
  		[
  			4698,
  			4701
  		],
  		2
  	],
  	[
  		[
  			4702,
  			4703
  		],
  		3
  	],
  	[
  		[
  			4704,
  			4742
  		],
  		2
  	],
  	[
  		4743,
  		2
  	],
  	[
  		4744,
  		2
  	],
  	[
  		4745,
  		3
  	],
  	[
  		[
  			4746,
  			4749
  		],
  		2
  	],
  	[
  		[
  			4750,
  			4751
  		],
  		3
  	],
  	[
  		[
  			4752,
  			4782
  		],
  		2
  	],
  	[
  		4783,
  		2
  	],
  	[
  		4784,
  		2
  	],
  	[
  		4785,
  		3
  	],
  	[
  		[
  			4786,
  			4789
  		],
  		2
  	],
  	[
  		[
  			4790,
  			4791
  		],
  		3
  	],
  	[
  		[
  			4792,
  			4798
  		],
  		2
  	],
  	[
  		4799,
  		3
  	],
  	[
  		4800,
  		2
  	],
  	[
  		4801,
  		3
  	],
  	[
  		[
  			4802,
  			4805
  		],
  		2
  	],
  	[
  		[
  			4806,
  			4807
  		],
  		3
  	],
  	[
  		[
  			4808,
  			4814
  		],
  		2
  	],
  	[
  		4815,
  		2
  	],
  	[
  		[
  			4816,
  			4822
  		],
  		2
  	],
  	[
  		4823,
  		3
  	],
  	[
  		[
  			4824,
  			4846
  		],
  		2
  	],
  	[
  		4847,
  		2
  	],
  	[
  		[
  			4848,
  			4878
  		],
  		2
  	],
  	[
  		4879,
  		2
  	],
  	[
  		4880,
  		2
  	],
  	[
  		4881,
  		3
  	],
  	[
  		[
  			4882,
  			4885
  		],
  		2
  	],
  	[
  		[
  			4886,
  			4887
  		],
  		3
  	],
  	[
  		[
  			4888,
  			4894
  		],
  		2
  	],
  	[
  		4895,
  		2
  	],
  	[
  		[
  			4896,
  			4934
  		],
  		2
  	],
  	[
  		4935,
  		2
  	],
  	[
  		[
  			4936,
  			4954
  		],
  		2
  	],
  	[
  		[
  			4955,
  			4956
  		],
  		3
  	],
  	[
  		[
  			4957,
  			4958
  		],
  		2
  	],
  	[
  		4959,
  		2
  	],
  	[
  		4960,
  		2
  	],
  	[
  		[
  			4961,
  			4988
  		],
  		2
  	],
  	[
  		[
  			4989,
  			4991
  		],
  		3
  	],
  	[
  		[
  			4992,
  			5007
  		],
  		2
  	],
  	[
  		[
  			5008,
  			5017
  		],
  		2
  	],
  	[
  		[
  			5018,
  			5023
  		],
  		3
  	],
  	[
  		[
  			5024,
  			5108
  		],
  		2
  	],
  	[
  		5109,
  		2
  	],
  	[
  		[
  			5110,
  			5111
  		],
  		3
  	],
  	[
  		5112,
  		1,
  		"Ᏸ"
  	],
  	[
  		5113,
  		1,
  		"Ᏹ"
  	],
  	[
  		5114,
  		1,
  		"Ᏺ"
  	],
  	[
  		5115,
  		1,
  		"Ᏻ"
  	],
  	[
  		5116,
  		1,
  		"Ᏼ"
  	],
  	[
  		5117,
  		1,
  		"Ᏽ"
  	],
  	[
  		[
  			5118,
  			5119
  		],
  		3
  	],
  	[
  		5120,
  		2
  	],
  	[
  		[
  			5121,
  			5740
  		],
  		2
  	],
  	[
  		[
  			5741,
  			5742
  		],
  		2
  	],
  	[
  		[
  			5743,
  			5750
  		],
  		2
  	],
  	[
  		[
  			5751,
  			5759
  		],
  		2
  	],
  	[
  		5760,
  		3
  	],
  	[
  		[
  			5761,
  			5786
  		],
  		2
  	],
  	[
  		[
  			5787,
  			5788
  		],
  		2
  	],
  	[
  		[
  			5789,
  			5791
  		],
  		3
  	],
  	[
  		[
  			5792,
  			5866
  		],
  		2
  	],
  	[
  		[
  			5867,
  			5872
  		],
  		2
  	],
  	[
  		[
  			5873,
  			5880
  		],
  		2
  	],
  	[
  		[
  			5881,
  			5887
  		],
  		3
  	],
  	[
  		[
  			5888,
  			5900
  		],
  		2
  	],
  	[
  		5901,
  		3
  	],
  	[
  		[
  			5902,
  			5908
  		],
  		2
  	],
  	[
  		[
  			5909,
  			5919
  		],
  		3
  	],
  	[
  		[
  			5920,
  			5940
  		],
  		2
  	],
  	[
  		[
  			5941,
  			5942
  		],
  		2
  	],
  	[
  		[
  			5943,
  			5951
  		],
  		3
  	],
  	[
  		[
  			5952,
  			5971
  		],
  		2
  	],
  	[
  		[
  			5972,
  			5983
  		],
  		3
  	],
  	[
  		[
  			5984,
  			5996
  		],
  		2
  	],
  	[
  		5997,
  		3
  	],
  	[
  		[
  			5998,
  			6000
  		],
  		2
  	],
  	[
  		6001,
  		3
  	],
  	[
  		[
  			6002,
  			6003
  		],
  		2
  	],
  	[
  		[
  			6004,
  			6015
  		],
  		3
  	],
  	[
  		[
  			6016,
  			6067
  		],
  		2
  	],
  	[
  		[
  			6068,
  			6069
  		],
  		3
  	],
  	[
  		[
  			6070,
  			6099
  		],
  		2
  	],
  	[
  		[
  			6100,
  			6102
  		],
  		2
  	],
  	[
  		6103,
  		2
  	],
  	[
  		[
  			6104,
  			6107
  		],
  		2
  	],
  	[
  		6108,
  		2
  	],
  	[
  		6109,
  		2
  	],
  	[
  		[
  			6110,
  			6111
  		],
  		3
  	],
  	[
  		[
  			6112,
  			6121
  		],
  		2
  	],
  	[
  		[
  			6122,
  			6127
  		],
  		3
  	],
  	[
  		[
  			6128,
  			6137
  		],
  		2
  	],
  	[
  		[
  			6138,
  			6143
  		],
  		3
  	],
  	[
  		[
  			6144,
  			6149
  		],
  		2
  	],
  	[
  		6150,
  		3
  	],
  	[
  		[
  			6151,
  			6154
  		],
  		2
  	],
  	[
  		[
  			6155,
  			6157
  		],
  		7
  	],
  	[
  		6158,
  		3
  	],
  	[
  		6159,
  		3
  	],
  	[
  		[
  			6160,
  			6169
  		],
  		2
  	],
  	[
  		[
  			6170,
  			6175
  		],
  		3
  	],
  	[
  		[
  			6176,
  			6263
  		],
  		2
  	],
  	[
  		6264,
  		2
  	],
  	[
  		[
  			6265,
  			6271
  		],
  		3
  	],
  	[
  		[
  			6272,
  			6313
  		],
  		2
  	],
  	[
  		6314,
  		2
  	],
  	[
  		[
  			6315,
  			6319
  		],
  		3
  	],
  	[
  		[
  			6320,
  			6389
  		],
  		2
  	],
  	[
  		[
  			6390,
  			6399
  		],
  		3
  	],
  	[
  		[
  			6400,
  			6428
  		],
  		2
  	],
  	[
  		[
  			6429,
  			6430
  		],
  		2
  	],
  	[
  		6431,
  		3
  	],
  	[
  		[
  			6432,
  			6443
  		],
  		2
  	],
  	[
  		[
  			6444,
  			6447
  		],
  		3
  	],
  	[
  		[
  			6448,
  			6459
  		],
  		2
  	],
  	[
  		[
  			6460,
  			6463
  		],
  		3
  	],
  	[
  		6464,
  		2
  	],
  	[
  		[
  			6465,
  			6467
  		],
  		3
  	],
  	[
  		[
  			6468,
  			6469
  		],
  		2
  	],
  	[
  		[
  			6470,
  			6509
  		],
  		2
  	],
  	[
  		[
  			6510,
  			6511
  		],
  		3
  	],
  	[
  		[
  			6512,
  			6516
  		],
  		2
  	],
  	[
  		[
  			6517,
  			6527
  		],
  		3
  	],
  	[
  		[
  			6528,
  			6569
  		],
  		2
  	],
  	[
  		[
  			6570,
  			6571
  		],
  		2
  	],
  	[
  		[
  			6572,
  			6575
  		],
  		3
  	],
  	[
  		[
  			6576,
  			6601
  		],
  		2
  	],
  	[
  		[
  			6602,
  			6607
  		],
  		3
  	],
  	[
  		[
  			6608,
  			6617
  		],
  		2
  	],
  	[
  		6618,
  		2
  	],
  	[
  		[
  			6619,
  			6621
  		],
  		3
  	],
  	[
  		[
  			6622,
  			6623
  		],
  		2
  	],
  	[
  		[
  			6624,
  			6655
  		],
  		2
  	],
  	[
  		[
  			6656,
  			6683
  		],
  		2
  	],
  	[
  		[
  			6684,
  			6685
  		],
  		3
  	],
  	[
  		[
  			6686,
  			6687
  		],
  		2
  	],
  	[
  		[
  			6688,
  			6750
  		],
  		2
  	],
  	[
  		6751,
  		3
  	],
  	[
  		[
  			6752,
  			6780
  		],
  		2
  	],
  	[
  		[
  			6781,
  			6782
  		],
  		3
  	],
  	[
  		[
  			6783,
  			6793
  		],
  		2
  	],
  	[
  		[
  			6794,
  			6799
  		],
  		3
  	],
  	[
  		[
  			6800,
  			6809
  		],
  		2
  	],
  	[
  		[
  			6810,
  			6815
  		],
  		3
  	],
  	[
  		[
  			6816,
  			6822
  		],
  		2
  	],
  	[
  		6823,
  		2
  	],
  	[
  		[
  			6824,
  			6829
  		],
  		2
  	],
  	[
  		[
  			6830,
  			6831
  		],
  		3
  	],
  	[
  		[
  			6832,
  			6845
  		],
  		2
  	],
  	[
  		6846,
  		2
  	],
  	[
  		[
  			6847,
  			6848
  		],
  		2
  	],
  	[
  		[
  			6849,
  			6911
  		],
  		3
  	],
  	[
  		[
  			6912,
  			6987
  		],
  		2
  	],
  	[
  		[
  			6988,
  			6991
  		],
  		3
  	],
  	[
  		[
  			6992,
  			7001
  		],
  		2
  	],
  	[
  		[
  			7002,
  			7018
  		],
  		2
  	],
  	[
  		[
  			7019,
  			7027
  		],
  		2
  	],
  	[
  		[
  			7028,
  			7036
  		],
  		2
  	],
  	[
  		[
  			7037,
  			7039
  		],
  		3
  	],
  	[
  		[
  			7040,
  			7082
  		],
  		2
  	],
  	[
  		[
  			7083,
  			7085
  		],
  		2
  	],
  	[
  		[
  			7086,
  			7097
  		],
  		2
  	],
  	[
  		[
  			7098,
  			7103
  		],
  		2
  	],
  	[
  		[
  			7104,
  			7155
  		],
  		2
  	],
  	[
  		[
  			7156,
  			7163
  		],
  		3
  	],
  	[
  		[
  			7164,
  			7167
  		],
  		2
  	],
  	[
  		[
  			7168,
  			7223
  		],
  		2
  	],
  	[
  		[
  			7224,
  			7226
  		],
  		3
  	],
  	[
  		[
  			7227,
  			7231
  		],
  		2
  	],
  	[
  		[
  			7232,
  			7241
  		],
  		2
  	],
  	[
  		[
  			7242,
  			7244
  		],
  		3
  	],
  	[
  		[
  			7245,
  			7293
  		],
  		2
  	],
  	[
  		[
  			7294,
  			7295
  		],
  		2
  	],
  	[
  		7296,
  		1,
  		"в"
  	],
  	[
  		7297,
  		1,
  		"д"
  	],
  	[
  		7298,
  		1,
  		"о"
  	],
  	[
  		7299,
  		1,
  		"с"
  	],
  	[
  		[
  			7300,
  			7301
  		],
  		1,
  		"т"
  	],
  	[
  		7302,
  		1,
  		"ъ"
  	],
  	[
  		7303,
  		1,
  		"ѣ"
  	],
  	[
  		7304,
  		1,
  		"ꙋ"
  	],
  	[
  		[
  			7305,
  			7311
  		],
  		3
  	],
  	[
  		7312,
  		1,
  		"ა"
  	],
  	[
  		7313,
  		1,
  		"ბ"
  	],
  	[
  		7314,
  		1,
  		"გ"
  	],
  	[
  		7315,
  		1,
  		"დ"
  	],
  	[
  		7316,
  		1,
  		"ე"
  	],
  	[
  		7317,
  		1,
  		"ვ"
  	],
  	[
  		7318,
  		1,
  		"ზ"
  	],
  	[
  		7319,
  		1,
  		"თ"
  	],
  	[
  		7320,
  		1,
  		"ი"
  	],
  	[
  		7321,
  		1,
  		"კ"
  	],
  	[
  		7322,
  		1,
  		"ლ"
  	],
  	[
  		7323,
  		1,
  		"მ"
  	],
  	[
  		7324,
  		1,
  		"ნ"
  	],
  	[
  		7325,
  		1,
  		"ო"
  	],
  	[
  		7326,
  		1,
  		"პ"
  	],
  	[
  		7327,
  		1,
  		"ჟ"
  	],
  	[
  		7328,
  		1,
  		"რ"
  	],
  	[
  		7329,
  		1,
  		"ს"
  	],
  	[
  		7330,
  		1,
  		"ტ"
  	],
  	[
  		7331,
  		1,
  		"უ"
  	],
  	[
  		7332,
  		1,
  		"ფ"
  	],
  	[
  		7333,
  		1,
  		"ქ"
  	],
  	[
  		7334,
  		1,
  		"ღ"
  	],
  	[
  		7335,
  		1,
  		"ყ"
  	],
  	[
  		7336,
  		1,
  		"შ"
  	],
  	[
  		7337,
  		1,
  		"ჩ"
  	],
  	[
  		7338,
  		1,
  		"ც"
  	],
  	[
  		7339,
  		1,
  		"ძ"
  	],
  	[
  		7340,
  		1,
  		"წ"
  	],
  	[
  		7341,
  		1,
  		"ჭ"
  	],
  	[
  		7342,
  		1,
  		"ხ"
  	],
  	[
  		7343,
  		1,
  		"ჯ"
  	],
  	[
  		7344,
  		1,
  		"ჰ"
  	],
  	[
  		7345,
  		1,
  		"ჱ"
  	],
  	[
  		7346,
  		1,
  		"ჲ"
  	],
  	[
  		7347,
  		1,
  		"ჳ"
  	],
  	[
  		7348,
  		1,
  		"ჴ"
  	],
  	[
  		7349,
  		1,
  		"ჵ"
  	],
  	[
  		7350,
  		1,
  		"ჶ"
  	],
  	[
  		7351,
  		1,
  		"ჷ"
  	],
  	[
  		7352,
  		1,
  		"ჸ"
  	],
  	[
  		7353,
  		1,
  		"ჹ"
  	],
  	[
  		7354,
  		1,
  		"ჺ"
  	],
  	[
  		[
  			7355,
  			7356
  		],
  		3
  	],
  	[
  		7357,
  		1,
  		"ჽ"
  	],
  	[
  		7358,
  		1,
  		"ჾ"
  	],
  	[
  		7359,
  		1,
  		"ჿ"
  	],
  	[
  		[
  			7360,
  			7367
  		],
  		2
  	],
  	[
  		[
  			7368,
  			7375
  		],
  		3
  	],
  	[
  		[
  			7376,
  			7378
  		],
  		2
  	],
  	[
  		7379,
  		2
  	],
  	[
  		[
  			7380,
  			7410
  		],
  		2
  	],
  	[
  		[
  			7411,
  			7414
  		],
  		2
  	],
  	[
  		7415,
  		2
  	],
  	[
  		[
  			7416,
  			7417
  		],
  		2
  	],
  	[
  		7418,
  		2
  	],
  	[
  		[
  			7419,
  			7423
  		],
  		3
  	],
  	[
  		[
  			7424,
  			7467
  		],
  		2
  	],
  	[
  		7468,
  		1,
  		"a"
  	],
  	[
  		7469,
  		1,
  		"æ"
  	],
  	[
  		7470,
  		1,
  		"b"
  	],
  	[
  		7471,
  		2
  	],
  	[
  		7472,
  		1,
  		"d"
  	],
  	[
  		7473,
  		1,
  		"e"
  	],
  	[
  		7474,
  		1,
  		"ǝ"
  	],
  	[
  		7475,
  		1,
  		"g"
  	],
  	[
  		7476,
  		1,
  		"h"
  	],
  	[
  		7477,
  		1,
  		"i"
  	],
  	[
  		7478,
  		1,
  		"j"
  	],
  	[
  		7479,
  		1,
  		"k"
  	],
  	[
  		7480,
  		1,
  		"l"
  	],
  	[
  		7481,
  		1,
  		"m"
  	],
  	[
  		7482,
  		1,
  		"n"
  	],
  	[
  		7483,
  		2
  	],
  	[
  		7484,
  		1,
  		"o"
  	],
  	[
  		7485,
  		1,
  		"ȣ"
  	],
  	[
  		7486,
  		1,
  		"p"
  	],
  	[
  		7487,
  		1,
  		"r"
  	],
  	[
  		7488,
  		1,
  		"t"
  	],
  	[
  		7489,
  		1,
  		"u"
  	],
  	[
  		7490,
  		1,
  		"w"
  	],
  	[
  		7491,
  		1,
  		"a"
  	],
  	[
  		7492,
  		1,
  		"ɐ"
  	],
  	[
  		7493,
  		1,
  		"ɑ"
  	],
  	[
  		7494,
  		1,
  		"ᴂ"
  	],
  	[
  		7495,
  		1,
  		"b"
  	],
  	[
  		7496,
  		1,
  		"d"
  	],
  	[
  		7497,
  		1,
  		"e"
  	],
  	[
  		7498,
  		1,
  		"ə"
  	],
  	[
  		7499,
  		1,
  		"ɛ"
  	],
  	[
  		7500,
  		1,
  		"ɜ"
  	],
  	[
  		7501,
  		1,
  		"g"
  	],
  	[
  		7502,
  		2
  	],
  	[
  		7503,
  		1,
  		"k"
  	],
  	[
  		7504,
  		1,
  		"m"
  	],
  	[
  		7505,
  		1,
  		"ŋ"
  	],
  	[
  		7506,
  		1,
  		"o"
  	],
  	[
  		7507,
  		1,
  		"ɔ"
  	],
  	[
  		7508,
  		1,
  		"ᴖ"
  	],
  	[
  		7509,
  		1,
  		"ᴗ"
  	],
  	[
  		7510,
  		1,
  		"p"
  	],
  	[
  		7511,
  		1,
  		"t"
  	],
  	[
  		7512,
  		1,
  		"u"
  	],
  	[
  		7513,
  		1,
  		"ᴝ"
  	],
  	[
  		7514,
  		1,
  		"ɯ"
  	],
  	[
  		7515,
  		1,
  		"v"
  	],
  	[
  		7516,
  		1,
  		"ᴥ"
  	],
  	[
  		7517,
  		1,
  		"β"
  	],
  	[
  		7518,
  		1,
  		"γ"
  	],
  	[
  		7519,
  		1,
  		"δ"
  	],
  	[
  		7520,
  		1,
  		"φ"
  	],
  	[
  		7521,
  		1,
  		"χ"
  	],
  	[
  		7522,
  		1,
  		"i"
  	],
  	[
  		7523,
  		1,
  		"r"
  	],
  	[
  		7524,
  		1,
  		"u"
  	],
  	[
  		7525,
  		1,
  		"v"
  	],
  	[
  		7526,
  		1,
  		"β"
  	],
  	[
  		7527,
  		1,
  		"γ"
  	],
  	[
  		7528,
  		1,
  		"ρ"
  	],
  	[
  		7529,
  		1,
  		"φ"
  	],
  	[
  		7530,
  		1,
  		"χ"
  	],
  	[
  		7531,
  		2
  	],
  	[
  		[
  			7532,
  			7543
  		],
  		2
  	],
  	[
  		7544,
  		1,
  		"н"
  	],
  	[
  		[
  			7545,
  			7578
  		],
  		2
  	],
  	[
  		7579,
  		1,
  		"ɒ"
  	],
  	[
  		7580,
  		1,
  		"c"
  	],
  	[
  		7581,
  		1,
  		"ɕ"
  	],
  	[
  		7582,
  		1,
  		"ð"
  	],
  	[
  		7583,
  		1,
  		"ɜ"
  	],
  	[
  		7584,
  		1,
  		"f"
  	],
  	[
  		7585,
  		1,
  		"ɟ"
  	],
  	[
  		7586,
  		1,
  		"ɡ"
  	],
  	[
  		7587,
  		1,
  		"ɥ"
  	],
  	[
  		7588,
  		1,
  		"ɨ"
  	],
  	[
  		7589,
  		1,
  		"ɩ"
  	],
  	[
  		7590,
  		1,
  		"ɪ"
  	],
  	[
  		7591,
  		1,
  		"ᵻ"
  	],
  	[
  		7592,
  		1,
  		"ʝ"
  	],
  	[
  		7593,
  		1,
  		"ɭ"
  	],
  	[
  		7594,
  		1,
  		"ᶅ"
  	],
  	[
  		7595,
  		1,
  		"ʟ"
  	],
  	[
  		7596,
  		1,
  		"ɱ"
  	],
  	[
  		7597,
  		1,
  		"ɰ"
  	],
  	[
  		7598,
  		1,
  		"ɲ"
  	],
  	[
  		7599,
  		1,
  		"ɳ"
  	],
  	[
  		7600,
  		1,
  		"ɴ"
  	],
  	[
  		7601,
  		1,
  		"ɵ"
  	],
  	[
  		7602,
  		1,
  		"ɸ"
  	],
  	[
  		7603,
  		1,
  		"ʂ"
  	],
  	[
  		7604,
  		1,
  		"ʃ"
  	],
  	[
  		7605,
  		1,
  		"ƫ"
  	],
  	[
  		7606,
  		1,
  		"ʉ"
  	],
  	[
  		7607,
  		1,
  		"ʊ"
  	],
  	[
  		7608,
  		1,
  		"ᴜ"
  	],
  	[
  		7609,
  		1,
  		"ʋ"
  	],
  	[
  		7610,
  		1,
  		"ʌ"
  	],
  	[
  		7611,
  		1,
  		"z"
  	],
  	[
  		7612,
  		1,
  		"ʐ"
  	],
  	[
  		7613,
  		1,
  		"ʑ"
  	],
  	[
  		7614,
  		1,
  		"ʒ"
  	],
  	[
  		7615,
  		1,
  		"θ"
  	],
  	[
  		[
  			7616,
  			7619
  		],
  		2
  	],
  	[
  		[
  			7620,
  			7626
  		],
  		2
  	],
  	[
  		[
  			7627,
  			7654
  		],
  		2
  	],
  	[
  		[
  			7655,
  			7669
  		],
  		2
  	],
  	[
  		[
  			7670,
  			7673
  		],
  		2
  	],
  	[
  		7674,
  		3
  	],
  	[
  		7675,
  		2
  	],
  	[
  		7676,
  		2
  	],
  	[
  		7677,
  		2
  	],
  	[
  		[
  			7678,
  			7679
  		],
  		2
  	],
  	[
  		7680,
  		1,
  		"ḁ"
  	],
  	[
  		7681,
  		2
  	],
  	[
  		7682,
  		1,
  		"ḃ"
  	],
  	[
  		7683,
  		2
  	],
  	[
  		7684,
  		1,
  		"ḅ"
  	],
  	[
  		7685,
  		2
  	],
  	[
  		7686,
  		1,
  		"ḇ"
  	],
  	[
  		7687,
  		2
  	],
  	[
  		7688,
  		1,
  		"ḉ"
  	],
  	[
  		7689,
  		2
  	],
  	[
  		7690,
  		1,
  		"ḋ"
  	],
  	[
  		7691,
  		2
  	],
  	[
  		7692,
  		1,
  		"ḍ"
  	],
  	[
  		7693,
  		2
  	],
  	[
  		7694,
  		1,
  		"ḏ"
  	],
  	[
  		7695,
  		2
  	],
  	[
  		7696,
  		1,
  		"ḑ"
  	],
  	[
  		7697,
  		2
  	],
  	[
  		7698,
  		1,
  		"ḓ"
  	],
  	[
  		7699,
  		2
  	],
  	[
  		7700,
  		1,
  		"ḕ"
  	],
  	[
  		7701,
  		2
  	],
  	[
  		7702,
  		1,
  		"ḗ"
  	],
  	[
  		7703,
  		2
  	],
  	[
  		7704,
  		1,
  		"ḙ"
  	],
  	[
  		7705,
  		2
  	],
  	[
  		7706,
  		1,
  		"ḛ"
  	],
  	[
  		7707,
  		2
  	],
  	[
  		7708,
  		1,
  		"ḝ"
  	],
  	[
  		7709,
  		2
  	],
  	[
  		7710,
  		1,
  		"ḟ"
  	],
  	[
  		7711,
  		2
  	],
  	[
  		7712,
  		1,
  		"ḡ"
  	],
  	[
  		7713,
  		2
  	],
  	[
  		7714,
  		1,
  		"ḣ"
  	],
  	[
  		7715,
  		2
  	],
  	[
  		7716,
  		1,
  		"ḥ"
  	],
  	[
  		7717,
  		2
  	],
  	[
  		7718,
  		1,
  		"ḧ"
  	],
  	[
  		7719,
  		2
  	],
  	[
  		7720,
  		1,
  		"ḩ"
  	],
  	[
  		7721,
  		2
  	],
  	[
  		7722,
  		1,
  		"ḫ"
  	],
  	[
  		7723,
  		2
  	],
  	[
  		7724,
  		1,
  		"ḭ"
  	],
  	[
  		7725,
  		2
  	],
  	[
  		7726,
  		1,
  		"ḯ"
  	],
  	[
  		7727,
  		2
  	],
  	[
  		7728,
  		1,
  		"ḱ"
  	],
  	[
  		7729,
  		2
  	],
  	[
  		7730,
  		1,
  		"ḳ"
  	],
  	[
  		7731,
  		2
  	],
  	[
  		7732,
  		1,
  		"ḵ"
  	],
  	[
  		7733,
  		2
  	],
  	[
  		7734,
  		1,
  		"ḷ"
  	],
  	[
  		7735,
  		2
  	],
  	[
  		7736,
  		1,
  		"ḹ"
  	],
  	[
  		7737,
  		2
  	],
  	[
  		7738,
  		1,
  		"ḻ"
  	],
  	[
  		7739,
  		2
  	],
  	[
  		7740,
  		1,
  		"ḽ"
  	],
  	[
  		7741,
  		2
  	],
  	[
  		7742,
  		1,
  		"ḿ"
  	],
  	[
  		7743,
  		2
  	],
  	[
  		7744,
  		1,
  		"ṁ"
  	],
  	[
  		7745,
  		2
  	],
  	[
  		7746,
  		1,
  		"ṃ"
  	],
  	[
  		7747,
  		2
  	],
  	[
  		7748,
  		1,
  		"ṅ"
  	],
  	[
  		7749,
  		2
  	],
  	[
  		7750,
  		1,
  		"ṇ"
  	],
  	[
  		7751,
  		2
  	],
  	[
  		7752,
  		1,
  		"ṉ"
  	],
  	[
  		7753,
  		2
  	],
  	[
  		7754,
  		1,
  		"ṋ"
  	],
  	[
  		7755,
  		2
  	],
  	[
  		7756,
  		1,
  		"ṍ"
  	],
  	[
  		7757,
  		2
  	],
  	[
  		7758,
  		1,
  		"ṏ"
  	],
  	[
  		7759,
  		2
  	],
  	[
  		7760,
  		1,
  		"ṑ"
  	],
  	[
  		7761,
  		2
  	],
  	[
  		7762,
  		1,
  		"ṓ"
  	],
  	[
  		7763,
  		2
  	],
  	[
  		7764,
  		1,
  		"ṕ"
  	],
  	[
  		7765,
  		2
  	],
  	[
  		7766,
  		1,
  		"ṗ"
  	],
  	[
  		7767,
  		2
  	],
  	[
  		7768,
  		1,
  		"ṙ"
  	],
  	[
  		7769,
  		2
  	],
  	[
  		7770,
  		1,
  		"ṛ"
  	],
  	[
  		7771,
  		2
  	],
  	[
  		7772,
  		1,
  		"ṝ"
  	],
  	[
  		7773,
  		2
  	],
  	[
  		7774,
  		1,
  		"ṟ"
  	],
  	[
  		7775,
  		2
  	],
  	[
  		7776,
  		1,
  		"ṡ"
  	],
  	[
  		7777,
  		2
  	],
  	[
  		7778,
  		1,
  		"ṣ"
  	],
  	[
  		7779,
  		2
  	],
  	[
  		7780,
  		1,
  		"ṥ"
  	],
  	[
  		7781,
  		2
  	],
  	[
  		7782,
  		1,
  		"ṧ"
  	],
  	[
  		7783,
  		2
  	],
  	[
  		7784,
  		1,
  		"ṩ"
  	],
  	[
  		7785,
  		2
  	],
  	[
  		7786,
  		1,
  		"ṫ"
  	],
  	[
  		7787,
  		2
  	],
  	[
  		7788,
  		1,
  		"ṭ"
  	],
  	[
  		7789,
  		2
  	],
  	[
  		7790,
  		1,
  		"ṯ"
  	],
  	[
  		7791,
  		2
  	],
  	[
  		7792,
  		1,
  		"ṱ"
  	],
  	[
  		7793,
  		2
  	],
  	[
  		7794,
  		1,
  		"ṳ"
  	],
  	[
  		7795,
  		2
  	],
  	[
  		7796,
  		1,
  		"ṵ"
  	],
  	[
  		7797,
  		2
  	],
  	[
  		7798,
  		1,
  		"ṷ"
  	],
  	[
  		7799,
  		2
  	],
  	[
  		7800,
  		1,
  		"ṹ"
  	],
  	[
  		7801,
  		2
  	],
  	[
  		7802,
  		1,
  		"ṻ"
  	],
  	[
  		7803,
  		2
  	],
  	[
  		7804,
  		1,
  		"ṽ"
  	],
  	[
  		7805,
  		2
  	],
  	[
  		7806,
  		1,
  		"ṿ"
  	],
  	[
  		7807,
  		2
  	],
  	[
  		7808,
  		1,
  		"ẁ"
  	],
  	[
  		7809,
  		2
  	],
  	[
  		7810,
  		1,
  		"ẃ"
  	],
  	[
  		7811,
  		2
  	],
  	[
  		7812,
  		1,
  		"ẅ"
  	],
  	[
  		7813,
  		2
  	],
  	[
  		7814,
  		1,
  		"ẇ"
  	],
  	[
  		7815,
  		2
  	],
  	[
  		7816,
  		1,
  		"ẉ"
  	],
  	[
  		7817,
  		2
  	],
  	[
  		7818,
  		1,
  		"ẋ"
  	],
  	[
  		7819,
  		2
  	],
  	[
  		7820,
  		1,
  		"ẍ"
  	],
  	[
  		7821,
  		2
  	],
  	[
  		7822,
  		1,
  		"ẏ"
  	],
  	[
  		7823,
  		2
  	],
  	[
  		7824,
  		1,
  		"ẑ"
  	],
  	[
  		7825,
  		2
  	],
  	[
  		7826,
  		1,
  		"ẓ"
  	],
  	[
  		7827,
  		2
  	],
  	[
  		7828,
  		1,
  		"ẕ"
  	],
  	[
  		[
  			7829,
  			7833
  		],
  		2
  	],
  	[
  		7834,
  		1,
  		"aʾ"
  	],
  	[
  		7835,
  		1,
  		"ṡ"
  	],
  	[
  		[
  			7836,
  			7837
  		],
  		2
  	],
  	[
  		7838,
  		1,
  		"ss"
  	],
  	[
  		7839,
  		2
  	],
  	[
  		7840,
  		1,
  		"ạ"
  	],
  	[
  		7841,
  		2
  	],
  	[
  		7842,
  		1,
  		"ả"
  	],
  	[
  		7843,
  		2
  	],
  	[
  		7844,
  		1,
  		"ấ"
  	],
  	[
  		7845,
  		2
  	],
  	[
  		7846,
  		1,
  		"ầ"
  	],
  	[
  		7847,
  		2
  	],
  	[
  		7848,
  		1,
  		"ẩ"
  	],
  	[
  		7849,
  		2
  	],
  	[
  		7850,
  		1,
  		"ẫ"
  	],
  	[
  		7851,
  		2
  	],
  	[
  		7852,
  		1,
  		"ậ"
  	],
  	[
  		7853,
  		2
  	],
  	[
  		7854,
  		1,
  		"ắ"
  	],
  	[
  		7855,
  		2
  	],
  	[
  		7856,
  		1,
  		"ằ"
  	],
  	[
  		7857,
  		2
  	],
  	[
  		7858,
  		1,
  		"ẳ"
  	],
  	[
  		7859,
  		2
  	],
  	[
  		7860,
  		1,
  		"ẵ"
  	],
  	[
  		7861,
  		2
  	],
  	[
  		7862,
  		1,
  		"ặ"
  	],
  	[
  		7863,
  		2
  	],
  	[
  		7864,
  		1,
  		"ẹ"
  	],
  	[
  		7865,
  		2
  	],
  	[
  		7866,
  		1,
  		"ẻ"
  	],
  	[
  		7867,
  		2
  	],
  	[
  		7868,
  		1,
  		"ẽ"
  	],
  	[
  		7869,
  		2
  	],
  	[
  		7870,
  		1,
  		"ế"
  	],
  	[
  		7871,
  		2
  	],
  	[
  		7872,
  		1,
  		"ề"
  	],
  	[
  		7873,
  		2
  	],
  	[
  		7874,
  		1,
  		"ể"
  	],
  	[
  		7875,
  		2
  	],
  	[
  		7876,
  		1,
  		"ễ"
  	],
  	[
  		7877,
  		2
  	],
  	[
  		7878,
  		1,
  		"ệ"
  	],
  	[
  		7879,
  		2
  	],
  	[
  		7880,
  		1,
  		"ỉ"
  	],
  	[
  		7881,
  		2
  	],
  	[
  		7882,
  		1,
  		"ị"
  	],
  	[
  		7883,
  		2
  	],
  	[
  		7884,
  		1,
  		"ọ"
  	],
  	[
  		7885,
  		2
  	],
  	[
  		7886,
  		1,
  		"ỏ"
  	],
  	[
  		7887,
  		2
  	],
  	[
  		7888,
  		1,
  		"ố"
  	],
  	[
  		7889,
  		2
  	],
  	[
  		7890,
  		1,
  		"ồ"
  	],
  	[
  		7891,
  		2
  	],
  	[
  		7892,
  		1,
  		"ổ"
  	],
  	[
  		7893,
  		2
  	],
  	[
  		7894,
  		1,
  		"ỗ"
  	],
  	[
  		7895,
  		2
  	],
  	[
  		7896,
  		1,
  		"ộ"
  	],
  	[
  		7897,
  		2
  	],
  	[
  		7898,
  		1,
  		"ớ"
  	],
  	[
  		7899,
  		2
  	],
  	[
  		7900,
  		1,
  		"ờ"
  	],
  	[
  		7901,
  		2
  	],
  	[
  		7902,
  		1,
  		"ở"
  	],
  	[
  		7903,
  		2
  	],
  	[
  		7904,
  		1,
  		"ỡ"
  	],
  	[
  		7905,
  		2
  	],
  	[
  		7906,
  		1,
  		"ợ"
  	],
  	[
  		7907,
  		2
  	],
  	[
  		7908,
  		1,
  		"ụ"
  	],
  	[
  		7909,
  		2
  	],
  	[
  		7910,
  		1,
  		"ủ"
  	],
  	[
  		7911,
  		2
  	],
  	[
  		7912,
  		1,
  		"ứ"
  	],
  	[
  		7913,
  		2
  	],
  	[
  		7914,
  		1,
  		"ừ"
  	],
  	[
  		7915,
  		2
  	],
  	[
  		7916,
  		1,
  		"ử"
  	],
  	[
  		7917,
  		2
  	],
  	[
  		7918,
  		1,
  		"ữ"
  	],
  	[
  		7919,
  		2
  	],
  	[
  		7920,
  		1,
  		"ự"
  	],
  	[
  		7921,
  		2
  	],
  	[
  		7922,
  		1,
  		"ỳ"
  	],
  	[
  		7923,
  		2
  	],
  	[
  		7924,
  		1,
  		"ỵ"
  	],
  	[
  		7925,
  		2
  	],
  	[
  		7926,
  		1,
  		"ỷ"
  	],
  	[
  		7927,
  		2
  	],
  	[
  		7928,
  		1,
  		"ỹ"
  	],
  	[
  		7929,
  		2
  	],
  	[
  		7930,
  		1,
  		"ỻ"
  	],
  	[
  		7931,
  		2
  	],
  	[
  		7932,
  		1,
  		"ỽ"
  	],
  	[
  		7933,
  		2
  	],
  	[
  		7934,
  		1,
  		"ỿ"
  	],
  	[
  		7935,
  		2
  	],
  	[
  		[
  			7936,
  			7943
  		],
  		2
  	],
  	[
  		7944,
  		1,
  		"ἀ"
  	],
  	[
  		7945,
  		1,
  		"ἁ"
  	],
  	[
  		7946,
  		1,
  		"ἂ"
  	],
  	[
  		7947,
  		1,
  		"ἃ"
  	],
  	[
  		7948,
  		1,
  		"ἄ"
  	],
  	[
  		7949,
  		1,
  		"ἅ"
  	],
  	[
  		7950,
  		1,
  		"ἆ"
  	],
  	[
  		7951,
  		1,
  		"ἇ"
  	],
  	[
  		[
  			7952,
  			7957
  		],
  		2
  	],
  	[
  		[
  			7958,
  			7959
  		],
  		3
  	],
  	[
  		7960,
  		1,
  		"ἐ"
  	],
  	[
  		7961,
  		1,
  		"ἑ"
  	],
  	[
  		7962,
  		1,
  		"ἒ"
  	],
  	[
  		7963,
  		1,
  		"ἓ"
  	],
  	[
  		7964,
  		1,
  		"ἔ"
  	],
  	[
  		7965,
  		1,
  		"ἕ"
  	],
  	[
  		[
  			7966,
  			7967
  		],
  		3
  	],
  	[
  		[
  			7968,
  			7975
  		],
  		2
  	],
  	[
  		7976,
  		1,
  		"ἠ"
  	],
  	[
  		7977,
  		1,
  		"ἡ"
  	],
  	[
  		7978,
  		1,
  		"ἢ"
  	],
  	[
  		7979,
  		1,
  		"ἣ"
  	],
  	[
  		7980,
  		1,
  		"ἤ"
  	],
  	[
  		7981,
  		1,
  		"ἥ"
  	],
  	[
  		7982,
  		1,
  		"ἦ"
  	],
  	[
  		7983,
  		1,
  		"ἧ"
  	],
  	[
  		[
  			7984,
  			7991
  		],
  		2
  	],
  	[
  		7992,
  		1,
  		"ἰ"
  	],
  	[
  		7993,
  		1,
  		"ἱ"
  	],
  	[
  		7994,
  		1,
  		"ἲ"
  	],
  	[
  		7995,
  		1,
  		"ἳ"
  	],
  	[
  		7996,
  		1,
  		"ἴ"
  	],
  	[
  		7997,
  		1,
  		"ἵ"
  	],
  	[
  		7998,
  		1,
  		"ἶ"
  	],
  	[
  		7999,
  		1,
  		"ἷ"
  	],
  	[
  		[
  			8000,
  			8005
  		],
  		2
  	],
  	[
  		[
  			8006,
  			8007
  		],
  		3
  	],
  	[
  		8008,
  		1,
  		"ὀ"
  	],
  	[
  		8009,
  		1,
  		"ὁ"
  	],
  	[
  		8010,
  		1,
  		"ὂ"
  	],
  	[
  		8011,
  		1,
  		"ὃ"
  	],
  	[
  		8012,
  		1,
  		"ὄ"
  	],
  	[
  		8013,
  		1,
  		"ὅ"
  	],
  	[
  		[
  			8014,
  			8015
  		],
  		3
  	],
  	[
  		[
  			8016,
  			8023
  		],
  		2
  	],
  	[
  		8024,
  		3
  	],
  	[
  		8025,
  		1,
  		"ὑ"
  	],
  	[
  		8026,
  		3
  	],
  	[
  		8027,
  		1,
  		"ὓ"
  	],
  	[
  		8028,
  		3
  	],
  	[
  		8029,
  		1,
  		"ὕ"
  	],
  	[
  		8030,
  		3
  	],
  	[
  		8031,
  		1,
  		"ὗ"
  	],
  	[
  		[
  			8032,
  			8039
  		],
  		2
  	],
  	[
  		8040,
  		1,
  		"ὠ"
  	],
  	[
  		8041,
  		1,
  		"ὡ"
  	],
  	[
  		8042,
  		1,
  		"ὢ"
  	],
  	[
  		8043,
  		1,
  		"ὣ"
  	],
  	[
  		8044,
  		1,
  		"ὤ"
  	],
  	[
  		8045,
  		1,
  		"ὥ"
  	],
  	[
  		8046,
  		1,
  		"ὦ"
  	],
  	[
  		8047,
  		1,
  		"ὧ"
  	],
  	[
  		8048,
  		2
  	],
  	[
  		8049,
  		1,
  		"ά"
  	],
  	[
  		8050,
  		2
  	],
  	[
  		8051,
  		1,
  		"έ"
  	],
  	[
  		8052,
  		2
  	],
  	[
  		8053,
  		1,
  		"ή"
  	],
  	[
  		8054,
  		2
  	],
  	[
  		8055,
  		1,
  		"ί"
  	],
  	[
  		8056,
  		2
  	],
  	[
  		8057,
  		1,
  		"ό"
  	],
  	[
  		8058,
  		2
  	],
  	[
  		8059,
  		1,
  		"ύ"
  	],
  	[
  		8060,
  		2
  	],
  	[
  		8061,
  		1,
  		"ώ"
  	],
  	[
  		[
  			8062,
  			8063
  		],
  		3
  	],
  	[
  		8064,
  		1,
  		"ἀι"
  	],
  	[
  		8065,
  		1,
  		"ἁι"
  	],
  	[
  		8066,
  		1,
  		"ἂι"
  	],
  	[
  		8067,
  		1,
  		"ἃι"
  	],
  	[
  		8068,
  		1,
  		"ἄι"
  	],
  	[
  		8069,
  		1,
  		"ἅι"
  	],
  	[
  		8070,
  		1,
  		"ἆι"
  	],
  	[
  		8071,
  		1,
  		"ἇι"
  	],
  	[
  		8072,
  		1,
  		"ἀι"
  	],
  	[
  		8073,
  		1,
  		"ἁι"
  	],
  	[
  		8074,
  		1,
  		"ἂι"
  	],
  	[
  		8075,
  		1,
  		"ἃι"
  	],
  	[
  		8076,
  		1,
  		"ἄι"
  	],
  	[
  		8077,
  		1,
  		"ἅι"
  	],
  	[
  		8078,
  		1,
  		"ἆι"
  	],
  	[
  		8079,
  		1,
  		"ἇι"
  	],
  	[
  		8080,
  		1,
  		"ἠι"
  	],
  	[
  		8081,
  		1,
  		"ἡι"
  	],
  	[
  		8082,
  		1,
  		"ἢι"
  	],
  	[
  		8083,
  		1,
  		"ἣι"
  	],
  	[
  		8084,
  		1,
  		"ἤι"
  	],
  	[
  		8085,
  		1,
  		"ἥι"
  	],
  	[
  		8086,
  		1,
  		"ἦι"
  	],
  	[
  		8087,
  		1,
  		"ἧι"
  	],
  	[
  		8088,
  		1,
  		"ἠι"
  	],
  	[
  		8089,
  		1,
  		"ἡι"
  	],
  	[
  		8090,
  		1,
  		"ἢι"
  	],
  	[
  		8091,
  		1,
  		"ἣι"
  	],
  	[
  		8092,
  		1,
  		"ἤι"
  	],
  	[
  		8093,
  		1,
  		"ἥι"
  	],
  	[
  		8094,
  		1,
  		"ἦι"
  	],
  	[
  		8095,
  		1,
  		"ἧι"
  	],
  	[
  		8096,
  		1,
  		"ὠι"
  	],
  	[
  		8097,
  		1,
  		"ὡι"
  	],
  	[
  		8098,
  		1,
  		"ὢι"
  	],
  	[
  		8099,
  		1,
  		"ὣι"
  	],
  	[
  		8100,
  		1,
  		"ὤι"
  	],
  	[
  		8101,
  		1,
  		"ὥι"
  	],
  	[
  		8102,
  		1,
  		"ὦι"
  	],
  	[
  		8103,
  		1,
  		"ὧι"
  	],
  	[
  		8104,
  		1,
  		"ὠι"
  	],
  	[
  		8105,
  		1,
  		"ὡι"
  	],
  	[
  		8106,
  		1,
  		"ὢι"
  	],
  	[
  		8107,
  		1,
  		"ὣι"
  	],
  	[
  		8108,
  		1,
  		"ὤι"
  	],
  	[
  		8109,
  		1,
  		"ὥι"
  	],
  	[
  		8110,
  		1,
  		"ὦι"
  	],
  	[
  		8111,
  		1,
  		"ὧι"
  	],
  	[
  		[
  			8112,
  			8113
  		],
  		2
  	],
  	[
  		8114,
  		1,
  		"ὰι"
  	],
  	[
  		8115,
  		1,
  		"αι"
  	],
  	[
  		8116,
  		1,
  		"άι"
  	],
  	[
  		8117,
  		3
  	],
  	[
  		8118,
  		2
  	],
  	[
  		8119,
  		1,
  		"ᾶι"
  	],
  	[
  		8120,
  		1,
  		"ᾰ"
  	],
  	[
  		8121,
  		1,
  		"ᾱ"
  	],
  	[
  		8122,
  		1,
  		"ὰ"
  	],
  	[
  		8123,
  		1,
  		"ά"
  	],
  	[
  		8124,
  		1,
  		"αι"
  	],
  	[
  		8125,
  		5,
  		" ̓"
  	],
  	[
  		8126,
  		1,
  		"ι"
  	],
  	[
  		8127,
  		5,
  		" ̓"
  	],
  	[
  		8128,
  		5,
  		" ͂"
  	],
  	[
  		8129,
  		5,
  		" ̈͂"
  	],
  	[
  		8130,
  		1,
  		"ὴι"
  	],
  	[
  		8131,
  		1,
  		"ηι"
  	],
  	[
  		8132,
  		1,
  		"ήι"
  	],
  	[
  		8133,
  		3
  	],
  	[
  		8134,
  		2
  	],
  	[
  		8135,
  		1,
  		"ῆι"
  	],
  	[
  		8136,
  		1,
  		"ὲ"
  	],
  	[
  		8137,
  		1,
  		"έ"
  	],
  	[
  		8138,
  		1,
  		"ὴ"
  	],
  	[
  		8139,
  		1,
  		"ή"
  	],
  	[
  		8140,
  		1,
  		"ηι"
  	],
  	[
  		8141,
  		5,
  		" ̓̀"
  	],
  	[
  		8142,
  		5,
  		" ̓́"
  	],
  	[
  		8143,
  		5,
  		" ̓͂"
  	],
  	[
  		[
  			8144,
  			8146
  		],
  		2
  	],
  	[
  		8147,
  		1,
  		"ΐ"
  	],
  	[
  		[
  			8148,
  			8149
  		],
  		3
  	],
  	[
  		[
  			8150,
  			8151
  		],
  		2
  	],
  	[
  		8152,
  		1,
  		"ῐ"
  	],
  	[
  		8153,
  		1,
  		"ῑ"
  	],
  	[
  		8154,
  		1,
  		"ὶ"
  	],
  	[
  		8155,
  		1,
  		"ί"
  	],
  	[
  		8156,
  		3
  	],
  	[
  		8157,
  		5,
  		" ̔̀"
  	],
  	[
  		8158,
  		5,
  		" ̔́"
  	],
  	[
  		8159,
  		5,
  		" ̔͂"
  	],
  	[
  		[
  			8160,
  			8162
  		],
  		2
  	],
  	[
  		8163,
  		1,
  		"ΰ"
  	],
  	[
  		[
  			8164,
  			8167
  		],
  		2
  	],
  	[
  		8168,
  		1,
  		"ῠ"
  	],
  	[
  		8169,
  		1,
  		"ῡ"
  	],
  	[
  		8170,
  		1,
  		"ὺ"
  	],
  	[
  		8171,
  		1,
  		"ύ"
  	],
  	[
  		8172,
  		1,
  		"ῥ"
  	],
  	[
  		8173,
  		5,
  		" ̈̀"
  	],
  	[
  		8174,
  		5,
  		" ̈́"
  	],
  	[
  		8175,
  		5,
  		"`"
  	],
  	[
  		[
  			8176,
  			8177
  		],
  		3
  	],
  	[
  		8178,
  		1,
  		"ὼι"
  	],
  	[
  		8179,
  		1,
  		"ωι"
  	],
  	[
  		8180,
  		1,
  		"ώι"
  	],
  	[
  		8181,
  		3
  	],
  	[
  		8182,
  		2
  	],
  	[
  		8183,
  		1,
  		"ῶι"
  	],
  	[
  		8184,
  		1,
  		"ὸ"
  	],
  	[
  		8185,
  		1,
  		"ό"
  	],
  	[
  		8186,
  		1,
  		"ὼ"
  	],
  	[
  		8187,
  		1,
  		"ώ"
  	],
  	[
  		8188,
  		1,
  		"ωι"
  	],
  	[
  		8189,
  		5,
  		" ́"
  	],
  	[
  		8190,
  		5,
  		" ̔"
  	],
  	[
  		8191,
  		3
  	],
  	[
  		[
  			8192,
  			8202
  		],
  		5,
  		" "
  	],
  	[
  		8203,
  		7
  	],
  	[
  		[
  			8204,
  			8205
  		],
  		6,
  		""
  	],
  	[
  		[
  			8206,
  			8207
  		],
  		3
  	],
  	[
  		8208,
  		2
  	],
  	[
  		8209,
  		1,
  		"‐"
  	],
  	[
  		[
  			8210,
  			8214
  		],
  		2
  	],
  	[
  		8215,
  		5,
  		" ̳"
  	],
  	[
  		[
  			8216,
  			8227
  		],
  		2
  	],
  	[
  		[
  			8228,
  			8230
  		],
  		3
  	],
  	[
  		8231,
  		2
  	],
  	[
  		[
  			8232,
  			8238
  		],
  		3
  	],
  	[
  		8239,
  		5,
  		" "
  	],
  	[
  		[
  			8240,
  			8242
  		],
  		2
  	],
  	[
  		8243,
  		1,
  		"′′"
  	],
  	[
  		8244,
  		1,
  		"′′′"
  	],
  	[
  		8245,
  		2
  	],
  	[
  		8246,
  		1,
  		"‵‵"
  	],
  	[
  		8247,
  		1,
  		"‵‵‵"
  	],
  	[
  		[
  			8248,
  			8251
  		],
  		2
  	],
  	[
  		8252,
  		5,
  		"!!"
  	],
  	[
  		8253,
  		2
  	],
  	[
  		8254,
  		5,
  		" ̅"
  	],
  	[
  		[
  			8255,
  			8262
  		],
  		2
  	],
  	[
  		8263,
  		5,
  		"??"
  	],
  	[
  		8264,
  		5,
  		"?!"
  	],
  	[
  		8265,
  		5,
  		"!?"
  	],
  	[
  		[
  			8266,
  			8269
  		],
  		2
  	],
  	[
  		[
  			8270,
  			8274
  		],
  		2
  	],
  	[
  		[
  			8275,
  			8276
  		],
  		2
  	],
  	[
  		[
  			8277,
  			8278
  		],
  		2
  	],
  	[
  		8279,
  		1,
  		"′′′′"
  	],
  	[
  		[
  			8280,
  			8286
  		],
  		2
  	],
  	[
  		8287,
  		5,
  		" "
  	],
  	[
  		8288,
  		7
  	],
  	[
  		[
  			8289,
  			8291
  		],
  		3
  	],
  	[
  		8292,
  		7
  	],
  	[
  		8293,
  		3
  	],
  	[
  		[
  			8294,
  			8297
  		],
  		3
  	],
  	[
  		[
  			8298,
  			8303
  		],
  		3
  	],
  	[
  		8304,
  		1,
  		"0"
  	],
  	[
  		8305,
  		1,
  		"i"
  	],
  	[
  		[
  			8306,
  			8307
  		],
  		3
  	],
  	[
  		8308,
  		1,
  		"4"
  	],
  	[
  		8309,
  		1,
  		"5"
  	],
  	[
  		8310,
  		1,
  		"6"
  	],
  	[
  		8311,
  		1,
  		"7"
  	],
  	[
  		8312,
  		1,
  		"8"
  	],
  	[
  		8313,
  		1,
  		"9"
  	],
  	[
  		8314,
  		5,
  		"+"
  	],
  	[
  		8315,
  		1,
  		"−"
  	],
  	[
  		8316,
  		5,
  		"="
  	],
  	[
  		8317,
  		5,
  		"("
  	],
  	[
  		8318,
  		5,
  		")"
  	],
  	[
  		8319,
  		1,
  		"n"
  	],
  	[
  		8320,
  		1,
  		"0"
  	],
  	[
  		8321,
  		1,
  		"1"
  	],
  	[
  		8322,
  		1,
  		"2"
  	],
  	[
  		8323,
  		1,
  		"3"
  	],
  	[
  		8324,
  		1,
  		"4"
  	],
  	[
  		8325,
  		1,
  		"5"
  	],
  	[
  		8326,
  		1,
  		"6"
  	],
  	[
  		8327,
  		1,
  		"7"
  	],
  	[
  		8328,
  		1,
  		"8"
  	],
  	[
  		8329,
  		1,
  		"9"
  	],
  	[
  		8330,
  		5,
  		"+"
  	],
  	[
  		8331,
  		1,
  		"−"
  	],
  	[
  		8332,
  		5,
  		"="
  	],
  	[
  		8333,
  		5,
  		"("
  	],
  	[
  		8334,
  		5,
  		")"
  	],
  	[
  		8335,
  		3
  	],
  	[
  		8336,
  		1,
  		"a"
  	],
  	[
  		8337,
  		1,
  		"e"
  	],
  	[
  		8338,
  		1,
  		"o"
  	],
  	[
  		8339,
  		1,
  		"x"
  	],
  	[
  		8340,
  		1,
  		"ə"
  	],
  	[
  		8341,
  		1,
  		"h"
  	],
  	[
  		8342,
  		1,
  		"k"
  	],
  	[
  		8343,
  		1,
  		"l"
  	],
  	[
  		8344,
  		1,
  		"m"
  	],
  	[
  		8345,
  		1,
  		"n"
  	],
  	[
  		8346,
  		1,
  		"p"
  	],
  	[
  		8347,
  		1,
  		"s"
  	],
  	[
  		8348,
  		1,
  		"t"
  	],
  	[
  		[
  			8349,
  			8351
  		],
  		3
  	],
  	[
  		[
  			8352,
  			8359
  		],
  		2
  	],
  	[
  		8360,
  		1,
  		"rs"
  	],
  	[
  		[
  			8361,
  			8362
  		],
  		2
  	],
  	[
  		8363,
  		2
  	],
  	[
  		8364,
  		2
  	],
  	[
  		[
  			8365,
  			8367
  		],
  		2
  	],
  	[
  		[
  			8368,
  			8369
  		],
  		2
  	],
  	[
  		[
  			8370,
  			8373
  		],
  		2
  	],
  	[
  		[
  			8374,
  			8376
  		],
  		2
  	],
  	[
  		8377,
  		2
  	],
  	[
  		8378,
  		2
  	],
  	[
  		[
  			8379,
  			8381
  		],
  		2
  	],
  	[
  		8382,
  		2
  	],
  	[
  		8383,
  		2
  	],
  	[
  		[
  			8384,
  			8399
  		],
  		3
  	],
  	[
  		[
  			8400,
  			8417
  		],
  		2
  	],
  	[
  		[
  			8418,
  			8419
  		],
  		2
  	],
  	[
  		[
  			8420,
  			8426
  		],
  		2
  	],
  	[
  		8427,
  		2
  	],
  	[
  		[
  			8428,
  			8431
  		],
  		2
  	],
  	[
  		8432,
  		2
  	],
  	[
  		[
  			8433,
  			8447
  		],
  		3
  	],
  	[
  		8448,
  		5,
  		"a/c"
  	],
  	[
  		8449,
  		5,
  		"a/s"
  	],
  	[
  		8450,
  		1,
  		"c"
  	],
  	[
  		8451,
  		1,
  		"°c"
  	],
  	[
  		8452,
  		2
  	],
  	[
  		8453,
  		5,
  		"c/o"
  	],
  	[
  		8454,
  		5,
  		"c/u"
  	],
  	[
  		8455,
  		1,
  		"ɛ"
  	],
  	[
  		8456,
  		2
  	],
  	[
  		8457,
  		1,
  		"°f"
  	],
  	[
  		8458,
  		1,
  		"g"
  	],
  	[
  		[
  			8459,
  			8462
  		],
  		1,
  		"h"
  	],
  	[
  		8463,
  		1,
  		"ħ"
  	],
  	[
  		[
  			8464,
  			8465
  		],
  		1,
  		"i"
  	],
  	[
  		[
  			8466,
  			8467
  		],
  		1,
  		"l"
  	],
  	[
  		8468,
  		2
  	],
  	[
  		8469,
  		1,
  		"n"
  	],
  	[
  		8470,
  		1,
  		"no"
  	],
  	[
  		[
  			8471,
  			8472
  		],
  		2
  	],
  	[
  		8473,
  		1,
  		"p"
  	],
  	[
  		8474,
  		1,
  		"q"
  	],
  	[
  		[
  			8475,
  			8477
  		],
  		1,
  		"r"
  	],
  	[
  		[
  			8478,
  			8479
  		],
  		2
  	],
  	[
  		8480,
  		1,
  		"sm"
  	],
  	[
  		8481,
  		1,
  		"tel"
  	],
  	[
  		8482,
  		1,
  		"tm"
  	],
  	[
  		8483,
  		2
  	],
  	[
  		8484,
  		1,
  		"z"
  	],
  	[
  		8485,
  		2
  	],
  	[
  		8486,
  		1,
  		"ω"
  	],
  	[
  		8487,
  		2
  	],
  	[
  		8488,
  		1,
  		"z"
  	],
  	[
  		8489,
  		2
  	],
  	[
  		8490,
  		1,
  		"k"
  	],
  	[
  		8491,
  		1,
  		"å"
  	],
  	[
  		8492,
  		1,
  		"b"
  	],
  	[
  		8493,
  		1,
  		"c"
  	],
  	[
  		8494,
  		2
  	],
  	[
  		[
  			8495,
  			8496
  		],
  		1,
  		"e"
  	],
  	[
  		8497,
  		1,
  		"f"
  	],
  	[
  		8498,
  		3
  	],
  	[
  		8499,
  		1,
  		"m"
  	],
  	[
  		8500,
  		1,
  		"o"
  	],
  	[
  		8501,
  		1,
  		"א"
  	],
  	[
  		8502,
  		1,
  		"ב"
  	],
  	[
  		8503,
  		1,
  		"ג"
  	],
  	[
  		8504,
  		1,
  		"ד"
  	],
  	[
  		8505,
  		1,
  		"i"
  	],
  	[
  		8506,
  		2
  	],
  	[
  		8507,
  		1,
  		"fax"
  	],
  	[
  		8508,
  		1,
  		"π"
  	],
  	[
  		[
  			8509,
  			8510
  		],
  		1,
  		"γ"
  	],
  	[
  		8511,
  		1,
  		"π"
  	],
  	[
  		8512,
  		1,
  		"∑"
  	],
  	[
  		[
  			8513,
  			8516
  		],
  		2
  	],
  	[
  		[
  			8517,
  			8518
  		],
  		1,
  		"d"
  	],
  	[
  		8519,
  		1,
  		"e"
  	],
  	[
  		8520,
  		1,
  		"i"
  	],
  	[
  		8521,
  		1,
  		"j"
  	],
  	[
  		[
  			8522,
  			8523
  		],
  		2
  	],
  	[
  		8524,
  		2
  	],
  	[
  		8525,
  		2
  	],
  	[
  		8526,
  		2
  	],
  	[
  		8527,
  		2
  	],
  	[
  		8528,
  		1,
  		"1⁄7"
  	],
  	[
  		8529,
  		1,
  		"1⁄9"
  	],
  	[
  		8530,
  		1,
  		"1⁄10"
  	],
  	[
  		8531,
  		1,
  		"1⁄3"
  	],
  	[
  		8532,
  		1,
  		"2⁄3"
  	],
  	[
  		8533,
  		1,
  		"1⁄5"
  	],
  	[
  		8534,
  		1,
  		"2⁄5"
  	],
  	[
  		8535,
  		1,
  		"3⁄5"
  	],
  	[
  		8536,
  		1,
  		"4⁄5"
  	],
  	[
  		8537,
  		1,
  		"1⁄6"
  	],
  	[
  		8538,
  		1,
  		"5⁄6"
  	],
  	[
  		8539,
  		1,
  		"1⁄8"
  	],
  	[
  		8540,
  		1,
  		"3⁄8"
  	],
  	[
  		8541,
  		1,
  		"5⁄8"
  	],
  	[
  		8542,
  		1,
  		"7⁄8"
  	],
  	[
  		8543,
  		1,
  		"1⁄"
  	],
  	[
  		8544,
  		1,
  		"i"
  	],
  	[
  		8545,
  		1,
  		"ii"
  	],
  	[
  		8546,
  		1,
  		"iii"
  	],
  	[
  		8547,
  		1,
  		"iv"
  	],
  	[
  		8548,
  		1,
  		"v"
  	],
  	[
  		8549,
  		1,
  		"vi"
  	],
  	[
  		8550,
  		1,
  		"vii"
  	],
  	[
  		8551,
  		1,
  		"viii"
  	],
  	[
  		8552,
  		1,
  		"ix"
  	],
  	[
  		8553,
  		1,
  		"x"
  	],
  	[
  		8554,
  		1,
  		"xi"
  	],
  	[
  		8555,
  		1,
  		"xii"
  	],
  	[
  		8556,
  		1,
  		"l"
  	],
  	[
  		8557,
  		1,
  		"c"
  	],
  	[
  		8558,
  		1,
  		"d"
  	],
  	[
  		8559,
  		1,
  		"m"
  	],
  	[
  		8560,
  		1,
  		"i"
  	],
  	[
  		8561,
  		1,
  		"ii"
  	],
  	[
  		8562,
  		1,
  		"iii"
  	],
  	[
  		8563,
  		1,
  		"iv"
  	],
  	[
  		8564,
  		1,
  		"v"
  	],
  	[
  		8565,
  		1,
  		"vi"
  	],
  	[
  		8566,
  		1,
  		"vii"
  	],
  	[
  		8567,
  		1,
  		"viii"
  	],
  	[
  		8568,
  		1,
  		"ix"
  	],
  	[
  		8569,
  		1,
  		"x"
  	],
  	[
  		8570,
  		1,
  		"xi"
  	],
  	[
  		8571,
  		1,
  		"xii"
  	],
  	[
  		8572,
  		1,
  		"l"
  	],
  	[
  		8573,
  		1,
  		"c"
  	],
  	[
  		8574,
  		1,
  		"d"
  	],
  	[
  		8575,
  		1,
  		"m"
  	],
  	[
  		[
  			8576,
  			8578
  		],
  		2
  	],
  	[
  		8579,
  		3
  	],
  	[
  		8580,
  		2
  	],
  	[
  		[
  			8581,
  			8584
  		],
  		2
  	],
  	[
  		8585,
  		1,
  		"0⁄3"
  	],
  	[
  		[
  			8586,
  			8587
  		],
  		2
  	],
  	[
  		[
  			8588,
  			8591
  		],
  		3
  	],
  	[
  		[
  			8592,
  			8682
  		],
  		2
  	],
  	[
  		[
  			8683,
  			8691
  		],
  		2
  	],
  	[
  		[
  			8692,
  			8703
  		],
  		2
  	],
  	[
  		[
  			8704,
  			8747
  		],
  		2
  	],
  	[
  		8748,
  		1,
  		"∫∫"
  	],
  	[
  		8749,
  		1,
  		"∫∫∫"
  	],
  	[
  		8750,
  		2
  	],
  	[
  		8751,
  		1,
  		"∮∮"
  	],
  	[
  		8752,
  		1,
  		"∮∮∮"
  	],
  	[
  		[
  			8753,
  			8799
  		],
  		2
  	],
  	[
  		8800,
  		4
  	],
  	[
  		[
  			8801,
  			8813
  		],
  		2
  	],
  	[
  		[
  			8814,
  			8815
  		],
  		4
  	],
  	[
  		[
  			8816,
  			8945
  		],
  		2
  	],
  	[
  		[
  			8946,
  			8959
  		],
  		2
  	],
  	[
  		8960,
  		2
  	],
  	[
  		8961,
  		2
  	],
  	[
  		[
  			8962,
  			9000
  		],
  		2
  	],
  	[
  		9001,
  		1,
  		"〈"
  	],
  	[
  		9002,
  		1,
  		"〉"
  	],
  	[
  		[
  			9003,
  			9082
  		],
  		2
  	],
  	[
  		9083,
  		2
  	],
  	[
  		9084,
  		2
  	],
  	[
  		[
  			9085,
  			9114
  		],
  		2
  	],
  	[
  		[
  			9115,
  			9166
  		],
  		2
  	],
  	[
  		[
  			9167,
  			9168
  		],
  		2
  	],
  	[
  		[
  			9169,
  			9179
  		],
  		2
  	],
  	[
  		[
  			9180,
  			9191
  		],
  		2
  	],
  	[
  		9192,
  		2
  	],
  	[
  		[
  			9193,
  			9203
  		],
  		2
  	],
  	[
  		[
  			9204,
  			9210
  		],
  		2
  	],
  	[
  		[
  			9211,
  			9214
  		],
  		2
  	],
  	[
  		9215,
  		2
  	],
  	[
  		[
  			9216,
  			9252
  		],
  		2
  	],
  	[
  		[
  			9253,
  			9254
  		],
  		2
  	],
  	[
  		[
  			9255,
  			9279
  		],
  		3
  	],
  	[
  		[
  			9280,
  			9290
  		],
  		2
  	],
  	[
  		[
  			9291,
  			9311
  		],
  		3
  	],
  	[
  		9312,
  		1,
  		"1"
  	],
  	[
  		9313,
  		1,
  		"2"
  	],
  	[
  		9314,
  		1,
  		"3"
  	],
  	[
  		9315,
  		1,
  		"4"
  	],
  	[
  		9316,
  		1,
  		"5"
  	],
  	[
  		9317,
  		1,
  		"6"
  	],
  	[
  		9318,
  		1,
  		"7"
  	],
  	[
  		9319,
  		1,
  		"8"
  	],
  	[
  		9320,
  		1,
  		"9"
  	],
  	[
  		9321,
  		1,
  		"10"
  	],
  	[
  		9322,
  		1,
  		"11"
  	],
  	[
  		9323,
  		1,
  		"12"
  	],
  	[
  		9324,
  		1,
  		"13"
  	],
  	[
  		9325,
  		1,
  		"14"
  	],
  	[
  		9326,
  		1,
  		"15"
  	],
  	[
  		9327,
  		1,
  		"16"
  	],
  	[
  		9328,
  		1,
  		"17"
  	],
  	[
  		9329,
  		1,
  		"18"
  	],
  	[
  		9330,
  		1,
  		"19"
  	],
  	[
  		9331,
  		1,
  		"20"
  	],
  	[
  		9332,
  		5,
  		"(1)"
  	],
  	[
  		9333,
  		5,
  		"(2)"
  	],
  	[
  		9334,
  		5,
  		"(3)"
  	],
  	[
  		9335,
  		5,
  		"(4)"
  	],
  	[
  		9336,
  		5,
  		"(5)"
  	],
  	[
  		9337,
  		5,
  		"(6)"
  	],
  	[
  		9338,
  		5,
  		"(7)"
  	],
  	[
  		9339,
  		5,
  		"(8)"
  	],
  	[
  		9340,
  		5,
  		"(9)"
  	],
  	[
  		9341,
  		5,
  		"(10)"
  	],
  	[
  		9342,
  		5,
  		"(11)"
  	],
  	[
  		9343,
  		5,
  		"(12)"
  	],
  	[
  		9344,
  		5,
  		"(13)"
  	],
  	[
  		9345,
  		5,
  		"(14)"
  	],
  	[
  		9346,
  		5,
  		"(15)"
  	],
  	[
  		9347,
  		5,
  		"(16)"
  	],
  	[
  		9348,
  		5,
  		"(17)"
  	],
  	[
  		9349,
  		5,
  		"(18)"
  	],
  	[
  		9350,
  		5,
  		"(19)"
  	],
  	[
  		9351,
  		5,
  		"(20)"
  	],
  	[
  		[
  			9352,
  			9371
  		],
  		3
  	],
  	[
  		9372,
  		5,
  		"(a)"
  	],
  	[
  		9373,
  		5,
  		"(b)"
  	],
  	[
  		9374,
  		5,
  		"(c)"
  	],
  	[
  		9375,
  		5,
  		"(d)"
  	],
  	[
  		9376,
  		5,
  		"(e)"
  	],
  	[
  		9377,
  		5,
  		"(f)"
  	],
  	[
  		9378,
  		5,
  		"(g)"
  	],
  	[
  		9379,
  		5,
  		"(h)"
  	],
  	[
  		9380,
  		5,
  		"(i)"
  	],
  	[
  		9381,
  		5,
  		"(j)"
  	],
  	[
  		9382,
  		5,
  		"(k)"
  	],
  	[
  		9383,
  		5,
  		"(l)"
  	],
  	[
  		9384,
  		5,
  		"(m)"
  	],
  	[
  		9385,
  		5,
  		"(n)"
  	],
  	[
  		9386,
  		5,
  		"(o)"
  	],
  	[
  		9387,
  		5,
  		"(p)"
  	],
  	[
  		9388,
  		5,
  		"(q)"
  	],
  	[
  		9389,
  		5,
  		"(r)"
  	],
  	[
  		9390,
  		5,
  		"(s)"
  	],
  	[
  		9391,
  		5,
  		"(t)"
  	],
  	[
  		9392,
  		5,
  		"(u)"
  	],
  	[
  		9393,
  		5,
  		"(v)"
  	],
  	[
  		9394,
  		5,
  		"(w)"
  	],
  	[
  		9395,
  		5,
  		"(x)"
  	],
  	[
  		9396,
  		5,
  		"(y)"
  	],
  	[
  		9397,
  		5,
  		"(z)"
  	],
  	[
  		9398,
  		1,
  		"a"
  	],
  	[
  		9399,
  		1,
  		"b"
  	],
  	[
  		9400,
  		1,
  		"c"
  	],
  	[
  		9401,
  		1,
  		"d"
  	],
  	[
  		9402,
  		1,
  		"e"
  	],
  	[
  		9403,
  		1,
  		"f"
  	],
  	[
  		9404,
  		1,
  		"g"
  	],
  	[
  		9405,
  		1,
  		"h"
  	],
  	[
  		9406,
  		1,
  		"i"
  	],
  	[
  		9407,
  		1,
  		"j"
  	],
  	[
  		9408,
  		1,
  		"k"
  	],
  	[
  		9409,
  		1,
  		"l"
  	],
  	[
  		9410,
  		1,
  		"m"
  	],
  	[
  		9411,
  		1,
  		"n"
  	],
  	[
  		9412,
  		1,
  		"o"
  	],
  	[
  		9413,
  		1,
  		"p"
  	],
  	[
  		9414,
  		1,
  		"q"
  	],
  	[
  		9415,
  		1,
  		"r"
  	],
  	[
  		9416,
  		1,
  		"s"
  	],
  	[
  		9417,
  		1,
  		"t"
  	],
  	[
  		9418,
  		1,
  		"u"
  	],
  	[
  		9419,
  		1,
  		"v"
  	],
  	[
  		9420,
  		1,
  		"w"
  	],
  	[
  		9421,
  		1,
  		"x"
  	],
  	[
  		9422,
  		1,
  		"y"
  	],
  	[
  		9423,
  		1,
  		"z"
  	],
  	[
  		9424,
  		1,
  		"a"
  	],
  	[
  		9425,
  		1,
  		"b"
  	],
  	[
  		9426,
  		1,
  		"c"
  	],
  	[
  		9427,
  		1,
  		"d"
  	],
  	[
  		9428,
  		1,
  		"e"
  	],
  	[
  		9429,
  		1,
  		"f"
  	],
  	[
  		9430,
  		1,
  		"g"
  	],
  	[
  		9431,
  		1,
  		"h"
  	],
  	[
  		9432,
  		1,
  		"i"
  	],
  	[
  		9433,
  		1,
  		"j"
  	],
  	[
  		9434,
  		1,
  		"k"
  	],
  	[
  		9435,
  		1,
  		"l"
  	],
  	[
  		9436,
  		1,
  		"m"
  	],
  	[
  		9437,
  		1,
  		"n"
  	],
  	[
  		9438,
  		1,
  		"o"
  	],
  	[
  		9439,
  		1,
  		"p"
  	],
  	[
  		9440,
  		1,
  		"q"
  	],
  	[
  		9441,
  		1,
  		"r"
  	],
  	[
  		9442,
  		1,
  		"s"
  	],
  	[
  		9443,
  		1,
  		"t"
  	],
  	[
  		9444,
  		1,
  		"u"
  	],
  	[
  		9445,
  		1,
  		"v"
  	],
  	[
  		9446,
  		1,
  		"w"
  	],
  	[
  		9447,
  		1,
  		"x"
  	],
  	[
  		9448,
  		1,
  		"y"
  	],
  	[
  		9449,
  		1,
  		"z"
  	],
  	[
  		9450,
  		1,
  		"0"
  	],
  	[
  		[
  			9451,
  			9470
  		],
  		2
  	],
  	[
  		9471,
  		2
  	],
  	[
  		[
  			9472,
  			9621
  		],
  		2
  	],
  	[
  		[
  			9622,
  			9631
  		],
  		2
  	],
  	[
  		[
  			9632,
  			9711
  		],
  		2
  	],
  	[
  		[
  			9712,
  			9719
  		],
  		2
  	],
  	[
  		[
  			9720,
  			9727
  		],
  		2
  	],
  	[
  		[
  			9728,
  			9747
  		],
  		2
  	],
  	[
  		[
  			9748,
  			9749
  		],
  		2
  	],
  	[
  		[
  			9750,
  			9751
  		],
  		2
  	],
  	[
  		9752,
  		2
  	],
  	[
  		9753,
  		2
  	],
  	[
  		[
  			9754,
  			9839
  		],
  		2
  	],
  	[
  		[
  			9840,
  			9841
  		],
  		2
  	],
  	[
  		[
  			9842,
  			9853
  		],
  		2
  	],
  	[
  		[
  			9854,
  			9855
  		],
  		2
  	],
  	[
  		[
  			9856,
  			9865
  		],
  		2
  	],
  	[
  		[
  			9866,
  			9873
  		],
  		2
  	],
  	[
  		[
  			9874,
  			9884
  		],
  		2
  	],
  	[
  		9885,
  		2
  	],
  	[
  		[
  			9886,
  			9887
  		],
  		2
  	],
  	[
  		[
  			9888,
  			9889
  		],
  		2
  	],
  	[
  		[
  			9890,
  			9905
  		],
  		2
  	],
  	[
  		9906,
  		2
  	],
  	[
  		[
  			9907,
  			9916
  		],
  		2
  	],
  	[
  		[
  			9917,
  			9919
  		],
  		2
  	],
  	[
  		[
  			9920,
  			9923
  		],
  		2
  	],
  	[
  		[
  			9924,
  			9933
  		],
  		2
  	],
  	[
  		9934,
  		2
  	],
  	[
  		[
  			9935,
  			9953
  		],
  		2
  	],
  	[
  		9954,
  		2
  	],
  	[
  		9955,
  		2
  	],
  	[
  		[
  			9956,
  			9959
  		],
  		2
  	],
  	[
  		[
  			9960,
  			9983
  		],
  		2
  	],
  	[
  		9984,
  		2
  	],
  	[
  		[
  			9985,
  			9988
  		],
  		2
  	],
  	[
  		9989,
  		2
  	],
  	[
  		[
  			9990,
  			9993
  		],
  		2
  	],
  	[
  		[
  			9994,
  			9995
  		],
  		2
  	],
  	[
  		[
  			9996,
  			10023
  		],
  		2
  	],
  	[
  		10024,
  		2
  	],
  	[
  		[
  			10025,
  			10059
  		],
  		2
  	],
  	[
  		10060,
  		2
  	],
  	[
  		10061,
  		2
  	],
  	[
  		10062,
  		2
  	],
  	[
  		[
  			10063,
  			10066
  		],
  		2
  	],
  	[
  		[
  			10067,
  			10069
  		],
  		2
  	],
  	[
  		10070,
  		2
  	],
  	[
  		10071,
  		2
  	],
  	[
  		[
  			10072,
  			10078
  		],
  		2
  	],
  	[
  		[
  			10079,
  			10080
  		],
  		2
  	],
  	[
  		[
  			10081,
  			10087
  		],
  		2
  	],
  	[
  		[
  			10088,
  			10101
  		],
  		2
  	],
  	[
  		[
  			10102,
  			10132
  		],
  		2
  	],
  	[
  		[
  			10133,
  			10135
  		],
  		2
  	],
  	[
  		[
  			10136,
  			10159
  		],
  		2
  	],
  	[
  		10160,
  		2
  	],
  	[
  		[
  			10161,
  			10174
  		],
  		2
  	],
  	[
  		10175,
  		2
  	],
  	[
  		[
  			10176,
  			10182
  		],
  		2
  	],
  	[
  		[
  			10183,
  			10186
  		],
  		2
  	],
  	[
  		10187,
  		2
  	],
  	[
  		10188,
  		2
  	],
  	[
  		10189,
  		2
  	],
  	[
  		[
  			10190,
  			10191
  		],
  		2
  	],
  	[
  		[
  			10192,
  			10219
  		],
  		2
  	],
  	[
  		[
  			10220,
  			10223
  		],
  		2
  	],
  	[
  		[
  			10224,
  			10239
  		],
  		2
  	],
  	[
  		[
  			10240,
  			10495
  		],
  		2
  	],
  	[
  		[
  			10496,
  			10763
  		],
  		2
  	],
  	[
  		10764,
  		1,
  		"∫∫∫∫"
  	],
  	[
  		[
  			10765,
  			10867
  		],
  		2
  	],
  	[
  		10868,
  		5,
  		"::="
  	],
  	[
  		10869,
  		5,
  		"=="
  	],
  	[
  		10870,
  		5,
  		"==="
  	],
  	[
  		[
  			10871,
  			10971
  		],
  		2
  	],
  	[
  		10972,
  		1,
  		"⫝̸"
  	],
  	[
  		[
  			10973,
  			11007
  		],
  		2
  	],
  	[
  		[
  			11008,
  			11021
  		],
  		2
  	],
  	[
  		[
  			11022,
  			11027
  		],
  		2
  	],
  	[
  		[
  			11028,
  			11034
  		],
  		2
  	],
  	[
  		[
  			11035,
  			11039
  		],
  		2
  	],
  	[
  		[
  			11040,
  			11043
  		],
  		2
  	],
  	[
  		[
  			11044,
  			11084
  		],
  		2
  	],
  	[
  		[
  			11085,
  			11087
  		],
  		2
  	],
  	[
  		[
  			11088,
  			11092
  		],
  		2
  	],
  	[
  		[
  			11093,
  			11097
  		],
  		2
  	],
  	[
  		[
  			11098,
  			11123
  		],
  		2
  	],
  	[
  		[
  			11124,
  			11125
  		],
  		3
  	],
  	[
  		[
  			11126,
  			11157
  		],
  		2
  	],
  	[
  		11158,
  		3
  	],
  	[
  		11159,
  		2
  	],
  	[
  		[
  			11160,
  			11193
  		],
  		2
  	],
  	[
  		[
  			11194,
  			11196
  		],
  		2
  	],
  	[
  		[
  			11197,
  			11208
  		],
  		2
  	],
  	[
  		11209,
  		2
  	],
  	[
  		[
  			11210,
  			11217
  		],
  		2
  	],
  	[
  		11218,
  		2
  	],
  	[
  		[
  			11219,
  			11243
  		],
  		2
  	],
  	[
  		[
  			11244,
  			11247
  		],
  		2
  	],
  	[
  		[
  			11248,
  			11262
  		],
  		2
  	],
  	[
  		11263,
  		2
  	],
  	[
  		11264,
  		1,
  		"ⰰ"
  	],
  	[
  		11265,
  		1,
  		"ⰱ"
  	],
  	[
  		11266,
  		1,
  		"ⰲ"
  	],
  	[
  		11267,
  		1,
  		"ⰳ"
  	],
  	[
  		11268,
  		1,
  		"ⰴ"
  	],
  	[
  		11269,
  		1,
  		"ⰵ"
  	],
  	[
  		11270,
  		1,
  		"ⰶ"
  	],
  	[
  		11271,
  		1,
  		"ⰷ"
  	],
  	[
  		11272,
  		1,
  		"ⰸ"
  	],
  	[
  		11273,
  		1,
  		"ⰹ"
  	],
  	[
  		11274,
  		1,
  		"ⰺ"
  	],
  	[
  		11275,
  		1,
  		"ⰻ"
  	],
  	[
  		11276,
  		1,
  		"ⰼ"
  	],
  	[
  		11277,
  		1,
  		"ⰽ"
  	],
  	[
  		11278,
  		1,
  		"ⰾ"
  	],
  	[
  		11279,
  		1,
  		"ⰿ"
  	],
  	[
  		11280,
  		1,
  		"ⱀ"
  	],
  	[
  		11281,
  		1,
  		"ⱁ"
  	],
  	[
  		11282,
  		1,
  		"ⱂ"
  	],
  	[
  		11283,
  		1,
  		"ⱃ"
  	],
  	[
  		11284,
  		1,
  		"ⱄ"
  	],
  	[
  		11285,
  		1,
  		"ⱅ"
  	],
  	[
  		11286,
  		1,
  		"ⱆ"
  	],
  	[
  		11287,
  		1,
  		"ⱇ"
  	],
  	[
  		11288,
  		1,
  		"ⱈ"
  	],
  	[
  		11289,
  		1,
  		"ⱉ"
  	],
  	[
  		11290,
  		1,
  		"ⱊ"
  	],
  	[
  		11291,
  		1,
  		"ⱋ"
  	],
  	[
  		11292,
  		1,
  		"ⱌ"
  	],
  	[
  		11293,
  		1,
  		"ⱍ"
  	],
  	[
  		11294,
  		1,
  		"ⱎ"
  	],
  	[
  		11295,
  		1,
  		"ⱏ"
  	],
  	[
  		11296,
  		1,
  		"ⱐ"
  	],
  	[
  		11297,
  		1,
  		"ⱑ"
  	],
  	[
  		11298,
  		1,
  		"ⱒ"
  	],
  	[
  		11299,
  		1,
  		"ⱓ"
  	],
  	[
  		11300,
  		1,
  		"ⱔ"
  	],
  	[
  		11301,
  		1,
  		"ⱕ"
  	],
  	[
  		11302,
  		1,
  		"ⱖ"
  	],
  	[
  		11303,
  		1,
  		"ⱗ"
  	],
  	[
  		11304,
  		1,
  		"ⱘ"
  	],
  	[
  		11305,
  		1,
  		"ⱙ"
  	],
  	[
  		11306,
  		1,
  		"ⱚ"
  	],
  	[
  		11307,
  		1,
  		"ⱛ"
  	],
  	[
  		11308,
  		1,
  		"ⱜ"
  	],
  	[
  		11309,
  		1,
  		"ⱝ"
  	],
  	[
  		11310,
  		1,
  		"ⱞ"
  	],
  	[
  		11311,
  		3
  	],
  	[
  		[
  			11312,
  			11358
  		],
  		2
  	],
  	[
  		11359,
  		3
  	],
  	[
  		11360,
  		1,
  		"ⱡ"
  	],
  	[
  		11361,
  		2
  	],
  	[
  		11362,
  		1,
  		"ɫ"
  	],
  	[
  		11363,
  		1,
  		"ᵽ"
  	],
  	[
  		11364,
  		1,
  		"ɽ"
  	],
  	[
  		[
  			11365,
  			11366
  		],
  		2
  	],
  	[
  		11367,
  		1,
  		"ⱨ"
  	],
  	[
  		11368,
  		2
  	],
  	[
  		11369,
  		1,
  		"ⱪ"
  	],
  	[
  		11370,
  		2
  	],
  	[
  		11371,
  		1,
  		"ⱬ"
  	],
  	[
  		11372,
  		2
  	],
  	[
  		11373,
  		1,
  		"ɑ"
  	],
  	[
  		11374,
  		1,
  		"ɱ"
  	],
  	[
  		11375,
  		1,
  		"ɐ"
  	],
  	[
  		11376,
  		1,
  		"ɒ"
  	],
  	[
  		11377,
  		2
  	],
  	[
  		11378,
  		1,
  		"ⱳ"
  	],
  	[
  		11379,
  		2
  	],
  	[
  		11380,
  		2
  	],
  	[
  		11381,
  		1,
  		"ⱶ"
  	],
  	[
  		[
  			11382,
  			11383
  		],
  		2
  	],
  	[
  		[
  			11384,
  			11387
  		],
  		2
  	],
  	[
  		11388,
  		1,
  		"j"
  	],
  	[
  		11389,
  		1,
  		"v"
  	],
  	[
  		11390,
  		1,
  		"ȿ"
  	],
  	[
  		11391,
  		1,
  		"ɀ"
  	],
  	[
  		11392,
  		1,
  		"ⲁ"
  	],
  	[
  		11393,
  		2
  	],
  	[
  		11394,
  		1,
  		"ⲃ"
  	],
  	[
  		11395,
  		2
  	],
  	[
  		11396,
  		1,
  		"ⲅ"
  	],
  	[
  		11397,
  		2
  	],
  	[
  		11398,
  		1,
  		"ⲇ"
  	],
  	[
  		11399,
  		2
  	],
  	[
  		11400,
  		1,
  		"ⲉ"
  	],
  	[
  		11401,
  		2
  	],
  	[
  		11402,
  		1,
  		"ⲋ"
  	],
  	[
  		11403,
  		2
  	],
  	[
  		11404,
  		1,
  		"ⲍ"
  	],
  	[
  		11405,
  		2
  	],
  	[
  		11406,
  		1,
  		"ⲏ"
  	],
  	[
  		11407,
  		2
  	],
  	[
  		11408,
  		1,
  		"ⲑ"
  	],
  	[
  		11409,
  		2
  	],
  	[
  		11410,
  		1,
  		"ⲓ"
  	],
  	[
  		11411,
  		2
  	],
  	[
  		11412,
  		1,
  		"ⲕ"
  	],
  	[
  		11413,
  		2
  	],
  	[
  		11414,
  		1,
  		"ⲗ"
  	],
  	[
  		11415,
  		2
  	],
  	[
  		11416,
  		1,
  		"ⲙ"
  	],
  	[
  		11417,
  		2
  	],
  	[
  		11418,
  		1,
  		"ⲛ"
  	],
  	[
  		11419,
  		2
  	],
  	[
  		11420,
  		1,
  		"ⲝ"
  	],
  	[
  		11421,
  		2
  	],
  	[
  		11422,
  		1,
  		"ⲟ"
  	],
  	[
  		11423,
  		2
  	],
  	[
  		11424,
  		1,
  		"ⲡ"
  	],
  	[
  		11425,
  		2
  	],
  	[
  		11426,
  		1,
  		"ⲣ"
  	],
  	[
  		11427,
  		2
  	],
  	[
  		11428,
  		1,
  		"ⲥ"
  	],
  	[
  		11429,
  		2
  	],
  	[
  		11430,
  		1,
  		"ⲧ"
  	],
  	[
  		11431,
  		2
  	],
  	[
  		11432,
  		1,
  		"ⲩ"
  	],
  	[
  		11433,
  		2
  	],
  	[
  		11434,
  		1,
  		"ⲫ"
  	],
  	[
  		11435,
  		2
  	],
  	[
  		11436,
  		1,
  		"ⲭ"
  	],
  	[
  		11437,
  		2
  	],
  	[
  		11438,
  		1,
  		"ⲯ"
  	],
  	[
  		11439,
  		2
  	],
  	[
  		11440,
  		1,
  		"ⲱ"
  	],
  	[
  		11441,
  		2
  	],
  	[
  		11442,
  		1,
  		"ⲳ"
  	],
  	[
  		11443,
  		2
  	],
  	[
  		11444,
  		1,
  		"ⲵ"
  	],
  	[
  		11445,
  		2
  	],
  	[
  		11446,
  		1,
  		"ⲷ"
  	],
  	[
  		11447,
  		2
  	],
  	[
  		11448,
  		1,
  		"ⲹ"
  	],
  	[
  		11449,
  		2
  	],
  	[
  		11450,
  		1,
  		"ⲻ"
  	],
  	[
  		11451,
  		2
  	],
  	[
  		11452,
  		1,
  		"ⲽ"
  	],
  	[
  		11453,
  		2
  	],
  	[
  		11454,
  		1,
  		"ⲿ"
  	],
  	[
  		11455,
  		2
  	],
  	[
  		11456,
  		1,
  		"ⳁ"
  	],
  	[
  		11457,
  		2
  	],
  	[
  		11458,
  		1,
  		"ⳃ"
  	],
  	[
  		11459,
  		2
  	],
  	[
  		11460,
  		1,
  		"ⳅ"
  	],
  	[
  		11461,
  		2
  	],
  	[
  		11462,
  		1,
  		"ⳇ"
  	],
  	[
  		11463,
  		2
  	],
  	[
  		11464,
  		1,
  		"ⳉ"
  	],
  	[
  		11465,
  		2
  	],
  	[
  		11466,
  		1,
  		"ⳋ"
  	],
  	[
  		11467,
  		2
  	],
  	[
  		11468,
  		1,
  		"ⳍ"
  	],
  	[
  		11469,
  		2
  	],
  	[
  		11470,
  		1,
  		"ⳏ"
  	],
  	[
  		11471,
  		2
  	],
  	[
  		11472,
  		1,
  		"ⳑ"
  	],
  	[
  		11473,
  		2
  	],
  	[
  		11474,
  		1,
  		"ⳓ"
  	],
  	[
  		11475,
  		2
  	],
  	[
  		11476,
  		1,
  		"ⳕ"
  	],
  	[
  		11477,
  		2
  	],
  	[
  		11478,
  		1,
  		"ⳗ"
  	],
  	[
  		11479,
  		2
  	],
  	[
  		11480,
  		1,
  		"ⳙ"
  	],
  	[
  		11481,
  		2
  	],
  	[
  		11482,
  		1,
  		"ⳛ"
  	],
  	[
  		11483,
  		2
  	],
  	[
  		11484,
  		1,
  		"ⳝ"
  	],
  	[
  		11485,
  		2
  	],
  	[
  		11486,
  		1,
  		"ⳟ"
  	],
  	[
  		11487,
  		2
  	],
  	[
  		11488,
  		1,
  		"ⳡ"
  	],
  	[
  		11489,
  		2
  	],
  	[
  		11490,
  		1,
  		"ⳣ"
  	],
  	[
  		[
  			11491,
  			11492
  		],
  		2
  	],
  	[
  		[
  			11493,
  			11498
  		],
  		2
  	],
  	[
  		11499,
  		1,
  		"ⳬ"
  	],
  	[
  		11500,
  		2
  	],
  	[
  		11501,
  		1,
  		"ⳮ"
  	],
  	[
  		[
  			11502,
  			11505
  		],
  		2
  	],
  	[
  		11506,
  		1,
  		"ⳳ"
  	],
  	[
  		11507,
  		2
  	],
  	[
  		[
  			11508,
  			11512
  		],
  		3
  	],
  	[
  		[
  			11513,
  			11519
  		],
  		2
  	],
  	[
  		[
  			11520,
  			11557
  		],
  		2
  	],
  	[
  		11558,
  		3
  	],
  	[
  		11559,
  		2
  	],
  	[
  		[
  			11560,
  			11564
  		],
  		3
  	],
  	[
  		11565,
  		2
  	],
  	[
  		[
  			11566,
  			11567
  		],
  		3
  	],
  	[
  		[
  			11568,
  			11621
  		],
  		2
  	],
  	[
  		[
  			11622,
  			11623
  		],
  		2
  	],
  	[
  		[
  			11624,
  			11630
  		],
  		3
  	],
  	[
  		11631,
  		1,
  		"ⵡ"
  	],
  	[
  		11632,
  		2
  	],
  	[
  		[
  			11633,
  			11646
  		],
  		3
  	],
  	[
  		11647,
  		2
  	],
  	[
  		[
  			11648,
  			11670
  		],
  		2
  	],
  	[
  		[
  			11671,
  			11679
  		],
  		3
  	],
  	[
  		[
  			11680,
  			11686
  		],
  		2
  	],
  	[
  		11687,
  		3
  	],
  	[
  		[
  			11688,
  			11694
  		],
  		2
  	],
  	[
  		11695,
  		3
  	],
  	[
  		[
  			11696,
  			11702
  		],
  		2
  	],
  	[
  		11703,
  		3
  	],
  	[
  		[
  			11704,
  			11710
  		],
  		2
  	],
  	[
  		11711,
  		3
  	],
  	[
  		[
  			11712,
  			11718
  		],
  		2
  	],
  	[
  		11719,
  		3
  	],
  	[
  		[
  			11720,
  			11726
  		],
  		2
  	],
  	[
  		11727,
  		3
  	],
  	[
  		[
  			11728,
  			11734
  		],
  		2
  	],
  	[
  		11735,
  		3
  	],
  	[
  		[
  			11736,
  			11742
  		],
  		2
  	],
  	[
  		11743,
  		3
  	],
  	[
  		[
  			11744,
  			11775
  		],
  		2
  	],
  	[
  		[
  			11776,
  			11799
  		],
  		2
  	],
  	[
  		[
  			11800,
  			11803
  		],
  		2
  	],
  	[
  		[
  			11804,
  			11805
  		],
  		2
  	],
  	[
  		[
  			11806,
  			11822
  		],
  		2
  	],
  	[
  		11823,
  		2
  	],
  	[
  		11824,
  		2
  	],
  	[
  		11825,
  		2
  	],
  	[
  		[
  			11826,
  			11835
  		],
  		2
  	],
  	[
  		[
  			11836,
  			11842
  		],
  		2
  	],
  	[
  		[
  			11843,
  			11844
  		],
  		2
  	],
  	[
  		[
  			11845,
  			11849
  		],
  		2
  	],
  	[
  		[
  			11850,
  			11854
  		],
  		2
  	],
  	[
  		11855,
  		2
  	],
  	[
  		[
  			11856,
  			11858
  		],
  		2
  	],
  	[
  		[
  			11859,
  			11903
  		],
  		3
  	],
  	[
  		[
  			11904,
  			11929
  		],
  		2
  	],
  	[
  		11930,
  		3
  	],
  	[
  		[
  			11931,
  			11934
  		],
  		2
  	],
  	[
  		11935,
  		1,
  		"母"
  	],
  	[
  		[
  			11936,
  			12018
  		],
  		2
  	],
  	[
  		12019,
  		1,
  		"龟"
  	],
  	[
  		[
  			12020,
  			12031
  		],
  		3
  	],
  	[
  		12032,
  		1,
  		"一"
  	],
  	[
  		12033,
  		1,
  		"丨"
  	],
  	[
  		12034,
  		1,
  		"丶"
  	],
  	[
  		12035,
  		1,
  		"丿"
  	],
  	[
  		12036,
  		1,
  		"乙"
  	],
  	[
  		12037,
  		1,
  		"亅"
  	],
  	[
  		12038,
  		1,
  		"二"
  	],
  	[
  		12039,
  		1,
  		"亠"
  	],
  	[
  		12040,
  		1,
  		"人"
  	],
  	[
  		12041,
  		1,
  		"儿"
  	],
  	[
  		12042,
  		1,
  		"入"
  	],
  	[
  		12043,
  		1,
  		"八"
  	],
  	[
  		12044,
  		1,
  		"冂"
  	],
  	[
  		12045,
  		1,
  		"冖"
  	],
  	[
  		12046,
  		1,
  		"冫"
  	],
  	[
  		12047,
  		1,
  		"几"
  	],
  	[
  		12048,
  		1,
  		"凵"
  	],
  	[
  		12049,
  		1,
  		"刀"
  	],
  	[
  		12050,
  		1,
  		"力"
  	],
  	[
  		12051,
  		1,
  		"勹"
  	],
  	[
  		12052,
  		1,
  		"匕"
  	],
  	[
  		12053,
  		1,
  		"匚"
  	],
  	[
  		12054,
  		1,
  		"匸"
  	],
  	[
  		12055,
  		1,
  		"十"
  	],
  	[
  		12056,
  		1,
  		"卜"
  	],
  	[
  		12057,
  		1,
  		"卩"
  	],
  	[
  		12058,
  		1,
  		"厂"
  	],
  	[
  		12059,
  		1,
  		"厶"
  	],
  	[
  		12060,
  		1,
  		"又"
  	],
  	[
  		12061,
  		1,
  		"口"
  	],
  	[
  		12062,
  		1,
  		"囗"
  	],
  	[
  		12063,
  		1,
  		"土"
  	],
  	[
  		12064,
  		1,
  		"士"
  	],
  	[
  		12065,
  		1,
  		"夂"
  	],
  	[
  		12066,
  		1,
  		"夊"
  	],
  	[
  		12067,
  		1,
  		"夕"
  	],
  	[
  		12068,
  		1,
  		"大"
  	],
  	[
  		12069,
  		1,
  		"女"
  	],
  	[
  		12070,
  		1,
  		"子"
  	],
  	[
  		12071,
  		1,
  		"宀"
  	],
  	[
  		12072,
  		1,
  		"寸"
  	],
  	[
  		12073,
  		1,
  		"小"
  	],
  	[
  		12074,
  		1,
  		"尢"
  	],
  	[
  		12075,
  		1,
  		"尸"
  	],
  	[
  		12076,
  		1,
  		"屮"
  	],
  	[
  		12077,
  		1,
  		"山"
  	],
  	[
  		12078,
  		1,
  		"巛"
  	],
  	[
  		12079,
  		1,
  		"工"
  	],
  	[
  		12080,
  		1,
  		"己"
  	],
  	[
  		12081,
  		1,
  		"巾"
  	],
  	[
  		12082,
  		1,
  		"干"
  	],
  	[
  		12083,
  		1,
  		"幺"
  	],
  	[
  		12084,
  		1,
  		"广"
  	],
  	[
  		12085,
  		1,
  		"廴"
  	],
  	[
  		12086,
  		1,
  		"廾"
  	],
  	[
  		12087,
  		1,
  		"弋"
  	],
  	[
  		12088,
  		1,
  		"弓"
  	],
  	[
  		12089,
  		1,
  		"彐"
  	],
  	[
  		12090,
  		1,
  		"彡"
  	],
  	[
  		12091,
  		1,
  		"彳"
  	],
  	[
  		12092,
  		1,
  		"心"
  	],
  	[
  		12093,
  		1,
  		"戈"
  	],
  	[
  		12094,
  		1,
  		"戶"
  	],
  	[
  		12095,
  		1,
  		"手"
  	],
  	[
  		12096,
  		1,
  		"支"
  	],
  	[
  		12097,
  		1,
  		"攴"
  	],
  	[
  		12098,
  		1,
  		"文"
  	],
  	[
  		12099,
  		1,
  		"斗"
  	],
  	[
  		12100,
  		1,
  		"斤"
  	],
  	[
  		12101,
  		1,
  		"方"
  	],
  	[
  		12102,
  		1,
  		"无"
  	],
  	[
  		12103,
  		1,
  		"日"
  	],
  	[
  		12104,
  		1,
  		"曰"
  	],
  	[
  		12105,
  		1,
  		"月"
  	],
  	[
  		12106,
  		1,
  		"木"
  	],
  	[
  		12107,
  		1,
  		"欠"
  	],
  	[
  		12108,
  		1,
  		"止"
  	],
  	[
  		12109,
  		1,
  		"歹"
  	],
  	[
  		12110,
  		1,
  		"殳"
  	],
  	[
  		12111,
  		1,
  		"毋"
  	],
  	[
  		12112,
  		1,
  		"比"
  	],
  	[
  		12113,
  		1,
  		"毛"
  	],
  	[
  		12114,
  		1,
  		"氏"
  	],
  	[
  		12115,
  		1,
  		"气"
  	],
  	[
  		12116,
  		1,
  		"水"
  	],
  	[
  		12117,
  		1,
  		"火"
  	],
  	[
  		12118,
  		1,
  		"爪"
  	],
  	[
  		12119,
  		1,
  		"父"
  	],
  	[
  		12120,
  		1,
  		"爻"
  	],
  	[
  		12121,
  		1,
  		"爿"
  	],
  	[
  		12122,
  		1,
  		"片"
  	],
  	[
  		12123,
  		1,
  		"牙"
  	],
  	[
  		12124,
  		1,
  		"牛"
  	],
  	[
  		12125,
  		1,
  		"犬"
  	],
  	[
  		12126,
  		1,
  		"玄"
  	],
  	[
  		12127,
  		1,
  		"玉"
  	],
  	[
  		12128,
  		1,
  		"瓜"
  	],
  	[
  		12129,
  		1,
  		"瓦"
  	],
  	[
  		12130,
  		1,
  		"甘"
  	],
  	[
  		12131,
  		1,
  		"生"
  	],
  	[
  		12132,
  		1,
  		"用"
  	],
  	[
  		12133,
  		1,
  		"田"
  	],
  	[
  		12134,
  		1,
  		"疋"
  	],
  	[
  		12135,
  		1,
  		"疒"
  	],
  	[
  		12136,
  		1,
  		"癶"
  	],
  	[
  		12137,
  		1,
  		"白"
  	],
  	[
  		12138,
  		1,
  		"皮"
  	],
  	[
  		12139,
  		1,
  		"皿"
  	],
  	[
  		12140,
  		1,
  		"目"
  	],
  	[
  		12141,
  		1,
  		"矛"
  	],
  	[
  		12142,
  		1,
  		"矢"
  	],
  	[
  		12143,
  		1,
  		"石"
  	],
  	[
  		12144,
  		1,
  		"示"
  	],
  	[
  		12145,
  		1,
  		"禸"
  	],
  	[
  		12146,
  		1,
  		"禾"
  	],
  	[
  		12147,
  		1,
  		"穴"
  	],
  	[
  		12148,
  		1,
  		"立"
  	],
  	[
  		12149,
  		1,
  		"竹"
  	],
  	[
  		12150,
  		1,
  		"米"
  	],
  	[
  		12151,
  		1,
  		"糸"
  	],
  	[
  		12152,
  		1,
  		"缶"
  	],
  	[
  		12153,
  		1,
  		"网"
  	],
  	[
  		12154,
  		1,
  		"羊"
  	],
  	[
  		12155,
  		1,
  		"羽"
  	],
  	[
  		12156,
  		1,
  		"老"
  	],
  	[
  		12157,
  		1,
  		"而"
  	],
  	[
  		12158,
  		1,
  		"耒"
  	],
  	[
  		12159,
  		1,
  		"耳"
  	],
  	[
  		12160,
  		1,
  		"聿"
  	],
  	[
  		12161,
  		1,
  		"肉"
  	],
  	[
  		12162,
  		1,
  		"臣"
  	],
  	[
  		12163,
  		1,
  		"自"
  	],
  	[
  		12164,
  		1,
  		"至"
  	],
  	[
  		12165,
  		1,
  		"臼"
  	],
  	[
  		12166,
  		1,
  		"舌"
  	],
  	[
  		12167,
  		1,
  		"舛"
  	],
  	[
  		12168,
  		1,
  		"舟"
  	],
  	[
  		12169,
  		1,
  		"艮"
  	],
  	[
  		12170,
  		1,
  		"色"
  	],
  	[
  		12171,
  		1,
  		"艸"
  	],
  	[
  		12172,
  		1,
  		"虍"
  	],
  	[
  		12173,
  		1,
  		"虫"
  	],
  	[
  		12174,
  		1,
  		"血"
  	],
  	[
  		12175,
  		1,
  		"行"
  	],
  	[
  		12176,
  		1,
  		"衣"
  	],
  	[
  		12177,
  		1,
  		"襾"
  	],
  	[
  		12178,
  		1,
  		"見"
  	],
  	[
  		12179,
  		1,
  		"角"
  	],
  	[
  		12180,
  		1,
  		"言"
  	],
  	[
  		12181,
  		1,
  		"谷"
  	],
  	[
  		12182,
  		1,
  		"豆"
  	],
  	[
  		12183,
  		1,
  		"豕"
  	],
  	[
  		12184,
  		1,
  		"豸"
  	],
  	[
  		12185,
  		1,
  		"貝"
  	],
  	[
  		12186,
  		1,
  		"赤"
  	],
  	[
  		12187,
  		1,
  		"走"
  	],
  	[
  		12188,
  		1,
  		"足"
  	],
  	[
  		12189,
  		1,
  		"身"
  	],
  	[
  		12190,
  		1,
  		"車"
  	],
  	[
  		12191,
  		1,
  		"辛"
  	],
  	[
  		12192,
  		1,
  		"辰"
  	],
  	[
  		12193,
  		1,
  		"辵"
  	],
  	[
  		12194,
  		1,
  		"邑"
  	],
  	[
  		12195,
  		1,
  		"酉"
  	],
  	[
  		12196,
  		1,
  		"釆"
  	],
  	[
  		12197,
  		1,
  		"里"
  	],
  	[
  		12198,
  		1,
  		"金"
  	],
  	[
  		12199,
  		1,
  		"長"
  	],
  	[
  		12200,
  		1,
  		"門"
  	],
  	[
  		12201,
  		1,
  		"阜"
  	],
  	[
  		12202,
  		1,
  		"隶"
  	],
  	[
  		12203,
  		1,
  		"隹"
  	],
  	[
  		12204,
  		1,
  		"雨"
  	],
  	[
  		12205,
  		1,
  		"靑"
  	],
  	[
  		12206,
  		1,
  		"非"
  	],
  	[
  		12207,
  		1,
  		"面"
  	],
  	[
  		12208,
  		1,
  		"革"
  	],
  	[
  		12209,
  		1,
  		"韋"
  	],
  	[
  		12210,
  		1,
  		"韭"
  	],
  	[
  		12211,
  		1,
  		"音"
  	],
  	[
  		12212,
  		1,
  		"頁"
  	],
  	[
  		12213,
  		1,
  		"風"
  	],
  	[
  		12214,
  		1,
  		"飛"
  	],
  	[
  		12215,
  		1,
  		"食"
  	],
  	[
  		12216,
  		1,
  		"首"
  	],
  	[
  		12217,
  		1,
  		"香"
  	],
  	[
  		12218,
  		1,
  		"馬"
  	],
  	[
  		12219,
  		1,
  		"骨"
  	],
  	[
  		12220,
  		1,
  		"高"
  	],
  	[
  		12221,
  		1,
  		"髟"
  	],
  	[
  		12222,
  		1,
  		"鬥"
  	],
  	[
  		12223,
  		1,
  		"鬯"
  	],
  	[
  		12224,
  		1,
  		"鬲"
  	],
  	[
  		12225,
  		1,
  		"鬼"
  	],
  	[
  		12226,
  		1,
  		"魚"
  	],
  	[
  		12227,
  		1,
  		"鳥"
  	],
  	[
  		12228,
  		1,
  		"鹵"
  	],
  	[
  		12229,
  		1,
  		"鹿"
  	],
  	[
  		12230,
  		1,
  		"麥"
  	],
  	[
  		12231,
  		1,
  		"麻"
  	],
  	[
  		12232,
  		1,
  		"黃"
  	],
  	[
  		12233,
  		1,
  		"黍"
  	],
  	[
  		12234,
  		1,
  		"黑"
  	],
  	[
  		12235,
  		1,
  		"黹"
  	],
  	[
  		12236,
  		1,
  		"黽"
  	],
  	[
  		12237,
  		1,
  		"鼎"
  	],
  	[
  		12238,
  		1,
  		"鼓"
  	],
  	[
  		12239,
  		1,
  		"鼠"
  	],
  	[
  		12240,
  		1,
  		"鼻"
  	],
  	[
  		12241,
  		1,
  		"齊"
  	],
  	[
  		12242,
  		1,
  		"齒"
  	],
  	[
  		12243,
  		1,
  		"龍"
  	],
  	[
  		12244,
  		1,
  		"龜"
  	],
  	[
  		12245,
  		1,
  		"龠"
  	],
  	[
  		[
  			12246,
  			12271
  		],
  		3
  	],
  	[
  		[
  			12272,
  			12283
  		],
  		3
  	],
  	[
  		[
  			12284,
  			12287
  		],
  		3
  	],
  	[
  		12288,
  		5,
  		" "
  	],
  	[
  		12289,
  		2
  	],
  	[
  		12290,
  		1,
  		"."
  	],
  	[
  		[
  			12291,
  			12292
  		],
  		2
  	],
  	[
  		[
  			12293,
  			12295
  		],
  		2
  	],
  	[
  		[
  			12296,
  			12329
  		],
  		2
  	],
  	[
  		[
  			12330,
  			12333
  		],
  		2
  	],
  	[
  		[
  			12334,
  			12341
  		],
  		2
  	],
  	[
  		12342,
  		1,
  		"〒"
  	],
  	[
  		12343,
  		2
  	],
  	[
  		12344,
  		1,
  		"十"
  	],
  	[
  		12345,
  		1,
  		"卄"
  	],
  	[
  		12346,
  		1,
  		"卅"
  	],
  	[
  		12347,
  		2
  	],
  	[
  		12348,
  		2
  	],
  	[
  		12349,
  		2
  	],
  	[
  		12350,
  		2
  	],
  	[
  		12351,
  		2
  	],
  	[
  		12352,
  		3
  	],
  	[
  		[
  			12353,
  			12436
  		],
  		2
  	],
  	[
  		[
  			12437,
  			12438
  		],
  		2
  	],
  	[
  		[
  			12439,
  			12440
  		],
  		3
  	],
  	[
  		[
  			12441,
  			12442
  		],
  		2
  	],
  	[
  		12443,
  		5,
  		" ゙"
  	],
  	[
  		12444,
  		5,
  		" ゚"
  	],
  	[
  		[
  			12445,
  			12446
  		],
  		2
  	],
  	[
  		12447,
  		1,
  		"より"
  	],
  	[
  		12448,
  		2
  	],
  	[
  		[
  			12449,
  			12542
  		],
  		2
  	],
  	[
  		12543,
  		1,
  		"コト"
  	],
  	[
  		[
  			12544,
  			12548
  		],
  		3
  	],
  	[
  		[
  			12549,
  			12588
  		],
  		2
  	],
  	[
  		12589,
  		2
  	],
  	[
  		12590,
  		2
  	],
  	[
  		12591,
  		2
  	],
  	[
  		12592,
  		3
  	],
  	[
  		12593,
  		1,
  		"ᄀ"
  	],
  	[
  		12594,
  		1,
  		"ᄁ"
  	],
  	[
  		12595,
  		1,
  		"ᆪ"
  	],
  	[
  		12596,
  		1,
  		"ᄂ"
  	],
  	[
  		12597,
  		1,
  		"ᆬ"
  	],
  	[
  		12598,
  		1,
  		"ᆭ"
  	],
  	[
  		12599,
  		1,
  		"ᄃ"
  	],
  	[
  		12600,
  		1,
  		"ᄄ"
  	],
  	[
  		12601,
  		1,
  		"ᄅ"
  	],
  	[
  		12602,
  		1,
  		"ᆰ"
  	],
  	[
  		12603,
  		1,
  		"ᆱ"
  	],
  	[
  		12604,
  		1,
  		"ᆲ"
  	],
  	[
  		12605,
  		1,
  		"ᆳ"
  	],
  	[
  		12606,
  		1,
  		"ᆴ"
  	],
  	[
  		12607,
  		1,
  		"ᆵ"
  	],
  	[
  		12608,
  		1,
  		"ᄚ"
  	],
  	[
  		12609,
  		1,
  		"ᄆ"
  	],
  	[
  		12610,
  		1,
  		"ᄇ"
  	],
  	[
  		12611,
  		1,
  		"ᄈ"
  	],
  	[
  		12612,
  		1,
  		"ᄡ"
  	],
  	[
  		12613,
  		1,
  		"ᄉ"
  	],
  	[
  		12614,
  		1,
  		"ᄊ"
  	],
  	[
  		12615,
  		1,
  		"ᄋ"
  	],
  	[
  		12616,
  		1,
  		"ᄌ"
  	],
  	[
  		12617,
  		1,
  		"ᄍ"
  	],
  	[
  		12618,
  		1,
  		"ᄎ"
  	],
  	[
  		12619,
  		1,
  		"ᄏ"
  	],
  	[
  		12620,
  		1,
  		"ᄐ"
  	],
  	[
  		12621,
  		1,
  		"ᄑ"
  	],
  	[
  		12622,
  		1,
  		"ᄒ"
  	],
  	[
  		12623,
  		1,
  		"ᅡ"
  	],
  	[
  		12624,
  		1,
  		"ᅢ"
  	],
  	[
  		12625,
  		1,
  		"ᅣ"
  	],
  	[
  		12626,
  		1,
  		"ᅤ"
  	],
  	[
  		12627,
  		1,
  		"ᅥ"
  	],
  	[
  		12628,
  		1,
  		"ᅦ"
  	],
  	[
  		12629,
  		1,
  		"ᅧ"
  	],
  	[
  		12630,
  		1,
  		"ᅨ"
  	],
  	[
  		12631,
  		1,
  		"ᅩ"
  	],
  	[
  		12632,
  		1,
  		"ᅪ"
  	],
  	[
  		12633,
  		1,
  		"ᅫ"
  	],
  	[
  		12634,
  		1,
  		"ᅬ"
  	],
  	[
  		12635,
  		1,
  		"ᅭ"
  	],
  	[
  		12636,
  		1,
  		"ᅮ"
  	],
  	[
  		12637,
  		1,
  		"ᅯ"
  	],
  	[
  		12638,
  		1,
  		"ᅰ"
  	],
  	[
  		12639,
  		1,
  		"ᅱ"
  	],
  	[
  		12640,
  		1,
  		"ᅲ"
  	],
  	[
  		12641,
  		1,
  		"ᅳ"
  	],
  	[
  		12642,
  		1,
  		"ᅴ"
  	],
  	[
  		12643,
  		1,
  		"ᅵ"
  	],
  	[
  		12644,
  		3
  	],
  	[
  		12645,
  		1,
  		"ᄔ"
  	],
  	[
  		12646,
  		1,
  		"ᄕ"
  	],
  	[
  		12647,
  		1,
  		"ᇇ"
  	],
  	[
  		12648,
  		1,
  		"ᇈ"
  	],
  	[
  		12649,
  		1,
  		"ᇌ"
  	],
  	[
  		12650,
  		1,
  		"ᇎ"
  	],
  	[
  		12651,
  		1,
  		"ᇓ"
  	],
  	[
  		12652,
  		1,
  		"ᇗ"
  	],
  	[
  		12653,
  		1,
  		"ᇙ"
  	],
  	[
  		12654,
  		1,
  		"ᄜ"
  	],
  	[
  		12655,
  		1,
  		"ᇝ"
  	],
  	[
  		12656,
  		1,
  		"ᇟ"
  	],
  	[
  		12657,
  		1,
  		"ᄝ"
  	],
  	[
  		12658,
  		1,
  		"ᄞ"
  	],
  	[
  		12659,
  		1,
  		"ᄠ"
  	],
  	[
  		12660,
  		1,
  		"ᄢ"
  	],
  	[
  		12661,
  		1,
  		"ᄣ"
  	],
  	[
  		12662,
  		1,
  		"ᄧ"
  	],
  	[
  		12663,
  		1,
  		"ᄩ"
  	],
  	[
  		12664,
  		1,
  		"ᄫ"
  	],
  	[
  		12665,
  		1,
  		"ᄬ"
  	],
  	[
  		12666,
  		1,
  		"ᄭ"
  	],
  	[
  		12667,
  		1,
  		"ᄮ"
  	],
  	[
  		12668,
  		1,
  		"ᄯ"
  	],
  	[
  		12669,
  		1,
  		"ᄲ"
  	],
  	[
  		12670,
  		1,
  		"ᄶ"
  	],
  	[
  		12671,
  		1,
  		"ᅀ"
  	],
  	[
  		12672,
  		1,
  		"ᅇ"
  	],
  	[
  		12673,
  		1,
  		"ᅌ"
  	],
  	[
  		12674,
  		1,
  		"ᇱ"
  	],
  	[
  		12675,
  		1,
  		"ᇲ"
  	],
  	[
  		12676,
  		1,
  		"ᅗ"
  	],
  	[
  		12677,
  		1,
  		"ᅘ"
  	],
  	[
  		12678,
  		1,
  		"ᅙ"
  	],
  	[
  		12679,
  		1,
  		"ᆄ"
  	],
  	[
  		12680,
  		1,
  		"ᆅ"
  	],
  	[
  		12681,
  		1,
  		"ᆈ"
  	],
  	[
  		12682,
  		1,
  		"ᆑ"
  	],
  	[
  		12683,
  		1,
  		"ᆒ"
  	],
  	[
  		12684,
  		1,
  		"ᆔ"
  	],
  	[
  		12685,
  		1,
  		"ᆞ"
  	],
  	[
  		12686,
  		1,
  		"ᆡ"
  	],
  	[
  		12687,
  		3
  	],
  	[
  		[
  			12688,
  			12689
  		],
  		2
  	],
  	[
  		12690,
  		1,
  		"一"
  	],
  	[
  		12691,
  		1,
  		"二"
  	],
  	[
  		12692,
  		1,
  		"三"
  	],
  	[
  		12693,
  		1,
  		"四"
  	],
  	[
  		12694,
  		1,
  		"上"
  	],
  	[
  		12695,
  		1,
  		"中"
  	],
  	[
  		12696,
  		1,
  		"下"
  	],
  	[
  		12697,
  		1,
  		"甲"
  	],
  	[
  		12698,
  		1,
  		"乙"
  	],
  	[
  		12699,
  		1,
  		"丙"
  	],
  	[
  		12700,
  		1,
  		"丁"
  	],
  	[
  		12701,
  		1,
  		"天"
  	],
  	[
  		12702,
  		1,
  		"地"
  	],
  	[
  		12703,
  		1,
  		"人"
  	],
  	[
  		[
  			12704,
  			12727
  		],
  		2
  	],
  	[
  		[
  			12728,
  			12730
  		],
  		2
  	],
  	[
  		[
  			12731,
  			12735
  		],
  		2
  	],
  	[
  		[
  			12736,
  			12751
  		],
  		2
  	],
  	[
  		[
  			12752,
  			12771
  		],
  		2
  	],
  	[
  		[
  			12772,
  			12783
  		],
  		3
  	],
  	[
  		[
  			12784,
  			12799
  		],
  		2
  	],
  	[
  		12800,
  		5,
  		"(ᄀ)"
  	],
  	[
  		12801,
  		5,
  		"(ᄂ)"
  	],
  	[
  		12802,
  		5,
  		"(ᄃ)"
  	],
  	[
  		12803,
  		5,
  		"(ᄅ)"
  	],
  	[
  		12804,
  		5,
  		"(ᄆ)"
  	],
  	[
  		12805,
  		5,
  		"(ᄇ)"
  	],
  	[
  		12806,
  		5,
  		"(ᄉ)"
  	],
  	[
  		12807,
  		5,
  		"(ᄋ)"
  	],
  	[
  		12808,
  		5,
  		"(ᄌ)"
  	],
  	[
  		12809,
  		5,
  		"(ᄎ)"
  	],
  	[
  		12810,
  		5,
  		"(ᄏ)"
  	],
  	[
  		12811,
  		5,
  		"(ᄐ)"
  	],
  	[
  		12812,
  		5,
  		"(ᄑ)"
  	],
  	[
  		12813,
  		5,
  		"(ᄒ)"
  	],
  	[
  		12814,
  		5,
  		"(가)"
  	],
  	[
  		12815,
  		5,
  		"(나)"
  	],
  	[
  		12816,
  		5,
  		"(다)"
  	],
  	[
  		12817,
  		5,
  		"(라)"
  	],
  	[
  		12818,
  		5,
  		"(마)"
  	],
  	[
  		12819,
  		5,
  		"(바)"
  	],
  	[
  		12820,
  		5,
  		"(사)"
  	],
  	[
  		12821,
  		5,
  		"(아)"
  	],
  	[
  		12822,
  		5,
  		"(자)"
  	],
  	[
  		12823,
  		5,
  		"(차)"
  	],
  	[
  		12824,
  		5,
  		"(카)"
  	],
  	[
  		12825,
  		5,
  		"(타)"
  	],
  	[
  		12826,
  		5,
  		"(파)"
  	],
  	[
  		12827,
  		5,
  		"(하)"
  	],
  	[
  		12828,
  		5,
  		"(주)"
  	],
  	[
  		12829,
  		5,
  		"(오전)"
  	],
  	[
  		12830,
  		5,
  		"(오후)"
  	],
  	[
  		12831,
  		3
  	],
  	[
  		12832,
  		5,
  		"(一)"
  	],
  	[
  		12833,
  		5,
  		"(二)"
  	],
  	[
  		12834,
  		5,
  		"(三)"
  	],
  	[
  		12835,
  		5,
  		"(四)"
  	],
  	[
  		12836,
  		5,
  		"(五)"
  	],
  	[
  		12837,
  		5,
  		"(六)"
  	],
  	[
  		12838,
  		5,
  		"(七)"
  	],
  	[
  		12839,
  		5,
  		"(八)"
  	],
  	[
  		12840,
  		5,
  		"(九)"
  	],
  	[
  		12841,
  		5,
  		"(十)"
  	],
  	[
  		12842,
  		5,
  		"(月)"
  	],
  	[
  		12843,
  		5,
  		"(火)"
  	],
  	[
  		12844,
  		5,
  		"(水)"
  	],
  	[
  		12845,
  		5,
  		"(木)"
  	],
  	[
  		12846,
  		5,
  		"(金)"
  	],
  	[
  		12847,
  		5,
  		"(土)"
  	],
  	[
  		12848,
  		5,
  		"(日)"
  	],
  	[
  		12849,
  		5,
  		"(株)"
  	],
  	[
  		12850,
  		5,
  		"(有)"
  	],
  	[
  		12851,
  		5,
  		"(社)"
  	],
  	[
  		12852,
  		5,
  		"(名)"
  	],
  	[
  		12853,
  		5,
  		"(特)"
  	],
  	[
  		12854,
  		5,
  		"(財)"
  	],
  	[
  		12855,
  		5,
  		"(祝)"
  	],
  	[
  		12856,
  		5,
  		"(労)"
  	],
  	[
  		12857,
  		5,
  		"(代)"
  	],
  	[
  		12858,
  		5,
  		"(呼)"
  	],
  	[
  		12859,
  		5,
  		"(学)"
  	],
  	[
  		12860,
  		5,
  		"(監)"
  	],
  	[
  		12861,
  		5,
  		"(企)"
  	],
  	[
  		12862,
  		5,
  		"(資)"
  	],
  	[
  		12863,
  		5,
  		"(協)"
  	],
  	[
  		12864,
  		5,
  		"(祭)"
  	],
  	[
  		12865,
  		5,
  		"(休)"
  	],
  	[
  		12866,
  		5,
  		"(自)"
  	],
  	[
  		12867,
  		5,
  		"(至)"
  	],
  	[
  		12868,
  		1,
  		"問"
  	],
  	[
  		12869,
  		1,
  		"幼"
  	],
  	[
  		12870,
  		1,
  		"文"
  	],
  	[
  		12871,
  		1,
  		"箏"
  	],
  	[
  		[
  			12872,
  			12879
  		],
  		2
  	],
  	[
  		12880,
  		1,
  		"pte"
  	],
  	[
  		12881,
  		1,
  		"21"
  	],
  	[
  		12882,
  		1,
  		"22"
  	],
  	[
  		12883,
  		1,
  		"23"
  	],
  	[
  		12884,
  		1,
  		"24"
  	],
  	[
  		12885,
  		1,
  		"25"
  	],
  	[
  		12886,
  		1,
  		"26"
  	],
  	[
  		12887,
  		1,
  		"27"
  	],
  	[
  		12888,
  		1,
  		"28"
  	],
  	[
  		12889,
  		1,
  		"29"
  	],
  	[
  		12890,
  		1,
  		"30"
  	],
  	[
  		12891,
  		1,
  		"31"
  	],
  	[
  		12892,
  		1,
  		"32"
  	],
  	[
  		12893,
  		1,
  		"33"
  	],
  	[
  		12894,
  		1,
  		"34"
  	],
  	[
  		12895,
  		1,
  		"35"
  	],
  	[
  		12896,
  		1,
  		"ᄀ"
  	],
  	[
  		12897,
  		1,
  		"ᄂ"
  	],
  	[
  		12898,
  		1,
  		"ᄃ"
  	],
  	[
  		12899,
  		1,
  		"ᄅ"
  	],
  	[
  		12900,
  		1,
  		"ᄆ"
  	],
  	[
  		12901,
  		1,
  		"ᄇ"
  	],
  	[
  		12902,
  		1,
  		"ᄉ"
  	],
  	[
  		12903,
  		1,
  		"ᄋ"
  	],
  	[
  		12904,
  		1,
  		"ᄌ"
  	],
  	[
  		12905,
  		1,
  		"ᄎ"
  	],
  	[
  		12906,
  		1,
  		"ᄏ"
  	],
  	[
  		12907,
  		1,
  		"ᄐ"
  	],
  	[
  		12908,
  		1,
  		"ᄑ"
  	],
  	[
  		12909,
  		1,
  		"ᄒ"
  	],
  	[
  		12910,
  		1,
  		"가"
  	],
  	[
  		12911,
  		1,
  		"나"
  	],
  	[
  		12912,
  		1,
  		"다"
  	],
  	[
  		12913,
  		1,
  		"라"
  	],
  	[
  		12914,
  		1,
  		"마"
  	],
  	[
  		12915,
  		1,
  		"바"
  	],
  	[
  		12916,
  		1,
  		"사"
  	],
  	[
  		12917,
  		1,
  		"아"
  	],
  	[
  		12918,
  		1,
  		"자"
  	],
  	[
  		12919,
  		1,
  		"차"
  	],
  	[
  		12920,
  		1,
  		"카"
  	],
  	[
  		12921,
  		1,
  		"타"
  	],
  	[
  		12922,
  		1,
  		"파"
  	],
  	[
  		12923,
  		1,
  		"하"
  	],
  	[
  		12924,
  		1,
  		"참고"
  	],
  	[
  		12925,
  		1,
  		"주의"
  	],
  	[
  		12926,
  		1,
  		"우"
  	],
  	[
  		12927,
  		2
  	],
  	[
  		12928,
  		1,
  		"一"
  	],
  	[
  		12929,
  		1,
  		"二"
  	],
  	[
  		12930,
  		1,
  		"三"
  	],
  	[
  		12931,
  		1,
  		"四"
  	],
  	[
  		12932,
  		1,
  		"五"
  	],
  	[
  		12933,
  		1,
  		"六"
  	],
  	[
  		12934,
  		1,
  		"七"
  	],
  	[
  		12935,
  		1,
  		"八"
  	],
  	[
  		12936,
  		1,
  		"九"
  	],
  	[
  		12937,
  		1,
  		"十"
  	],
  	[
  		12938,
  		1,
  		"月"
  	],
  	[
  		12939,
  		1,
  		"火"
  	],
  	[
  		12940,
  		1,
  		"水"
  	],
  	[
  		12941,
  		1,
  		"木"
  	],
  	[
  		12942,
  		1,
  		"金"
  	],
  	[
  		12943,
  		1,
  		"土"
  	],
  	[
  		12944,
  		1,
  		"日"
  	],
  	[
  		12945,
  		1,
  		"株"
  	],
  	[
  		12946,
  		1,
  		"有"
  	],
  	[
  		12947,
  		1,
  		"社"
  	],
  	[
  		12948,
  		1,
  		"名"
  	],
  	[
  		12949,
  		1,
  		"特"
  	],
  	[
  		12950,
  		1,
  		"財"
  	],
  	[
  		12951,
  		1,
  		"祝"
  	],
  	[
  		12952,
  		1,
  		"労"
  	],
  	[
  		12953,
  		1,
  		"秘"
  	],
  	[
  		12954,
  		1,
  		"男"
  	],
  	[
  		12955,
  		1,
  		"女"
  	],
  	[
  		12956,
  		1,
  		"適"
  	],
  	[
  		12957,
  		1,
  		"優"
  	],
  	[
  		12958,
  		1,
  		"印"
  	],
  	[
  		12959,
  		1,
  		"注"
  	],
  	[
  		12960,
  		1,
  		"項"
  	],
  	[
  		12961,
  		1,
  		"休"
  	],
  	[
  		12962,
  		1,
  		"写"
  	],
  	[
  		12963,
  		1,
  		"正"
  	],
  	[
  		12964,
  		1,
  		"上"
  	],
  	[
  		12965,
  		1,
  		"中"
  	],
  	[
  		12966,
  		1,
  		"下"
  	],
  	[
  		12967,
  		1,
  		"左"
  	],
  	[
  		12968,
  		1,
  		"右"
  	],
  	[
  		12969,
  		1,
  		"医"
  	],
  	[
  		12970,
  		1,
  		"宗"
  	],
  	[
  		12971,
  		1,
  		"学"
  	],
  	[
  		12972,
  		1,
  		"監"
  	],
  	[
  		12973,
  		1,
  		"企"
  	],
  	[
  		12974,
  		1,
  		"資"
  	],
  	[
  		12975,
  		1,
  		"協"
  	],
  	[
  		12976,
  		1,
  		"夜"
  	],
  	[
  		12977,
  		1,
  		"36"
  	],
  	[
  		12978,
  		1,
  		"37"
  	],
  	[
  		12979,
  		1,
  		"38"
  	],
  	[
  		12980,
  		1,
  		"39"
  	],
  	[
  		12981,
  		1,
  		"40"
  	],
  	[
  		12982,
  		1,
  		"41"
  	],
  	[
  		12983,
  		1,
  		"42"
  	],
  	[
  		12984,
  		1,
  		"43"
  	],
  	[
  		12985,
  		1,
  		"44"
  	],
  	[
  		12986,
  		1,
  		"45"
  	],
  	[
  		12987,
  		1,
  		"46"
  	],
  	[
  		12988,
  		1,
  		"47"
  	],
  	[
  		12989,
  		1,
  		"48"
  	],
  	[
  		12990,
  		1,
  		"49"
  	],
  	[
  		12991,
  		1,
  		"50"
  	],
  	[
  		12992,
  		1,
  		"1月"
  	],
  	[
  		12993,
  		1,
  		"2月"
  	],
  	[
  		12994,
  		1,
  		"3月"
  	],
  	[
  		12995,
  		1,
  		"4月"
  	],
  	[
  		12996,
  		1,
  		"5月"
  	],
  	[
  		12997,
  		1,
  		"6月"
  	],
  	[
  		12998,
  		1,
  		"7月"
  	],
  	[
  		12999,
  		1,
  		"8月"
  	],
  	[
  		13000,
  		1,
  		"9月"
  	],
  	[
  		13001,
  		1,
  		"10月"
  	],
  	[
  		13002,
  		1,
  		"11月"
  	],
  	[
  		13003,
  		1,
  		"12月"
  	],
  	[
  		13004,
  		1,
  		"hg"
  	],
  	[
  		13005,
  		1,
  		"erg"
  	],
  	[
  		13006,
  		1,
  		"ev"
  	],
  	[
  		13007,
  		1,
  		"ltd"
  	],
  	[
  		13008,
  		1,
  		"ア"
  	],
  	[
  		13009,
  		1,
  		"イ"
  	],
  	[
  		13010,
  		1,
  		"ウ"
  	],
  	[
  		13011,
  		1,
  		"エ"
  	],
  	[
  		13012,
  		1,
  		"オ"
  	],
  	[
  		13013,
  		1,
  		"カ"
  	],
  	[
  		13014,
  		1,
  		"キ"
  	],
  	[
  		13015,
  		1,
  		"ク"
  	],
  	[
  		13016,
  		1,
  		"ケ"
  	],
  	[
  		13017,
  		1,
  		"コ"
  	],
  	[
  		13018,
  		1,
  		"サ"
  	],
  	[
  		13019,
  		1,
  		"シ"
  	],
  	[
  		13020,
  		1,
  		"ス"
  	],
  	[
  		13021,
  		1,
  		"セ"
  	],
  	[
  		13022,
  		1,
  		"ソ"
  	],
  	[
  		13023,
  		1,
  		"タ"
  	],
  	[
  		13024,
  		1,
  		"チ"
  	],
  	[
  		13025,
  		1,
  		"ツ"
  	],
  	[
  		13026,
  		1,
  		"テ"
  	],
  	[
  		13027,
  		1,
  		"ト"
  	],
  	[
  		13028,
  		1,
  		"ナ"
  	],
  	[
  		13029,
  		1,
  		"ニ"
  	],
  	[
  		13030,
  		1,
  		"ヌ"
  	],
  	[
  		13031,
  		1,
  		"ネ"
  	],
  	[
  		13032,
  		1,
  		"ノ"
  	],
  	[
  		13033,
  		1,
  		"ハ"
  	],
  	[
  		13034,
  		1,
  		"ヒ"
  	],
  	[
  		13035,
  		1,
  		"フ"
  	],
  	[
  		13036,
  		1,
  		"ヘ"
  	],
  	[
  		13037,
  		1,
  		"ホ"
  	],
  	[
  		13038,
  		1,
  		"マ"
  	],
  	[
  		13039,
  		1,
  		"ミ"
  	],
  	[
  		13040,
  		1,
  		"ム"
  	],
  	[
  		13041,
  		1,
  		"メ"
  	],
  	[
  		13042,
  		1,
  		"モ"
  	],
  	[
  		13043,
  		1,
  		"ヤ"
  	],
  	[
  		13044,
  		1,
  		"ユ"
  	],
  	[
  		13045,
  		1,
  		"ヨ"
  	],
  	[
  		13046,
  		1,
  		"ラ"
  	],
  	[
  		13047,
  		1,
  		"リ"
  	],
  	[
  		13048,
  		1,
  		"ル"
  	],
  	[
  		13049,
  		1,
  		"レ"
  	],
  	[
  		13050,
  		1,
  		"ロ"
  	],
  	[
  		13051,
  		1,
  		"ワ"
  	],
  	[
  		13052,
  		1,
  		"ヰ"
  	],
  	[
  		13053,
  		1,
  		"ヱ"
  	],
  	[
  		13054,
  		1,
  		"ヲ"
  	],
  	[
  		13055,
  		1,
  		"令和"
  	],
  	[
  		13056,
  		1,
  		"アパート"
  	],
  	[
  		13057,
  		1,
  		"アルファ"
  	],
  	[
  		13058,
  		1,
  		"アンペア"
  	],
  	[
  		13059,
  		1,
  		"アール"
  	],
  	[
  		13060,
  		1,
  		"イニング"
  	],
  	[
  		13061,
  		1,
  		"インチ"
  	],
  	[
  		13062,
  		1,
  		"ウォン"
  	],
  	[
  		13063,
  		1,
  		"エスクード"
  	],
  	[
  		13064,
  		1,
  		"エーカー"
  	],
  	[
  		13065,
  		1,
  		"オンス"
  	],
  	[
  		13066,
  		1,
  		"オーム"
  	],
  	[
  		13067,
  		1,
  		"カイリ"
  	],
  	[
  		13068,
  		1,
  		"カラット"
  	],
  	[
  		13069,
  		1,
  		"カロリー"
  	],
  	[
  		13070,
  		1,
  		"ガロン"
  	],
  	[
  		13071,
  		1,
  		"ガンマ"
  	],
  	[
  		13072,
  		1,
  		"ギガ"
  	],
  	[
  		13073,
  		1,
  		"ギニー"
  	],
  	[
  		13074,
  		1,
  		"キュリー"
  	],
  	[
  		13075,
  		1,
  		"ギルダー"
  	],
  	[
  		13076,
  		1,
  		"キロ"
  	],
  	[
  		13077,
  		1,
  		"キログラム"
  	],
  	[
  		13078,
  		1,
  		"キロメートル"
  	],
  	[
  		13079,
  		1,
  		"キロワット"
  	],
  	[
  		13080,
  		1,
  		"グラム"
  	],
  	[
  		13081,
  		1,
  		"グラムトン"
  	],
  	[
  		13082,
  		1,
  		"クルゼイロ"
  	],
  	[
  		13083,
  		1,
  		"クローネ"
  	],
  	[
  		13084,
  		1,
  		"ケース"
  	],
  	[
  		13085,
  		1,
  		"コルナ"
  	],
  	[
  		13086,
  		1,
  		"コーポ"
  	],
  	[
  		13087,
  		1,
  		"サイクル"
  	],
  	[
  		13088,
  		1,
  		"サンチーム"
  	],
  	[
  		13089,
  		1,
  		"シリング"
  	],
  	[
  		13090,
  		1,
  		"センチ"
  	],
  	[
  		13091,
  		1,
  		"セント"
  	],
  	[
  		13092,
  		1,
  		"ダース"
  	],
  	[
  		13093,
  		1,
  		"デシ"
  	],
  	[
  		13094,
  		1,
  		"ドル"
  	],
  	[
  		13095,
  		1,
  		"トン"
  	],
  	[
  		13096,
  		1,
  		"ナノ"
  	],
  	[
  		13097,
  		1,
  		"ノット"
  	],
  	[
  		13098,
  		1,
  		"ハイツ"
  	],
  	[
  		13099,
  		1,
  		"パーセント"
  	],
  	[
  		13100,
  		1,
  		"パーツ"
  	],
  	[
  		13101,
  		1,
  		"バーレル"
  	],
  	[
  		13102,
  		1,
  		"ピアストル"
  	],
  	[
  		13103,
  		1,
  		"ピクル"
  	],
  	[
  		13104,
  		1,
  		"ピコ"
  	],
  	[
  		13105,
  		1,
  		"ビル"
  	],
  	[
  		13106,
  		1,
  		"ファラッド"
  	],
  	[
  		13107,
  		1,
  		"フィート"
  	],
  	[
  		13108,
  		1,
  		"ブッシェル"
  	],
  	[
  		13109,
  		1,
  		"フラン"
  	],
  	[
  		13110,
  		1,
  		"ヘクタール"
  	],
  	[
  		13111,
  		1,
  		"ペソ"
  	],
  	[
  		13112,
  		1,
  		"ペニヒ"
  	],
  	[
  		13113,
  		1,
  		"ヘルツ"
  	],
  	[
  		13114,
  		1,
  		"ペンス"
  	],
  	[
  		13115,
  		1,
  		"ページ"
  	],
  	[
  		13116,
  		1,
  		"ベータ"
  	],
  	[
  		13117,
  		1,
  		"ポイント"
  	],
  	[
  		13118,
  		1,
  		"ボルト"
  	],
  	[
  		13119,
  		1,
  		"ホン"
  	],
  	[
  		13120,
  		1,
  		"ポンド"
  	],
  	[
  		13121,
  		1,
  		"ホール"
  	],
  	[
  		13122,
  		1,
  		"ホーン"
  	],
  	[
  		13123,
  		1,
  		"マイクロ"
  	],
  	[
  		13124,
  		1,
  		"マイル"
  	],
  	[
  		13125,
  		1,
  		"マッハ"
  	],
  	[
  		13126,
  		1,
  		"マルク"
  	],
  	[
  		13127,
  		1,
  		"マンション"
  	],
  	[
  		13128,
  		1,
  		"ミクロン"
  	],
  	[
  		13129,
  		1,
  		"ミリ"
  	],
  	[
  		13130,
  		1,
  		"ミリバール"
  	],
  	[
  		13131,
  		1,
  		"メガ"
  	],
  	[
  		13132,
  		1,
  		"メガトン"
  	],
  	[
  		13133,
  		1,
  		"メートル"
  	],
  	[
  		13134,
  		1,
  		"ヤード"
  	],
  	[
  		13135,
  		1,
  		"ヤール"
  	],
  	[
  		13136,
  		1,
  		"ユアン"
  	],
  	[
  		13137,
  		1,
  		"リットル"
  	],
  	[
  		13138,
  		1,
  		"リラ"
  	],
  	[
  		13139,
  		1,
  		"ルピー"
  	],
  	[
  		13140,
  		1,
  		"ルーブル"
  	],
  	[
  		13141,
  		1,
  		"レム"
  	],
  	[
  		13142,
  		1,
  		"レントゲン"
  	],
  	[
  		13143,
  		1,
  		"ワット"
  	],
  	[
  		13144,
  		1,
  		"0点"
  	],
  	[
  		13145,
  		1,
  		"1点"
  	],
  	[
  		13146,
  		1,
  		"2点"
  	],
  	[
  		13147,
  		1,
  		"3点"
  	],
  	[
  		13148,
  		1,
  		"4点"
  	],
  	[
  		13149,
  		1,
  		"5点"
  	],
  	[
  		13150,
  		1,
  		"6点"
  	],
  	[
  		13151,
  		1,
  		"7点"
  	],
  	[
  		13152,
  		1,
  		"8点"
  	],
  	[
  		13153,
  		1,
  		"9点"
  	],
  	[
  		13154,
  		1,
  		"10点"
  	],
  	[
  		13155,
  		1,
  		"11点"
  	],
  	[
  		13156,
  		1,
  		"12点"
  	],
  	[
  		13157,
  		1,
  		"13点"
  	],
  	[
  		13158,
  		1,
  		"14点"
  	],
  	[
  		13159,
  		1,
  		"15点"
  	],
  	[
  		13160,
  		1,
  		"16点"
  	],
  	[
  		13161,
  		1,
  		"17点"
  	],
  	[
  		13162,
  		1,
  		"18点"
  	],
  	[
  		13163,
  		1,
  		"19点"
  	],
  	[
  		13164,
  		1,
  		"20点"
  	],
  	[
  		13165,
  		1,
  		"21点"
  	],
  	[
  		13166,
  		1,
  		"22点"
  	],
  	[
  		13167,
  		1,
  		"23点"
  	],
  	[
  		13168,
  		1,
  		"24点"
  	],
  	[
  		13169,
  		1,
  		"hpa"
  	],
  	[
  		13170,
  		1,
  		"da"
  	],
  	[
  		13171,
  		1,
  		"au"
  	],
  	[
  		13172,
  		1,
  		"bar"
  	],
  	[
  		13173,
  		1,
  		"ov"
  	],
  	[
  		13174,
  		1,
  		"pc"
  	],
  	[
  		13175,
  		1,
  		"dm"
  	],
  	[
  		13176,
  		1,
  		"dm2"
  	],
  	[
  		13177,
  		1,
  		"dm3"
  	],
  	[
  		13178,
  		1,
  		"iu"
  	],
  	[
  		13179,
  		1,
  		"平成"
  	],
  	[
  		13180,
  		1,
  		"昭和"
  	],
  	[
  		13181,
  		1,
  		"大正"
  	],
  	[
  		13182,
  		1,
  		"明治"
  	],
  	[
  		13183,
  		1,
  		"株式会社"
  	],
  	[
  		13184,
  		1,
  		"pa"
  	],
  	[
  		13185,
  		1,
  		"na"
  	],
  	[
  		13186,
  		1,
  		"μa"
  	],
  	[
  		13187,
  		1,
  		"ma"
  	],
  	[
  		13188,
  		1,
  		"ka"
  	],
  	[
  		13189,
  		1,
  		"kb"
  	],
  	[
  		13190,
  		1,
  		"mb"
  	],
  	[
  		13191,
  		1,
  		"gb"
  	],
  	[
  		13192,
  		1,
  		"cal"
  	],
  	[
  		13193,
  		1,
  		"kcal"
  	],
  	[
  		13194,
  		1,
  		"pf"
  	],
  	[
  		13195,
  		1,
  		"nf"
  	],
  	[
  		13196,
  		1,
  		"μf"
  	],
  	[
  		13197,
  		1,
  		"μg"
  	],
  	[
  		13198,
  		1,
  		"mg"
  	],
  	[
  		13199,
  		1,
  		"kg"
  	],
  	[
  		13200,
  		1,
  		"hz"
  	],
  	[
  		13201,
  		1,
  		"khz"
  	],
  	[
  		13202,
  		1,
  		"mhz"
  	],
  	[
  		13203,
  		1,
  		"ghz"
  	],
  	[
  		13204,
  		1,
  		"thz"
  	],
  	[
  		13205,
  		1,
  		"μl"
  	],
  	[
  		13206,
  		1,
  		"ml"
  	],
  	[
  		13207,
  		1,
  		"dl"
  	],
  	[
  		13208,
  		1,
  		"kl"
  	],
  	[
  		13209,
  		1,
  		"fm"
  	],
  	[
  		13210,
  		1,
  		"nm"
  	],
  	[
  		13211,
  		1,
  		"μm"
  	],
  	[
  		13212,
  		1,
  		"mm"
  	],
  	[
  		13213,
  		1,
  		"cm"
  	],
  	[
  		13214,
  		1,
  		"km"
  	],
  	[
  		13215,
  		1,
  		"mm2"
  	],
  	[
  		13216,
  		1,
  		"cm2"
  	],
  	[
  		13217,
  		1,
  		"m2"
  	],
  	[
  		13218,
  		1,
  		"km2"
  	],
  	[
  		13219,
  		1,
  		"mm3"
  	],
  	[
  		13220,
  		1,
  		"cm3"
  	],
  	[
  		13221,
  		1,
  		"m3"
  	],
  	[
  		13222,
  		1,
  		"km3"
  	],
  	[
  		13223,
  		1,
  		"m∕s"
  	],
  	[
  		13224,
  		1,
  		"m∕s2"
  	],
  	[
  		13225,
  		1,
  		"pa"
  	],
  	[
  		13226,
  		1,
  		"kpa"
  	],
  	[
  		13227,
  		1,
  		"mpa"
  	],
  	[
  		13228,
  		1,
  		"gpa"
  	],
  	[
  		13229,
  		1,
  		"rad"
  	],
  	[
  		13230,
  		1,
  		"rad∕s"
  	],
  	[
  		13231,
  		1,
  		"rad∕s2"
  	],
  	[
  		13232,
  		1,
  		"ps"
  	],
  	[
  		13233,
  		1,
  		"ns"
  	],
  	[
  		13234,
  		1,
  		"μs"
  	],
  	[
  		13235,
  		1,
  		"ms"
  	],
  	[
  		13236,
  		1,
  		"pv"
  	],
  	[
  		13237,
  		1,
  		"nv"
  	],
  	[
  		13238,
  		1,
  		"μv"
  	],
  	[
  		13239,
  		1,
  		"mv"
  	],
  	[
  		13240,
  		1,
  		"kv"
  	],
  	[
  		13241,
  		1,
  		"mv"
  	],
  	[
  		13242,
  		1,
  		"pw"
  	],
  	[
  		13243,
  		1,
  		"nw"
  	],
  	[
  		13244,
  		1,
  		"μw"
  	],
  	[
  		13245,
  		1,
  		"mw"
  	],
  	[
  		13246,
  		1,
  		"kw"
  	],
  	[
  		13247,
  		1,
  		"mw"
  	],
  	[
  		13248,
  		1,
  		"kω"
  	],
  	[
  		13249,
  		1,
  		"mω"
  	],
  	[
  		13250,
  		3
  	],
  	[
  		13251,
  		1,
  		"bq"
  	],
  	[
  		13252,
  		1,
  		"cc"
  	],
  	[
  		13253,
  		1,
  		"cd"
  	],
  	[
  		13254,
  		1,
  		"c∕kg"
  	],
  	[
  		13255,
  		3
  	],
  	[
  		13256,
  		1,
  		"db"
  	],
  	[
  		13257,
  		1,
  		"gy"
  	],
  	[
  		13258,
  		1,
  		"ha"
  	],
  	[
  		13259,
  		1,
  		"hp"
  	],
  	[
  		13260,
  		1,
  		"in"
  	],
  	[
  		13261,
  		1,
  		"kk"
  	],
  	[
  		13262,
  		1,
  		"km"
  	],
  	[
  		13263,
  		1,
  		"kt"
  	],
  	[
  		13264,
  		1,
  		"lm"
  	],
  	[
  		13265,
  		1,
  		"ln"
  	],
  	[
  		13266,
  		1,
  		"log"
  	],
  	[
  		13267,
  		1,
  		"lx"
  	],
  	[
  		13268,
  		1,
  		"mb"
  	],
  	[
  		13269,
  		1,
  		"mil"
  	],
  	[
  		13270,
  		1,
  		"mol"
  	],
  	[
  		13271,
  		1,
  		"ph"
  	],
  	[
  		13272,
  		3
  	],
  	[
  		13273,
  		1,
  		"ppm"
  	],
  	[
  		13274,
  		1,
  		"pr"
  	],
  	[
  		13275,
  		1,
  		"sr"
  	],
  	[
  		13276,
  		1,
  		"sv"
  	],
  	[
  		13277,
  		1,
  		"wb"
  	],
  	[
  		13278,
  		1,
  		"v∕m"
  	],
  	[
  		13279,
  		1,
  		"a∕m"
  	],
  	[
  		13280,
  		1,
  		"1日"
  	],
  	[
  		13281,
  		1,
  		"2日"
  	],
  	[
  		13282,
  		1,
  		"3日"
  	],
  	[
  		13283,
  		1,
  		"4日"
  	],
  	[
  		13284,
  		1,
  		"5日"
  	],
  	[
  		13285,
  		1,
  		"6日"
  	],
  	[
  		13286,
  		1,
  		"7日"
  	],
  	[
  		13287,
  		1,
  		"8日"
  	],
  	[
  		13288,
  		1,
  		"9日"
  	],
  	[
  		13289,
  		1,
  		"10日"
  	],
  	[
  		13290,
  		1,
  		"11日"
  	],
  	[
  		13291,
  		1,
  		"12日"
  	],
  	[
  		13292,
  		1,
  		"13日"
  	],
  	[
  		13293,
  		1,
  		"14日"
  	],
  	[
  		13294,
  		1,
  		"15日"
  	],
  	[
  		13295,
  		1,
  		"16日"
  	],
  	[
  		13296,
  		1,
  		"17日"
  	],
  	[
  		13297,
  		1,
  		"18日"
  	],
  	[
  		13298,
  		1,
  		"19日"
  	],
  	[
  		13299,
  		1,
  		"20日"
  	],
  	[
  		13300,
  		1,
  		"21日"
  	],
  	[
  		13301,
  		1,
  		"22日"
  	],
  	[
  		13302,
  		1,
  		"23日"
  	],
  	[
  		13303,
  		1,
  		"24日"
  	],
  	[
  		13304,
  		1,
  		"25日"
  	],
  	[
  		13305,
  		1,
  		"26日"
  	],
  	[
  		13306,
  		1,
  		"27日"
  	],
  	[
  		13307,
  		1,
  		"28日"
  	],
  	[
  		13308,
  		1,
  		"29日"
  	],
  	[
  		13309,
  		1,
  		"30日"
  	],
  	[
  		13310,
  		1,
  		"31日"
  	],
  	[
  		13311,
  		1,
  		"gal"
  	],
  	[
  		[
  			13312,
  			19893
  		],
  		2
  	],
  	[
  		[
  			19894,
  			19903
  		],
  		2
  	],
  	[
  		[
  			19904,
  			19967
  		],
  		2
  	],
  	[
  		[
  			19968,
  			40869
  		],
  		2
  	],
  	[
  		[
  			40870,
  			40891
  		],
  		2
  	],
  	[
  		[
  			40892,
  			40899
  		],
  		2
  	],
  	[
  		[
  			40900,
  			40907
  		],
  		2
  	],
  	[
  		40908,
  		2
  	],
  	[
  		[
  			40909,
  			40917
  		],
  		2
  	],
  	[
  		[
  			40918,
  			40938
  		],
  		2
  	],
  	[
  		[
  			40939,
  			40943
  		],
  		2
  	],
  	[
  		[
  			40944,
  			40956
  		],
  		2
  	],
  	[
  		[
  			40957,
  			40959
  		],
  		3
  	],
  	[
  		[
  			40960,
  			42124
  		],
  		2
  	],
  	[
  		[
  			42125,
  			42127
  		],
  		3
  	],
  	[
  		[
  			42128,
  			42145
  		],
  		2
  	],
  	[
  		[
  			42146,
  			42147
  		],
  		2
  	],
  	[
  		[
  			42148,
  			42163
  		],
  		2
  	],
  	[
  		42164,
  		2
  	],
  	[
  		[
  			42165,
  			42176
  		],
  		2
  	],
  	[
  		42177,
  		2
  	],
  	[
  		[
  			42178,
  			42180
  		],
  		2
  	],
  	[
  		42181,
  		2
  	],
  	[
  		42182,
  		2
  	],
  	[
  		[
  			42183,
  			42191
  		],
  		3
  	],
  	[
  		[
  			42192,
  			42237
  		],
  		2
  	],
  	[
  		[
  			42238,
  			42239
  		],
  		2
  	],
  	[
  		[
  			42240,
  			42508
  		],
  		2
  	],
  	[
  		[
  			42509,
  			42511
  		],
  		2
  	],
  	[
  		[
  			42512,
  			42539
  		],
  		2
  	],
  	[
  		[
  			42540,
  			42559
  		],
  		3
  	],
  	[
  		42560,
  		1,
  		"ꙁ"
  	],
  	[
  		42561,
  		2
  	],
  	[
  		42562,
  		1,
  		"ꙃ"
  	],
  	[
  		42563,
  		2
  	],
  	[
  		42564,
  		1,
  		"ꙅ"
  	],
  	[
  		42565,
  		2
  	],
  	[
  		42566,
  		1,
  		"ꙇ"
  	],
  	[
  		42567,
  		2
  	],
  	[
  		42568,
  		1,
  		"ꙉ"
  	],
  	[
  		42569,
  		2
  	],
  	[
  		42570,
  		1,
  		"ꙋ"
  	],
  	[
  		42571,
  		2
  	],
  	[
  		42572,
  		1,
  		"ꙍ"
  	],
  	[
  		42573,
  		2
  	],
  	[
  		42574,
  		1,
  		"ꙏ"
  	],
  	[
  		42575,
  		2
  	],
  	[
  		42576,
  		1,
  		"ꙑ"
  	],
  	[
  		42577,
  		2
  	],
  	[
  		42578,
  		1,
  		"ꙓ"
  	],
  	[
  		42579,
  		2
  	],
  	[
  		42580,
  		1,
  		"ꙕ"
  	],
  	[
  		42581,
  		2
  	],
  	[
  		42582,
  		1,
  		"ꙗ"
  	],
  	[
  		42583,
  		2
  	],
  	[
  		42584,
  		1,
  		"ꙙ"
  	],
  	[
  		42585,
  		2
  	],
  	[
  		42586,
  		1,
  		"ꙛ"
  	],
  	[
  		42587,
  		2
  	],
  	[
  		42588,
  		1,
  		"ꙝ"
  	],
  	[
  		42589,
  		2
  	],
  	[
  		42590,
  		1,
  		"ꙟ"
  	],
  	[
  		42591,
  		2
  	],
  	[
  		42592,
  		1,
  		"ꙡ"
  	],
  	[
  		42593,
  		2
  	],
  	[
  		42594,
  		1,
  		"ꙣ"
  	],
  	[
  		42595,
  		2
  	],
  	[
  		42596,
  		1,
  		"ꙥ"
  	],
  	[
  		42597,
  		2
  	],
  	[
  		42598,
  		1,
  		"ꙧ"
  	],
  	[
  		42599,
  		2
  	],
  	[
  		42600,
  		1,
  		"ꙩ"
  	],
  	[
  		42601,
  		2
  	],
  	[
  		42602,
  		1,
  		"ꙫ"
  	],
  	[
  		42603,
  		2
  	],
  	[
  		42604,
  		1,
  		"ꙭ"
  	],
  	[
  		[
  			42605,
  			42607
  		],
  		2
  	],
  	[
  		[
  			42608,
  			42611
  		],
  		2
  	],
  	[
  		[
  			42612,
  			42619
  		],
  		2
  	],
  	[
  		[
  			42620,
  			42621
  		],
  		2
  	],
  	[
  		42622,
  		2
  	],
  	[
  		42623,
  		2
  	],
  	[
  		42624,
  		1,
  		"ꚁ"
  	],
  	[
  		42625,
  		2
  	],
  	[
  		42626,
  		1,
  		"ꚃ"
  	],
  	[
  		42627,
  		2
  	],
  	[
  		42628,
  		1,
  		"ꚅ"
  	],
  	[
  		42629,
  		2
  	],
  	[
  		42630,
  		1,
  		"ꚇ"
  	],
  	[
  		42631,
  		2
  	],
  	[
  		42632,
  		1,
  		"ꚉ"
  	],
  	[
  		42633,
  		2
  	],
  	[
  		42634,
  		1,
  		"ꚋ"
  	],
  	[
  		42635,
  		2
  	],
  	[
  		42636,
  		1,
  		"ꚍ"
  	],
  	[
  		42637,
  		2
  	],
  	[
  		42638,
  		1,
  		"ꚏ"
  	],
  	[
  		42639,
  		2
  	],
  	[
  		42640,
  		1,
  		"ꚑ"
  	],
  	[
  		42641,
  		2
  	],
  	[
  		42642,
  		1,
  		"ꚓ"
  	],
  	[
  		42643,
  		2
  	],
  	[
  		42644,
  		1,
  		"ꚕ"
  	],
  	[
  		42645,
  		2
  	],
  	[
  		42646,
  		1,
  		"ꚗ"
  	],
  	[
  		42647,
  		2
  	],
  	[
  		42648,
  		1,
  		"ꚙ"
  	],
  	[
  		42649,
  		2
  	],
  	[
  		42650,
  		1,
  		"ꚛ"
  	],
  	[
  		42651,
  		2
  	],
  	[
  		42652,
  		1,
  		"ъ"
  	],
  	[
  		42653,
  		1,
  		"ь"
  	],
  	[
  		42654,
  		2
  	],
  	[
  		42655,
  		2
  	],
  	[
  		[
  			42656,
  			42725
  		],
  		2
  	],
  	[
  		[
  			42726,
  			42735
  		],
  		2
  	],
  	[
  		[
  			42736,
  			42737
  		],
  		2
  	],
  	[
  		[
  			42738,
  			42743
  		],
  		2
  	],
  	[
  		[
  			42744,
  			42751
  		],
  		3
  	],
  	[
  		[
  			42752,
  			42774
  		],
  		2
  	],
  	[
  		[
  			42775,
  			42778
  		],
  		2
  	],
  	[
  		[
  			42779,
  			42783
  		],
  		2
  	],
  	[
  		[
  			42784,
  			42785
  		],
  		2
  	],
  	[
  		42786,
  		1,
  		"ꜣ"
  	],
  	[
  		42787,
  		2
  	],
  	[
  		42788,
  		1,
  		"ꜥ"
  	],
  	[
  		42789,
  		2
  	],
  	[
  		42790,
  		1,
  		"ꜧ"
  	],
  	[
  		42791,
  		2
  	],
  	[
  		42792,
  		1,
  		"ꜩ"
  	],
  	[
  		42793,
  		2
  	],
  	[
  		42794,
  		1,
  		"ꜫ"
  	],
  	[
  		42795,
  		2
  	],
  	[
  		42796,
  		1,
  		"ꜭ"
  	],
  	[
  		42797,
  		2
  	],
  	[
  		42798,
  		1,
  		"ꜯ"
  	],
  	[
  		[
  			42799,
  			42801
  		],
  		2
  	],
  	[
  		42802,
  		1,
  		"ꜳ"
  	],
  	[
  		42803,
  		2
  	],
  	[
  		42804,
  		1,
  		"ꜵ"
  	],
  	[
  		42805,
  		2
  	],
  	[
  		42806,
  		1,
  		"ꜷ"
  	],
  	[
  		42807,
  		2
  	],
  	[
  		42808,
  		1,
  		"ꜹ"
  	],
  	[
  		42809,
  		2
  	],
  	[
  		42810,
  		1,
  		"ꜻ"
  	],
  	[
  		42811,
  		2
  	],
  	[
  		42812,
  		1,
  		"ꜽ"
  	],
  	[
  		42813,
  		2
  	],
  	[
  		42814,
  		1,
  		"ꜿ"
  	],
  	[
  		42815,
  		2
  	],
  	[
  		42816,
  		1,
  		"ꝁ"
  	],
  	[
  		42817,
  		2
  	],
  	[
  		42818,
  		1,
  		"ꝃ"
  	],
  	[
  		42819,
  		2
  	],
  	[
  		42820,
  		1,
  		"ꝅ"
  	],
  	[
  		42821,
  		2
  	],
  	[
  		42822,
  		1,
  		"ꝇ"
  	],
  	[
  		42823,
  		2
  	],
  	[
  		42824,
  		1,
  		"ꝉ"
  	],
  	[
  		42825,
  		2
  	],
  	[
  		42826,
  		1,
  		"ꝋ"
  	],
  	[
  		42827,
  		2
  	],
  	[
  		42828,
  		1,
  		"ꝍ"
  	],
  	[
  		42829,
  		2
  	],
  	[
  		42830,
  		1,
  		"ꝏ"
  	],
  	[
  		42831,
  		2
  	],
  	[
  		42832,
  		1,
  		"ꝑ"
  	],
  	[
  		42833,
  		2
  	],
  	[
  		42834,
  		1,
  		"ꝓ"
  	],
  	[
  		42835,
  		2
  	],
  	[
  		42836,
  		1,
  		"ꝕ"
  	],
  	[
  		42837,
  		2
  	],
  	[
  		42838,
  		1,
  		"ꝗ"
  	],
  	[
  		42839,
  		2
  	],
  	[
  		42840,
  		1,
  		"ꝙ"
  	],
  	[
  		42841,
  		2
  	],
  	[
  		42842,
  		1,
  		"ꝛ"
  	],
  	[
  		42843,
  		2
  	],
  	[
  		42844,
  		1,
  		"ꝝ"
  	],
  	[
  		42845,
  		2
  	],
  	[
  		42846,
  		1,
  		"ꝟ"
  	],
  	[
  		42847,
  		2
  	],
  	[
  		42848,
  		1,
  		"ꝡ"
  	],
  	[
  		42849,
  		2
  	],
  	[
  		42850,
  		1,
  		"ꝣ"
  	],
  	[
  		42851,
  		2
  	],
  	[
  		42852,
  		1,
  		"ꝥ"
  	],
  	[
  		42853,
  		2
  	],
  	[
  		42854,
  		1,
  		"ꝧ"
  	],
  	[
  		42855,
  		2
  	],
  	[
  		42856,
  		1,
  		"ꝩ"
  	],
  	[
  		42857,
  		2
  	],
  	[
  		42858,
  		1,
  		"ꝫ"
  	],
  	[
  		42859,
  		2
  	],
  	[
  		42860,
  		1,
  		"ꝭ"
  	],
  	[
  		42861,
  		2
  	],
  	[
  		42862,
  		1,
  		"ꝯ"
  	],
  	[
  		42863,
  		2
  	],
  	[
  		42864,
  		1,
  		"ꝯ"
  	],
  	[
  		[
  			42865,
  			42872
  		],
  		2
  	],
  	[
  		42873,
  		1,
  		"ꝺ"
  	],
  	[
  		42874,
  		2
  	],
  	[
  		42875,
  		1,
  		"ꝼ"
  	],
  	[
  		42876,
  		2
  	],
  	[
  		42877,
  		1,
  		"ᵹ"
  	],
  	[
  		42878,
  		1,
  		"ꝿ"
  	],
  	[
  		42879,
  		2
  	],
  	[
  		42880,
  		1,
  		"ꞁ"
  	],
  	[
  		42881,
  		2
  	],
  	[
  		42882,
  		1,
  		"ꞃ"
  	],
  	[
  		42883,
  		2
  	],
  	[
  		42884,
  		1,
  		"ꞅ"
  	],
  	[
  		42885,
  		2
  	],
  	[
  		42886,
  		1,
  		"ꞇ"
  	],
  	[
  		[
  			42887,
  			42888
  		],
  		2
  	],
  	[
  		[
  			42889,
  			42890
  		],
  		2
  	],
  	[
  		42891,
  		1,
  		"ꞌ"
  	],
  	[
  		42892,
  		2
  	],
  	[
  		42893,
  		1,
  		"ɥ"
  	],
  	[
  		42894,
  		2
  	],
  	[
  		42895,
  		2
  	],
  	[
  		42896,
  		1,
  		"ꞑ"
  	],
  	[
  		42897,
  		2
  	],
  	[
  		42898,
  		1,
  		"ꞓ"
  	],
  	[
  		42899,
  		2
  	],
  	[
  		[
  			42900,
  			42901
  		],
  		2
  	],
  	[
  		42902,
  		1,
  		"ꞗ"
  	],
  	[
  		42903,
  		2
  	],
  	[
  		42904,
  		1,
  		"ꞙ"
  	],
  	[
  		42905,
  		2
  	],
  	[
  		42906,
  		1,
  		"ꞛ"
  	],
  	[
  		42907,
  		2
  	],
  	[
  		42908,
  		1,
  		"ꞝ"
  	],
  	[
  		42909,
  		2
  	],
  	[
  		42910,
  		1,
  		"ꞟ"
  	],
  	[
  		42911,
  		2
  	],
  	[
  		42912,
  		1,
  		"ꞡ"
  	],
  	[
  		42913,
  		2
  	],
  	[
  		42914,
  		1,
  		"ꞣ"
  	],
  	[
  		42915,
  		2
  	],
  	[
  		42916,
  		1,
  		"ꞥ"
  	],
  	[
  		42917,
  		2
  	],
  	[
  		42918,
  		1,
  		"ꞧ"
  	],
  	[
  		42919,
  		2
  	],
  	[
  		42920,
  		1,
  		"ꞩ"
  	],
  	[
  		42921,
  		2
  	],
  	[
  		42922,
  		1,
  		"ɦ"
  	],
  	[
  		42923,
  		1,
  		"ɜ"
  	],
  	[
  		42924,
  		1,
  		"ɡ"
  	],
  	[
  		42925,
  		1,
  		"ɬ"
  	],
  	[
  		42926,
  		1,
  		"ɪ"
  	],
  	[
  		42927,
  		2
  	],
  	[
  		42928,
  		1,
  		"ʞ"
  	],
  	[
  		42929,
  		1,
  		"ʇ"
  	],
  	[
  		42930,
  		1,
  		"ʝ"
  	],
  	[
  		42931,
  		1,
  		"ꭓ"
  	],
  	[
  		42932,
  		1,
  		"ꞵ"
  	],
  	[
  		42933,
  		2
  	],
  	[
  		42934,
  		1,
  		"ꞷ"
  	],
  	[
  		42935,
  		2
  	],
  	[
  		42936,
  		1,
  		"ꞹ"
  	],
  	[
  		42937,
  		2
  	],
  	[
  		42938,
  		1,
  		"ꞻ"
  	],
  	[
  		42939,
  		2
  	],
  	[
  		42940,
  		1,
  		"ꞽ"
  	],
  	[
  		42941,
  		2
  	],
  	[
  		42942,
  		1,
  		"ꞿ"
  	],
  	[
  		42943,
  		2
  	],
  	[
  		[
  			42944,
  			42945
  		],
  		3
  	],
  	[
  		42946,
  		1,
  		"ꟃ"
  	],
  	[
  		42947,
  		2
  	],
  	[
  		42948,
  		1,
  		"ꞔ"
  	],
  	[
  		42949,
  		1,
  		"ʂ"
  	],
  	[
  		42950,
  		1,
  		"ᶎ"
  	],
  	[
  		42951,
  		1,
  		"ꟈ"
  	],
  	[
  		42952,
  		2
  	],
  	[
  		42953,
  		1,
  		"ꟊ"
  	],
  	[
  		42954,
  		2
  	],
  	[
  		[
  			42955,
  			42996
  		],
  		3
  	],
  	[
  		42997,
  		1,
  		"ꟶ"
  	],
  	[
  		42998,
  		2
  	],
  	[
  		42999,
  		2
  	],
  	[
  		43000,
  		1,
  		"ħ"
  	],
  	[
  		43001,
  		1,
  		"œ"
  	],
  	[
  		43002,
  		2
  	],
  	[
  		[
  			43003,
  			43007
  		],
  		2
  	],
  	[
  		[
  			43008,
  			43047
  		],
  		2
  	],
  	[
  		[
  			43048,
  			43051
  		],
  		2
  	],
  	[
  		43052,
  		2
  	],
  	[
  		[
  			43053,
  			43055
  		],
  		3
  	],
  	[
  		[
  			43056,
  			43065
  		],
  		2
  	],
  	[
  		[
  			43066,
  			43071
  		],
  		3
  	],
  	[
  		[
  			43072,
  			43123
  		],
  		2
  	],
  	[
  		[
  			43124,
  			43127
  		],
  		2
  	],
  	[
  		[
  			43128,
  			43135
  		],
  		3
  	],
  	[
  		[
  			43136,
  			43204
  		],
  		2
  	],
  	[
  		43205,
  		2
  	],
  	[
  		[
  			43206,
  			43213
  		],
  		3
  	],
  	[
  		[
  			43214,
  			43215
  		],
  		2
  	],
  	[
  		[
  			43216,
  			43225
  		],
  		2
  	],
  	[
  		[
  			43226,
  			43231
  		],
  		3
  	],
  	[
  		[
  			43232,
  			43255
  		],
  		2
  	],
  	[
  		[
  			43256,
  			43258
  		],
  		2
  	],
  	[
  		43259,
  		2
  	],
  	[
  		43260,
  		2
  	],
  	[
  		43261,
  		2
  	],
  	[
  		[
  			43262,
  			43263
  		],
  		2
  	],
  	[
  		[
  			43264,
  			43309
  		],
  		2
  	],
  	[
  		[
  			43310,
  			43311
  		],
  		2
  	],
  	[
  		[
  			43312,
  			43347
  		],
  		2
  	],
  	[
  		[
  			43348,
  			43358
  		],
  		3
  	],
  	[
  		43359,
  		2
  	],
  	[
  		[
  			43360,
  			43388
  		],
  		2
  	],
  	[
  		[
  			43389,
  			43391
  		],
  		3
  	],
  	[
  		[
  			43392,
  			43456
  		],
  		2
  	],
  	[
  		[
  			43457,
  			43469
  		],
  		2
  	],
  	[
  		43470,
  		3
  	],
  	[
  		[
  			43471,
  			43481
  		],
  		2
  	],
  	[
  		[
  			43482,
  			43485
  		],
  		3
  	],
  	[
  		[
  			43486,
  			43487
  		],
  		2
  	],
  	[
  		[
  			43488,
  			43518
  		],
  		2
  	],
  	[
  		43519,
  		3
  	],
  	[
  		[
  			43520,
  			43574
  		],
  		2
  	],
  	[
  		[
  			43575,
  			43583
  		],
  		3
  	],
  	[
  		[
  			43584,
  			43597
  		],
  		2
  	],
  	[
  		[
  			43598,
  			43599
  		],
  		3
  	],
  	[
  		[
  			43600,
  			43609
  		],
  		2
  	],
  	[
  		[
  			43610,
  			43611
  		],
  		3
  	],
  	[
  		[
  			43612,
  			43615
  		],
  		2
  	],
  	[
  		[
  			43616,
  			43638
  		],
  		2
  	],
  	[
  		[
  			43639,
  			43641
  		],
  		2
  	],
  	[
  		[
  			43642,
  			43643
  		],
  		2
  	],
  	[
  		[
  			43644,
  			43647
  		],
  		2
  	],
  	[
  		[
  			43648,
  			43714
  		],
  		2
  	],
  	[
  		[
  			43715,
  			43738
  		],
  		3
  	],
  	[
  		[
  			43739,
  			43741
  		],
  		2
  	],
  	[
  		[
  			43742,
  			43743
  		],
  		2
  	],
  	[
  		[
  			43744,
  			43759
  		],
  		2
  	],
  	[
  		[
  			43760,
  			43761
  		],
  		2
  	],
  	[
  		[
  			43762,
  			43766
  		],
  		2
  	],
  	[
  		[
  			43767,
  			43776
  		],
  		3
  	],
  	[
  		[
  			43777,
  			43782
  		],
  		2
  	],
  	[
  		[
  			43783,
  			43784
  		],
  		3
  	],
  	[
  		[
  			43785,
  			43790
  		],
  		2
  	],
  	[
  		[
  			43791,
  			43792
  		],
  		3
  	],
  	[
  		[
  			43793,
  			43798
  		],
  		2
  	],
  	[
  		[
  			43799,
  			43807
  		],
  		3
  	],
  	[
  		[
  			43808,
  			43814
  		],
  		2
  	],
  	[
  		43815,
  		3
  	],
  	[
  		[
  			43816,
  			43822
  		],
  		2
  	],
  	[
  		43823,
  		3
  	],
  	[
  		[
  			43824,
  			43866
  		],
  		2
  	],
  	[
  		43867,
  		2
  	],
  	[
  		43868,
  		1,
  		"ꜧ"
  	],
  	[
  		43869,
  		1,
  		"ꬷ"
  	],
  	[
  		43870,
  		1,
  		"ɫ"
  	],
  	[
  		43871,
  		1,
  		"ꭒ"
  	],
  	[
  		[
  			43872,
  			43875
  		],
  		2
  	],
  	[
  		[
  			43876,
  			43877
  		],
  		2
  	],
  	[
  		[
  			43878,
  			43879
  		],
  		2
  	],
  	[
  		43880,
  		2
  	],
  	[
  		43881,
  		1,
  		"ʍ"
  	],
  	[
  		[
  			43882,
  			43883
  		],
  		2
  	],
  	[
  		[
  			43884,
  			43887
  		],
  		3
  	],
  	[
  		43888,
  		1,
  		"Ꭰ"
  	],
  	[
  		43889,
  		1,
  		"Ꭱ"
  	],
  	[
  		43890,
  		1,
  		"Ꭲ"
  	],
  	[
  		43891,
  		1,
  		"Ꭳ"
  	],
  	[
  		43892,
  		1,
  		"Ꭴ"
  	],
  	[
  		43893,
  		1,
  		"Ꭵ"
  	],
  	[
  		43894,
  		1,
  		"Ꭶ"
  	],
  	[
  		43895,
  		1,
  		"Ꭷ"
  	],
  	[
  		43896,
  		1,
  		"Ꭸ"
  	],
  	[
  		43897,
  		1,
  		"Ꭹ"
  	],
  	[
  		43898,
  		1,
  		"Ꭺ"
  	],
  	[
  		43899,
  		1,
  		"Ꭻ"
  	],
  	[
  		43900,
  		1,
  		"Ꭼ"
  	],
  	[
  		43901,
  		1,
  		"Ꭽ"
  	],
  	[
  		43902,
  		1,
  		"Ꭾ"
  	],
  	[
  		43903,
  		1,
  		"Ꭿ"
  	],
  	[
  		43904,
  		1,
  		"Ꮀ"
  	],
  	[
  		43905,
  		1,
  		"Ꮁ"
  	],
  	[
  		43906,
  		1,
  		"Ꮂ"
  	],
  	[
  		43907,
  		1,
  		"Ꮃ"
  	],
  	[
  		43908,
  		1,
  		"Ꮄ"
  	],
  	[
  		43909,
  		1,
  		"Ꮅ"
  	],
  	[
  		43910,
  		1,
  		"Ꮆ"
  	],
  	[
  		43911,
  		1,
  		"Ꮇ"
  	],
  	[
  		43912,
  		1,
  		"Ꮈ"
  	],
  	[
  		43913,
  		1,
  		"Ꮉ"
  	],
  	[
  		43914,
  		1,
  		"Ꮊ"
  	],
  	[
  		43915,
  		1,
  		"Ꮋ"
  	],
  	[
  		43916,
  		1,
  		"Ꮌ"
  	],
  	[
  		43917,
  		1,
  		"Ꮍ"
  	],
  	[
  		43918,
  		1,
  		"Ꮎ"
  	],
  	[
  		43919,
  		1,
  		"Ꮏ"
  	],
  	[
  		43920,
  		1,
  		"Ꮐ"
  	],
  	[
  		43921,
  		1,
  		"Ꮑ"
  	],
  	[
  		43922,
  		1,
  		"Ꮒ"
  	],
  	[
  		43923,
  		1,
  		"Ꮓ"
  	],
  	[
  		43924,
  		1,
  		"Ꮔ"
  	],
  	[
  		43925,
  		1,
  		"Ꮕ"
  	],
  	[
  		43926,
  		1,
  		"Ꮖ"
  	],
  	[
  		43927,
  		1,
  		"Ꮗ"
  	],
  	[
  		43928,
  		1,
  		"Ꮘ"
  	],
  	[
  		43929,
  		1,
  		"Ꮙ"
  	],
  	[
  		43930,
  		1,
  		"Ꮚ"
  	],
  	[
  		43931,
  		1,
  		"Ꮛ"
  	],
  	[
  		43932,
  		1,
  		"Ꮜ"
  	],
  	[
  		43933,
  		1,
  		"Ꮝ"
  	],
  	[
  		43934,
  		1,
  		"Ꮞ"
  	],
  	[
  		43935,
  		1,
  		"Ꮟ"
  	],
  	[
  		43936,
  		1,
  		"Ꮠ"
  	],
  	[
  		43937,
  		1,
  		"Ꮡ"
  	],
  	[
  		43938,
  		1,
  		"Ꮢ"
  	],
  	[
  		43939,
  		1,
  		"Ꮣ"
  	],
  	[
  		43940,
  		1,
  		"Ꮤ"
  	],
  	[
  		43941,
  		1,
  		"Ꮥ"
  	],
  	[
  		43942,
  		1,
  		"Ꮦ"
  	],
  	[
  		43943,
  		1,
  		"Ꮧ"
  	],
  	[
  		43944,
  		1,
  		"Ꮨ"
  	],
  	[
  		43945,
  		1,
  		"Ꮩ"
  	],
  	[
  		43946,
  		1,
  		"Ꮪ"
  	],
  	[
  		43947,
  		1,
  		"Ꮫ"
  	],
  	[
  		43948,
  		1,
  		"Ꮬ"
  	],
  	[
  		43949,
  		1,
  		"Ꮭ"
  	],
  	[
  		43950,
  		1,
  		"Ꮮ"
  	],
  	[
  		43951,
  		1,
  		"Ꮯ"
  	],
  	[
  		43952,
  		1,
  		"Ꮰ"
  	],
  	[
  		43953,
  		1,
  		"Ꮱ"
  	],
  	[
  		43954,
  		1,
  		"Ꮲ"
  	],
  	[
  		43955,
  		1,
  		"Ꮳ"
  	],
  	[
  		43956,
  		1,
  		"Ꮴ"
  	],
  	[
  		43957,
  		1,
  		"Ꮵ"
  	],
  	[
  		43958,
  		1,
  		"Ꮶ"
  	],
  	[
  		43959,
  		1,
  		"Ꮷ"
  	],
  	[
  		43960,
  		1,
  		"Ꮸ"
  	],
  	[
  		43961,
  		1,
  		"Ꮹ"
  	],
  	[
  		43962,
  		1,
  		"Ꮺ"
  	],
  	[
  		43963,
  		1,
  		"Ꮻ"
  	],
  	[
  		43964,
  		1,
  		"Ꮼ"
  	],
  	[
  		43965,
  		1,
  		"Ꮽ"
  	],
  	[
  		43966,
  		1,
  		"Ꮾ"
  	],
  	[
  		43967,
  		1,
  		"Ꮿ"
  	],
  	[
  		[
  			43968,
  			44010
  		],
  		2
  	],
  	[
  		44011,
  		2
  	],
  	[
  		[
  			44012,
  			44013
  		],
  		2
  	],
  	[
  		[
  			44014,
  			44015
  		],
  		3
  	],
  	[
  		[
  			44016,
  			44025
  		],
  		2
  	],
  	[
  		[
  			44026,
  			44031
  		],
  		3
  	],
  	[
  		[
  			44032,
  			55203
  		],
  		2
  	],
  	[
  		[
  			55204,
  			55215
  		],
  		3
  	],
  	[
  		[
  			55216,
  			55238
  		],
  		2
  	],
  	[
  		[
  			55239,
  			55242
  		],
  		3
  	],
  	[
  		[
  			55243,
  			55291
  		],
  		2
  	],
  	[
  		[
  			55292,
  			55295
  		],
  		3
  	],
  	[
  		[
  			55296,
  			57343
  		],
  		3
  	],
  	[
  		[
  			57344,
  			63743
  		],
  		3
  	],
  	[
  		63744,
  		1,
  		"豈"
  	],
  	[
  		63745,
  		1,
  		"更"
  	],
  	[
  		63746,
  		1,
  		"車"
  	],
  	[
  		63747,
  		1,
  		"賈"
  	],
  	[
  		63748,
  		1,
  		"滑"
  	],
  	[
  		63749,
  		1,
  		"串"
  	],
  	[
  		63750,
  		1,
  		"句"
  	],
  	[
  		[
  			63751,
  			63752
  		],
  		1,
  		"龜"
  	],
  	[
  		63753,
  		1,
  		"契"
  	],
  	[
  		63754,
  		1,
  		"金"
  	],
  	[
  		63755,
  		1,
  		"喇"
  	],
  	[
  		63756,
  		1,
  		"奈"
  	],
  	[
  		63757,
  		1,
  		"懶"
  	],
  	[
  		63758,
  		1,
  		"癩"
  	],
  	[
  		63759,
  		1,
  		"羅"
  	],
  	[
  		63760,
  		1,
  		"蘿"
  	],
  	[
  		63761,
  		1,
  		"螺"
  	],
  	[
  		63762,
  		1,
  		"裸"
  	],
  	[
  		63763,
  		1,
  		"邏"
  	],
  	[
  		63764,
  		1,
  		"樂"
  	],
  	[
  		63765,
  		1,
  		"洛"
  	],
  	[
  		63766,
  		1,
  		"烙"
  	],
  	[
  		63767,
  		1,
  		"珞"
  	],
  	[
  		63768,
  		1,
  		"落"
  	],
  	[
  		63769,
  		1,
  		"酪"
  	],
  	[
  		63770,
  		1,
  		"駱"
  	],
  	[
  		63771,
  		1,
  		"亂"
  	],
  	[
  		63772,
  		1,
  		"卵"
  	],
  	[
  		63773,
  		1,
  		"欄"
  	],
  	[
  		63774,
  		1,
  		"爛"
  	],
  	[
  		63775,
  		1,
  		"蘭"
  	],
  	[
  		63776,
  		1,
  		"鸞"
  	],
  	[
  		63777,
  		1,
  		"嵐"
  	],
  	[
  		63778,
  		1,
  		"濫"
  	],
  	[
  		63779,
  		1,
  		"藍"
  	],
  	[
  		63780,
  		1,
  		"襤"
  	],
  	[
  		63781,
  		1,
  		"拉"
  	],
  	[
  		63782,
  		1,
  		"臘"
  	],
  	[
  		63783,
  		1,
  		"蠟"
  	],
  	[
  		63784,
  		1,
  		"廊"
  	],
  	[
  		63785,
  		1,
  		"朗"
  	],
  	[
  		63786,
  		1,
  		"浪"
  	],
  	[
  		63787,
  		1,
  		"狼"
  	],
  	[
  		63788,
  		1,
  		"郎"
  	],
  	[
  		63789,
  		1,
  		"來"
  	],
  	[
  		63790,
  		1,
  		"冷"
  	],
  	[
  		63791,
  		1,
  		"勞"
  	],
  	[
  		63792,
  		1,
  		"擄"
  	],
  	[
  		63793,
  		1,
  		"櫓"
  	],
  	[
  		63794,
  		1,
  		"爐"
  	],
  	[
  		63795,
  		1,
  		"盧"
  	],
  	[
  		63796,
  		1,
  		"老"
  	],
  	[
  		63797,
  		1,
  		"蘆"
  	],
  	[
  		63798,
  		1,
  		"虜"
  	],
  	[
  		63799,
  		1,
  		"路"
  	],
  	[
  		63800,
  		1,
  		"露"
  	],
  	[
  		63801,
  		1,
  		"魯"
  	],
  	[
  		63802,
  		1,
  		"鷺"
  	],
  	[
  		63803,
  		1,
  		"碌"
  	],
  	[
  		63804,
  		1,
  		"祿"
  	],
  	[
  		63805,
  		1,
  		"綠"
  	],
  	[
  		63806,
  		1,
  		"菉"
  	],
  	[
  		63807,
  		1,
  		"錄"
  	],
  	[
  		63808,
  		1,
  		"鹿"
  	],
  	[
  		63809,
  		1,
  		"論"
  	],
  	[
  		63810,
  		1,
  		"壟"
  	],
  	[
  		63811,
  		1,
  		"弄"
  	],
  	[
  		63812,
  		1,
  		"籠"
  	],
  	[
  		63813,
  		1,
  		"聾"
  	],
  	[
  		63814,
  		1,
  		"牢"
  	],
  	[
  		63815,
  		1,
  		"磊"
  	],
  	[
  		63816,
  		1,
  		"賂"
  	],
  	[
  		63817,
  		1,
  		"雷"
  	],
  	[
  		63818,
  		1,
  		"壘"
  	],
  	[
  		63819,
  		1,
  		"屢"
  	],
  	[
  		63820,
  		1,
  		"樓"
  	],
  	[
  		63821,
  		1,
  		"淚"
  	],
  	[
  		63822,
  		1,
  		"漏"
  	],
  	[
  		63823,
  		1,
  		"累"
  	],
  	[
  		63824,
  		1,
  		"縷"
  	],
  	[
  		63825,
  		1,
  		"陋"
  	],
  	[
  		63826,
  		1,
  		"勒"
  	],
  	[
  		63827,
  		1,
  		"肋"
  	],
  	[
  		63828,
  		1,
  		"凜"
  	],
  	[
  		63829,
  		1,
  		"凌"
  	],
  	[
  		63830,
  		1,
  		"稜"
  	],
  	[
  		63831,
  		1,
  		"綾"
  	],
  	[
  		63832,
  		1,
  		"菱"
  	],
  	[
  		63833,
  		1,
  		"陵"
  	],
  	[
  		63834,
  		1,
  		"讀"
  	],
  	[
  		63835,
  		1,
  		"拏"
  	],
  	[
  		63836,
  		1,
  		"樂"
  	],
  	[
  		63837,
  		1,
  		"諾"
  	],
  	[
  		63838,
  		1,
  		"丹"
  	],
  	[
  		63839,
  		1,
  		"寧"
  	],
  	[
  		63840,
  		1,
  		"怒"
  	],
  	[
  		63841,
  		1,
  		"率"
  	],
  	[
  		63842,
  		1,
  		"異"
  	],
  	[
  		63843,
  		1,
  		"北"
  	],
  	[
  		63844,
  		1,
  		"磻"
  	],
  	[
  		63845,
  		1,
  		"便"
  	],
  	[
  		63846,
  		1,
  		"復"
  	],
  	[
  		63847,
  		1,
  		"不"
  	],
  	[
  		63848,
  		1,
  		"泌"
  	],
  	[
  		63849,
  		1,
  		"數"
  	],
  	[
  		63850,
  		1,
  		"索"
  	],
  	[
  		63851,
  		1,
  		"參"
  	],
  	[
  		63852,
  		1,
  		"塞"
  	],
  	[
  		63853,
  		1,
  		"省"
  	],
  	[
  		63854,
  		1,
  		"葉"
  	],
  	[
  		63855,
  		1,
  		"說"
  	],
  	[
  		63856,
  		1,
  		"殺"
  	],
  	[
  		63857,
  		1,
  		"辰"
  	],
  	[
  		63858,
  		1,
  		"沈"
  	],
  	[
  		63859,
  		1,
  		"拾"
  	],
  	[
  		63860,
  		1,
  		"若"
  	],
  	[
  		63861,
  		1,
  		"掠"
  	],
  	[
  		63862,
  		1,
  		"略"
  	],
  	[
  		63863,
  		1,
  		"亮"
  	],
  	[
  		63864,
  		1,
  		"兩"
  	],
  	[
  		63865,
  		1,
  		"凉"
  	],
  	[
  		63866,
  		1,
  		"梁"
  	],
  	[
  		63867,
  		1,
  		"糧"
  	],
  	[
  		63868,
  		1,
  		"良"
  	],
  	[
  		63869,
  		1,
  		"諒"
  	],
  	[
  		63870,
  		1,
  		"量"
  	],
  	[
  		63871,
  		1,
  		"勵"
  	],
  	[
  		63872,
  		1,
  		"呂"
  	],
  	[
  		63873,
  		1,
  		"女"
  	],
  	[
  		63874,
  		1,
  		"廬"
  	],
  	[
  		63875,
  		1,
  		"旅"
  	],
  	[
  		63876,
  		1,
  		"濾"
  	],
  	[
  		63877,
  		1,
  		"礪"
  	],
  	[
  		63878,
  		1,
  		"閭"
  	],
  	[
  		63879,
  		1,
  		"驪"
  	],
  	[
  		63880,
  		1,
  		"麗"
  	],
  	[
  		63881,
  		1,
  		"黎"
  	],
  	[
  		63882,
  		1,
  		"力"
  	],
  	[
  		63883,
  		1,
  		"曆"
  	],
  	[
  		63884,
  		1,
  		"歷"
  	],
  	[
  		63885,
  		1,
  		"轢"
  	],
  	[
  		63886,
  		1,
  		"年"
  	],
  	[
  		63887,
  		1,
  		"憐"
  	],
  	[
  		63888,
  		1,
  		"戀"
  	],
  	[
  		63889,
  		1,
  		"撚"
  	],
  	[
  		63890,
  		1,
  		"漣"
  	],
  	[
  		63891,
  		1,
  		"煉"
  	],
  	[
  		63892,
  		1,
  		"璉"
  	],
  	[
  		63893,
  		1,
  		"秊"
  	],
  	[
  		63894,
  		1,
  		"練"
  	],
  	[
  		63895,
  		1,
  		"聯"
  	],
  	[
  		63896,
  		1,
  		"輦"
  	],
  	[
  		63897,
  		1,
  		"蓮"
  	],
  	[
  		63898,
  		1,
  		"連"
  	],
  	[
  		63899,
  		1,
  		"鍊"
  	],
  	[
  		63900,
  		1,
  		"列"
  	],
  	[
  		63901,
  		1,
  		"劣"
  	],
  	[
  		63902,
  		1,
  		"咽"
  	],
  	[
  		63903,
  		1,
  		"烈"
  	],
  	[
  		63904,
  		1,
  		"裂"
  	],
  	[
  		63905,
  		1,
  		"說"
  	],
  	[
  		63906,
  		1,
  		"廉"
  	],
  	[
  		63907,
  		1,
  		"念"
  	],
  	[
  		63908,
  		1,
  		"捻"
  	],
  	[
  		63909,
  		1,
  		"殮"
  	],
  	[
  		63910,
  		1,
  		"簾"
  	],
  	[
  		63911,
  		1,
  		"獵"
  	],
  	[
  		63912,
  		1,
  		"令"
  	],
  	[
  		63913,
  		1,
  		"囹"
  	],
  	[
  		63914,
  		1,
  		"寧"
  	],
  	[
  		63915,
  		1,
  		"嶺"
  	],
  	[
  		63916,
  		1,
  		"怜"
  	],
  	[
  		63917,
  		1,
  		"玲"
  	],
  	[
  		63918,
  		1,
  		"瑩"
  	],
  	[
  		63919,
  		1,
  		"羚"
  	],
  	[
  		63920,
  		1,
  		"聆"
  	],
  	[
  		63921,
  		1,
  		"鈴"
  	],
  	[
  		63922,
  		1,
  		"零"
  	],
  	[
  		63923,
  		1,
  		"靈"
  	],
  	[
  		63924,
  		1,
  		"領"
  	],
  	[
  		63925,
  		1,
  		"例"
  	],
  	[
  		63926,
  		1,
  		"禮"
  	],
  	[
  		63927,
  		1,
  		"醴"
  	],
  	[
  		63928,
  		1,
  		"隸"
  	],
  	[
  		63929,
  		1,
  		"惡"
  	],
  	[
  		63930,
  		1,
  		"了"
  	],
  	[
  		63931,
  		1,
  		"僚"
  	],
  	[
  		63932,
  		1,
  		"寮"
  	],
  	[
  		63933,
  		1,
  		"尿"
  	],
  	[
  		63934,
  		1,
  		"料"
  	],
  	[
  		63935,
  		1,
  		"樂"
  	],
  	[
  		63936,
  		1,
  		"燎"
  	],
  	[
  		63937,
  		1,
  		"療"
  	],
  	[
  		63938,
  		1,
  		"蓼"
  	],
  	[
  		63939,
  		1,
  		"遼"
  	],
  	[
  		63940,
  		1,
  		"龍"
  	],
  	[
  		63941,
  		1,
  		"暈"
  	],
  	[
  		63942,
  		1,
  		"阮"
  	],
  	[
  		63943,
  		1,
  		"劉"
  	],
  	[
  		63944,
  		1,
  		"杻"
  	],
  	[
  		63945,
  		1,
  		"柳"
  	],
  	[
  		63946,
  		1,
  		"流"
  	],
  	[
  		63947,
  		1,
  		"溜"
  	],
  	[
  		63948,
  		1,
  		"琉"
  	],
  	[
  		63949,
  		1,
  		"留"
  	],
  	[
  		63950,
  		1,
  		"硫"
  	],
  	[
  		63951,
  		1,
  		"紐"
  	],
  	[
  		63952,
  		1,
  		"類"
  	],
  	[
  		63953,
  		1,
  		"六"
  	],
  	[
  		63954,
  		1,
  		"戮"
  	],
  	[
  		63955,
  		1,
  		"陸"
  	],
  	[
  		63956,
  		1,
  		"倫"
  	],
  	[
  		63957,
  		1,
  		"崙"
  	],
  	[
  		63958,
  		1,
  		"淪"
  	],
  	[
  		63959,
  		1,
  		"輪"
  	],
  	[
  		63960,
  		1,
  		"律"
  	],
  	[
  		63961,
  		1,
  		"慄"
  	],
  	[
  		63962,
  		1,
  		"栗"
  	],
  	[
  		63963,
  		1,
  		"率"
  	],
  	[
  		63964,
  		1,
  		"隆"
  	],
  	[
  		63965,
  		1,
  		"利"
  	],
  	[
  		63966,
  		1,
  		"吏"
  	],
  	[
  		63967,
  		1,
  		"履"
  	],
  	[
  		63968,
  		1,
  		"易"
  	],
  	[
  		63969,
  		1,
  		"李"
  	],
  	[
  		63970,
  		1,
  		"梨"
  	],
  	[
  		63971,
  		1,
  		"泥"
  	],
  	[
  		63972,
  		1,
  		"理"
  	],
  	[
  		63973,
  		1,
  		"痢"
  	],
  	[
  		63974,
  		1,
  		"罹"
  	],
  	[
  		63975,
  		1,
  		"裏"
  	],
  	[
  		63976,
  		1,
  		"裡"
  	],
  	[
  		63977,
  		1,
  		"里"
  	],
  	[
  		63978,
  		1,
  		"離"
  	],
  	[
  		63979,
  		1,
  		"匿"
  	],
  	[
  		63980,
  		1,
  		"溺"
  	],
  	[
  		63981,
  		1,
  		"吝"
  	],
  	[
  		63982,
  		1,
  		"燐"
  	],
  	[
  		63983,
  		1,
  		"璘"
  	],
  	[
  		63984,
  		1,
  		"藺"
  	],
  	[
  		63985,
  		1,
  		"隣"
  	],
  	[
  		63986,
  		1,
  		"鱗"
  	],
  	[
  		63987,
  		1,
  		"麟"
  	],
  	[
  		63988,
  		1,
  		"林"
  	],
  	[
  		63989,
  		1,
  		"淋"
  	],
  	[
  		63990,
  		1,
  		"臨"
  	],
  	[
  		63991,
  		1,
  		"立"
  	],
  	[
  		63992,
  		1,
  		"笠"
  	],
  	[
  		63993,
  		1,
  		"粒"
  	],
  	[
  		63994,
  		1,
  		"狀"
  	],
  	[
  		63995,
  		1,
  		"炙"
  	],
  	[
  		63996,
  		1,
  		"識"
  	],
  	[
  		63997,
  		1,
  		"什"
  	],
  	[
  		63998,
  		1,
  		"茶"
  	],
  	[
  		63999,
  		1,
  		"刺"
  	],
  	[
  		64000,
  		1,
  		"切"
  	],
  	[
  		64001,
  		1,
  		"度"
  	],
  	[
  		64002,
  		1,
  		"拓"
  	],
  	[
  		64003,
  		1,
  		"糖"
  	],
  	[
  		64004,
  		1,
  		"宅"
  	],
  	[
  		64005,
  		1,
  		"洞"
  	],
  	[
  		64006,
  		1,
  		"暴"
  	],
  	[
  		64007,
  		1,
  		"輻"
  	],
  	[
  		64008,
  		1,
  		"行"
  	],
  	[
  		64009,
  		1,
  		"降"
  	],
  	[
  		64010,
  		1,
  		"見"
  	],
  	[
  		64011,
  		1,
  		"廓"
  	],
  	[
  		64012,
  		1,
  		"兀"
  	],
  	[
  		64013,
  		1,
  		"嗀"
  	],
  	[
  		[
  			64014,
  			64015
  		],
  		2
  	],
  	[
  		64016,
  		1,
  		"塚"
  	],
  	[
  		64017,
  		2
  	],
  	[
  		64018,
  		1,
  		"晴"
  	],
  	[
  		[
  			64019,
  			64020
  		],
  		2
  	],
  	[
  		64021,
  		1,
  		"凞"
  	],
  	[
  		64022,
  		1,
  		"猪"
  	],
  	[
  		64023,
  		1,
  		"益"
  	],
  	[
  		64024,
  		1,
  		"礼"
  	],
  	[
  		64025,
  		1,
  		"神"
  	],
  	[
  		64026,
  		1,
  		"祥"
  	],
  	[
  		64027,
  		1,
  		"福"
  	],
  	[
  		64028,
  		1,
  		"靖"
  	],
  	[
  		64029,
  		1,
  		"精"
  	],
  	[
  		64030,
  		1,
  		"羽"
  	],
  	[
  		64031,
  		2
  	],
  	[
  		64032,
  		1,
  		"蘒"
  	],
  	[
  		64033,
  		2
  	],
  	[
  		64034,
  		1,
  		"諸"
  	],
  	[
  		[
  			64035,
  			64036
  		],
  		2
  	],
  	[
  		64037,
  		1,
  		"逸"
  	],
  	[
  		64038,
  		1,
  		"都"
  	],
  	[
  		[
  			64039,
  			64041
  		],
  		2
  	],
  	[
  		64042,
  		1,
  		"飯"
  	],
  	[
  		64043,
  		1,
  		"飼"
  	],
  	[
  		64044,
  		1,
  		"館"
  	],
  	[
  		64045,
  		1,
  		"鶴"
  	],
  	[
  		64046,
  		1,
  		"郞"
  	],
  	[
  		64047,
  		1,
  		"隷"
  	],
  	[
  		64048,
  		1,
  		"侮"
  	],
  	[
  		64049,
  		1,
  		"僧"
  	],
  	[
  		64050,
  		1,
  		"免"
  	],
  	[
  		64051,
  		1,
  		"勉"
  	],
  	[
  		64052,
  		1,
  		"勤"
  	],
  	[
  		64053,
  		1,
  		"卑"
  	],
  	[
  		64054,
  		1,
  		"喝"
  	],
  	[
  		64055,
  		1,
  		"嘆"
  	],
  	[
  		64056,
  		1,
  		"器"
  	],
  	[
  		64057,
  		1,
  		"塀"
  	],
  	[
  		64058,
  		1,
  		"墨"
  	],
  	[
  		64059,
  		1,
  		"層"
  	],
  	[
  		64060,
  		1,
  		"屮"
  	],
  	[
  		64061,
  		1,
  		"悔"
  	],
  	[
  		64062,
  		1,
  		"慨"
  	],
  	[
  		64063,
  		1,
  		"憎"
  	],
  	[
  		64064,
  		1,
  		"懲"
  	],
  	[
  		64065,
  		1,
  		"敏"
  	],
  	[
  		64066,
  		1,
  		"既"
  	],
  	[
  		64067,
  		1,
  		"暑"
  	],
  	[
  		64068,
  		1,
  		"梅"
  	],
  	[
  		64069,
  		1,
  		"海"
  	],
  	[
  		64070,
  		1,
  		"渚"
  	],
  	[
  		64071,
  		1,
  		"漢"
  	],
  	[
  		64072,
  		1,
  		"煮"
  	],
  	[
  		64073,
  		1,
  		"爫"
  	],
  	[
  		64074,
  		1,
  		"琢"
  	],
  	[
  		64075,
  		1,
  		"碑"
  	],
  	[
  		64076,
  		1,
  		"社"
  	],
  	[
  		64077,
  		1,
  		"祉"
  	],
  	[
  		64078,
  		1,
  		"祈"
  	],
  	[
  		64079,
  		1,
  		"祐"
  	],
  	[
  		64080,
  		1,
  		"祖"
  	],
  	[
  		64081,
  		1,
  		"祝"
  	],
  	[
  		64082,
  		1,
  		"禍"
  	],
  	[
  		64083,
  		1,
  		"禎"
  	],
  	[
  		64084,
  		1,
  		"穀"
  	],
  	[
  		64085,
  		1,
  		"突"
  	],
  	[
  		64086,
  		1,
  		"節"
  	],
  	[
  		64087,
  		1,
  		"練"
  	],
  	[
  		64088,
  		1,
  		"縉"
  	],
  	[
  		64089,
  		1,
  		"繁"
  	],
  	[
  		64090,
  		1,
  		"署"
  	],
  	[
  		64091,
  		1,
  		"者"
  	],
  	[
  		64092,
  		1,
  		"臭"
  	],
  	[
  		[
  			64093,
  			64094
  		],
  		1,
  		"艹"
  	],
  	[
  		64095,
  		1,
  		"著"
  	],
  	[
  		64096,
  		1,
  		"褐"
  	],
  	[
  		64097,
  		1,
  		"視"
  	],
  	[
  		64098,
  		1,
  		"謁"
  	],
  	[
  		64099,
  		1,
  		"謹"
  	],
  	[
  		64100,
  		1,
  		"賓"
  	],
  	[
  		64101,
  		1,
  		"贈"
  	],
  	[
  		64102,
  		1,
  		"辶"
  	],
  	[
  		64103,
  		1,
  		"逸"
  	],
  	[
  		64104,
  		1,
  		"難"
  	],
  	[
  		64105,
  		1,
  		"響"
  	],
  	[
  		64106,
  		1,
  		"頻"
  	],
  	[
  		64107,
  		1,
  		"恵"
  	],
  	[
  		64108,
  		1,
  		"𤋮"
  	],
  	[
  		64109,
  		1,
  		"舘"
  	],
  	[
  		[
  			64110,
  			64111
  		],
  		3
  	],
  	[
  		64112,
  		1,
  		"並"
  	],
  	[
  		64113,
  		1,
  		"况"
  	],
  	[
  		64114,
  		1,
  		"全"
  	],
  	[
  		64115,
  		1,
  		"侀"
  	],
  	[
  		64116,
  		1,
  		"充"
  	],
  	[
  		64117,
  		1,
  		"冀"
  	],
  	[
  		64118,
  		1,
  		"勇"
  	],
  	[
  		64119,
  		1,
  		"勺"
  	],
  	[
  		64120,
  		1,
  		"喝"
  	],
  	[
  		64121,
  		1,
  		"啕"
  	],
  	[
  		64122,
  		1,
  		"喙"
  	],
  	[
  		64123,
  		1,
  		"嗢"
  	],
  	[
  		64124,
  		1,
  		"塚"
  	],
  	[
  		64125,
  		1,
  		"墳"
  	],
  	[
  		64126,
  		1,
  		"奄"
  	],
  	[
  		64127,
  		1,
  		"奔"
  	],
  	[
  		64128,
  		1,
  		"婢"
  	],
  	[
  		64129,
  		1,
  		"嬨"
  	],
  	[
  		64130,
  		1,
  		"廒"
  	],
  	[
  		64131,
  		1,
  		"廙"
  	],
  	[
  		64132,
  		1,
  		"彩"
  	],
  	[
  		64133,
  		1,
  		"徭"
  	],
  	[
  		64134,
  		1,
  		"惘"
  	],
  	[
  		64135,
  		1,
  		"慎"
  	],
  	[
  		64136,
  		1,
  		"愈"
  	],
  	[
  		64137,
  		1,
  		"憎"
  	],
  	[
  		64138,
  		1,
  		"慠"
  	],
  	[
  		64139,
  		1,
  		"懲"
  	],
  	[
  		64140,
  		1,
  		"戴"
  	],
  	[
  		64141,
  		1,
  		"揄"
  	],
  	[
  		64142,
  		1,
  		"搜"
  	],
  	[
  		64143,
  		1,
  		"摒"
  	],
  	[
  		64144,
  		1,
  		"敖"
  	],
  	[
  		64145,
  		1,
  		"晴"
  	],
  	[
  		64146,
  		1,
  		"朗"
  	],
  	[
  		64147,
  		1,
  		"望"
  	],
  	[
  		64148,
  		1,
  		"杖"
  	],
  	[
  		64149,
  		1,
  		"歹"
  	],
  	[
  		64150,
  		1,
  		"殺"
  	],
  	[
  		64151,
  		1,
  		"流"
  	],
  	[
  		64152,
  		1,
  		"滛"
  	],
  	[
  		64153,
  		1,
  		"滋"
  	],
  	[
  		64154,
  		1,
  		"漢"
  	],
  	[
  		64155,
  		1,
  		"瀞"
  	],
  	[
  		64156,
  		1,
  		"煮"
  	],
  	[
  		64157,
  		1,
  		"瞧"
  	],
  	[
  		64158,
  		1,
  		"爵"
  	],
  	[
  		64159,
  		1,
  		"犯"
  	],
  	[
  		64160,
  		1,
  		"猪"
  	],
  	[
  		64161,
  		1,
  		"瑱"
  	],
  	[
  		64162,
  		1,
  		"甆"
  	],
  	[
  		64163,
  		1,
  		"画"
  	],
  	[
  		64164,
  		1,
  		"瘝"
  	],
  	[
  		64165,
  		1,
  		"瘟"
  	],
  	[
  		64166,
  		1,
  		"益"
  	],
  	[
  		64167,
  		1,
  		"盛"
  	],
  	[
  		64168,
  		1,
  		"直"
  	],
  	[
  		64169,
  		1,
  		"睊"
  	],
  	[
  		64170,
  		1,
  		"着"
  	],
  	[
  		64171,
  		1,
  		"磌"
  	],
  	[
  		64172,
  		1,
  		"窱"
  	],
  	[
  		64173,
  		1,
  		"節"
  	],
  	[
  		64174,
  		1,
  		"类"
  	],
  	[
  		64175,
  		1,
  		"絛"
  	],
  	[
  		64176,
  		1,
  		"練"
  	],
  	[
  		64177,
  		1,
  		"缾"
  	],
  	[
  		64178,
  		1,
  		"者"
  	],
  	[
  		64179,
  		1,
  		"荒"
  	],
  	[
  		64180,
  		1,
  		"華"
  	],
  	[
  		64181,
  		1,
  		"蝹"
  	],
  	[
  		64182,
  		1,
  		"襁"
  	],
  	[
  		64183,
  		1,
  		"覆"
  	],
  	[
  		64184,
  		1,
  		"視"
  	],
  	[
  		64185,
  		1,
  		"調"
  	],
  	[
  		64186,
  		1,
  		"諸"
  	],
  	[
  		64187,
  		1,
  		"請"
  	],
  	[
  		64188,
  		1,
  		"謁"
  	],
  	[
  		64189,
  		1,
  		"諾"
  	],
  	[
  		64190,
  		1,
  		"諭"
  	],
  	[
  		64191,
  		1,
  		"謹"
  	],
  	[
  		64192,
  		1,
  		"變"
  	],
  	[
  		64193,
  		1,
  		"贈"
  	],
  	[
  		64194,
  		1,
  		"輸"
  	],
  	[
  		64195,
  		1,
  		"遲"
  	],
  	[
  		64196,
  		1,
  		"醙"
  	],
  	[
  		64197,
  		1,
  		"鉶"
  	],
  	[
  		64198,
  		1,
  		"陼"
  	],
  	[
  		64199,
  		1,
  		"難"
  	],
  	[
  		64200,
  		1,
  		"靖"
  	],
  	[
  		64201,
  		1,
  		"韛"
  	],
  	[
  		64202,
  		1,
  		"響"
  	],
  	[
  		64203,
  		1,
  		"頋"
  	],
  	[
  		64204,
  		1,
  		"頻"
  	],
  	[
  		64205,
  		1,
  		"鬒"
  	],
  	[
  		64206,
  		1,
  		"龜"
  	],
  	[
  		64207,
  		1,
  		"𢡊"
  	],
  	[
  		64208,
  		1,
  		"𢡄"
  	],
  	[
  		64209,
  		1,
  		"𣏕"
  	],
  	[
  		64210,
  		1,
  		"㮝"
  	],
  	[
  		64211,
  		1,
  		"䀘"
  	],
  	[
  		64212,
  		1,
  		"䀹"
  	],
  	[
  		64213,
  		1,
  		"𥉉"
  	],
  	[
  		64214,
  		1,
  		"𥳐"
  	],
  	[
  		64215,
  		1,
  		"𧻓"
  	],
  	[
  		64216,
  		1,
  		"齃"
  	],
  	[
  		64217,
  		1,
  		"龎"
  	],
  	[
  		[
  			64218,
  			64255
  		],
  		3
  	],
  	[
  		64256,
  		1,
  		"ff"
  	],
  	[
  		64257,
  		1,
  		"fi"
  	],
  	[
  		64258,
  		1,
  		"fl"
  	],
  	[
  		64259,
  		1,
  		"ffi"
  	],
  	[
  		64260,
  		1,
  		"ffl"
  	],
  	[
  		[
  			64261,
  			64262
  		],
  		1,
  		"st"
  	],
  	[
  		[
  			64263,
  			64274
  		],
  		3
  	],
  	[
  		64275,
  		1,
  		"մն"
  	],
  	[
  		64276,
  		1,
  		"մե"
  	],
  	[
  		64277,
  		1,
  		"մի"
  	],
  	[
  		64278,
  		1,
  		"վն"
  	],
  	[
  		64279,
  		1,
  		"մխ"
  	],
  	[
  		[
  			64280,
  			64284
  		],
  		3
  	],
  	[
  		64285,
  		1,
  		"יִ"
  	],
  	[
  		64286,
  		2
  	],
  	[
  		64287,
  		1,
  		"ײַ"
  	],
  	[
  		64288,
  		1,
  		"ע"
  	],
  	[
  		64289,
  		1,
  		"א"
  	],
  	[
  		64290,
  		1,
  		"ד"
  	],
  	[
  		64291,
  		1,
  		"ה"
  	],
  	[
  		64292,
  		1,
  		"כ"
  	],
  	[
  		64293,
  		1,
  		"ל"
  	],
  	[
  		64294,
  		1,
  		"ם"
  	],
  	[
  		64295,
  		1,
  		"ר"
  	],
  	[
  		64296,
  		1,
  		"ת"
  	],
  	[
  		64297,
  		5,
  		"+"
  	],
  	[
  		64298,
  		1,
  		"שׁ"
  	],
  	[
  		64299,
  		1,
  		"שׂ"
  	],
  	[
  		64300,
  		1,
  		"שּׁ"
  	],
  	[
  		64301,
  		1,
  		"שּׂ"
  	],
  	[
  		64302,
  		1,
  		"אַ"
  	],
  	[
  		64303,
  		1,
  		"אָ"
  	],
  	[
  		64304,
  		1,
  		"אּ"
  	],
  	[
  		64305,
  		1,
  		"בּ"
  	],
  	[
  		64306,
  		1,
  		"גּ"
  	],
  	[
  		64307,
  		1,
  		"דּ"
  	],
  	[
  		64308,
  		1,
  		"הּ"
  	],
  	[
  		64309,
  		1,
  		"וּ"
  	],
  	[
  		64310,
  		1,
  		"זּ"
  	],
  	[
  		64311,
  		3
  	],
  	[
  		64312,
  		1,
  		"טּ"
  	],
  	[
  		64313,
  		1,
  		"יּ"
  	],
  	[
  		64314,
  		1,
  		"ךּ"
  	],
  	[
  		64315,
  		1,
  		"כּ"
  	],
  	[
  		64316,
  		1,
  		"לּ"
  	],
  	[
  		64317,
  		3
  	],
  	[
  		64318,
  		1,
  		"מּ"
  	],
  	[
  		64319,
  		3
  	],
  	[
  		64320,
  		1,
  		"נּ"
  	],
  	[
  		64321,
  		1,
  		"סּ"
  	],
  	[
  		64322,
  		3
  	],
  	[
  		64323,
  		1,
  		"ףּ"
  	],
  	[
  		64324,
  		1,
  		"פּ"
  	],
  	[
  		64325,
  		3
  	],
  	[
  		64326,
  		1,
  		"צּ"
  	],
  	[
  		64327,
  		1,
  		"קּ"
  	],
  	[
  		64328,
  		1,
  		"רּ"
  	],
  	[
  		64329,
  		1,
  		"שּ"
  	],
  	[
  		64330,
  		1,
  		"תּ"
  	],
  	[
  		64331,
  		1,
  		"וֹ"
  	],
  	[
  		64332,
  		1,
  		"בֿ"
  	],
  	[
  		64333,
  		1,
  		"כֿ"
  	],
  	[
  		64334,
  		1,
  		"פֿ"
  	],
  	[
  		64335,
  		1,
  		"אל"
  	],
  	[
  		[
  			64336,
  			64337
  		],
  		1,
  		"ٱ"
  	],
  	[
  		[
  			64338,
  			64341
  		],
  		1,
  		"ٻ"
  	],
  	[
  		[
  			64342,
  			64345
  		],
  		1,
  		"پ"
  	],
  	[
  		[
  			64346,
  			64349
  		],
  		1,
  		"ڀ"
  	],
  	[
  		[
  			64350,
  			64353
  		],
  		1,
  		"ٺ"
  	],
  	[
  		[
  			64354,
  			64357
  		],
  		1,
  		"ٿ"
  	],
  	[
  		[
  			64358,
  			64361
  		],
  		1,
  		"ٹ"
  	],
  	[
  		[
  			64362,
  			64365
  		],
  		1,
  		"ڤ"
  	],
  	[
  		[
  			64366,
  			64369
  		],
  		1,
  		"ڦ"
  	],
  	[
  		[
  			64370,
  			64373
  		],
  		1,
  		"ڄ"
  	],
  	[
  		[
  			64374,
  			64377
  		],
  		1,
  		"ڃ"
  	],
  	[
  		[
  			64378,
  			64381
  		],
  		1,
  		"چ"
  	],
  	[
  		[
  			64382,
  			64385
  		],
  		1,
  		"ڇ"
  	],
  	[
  		[
  			64386,
  			64387
  		],
  		1,
  		"ڍ"
  	],
  	[
  		[
  			64388,
  			64389
  		],
  		1,
  		"ڌ"
  	],
  	[
  		[
  			64390,
  			64391
  		],
  		1,
  		"ڎ"
  	],
  	[
  		[
  			64392,
  			64393
  		],
  		1,
  		"ڈ"
  	],
  	[
  		[
  			64394,
  			64395
  		],
  		1,
  		"ژ"
  	],
  	[
  		[
  			64396,
  			64397
  		],
  		1,
  		"ڑ"
  	],
  	[
  		[
  			64398,
  			64401
  		],
  		1,
  		"ک"
  	],
  	[
  		[
  			64402,
  			64405
  		],
  		1,
  		"گ"
  	],
  	[
  		[
  			64406,
  			64409
  		],
  		1,
  		"ڳ"
  	],
  	[
  		[
  			64410,
  			64413
  		],
  		1,
  		"ڱ"
  	],
  	[
  		[
  			64414,
  			64415
  		],
  		1,
  		"ں"
  	],
  	[
  		[
  			64416,
  			64419
  		],
  		1,
  		"ڻ"
  	],
  	[
  		[
  			64420,
  			64421
  		],
  		1,
  		"ۀ"
  	],
  	[
  		[
  			64422,
  			64425
  		],
  		1,
  		"ہ"
  	],
  	[
  		[
  			64426,
  			64429
  		],
  		1,
  		"ھ"
  	],
  	[
  		[
  			64430,
  			64431
  		],
  		1,
  		"ے"
  	],
  	[
  		[
  			64432,
  			64433
  		],
  		1,
  		"ۓ"
  	],
  	[
  		[
  			64434,
  			64449
  		],
  		2
  	],
  	[
  		[
  			64450,
  			64466
  		],
  		3
  	],
  	[
  		[
  			64467,
  			64470
  		],
  		1,
  		"ڭ"
  	],
  	[
  		[
  			64471,
  			64472
  		],
  		1,
  		"ۇ"
  	],
  	[
  		[
  			64473,
  			64474
  		],
  		1,
  		"ۆ"
  	],
  	[
  		[
  			64475,
  			64476
  		],
  		1,
  		"ۈ"
  	],
  	[
  		64477,
  		1,
  		"ۇٴ"
  	],
  	[
  		[
  			64478,
  			64479
  		],
  		1,
  		"ۋ"
  	],
  	[
  		[
  			64480,
  			64481
  		],
  		1,
  		"ۅ"
  	],
  	[
  		[
  			64482,
  			64483
  		],
  		1,
  		"ۉ"
  	],
  	[
  		[
  			64484,
  			64487
  		],
  		1,
  		"ې"
  	],
  	[
  		[
  			64488,
  			64489
  		],
  		1,
  		"ى"
  	],
  	[
  		[
  			64490,
  			64491
  		],
  		1,
  		"ئا"
  	],
  	[
  		[
  			64492,
  			64493
  		],
  		1,
  		"ئە"
  	],
  	[
  		[
  			64494,
  			64495
  		],
  		1,
  		"ئو"
  	],
  	[
  		[
  			64496,
  			64497
  		],
  		1,
  		"ئۇ"
  	],
  	[
  		[
  			64498,
  			64499
  		],
  		1,
  		"ئۆ"
  	],
  	[
  		[
  			64500,
  			64501
  		],
  		1,
  		"ئۈ"
  	],
  	[
  		[
  			64502,
  			64504
  		],
  		1,
  		"ئې"
  	],
  	[
  		[
  			64505,
  			64507
  		],
  		1,
  		"ئى"
  	],
  	[
  		[
  			64508,
  			64511
  		],
  		1,
  		"ی"
  	],
  	[
  		64512,
  		1,
  		"ئج"
  	],
  	[
  		64513,
  		1,
  		"ئح"
  	],
  	[
  		64514,
  		1,
  		"ئم"
  	],
  	[
  		64515,
  		1,
  		"ئى"
  	],
  	[
  		64516,
  		1,
  		"ئي"
  	],
  	[
  		64517,
  		1,
  		"بج"
  	],
  	[
  		64518,
  		1,
  		"بح"
  	],
  	[
  		64519,
  		1,
  		"بخ"
  	],
  	[
  		64520,
  		1,
  		"بم"
  	],
  	[
  		64521,
  		1,
  		"بى"
  	],
  	[
  		64522,
  		1,
  		"بي"
  	],
  	[
  		64523,
  		1,
  		"تج"
  	],
  	[
  		64524,
  		1,
  		"تح"
  	],
  	[
  		64525,
  		1,
  		"تخ"
  	],
  	[
  		64526,
  		1,
  		"تم"
  	],
  	[
  		64527,
  		1,
  		"تى"
  	],
  	[
  		64528,
  		1,
  		"تي"
  	],
  	[
  		64529,
  		1,
  		"ثج"
  	],
  	[
  		64530,
  		1,
  		"ثم"
  	],
  	[
  		64531,
  		1,
  		"ثى"
  	],
  	[
  		64532,
  		1,
  		"ثي"
  	],
  	[
  		64533,
  		1,
  		"جح"
  	],
  	[
  		64534,
  		1,
  		"جم"
  	],
  	[
  		64535,
  		1,
  		"حج"
  	],
  	[
  		64536,
  		1,
  		"حم"
  	],
  	[
  		64537,
  		1,
  		"خج"
  	],
  	[
  		64538,
  		1,
  		"خح"
  	],
  	[
  		64539,
  		1,
  		"خم"
  	],
  	[
  		64540,
  		1,
  		"سج"
  	],
  	[
  		64541,
  		1,
  		"سح"
  	],
  	[
  		64542,
  		1,
  		"سخ"
  	],
  	[
  		64543,
  		1,
  		"سم"
  	],
  	[
  		64544,
  		1,
  		"صح"
  	],
  	[
  		64545,
  		1,
  		"صم"
  	],
  	[
  		64546,
  		1,
  		"ضج"
  	],
  	[
  		64547,
  		1,
  		"ضح"
  	],
  	[
  		64548,
  		1,
  		"ضخ"
  	],
  	[
  		64549,
  		1,
  		"ضم"
  	],
  	[
  		64550,
  		1,
  		"طح"
  	],
  	[
  		64551,
  		1,
  		"طم"
  	],
  	[
  		64552,
  		1,
  		"ظم"
  	],
  	[
  		64553,
  		1,
  		"عج"
  	],
  	[
  		64554,
  		1,
  		"عم"
  	],
  	[
  		64555,
  		1,
  		"غج"
  	],
  	[
  		64556,
  		1,
  		"غم"
  	],
  	[
  		64557,
  		1,
  		"فج"
  	],
  	[
  		64558,
  		1,
  		"فح"
  	],
  	[
  		64559,
  		1,
  		"فخ"
  	],
  	[
  		64560,
  		1,
  		"فم"
  	],
  	[
  		64561,
  		1,
  		"فى"
  	],
  	[
  		64562,
  		1,
  		"في"
  	],
  	[
  		64563,
  		1,
  		"قح"
  	],
  	[
  		64564,
  		1,
  		"قم"
  	],
  	[
  		64565,
  		1,
  		"قى"
  	],
  	[
  		64566,
  		1,
  		"قي"
  	],
  	[
  		64567,
  		1,
  		"كا"
  	],
  	[
  		64568,
  		1,
  		"كج"
  	],
  	[
  		64569,
  		1,
  		"كح"
  	],
  	[
  		64570,
  		1,
  		"كخ"
  	],
  	[
  		64571,
  		1,
  		"كل"
  	],
  	[
  		64572,
  		1,
  		"كم"
  	],
  	[
  		64573,
  		1,
  		"كى"
  	],
  	[
  		64574,
  		1,
  		"كي"
  	],
  	[
  		64575,
  		1,
  		"لج"
  	],
  	[
  		64576,
  		1,
  		"لح"
  	],
  	[
  		64577,
  		1,
  		"لخ"
  	],
  	[
  		64578,
  		1,
  		"لم"
  	],
  	[
  		64579,
  		1,
  		"لى"
  	],
  	[
  		64580,
  		1,
  		"لي"
  	],
  	[
  		64581,
  		1,
  		"مج"
  	],
  	[
  		64582,
  		1,
  		"مح"
  	],
  	[
  		64583,
  		1,
  		"مخ"
  	],
  	[
  		64584,
  		1,
  		"مم"
  	],
  	[
  		64585,
  		1,
  		"مى"
  	],
  	[
  		64586,
  		1,
  		"مي"
  	],
  	[
  		64587,
  		1,
  		"نج"
  	],
  	[
  		64588,
  		1,
  		"نح"
  	],
  	[
  		64589,
  		1,
  		"نخ"
  	],
  	[
  		64590,
  		1,
  		"نم"
  	],
  	[
  		64591,
  		1,
  		"نى"
  	],
  	[
  		64592,
  		1,
  		"ني"
  	],
  	[
  		64593,
  		1,
  		"هج"
  	],
  	[
  		64594,
  		1,
  		"هم"
  	],
  	[
  		64595,
  		1,
  		"هى"
  	],
  	[
  		64596,
  		1,
  		"هي"
  	],
  	[
  		64597,
  		1,
  		"يج"
  	],
  	[
  		64598,
  		1,
  		"يح"
  	],
  	[
  		64599,
  		1,
  		"يخ"
  	],
  	[
  		64600,
  		1,
  		"يم"
  	],
  	[
  		64601,
  		1,
  		"يى"
  	],
  	[
  		64602,
  		1,
  		"يي"
  	],
  	[
  		64603,
  		1,
  		"ذٰ"
  	],
  	[
  		64604,
  		1,
  		"رٰ"
  	],
  	[
  		64605,
  		1,
  		"ىٰ"
  	],
  	[
  		64606,
  		5,
  		" ٌّ"
  	],
  	[
  		64607,
  		5,
  		" ٍّ"
  	],
  	[
  		64608,
  		5,
  		" َّ"
  	],
  	[
  		64609,
  		5,
  		" ُّ"
  	],
  	[
  		64610,
  		5,
  		" ِّ"
  	],
  	[
  		64611,
  		5,
  		" ّٰ"
  	],
  	[
  		64612,
  		1,
  		"ئر"
  	],
  	[
  		64613,
  		1,
  		"ئز"
  	],
  	[
  		64614,
  		1,
  		"ئم"
  	],
  	[
  		64615,
  		1,
  		"ئن"
  	],
  	[
  		64616,
  		1,
  		"ئى"
  	],
  	[
  		64617,
  		1,
  		"ئي"
  	],
  	[
  		64618,
  		1,
  		"بر"
  	],
  	[
  		64619,
  		1,
  		"بز"
  	],
  	[
  		64620,
  		1,
  		"بم"
  	],
  	[
  		64621,
  		1,
  		"بن"
  	],
  	[
  		64622,
  		1,
  		"بى"
  	],
  	[
  		64623,
  		1,
  		"بي"
  	],
  	[
  		64624,
  		1,
  		"تر"
  	],
  	[
  		64625,
  		1,
  		"تز"
  	],
  	[
  		64626,
  		1,
  		"تم"
  	],
  	[
  		64627,
  		1,
  		"تن"
  	],
  	[
  		64628,
  		1,
  		"تى"
  	],
  	[
  		64629,
  		1,
  		"تي"
  	],
  	[
  		64630,
  		1,
  		"ثر"
  	],
  	[
  		64631,
  		1,
  		"ثز"
  	],
  	[
  		64632,
  		1,
  		"ثم"
  	],
  	[
  		64633,
  		1,
  		"ثن"
  	],
  	[
  		64634,
  		1,
  		"ثى"
  	],
  	[
  		64635,
  		1,
  		"ثي"
  	],
  	[
  		64636,
  		1,
  		"فى"
  	],
  	[
  		64637,
  		1,
  		"في"
  	],
  	[
  		64638,
  		1,
  		"قى"
  	],
  	[
  		64639,
  		1,
  		"قي"
  	],
  	[
  		64640,
  		1,
  		"كا"
  	],
  	[
  		64641,
  		1,
  		"كل"
  	],
  	[
  		64642,
  		1,
  		"كم"
  	],
  	[
  		64643,
  		1,
  		"كى"
  	],
  	[
  		64644,
  		1,
  		"كي"
  	],
  	[
  		64645,
  		1,
  		"لم"
  	],
  	[
  		64646,
  		1,
  		"لى"
  	],
  	[
  		64647,
  		1,
  		"لي"
  	],
  	[
  		64648,
  		1,
  		"ما"
  	],
  	[
  		64649,
  		1,
  		"مم"
  	],
  	[
  		64650,
  		1,
  		"نر"
  	],
  	[
  		64651,
  		1,
  		"نز"
  	],
  	[
  		64652,
  		1,
  		"نم"
  	],
  	[
  		64653,
  		1,
  		"نن"
  	],
  	[
  		64654,
  		1,
  		"نى"
  	],
  	[
  		64655,
  		1,
  		"ني"
  	],
  	[
  		64656,
  		1,
  		"ىٰ"
  	],
  	[
  		64657,
  		1,
  		"ير"
  	],
  	[
  		64658,
  		1,
  		"يز"
  	],
  	[
  		64659,
  		1,
  		"يم"
  	],
  	[
  		64660,
  		1,
  		"ين"
  	],
  	[
  		64661,
  		1,
  		"يى"
  	],
  	[
  		64662,
  		1,
  		"يي"
  	],
  	[
  		64663,
  		1,
  		"ئج"
  	],
  	[
  		64664,
  		1,
  		"ئح"
  	],
  	[
  		64665,
  		1,
  		"ئخ"
  	],
  	[
  		64666,
  		1,
  		"ئم"
  	],
  	[
  		64667,
  		1,
  		"ئه"
  	],
  	[
  		64668,
  		1,
  		"بج"
  	],
  	[
  		64669,
  		1,
  		"بح"
  	],
  	[
  		64670,
  		1,
  		"بخ"
  	],
  	[
  		64671,
  		1,
  		"بم"
  	],
  	[
  		64672,
  		1,
  		"به"
  	],
  	[
  		64673,
  		1,
  		"تج"
  	],
  	[
  		64674,
  		1,
  		"تح"
  	],
  	[
  		64675,
  		1,
  		"تخ"
  	],
  	[
  		64676,
  		1,
  		"تم"
  	],
  	[
  		64677,
  		1,
  		"ته"
  	],
  	[
  		64678,
  		1,
  		"ثم"
  	],
  	[
  		64679,
  		1,
  		"جح"
  	],
  	[
  		64680,
  		1,
  		"جم"
  	],
  	[
  		64681,
  		1,
  		"حج"
  	],
  	[
  		64682,
  		1,
  		"حم"
  	],
  	[
  		64683,
  		1,
  		"خج"
  	],
  	[
  		64684,
  		1,
  		"خم"
  	],
  	[
  		64685,
  		1,
  		"سج"
  	],
  	[
  		64686,
  		1,
  		"سح"
  	],
  	[
  		64687,
  		1,
  		"سخ"
  	],
  	[
  		64688,
  		1,
  		"سم"
  	],
  	[
  		64689,
  		1,
  		"صح"
  	],
  	[
  		64690,
  		1,
  		"صخ"
  	],
  	[
  		64691,
  		1,
  		"صم"
  	],
  	[
  		64692,
  		1,
  		"ضج"
  	],
  	[
  		64693,
  		1,
  		"ضح"
  	],
  	[
  		64694,
  		1,
  		"ضخ"
  	],
  	[
  		64695,
  		1,
  		"ضم"
  	],
  	[
  		64696,
  		1,
  		"طح"
  	],
  	[
  		64697,
  		1,
  		"ظم"
  	],
  	[
  		64698,
  		1,
  		"عج"
  	],
  	[
  		64699,
  		1,
  		"عم"
  	],
  	[
  		64700,
  		1,
  		"غج"
  	],
  	[
  		64701,
  		1,
  		"غم"
  	],
  	[
  		64702,
  		1,
  		"فج"
  	],
  	[
  		64703,
  		1,
  		"فح"
  	],
  	[
  		64704,
  		1,
  		"فخ"
  	],
  	[
  		64705,
  		1,
  		"فم"
  	],
  	[
  		64706,
  		1,
  		"قح"
  	],
  	[
  		64707,
  		1,
  		"قم"
  	],
  	[
  		64708,
  		1,
  		"كج"
  	],
  	[
  		64709,
  		1,
  		"كح"
  	],
  	[
  		64710,
  		1,
  		"كخ"
  	],
  	[
  		64711,
  		1,
  		"كل"
  	],
  	[
  		64712,
  		1,
  		"كم"
  	],
  	[
  		64713,
  		1,
  		"لج"
  	],
  	[
  		64714,
  		1,
  		"لح"
  	],
  	[
  		64715,
  		1,
  		"لخ"
  	],
  	[
  		64716,
  		1,
  		"لم"
  	],
  	[
  		64717,
  		1,
  		"له"
  	],
  	[
  		64718,
  		1,
  		"مج"
  	],
  	[
  		64719,
  		1,
  		"مح"
  	],
  	[
  		64720,
  		1,
  		"مخ"
  	],
  	[
  		64721,
  		1,
  		"مم"
  	],
  	[
  		64722,
  		1,
  		"نج"
  	],
  	[
  		64723,
  		1,
  		"نح"
  	],
  	[
  		64724,
  		1,
  		"نخ"
  	],
  	[
  		64725,
  		1,
  		"نم"
  	],
  	[
  		64726,
  		1,
  		"نه"
  	],
  	[
  		64727,
  		1,
  		"هج"
  	],
  	[
  		64728,
  		1,
  		"هم"
  	],
  	[
  		64729,
  		1,
  		"هٰ"
  	],
  	[
  		64730,
  		1,
  		"يج"
  	],
  	[
  		64731,
  		1,
  		"يح"
  	],
  	[
  		64732,
  		1,
  		"يخ"
  	],
  	[
  		64733,
  		1,
  		"يم"
  	],
  	[
  		64734,
  		1,
  		"يه"
  	],
  	[
  		64735,
  		1,
  		"ئم"
  	],
  	[
  		64736,
  		1,
  		"ئه"
  	],
  	[
  		64737,
  		1,
  		"بم"
  	],
  	[
  		64738,
  		1,
  		"به"
  	],
  	[
  		64739,
  		1,
  		"تم"
  	],
  	[
  		64740,
  		1,
  		"ته"
  	],
  	[
  		64741,
  		1,
  		"ثم"
  	],
  	[
  		64742,
  		1,
  		"ثه"
  	],
  	[
  		64743,
  		1,
  		"سم"
  	],
  	[
  		64744,
  		1,
  		"سه"
  	],
  	[
  		64745,
  		1,
  		"شم"
  	],
  	[
  		64746,
  		1,
  		"شه"
  	],
  	[
  		64747,
  		1,
  		"كل"
  	],
  	[
  		64748,
  		1,
  		"كم"
  	],
  	[
  		64749,
  		1,
  		"لم"
  	],
  	[
  		64750,
  		1,
  		"نم"
  	],
  	[
  		64751,
  		1,
  		"نه"
  	],
  	[
  		64752,
  		1,
  		"يم"
  	],
  	[
  		64753,
  		1,
  		"يه"
  	],
  	[
  		64754,
  		1,
  		"ـَّ"
  	],
  	[
  		64755,
  		1,
  		"ـُّ"
  	],
  	[
  		64756,
  		1,
  		"ـِّ"
  	],
  	[
  		64757,
  		1,
  		"طى"
  	],
  	[
  		64758,
  		1,
  		"طي"
  	],
  	[
  		64759,
  		1,
  		"عى"
  	],
  	[
  		64760,
  		1,
  		"عي"
  	],
  	[
  		64761,
  		1,
  		"غى"
  	],
  	[
  		64762,
  		1,
  		"غي"
  	],
  	[
  		64763,
  		1,
  		"سى"
  	],
  	[
  		64764,
  		1,
  		"سي"
  	],
  	[
  		64765,
  		1,
  		"شى"
  	],
  	[
  		64766,
  		1,
  		"شي"
  	],
  	[
  		64767,
  		1,
  		"حى"
  	],
  	[
  		64768,
  		1,
  		"حي"
  	],
  	[
  		64769,
  		1,
  		"جى"
  	],
  	[
  		64770,
  		1,
  		"جي"
  	],
  	[
  		64771,
  		1,
  		"خى"
  	],
  	[
  		64772,
  		1,
  		"خي"
  	],
  	[
  		64773,
  		1,
  		"صى"
  	],
  	[
  		64774,
  		1,
  		"صي"
  	],
  	[
  		64775,
  		1,
  		"ضى"
  	],
  	[
  		64776,
  		1,
  		"ضي"
  	],
  	[
  		64777,
  		1,
  		"شج"
  	],
  	[
  		64778,
  		1,
  		"شح"
  	],
  	[
  		64779,
  		1,
  		"شخ"
  	],
  	[
  		64780,
  		1,
  		"شم"
  	],
  	[
  		64781,
  		1,
  		"شر"
  	],
  	[
  		64782,
  		1,
  		"سر"
  	],
  	[
  		64783,
  		1,
  		"صر"
  	],
  	[
  		64784,
  		1,
  		"ضر"
  	],
  	[
  		64785,
  		1,
  		"طى"
  	],
  	[
  		64786,
  		1,
  		"طي"
  	],
  	[
  		64787,
  		1,
  		"عى"
  	],
  	[
  		64788,
  		1,
  		"عي"
  	],
  	[
  		64789,
  		1,
  		"غى"
  	],
  	[
  		64790,
  		1,
  		"غي"
  	],
  	[
  		64791,
  		1,
  		"سى"
  	],
  	[
  		64792,
  		1,
  		"سي"
  	],
  	[
  		64793,
  		1,
  		"شى"
  	],
  	[
  		64794,
  		1,
  		"شي"
  	],
  	[
  		64795,
  		1,
  		"حى"
  	],
  	[
  		64796,
  		1,
  		"حي"
  	],
  	[
  		64797,
  		1,
  		"جى"
  	],
  	[
  		64798,
  		1,
  		"جي"
  	],
  	[
  		64799,
  		1,
  		"خى"
  	],
  	[
  		64800,
  		1,
  		"خي"
  	],
  	[
  		64801,
  		1,
  		"صى"
  	],
  	[
  		64802,
  		1,
  		"صي"
  	],
  	[
  		64803,
  		1,
  		"ضى"
  	],
  	[
  		64804,
  		1,
  		"ضي"
  	],
  	[
  		64805,
  		1,
  		"شج"
  	],
  	[
  		64806,
  		1,
  		"شح"
  	],
  	[
  		64807,
  		1,
  		"شخ"
  	],
  	[
  		64808,
  		1,
  		"شم"
  	],
  	[
  		64809,
  		1,
  		"شر"
  	],
  	[
  		64810,
  		1,
  		"سر"
  	],
  	[
  		64811,
  		1,
  		"صر"
  	],
  	[
  		64812,
  		1,
  		"ضر"
  	],
  	[
  		64813,
  		1,
  		"شج"
  	],
  	[
  		64814,
  		1,
  		"شح"
  	],
  	[
  		64815,
  		1,
  		"شخ"
  	],
  	[
  		64816,
  		1,
  		"شم"
  	],
  	[
  		64817,
  		1,
  		"سه"
  	],
  	[
  		64818,
  		1,
  		"شه"
  	],
  	[
  		64819,
  		1,
  		"طم"
  	],
  	[
  		64820,
  		1,
  		"سج"
  	],
  	[
  		64821,
  		1,
  		"سح"
  	],
  	[
  		64822,
  		1,
  		"سخ"
  	],
  	[
  		64823,
  		1,
  		"شج"
  	],
  	[
  		64824,
  		1,
  		"شح"
  	],
  	[
  		64825,
  		1,
  		"شخ"
  	],
  	[
  		64826,
  		1,
  		"طم"
  	],
  	[
  		64827,
  		1,
  		"ظم"
  	],
  	[
  		[
  			64828,
  			64829
  		],
  		1,
  		"اً"
  	],
  	[
  		[
  			64830,
  			64831
  		],
  		2
  	],
  	[
  		[
  			64832,
  			64847
  		],
  		3
  	],
  	[
  		64848,
  		1,
  		"تجم"
  	],
  	[
  		[
  			64849,
  			64850
  		],
  		1,
  		"تحج"
  	],
  	[
  		64851,
  		1,
  		"تحم"
  	],
  	[
  		64852,
  		1,
  		"تخم"
  	],
  	[
  		64853,
  		1,
  		"تمج"
  	],
  	[
  		64854,
  		1,
  		"تمح"
  	],
  	[
  		64855,
  		1,
  		"تمخ"
  	],
  	[
  		[
  			64856,
  			64857
  		],
  		1,
  		"جمح"
  	],
  	[
  		64858,
  		1,
  		"حمي"
  	],
  	[
  		64859,
  		1,
  		"حمى"
  	],
  	[
  		64860,
  		1,
  		"سحج"
  	],
  	[
  		64861,
  		1,
  		"سجح"
  	],
  	[
  		64862,
  		1,
  		"سجى"
  	],
  	[
  		[
  			64863,
  			64864
  		],
  		1,
  		"سمح"
  	],
  	[
  		64865,
  		1,
  		"سمج"
  	],
  	[
  		[
  			64866,
  			64867
  		],
  		1,
  		"سمم"
  	],
  	[
  		[
  			64868,
  			64869
  		],
  		1,
  		"صحح"
  	],
  	[
  		64870,
  		1,
  		"صمم"
  	],
  	[
  		[
  			64871,
  			64872
  		],
  		1,
  		"شحم"
  	],
  	[
  		64873,
  		1,
  		"شجي"
  	],
  	[
  		[
  			64874,
  			64875
  		],
  		1,
  		"شمخ"
  	],
  	[
  		[
  			64876,
  			64877
  		],
  		1,
  		"شمم"
  	],
  	[
  		64878,
  		1,
  		"ضحى"
  	],
  	[
  		[
  			64879,
  			64880
  		],
  		1,
  		"ضخم"
  	],
  	[
  		[
  			64881,
  			64882
  		],
  		1,
  		"طمح"
  	],
  	[
  		64883,
  		1,
  		"طمم"
  	],
  	[
  		64884,
  		1,
  		"طمي"
  	],
  	[
  		64885,
  		1,
  		"عجم"
  	],
  	[
  		[
  			64886,
  			64887
  		],
  		1,
  		"عمم"
  	],
  	[
  		64888,
  		1,
  		"عمى"
  	],
  	[
  		64889,
  		1,
  		"غمم"
  	],
  	[
  		64890,
  		1,
  		"غمي"
  	],
  	[
  		64891,
  		1,
  		"غمى"
  	],
  	[
  		[
  			64892,
  			64893
  		],
  		1,
  		"فخم"
  	],
  	[
  		64894,
  		1,
  		"قمح"
  	],
  	[
  		64895,
  		1,
  		"قمم"
  	],
  	[
  		64896,
  		1,
  		"لحم"
  	],
  	[
  		64897,
  		1,
  		"لحي"
  	],
  	[
  		64898,
  		1,
  		"لحى"
  	],
  	[
  		[
  			64899,
  			64900
  		],
  		1,
  		"لجج"
  	],
  	[
  		[
  			64901,
  			64902
  		],
  		1,
  		"لخم"
  	],
  	[
  		[
  			64903,
  			64904
  		],
  		1,
  		"لمح"
  	],
  	[
  		64905,
  		1,
  		"محج"
  	],
  	[
  		64906,
  		1,
  		"محم"
  	],
  	[
  		64907,
  		1,
  		"محي"
  	],
  	[
  		64908,
  		1,
  		"مجح"
  	],
  	[
  		64909,
  		1,
  		"مجم"
  	],
  	[
  		64910,
  		1,
  		"مخج"
  	],
  	[
  		64911,
  		1,
  		"مخم"
  	],
  	[
  		[
  			64912,
  			64913
  		],
  		3
  	],
  	[
  		64914,
  		1,
  		"مجخ"
  	],
  	[
  		64915,
  		1,
  		"همج"
  	],
  	[
  		64916,
  		1,
  		"همم"
  	],
  	[
  		64917,
  		1,
  		"نحم"
  	],
  	[
  		64918,
  		1,
  		"نحى"
  	],
  	[
  		[
  			64919,
  			64920
  		],
  		1,
  		"نجم"
  	],
  	[
  		64921,
  		1,
  		"نجى"
  	],
  	[
  		64922,
  		1,
  		"نمي"
  	],
  	[
  		64923,
  		1,
  		"نمى"
  	],
  	[
  		[
  			64924,
  			64925
  		],
  		1,
  		"يمم"
  	],
  	[
  		64926,
  		1,
  		"بخي"
  	],
  	[
  		64927,
  		1,
  		"تجي"
  	],
  	[
  		64928,
  		1,
  		"تجى"
  	],
  	[
  		64929,
  		1,
  		"تخي"
  	],
  	[
  		64930,
  		1,
  		"تخى"
  	],
  	[
  		64931,
  		1,
  		"تمي"
  	],
  	[
  		64932,
  		1,
  		"تمى"
  	],
  	[
  		64933,
  		1,
  		"جمي"
  	],
  	[
  		64934,
  		1,
  		"جحى"
  	],
  	[
  		64935,
  		1,
  		"جمى"
  	],
  	[
  		64936,
  		1,
  		"سخى"
  	],
  	[
  		64937,
  		1,
  		"صحي"
  	],
  	[
  		64938,
  		1,
  		"شحي"
  	],
  	[
  		64939,
  		1,
  		"ضحي"
  	],
  	[
  		64940,
  		1,
  		"لجي"
  	],
  	[
  		64941,
  		1,
  		"لمي"
  	],
  	[
  		64942,
  		1,
  		"يحي"
  	],
  	[
  		64943,
  		1,
  		"يجي"
  	],
  	[
  		64944,
  		1,
  		"يمي"
  	],
  	[
  		64945,
  		1,
  		"ممي"
  	],
  	[
  		64946,
  		1,
  		"قمي"
  	],
  	[
  		64947,
  		1,
  		"نحي"
  	],
  	[
  		64948,
  		1,
  		"قمح"
  	],
  	[
  		64949,
  		1,
  		"لحم"
  	],
  	[
  		64950,
  		1,
  		"عمي"
  	],
  	[
  		64951,
  		1,
  		"كمي"
  	],
  	[
  		64952,
  		1,
  		"نجح"
  	],
  	[
  		64953,
  		1,
  		"مخي"
  	],
  	[
  		64954,
  		1,
  		"لجم"
  	],
  	[
  		64955,
  		1,
  		"كمم"
  	],
  	[
  		64956,
  		1,
  		"لجم"
  	],
  	[
  		64957,
  		1,
  		"نجح"
  	],
  	[
  		64958,
  		1,
  		"جحي"
  	],
  	[
  		64959,
  		1,
  		"حجي"
  	],
  	[
  		64960,
  		1,
  		"مجي"
  	],
  	[
  		64961,
  		1,
  		"فمي"
  	],
  	[
  		64962,
  		1,
  		"بحي"
  	],
  	[
  		64963,
  		1,
  		"كمم"
  	],
  	[
  		64964,
  		1,
  		"عجم"
  	],
  	[
  		64965,
  		1,
  		"صمم"
  	],
  	[
  		64966,
  		1,
  		"سخي"
  	],
  	[
  		64967,
  		1,
  		"نجي"
  	],
  	[
  		[
  			64968,
  			64975
  		],
  		3
  	],
  	[
  		[
  			64976,
  			65007
  		],
  		3
  	],
  	[
  		65008,
  		1,
  		"صلے"
  	],
  	[
  		65009,
  		1,
  		"قلے"
  	],
  	[
  		65010,
  		1,
  		"الله"
  	],
  	[
  		65011,
  		1,
  		"اكبر"
  	],
  	[
  		65012,
  		1,
  		"محمد"
  	],
  	[
  		65013,
  		1,
  		"صلعم"
  	],
  	[
  		65014,
  		1,
  		"رسول"
  	],
  	[
  		65015,
  		1,
  		"عليه"
  	],
  	[
  		65016,
  		1,
  		"وسلم"
  	],
  	[
  		65017,
  		1,
  		"صلى"
  	],
  	[
  		65018,
  		5,
  		"صلى الله عليه وسلم"
  	],
  	[
  		65019,
  		5,
  		"جل جلاله"
  	],
  	[
  		65020,
  		1,
  		"ریال"
  	],
  	[
  		65021,
  		2
  	],
  	[
  		[
  			65022,
  			65023
  		],
  		3
  	],
  	[
  		[
  			65024,
  			65039
  		],
  		7
  	],
  	[
  		65040,
  		5,
  		","
  	],
  	[
  		65041,
  		1,
  		"、"
  	],
  	[
  		65042,
  		3
  	],
  	[
  		65043,
  		5,
  		":"
  	],
  	[
  		65044,
  		5,
  		";"
  	],
  	[
  		65045,
  		5,
  		"!"
  	],
  	[
  		65046,
  		5,
  		"?"
  	],
  	[
  		65047,
  		1,
  		"〖"
  	],
  	[
  		65048,
  		1,
  		"〗"
  	],
  	[
  		65049,
  		3
  	],
  	[
  		[
  			65050,
  			65055
  		],
  		3
  	],
  	[
  		[
  			65056,
  			65059
  		],
  		2
  	],
  	[
  		[
  			65060,
  			65062
  		],
  		2
  	],
  	[
  		[
  			65063,
  			65069
  		],
  		2
  	],
  	[
  		[
  			65070,
  			65071
  		],
  		2
  	],
  	[
  		65072,
  		3
  	],
  	[
  		65073,
  		1,
  		"—"
  	],
  	[
  		65074,
  		1,
  		"–"
  	],
  	[
  		[
  			65075,
  			65076
  		],
  		5,
  		"_"
  	],
  	[
  		65077,
  		5,
  		"("
  	],
  	[
  		65078,
  		5,
  		")"
  	],
  	[
  		65079,
  		5,
  		"{"
  	],
  	[
  		65080,
  		5,
  		"}"
  	],
  	[
  		65081,
  		1,
  		"〔"
  	],
  	[
  		65082,
  		1,
  		"〕"
  	],
  	[
  		65083,
  		1,
  		"【"
  	],
  	[
  		65084,
  		1,
  		"】"
  	],
  	[
  		65085,
  		1,
  		"《"
  	],
  	[
  		65086,
  		1,
  		"》"
  	],
  	[
  		65087,
  		1,
  		"〈"
  	],
  	[
  		65088,
  		1,
  		"〉"
  	],
  	[
  		65089,
  		1,
  		"「"
  	],
  	[
  		65090,
  		1,
  		"」"
  	],
  	[
  		65091,
  		1,
  		"『"
  	],
  	[
  		65092,
  		1,
  		"』"
  	],
  	[
  		[
  			65093,
  			65094
  		],
  		2
  	],
  	[
  		65095,
  		5,
  		"["
  	],
  	[
  		65096,
  		5,
  		"]"
  	],
  	[
  		[
  			65097,
  			65100
  		],
  		5,
  		" ̅"
  	],
  	[
  		[
  			65101,
  			65103
  		],
  		5,
  		"_"
  	],
  	[
  		65104,
  		5,
  		","
  	],
  	[
  		65105,
  		1,
  		"、"
  	],
  	[
  		65106,
  		3
  	],
  	[
  		65107,
  		3
  	],
  	[
  		65108,
  		5,
  		";"
  	],
  	[
  		65109,
  		5,
  		":"
  	],
  	[
  		65110,
  		5,
  		"?"
  	],
  	[
  		65111,
  		5,
  		"!"
  	],
  	[
  		65112,
  		1,
  		"—"
  	],
  	[
  		65113,
  		5,
  		"("
  	],
  	[
  		65114,
  		5,
  		")"
  	],
  	[
  		65115,
  		5,
  		"{"
  	],
  	[
  		65116,
  		5,
  		"}"
  	],
  	[
  		65117,
  		1,
  		"〔"
  	],
  	[
  		65118,
  		1,
  		"〕"
  	],
  	[
  		65119,
  		5,
  		"#"
  	],
  	[
  		65120,
  		5,
  		"&"
  	],
  	[
  		65121,
  		5,
  		"*"
  	],
  	[
  		65122,
  		5,
  		"+"
  	],
  	[
  		65123,
  		1,
  		"-"
  	],
  	[
  		65124,
  		5,
  		"<"
  	],
  	[
  		65125,
  		5,
  		">"
  	],
  	[
  		65126,
  		5,
  		"="
  	],
  	[
  		65127,
  		3
  	],
  	[
  		65128,
  		5,
  		"\\"
  	],
  	[
  		65129,
  		5,
  		"$"
  	],
  	[
  		65130,
  		5,
  		"%"
  	],
  	[
  		65131,
  		5,
  		"@"
  	],
  	[
  		[
  			65132,
  			65135
  		],
  		3
  	],
  	[
  		65136,
  		5,
  		" ً"
  	],
  	[
  		65137,
  		1,
  		"ـً"
  	],
  	[
  		65138,
  		5,
  		" ٌ"
  	],
  	[
  		65139,
  		2
  	],
  	[
  		65140,
  		5,
  		" ٍ"
  	],
  	[
  		65141,
  		3
  	],
  	[
  		65142,
  		5,
  		" َ"
  	],
  	[
  		65143,
  		1,
  		"ـَ"
  	],
  	[
  		65144,
  		5,
  		" ُ"
  	],
  	[
  		65145,
  		1,
  		"ـُ"
  	],
  	[
  		65146,
  		5,
  		" ِ"
  	],
  	[
  		65147,
  		1,
  		"ـِ"
  	],
  	[
  		65148,
  		5,
  		" ّ"
  	],
  	[
  		65149,
  		1,
  		"ـّ"
  	],
  	[
  		65150,
  		5,
  		" ْ"
  	],
  	[
  		65151,
  		1,
  		"ـْ"
  	],
  	[
  		65152,
  		1,
  		"ء"
  	],
  	[
  		[
  			65153,
  			65154
  		],
  		1,
  		"آ"
  	],
  	[
  		[
  			65155,
  			65156
  		],
  		1,
  		"أ"
  	],
  	[
  		[
  			65157,
  			65158
  		],
  		1,
  		"ؤ"
  	],
  	[
  		[
  			65159,
  			65160
  		],
  		1,
  		"إ"
  	],
  	[
  		[
  			65161,
  			65164
  		],
  		1,
  		"ئ"
  	],
  	[
  		[
  			65165,
  			65166
  		],
  		1,
  		"ا"
  	],
  	[
  		[
  			65167,
  			65170
  		],
  		1,
  		"ب"
  	],
  	[
  		[
  			65171,
  			65172
  		],
  		1,
  		"ة"
  	],
  	[
  		[
  			65173,
  			65176
  		],
  		1,
  		"ت"
  	],
  	[
  		[
  			65177,
  			65180
  		],
  		1,
  		"ث"
  	],
  	[
  		[
  			65181,
  			65184
  		],
  		1,
  		"ج"
  	],
  	[
  		[
  			65185,
  			65188
  		],
  		1,
  		"ح"
  	],
  	[
  		[
  			65189,
  			65192
  		],
  		1,
  		"خ"
  	],
  	[
  		[
  			65193,
  			65194
  		],
  		1,
  		"د"
  	],
  	[
  		[
  			65195,
  			65196
  		],
  		1,
  		"ذ"
  	],
  	[
  		[
  			65197,
  			65198
  		],
  		1,
  		"ر"
  	],
  	[
  		[
  			65199,
  			65200
  		],
  		1,
  		"ز"
  	],
  	[
  		[
  			65201,
  			65204
  		],
  		1,
  		"س"
  	],
  	[
  		[
  			65205,
  			65208
  		],
  		1,
  		"ش"
  	],
  	[
  		[
  			65209,
  			65212
  		],
  		1,
  		"ص"
  	],
  	[
  		[
  			65213,
  			65216
  		],
  		1,
  		"ض"
  	],
  	[
  		[
  			65217,
  			65220
  		],
  		1,
  		"ط"
  	],
  	[
  		[
  			65221,
  			65224
  		],
  		1,
  		"ظ"
  	],
  	[
  		[
  			65225,
  			65228
  		],
  		1,
  		"ع"
  	],
  	[
  		[
  			65229,
  			65232
  		],
  		1,
  		"غ"
  	],
  	[
  		[
  			65233,
  			65236
  		],
  		1,
  		"ف"
  	],
  	[
  		[
  			65237,
  			65240
  		],
  		1,
  		"ق"
  	],
  	[
  		[
  			65241,
  			65244
  		],
  		1,
  		"ك"
  	],
  	[
  		[
  			65245,
  			65248
  		],
  		1,
  		"ل"
  	],
  	[
  		[
  			65249,
  			65252
  		],
  		1,
  		"م"
  	],
  	[
  		[
  			65253,
  			65256
  		],
  		1,
  		"ن"
  	],
  	[
  		[
  			65257,
  			65260
  		],
  		1,
  		"ه"
  	],
  	[
  		[
  			65261,
  			65262
  		],
  		1,
  		"و"
  	],
  	[
  		[
  			65263,
  			65264
  		],
  		1,
  		"ى"
  	],
  	[
  		[
  			65265,
  			65268
  		],
  		1,
  		"ي"
  	],
  	[
  		[
  			65269,
  			65270
  		],
  		1,
  		"لآ"
  	],
  	[
  		[
  			65271,
  			65272
  		],
  		1,
  		"لأ"
  	],
  	[
  		[
  			65273,
  			65274
  		],
  		1,
  		"لإ"
  	],
  	[
  		[
  			65275,
  			65276
  		],
  		1,
  		"لا"
  	],
  	[
  		[
  			65277,
  			65278
  		],
  		3
  	],
  	[
  		65279,
  		7
  	],
  	[
  		65280,
  		3
  	],
  	[
  		65281,
  		5,
  		"!"
  	],
  	[
  		65282,
  		5,
  		"\""
  	],
  	[
  		65283,
  		5,
  		"#"
  	],
  	[
  		65284,
  		5,
  		"$"
  	],
  	[
  		65285,
  		5,
  		"%"
  	],
  	[
  		65286,
  		5,
  		"&"
  	],
  	[
  		65287,
  		5,
  		"'"
  	],
  	[
  		65288,
  		5,
  		"("
  	],
  	[
  		65289,
  		5,
  		")"
  	],
  	[
  		65290,
  		5,
  		"*"
  	],
  	[
  		65291,
  		5,
  		"+"
  	],
  	[
  		65292,
  		5,
  		","
  	],
  	[
  		65293,
  		1,
  		"-"
  	],
  	[
  		65294,
  		1,
  		"."
  	],
  	[
  		65295,
  		5,
  		"/"
  	],
  	[
  		65296,
  		1,
  		"0"
  	],
  	[
  		65297,
  		1,
  		"1"
  	],
  	[
  		65298,
  		1,
  		"2"
  	],
  	[
  		65299,
  		1,
  		"3"
  	],
  	[
  		65300,
  		1,
  		"4"
  	],
  	[
  		65301,
  		1,
  		"5"
  	],
  	[
  		65302,
  		1,
  		"6"
  	],
  	[
  		65303,
  		1,
  		"7"
  	],
  	[
  		65304,
  		1,
  		"8"
  	],
  	[
  		65305,
  		1,
  		"9"
  	],
  	[
  		65306,
  		5,
  		":"
  	],
  	[
  		65307,
  		5,
  		";"
  	],
  	[
  		65308,
  		5,
  		"<"
  	],
  	[
  		65309,
  		5,
  		"="
  	],
  	[
  		65310,
  		5,
  		">"
  	],
  	[
  		65311,
  		5,
  		"?"
  	],
  	[
  		65312,
  		5,
  		"@"
  	],
  	[
  		65313,
  		1,
  		"a"
  	],
  	[
  		65314,
  		1,
  		"b"
  	],
  	[
  		65315,
  		1,
  		"c"
  	],
  	[
  		65316,
  		1,
  		"d"
  	],
  	[
  		65317,
  		1,
  		"e"
  	],
  	[
  		65318,
  		1,
  		"f"
  	],
  	[
  		65319,
  		1,
  		"g"
  	],
  	[
  		65320,
  		1,
  		"h"
  	],
  	[
  		65321,
  		1,
  		"i"
  	],
  	[
  		65322,
  		1,
  		"j"
  	],
  	[
  		65323,
  		1,
  		"k"
  	],
  	[
  		65324,
  		1,
  		"l"
  	],
  	[
  		65325,
  		1,
  		"m"
  	],
  	[
  		65326,
  		1,
  		"n"
  	],
  	[
  		65327,
  		1,
  		"o"
  	],
  	[
  		65328,
  		1,
  		"p"
  	],
  	[
  		65329,
  		1,
  		"q"
  	],
  	[
  		65330,
  		1,
  		"r"
  	],
  	[
  		65331,
  		1,
  		"s"
  	],
  	[
  		65332,
  		1,
  		"t"
  	],
  	[
  		65333,
  		1,
  		"u"
  	],
  	[
  		65334,
  		1,
  		"v"
  	],
  	[
  		65335,
  		1,
  		"w"
  	],
  	[
  		65336,
  		1,
  		"x"
  	],
  	[
  		65337,
  		1,
  		"y"
  	],
  	[
  		65338,
  		1,
  		"z"
  	],
  	[
  		65339,
  		5,
  		"["
  	],
  	[
  		65340,
  		5,
  		"\\"
  	],
  	[
  		65341,
  		5,
  		"]"
  	],
  	[
  		65342,
  		5,
  		"^"
  	],
  	[
  		65343,
  		5,
  		"_"
  	],
  	[
  		65344,
  		5,
  		"`"
  	],
  	[
  		65345,
  		1,
  		"a"
  	],
  	[
  		65346,
  		1,
  		"b"
  	],
  	[
  		65347,
  		1,
  		"c"
  	],
  	[
  		65348,
  		1,
  		"d"
  	],
  	[
  		65349,
  		1,
  		"e"
  	],
  	[
  		65350,
  		1,
  		"f"
  	],
  	[
  		65351,
  		1,
  		"g"
  	],
  	[
  		65352,
  		1,
  		"h"
  	],
  	[
  		65353,
  		1,
  		"i"
  	],
  	[
  		65354,
  		1,
  		"j"
  	],
  	[
  		65355,
  		1,
  		"k"
  	],
  	[
  		65356,
  		1,
  		"l"
  	],
  	[
  		65357,
  		1,
  		"m"
  	],
  	[
  		65358,
  		1,
  		"n"
  	],
  	[
  		65359,
  		1,
  		"o"
  	],
  	[
  		65360,
  		1,
  		"p"
  	],
  	[
  		65361,
  		1,
  		"q"
  	],
  	[
  		65362,
  		1,
  		"r"
  	],
  	[
  		65363,
  		1,
  		"s"
  	],
  	[
  		65364,
  		1,
  		"t"
  	],
  	[
  		65365,
  		1,
  		"u"
  	],
  	[
  		65366,
  		1,
  		"v"
  	],
  	[
  		65367,
  		1,
  		"w"
  	],
  	[
  		65368,
  		1,
  		"x"
  	],
  	[
  		65369,
  		1,
  		"y"
  	],
  	[
  		65370,
  		1,
  		"z"
  	],
  	[
  		65371,
  		5,
  		"{"
  	],
  	[
  		65372,
  		5,
  		"|"
  	],
  	[
  		65373,
  		5,
  		"}"
  	],
  	[
  		65374,
  		5,
  		"~"
  	],
  	[
  		65375,
  		1,
  		"⦅"
  	],
  	[
  		65376,
  		1,
  		"⦆"
  	],
  	[
  		65377,
  		1,
  		"."
  	],
  	[
  		65378,
  		1,
  		"「"
  	],
  	[
  		65379,
  		1,
  		"」"
  	],
  	[
  		65380,
  		1,
  		"、"
  	],
  	[
  		65381,
  		1,
  		"・"
  	],
  	[
  		65382,
  		1,
  		"ヲ"
  	],
  	[
  		65383,
  		1,
  		"ァ"
  	],
  	[
  		65384,
  		1,
  		"ィ"
  	],
  	[
  		65385,
  		1,
  		"ゥ"
  	],
  	[
  		65386,
  		1,
  		"ェ"
  	],
  	[
  		65387,
  		1,
  		"ォ"
  	],
  	[
  		65388,
  		1,
  		"ャ"
  	],
  	[
  		65389,
  		1,
  		"ュ"
  	],
  	[
  		65390,
  		1,
  		"ョ"
  	],
  	[
  		65391,
  		1,
  		"ッ"
  	],
  	[
  		65392,
  		1,
  		"ー"
  	],
  	[
  		65393,
  		1,
  		"ア"
  	],
  	[
  		65394,
  		1,
  		"イ"
  	],
  	[
  		65395,
  		1,
  		"ウ"
  	],
  	[
  		65396,
  		1,
  		"エ"
  	],
  	[
  		65397,
  		1,
  		"オ"
  	],
  	[
  		65398,
  		1,
  		"カ"
  	],
  	[
  		65399,
  		1,
  		"キ"
  	],
  	[
  		65400,
  		1,
  		"ク"
  	],
  	[
  		65401,
  		1,
  		"ケ"
  	],
  	[
  		65402,
  		1,
  		"コ"
  	],
  	[
  		65403,
  		1,
  		"サ"
  	],
  	[
  		65404,
  		1,
  		"シ"
  	],
  	[
  		65405,
  		1,
  		"ス"
  	],
  	[
  		65406,
  		1,
  		"セ"
  	],
  	[
  		65407,
  		1,
  		"ソ"
  	],
  	[
  		65408,
  		1,
  		"タ"
  	],
  	[
  		65409,
  		1,
  		"チ"
  	],
  	[
  		65410,
  		1,
  		"ツ"
  	],
  	[
  		65411,
  		1,
  		"テ"
  	],
  	[
  		65412,
  		1,
  		"ト"
  	],
  	[
  		65413,
  		1,
  		"ナ"
  	],
  	[
  		65414,
  		1,
  		"ニ"
  	],
  	[
  		65415,
  		1,
  		"ヌ"
  	],
  	[
  		65416,
  		1,
  		"ネ"
  	],
  	[
  		65417,
  		1,
  		"ノ"
  	],
  	[
  		65418,
  		1,
  		"ハ"
  	],
  	[
  		65419,
  		1,
  		"ヒ"
  	],
  	[
  		65420,
  		1,
  		"フ"
  	],
  	[
  		65421,
  		1,
  		"ヘ"
  	],
  	[
  		65422,
  		1,
  		"ホ"
  	],
  	[
  		65423,
  		1,
  		"マ"
  	],
  	[
  		65424,
  		1,
  		"ミ"
  	],
  	[
  		65425,
  		1,
  		"ム"
  	],
  	[
  		65426,
  		1,
  		"メ"
  	],
  	[
  		65427,
  		1,
  		"モ"
  	],
  	[
  		65428,
  		1,
  		"ヤ"
  	],
  	[
  		65429,
  		1,
  		"ユ"
  	],
  	[
  		65430,
  		1,
  		"ヨ"
  	],
  	[
  		65431,
  		1,
  		"ラ"
  	],
  	[
  		65432,
  		1,
  		"リ"
  	],
  	[
  		65433,
  		1,
  		"ル"
  	],
  	[
  		65434,
  		1,
  		"レ"
  	],
  	[
  		65435,
  		1,
  		"ロ"
  	],
  	[
  		65436,
  		1,
  		"ワ"
  	],
  	[
  		65437,
  		1,
  		"ン"
  	],
  	[
  		65438,
  		1,
  		"゙"
  	],
  	[
  		65439,
  		1,
  		"゚"
  	],
  	[
  		65440,
  		3
  	],
  	[
  		65441,
  		1,
  		"ᄀ"
  	],
  	[
  		65442,
  		1,
  		"ᄁ"
  	],
  	[
  		65443,
  		1,
  		"ᆪ"
  	],
  	[
  		65444,
  		1,
  		"ᄂ"
  	],
  	[
  		65445,
  		1,
  		"ᆬ"
  	],
  	[
  		65446,
  		1,
  		"ᆭ"
  	],
  	[
  		65447,
  		1,
  		"ᄃ"
  	],
  	[
  		65448,
  		1,
  		"ᄄ"
  	],
  	[
  		65449,
  		1,
  		"ᄅ"
  	],
  	[
  		65450,
  		1,
  		"ᆰ"
  	],
  	[
  		65451,
  		1,
  		"ᆱ"
  	],
  	[
  		65452,
  		1,
  		"ᆲ"
  	],
  	[
  		65453,
  		1,
  		"ᆳ"
  	],
  	[
  		65454,
  		1,
  		"ᆴ"
  	],
  	[
  		65455,
  		1,
  		"ᆵ"
  	],
  	[
  		65456,
  		1,
  		"ᄚ"
  	],
  	[
  		65457,
  		1,
  		"ᄆ"
  	],
  	[
  		65458,
  		1,
  		"ᄇ"
  	],
  	[
  		65459,
  		1,
  		"ᄈ"
  	],
  	[
  		65460,
  		1,
  		"ᄡ"
  	],
  	[
  		65461,
  		1,
  		"ᄉ"
  	],
  	[
  		65462,
  		1,
  		"ᄊ"
  	],
  	[
  		65463,
  		1,
  		"ᄋ"
  	],
  	[
  		65464,
  		1,
  		"ᄌ"
  	],
  	[
  		65465,
  		1,
  		"ᄍ"
  	],
  	[
  		65466,
  		1,
  		"ᄎ"
  	],
  	[
  		65467,
  		1,
  		"ᄏ"
  	],
  	[
  		65468,
  		1,
  		"ᄐ"
  	],
  	[
  		65469,
  		1,
  		"ᄑ"
  	],
  	[
  		65470,
  		1,
  		"ᄒ"
  	],
  	[
  		[
  			65471,
  			65473
  		],
  		3
  	],
  	[
  		65474,
  		1,
  		"ᅡ"
  	],
  	[
  		65475,
  		1,
  		"ᅢ"
  	],
  	[
  		65476,
  		1,
  		"ᅣ"
  	],
  	[
  		65477,
  		1,
  		"ᅤ"
  	],
  	[
  		65478,
  		1,
  		"ᅥ"
  	],
  	[
  		65479,
  		1,
  		"ᅦ"
  	],
  	[
  		[
  			65480,
  			65481
  		],
  		3
  	],
  	[
  		65482,
  		1,
  		"ᅧ"
  	],
  	[
  		65483,
  		1,
  		"ᅨ"
  	],
  	[
  		65484,
  		1,
  		"ᅩ"
  	],
  	[
  		65485,
  		1,
  		"ᅪ"
  	],
  	[
  		65486,
  		1,
  		"ᅫ"
  	],
  	[
  		65487,
  		1,
  		"ᅬ"
  	],
  	[
  		[
  			65488,
  			65489
  		],
  		3
  	],
  	[
  		65490,
  		1,
  		"ᅭ"
  	],
  	[
  		65491,
  		1,
  		"ᅮ"
  	],
  	[
  		65492,
  		1,
  		"ᅯ"
  	],
  	[
  		65493,
  		1,
  		"ᅰ"
  	],
  	[
  		65494,
  		1,
  		"ᅱ"
  	],
  	[
  		65495,
  		1,
  		"ᅲ"
  	],
  	[
  		[
  			65496,
  			65497
  		],
  		3
  	],
  	[
  		65498,
  		1,
  		"ᅳ"
  	],
  	[
  		65499,
  		1,
  		"ᅴ"
  	],
  	[
  		65500,
  		1,
  		"ᅵ"
  	],
  	[
  		[
  			65501,
  			65503
  		],
  		3
  	],
  	[
  		65504,
  		1,
  		"¢"
  	],
  	[
  		65505,
  		1,
  		"£"
  	],
  	[
  		65506,
  		1,
  		"¬"
  	],
  	[
  		65507,
  		5,
  		" ̄"
  	],
  	[
  		65508,
  		1,
  		"¦"
  	],
  	[
  		65509,
  		1,
  		"¥"
  	],
  	[
  		65510,
  		1,
  		"₩"
  	],
  	[
  		65511,
  		3
  	],
  	[
  		65512,
  		1,
  		"│"
  	],
  	[
  		65513,
  		1,
  		"←"
  	],
  	[
  		65514,
  		1,
  		"↑"
  	],
  	[
  		65515,
  		1,
  		"→"
  	],
  	[
  		65516,
  		1,
  		"↓"
  	],
  	[
  		65517,
  		1,
  		"■"
  	],
  	[
  		65518,
  		1,
  		"○"
  	],
  	[
  		[
  			65519,
  			65528
  		],
  		3
  	],
  	[
  		[
  			65529,
  			65531
  		],
  		3
  	],
  	[
  		65532,
  		3
  	],
  	[
  		65533,
  		3
  	],
  	[
  		[
  			65534,
  			65535
  		],
  		3
  	],
  	[
  		[
  			65536,
  			65547
  		],
  		2
  	],
  	[
  		65548,
  		3
  	],
  	[
  		[
  			65549,
  			65574
  		],
  		2
  	],
  	[
  		65575,
  		3
  	],
  	[
  		[
  			65576,
  			65594
  		],
  		2
  	],
  	[
  		65595,
  		3
  	],
  	[
  		[
  			65596,
  			65597
  		],
  		2
  	],
  	[
  		65598,
  		3
  	],
  	[
  		[
  			65599,
  			65613
  		],
  		2
  	],
  	[
  		[
  			65614,
  			65615
  		],
  		3
  	],
  	[
  		[
  			65616,
  			65629
  		],
  		2
  	],
  	[
  		[
  			65630,
  			65663
  		],
  		3
  	],
  	[
  		[
  			65664,
  			65786
  		],
  		2
  	],
  	[
  		[
  			65787,
  			65791
  		],
  		3
  	],
  	[
  		[
  			65792,
  			65794
  		],
  		2
  	],
  	[
  		[
  			65795,
  			65798
  		],
  		3
  	],
  	[
  		[
  			65799,
  			65843
  		],
  		2
  	],
  	[
  		[
  			65844,
  			65846
  		],
  		3
  	],
  	[
  		[
  			65847,
  			65855
  		],
  		2
  	],
  	[
  		[
  			65856,
  			65930
  		],
  		2
  	],
  	[
  		[
  			65931,
  			65932
  		],
  		2
  	],
  	[
  		[
  			65933,
  			65934
  		],
  		2
  	],
  	[
  		65935,
  		3
  	],
  	[
  		[
  			65936,
  			65947
  		],
  		2
  	],
  	[
  		65948,
  		2
  	],
  	[
  		[
  			65949,
  			65951
  		],
  		3
  	],
  	[
  		65952,
  		2
  	],
  	[
  		[
  			65953,
  			65999
  		],
  		3
  	],
  	[
  		[
  			66000,
  			66044
  		],
  		2
  	],
  	[
  		66045,
  		2
  	],
  	[
  		[
  			66046,
  			66175
  		],
  		3
  	],
  	[
  		[
  			66176,
  			66204
  		],
  		2
  	],
  	[
  		[
  			66205,
  			66207
  		],
  		3
  	],
  	[
  		[
  			66208,
  			66256
  		],
  		2
  	],
  	[
  		[
  			66257,
  			66271
  		],
  		3
  	],
  	[
  		66272,
  		2
  	],
  	[
  		[
  			66273,
  			66299
  		],
  		2
  	],
  	[
  		[
  			66300,
  			66303
  		],
  		3
  	],
  	[
  		[
  			66304,
  			66334
  		],
  		2
  	],
  	[
  		66335,
  		2
  	],
  	[
  		[
  			66336,
  			66339
  		],
  		2
  	],
  	[
  		[
  			66340,
  			66348
  		],
  		3
  	],
  	[
  		[
  			66349,
  			66351
  		],
  		2
  	],
  	[
  		[
  			66352,
  			66368
  		],
  		2
  	],
  	[
  		66369,
  		2
  	],
  	[
  		[
  			66370,
  			66377
  		],
  		2
  	],
  	[
  		66378,
  		2
  	],
  	[
  		[
  			66379,
  			66383
  		],
  		3
  	],
  	[
  		[
  			66384,
  			66426
  		],
  		2
  	],
  	[
  		[
  			66427,
  			66431
  		],
  		3
  	],
  	[
  		[
  			66432,
  			66461
  		],
  		2
  	],
  	[
  		66462,
  		3
  	],
  	[
  		66463,
  		2
  	],
  	[
  		[
  			66464,
  			66499
  		],
  		2
  	],
  	[
  		[
  			66500,
  			66503
  		],
  		3
  	],
  	[
  		[
  			66504,
  			66511
  		],
  		2
  	],
  	[
  		[
  			66512,
  			66517
  		],
  		2
  	],
  	[
  		[
  			66518,
  			66559
  		],
  		3
  	],
  	[
  		66560,
  		1,
  		"𐐨"
  	],
  	[
  		66561,
  		1,
  		"𐐩"
  	],
  	[
  		66562,
  		1,
  		"𐐪"
  	],
  	[
  		66563,
  		1,
  		"𐐫"
  	],
  	[
  		66564,
  		1,
  		"𐐬"
  	],
  	[
  		66565,
  		1,
  		"𐐭"
  	],
  	[
  		66566,
  		1,
  		"𐐮"
  	],
  	[
  		66567,
  		1,
  		"𐐯"
  	],
  	[
  		66568,
  		1,
  		"𐐰"
  	],
  	[
  		66569,
  		1,
  		"𐐱"
  	],
  	[
  		66570,
  		1,
  		"𐐲"
  	],
  	[
  		66571,
  		1,
  		"𐐳"
  	],
  	[
  		66572,
  		1,
  		"𐐴"
  	],
  	[
  		66573,
  		1,
  		"𐐵"
  	],
  	[
  		66574,
  		1,
  		"𐐶"
  	],
  	[
  		66575,
  		1,
  		"𐐷"
  	],
  	[
  		66576,
  		1,
  		"𐐸"
  	],
  	[
  		66577,
  		1,
  		"𐐹"
  	],
  	[
  		66578,
  		1,
  		"𐐺"
  	],
  	[
  		66579,
  		1,
  		"𐐻"
  	],
  	[
  		66580,
  		1,
  		"𐐼"
  	],
  	[
  		66581,
  		1,
  		"𐐽"
  	],
  	[
  		66582,
  		1,
  		"𐐾"
  	],
  	[
  		66583,
  		1,
  		"𐐿"
  	],
  	[
  		66584,
  		1,
  		"𐑀"
  	],
  	[
  		66585,
  		1,
  		"𐑁"
  	],
  	[
  		66586,
  		1,
  		"𐑂"
  	],
  	[
  		66587,
  		1,
  		"𐑃"
  	],
  	[
  		66588,
  		1,
  		"𐑄"
  	],
  	[
  		66589,
  		1,
  		"𐑅"
  	],
  	[
  		66590,
  		1,
  		"𐑆"
  	],
  	[
  		66591,
  		1,
  		"𐑇"
  	],
  	[
  		66592,
  		1,
  		"𐑈"
  	],
  	[
  		66593,
  		1,
  		"𐑉"
  	],
  	[
  		66594,
  		1,
  		"𐑊"
  	],
  	[
  		66595,
  		1,
  		"𐑋"
  	],
  	[
  		66596,
  		1,
  		"𐑌"
  	],
  	[
  		66597,
  		1,
  		"𐑍"
  	],
  	[
  		66598,
  		1,
  		"𐑎"
  	],
  	[
  		66599,
  		1,
  		"𐑏"
  	],
  	[
  		[
  			66600,
  			66637
  		],
  		2
  	],
  	[
  		[
  			66638,
  			66717
  		],
  		2
  	],
  	[
  		[
  			66718,
  			66719
  		],
  		3
  	],
  	[
  		[
  			66720,
  			66729
  		],
  		2
  	],
  	[
  		[
  			66730,
  			66735
  		],
  		3
  	],
  	[
  		66736,
  		1,
  		"𐓘"
  	],
  	[
  		66737,
  		1,
  		"𐓙"
  	],
  	[
  		66738,
  		1,
  		"𐓚"
  	],
  	[
  		66739,
  		1,
  		"𐓛"
  	],
  	[
  		66740,
  		1,
  		"𐓜"
  	],
  	[
  		66741,
  		1,
  		"𐓝"
  	],
  	[
  		66742,
  		1,
  		"𐓞"
  	],
  	[
  		66743,
  		1,
  		"𐓟"
  	],
  	[
  		66744,
  		1,
  		"𐓠"
  	],
  	[
  		66745,
  		1,
  		"𐓡"
  	],
  	[
  		66746,
  		1,
  		"𐓢"
  	],
  	[
  		66747,
  		1,
  		"𐓣"
  	],
  	[
  		66748,
  		1,
  		"𐓤"
  	],
  	[
  		66749,
  		1,
  		"𐓥"
  	],
  	[
  		66750,
  		1,
  		"𐓦"
  	],
  	[
  		66751,
  		1,
  		"𐓧"
  	],
  	[
  		66752,
  		1,
  		"𐓨"
  	],
  	[
  		66753,
  		1,
  		"𐓩"
  	],
  	[
  		66754,
  		1,
  		"𐓪"
  	],
  	[
  		66755,
  		1,
  		"𐓫"
  	],
  	[
  		66756,
  		1,
  		"𐓬"
  	],
  	[
  		66757,
  		1,
  		"𐓭"
  	],
  	[
  		66758,
  		1,
  		"𐓮"
  	],
  	[
  		66759,
  		1,
  		"𐓯"
  	],
  	[
  		66760,
  		1,
  		"𐓰"
  	],
  	[
  		66761,
  		1,
  		"𐓱"
  	],
  	[
  		66762,
  		1,
  		"𐓲"
  	],
  	[
  		66763,
  		1,
  		"𐓳"
  	],
  	[
  		66764,
  		1,
  		"𐓴"
  	],
  	[
  		66765,
  		1,
  		"𐓵"
  	],
  	[
  		66766,
  		1,
  		"𐓶"
  	],
  	[
  		66767,
  		1,
  		"𐓷"
  	],
  	[
  		66768,
  		1,
  		"𐓸"
  	],
  	[
  		66769,
  		1,
  		"𐓹"
  	],
  	[
  		66770,
  		1,
  		"𐓺"
  	],
  	[
  		66771,
  		1,
  		"𐓻"
  	],
  	[
  		[
  			66772,
  			66775
  		],
  		3
  	],
  	[
  		[
  			66776,
  			66811
  		],
  		2
  	],
  	[
  		[
  			66812,
  			66815
  		],
  		3
  	],
  	[
  		[
  			66816,
  			66855
  		],
  		2
  	],
  	[
  		[
  			66856,
  			66863
  		],
  		3
  	],
  	[
  		[
  			66864,
  			66915
  		],
  		2
  	],
  	[
  		[
  			66916,
  			66926
  		],
  		3
  	],
  	[
  		66927,
  		2
  	],
  	[
  		[
  			66928,
  			67071
  		],
  		3
  	],
  	[
  		[
  			67072,
  			67382
  		],
  		2
  	],
  	[
  		[
  			67383,
  			67391
  		],
  		3
  	],
  	[
  		[
  			67392,
  			67413
  		],
  		2
  	],
  	[
  		[
  			67414,
  			67423
  		],
  		3
  	],
  	[
  		[
  			67424,
  			67431
  		],
  		2
  	],
  	[
  		[
  			67432,
  			67583
  		],
  		3
  	],
  	[
  		[
  			67584,
  			67589
  		],
  		2
  	],
  	[
  		[
  			67590,
  			67591
  		],
  		3
  	],
  	[
  		67592,
  		2
  	],
  	[
  		67593,
  		3
  	],
  	[
  		[
  			67594,
  			67637
  		],
  		2
  	],
  	[
  		67638,
  		3
  	],
  	[
  		[
  			67639,
  			67640
  		],
  		2
  	],
  	[
  		[
  			67641,
  			67643
  		],
  		3
  	],
  	[
  		67644,
  		2
  	],
  	[
  		[
  			67645,
  			67646
  		],
  		3
  	],
  	[
  		67647,
  		2
  	],
  	[
  		[
  			67648,
  			67669
  		],
  		2
  	],
  	[
  		67670,
  		3
  	],
  	[
  		[
  			67671,
  			67679
  		],
  		2
  	],
  	[
  		[
  			67680,
  			67702
  		],
  		2
  	],
  	[
  		[
  			67703,
  			67711
  		],
  		2
  	],
  	[
  		[
  			67712,
  			67742
  		],
  		2
  	],
  	[
  		[
  			67743,
  			67750
  		],
  		3
  	],
  	[
  		[
  			67751,
  			67759
  		],
  		2
  	],
  	[
  		[
  			67760,
  			67807
  		],
  		3
  	],
  	[
  		[
  			67808,
  			67826
  		],
  		2
  	],
  	[
  		67827,
  		3
  	],
  	[
  		[
  			67828,
  			67829
  		],
  		2
  	],
  	[
  		[
  			67830,
  			67834
  		],
  		3
  	],
  	[
  		[
  			67835,
  			67839
  		],
  		2
  	],
  	[
  		[
  			67840,
  			67861
  		],
  		2
  	],
  	[
  		[
  			67862,
  			67865
  		],
  		2
  	],
  	[
  		[
  			67866,
  			67867
  		],
  		2
  	],
  	[
  		[
  			67868,
  			67870
  		],
  		3
  	],
  	[
  		67871,
  		2
  	],
  	[
  		[
  			67872,
  			67897
  		],
  		2
  	],
  	[
  		[
  			67898,
  			67902
  		],
  		3
  	],
  	[
  		67903,
  		2
  	],
  	[
  		[
  			67904,
  			67967
  		],
  		3
  	],
  	[
  		[
  			67968,
  			68023
  		],
  		2
  	],
  	[
  		[
  			68024,
  			68027
  		],
  		3
  	],
  	[
  		[
  			68028,
  			68029
  		],
  		2
  	],
  	[
  		[
  			68030,
  			68031
  		],
  		2
  	],
  	[
  		[
  			68032,
  			68047
  		],
  		2
  	],
  	[
  		[
  			68048,
  			68049
  		],
  		3
  	],
  	[
  		[
  			68050,
  			68095
  		],
  		2
  	],
  	[
  		[
  			68096,
  			68099
  		],
  		2
  	],
  	[
  		68100,
  		3
  	],
  	[
  		[
  			68101,
  			68102
  		],
  		2
  	],
  	[
  		[
  			68103,
  			68107
  		],
  		3
  	],
  	[
  		[
  			68108,
  			68115
  		],
  		2
  	],
  	[
  		68116,
  		3
  	],
  	[
  		[
  			68117,
  			68119
  		],
  		2
  	],
  	[
  		68120,
  		3
  	],
  	[
  		[
  			68121,
  			68147
  		],
  		2
  	],
  	[
  		[
  			68148,
  			68149
  		],
  		2
  	],
  	[
  		[
  			68150,
  			68151
  		],
  		3
  	],
  	[
  		[
  			68152,
  			68154
  		],
  		2
  	],
  	[
  		[
  			68155,
  			68158
  		],
  		3
  	],
  	[
  		68159,
  		2
  	],
  	[
  		[
  			68160,
  			68167
  		],
  		2
  	],
  	[
  		68168,
  		2
  	],
  	[
  		[
  			68169,
  			68175
  		],
  		3
  	],
  	[
  		[
  			68176,
  			68184
  		],
  		2
  	],
  	[
  		[
  			68185,
  			68191
  		],
  		3
  	],
  	[
  		[
  			68192,
  			68220
  		],
  		2
  	],
  	[
  		[
  			68221,
  			68223
  		],
  		2
  	],
  	[
  		[
  			68224,
  			68252
  		],
  		2
  	],
  	[
  		[
  			68253,
  			68255
  		],
  		2
  	],
  	[
  		[
  			68256,
  			68287
  		],
  		3
  	],
  	[
  		[
  			68288,
  			68295
  		],
  		2
  	],
  	[
  		68296,
  		2
  	],
  	[
  		[
  			68297,
  			68326
  		],
  		2
  	],
  	[
  		[
  			68327,
  			68330
  		],
  		3
  	],
  	[
  		[
  			68331,
  			68342
  		],
  		2
  	],
  	[
  		[
  			68343,
  			68351
  		],
  		3
  	],
  	[
  		[
  			68352,
  			68405
  		],
  		2
  	],
  	[
  		[
  			68406,
  			68408
  		],
  		3
  	],
  	[
  		[
  			68409,
  			68415
  		],
  		2
  	],
  	[
  		[
  			68416,
  			68437
  		],
  		2
  	],
  	[
  		[
  			68438,
  			68439
  		],
  		3
  	],
  	[
  		[
  			68440,
  			68447
  		],
  		2
  	],
  	[
  		[
  			68448,
  			68466
  		],
  		2
  	],
  	[
  		[
  			68467,
  			68471
  		],
  		3
  	],
  	[
  		[
  			68472,
  			68479
  		],
  		2
  	],
  	[
  		[
  			68480,
  			68497
  		],
  		2
  	],
  	[
  		[
  			68498,
  			68504
  		],
  		3
  	],
  	[
  		[
  			68505,
  			68508
  		],
  		2
  	],
  	[
  		[
  			68509,
  			68520
  		],
  		3
  	],
  	[
  		[
  			68521,
  			68527
  		],
  		2
  	],
  	[
  		[
  			68528,
  			68607
  		],
  		3
  	],
  	[
  		[
  			68608,
  			68680
  		],
  		2
  	],
  	[
  		[
  			68681,
  			68735
  		],
  		3
  	],
  	[
  		68736,
  		1,
  		"𐳀"
  	],
  	[
  		68737,
  		1,
  		"𐳁"
  	],
  	[
  		68738,
  		1,
  		"𐳂"
  	],
  	[
  		68739,
  		1,
  		"𐳃"
  	],
  	[
  		68740,
  		1,
  		"𐳄"
  	],
  	[
  		68741,
  		1,
  		"𐳅"
  	],
  	[
  		68742,
  		1,
  		"𐳆"
  	],
  	[
  		68743,
  		1,
  		"𐳇"
  	],
  	[
  		68744,
  		1,
  		"𐳈"
  	],
  	[
  		68745,
  		1,
  		"𐳉"
  	],
  	[
  		68746,
  		1,
  		"𐳊"
  	],
  	[
  		68747,
  		1,
  		"𐳋"
  	],
  	[
  		68748,
  		1,
  		"𐳌"
  	],
  	[
  		68749,
  		1,
  		"𐳍"
  	],
  	[
  		68750,
  		1,
  		"𐳎"
  	],
  	[
  		68751,
  		1,
  		"𐳏"
  	],
  	[
  		68752,
  		1,
  		"𐳐"
  	],
  	[
  		68753,
  		1,
  		"𐳑"
  	],
  	[
  		68754,
  		1,
  		"𐳒"
  	],
  	[
  		68755,
  		1,
  		"𐳓"
  	],
  	[
  		68756,
  		1,
  		"𐳔"
  	],
  	[
  		68757,
  		1,
  		"𐳕"
  	],
  	[
  		68758,
  		1,
  		"𐳖"
  	],
  	[
  		68759,
  		1,
  		"𐳗"
  	],
  	[
  		68760,
  		1,
  		"𐳘"
  	],
  	[
  		68761,
  		1,
  		"𐳙"
  	],
  	[
  		68762,
  		1,
  		"𐳚"
  	],
  	[
  		68763,
  		1,
  		"𐳛"
  	],
  	[
  		68764,
  		1,
  		"𐳜"
  	],
  	[
  		68765,
  		1,
  		"𐳝"
  	],
  	[
  		68766,
  		1,
  		"𐳞"
  	],
  	[
  		68767,
  		1,
  		"𐳟"
  	],
  	[
  		68768,
  		1,
  		"𐳠"
  	],
  	[
  		68769,
  		1,
  		"𐳡"
  	],
  	[
  		68770,
  		1,
  		"𐳢"
  	],
  	[
  		68771,
  		1,
  		"𐳣"
  	],
  	[
  		68772,
  		1,
  		"𐳤"
  	],
  	[
  		68773,
  		1,
  		"𐳥"
  	],
  	[
  		68774,
  		1,
  		"𐳦"
  	],
  	[
  		68775,
  		1,
  		"𐳧"
  	],
  	[
  		68776,
  		1,
  		"𐳨"
  	],
  	[
  		68777,
  		1,
  		"𐳩"
  	],
  	[
  		68778,
  		1,
  		"𐳪"
  	],
  	[
  		68779,
  		1,
  		"𐳫"
  	],
  	[
  		68780,
  		1,
  		"𐳬"
  	],
  	[
  		68781,
  		1,
  		"𐳭"
  	],
  	[
  		68782,
  		1,
  		"𐳮"
  	],
  	[
  		68783,
  		1,
  		"𐳯"
  	],
  	[
  		68784,
  		1,
  		"𐳰"
  	],
  	[
  		68785,
  		1,
  		"𐳱"
  	],
  	[
  		68786,
  		1,
  		"𐳲"
  	],
  	[
  		[
  			68787,
  			68799
  		],
  		3
  	],
  	[
  		[
  			68800,
  			68850
  		],
  		2
  	],
  	[
  		[
  			68851,
  			68857
  		],
  		3
  	],
  	[
  		[
  			68858,
  			68863
  		],
  		2
  	],
  	[
  		[
  			68864,
  			68903
  		],
  		2
  	],
  	[
  		[
  			68904,
  			68911
  		],
  		3
  	],
  	[
  		[
  			68912,
  			68921
  		],
  		2
  	],
  	[
  		[
  			68922,
  			69215
  		],
  		3
  	],
  	[
  		[
  			69216,
  			69246
  		],
  		2
  	],
  	[
  		69247,
  		3
  	],
  	[
  		[
  			69248,
  			69289
  		],
  		2
  	],
  	[
  		69290,
  		3
  	],
  	[
  		[
  			69291,
  			69292
  		],
  		2
  	],
  	[
  		69293,
  		2
  	],
  	[
  		[
  			69294,
  			69295
  		],
  		3
  	],
  	[
  		[
  			69296,
  			69297
  		],
  		2
  	],
  	[
  		[
  			69298,
  			69375
  		],
  		3
  	],
  	[
  		[
  			69376,
  			69404
  		],
  		2
  	],
  	[
  		[
  			69405,
  			69414
  		],
  		2
  	],
  	[
  		69415,
  		2
  	],
  	[
  		[
  			69416,
  			69423
  		],
  		3
  	],
  	[
  		[
  			69424,
  			69456
  		],
  		2
  	],
  	[
  		[
  			69457,
  			69465
  		],
  		2
  	],
  	[
  		[
  			69466,
  			69551
  		],
  		3
  	],
  	[
  		[
  			69552,
  			69572
  		],
  		2
  	],
  	[
  		[
  			69573,
  			69579
  		],
  		2
  	],
  	[
  		[
  			69580,
  			69599
  		],
  		3
  	],
  	[
  		[
  			69600,
  			69622
  		],
  		2
  	],
  	[
  		[
  			69623,
  			69631
  		],
  		3
  	],
  	[
  		[
  			69632,
  			69702
  		],
  		2
  	],
  	[
  		[
  			69703,
  			69709
  		],
  		2
  	],
  	[
  		[
  			69710,
  			69713
  		],
  		3
  	],
  	[
  		[
  			69714,
  			69733
  		],
  		2
  	],
  	[
  		[
  			69734,
  			69743
  		],
  		2
  	],
  	[
  		[
  			69744,
  			69758
  		],
  		3
  	],
  	[
  		69759,
  		2
  	],
  	[
  		[
  			69760,
  			69818
  		],
  		2
  	],
  	[
  		[
  			69819,
  			69820
  		],
  		2
  	],
  	[
  		69821,
  		3
  	],
  	[
  		[
  			69822,
  			69825
  		],
  		2
  	],
  	[
  		[
  			69826,
  			69836
  		],
  		3
  	],
  	[
  		69837,
  		3
  	],
  	[
  		[
  			69838,
  			69839
  		],
  		3
  	],
  	[
  		[
  			69840,
  			69864
  		],
  		2
  	],
  	[
  		[
  			69865,
  			69871
  		],
  		3
  	],
  	[
  		[
  			69872,
  			69881
  		],
  		2
  	],
  	[
  		[
  			69882,
  			69887
  		],
  		3
  	],
  	[
  		[
  			69888,
  			69940
  		],
  		2
  	],
  	[
  		69941,
  		3
  	],
  	[
  		[
  			69942,
  			69951
  		],
  		2
  	],
  	[
  		[
  			69952,
  			69955
  		],
  		2
  	],
  	[
  		[
  			69956,
  			69958
  		],
  		2
  	],
  	[
  		69959,
  		2
  	],
  	[
  		[
  			69960,
  			69967
  		],
  		3
  	],
  	[
  		[
  			69968,
  			70003
  		],
  		2
  	],
  	[
  		[
  			70004,
  			70005
  		],
  		2
  	],
  	[
  		70006,
  		2
  	],
  	[
  		[
  			70007,
  			70015
  		],
  		3
  	],
  	[
  		[
  			70016,
  			70084
  		],
  		2
  	],
  	[
  		[
  			70085,
  			70088
  		],
  		2
  	],
  	[
  		[
  			70089,
  			70092
  		],
  		2
  	],
  	[
  		70093,
  		2
  	],
  	[
  		[
  			70094,
  			70095
  		],
  		2
  	],
  	[
  		[
  			70096,
  			70105
  		],
  		2
  	],
  	[
  		70106,
  		2
  	],
  	[
  		70107,
  		2
  	],
  	[
  		70108,
  		2
  	],
  	[
  		[
  			70109,
  			70111
  		],
  		2
  	],
  	[
  		70112,
  		3
  	],
  	[
  		[
  			70113,
  			70132
  		],
  		2
  	],
  	[
  		[
  			70133,
  			70143
  		],
  		3
  	],
  	[
  		[
  			70144,
  			70161
  		],
  		2
  	],
  	[
  		70162,
  		3
  	],
  	[
  		[
  			70163,
  			70199
  		],
  		2
  	],
  	[
  		[
  			70200,
  			70205
  		],
  		2
  	],
  	[
  		70206,
  		2
  	],
  	[
  		[
  			70207,
  			70271
  		],
  		3
  	],
  	[
  		[
  			70272,
  			70278
  		],
  		2
  	],
  	[
  		70279,
  		3
  	],
  	[
  		70280,
  		2
  	],
  	[
  		70281,
  		3
  	],
  	[
  		[
  			70282,
  			70285
  		],
  		2
  	],
  	[
  		70286,
  		3
  	],
  	[
  		[
  			70287,
  			70301
  		],
  		2
  	],
  	[
  		70302,
  		3
  	],
  	[
  		[
  			70303,
  			70312
  		],
  		2
  	],
  	[
  		70313,
  		2
  	],
  	[
  		[
  			70314,
  			70319
  		],
  		3
  	],
  	[
  		[
  			70320,
  			70378
  		],
  		2
  	],
  	[
  		[
  			70379,
  			70383
  		],
  		3
  	],
  	[
  		[
  			70384,
  			70393
  		],
  		2
  	],
  	[
  		[
  			70394,
  			70399
  		],
  		3
  	],
  	[
  		70400,
  		2
  	],
  	[
  		[
  			70401,
  			70403
  		],
  		2
  	],
  	[
  		70404,
  		3
  	],
  	[
  		[
  			70405,
  			70412
  		],
  		2
  	],
  	[
  		[
  			70413,
  			70414
  		],
  		3
  	],
  	[
  		[
  			70415,
  			70416
  		],
  		2
  	],
  	[
  		[
  			70417,
  			70418
  		],
  		3
  	],
  	[
  		[
  			70419,
  			70440
  		],
  		2
  	],
  	[
  		70441,
  		3
  	],
  	[
  		[
  			70442,
  			70448
  		],
  		2
  	],
  	[
  		70449,
  		3
  	],
  	[
  		[
  			70450,
  			70451
  		],
  		2
  	],
  	[
  		70452,
  		3
  	],
  	[
  		[
  			70453,
  			70457
  		],
  		2
  	],
  	[
  		70458,
  		3
  	],
  	[
  		70459,
  		2
  	],
  	[
  		[
  			70460,
  			70468
  		],
  		2
  	],
  	[
  		[
  			70469,
  			70470
  		],
  		3
  	],
  	[
  		[
  			70471,
  			70472
  		],
  		2
  	],
  	[
  		[
  			70473,
  			70474
  		],
  		3
  	],
  	[
  		[
  			70475,
  			70477
  		],
  		2
  	],
  	[
  		[
  			70478,
  			70479
  		],
  		3
  	],
  	[
  		70480,
  		2
  	],
  	[
  		[
  			70481,
  			70486
  		],
  		3
  	],
  	[
  		70487,
  		2
  	],
  	[
  		[
  			70488,
  			70492
  		],
  		3
  	],
  	[
  		[
  			70493,
  			70499
  		],
  		2
  	],
  	[
  		[
  			70500,
  			70501
  		],
  		3
  	],
  	[
  		[
  			70502,
  			70508
  		],
  		2
  	],
  	[
  		[
  			70509,
  			70511
  		],
  		3
  	],
  	[
  		[
  			70512,
  			70516
  		],
  		2
  	],
  	[
  		[
  			70517,
  			70655
  		],
  		3
  	],
  	[
  		[
  			70656,
  			70730
  		],
  		2
  	],
  	[
  		[
  			70731,
  			70735
  		],
  		2
  	],
  	[
  		[
  			70736,
  			70745
  		],
  		2
  	],
  	[
  		70746,
  		2
  	],
  	[
  		70747,
  		2
  	],
  	[
  		70748,
  		3
  	],
  	[
  		70749,
  		2
  	],
  	[
  		70750,
  		2
  	],
  	[
  		70751,
  		2
  	],
  	[
  		[
  			70752,
  			70753
  		],
  		2
  	],
  	[
  		[
  			70754,
  			70783
  		],
  		3
  	],
  	[
  		[
  			70784,
  			70853
  		],
  		2
  	],
  	[
  		70854,
  		2
  	],
  	[
  		70855,
  		2
  	],
  	[
  		[
  			70856,
  			70863
  		],
  		3
  	],
  	[
  		[
  			70864,
  			70873
  		],
  		2
  	],
  	[
  		[
  			70874,
  			71039
  		],
  		3
  	],
  	[
  		[
  			71040,
  			71093
  		],
  		2
  	],
  	[
  		[
  			71094,
  			71095
  		],
  		3
  	],
  	[
  		[
  			71096,
  			71104
  		],
  		2
  	],
  	[
  		[
  			71105,
  			71113
  		],
  		2
  	],
  	[
  		[
  			71114,
  			71127
  		],
  		2
  	],
  	[
  		[
  			71128,
  			71133
  		],
  		2
  	],
  	[
  		[
  			71134,
  			71167
  		],
  		3
  	],
  	[
  		[
  			71168,
  			71232
  		],
  		2
  	],
  	[
  		[
  			71233,
  			71235
  		],
  		2
  	],
  	[
  		71236,
  		2
  	],
  	[
  		[
  			71237,
  			71247
  		],
  		3
  	],
  	[
  		[
  			71248,
  			71257
  		],
  		2
  	],
  	[
  		[
  			71258,
  			71263
  		],
  		3
  	],
  	[
  		[
  			71264,
  			71276
  		],
  		2
  	],
  	[
  		[
  			71277,
  			71295
  		],
  		3
  	],
  	[
  		[
  			71296,
  			71351
  		],
  		2
  	],
  	[
  		71352,
  		2
  	],
  	[
  		[
  			71353,
  			71359
  		],
  		3
  	],
  	[
  		[
  			71360,
  			71369
  		],
  		2
  	],
  	[
  		[
  			71370,
  			71423
  		],
  		3
  	],
  	[
  		[
  			71424,
  			71449
  		],
  		2
  	],
  	[
  		71450,
  		2
  	],
  	[
  		[
  			71451,
  			71452
  		],
  		3
  	],
  	[
  		[
  			71453,
  			71467
  		],
  		2
  	],
  	[
  		[
  			71468,
  			71471
  		],
  		3
  	],
  	[
  		[
  			71472,
  			71481
  		],
  		2
  	],
  	[
  		[
  			71482,
  			71487
  		],
  		2
  	],
  	[
  		[
  			71488,
  			71679
  		],
  		3
  	],
  	[
  		[
  			71680,
  			71738
  		],
  		2
  	],
  	[
  		71739,
  		2
  	],
  	[
  		[
  			71740,
  			71839
  		],
  		3
  	],
  	[
  		71840,
  		1,
  		"𑣀"
  	],
  	[
  		71841,
  		1,
  		"𑣁"
  	],
  	[
  		71842,
  		1,
  		"𑣂"
  	],
  	[
  		71843,
  		1,
  		"𑣃"
  	],
  	[
  		71844,
  		1,
  		"𑣄"
  	],
  	[
  		71845,
  		1,
  		"𑣅"
  	],
  	[
  		71846,
  		1,
  		"𑣆"
  	],
  	[
  		71847,
  		1,
  		"𑣇"
  	],
  	[
  		71848,
  		1,
  		"𑣈"
  	],
  	[
  		71849,
  		1,
  		"𑣉"
  	],
  	[
  		71850,
  		1,
  		"𑣊"
  	],
  	[
  		71851,
  		1,
  		"𑣋"
  	],
  	[
  		71852,
  		1,
  		"𑣌"
  	],
  	[
  		71853,
  		1,
  		"𑣍"
  	],
  	[
  		71854,
  		1,
  		"𑣎"
  	],
  	[
  		71855,
  		1,
  		"𑣏"
  	],
  	[
  		71856,
  		1,
  		"𑣐"
  	],
  	[
  		71857,
  		1,
  		"𑣑"
  	],
  	[
  		71858,
  		1,
  		"𑣒"
  	],
  	[
  		71859,
  		1,
  		"𑣓"
  	],
  	[
  		71860,
  		1,
  		"𑣔"
  	],
  	[
  		71861,
  		1,
  		"𑣕"
  	],
  	[
  		71862,
  		1,
  		"𑣖"
  	],
  	[
  		71863,
  		1,
  		"𑣗"
  	],
  	[
  		71864,
  		1,
  		"𑣘"
  	],
  	[
  		71865,
  		1,
  		"𑣙"
  	],
  	[
  		71866,
  		1,
  		"𑣚"
  	],
  	[
  		71867,
  		1,
  		"𑣛"
  	],
  	[
  		71868,
  		1,
  		"𑣜"
  	],
  	[
  		71869,
  		1,
  		"𑣝"
  	],
  	[
  		71870,
  		1,
  		"𑣞"
  	],
  	[
  		71871,
  		1,
  		"𑣟"
  	],
  	[
  		[
  			71872,
  			71913
  		],
  		2
  	],
  	[
  		[
  			71914,
  			71922
  		],
  		2
  	],
  	[
  		[
  			71923,
  			71934
  		],
  		3
  	],
  	[
  		71935,
  		2
  	],
  	[
  		[
  			71936,
  			71942
  		],
  		2
  	],
  	[
  		[
  			71943,
  			71944
  		],
  		3
  	],
  	[
  		71945,
  		2
  	],
  	[
  		[
  			71946,
  			71947
  		],
  		3
  	],
  	[
  		[
  			71948,
  			71955
  		],
  		2
  	],
  	[
  		71956,
  		3
  	],
  	[
  		[
  			71957,
  			71958
  		],
  		2
  	],
  	[
  		71959,
  		3
  	],
  	[
  		[
  			71960,
  			71989
  		],
  		2
  	],
  	[
  		71990,
  		3
  	],
  	[
  		[
  			71991,
  			71992
  		],
  		2
  	],
  	[
  		[
  			71993,
  			71994
  		],
  		3
  	],
  	[
  		[
  			71995,
  			72003
  		],
  		2
  	],
  	[
  		[
  			72004,
  			72006
  		],
  		2
  	],
  	[
  		[
  			72007,
  			72015
  		],
  		3
  	],
  	[
  		[
  			72016,
  			72025
  		],
  		2
  	],
  	[
  		[
  			72026,
  			72095
  		],
  		3
  	],
  	[
  		[
  			72096,
  			72103
  		],
  		2
  	],
  	[
  		[
  			72104,
  			72105
  		],
  		3
  	],
  	[
  		[
  			72106,
  			72151
  		],
  		2
  	],
  	[
  		[
  			72152,
  			72153
  		],
  		3
  	],
  	[
  		[
  			72154,
  			72161
  		],
  		2
  	],
  	[
  		72162,
  		2
  	],
  	[
  		[
  			72163,
  			72164
  		],
  		2
  	],
  	[
  		[
  			72165,
  			72191
  		],
  		3
  	],
  	[
  		[
  			72192,
  			72254
  		],
  		2
  	],
  	[
  		[
  			72255,
  			72262
  		],
  		2
  	],
  	[
  		72263,
  		2
  	],
  	[
  		[
  			72264,
  			72271
  		],
  		3
  	],
  	[
  		[
  			72272,
  			72323
  		],
  		2
  	],
  	[
  		[
  			72324,
  			72325
  		],
  		2
  	],
  	[
  		[
  			72326,
  			72345
  		],
  		2
  	],
  	[
  		[
  			72346,
  			72348
  		],
  		2
  	],
  	[
  		72349,
  		2
  	],
  	[
  		[
  			72350,
  			72354
  		],
  		2
  	],
  	[
  		[
  			72355,
  			72383
  		],
  		3
  	],
  	[
  		[
  			72384,
  			72440
  		],
  		2
  	],
  	[
  		[
  			72441,
  			72703
  		],
  		3
  	],
  	[
  		[
  			72704,
  			72712
  		],
  		2
  	],
  	[
  		72713,
  		3
  	],
  	[
  		[
  			72714,
  			72758
  		],
  		2
  	],
  	[
  		72759,
  		3
  	],
  	[
  		[
  			72760,
  			72768
  		],
  		2
  	],
  	[
  		[
  			72769,
  			72773
  		],
  		2
  	],
  	[
  		[
  			72774,
  			72783
  		],
  		3
  	],
  	[
  		[
  			72784,
  			72793
  		],
  		2
  	],
  	[
  		[
  			72794,
  			72812
  		],
  		2
  	],
  	[
  		[
  			72813,
  			72815
  		],
  		3
  	],
  	[
  		[
  			72816,
  			72817
  		],
  		2
  	],
  	[
  		[
  			72818,
  			72847
  		],
  		2
  	],
  	[
  		[
  			72848,
  			72849
  		],
  		3
  	],
  	[
  		[
  			72850,
  			72871
  		],
  		2
  	],
  	[
  		72872,
  		3
  	],
  	[
  		[
  			72873,
  			72886
  		],
  		2
  	],
  	[
  		[
  			72887,
  			72959
  		],
  		3
  	],
  	[
  		[
  			72960,
  			72966
  		],
  		2
  	],
  	[
  		72967,
  		3
  	],
  	[
  		[
  			72968,
  			72969
  		],
  		2
  	],
  	[
  		72970,
  		3
  	],
  	[
  		[
  			72971,
  			73014
  		],
  		2
  	],
  	[
  		[
  			73015,
  			73017
  		],
  		3
  	],
  	[
  		73018,
  		2
  	],
  	[
  		73019,
  		3
  	],
  	[
  		[
  			73020,
  			73021
  		],
  		2
  	],
  	[
  		73022,
  		3
  	],
  	[
  		[
  			73023,
  			73031
  		],
  		2
  	],
  	[
  		[
  			73032,
  			73039
  		],
  		3
  	],
  	[
  		[
  			73040,
  			73049
  		],
  		2
  	],
  	[
  		[
  			73050,
  			73055
  		],
  		3
  	],
  	[
  		[
  			73056,
  			73061
  		],
  		2
  	],
  	[
  		73062,
  		3
  	],
  	[
  		[
  			73063,
  			73064
  		],
  		2
  	],
  	[
  		73065,
  		3
  	],
  	[
  		[
  			73066,
  			73102
  		],
  		2
  	],
  	[
  		73103,
  		3
  	],
  	[
  		[
  			73104,
  			73105
  		],
  		2
  	],
  	[
  		73106,
  		3
  	],
  	[
  		[
  			73107,
  			73112
  		],
  		2
  	],
  	[
  		[
  			73113,
  			73119
  		],
  		3
  	],
  	[
  		[
  			73120,
  			73129
  		],
  		2
  	],
  	[
  		[
  			73130,
  			73439
  		],
  		3
  	],
  	[
  		[
  			73440,
  			73462
  		],
  		2
  	],
  	[
  		[
  			73463,
  			73464
  		],
  		2
  	],
  	[
  		[
  			73465,
  			73647
  		],
  		3
  	],
  	[
  		73648,
  		2
  	],
  	[
  		[
  			73649,
  			73663
  		],
  		3
  	],
  	[
  		[
  			73664,
  			73713
  		],
  		2
  	],
  	[
  		[
  			73714,
  			73726
  		],
  		3
  	],
  	[
  		73727,
  		2
  	],
  	[
  		[
  			73728,
  			74606
  		],
  		2
  	],
  	[
  		[
  			74607,
  			74648
  		],
  		2
  	],
  	[
  		74649,
  		2
  	],
  	[
  		[
  			74650,
  			74751
  		],
  		3
  	],
  	[
  		[
  			74752,
  			74850
  		],
  		2
  	],
  	[
  		[
  			74851,
  			74862
  		],
  		2
  	],
  	[
  		74863,
  		3
  	],
  	[
  		[
  			74864,
  			74867
  		],
  		2
  	],
  	[
  		74868,
  		2
  	],
  	[
  		[
  			74869,
  			74879
  		],
  		3
  	],
  	[
  		[
  			74880,
  			75075
  		],
  		2
  	],
  	[
  		[
  			75076,
  			77823
  		],
  		3
  	],
  	[
  		[
  			77824,
  			78894
  		],
  		2
  	],
  	[
  		78895,
  		3
  	],
  	[
  		[
  			78896,
  			78904
  		],
  		3
  	],
  	[
  		[
  			78905,
  			82943
  		],
  		3
  	],
  	[
  		[
  			82944,
  			83526
  		],
  		2
  	],
  	[
  		[
  			83527,
  			92159
  		],
  		3
  	],
  	[
  		[
  			92160,
  			92728
  		],
  		2
  	],
  	[
  		[
  			92729,
  			92735
  		],
  		3
  	],
  	[
  		[
  			92736,
  			92766
  		],
  		2
  	],
  	[
  		92767,
  		3
  	],
  	[
  		[
  			92768,
  			92777
  		],
  		2
  	],
  	[
  		[
  			92778,
  			92781
  		],
  		3
  	],
  	[
  		[
  			92782,
  			92783
  		],
  		2
  	],
  	[
  		[
  			92784,
  			92879
  		],
  		3
  	],
  	[
  		[
  			92880,
  			92909
  		],
  		2
  	],
  	[
  		[
  			92910,
  			92911
  		],
  		3
  	],
  	[
  		[
  			92912,
  			92916
  		],
  		2
  	],
  	[
  		92917,
  		2
  	],
  	[
  		[
  			92918,
  			92927
  		],
  		3
  	],
  	[
  		[
  			92928,
  			92982
  		],
  		2
  	],
  	[
  		[
  			92983,
  			92991
  		],
  		2
  	],
  	[
  		[
  			92992,
  			92995
  		],
  		2
  	],
  	[
  		[
  			92996,
  			92997
  		],
  		2
  	],
  	[
  		[
  			92998,
  			93007
  		],
  		3
  	],
  	[
  		[
  			93008,
  			93017
  		],
  		2
  	],
  	[
  		93018,
  		3
  	],
  	[
  		[
  			93019,
  			93025
  		],
  		2
  	],
  	[
  		93026,
  		3
  	],
  	[
  		[
  			93027,
  			93047
  		],
  		2
  	],
  	[
  		[
  			93048,
  			93052
  		],
  		3
  	],
  	[
  		[
  			93053,
  			93071
  		],
  		2
  	],
  	[
  		[
  			93072,
  			93759
  		],
  		3
  	],
  	[
  		93760,
  		1,
  		"𖹠"
  	],
  	[
  		93761,
  		1,
  		"𖹡"
  	],
  	[
  		93762,
  		1,
  		"𖹢"
  	],
  	[
  		93763,
  		1,
  		"𖹣"
  	],
  	[
  		93764,
  		1,
  		"𖹤"
  	],
  	[
  		93765,
  		1,
  		"𖹥"
  	],
  	[
  		93766,
  		1,
  		"𖹦"
  	],
  	[
  		93767,
  		1,
  		"𖹧"
  	],
  	[
  		93768,
  		1,
  		"𖹨"
  	],
  	[
  		93769,
  		1,
  		"𖹩"
  	],
  	[
  		93770,
  		1,
  		"𖹪"
  	],
  	[
  		93771,
  		1,
  		"𖹫"
  	],
  	[
  		93772,
  		1,
  		"𖹬"
  	],
  	[
  		93773,
  		1,
  		"𖹭"
  	],
  	[
  		93774,
  		1,
  		"𖹮"
  	],
  	[
  		93775,
  		1,
  		"𖹯"
  	],
  	[
  		93776,
  		1,
  		"𖹰"
  	],
  	[
  		93777,
  		1,
  		"𖹱"
  	],
  	[
  		93778,
  		1,
  		"𖹲"
  	],
  	[
  		93779,
  		1,
  		"𖹳"
  	],
  	[
  		93780,
  		1,
  		"𖹴"
  	],
  	[
  		93781,
  		1,
  		"𖹵"
  	],
  	[
  		93782,
  		1,
  		"𖹶"
  	],
  	[
  		93783,
  		1,
  		"𖹷"
  	],
  	[
  		93784,
  		1,
  		"𖹸"
  	],
  	[
  		93785,
  		1,
  		"𖹹"
  	],
  	[
  		93786,
  		1,
  		"𖹺"
  	],
  	[
  		93787,
  		1,
  		"𖹻"
  	],
  	[
  		93788,
  		1,
  		"𖹼"
  	],
  	[
  		93789,
  		1,
  		"𖹽"
  	],
  	[
  		93790,
  		1,
  		"𖹾"
  	],
  	[
  		93791,
  		1,
  		"𖹿"
  	],
  	[
  		[
  			93792,
  			93823
  		],
  		2
  	],
  	[
  		[
  			93824,
  			93850
  		],
  		2
  	],
  	[
  		[
  			93851,
  			93951
  		],
  		3
  	],
  	[
  		[
  			93952,
  			94020
  		],
  		2
  	],
  	[
  		[
  			94021,
  			94026
  		],
  		2
  	],
  	[
  		[
  			94027,
  			94030
  		],
  		3
  	],
  	[
  		94031,
  		2
  	],
  	[
  		[
  			94032,
  			94078
  		],
  		2
  	],
  	[
  		[
  			94079,
  			94087
  		],
  		2
  	],
  	[
  		[
  			94088,
  			94094
  		],
  		3
  	],
  	[
  		[
  			94095,
  			94111
  		],
  		2
  	],
  	[
  		[
  			94112,
  			94175
  		],
  		3
  	],
  	[
  		94176,
  		2
  	],
  	[
  		94177,
  		2
  	],
  	[
  		94178,
  		2
  	],
  	[
  		94179,
  		2
  	],
  	[
  		94180,
  		2
  	],
  	[
  		[
  			94181,
  			94191
  		],
  		3
  	],
  	[
  		[
  			94192,
  			94193
  		],
  		2
  	],
  	[
  		[
  			94194,
  			94207
  		],
  		3
  	],
  	[
  		[
  			94208,
  			100332
  		],
  		2
  	],
  	[
  		[
  			100333,
  			100337
  		],
  		2
  	],
  	[
  		[
  			100338,
  			100343
  		],
  		2
  	],
  	[
  		[
  			100344,
  			100351
  		],
  		3
  	],
  	[
  		[
  			100352,
  			101106
  		],
  		2
  	],
  	[
  		[
  			101107,
  			101589
  		],
  		2
  	],
  	[
  		[
  			101590,
  			101631
  		],
  		3
  	],
  	[
  		[
  			101632,
  			101640
  		],
  		2
  	],
  	[
  		[
  			101641,
  			110591
  		],
  		3
  	],
  	[
  		[
  			110592,
  			110593
  		],
  		2
  	],
  	[
  		[
  			110594,
  			110878
  		],
  		2
  	],
  	[
  		[
  			110879,
  			110927
  		],
  		3
  	],
  	[
  		[
  			110928,
  			110930
  		],
  		2
  	],
  	[
  		[
  			110931,
  			110947
  		],
  		3
  	],
  	[
  		[
  			110948,
  			110951
  		],
  		2
  	],
  	[
  		[
  			110952,
  			110959
  		],
  		3
  	],
  	[
  		[
  			110960,
  			111355
  		],
  		2
  	],
  	[
  		[
  			111356,
  			113663
  		],
  		3
  	],
  	[
  		[
  			113664,
  			113770
  		],
  		2
  	],
  	[
  		[
  			113771,
  			113775
  		],
  		3
  	],
  	[
  		[
  			113776,
  			113788
  		],
  		2
  	],
  	[
  		[
  			113789,
  			113791
  		],
  		3
  	],
  	[
  		[
  			113792,
  			113800
  		],
  		2
  	],
  	[
  		[
  			113801,
  			113807
  		],
  		3
  	],
  	[
  		[
  			113808,
  			113817
  		],
  		2
  	],
  	[
  		[
  			113818,
  			113819
  		],
  		3
  	],
  	[
  		113820,
  		2
  	],
  	[
  		[
  			113821,
  			113822
  		],
  		2
  	],
  	[
  		113823,
  		2
  	],
  	[
  		[
  			113824,
  			113827
  		],
  		7
  	],
  	[
  		[
  			113828,
  			118783
  		],
  		3
  	],
  	[
  		[
  			118784,
  			119029
  		],
  		2
  	],
  	[
  		[
  			119030,
  			119039
  		],
  		3
  	],
  	[
  		[
  			119040,
  			119078
  		],
  		2
  	],
  	[
  		[
  			119079,
  			119080
  		],
  		3
  	],
  	[
  		119081,
  		2
  	],
  	[
  		[
  			119082,
  			119133
  		],
  		2
  	],
  	[
  		119134,
  		1,
  		"𝅗𝅥"
  	],
  	[
  		119135,
  		1,
  		"𝅘𝅥"
  	],
  	[
  		119136,
  		1,
  		"𝅘𝅥𝅮"
  	],
  	[
  		119137,
  		1,
  		"𝅘𝅥𝅯"
  	],
  	[
  		119138,
  		1,
  		"𝅘𝅥𝅰"
  	],
  	[
  		119139,
  		1,
  		"𝅘𝅥𝅱"
  	],
  	[
  		119140,
  		1,
  		"𝅘𝅥𝅲"
  	],
  	[
  		[
  			119141,
  			119154
  		],
  		2
  	],
  	[
  		[
  			119155,
  			119162
  		],
  		3
  	],
  	[
  		[
  			119163,
  			119226
  		],
  		2
  	],
  	[
  		119227,
  		1,
  		"𝆹𝅥"
  	],
  	[
  		119228,
  		1,
  		"𝆺𝅥"
  	],
  	[
  		119229,
  		1,
  		"𝆹𝅥𝅮"
  	],
  	[
  		119230,
  		1,
  		"𝆺𝅥𝅮"
  	],
  	[
  		119231,
  		1,
  		"𝆹𝅥𝅯"
  	],
  	[
  		119232,
  		1,
  		"𝆺𝅥𝅯"
  	],
  	[
  		[
  			119233,
  			119261
  		],
  		2
  	],
  	[
  		[
  			119262,
  			119272
  		],
  		2
  	],
  	[
  		[
  			119273,
  			119295
  		],
  		3
  	],
  	[
  		[
  			119296,
  			119365
  		],
  		2
  	],
  	[
  		[
  			119366,
  			119519
  		],
  		3
  	],
  	[
  		[
  			119520,
  			119539
  		],
  		2
  	],
  	[
  		[
  			119540,
  			119551
  		],
  		3
  	],
  	[
  		[
  			119552,
  			119638
  		],
  		2
  	],
  	[
  		[
  			119639,
  			119647
  		],
  		3
  	],
  	[
  		[
  			119648,
  			119665
  		],
  		2
  	],
  	[
  		[
  			119666,
  			119672
  		],
  		2
  	],
  	[
  		[
  			119673,
  			119807
  		],
  		3
  	],
  	[
  		119808,
  		1,
  		"a"
  	],
  	[
  		119809,
  		1,
  		"b"
  	],
  	[
  		119810,
  		1,
  		"c"
  	],
  	[
  		119811,
  		1,
  		"d"
  	],
  	[
  		119812,
  		1,
  		"e"
  	],
  	[
  		119813,
  		1,
  		"f"
  	],
  	[
  		119814,
  		1,
  		"g"
  	],
  	[
  		119815,
  		1,
  		"h"
  	],
  	[
  		119816,
  		1,
  		"i"
  	],
  	[
  		119817,
  		1,
  		"j"
  	],
  	[
  		119818,
  		1,
  		"k"
  	],
  	[
  		119819,
  		1,
  		"l"
  	],
  	[
  		119820,
  		1,
  		"m"
  	],
  	[
  		119821,
  		1,
  		"n"
  	],
  	[
  		119822,
  		1,
  		"o"
  	],
  	[
  		119823,
  		1,
  		"p"
  	],
  	[
  		119824,
  		1,
  		"q"
  	],
  	[
  		119825,
  		1,
  		"r"
  	],
  	[
  		119826,
  		1,
  		"s"
  	],
  	[
  		119827,
  		1,
  		"t"
  	],
  	[
  		119828,
  		1,
  		"u"
  	],
  	[
  		119829,
  		1,
  		"v"
  	],
  	[
  		119830,
  		1,
  		"w"
  	],
  	[
  		119831,
  		1,
  		"x"
  	],
  	[
  		119832,
  		1,
  		"y"
  	],
  	[
  		119833,
  		1,
  		"z"
  	],
  	[
  		119834,
  		1,
  		"a"
  	],
  	[
  		119835,
  		1,
  		"b"
  	],
  	[
  		119836,
  		1,
  		"c"
  	],
  	[
  		119837,
  		1,
  		"d"
  	],
  	[
  		119838,
  		1,
  		"e"
  	],
  	[
  		119839,
  		1,
  		"f"
  	],
  	[
  		119840,
  		1,
  		"g"
  	],
  	[
  		119841,
  		1,
  		"h"
  	],
  	[
  		119842,
  		1,
  		"i"
  	],
  	[
  		119843,
  		1,
  		"j"
  	],
  	[
  		119844,
  		1,
  		"k"
  	],
  	[
  		119845,
  		1,
  		"l"
  	],
  	[
  		119846,
  		1,
  		"m"
  	],
  	[
  		119847,
  		1,
  		"n"
  	],
  	[
  		119848,
  		1,
  		"o"
  	],
  	[
  		119849,
  		1,
  		"p"
  	],
  	[
  		119850,
  		1,
  		"q"
  	],
  	[
  		119851,
  		1,
  		"r"
  	],
  	[
  		119852,
  		1,
  		"s"
  	],
  	[
  		119853,
  		1,
  		"t"
  	],
  	[
  		119854,
  		1,
  		"u"
  	],
  	[
  		119855,
  		1,
  		"v"
  	],
  	[
  		119856,
  		1,
  		"w"
  	],
  	[
  		119857,
  		1,
  		"x"
  	],
  	[
  		119858,
  		1,
  		"y"
  	],
  	[
  		119859,
  		1,
  		"z"
  	],
  	[
  		119860,
  		1,
  		"a"
  	],
  	[
  		119861,
  		1,
  		"b"
  	],
  	[
  		119862,
  		1,
  		"c"
  	],
  	[
  		119863,
  		1,
  		"d"
  	],
  	[
  		119864,
  		1,
  		"e"
  	],
  	[
  		119865,
  		1,
  		"f"
  	],
  	[
  		119866,
  		1,
  		"g"
  	],
  	[
  		119867,
  		1,
  		"h"
  	],
  	[
  		119868,
  		1,
  		"i"
  	],
  	[
  		119869,
  		1,
  		"j"
  	],
  	[
  		119870,
  		1,
  		"k"
  	],
  	[
  		119871,
  		1,
  		"l"
  	],
  	[
  		119872,
  		1,
  		"m"
  	],
  	[
  		119873,
  		1,
  		"n"
  	],
  	[
  		119874,
  		1,
  		"o"
  	],
  	[
  		119875,
  		1,
  		"p"
  	],
  	[
  		119876,
  		1,
  		"q"
  	],
  	[
  		119877,
  		1,
  		"r"
  	],
  	[
  		119878,
  		1,
  		"s"
  	],
  	[
  		119879,
  		1,
  		"t"
  	],
  	[
  		119880,
  		1,
  		"u"
  	],
  	[
  		119881,
  		1,
  		"v"
  	],
  	[
  		119882,
  		1,
  		"w"
  	],
  	[
  		119883,
  		1,
  		"x"
  	],
  	[
  		119884,
  		1,
  		"y"
  	],
  	[
  		119885,
  		1,
  		"z"
  	],
  	[
  		119886,
  		1,
  		"a"
  	],
  	[
  		119887,
  		1,
  		"b"
  	],
  	[
  		119888,
  		1,
  		"c"
  	],
  	[
  		119889,
  		1,
  		"d"
  	],
  	[
  		119890,
  		1,
  		"e"
  	],
  	[
  		119891,
  		1,
  		"f"
  	],
  	[
  		119892,
  		1,
  		"g"
  	],
  	[
  		119893,
  		3
  	],
  	[
  		119894,
  		1,
  		"i"
  	],
  	[
  		119895,
  		1,
  		"j"
  	],
  	[
  		119896,
  		1,
  		"k"
  	],
  	[
  		119897,
  		1,
  		"l"
  	],
  	[
  		119898,
  		1,
  		"m"
  	],
  	[
  		119899,
  		1,
  		"n"
  	],
  	[
  		119900,
  		1,
  		"o"
  	],
  	[
  		119901,
  		1,
  		"p"
  	],
  	[
  		119902,
  		1,
  		"q"
  	],
  	[
  		119903,
  		1,
  		"r"
  	],
  	[
  		119904,
  		1,
  		"s"
  	],
  	[
  		119905,
  		1,
  		"t"
  	],
  	[
  		119906,
  		1,
  		"u"
  	],
  	[
  		119907,
  		1,
  		"v"
  	],
  	[
  		119908,
  		1,
  		"w"
  	],
  	[
  		119909,
  		1,
  		"x"
  	],
  	[
  		119910,
  		1,
  		"y"
  	],
  	[
  		119911,
  		1,
  		"z"
  	],
  	[
  		119912,
  		1,
  		"a"
  	],
  	[
  		119913,
  		1,
  		"b"
  	],
  	[
  		119914,
  		1,
  		"c"
  	],
  	[
  		119915,
  		1,
  		"d"
  	],
  	[
  		119916,
  		1,
  		"e"
  	],
  	[
  		119917,
  		1,
  		"f"
  	],
  	[
  		119918,
  		1,
  		"g"
  	],
  	[
  		119919,
  		1,
  		"h"
  	],
  	[
  		119920,
  		1,
  		"i"
  	],
  	[
  		119921,
  		1,
  		"j"
  	],
  	[
  		119922,
  		1,
  		"k"
  	],
  	[
  		119923,
  		1,
  		"l"
  	],
  	[
  		119924,
  		1,
  		"m"
  	],
  	[
  		119925,
  		1,
  		"n"
  	],
  	[
  		119926,
  		1,
  		"o"
  	],
  	[
  		119927,
  		1,
  		"p"
  	],
  	[
  		119928,
  		1,
  		"q"
  	],
  	[
  		119929,
  		1,
  		"r"
  	],
  	[
  		119930,
  		1,
  		"s"
  	],
  	[
  		119931,
  		1,
  		"t"
  	],
  	[
  		119932,
  		1,
  		"u"
  	],
  	[
  		119933,
  		1,
  		"v"
  	],
  	[
  		119934,
  		1,
  		"w"
  	],
  	[
  		119935,
  		1,
  		"x"
  	],
  	[
  		119936,
  		1,
  		"y"
  	],
  	[
  		119937,
  		1,
  		"z"
  	],
  	[
  		119938,
  		1,
  		"a"
  	],
  	[
  		119939,
  		1,
  		"b"
  	],
  	[
  		119940,
  		1,
  		"c"
  	],
  	[
  		119941,
  		1,
  		"d"
  	],
  	[
  		119942,
  		1,
  		"e"
  	],
  	[
  		119943,
  		1,
  		"f"
  	],
  	[
  		119944,
  		1,
  		"g"
  	],
  	[
  		119945,
  		1,
  		"h"
  	],
  	[
  		119946,
  		1,
  		"i"
  	],
  	[
  		119947,
  		1,
  		"j"
  	],
  	[
  		119948,
  		1,
  		"k"
  	],
  	[
  		119949,
  		1,
  		"l"
  	],
  	[
  		119950,
  		1,
  		"m"
  	],
  	[
  		119951,
  		1,
  		"n"
  	],
  	[
  		119952,
  		1,
  		"o"
  	],
  	[
  		119953,
  		1,
  		"p"
  	],
  	[
  		119954,
  		1,
  		"q"
  	],
  	[
  		119955,
  		1,
  		"r"
  	],
  	[
  		119956,
  		1,
  		"s"
  	],
  	[
  		119957,
  		1,
  		"t"
  	],
  	[
  		119958,
  		1,
  		"u"
  	],
  	[
  		119959,
  		1,
  		"v"
  	],
  	[
  		119960,
  		1,
  		"w"
  	],
  	[
  		119961,
  		1,
  		"x"
  	],
  	[
  		119962,
  		1,
  		"y"
  	],
  	[
  		119963,
  		1,
  		"z"
  	],
  	[
  		119964,
  		1,
  		"a"
  	],
  	[
  		119965,
  		3
  	],
  	[
  		119966,
  		1,
  		"c"
  	],
  	[
  		119967,
  		1,
  		"d"
  	],
  	[
  		[
  			119968,
  			119969
  		],
  		3
  	],
  	[
  		119970,
  		1,
  		"g"
  	],
  	[
  		[
  			119971,
  			119972
  		],
  		3
  	],
  	[
  		119973,
  		1,
  		"j"
  	],
  	[
  		119974,
  		1,
  		"k"
  	],
  	[
  		[
  			119975,
  			119976
  		],
  		3
  	],
  	[
  		119977,
  		1,
  		"n"
  	],
  	[
  		119978,
  		1,
  		"o"
  	],
  	[
  		119979,
  		1,
  		"p"
  	],
  	[
  		119980,
  		1,
  		"q"
  	],
  	[
  		119981,
  		3
  	],
  	[
  		119982,
  		1,
  		"s"
  	],
  	[
  		119983,
  		1,
  		"t"
  	],
  	[
  		119984,
  		1,
  		"u"
  	],
  	[
  		119985,
  		1,
  		"v"
  	],
  	[
  		119986,
  		1,
  		"w"
  	],
  	[
  		119987,
  		1,
  		"x"
  	],
  	[
  		119988,
  		1,
  		"y"
  	],
  	[
  		119989,
  		1,
  		"z"
  	],
  	[
  		119990,
  		1,
  		"a"
  	],
  	[
  		119991,
  		1,
  		"b"
  	],
  	[
  		119992,
  		1,
  		"c"
  	],
  	[
  		119993,
  		1,
  		"d"
  	],
  	[
  		119994,
  		3
  	],
  	[
  		119995,
  		1,
  		"f"
  	],
  	[
  		119996,
  		3
  	],
  	[
  		119997,
  		1,
  		"h"
  	],
  	[
  		119998,
  		1,
  		"i"
  	],
  	[
  		119999,
  		1,
  		"j"
  	],
  	[
  		120000,
  		1,
  		"k"
  	],
  	[
  		120001,
  		1,
  		"l"
  	],
  	[
  		120002,
  		1,
  		"m"
  	],
  	[
  		120003,
  		1,
  		"n"
  	],
  	[
  		120004,
  		3
  	],
  	[
  		120005,
  		1,
  		"p"
  	],
  	[
  		120006,
  		1,
  		"q"
  	],
  	[
  		120007,
  		1,
  		"r"
  	],
  	[
  		120008,
  		1,
  		"s"
  	],
  	[
  		120009,
  		1,
  		"t"
  	],
  	[
  		120010,
  		1,
  		"u"
  	],
  	[
  		120011,
  		1,
  		"v"
  	],
  	[
  		120012,
  		1,
  		"w"
  	],
  	[
  		120013,
  		1,
  		"x"
  	],
  	[
  		120014,
  		1,
  		"y"
  	],
  	[
  		120015,
  		1,
  		"z"
  	],
  	[
  		120016,
  		1,
  		"a"
  	],
  	[
  		120017,
  		1,
  		"b"
  	],
  	[
  		120018,
  		1,
  		"c"
  	],
  	[
  		120019,
  		1,
  		"d"
  	],
  	[
  		120020,
  		1,
  		"e"
  	],
  	[
  		120021,
  		1,
  		"f"
  	],
  	[
  		120022,
  		1,
  		"g"
  	],
  	[
  		120023,
  		1,
  		"h"
  	],
  	[
  		120024,
  		1,
  		"i"
  	],
  	[
  		120025,
  		1,
  		"j"
  	],
  	[
  		120026,
  		1,
  		"k"
  	],
  	[
  		120027,
  		1,
  		"l"
  	],
  	[
  		120028,
  		1,
  		"m"
  	],
  	[
  		120029,
  		1,
  		"n"
  	],
  	[
  		120030,
  		1,
  		"o"
  	],
  	[
  		120031,
  		1,
  		"p"
  	],
  	[
  		120032,
  		1,
  		"q"
  	],
  	[
  		120033,
  		1,
  		"r"
  	],
  	[
  		120034,
  		1,
  		"s"
  	],
  	[
  		120035,
  		1,
  		"t"
  	],
  	[
  		120036,
  		1,
  		"u"
  	],
  	[
  		120037,
  		1,
  		"v"
  	],
  	[
  		120038,
  		1,
  		"w"
  	],
  	[
  		120039,
  		1,
  		"x"
  	],
  	[
  		120040,
  		1,
  		"y"
  	],
  	[
  		120041,
  		1,
  		"z"
  	],
  	[
  		120042,
  		1,
  		"a"
  	],
  	[
  		120043,
  		1,
  		"b"
  	],
  	[
  		120044,
  		1,
  		"c"
  	],
  	[
  		120045,
  		1,
  		"d"
  	],
  	[
  		120046,
  		1,
  		"e"
  	],
  	[
  		120047,
  		1,
  		"f"
  	],
  	[
  		120048,
  		1,
  		"g"
  	],
  	[
  		120049,
  		1,
  		"h"
  	],
  	[
  		120050,
  		1,
  		"i"
  	],
  	[
  		120051,
  		1,
  		"j"
  	],
  	[
  		120052,
  		1,
  		"k"
  	],
  	[
  		120053,
  		1,
  		"l"
  	],
  	[
  		120054,
  		1,
  		"m"
  	],
  	[
  		120055,
  		1,
  		"n"
  	],
  	[
  		120056,
  		1,
  		"o"
  	],
  	[
  		120057,
  		1,
  		"p"
  	],
  	[
  		120058,
  		1,
  		"q"
  	],
  	[
  		120059,
  		1,
  		"r"
  	],
  	[
  		120060,
  		1,
  		"s"
  	],
  	[
  		120061,
  		1,
  		"t"
  	],
  	[
  		120062,
  		1,
  		"u"
  	],
  	[
  		120063,
  		1,
  		"v"
  	],
  	[
  		120064,
  		1,
  		"w"
  	],
  	[
  		120065,
  		1,
  		"x"
  	],
  	[
  		120066,
  		1,
  		"y"
  	],
  	[
  		120067,
  		1,
  		"z"
  	],
  	[
  		120068,
  		1,
  		"a"
  	],
  	[
  		120069,
  		1,
  		"b"
  	],
  	[
  		120070,
  		3
  	],
  	[
  		120071,
  		1,
  		"d"
  	],
  	[
  		120072,
  		1,
  		"e"
  	],
  	[
  		120073,
  		1,
  		"f"
  	],
  	[
  		120074,
  		1,
  		"g"
  	],
  	[
  		[
  			120075,
  			120076
  		],
  		3
  	],
  	[
  		120077,
  		1,
  		"j"
  	],
  	[
  		120078,
  		1,
  		"k"
  	],
  	[
  		120079,
  		1,
  		"l"
  	],
  	[
  		120080,
  		1,
  		"m"
  	],
  	[
  		120081,
  		1,
  		"n"
  	],
  	[
  		120082,
  		1,
  		"o"
  	],
  	[
  		120083,
  		1,
  		"p"
  	],
  	[
  		120084,
  		1,
  		"q"
  	],
  	[
  		120085,
  		3
  	],
  	[
  		120086,
  		1,
  		"s"
  	],
  	[
  		120087,
  		1,
  		"t"
  	],
  	[
  		120088,
  		1,
  		"u"
  	],
  	[
  		120089,
  		1,
  		"v"
  	],
  	[
  		120090,
  		1,
  		"w"
  	],
  	[
  		120091,
  		1,
  		"x"
  	],
  	[
  		120092,
  		1,
  		"y"
  	],
  	[
  		120093,
  		3
  	],
  	[
  		120094,
  		1,
  		"a"
  	],
  	[
  		120095,
  		1,
  		"b"
  	],
  	[
  		120096,
  		1,
  		"c"
  	],
  	[
  		120097,
  		1,
  		"d"
  	],
  	[
  		120098,
  		1,
  		"e"
  	],
  	[
  		120099,
  		1,
  		"f"
  	],
  	[
  		120100,
  		1,
  		"g"
  	],
  	[
  		120101,
  		1,
  		"h"
  	],
  	[
  		120102,
  		1,
  		"i"
  	],
  	[
  		120103,
  		1,
  		"j"
  	],
  	[
  		120104,
  		1,
  		"k"
  	],
  	[
  		120105,
  		1,
  		"l"
  	],
  	[
  		120106,
  		1,
  		"m"
  	],
  	[
  		120107,
  		1,
  		"n"
  	],
  	[
  		120108,
  		1,
  		"o"
  	],
  	[
  		120109,
  		1,
  		"p"
  	],
  	[
  		120110,
  		1,
  		"q"
  	],
  	[
  		120111,
  		1,
  		"r"
  	],
  	[
  		120112,
  		1,
  		"s"
  	],
  	[
  		120113,
  		1,
  		"t"
  	],
  	[
  		120114,
  		1,
  		"u"
  	],
  	[
  		120115,
  		1,
  		"v"
  	],
  	[
  		120116,
  		1,
  		"w"
  	],
  	[
  		120117,
  		1,
  		"x"
  	],
  	[
  		120118,
  		1,
  		"y"
  	],
  	[
  		120119,
  		1,
  		"z"
  	],
  	[
  		120120,
  		1,
  		"a"
  	],
  	[
  		120121,
  		1,
  		"b"
  	],
  	[
  		120122,
  		3
  	],
  	[
  		120123,
  		1,
  		"d"
  	],
  	[
  		120124,
  		1,
  		"e"
  	],
  	[
  		120125,
  		1,
  		"f"
  	],
  	[
  		120126,
  		1,
  		"g"
  	],
  	[
  		120127,
  		3
  	],
  	[
  		120128,
  		1,
  		"i"
  	],
  	[
  		120129,
  		1,
  		"j"
  	],
  	[
  		120130,
  		1,
  		"k"
  	],
  	[
  		120131,
  		1,
  		"l"
  	],
  	[
  		120132,
  		1,
  		"m"
  	],
  	[
  		120133,
  		3
  	],
  	[
  		120134,
  		1,
  		"o"
  	],
  	[
  		[
  			120135,
  			120137
  		],
  		3
  	],
  	[
  		120138,
  		1,
  		"s"
  	],
  	[
  		120139,
  		1,
  		"t"
  	],
  	[
  		120140,
  		1,
  		"u"
  	],
  	[
  		120141,
  		1,
  		"v"
  	],
  	[
  		120142,
  		1,
  		"w"
  	],
  	[
  		120143,
  		1,
  		"x"
  	],
  	[
  		120144,
  		1,
  		"y"
  	],
  	[
  		120145,
  		3
  	],
  	[
  		120146,
  		1,
  		"a"
  	],
  	[
  		120147,
  		1,
  		"b"
  	],
  	[
  		120148,
  		1,
  		"c"
  	],
  	[
  		120149,
  		1,
  		"d"
  	],
  	[
  		120150,
  		1,
  		"e"
  	],
  	[
  		120151,
  		1,
  		"f"
  	],
  	[
  		120152,
  		1,
  		"g"
  	],
  	[
  		120153,
  		1,
  		"h"
  	],
  	[
  		120154,
  		1,
  		"i"
  	],
  	[
  		120155,
  		1,
  		"j"
  	],
  	[
  		120156,
  		1,
  		"k"
  	],
  	[
  		120157,
  		1,
  		"l"
  	],
  	[
  		120158,
  		1,
  		"m"
  	],
  	[
  		120159,
  		1,
  		"n"
  	],
  	[
  		120160,
  		1,
  		"o"
  	],
  	[
  		120161,
  		1,
  		"p"
  	],
  	[
  		120162,
  		1,
  		"q"
  	],
  	[
  		120163,
  		1,
  		"r"
  	],
  	[
  		120164,
  		1,
  		"s"
  	],
  	[
  		120165,
  		1,
  		"t"
  	],
  	[
  		120166,
  		1,
  		"u"
  	],
  	[
  		120167,
  		1,
  		"v"
  	],
  	[
  		120168,
  		1,
  		"w"
  	],
  	[
  		120169,
  		1,
  		"x"
  	],
  	[
  		120170,
  		1,
  		"y"
  	],
  	[
  		120171,
  		1,
  		"z"
  	],
  	[
  		120172,
  		1,
  		"a"
  	],
  	[
  		120173,
  		1,
  		"b"
  	],
  	[
  		120174,
  		1,
  		"c"
  	],
  	[
  		120175,
  		1,
  		"d"
  	],
  	[
  		120176,
  		1,
  		"e"
  	],
  	[
  		120177,
  		1,
  		"f"
  	],
  	[
  		120178,
  		1,
  		"g"
  	],
  	[
  		120179,
  		1,
  		"h"
  	],
  	[
  		120180,
  		1,
  		"i"
  	],
  	[
  		120181,
  		1,
  		"j"
  	],
  	[
  		120182,
  		1,
  		"k"
  	],
  	[
  		120183,
  		1,
  		"l"
  	],
  	[
  		120184,
  		1,
  		"m"
  	],
  	[
  		120185,
  		1,
  		"n"
  	],
  	[
  		120186,
  		1,
  		"o"
  	],
  	[
  		120187,
  		1,
  		"p"
  	],
  	[
  		120188,
  		1,
  		"q"
  	],
  	[
  		120189,
  		1,
  		"r"
  	],
  	[
  		120190,
  		1,
  		"s"
  	],
  	[
  		120191,
  		1,
  		"t"
  	],
  	[
  		120192,
  		1,
  		"u"
  	],
  	[
  		120193,
  		1,
  		"v"
  	],
  	[
  		120194,
  		1,
  		"w"
  	],
  	[
  		120195,
  		1,
  		"x"
  	],
  	[
  		120196,
  		1,
  		"y"
  	],
  	[
  		120197,
  		1,
  		"z"
  	],
  	[
  		120198,
  		1,
  		"a"
  	],
  	[
  		120199,
  		1,
  		"b"
  	],
  	[
  		120200,
  		1,
  		"c"
  	],
  	[
  		120201,
  		1,
  		"d"
  	],
  	[
  		120202,
  		1,
  		"e"
  	],
  	[
  		120203,
  		1,
  		"f"
  	],
  	[
  		120204,
  		1,
  		"g"
  	],
  	[
  		120205,
  		1,
  		"h"
  	],
  	[
  		120206,
  		1,
  		"i"
  	],
  	[
  		120207,
  		1,
  		"j"
  	],
  	[
  		120208,
  		1,
  		"k"
  	],
  	[
  		120209,
  		1,
  		"l"
  	],
  	[
  		120210,
  		1,
  		"m"
  	],
  	[
  		120211,
  		1,
  		"n"
  	],
  	[
  		120212,
  		1,
  		"o"
  	],
  	[
  		120213,
  		1,
  		"p"
  	],
  	[
  		120214,
  		1,
  		"q"
  	],
  	[
  		120215,
  		1,
  		"r"
  	],
  	[
  		120216,
  		1,
  		"s"
  	],
  	[
  		120217,
  		1,
  		"t"
  	],
  	[
  		120218,
  		1,
  		"u"
  	],
  	[
  		120219,
  		1,
  		"v"
  	],
  	[
  		120220,
  		1,
  		"w"
  	],
  	[
  		120221,
  		1,
  		"x"
  	],
  	[
  		120222,
  		1,
  		"y"
  	],
  	[
  		120223,
  		1,
  		"z"
  	],
  	[
  		120224,
  		1,
  		"a"
  	],
  	[
  		120225,
  		1,
  		"b"
  	],
  	[
  		120226,
  		1,
  		"c"
  	],
  	[
  		120227,
  		1,
  		"d"
  	],
  	[
  		120228,
  		1,
  		"e"
  	],
  	[
  		120229,
  		1,
  		"f"
  	],
  	[
  		120230,
  		1,
  		"g"
  	],
  	[
  		120231,
  		1,
  		"h"
  	],
  	[
  		120232,
  		1,
  		"i"
  	],
  	[
  		120233,
  		1,
  		"j"
  	],
  	[
  		120234,
  		1,
  		"k"
  	],
  	[
  		120235,
  		1,
  		"l"
  	],
  	[
  		120236,
  		1,
  		"m"
  	],
  	[
  		120237,
  		1,
  		"n"
  	],
  	[
  		120238,
  		1,
  		"o"
  	],
  	[
  		120239,
  		1,
  		"p"
  	],
  	[
  		120240,
  		1,
  		"q"
  	],
  	[
  		120241,
  		1,
  		"r"
  	],
  	[
  		120242,
  		1,
  		"s"
  	],
  	[
  		120243,
  		1,
  		"t"
  	],
  	[
  		120244,
  		1,
  		"u"
  	],
  	[
  		120245,
  		1,
  		"v"
  	],
  	[
  		120246,
  		1,
  		"w"
  	],
  	[
  		120247,
  		1,
  		"x"
  	],
  	[
  		120248,
  		1,
  		"y"
  	],
  	[
  		120249,
  		1,
  		"z"
  	],
  	[
  		120250,
  		1,
  		"a"
  	],
  	[
  		120251,
  		1,
  		"b"
  	],
  	[
  		120252,
  		1,
  		"c"
  	],
  	[
  		120253,
  		1,
  		"d"
  	],
  	[
  		120254,
  		1,
  		"e"
  	],
  	[
  		120255,
  		1,
  		"f"
  	],
  	[
  		120256,
  		1,
  		"g"
  	],
  	[
  		120257,
  		1,
  		"h"
  	],
  	[
  		120258,
  		1,
  		"i"
  	],
  	[
  		120259,
  		1,
  		"j"
  	],
  	[
  		120260,
  		1,
  		"k"
  	],
  	[
  		120261,
  		1,
  		"l"
  	],
  	[
  		120262,
  		1,
  		"m"
  	],
  	[
  		120263,
  		1,
  		"n"
  	],
  	[
  		120264,
  		1,
  		"o"
  	],
  	[
  		120265,
  		1,
  		"p"
  	],
  	[
  		120266,
  		1,
  		"q"
  	],
  	[
  		120267,
  		1,
  		"r"
  	],
  	[
  		120268,
  		1,
  		"s"
  	],
  	[
  		120269,
  		1,
  		"t"
  	],
  	[
  		120270,
  		1,
  		"u"
  	],
  	[
  		120271,
  		1,
  		"v"
  	],
  	[
  		120272,
  		1,
  		"w"
  	],
  	[
  		120273,
  		1,
  		"x"
  	],
  	[
  		120274,
  		1,
  		"y"
  	],
  	[
  		120275,
  		1,
  		"z"
  	],
  	[
  		120276,
  		1,
  		"a"
  	],
  	[
  		120277,
  		1,
  		"b"
  	],
  	[
  		120278,
  		1,
  		"c"
  	],
  	[
  		120279,
  		1,
  		"d"
  	],
  	[
  		120280,
  		1,
  		"e"
  	],
  	[
  		120281,
  		1,
  		"f"
  	],
  	[
  		120282,
  		1,
  		"g"
  	],
  	[
  		120283,
  		1,
  		"h"
  	],
  	[
  		120284,
  		1,
  		"i"
  	],
  	[
  		120285,
  		1,
  		"j"
  	],
  	[
  		120286,
  		1,
  		"k"
  	],
  	[
  		120287,
  		1,
  		"l"
  	],
  	[
  		120288,
  		1,
  		"m"
  	],
  	[
  		120289,
  		1,
  		"n"
  	],
  	[
  		120290,
  		1,
  		"o"
  	],
  	[
  		120291,
  		1,
  		"p"
  	],
  	[
  		120292,
  		1,
  		"q"
  	],
  	[
  		120293,
  		1,
  		"r"
  	],
  	[
  		120294,
  		1,
  		"s"
  	],
  	[
  		120295,
  		1,
  		"t"
  	],
  	[
  		120296,
  		1,
  		"u"
  	],
  	[
  		120297,
  		1,
  		"v"
  	],
  	[
  		120298,
  		1,
  		"w"
  	],
  	[
  		120299,
  		1,
  		"x"
  	],
  	[
  		120300,
  		1,
  		"y"
  	],
  	[
  		120301,
  		1,
  		"z"
  	],
  	[
  		120302,
  		1,
  		"a"
  	],
  	[
  		120303,
  		1,
  		"b"
  	],
  	[
  		120304,
  		1,
  		"c"
  	],
  	[
  		120305,
  		1,
  		"d"
  	],
  	[
  		120306,
  		1,
  		"e"
  	],
  	[
  		120307,
  		1,
  		"f"
  	],
  	[
  		120308,
  		1,
  		"g"
  	],
  	[
  		120309,
  		1,
  		"h"
  	],
  	[
  		120310,
  		1,
  		"i"
  	],
  	[
  		120311,
  		1,
  		"j"
  	],
  	[
  		120312,
  		1,
  		"k"
  	],
  	[
  		120313,
  		1,
  		"l"
  	],
  	[
  		120314,
  		1,
  		"m"
  	],
  	[
  		120315,
  		1,
  		"n"
  	],
  	[
  		120316,
  		1,
  		"o"
  	],
  	[
  		120317,
  		1,
  		"p"
  	],
  	[
  		120318,
  		1,
  		"q"
  	],
  	[
  		120319,
  		1,
  		"r"
  	],
  	[
  		120320,
  		1,
  		"s"
  	],
  	[
  		120321,
  		1,
  		"t"
  	],
  	[
  		120322,
  		1,
  		"u"
  	],
  	[
  		120323,
  		1,
  		"v"
  	],
  	[
  		120324,
  		1,
  		"w"
  	],
  	[
  		120325,
  		1,
  		"x"
  	],
  	[
  		120326,
  		1,
  		"y"
  	],
  	[
  		120327,
  		1,
  		"z"
  	],
  	[
  		120328,
  		1,
  		"a"
  	],
  	[
  		120329,
  		1,
  		"b"
  	],
  	[
  		120330,
  		1,
  		"c"
  	],
  	[
  		120331,
  		1,
  		"d"
  	],
  	[
  		120332,
  		1,
  		"e"
  	],
  	[
  		120333,
  		1,
  		"f"
  	],
  	[
  		120334,
  		1,
  		"g"
  	],
  	[
  		120335,
  		1,
  		"h"
  	],
  	[
  		120336,
  		1,
  		"i"
  	],
  	[
  		120337,
  		1,
  		"j"
  	],
  	[
  		120338,
  		1,
  		"k"
  	],
  	[
  		120339,
  		1,
  		"l"
  	],
  	[
  		120340,
  		1,
  		"m"
  	],
  	[
  		120341,
  		1,
  		"n"
  	],
  	[
  		120342,
  		1,
  		"o"
  	],
  	[
  		120343,
  		1,
  		"p"
  	],
  	[
  		120344,
  		1,
  		"q"
  	],
  	[
  		120345,
  		1,
  		"r"
  	],
  	[
  		120346,
  		1,
  		"s"
  	],
  	[
  		120347,
  		1,
  		"t"
  	],
  	[
  		120348,
  		1,
  		"u"
  	],
  	[
  		120349,
  		1,
  		"v"
  	],
  	[
  		120350,
  		1,
  		"w"
  	],
  	[
  		120351,
  		1,
  		"x"
  	],
  	[
  		120352,
  		1,
  		"y"
  	],
  	[
  		120353,
  		1,
  		"z"
  	],
  	[
  		120354,
  		1,
  		"a"
  	],
  	[
  		120355,
  		1,
  		"b"
  	],
  	[
  		120356,
  		1,
  		"c"
  	],
  	[
  		120357,
  		1,
  		"d"
  	],
  	[
  		120358,
  		1,
  		"e"
  	],
  	[
  		120359,
  		1,
  		"f"
  	],
  	[
  		120360,
  		1,
  		"g"
  	],
  	[
  		120361,
  		1,
  		"h"
  	],
  	[
  		120362,
  		1,
  		"i"
  	],
  	[
  		120363,
  		1,
  		"j"
  	],
  	[
  		120364,
  		1,
  		"k"
  	],
  	[
  		120365,
  		1,
  		"l"
  	],
  	[
  		120366,
  		1,
  		"m"
  	],
  	[
  		120367,
  		1,
  		"n"
  	],
  	[
  		120368,
  		1,
  		"o"
  	],
  	[
  		120369,
  		1,
  		"p"
  	],
  	[
  		120370,
  		1,
  		"q"
  	],
  	[
  		120371,
  		1,
  		"r"
  	],
  	[
  		120372,
  		1,
  		"s"
  	],
  	[
  		120373,
  		1,
  		"t"
  	],
  	[
  		120374,
  		1,
  		"u"
  	],
  	[
  		120375,
  		1,
  		"v"
  	],
  	[
  		120376,
  		1,
  		"w"
  	],
  	[
  		120377,
  		1,
  		"x"
  	],
  	[
  		120378,
  		1,
  		"y"
  	],
  	[
  		120379,
  		1,
  		"z"
  	],
  	[
  		120380,
  		1,
  		"a"
  	],
  	[
  		120381,
  		1,
  		"b"
  	],
  	[
  		120382,
  		1,
  		"c"
  	],
  	[
  		120383,
  		1,
  		"d"
  	],
  	[
  		120384,
  		1,
  		"e"
  	],
  	[
  		120385,
  		1,
  		"f"
  	],
  	[
  		120386,
  		1,
  		"g"
  	],
  	[
  		120387,
  		1,
  		"h"
  	],
  	[
  		120388,
  		1,
  		"i"
  	],
  	[
  		120389,
  		1,
  		"j"
  	],
  	[
  		120390,
  		1,
  		"k"
  	],
  	[
  		120391,
  		1,
  		"l"
  	],
  	[
  		120392,
  		1,
  		"m"
  	],
  	[
  		120393,
  		1,
  		"n"
  	],
  	[
  		120394,
  		1,
  		"o"
  	],
  	[
  		120395,
  		1,
  		"p"
  	],
  	[
  		120396,
  		1,
  		"q"
  	],
  	[
  		120397,
  		1,
  		"r"
  	],
  	[
  		120398,
  		1,
  		"s"
  	],
  	[
  		120399,
  		1,
  		"t"
  	],
  	[
  		120400,
  		1,
  		"u"
  	],
  	[
  		120401,
  		1,
  		"v"
  	],
  	[
  		120402,
  		1,
  		"w"
  	],
  	[
  		120403,
  		1,
  		"x"
  	],
  	[
  		120404,
  		1,
  		"y"
  	],
  	[
  		120405,
  		1,
  		"z"
  	],
  	[
  		120406,
  		1,
  		"a"
  	],
  	[
  		120407,
  		1,
  		"b"
  	],
  	[
  		120408,
  		1,
  		"c"
  	],
  	[
  		120409,
  		1,
  		"d"
  	],
  	[
  		120410,
  		1,
  		"e"
  	],
  	[
  		120411,
  		1,
  		"f"
  	],
  	[
  		120412,
  		1,
  		"g"
  	],
  	[
  		120413,
  		1,
  		"h"
  	],
  	[
  		120414,
  		1,
  		"i"
  	],
  	[
  		120415,
  		1,
  		"j"
  	],
  	[
  		120416,
  		1,
  		"k"
  	],
  	[
  		120417,
  		1,
  		"l"
  	],
  	[
  		120418,
  		1,
  		"m"
  	],
  	[
  		120419,
  		1,
  		"n"
  	],
  	[
  		120420,
  		1,
  		"o"
  	],
  	[
  		120421,
  		1,
  		"p"
  	],
  	[
  		120422,
  		1,
  		"q"
  	],
  	[
  		120423,
  		1,
  		"r"
  	],
  	[
  		120424,
  		1,
  		"s"
  	],
  	[
  		120425,
  		1,
  		"t"
  	],
  	[
  		120426,
  		1,
  		"u"
  	],
  	[
  		120427,
  		1,
  		"v"
  	],
  	[
  		120428,
  		1,
  		"w"
  	],
  	[
  		120429,
  		1,
  		"x"
  	],
  	[
  		120430,
  		1,
  		"y"
  	],
  	[
  		120431,
  		1,
  		"z"
  	],
  	[
  		120432,
  		1,
  		"a"
  	],
  	[
  		120433,
  		1,
  		"b"
  	],
  	[
  		120434,
  		1,
  		"c"
  	],
  	[
  		120435,
  		1,
  		"d"
  	],
  	[
  		120436,
  		1,
  		"e"
  	],
  	[
  		120437,
  		1,
  		"f"
  	],
  	[
  		120438,
  		1,
  		"g"
  	],
  	[
  		120439,
  		1,
  		"h"
  	],
  	[
  		120440,
  		1,
  		"i"
  	],
  	[
  		120441,
  		1,
  		"j"
  	],
  	[
  		120442,
  		1,
  		"k"
  	],
  	[
  		120443,
  		1,
  		"l"
  	],
  	[
  		120444,
  		1,
  		"m"
  	],
  	[
  		120445,
  		1,
  		"n"
  	],
  	[
  		120446,
  		1,
  		"o"
  	],
  	[
  		120447,
  		1,
  		"p"
  	],
  	[
  		120448,
  		1,
  		"q"
  	],
  	[
  		120449,
  		1,
  		"r"
  	],
  	[
  		120450,
  		1,
  		"s"
  	],
  	[
  		120451,
  		1,
  		"t"
  	],
  	[
  		120452,
  		1,
  		"u"
  	],
  	[
  		120453,
  		1,
  		"v"
  	],
  	[
  		120454,
  		1,
  		"w"
  	],
  	[
  		120455,
  		1,
  		"x"
  	],
  	[
  		120456,
  		1,
  		"y"
  	],
  	[
  		120457,
  		1,
  		"z"
  	],
  	[
  		120458,
  		1,
  		"a"
  	],
  	[
  		120459,
  		1,
  		"b"
  	],
  	[
  		120460,
  		1,
  		"c"
  	],
  	[
  		120461,
  		1,
  		"d"
  	],
  	[
  		120462,
  		1,
  		"e"
  	],
  	[
  		120463,
  		1,
  		"f"
  	],
  	[
  		120464,
  		1,
  		"g"
  	],
  	[
  		120465,
  		1,
  		"h"
  	],
  	[
  		120466,
  		1,
  		"i"
  	],
  	[
  		120467,
  		1,
  		"j"
  	],
  	[
  		120468,
  		1,
  		"k"
  	],
  	[
  		120469,
  		1,
  		"l"
  	],
  	[
  		120470,
  		1,
  		"m"
  	],
  	[
  		120471,
  		1,
  		"n"
  	],
  	[
  		120472,
  		1,
  		"o"
  	],
  	[
  		120473,
  		1,
  		"p"
  	],
  	[
  		120474,
  		1,
  		"q"
  	],
  	[
  		120475,
  		1,
  		"r"
  	],
  	[
  		120476,
  		1,
  		"s"
  	],
  	[
  		120477,
  		1,
  		"t"
  	],
  	[
  		120478,
  		1,
  		"u"
  	],
  	[
  		120479,
  		1,
  		"v"
  	],
  	[
  		120480,
  		1,
  		"w"
  	],
  	[
  		120481,
  		1,
  		"x"
  	],
  	[
  		120482,
  		1,
  		"y"
  	],
  	[
  		120483,
  		1,
  		"z"
  	],
  	[
  		120484,
  		1,
  		"ı"
  	],
  	[
  		120485,
  		1,
  		"ȷ"
  	],
  	[
  		[
  			120486,
  			120487
  		],
  		3
  	],
  	[
  		120488,
  		1,
  		"α"
  	],
  	[
  		120489,
  		1,
  		"β"
  	],
  	[
  		120490,
  		1,
  		"γ"
  	],
  	[
  		120491,
  		1,
  		"δ"
  	],
  	[
  		120492,
  		1,
  		"ε"
  	],
  	[
  		120493,
  		1,
  		"ζ"
  	],
  	[
  		120494,
  		1,
  		"η"
  	],
  	[
  		120495,
  		1,
  		"θ"
  	],
  	[
  		120496,
  		1,
  		"ι"
  	],
  	[
  		120497,
  		1,
  		"κ"
  	],
  	[
  		120498,
  		1,
  		"λ"
  	],
  	[
  		120499,
  		1,
  		"μ"
  	],
  	[
  		120500,
  		1,
  		"ν"
  	],
  	[
  		120501,
  		1,
  		"ξ"
  	],
  	[
  		120502,
  		1,
  		"ο"
  	],
  	[
  		120503,
  		1,
  		"π"
  	],
  	[
  		120504,
  		1,
  		"ρ"
  	],
  	[
  		120505,
  		1,
  		"θ"
  	],
  	[
  		120506,
  		1,
  		"σ"
  	],
  	[
  		120507,
  		1,
  		"τ"
  	],
  	[
  		120508,
  		1,
  		"υ"
  	],
  	[
  		120509,
  		1,
  		"φ"
  	],
  	[
  		120510,
  		1,
  		"χ"
  	],
  	[
  		120511,
  		1,
  		"ψ"
  	],
  	[
  		120512,
  		1,
  		"ω"
  	],
  	[
  		120513,
  		1,
  		"∇"
  	],
  	[
  		120514,
  		1,
  		"α"
  	],
  	[
  		120515,
  		1,
  		"β"
  	],
  	[
  		120516,
  		1,
  		"γ"
  	],
  	[
  		120517,
  		1,
  		"δ"
  	],
  	[
  		120518,
  		1,
  		"ε"
  	],
  	[
  		120519,
  		1,
  		"ζ"
  	],
  	[
  		120520,
  		1,
  		"η"
  	],
  	[
  		120521,
  		1,
  		"θ"
  	],
  	[
  		120522,
  		1,
  		"ι"
  	],
  	[
  		120523,
  		1,
  		"κ"
  	],
  	[
  		120524,
  		1,
  		"λ"
  	],
  	[
  		120525,
  		1,
  		"μ"
  	],
  	[
  		120526,
  		1,
  		"ν"
  	],
  	[
  		120527,
  		1,
  		"ξ"
  	],
  	[
  		120528,
  		1,
  		"ο"
  	],
  	[
  		120529,
  		1,
  		"π"
  	],
  	[
  		120530,
  		1,
  		"ρ"
  	],
  	[
  		[
  			120531,
  			120532
  		],
  		1,
  		"σ"
  	],
  	[
  		120533,
  		1,
  		"τ"
  	],
  	[
  		120534,
  		1,
  		"υ"
  	],
  	[
  		120535,
  		1,
  		"φ"
  	],
  	[
  		120536,
  		1,
  		"χ"
  	],
  	[
  		120537,
  		1,
  		"ψ"
  	],
  	[
  		120538,
  		1,
  		"ω"
  	],
  	[
  		120539,
  		1,
  		"∂"
  	],
  	[
  		120540,
  		1,
  		"ε"
  	],
  	[
  		120541,
  		1,
  		"θ"
  	],
  	[
  		120542,
  		1,
  		"κ"
  	],
  	[
  		120543,
  		1,
  		"φ"
  	],
  	[
  		120544,
  		1,
  		"ρ"
  	],
  	[
  		120545,
  		1,
  		"π"
  	],
  	[
  		120546,
  		1,
  		"α"
  	],
  	[
  		120547,
  		1,
  		"β"
  	],
  	[
  		120548,
  		1,
  		"γ"
  	],
  	[
  		120549,
  		1,
  		"δ"
  	],
  	[
  		120550,
  		1,
  		"ε"
  	],
  	[
  		120551,
  		1,
  		"ζ"
  	],
  	[
  		120552,
  		1,
  		"η"
  	],
  	[
  		120553,
  		1,
  		"θ"
  	],
  	[
  		120554,
  		1,
  		"ι"
  	],
  	[
  		120555,
  		1,
  		"κ"
  	],
  	[
  		120556,
  		1,
  		"λ"
  	],
  	[
  		120557,
  		1,
  		"μ"
  	],
  	[
  		120558,
  		1,
  		"ν"
  	],
  	[
  		120559,
  		1,
  		"ξ"
  	],
  	[
  		120560,
  		1,
  		"ο"
  	],
  	[
  		120561,
  		1,
  		"π"
  	],
  	[
  		120562,
  		1,
  		"ρ"
  	],
  	[
  		120563,
  		1,
  		"θ"
  	],
  	[
  		120564,
  		1,
  		"σ"
  	],
  	[
  		120565,
  		1,
  		"τ"
  	],
  	[
  		120566,
  		1,
  		"υ"
  	],
  	[
  		120567,
  		1,
  		"φ"
  	],
  	[
  		120568,
  		1,
  		"χ"
  	],
  	[
  		120569,
  		1,
  		"ψ"
  	],
  	[
  		120570,
  		1,
  		"ω"
  	],
  	[
  		120571,
  		1,
  		"∇"
  	],
  	[
  		120572,
  		1,
  		"α"
  	],
  	[
  		120573,
  		1,
  		"β"
  	],
  	[
  		120574,
  		1,
  		"γ"
  	],
  	[
  		120575,
  		1,
  		"δ"
  	],
  	[
  		120576,
  		1,
  		"ε"
  	],
  	[
  		120577,
  		1,
  		"ζ"
  	],
  	[
  		120578,
  		1,
  		"η"
  	],
  	[
  		120579,
  		1,
  		"θ"
  	],
  	[
  		120580,
  		1,
  		"ι"
  	],
  	[
  		120581,
  		1,
  		"κ"
  	],
  	[
  		120582,
  		1,
  		"λ"
  	],
  	[
  		120583,
  		1,
  		"μ"
  	],
  	[
  		120584,
  		1,
  		"ν"
  	],
  	[
  		120585,
  		1,
  		"ξ"
  	],
  	[
  		120586,
  		1,
  		"ο"
  	],
  	[
  		120587,
  		1,
  		"π"
  	],
  	[
  		120588,
  		1,
  		"ρ"
  	],
  	[
  		[
  			120589,
  			120590
  		],
  		1,
  		"σ"
  	],
  	[
  		120591,
  		1,
  		"τ"
  	],
  	[
  		120592,
  		1,
  		"υ"
  	],
  	[
  		120593,
  		1,
  		"φ"
  	],
  	[
  		120594,
  		1,
  		"χ"
  	],
  	[
  		120595,
  		1,
  		"ψ"
  	],
  	[
  		120596,
  		1,
  		"ω"
  	],
  	[
  		120597,
  		1,
  		"∂"
  	],
  	[
  		120598,
  		1,
  		"ε"
  	],
  	[
  		120599,
  		1,
  		"θ"
  	],
  	[
  		120600,
  		1,
  		"κ"
  	],
  	[
  		120601,
  		1,
  		"φ"
  	],
  	[
  		120602,
  		1,
  		"ρ"
  	],
  	[
  		120603,
  		1,
  		"π"
  	],
  	[
  		120604,
  		1,
  		"α"
  	],
  	[
  		120605,
  		1,
  		"β"
  	],
  	[
  		120606,
  		1,
  		"γ"
  	],
  	[
  		120607,
  		1,
  		"δ"
  	],
  	[
  		120608,
  		1,
  		"ε"
  	],
  	[
  		120609,
  		1,
  		"ζ"
  	],
  	[
  		120610,
  		1,
  		"η"
  	],
  	[
  		120611,
  		1,
  		"θ"
  	],
  	[
  		120612,
  		1,
  		"ι"
  	],
  	[
  		120613,
  		1,
  		"κ"
  	],
  	[
  		120614,
  		1,
  		"λ"
  	],
  	[
  		120615,
  		1,
  		"μ"
  	],
  	[
  		120616,
  		1,
  		"ν"
  	],
  	[
  		120617,
  		1,
  		"ξ"
  	],
  	[
  		120618,
  		1,
  		"ο"
  	],
  	[
  		120619,
  		1,
  		"π"
  	],
  	[
  		120620,
  		1,
  		"ρ"
  	],
  	[
  		120621,
  		1,
  		"θ"
  	],
  	[
  		120622,
  		1,
  		"σ"
  	],
  	[
  		120623,
  		1,
  		"τ"
  	],
  	[
  		120624,
  		1,
  		"υ"
  	],
  	[
  		120625,
  		1,
  		"φ"
  	],
  	[
  		120626,
  		1,
  		"χ"
  	],
  	[
  		120627,
  		1,
  		"ψ"
  	],
  	[
  		120628,
  		1,
  		"ω"
  	],
  	[
  		120629,
  		1,
  		"∇"
  	],
  	[
  		120630,
  		1,
  		"α"
  	],
  	[
  		120631,
  		1,
  		"β"
  	],
  	[
  		120632,
  		1,
  		"γ"
  	],
  	[
  		120633,
  		1,
  		"δ"
  	],
  	[
  		120634,
  		1,
  		"ε"
  	],
  	[
  		120635,
  		1,
  		"ζ"
  	],
  	[
  		120636,
  		1,
  		"η"
  	],
  	[
  		120637,
  		1,
  		"θ"
  	],
  	[
  		120638,
  		1,
  		"ι"
  	],
  	[
  		120639,
  		1,
  		"κ"
  	],
  	[
  		120640,
  		1,
  		"λ"
  	],
  	[
  		120641,
  		1,
  		"μ"
  	],
  	[
  		120642,
  		1,
  		"ν"
  	],
  	[
  		120643,
  		1,
  		"ξ"
  	],
  	[
  		120644,
  		1,
  		"ο"
  	],
  	[
  		120645,
  		1,
  		"π"
  	],
  	[
  		120646,
  		1,
  		"ρ"
  	],
  	[
  		[
  			120647,
  			120648
  		],
  		1,
  		"σ"
  	],
  	[
  		120649,
  		1,
  		"τ"
  	],
  	[
  		120650,
  		1,
  		"υ"
  	],
  	[
  		120651,
  		1,
  		"φ"
  	],
  	[
  		120652,
  		1,
  		"χ"
  	],
  	[
  		120653,
  		1,
  		"ψ"
  	],
  	[
  		120654,
  		1,
  		"ω"
  	],
  	[
  		120655,
  		1,
  		"∂"
  	],
  	[
  		120656,
  		1,
  		"ε"
  	],
  	[
  		120657,
  		1,
  		"θ"
  	],
  	[
  		120658,
  		1,
  		"κ"
  	],
  	[
  		120659,
  		1,
  		"φ"
  	],
  	[
  		120660,
  		1,
  		"ρ"
  	],
  	[
  		120661,
  		1,
  		"π"
  	],
  	[
  		120662,
  		1,
  		"α"
  	],
  	[
  		120663,
  		1,
  		"β"
  	],
  	[
  		120664,
  		1,
  		"γ"
  	],
  	[
  		120665,
  		1,
  		"δ"
  	],
  	[
  		120666,
  		1,
  		"ε"
  	],
  	[
  		120667,
  		1,
  		"ζ"
  	],
  	[
  		120668,
  		1,
  		"η"
  	],
  	[
  		120669,
  		1,
  		"θ"
  	],
  	[
  		120670,
  		1,
  		"ι"
  	],
  	[
  		120671,
  		1,
  		"κ"
  	],
  	[
  		120672,
  		1,
  		"λ"
  	],
  	[
  		120673,
  		1,
  		"μ"
  	],
  	[
  		120674,
  		1,
  		"ν"
  	],
  	[
  		120675,
  		1,
  		"ξ"
  	],
  	[
  		120676,
  		1,
  		"ο"
  	],
  	[
  		120677,
  		1,
  		"π"
  	],
  	[
  		120678,
  		1,
  		"ρ"
  	],
  	[
  		120679,
  		1,
  		"θ"
  	],
  	[
  		120680,
  		1,
  		"σ"
  	],
  	[
  		120681,
  		1,
  		"τ"
  	],
  	[
  		120682,
  		1,
  		"υ"
  	],
  	[
  		120683,
  		1,
  		"φ"
  	],
  	[
  		120684,
  		1,
  		"χ"
  	],
  	[
  		120685,
  		1,
  		"ψ"
  	],
  	[
  		120686,
  		1,
  		"ω"
  	],
  	[
  		120687,
  		1,
  		"∇"
  	],
  	[
  		120688,
  		1,
  		"α"
  	],
  	[
  		120689,
  		1,
  		"β"
  	],
  	[
  		120690,
  		1,
  		"γ"
  	],
  	[
  		120691,
  		1,
  		"δ"
  	],
  	[
  		120692,
  		1,
  		"ε"
  	],
  	[
  		120693,
  		1,
  		"ζ"
  	],
  	[
  		120694,
  		1,
  		"η"
  	],
  	[
  		120695,
  		1,
  		"θ"
  	],
  	[
  		120696,
  		1,
  		"ι"
  	],
  	[
  		120697,
  		1,
  		"κ"
  	],
  	[
  		120698,
  		1,
  		"λ"
  	],
  	[
  		120699,
  		1,
  		"μ"
  	],
  	[
  		120700,
  		1,
  		"ν"
  	],
  	[
  		120701,
  		1,
  		"ξ"
  	],
  	[
  		120702,
  		1,
  		"ο"
  	],
  	[
  		120703,
  		1,
  		"π"
  	],
  	[
  		120704,
  		1,
  		"ρ"
  	],
  	[
  		[
  			120705,
  			120706
  		],
  		1,
  		"σ"
  	],
  	[
  		120707,
  		1,
  		"τ"
  	],
  	[
  		120708,
  		1,
  		"υ"
  	],
  	[
  		120709,
  		1,
  		"φ"
  	],
  	[
  		120710,
  		1,
  		"χ"
  	],
  	[
  		120711,
  		1,
  		"ψ"
  	],
  	[
  		120712,
  		1,
  		"ω"
  	],
  	[
  		120713,
  		1,
  		"∂"
  	],
  	[
  		120714,
  		1,
  		"ε"
  	],
  	[
  		120715,
  		1,
  		"θ"
  	],
  	[
  		120716,
  		1,
  		"κ"
  	],
  	[
  		120717,
  		1,
  		"φ"
  	],
  	[
  		120718,
  		1,
  		"ρ"
  	],
  	[
  		120719,
  		1,
  		"π"
  	],
  	[
  		120720,
  		1,
  		"α"
  	],
  	[
  		120721,
  		1,
  		"β"
  	],
  	[
  		120722,
  		1,
  		"γ"
  	],
  	[
  		120723,
  		1,
  		"δ"
  	],
  	[
  		120724,
  		1,
  		"ε"
  	],
  	[
  		120725,
  		1,
  		"ζ"
  	],
  	[
  		120726,
  		1,
  		"η"
  	],
  	[
  		120727,
  		1,
  		"θ"
  	],
  	[
  		120728,
  		1,
  		"ι"
  	],
  	[
  		120729,
  		1,
  		"κ"
  	],
  	[
  		120730,
  		1,
  		"λ"
  	],
  	[
  		120731,
  		1,
  		"μ"
  	],
  	[
  		120732,
  		1,
  		"ν"
  	],
  	[
  		120733,
  		1,
  		"ξ"
  	],
  	[
  		120734,
  		1,
  		"ο"
  	],
  	[
  		120735,
  		1,
  		"π"
  	],
  	[
  		120736,
  		1,
  		"ρ"
  	],
  	[
  		120737,
  		1,
  		"θ"
  	],
  	[
  		120738,
  		1,
  		"σ"
  	],
  	[
  		120739,
  		1,
  		"τ"
  	],
  	[
  		120740,
  		1,
  		"υ"
  	],
  	[
  		120741,
  		1,
  		"φ"
  	],
  	[
  		120742,
  		1,
  		"χ"
  	],
  	[
  		120743,
  		1,
  		"ψ"
  	],
  	[
  		120744,
  		1,
  		"ω"
  	],
  	[
  		120745,
  		1,
  		"∇"
  	],
  	[
  		120746,
  		1,
  		"α"
  	],
  	[
  		120747,
  		1,
  		"β"
  	],
  	[
  		120748,
  		1,
  		"γ"
  	],
  	[
  		120749,
  		1,
  		"δ"
  	],
  	[
  		120750,
  		1,
  		"ε"
  	],
  	[
  		120751,
  		1,
  		"ζ"
  	],
  	[
  		120752,
  		1,
  		"η"
  	],
  	[
  		120753,
  		1,
  		"θ"
  	],
  	[
  		120754,
  		1,
  		"ι"
  	],
  	[
  		120755,
  		1,
  		"κ"
  	],
  	[
  		120756,
  		1,
  		"λ"
  	],
  	[
  		120757,
  		1,
  		"μ"
  	],
  	[
  		120758,
  		1,
  		"ν"
  	],
  	[
  		120759,
  		1,
  		"ξ"
  	],
  	[
  		120760,
  		1,
  		"ο"
  	],
  	[
  		120761,
  		1,
  		"π"
  	],
  	[
  		120762,
  		1,
  		"ρ"
  	],
  	[
  		[
  			120763,
  			120764
  		],
  		1,
  		"σ"
  	],
  	[
  		120765,
  		1,
  		"τ"
  	],
  	[
  		120766,
  		1,
  		"υ"
  	],
  	[
  		120767,
  		1,
  		"φ"
  	],
  	[
  		120768,
  		1,
  		"χ"
  	],
  	[
  		120769,
  		1,
  		"ψ"
  	],
  	[
  		120770,
  		1,
  		"ω"
  	],
  	[
  		120771,
  		1,
  		"∂"
  	],
  	[
  		120772,
  		1,
  		"ε"
  	],
  	[
  		120773,
  		1,
  		"θ"
  	],
  	[
  		120774,
  		1,
  		"κ"
  	],
  	[
  		120775,
  		1,
  		"φ"
  	],
  	[
  		120776,
  		1,
  		"ρ"
  	],
  	[
  		120777,
  		1,
  		"π"
  	],
  	[
  		[
  			120778,
  			120779
  		],
  		1,
  		"ϝ"
  	],
  	[
  		[
  			120780,
  			120781
  		],
  		3
  	],
  	[
  		120782,
  		1,
  		"0"
  	],
  	[
  		120783,
  		1,
  		"1"
  	],
  	[
  		120784,
  		1,
  		"2"
  	],
  	[
  		120785,
  		1,
  		"3"
  	],
  	[
  		120786,
  		1,
  		"4"
  	],
  	[
  		120787,
  		1,
  		"5"
  	],
  	[
  		120788,
  		1,
  		"6"
  	],
  	[
  		120789,
  		1,
  		"7"
  	],
  	[
  		120790,
  		1,
  		"8"
  	],
  	[
  		120791,
  		1,
  		"9"
  	],
  	[
  		120792,
  		1,
  		"0"
  	],
  	[
  		120793,
  		1,
  		"1"
  	],
  	[
  		120794,
  		1,
  		"2"
  	],
  	[
  		120795,
  		1,
  		"3"
  	],
  	[
  		120796,
  		1,
  		"4"
  	],
  	[
  		120797,
  		1,
  		"5"
  	],
  	[
  		120798,
  		1,
  		"6"
  	],
  	[
  		120799,
  		1,
  		"7"
  	],
  	[
  		120800,
  		1,
  		"8"
  	],
  	[
  		120801,
  		1,
  		"9"
  	],
  	[
  		120802,
  		1,
  		"0"
  	],
  	[
  		120803,
  		1,
  		"1"
  	],
  	[
  		120804,
  		1,
  		"2"
  	],
  	[
  		120805,
  		1,
  		"3"
  	],
  	[
  		120806,
  		1,
  		"4"
  	],
  	[
  		120807,
  		1,
  		"5"
  	],
  	[
  		120808,
  		1,
  		"6"
  	],
  	[
  		120809,
  		1,
  		"7"
  	],
  	[
  		120810,
  		1,
  		"8"
  	],
  	[
  		120811,
  		1,
  		"9"
  	],
  	[
  		120812,
  		1,
  		"0"
  	],
  	[
  		120813,
  		1,
  		"1"
  	],
  	[
  		120814,
  		1,
  		"2"
  	],
  	[
  		120815,
  		1,
  		"3"
  	],
  	[
  		120816,
  		1,
  		"4"
  	],
  	[
  		120817,
  		1,
  		"5"
  	],
  	[
  		120818,
  		1,
  		"6"
  	],
  	[
  		120819,
  		1,
  		"7"
  	],
  	[
  		120820,
  		1,
  		"8"
  	],
  	[
  		120821,
  		1,
  		"9"
  	],
  	[
  		120822,
  		1,
  		"0"
  	],
  	[
  		120823,
  		1,
  		"1"
  	],
  	[
  		120824,
  		1,
  		"2"
  	],
  	[
  		120825,
  		1,
  		"3"
  	],
  	[
  		120826,
  		1,
  		"4"
  	],
  	[
  		120827,
  		1,
  		"5"
  	],
  	[
  		120828,
  		1,
  		"6"
  	],
  	[
  		120829,
  		1,
  		"7"
  	],
  	[
  		120830,
  		1,
  		"8"
  	],
  	[
  		120831,
  		1,
  		"9"
  	],
  	[
  		[
  			120832,
  			121343
  		],
  		2
  	],
  	[
  		[
  			121344,
  			121398
  		],
  		2
  	],
  	[
  		[
  			121399,
  			121402
  		],
  		2
  	],
  	[
  		[
  			121403,
  			121452
  		],
  		2
  	],
  	[
  		[
  			121453,
  			121460
  		],
  		2
  	],
  	[
  		121461,
  		2
  	],
  	[
  		[
  			121462,
  			121475
  		],
  		2
  	],
  	[
  		121476,
  		2
  	],
  	[
  		[
  			121477,
  			121483
  		],
  		2
  	],
  	[
  		[
  			121484,
  			121498
  		],
  		3
  	],
  	[
  		[
  			121499,
  			121503
  		],
  		2
  	],
  	[
  		121504,
  		3
  	],
  	[
  		[
  			121505,
  			121519
  		],
  		2
  	],
  	[
  		[
  			121520,
  			122879
  		],
  		3
  	],
  	[
  		[
  			122880,
  			122886
  		],
  		2
  	],
  	[
  		122887,
  		3
  	],
  	[
  		[
  			122888,
  			122904
  		],
  		2
  	],
  	[
  		[
  			122905,
  			122906
  		],
  		3
  	],
  	[
  		[
  			122907,
  			122913
  		],
  		2
  	],
  	[
  		122914,
  		3
  	],
  	[
  		[
  			122915,
  			122916
  		],
  		2
  	],
  	[
  		122917,
  		3
  	],
  	[
  		[
  			122918,
  			122922
  		],
  		2
  	],
  	[
  		[
  			122923,
  			123135
  		],
  		3
  	],
  	[
  		[
  			123136,
  			123180
  		],
  		2
  	],
  	[
  		[
  			123181,
  			123183
  		],
  		3
  	],
  	[
  		[
  			123184,
  			123197
  		],
  		2
  	],
  	[
  		[
  			123198,
  			123199
  		],
  		3
  	],
  	[
  		[
  			123200,
  			123209
  		],
  		2
  	],
  	[
  		[
  			123210,
  			123213
  		],
  		3
  	],
  	[
  		123214,
  		2
  	],
  	[
  		123215,
  		2
  	],
  	[
  		[
  			123216,
  			123583
  		],
  		3
  	],
  	[
  		[
  			123584,
  			123641
  		],
  		2
  	],
  	[
  		[
  			123642,
  			123646
  		],
  		3
  	],
  	[
  		123647,
  		2
  	],
  	[
  		[
  			123648,
  			124927
  		],
  		3
  	],
  	[
  		[
  			124928,
  			125124
  		],
  		2
  	],
  	[
  		[
  			125125,
  			125126
  		],
  		3
  	],
  	[
  		[
  			125127,
  			125135
  		],
  		2
  	],
  	[
  		[
  			125136,
  			125142
  		],
  		2
  	],
  	[
  		[
  			125143,
  			125183
  		],
  		3
  	],
  	[
  		125184,
  		1,
  		"𞤢"
  	],
  	[
  		125185,
  		1,
  		"𞤣"
  	],
  	[
  		125186,
  		1,
  		"𞤤"
  	],
  	[
  		125187,
  		1,
  		"𞤥"
  	],
  	[
  		125188,
  		1,
  		"𞤦"
  	],
  	[
  		125189,
  		1,
  		"𞤧"
  	],
  	[
  		125190,
  		1,
  		"𞤨"
  	],
  	[
  		125191,
  		1,
  		"𞤩"
  	],
  	[
  		125192,
  		1,
  		"𞤪"
  	],
  	[
  		125193,
  		1,
  		"𞤫"
  	],
  	[
  		125194,
  		1,
  		"𞤬"
  	],
  	[
  		125195,
  		1,
  		"𞤭"
  	],
  	[
  		125196,
  		1,
  		"𞤮"
  	],
  	[
  		125197,
  		1,
  		"𞤯"
  	],
  	[
  		125198,
  		1,
  		"𞤰"
  	],
  	[
  		125199,
  		1,
  		"𞤱"
  	],
  	[
  		125200,
  		1,
  		"𞤲"
  	],
  	[
  		125201,
  		1,
  		"𞤳"
  	],
  	[
  		125202,
  		1,
  		"𞤴"
  	],
  	[
  		125203,
  		1,
  		"𞤵"
  	],
  	[
  		125204,
  		1,
  		"𞤶"
  	],
  	[
  		125205,
  		1,
  		"𞤷"
  	],
  	[
  		125206,
  		1,
  		"𞤸"
  	],
  	[
  		125207,
  		1,
  		"𞤹"
  	],
  	[
  		125208,
  		1,
  		"𞤺"
  	],
  	[
  		125209,
  		1,
  		"𞤻"
  	],
  	[
  		125210,
  		1,
  		"𞤼"
  	],
  	[
  		125211,
  		1,
  		"𞤽"
  	],
  	[
  		125212,
  		1,
  		"𞤾"
  	],
  	[
  		125213,
  		1,
  		"𞤿"
  	],
  	[
  		125214,
  		1,
  		"𞥀"
  	],
  	[
  		125215,
  		1,
  		"𞥁"
  	],
  	[
  		125216,
  		1,
  		"𞥂"
  	],
  	[
  		125217,
  		1,
  		"𞥃"
  	],
  	[
  		[
  			125218,
  			125258
  		],
  		2
  	],
  	[
  		125259,
  		2
  	],
  	[
  		[
  			125260,
  			125263
  		],
  		3
  	],
  	[
  		[
  			125264,
  			125273
  		],
  		2
  	],
  	[
  		[
  			125274,
  			125277
  		],
  		3
  	],
  	[
  		[
  			125278,
  			125279
  		],
  		2
  	],
  	[
  		[
  			125280,
  			126064
  		],
  		3
  	],
  	[
  		[
  			126065,
  			126132
  		],
  		2
  	],
  	[
  		[
  			126133,
  			126208
  		],
  		3
  	],
  	[
  		[
  			126209,
  			126269
  		],
  		2
  	],
  	[
  		[
  			126270,
  			126463
  		],
  		3
  	],
  	[
  		126464,
  		1,
  		"ا"
  	],
  	[
  		126465,
  		1,
  		"ب"
  	],
  	[
  		126466,
  		1,
  		"ج"
  	],
  	[
  		126467,
  		1,
  		"د"
  	],
  	[
  		126468,
  		3
  	],
  	[
  		126469,
  		1,
  		"و"
  	],
  	[
  		126470,
  		1,
  		"ز"
  	],
  	[
  		126471,
  		1,
  		"ح"
  	],
  	[
  		126472,
  		1,
  		"ط"
  	],
  	[
  		126473,
  		1,
  		"ي"
  	],
  	[
  		126474,
  		1,
  		"ك"
  	],
  	[
  		126475,
  		1,
  		"ل"
  	],
  	[
  		126476,
  		1,
  		"م"
  	],
  	[
  		126477,
  		1,
  		"ن"
  	],
  	[
  		126478,
  		1,
  		"س"
  	],
  	[
  		126479,
  		1,
  		"ع"
  	],
  	[
  		126480,
  		1,
  		"ف"
  	],
  	[
  		126481,
  		1,
  		"ص"
  	],
  	[
  		126482,
  		1,
  		"ق"
  	],
  	[
  		126483,
  		1,
  		"ر"
  	],
  	[
  		126484,
  		1,
  		"ش"
  	],
  	[
  		126485,
  		1,
  		"ت"
  	],
  	[
  		126486,
  		1,
  		"ث"
  	],
  	[
  		126487,
  		1,
  		"خ"
  	],
  	[
  		126488,
  		1,
  		"ذ"
  	],
  	[
  		126489,
  		1,
  		"ض"
  	],
  	[
  		126490,
  		1,
  		"ظ"
  	],
  	[
  		126491,
  		1,
  		"غ"
  	],
  	[
  		126492,
  		1,
  		"ٮ"
  	],
  	[
  		126493,
  		1,
  		"ں"
  	],
  	[
  		126494,
  		1,
  		"ڡ"
  	],
  	[
  		126495,
  		1,
  		"ٯ"
  	],
  	[
  		126496,
  		3
  	],
  	[
  		126497,
  		1,
  		"ب"
  	],
  	[
  		126498,
  		1,
  		"ج"
  	],
  	[
  		126499,
  		3
  	],
  	[
  		126500,
  		1,
  		"ه"
  	],
  	[
  		[
  			126501,
  			126502
  		],
  		3
  	],
  	[
  		126503,
  		1,
  		"ح"
  	],
  	[
  		126504,
  		3
  	],
  	[
  		126505,
  		1,
  		"ي"
  	],
  	[
  		126506,
  		1,
  		"ك"
  	],
  	[
  		126507,
  		1,
  		"ل"
  	],
  	[
  		126508,
  		1,
  		"م"
  	],
  	[
  		126509,
  		1,
  		"ن"
  	],
  	[
  		126510,
  		1,
  		"س"
  	],
  	[
  		126511,
  		1,
  		"ع"
  	],
  	[
  		126512,
  		1,
  		"ف"
  	],
  	[
  		126513,
  		1,
  		"ص"
  	],
  	[
  		126514,
  		1,
  		"ق"
  	],
  	[
  		126515,
  		3
  	],
  	[
  		126516,
  		1,
  		"ش"
  	],
  	[
  		126517,
  		1,
  		"ت"
  	],
  	[
  		126518,
  		1,
  		"ث"
  	],
  	[
  		126519,
  		1,
  		"خ"
  	],
  	[
  		126520,
  		3
  	],
  	[
  		126521,
  		1,
  		"ض"
  	],
  	[
  		126522,
  		3
  	],
  	[
  		126523,
  		1,
  		"غ"
  	],
  	[
  		[
  			126524,
  			126529
  		],
  		3
  	],
  	[
  		126530,
  		1,
  		"ج"
  	],
  	[
  		[
  			126531,
  			126534
  		],
  		3
  	],
  	[
  		126535,
  		1,
  		"ح"
  	],
  	[
  		126536,
  		3
  	],
  	[
  		126537,
  		1,
  		"ي"
  	],
  	[
  		126538,
  		3
  	],
  	[
  		126539,
  		1,
  		"ل"
  	],
  	[
  		126540,
  		3
  	],
  	[
  		126541,
  		1,
  		"ن"
  	],
  	[
  		126542,
  		1,
  		"س"
  	],
  	[
  		126543,
  		1,
  		"ع"
  	],
  	[
  		126544,
  		3
  	],
  	[
  		126545,
  		1,
  		"ص"
  	],
  	[
  		126546,
  		1,
  		"ق"
  	],
  	[
  		126547,
  		3
  	],
  	[
  		126548,
  		1,
  		"ش"
  	],
  	[
  		[
  			126549,
  			126550
  		],
  		3
  	],
  	[
  		126551,
  		1,
  		"خ"
  	],
  	[
  		126552,
  		3
  	],
  	[
  		126553,
  		1,
  		"ض"
  	],
  	[
  		126554,
  		3
  	],
  	[
  		126555,
  		1,
  		"غ"
  	],
  	[
  		126556,
  		3
  	],
  	[
  		126557,
  		1,
  		"ں"
  	],
  	[
  		126558,
  		3
  	],
  	[
  		126559,
  		1,
  		"ٯ"
  	],
  	[
  		126560,
  		3
  	],
  	[
  		126561,
  		1,
  		"ب"
  	],
  	[
  		126562,
  		1,
  		"ج"
  	],
  	[
  		126563,
  		3
  	],
  	[
  		126564,
  		1,
  		"ه"
  	],
  	[
  		[
  			126565,
  			126566
  		],
  		3
  	],
  	[
  		126567,
  		1,
  		"ح"
  	],
  	[
  		126568,
  		1,
  		"ط"
  	],
  	[
  		126569,
  		1,
  		"ي"
  	],
  	[
  		126570,
  		1,
  		"ك"
  	],
  	[
  		126571,
  		3
  	],
  	[
  		126572,
  		1,
  		"م"
  	],
  	[
  		126573,
  		1,
  		"ن"
  	],
  	[
  		126574,
  		1,
  		"س"
  	],
  	[
  		126575,
  		1,
  		"ع"
  	],
  	[
  		126576,
  		1,
  		"ف"
  	],
  	[
  		126577,
  		1,
  		"ص"
  	],
  	[
  		126578,
  		1,
  		"ق"
  	],
  	[
  		126579,
  		3
  	],
  	[
  		126580,
  		1,
  		"ش"
  	],
  	[
  		126581,
  		1,
  		"ت"
  	],
  	[
  		126582,
  		1,
  		"ث"
  	],
  	[
  		126583,
  		1,
  		"خ"
  	],
  	[
  		126584,
  		3
  	],
  	[
  		126585,
  		1,
  		"ض"
  	],
  	[
  		126586,
  		1,
  		"ظ"
  	],
  	[
  		126587,
  		1,
  		"غ"
  	],
  	[
  		126588,
  		1,
  		"ٮ"
  	],
  	[
  		126589,
  		3
  	],
  	[
  		126590,
  		1,
  		"ڡ"
  	],
  	[
  		126591,
  		3
  	],
  	[
  		126592,
  		1,
  		"ا"
  	],
  	[
  		126593,
  		1,
  		"ب"
  	],
  	[
  		126594,
  		1,
  		"ج"
  	],
  	[
  		126595,
  		1,
  		"د"
  	],
  	[
  		126596,
  		1,
  		"ه"
  	],
  	[
  		126597,
  		1,
  		"و"
  	],
  	[
  		126598,
  		1,
  		"ز"
  	],
  	[
  		126599,
  		1,
  		"ح"
  	],
  	[
  		126600,
  		1,
  		"ط"
  	],
  	[
  		126601,
  		1,
  		"ي"
  	],
  	[
  		126602,
  		3
  	],
  	[
  		126603,
  		1,
  		"ل"
  	],
  	[
  		126604,
  		1,
  		"م"
  	],
  	[
  		126605,
  		1,
  		"ن"
  	],
  	[
  		126606,
  		1,
  		"س"
  	],
  	[
  		126607,
  		1,
  		"ع"
  	],
  	[
  		126608,
  		1,
  		"ف"
  	],
  	[
  		126609,
  		1,
  		"ص"
  	],
  	[
  		126610,
  		1,
  		"ق"
  	],
  	[
  		126611,
  		1,
  		"ر"
  	],
  	[
  		126612,
  		1,
  		"ش"
  	],
  	[
  		126613,
  		1,
  		"ت"
  	],
  	[
  		126614,
  		1,
  		"ث"
  	],
  	[
  		126615,
  		1,
  		"خ"
  	],
  	[
  		126616,
  		1,
  		"ذ"
  	],
  	[
  		126617,
  		1,
  		"ض"
  	],
  	[
  		126618,
  		1,
  		"ظ"
  	],
  	[
  		126619,
  		1,
  		"غ"
  	],
  	[
  		[
  			126620,
  			126624
  		],
  		3
  	],
  	[
  		126625,
  		1,
  		"ب"
  	],
  	[
  		126626,
  		1,
  		"ج"
  	],
  	[
  		126627,
  		1,
  		"د"
  	],
  	[
  		126628,
  		3
  	],
  	[
  		126629,
  		1,
  		"و"
  	],
  	[
  		126630,
  		1,
  		"ز"
  	],
  	[
  		126631,
  		1,
  		"ح"
  	],
  	[
  		126632,
  		1,
  		"ط"
  	],
  	[
  		126633,
  		1,
  		"ي"
  	],
  	[
  		126634,
  		3
  	],
  	[
  		126635,
  		1,
  		"ل"
  	],
  	[
  		126636,
  		1,
  		"م"
  	],
  	[
  		126637,
  		1,
  		"ن"
  	],
  	[
  		126638,
  		1,
  		"س"
  	],
  	[
  		126639,
  		1,
  		"ع"
  	],
  	[
  		126640,
  		1,
  		"ف"
  	],
  	[
  		126641,
  		1,
  		"ص"
  	],
  	[
  		126642,
  		1,
  		"ق"
  	],
  	[
  		126643,
  		1,
  		"ر"
  	],
  	[
  		126644,
  		1,
  		"ش"
  	],
  	[
  		126645,
  		1,
  		"ت"
  	],
  	[
  		126646,
  		1,
  		"ث"
  	],
  	[
  		126647,
  		1,
  		"خ"
  	],
  	[
  		126648,
  		1,
  		"ذ"
  	],
  	[
  		126649,
  		1,
  		"ض"
  	],
  	[
  		126650,
  		1,
  		"ظ"
  	],
  	[
  		126651,
  		1,
  		"غ"
  	],
  	[
  		[
  			126652,
  			126703
  		],
  		3
  	],
  	[
  		[
  			126704,
  			126705
  		],
  		2
  	],
  	[
  		[
  			126706,
  			126975
  		],
  		3
  	],
  	[
  		[
  			126976,
  			127019
  		],
  		2
  	],
  	[
  		[
  			127020,
  			127023
  		],
  		3
  	],
  	[
  		[
  			127024,
  			127123
  		],
  		2
  	],
  	[
  		[
  			127124,
  			127135
  		],
  		3
  	],
  	[
  		[
  			127136,
  			127150
  		],
  		2
  	],
  	[
  		[
  			127151,
  			127152
  		],
  		3
  	],
  	[
  		[
  			127153,
  			127166
  		],
  		2
  	],
  	[
  		127167,
  		2
  	],
  	[
  		127168,
  		3
  	],
  	[
  		[
  			127169,
  			127183
  		],
  		2
  	],
  	[
  		127184,
  		3
  	],
  	[
  		[
  			127185,
  			127199
  		],
  		2
  	],
  	[
  		[
  			127200,
  			127221
  		],
  		2
  	],
  	[
  		[
  			127222,
  			127231
  		],
  		3
  	],
  	[
  		127232,
  		3
  	],
  	[
  		127233,
  		5,
  		"0,"
  	],
  	[
  		127234,
  		5,
  		"1,"
  	],
  	[
  		127235,
  		5,
  		"2,"
  	],
  	[
  		127236,
  		5,
  		"3,"
  	],
  	[
  		127237,
  		5,
  		"4,"
  	],
  	[
  		127238,
  		5,
  		"5,"
  	],
  	[
  		127239,
  		5,
  		"6,"
  	],
  	[
  		127240,
  		5,
  		"7,"
  	],
  	[
  		127241,
  		5,
  		"8,"
  	],
  	[
  		127242,
  		5,
  		"9,"
  	],
  	[
  		[
  			127243,
  			127244
  		],
  		2
  	],
  	[
  		[
  			127245,
  			127247
  		],
  		2
  	],
  	[
  		127248,
  		5,
  		"(a)"
  	],
  	[
  		127249,
  		5,
  		"(b)"
  	],
  	[
  		127250,
  		5,
  		"(c)"
  	],
  	[
  		127251,
  		5,
  		"(d)"
  	],
  	[
  		127252,
  		5,
  		"(e)"
  	],
  	[
  		127253,
  		5,
  		"(f)"
  	],
  	[
  		127254,
  		5,
  		"(g)"
  	],
  	[
  		127255,
  		5,
  		"(h)"
  	],
  	[
  		127256,
  		5,
  		"(i)"
  	],
  	[
  		127257,
  		5,
  		"(j)"
  	],
  	[
  		127258,
  		5,
  		"(k)"
  	],
  	[
  		127259,
  		5,
  		"(l)"
  	],
  	[
  		127260,
  		5,
  		"(m)"
  	],
  	[
  		127261,
  		5,
  		"(n)"
  	],
  	[
  		127262,
  		5,
  		"(o)"
  	],
  	[
  		127263,
  		5,
  		"(p)"
  	],
  	[
  		127264,
  		5,
  		"(q)"
  	],
  	[
  		127265,
  		5,
  		"(r)"
  	],
  	[
  		127266,
  		5,
  		"(s)"
  	],
  	[
  		127267,
  		5,
  		"(t)"
  	],
  	[
  		127268,
  		5,
  		"(u)"
  	],
  	[
  		127269,
  		5,
  		"(v)"
  	],
  	[
  		127270,
  		5,
  		"(w)"
  	],
  	[
  		127271,
  		5,
  		"(x)"
  	],
  	[
  		127272,
  		5,
  		"(y)"
  	],
  	[
  		127273,
  		5,
  		"(z)"
  	],
  	[
  		127274,
  		1,
  		"〔s〕"
  	],
  	[
  		127275,
  		1,
  		"c"
  	],
  	[
  		127276,
  		1,
  		"r"
  	],
  	[
  		127277,
  		1,
  		"cd"
  	],
  	[
  		127278,
  		1,
  		"wz"
  	],
  	[
  		127279,
  		2
  	],
  	[
  		127280,
  		1,
  		"a"
  	],
  	[
  		127281,
  		1,
  		"b"
  	],
  	[
  		127282,
  		1,
  		"c"
  	],
  	[
  		127283,
  		1,
  		"d"
  	],
  	[
  		127284,
  		1,
  		"e"
  	],
  	[
  		127285,
  		1,
  		"f"
  	],
  	[
  		127286,
  		1,
  		"g"
  	],
  	[
  		127287,
  		1,
  		"h"
  	],
  	[
  		127288,
  		1,
  		"i"
  	],
  	[
  		127289,
  		1,
  		"j"
  	],
  	[
  		127290,
  		1,
  		"k"
  	],
  	[
  		127291,
  		1,
  		"l"
  	],
  	[
  		127292,
  		1,
  		"m"
  	],
  	[
  		127293,
  		1,
  		"n"
  	],
  	[
  		127294,
  		1,
  		"o"
  	],
  	[
  		127295,
  		1,
  		"p"
  	],
  	[
  		127296,
  		1,
  		"q"
  	],
  	[
  		127297,
  		1,
  		"r"
  	],
  	[
  		127298,
  		1,
  		"s"
  	],
  	[
  		127299,
  		1,
  		"t"
  	],
  	[
  		127300,
  		1,
  		"u"
  	],
  	[
  		127301,
  		1,
  		"v"
  	],
  	[
  		127302,
  		1,
  		"w"
  	],
  	[
  		127303,
  		1,
  		"x"
  	],
  	[
  		127304,
  		1,
  		"y"
  	],
  	[
  		127305,
  		1,
  		"z"
  	],
  	[
  		127306,
  		1,
  		"hv"
  	],
  	[
  		127307,
  		1,
  		"mv"
  	],
  	[
  		127308,
  		1,
  		"sd"
  	],
  	[
  		127309,
  		1,
  		"ss"
  	],
  	[
  		127310,
  		1,
  		"ppv"
  	],
  	[
  		127311,
  		1,
  		"wc"
  	],
  	[
  		[
  			127312,
  			127318
  		],
  		2
  	],
  	[
  		127319,
  		2
  	],
  	[
  		[
  			127320,
  			127326
  		],
  		2
  	],
  	[
  		127327,
  		2
  	],
  	[
  		[
  			127328,
  			127337
  		],
  		2
  	],
  	[
  		127338,
  		1,
  		"mc"
  	],
  	[
  		127339,
  		1,
  		"md"
  	],
  	[
  		127340,
  		1,
  		"mr"
  	],
  	[
  		[
  			127341,
  			127343
  		],
  		2
  	],
  	[
  		[
  			127344,
  			127352
  		],
  		2
  	],
  	[
  		127353,
  		2
  	],
  	[
  		127354,
  		2
  	],
  	[
  		[
  			127355,
  			127356
  		],
  		2
  	],
  	[
  		[
  			127357,
  			127358
  		],
  		2
  	],
  	[
  		127359,
  		2
  	],
  	[
  		[
  			127360,
  			127369
  		],
  		2
  	],
  	[
  		[
  			127370,
  			127373
  		],
  		2
  	],
  	[
  		[
  			127374,
  			127375
  		],
  		2
  	],
  	[
  		127376,
  		1,
  		"dj"
  	],
  	[
  		[
  			127377,
  			127386
  		],
  		2
  	],
  	[
  		[
  			127387,
  			127404
  		],
  		2
  	],
  	[
  		127405,
  		2
  	],
  	[
  		[
  			127406,
  			127461
  		],
  		3
  	],
  	[
  		[
  			127462,
  			127487
  		],
  		2
  	],
  	[
  		127488,
  		1,
  		"ほか"
  	],
  	[
  		127489,
  		1,
  		"ココ"
  	],
  	[
  		127490,
  		1,
  		"サ"
  	],
  	[
  		[
  			127491,
  			127503
  		],
  		3
  	],
  	[
  		127504,
  		1,
  		"手"
  	],
  	[
  		127505,
  		1,
  		"字"
  	],
  	[
  		127506,
  		1,
  		"双"
  	],
  	[
  		127507,
  		1,
  		"デ"
  	],
  	[
  		127508,
  		1,
  		"二"
  	],
  	[
  		127509,
  		1,
  		"多"
  	],
  	[
  		127510,
  		1,
  		"解"
  	],
  	[
  		127511,
  		1,
  		"天"
  	],
  	[
  		127512,
  		1,
  		"交"
  	],
  	[
  		127513,
  		1,
  		"映"
  	],
  	[
  		127514,
  		1,
  		"無"
  	],
  	[
  		127515,
  		1,
  		"料"
  	],
  	[
  		127516,
  		1,
  		"前"
  	],
  	[
  		127517,
  		1,
  		"後"
  	],
  	[
  		127518,
  		1,
  		"再"
  	],
  	[
  		127519,
  		1,
  		"新"
  	],
  	[
  		127520,
  		1,
  		"初"
  	],
  	[
  		127521,
  		1,
  		"終"
  	],
  	[
  		127522,
  		1,
  		"生"
  	],
  	[
  		127523,
  		1,
  		"販"
  	],
  	[
  		127524,
  		1,
  		"声"
  	],
  	[
  		127525,
  		1,
  		"吹"
  	],
  	[
  		127526,
  		1,
  		"演"
  	],
  	[
  		127527,
  		1,
  		"投"
  	],
  	[
  		127528,
  		1,
  		"捕"
  	],
  	[
  		127529,
  		1,
  		"一"
  	],
  	[
  		127530,
  		1,
  		"三"
  	],
  	[
  		127531,
  		1,
  		"遊"
  	],
  	[
  		127532,
  		1,
  		"左"
  	],
  	[
  		127533,
  		1,
  		"中"
  	],
  	[
  		127534,
  		1,
  		"右"
  	],
  	[
  		127535,
  		1,
  		"指"
  	],
  	[
  		127536,
  		1,
  		"走"
  	],
  	[
  		127537,
  		1,
  		"打"
  	],
  	[
  		127538,
  		1,
  		"禁"
  	],
  	[
  		127539,
  		1,
  		"空"
  	],
  	[
  		127540,
  		1,
  		"合"
  	],
  	[
  		127541,
  		1,
  		"満"
  	],
  	[
  		127542,
  		1,
  		"有"
  	],
  	[
  		127543,
  		1,
  		"月"
  	],
  	[
  		127544,
  		1,
  		"申"
  	],
  	[
  		127545,
  		1,
  		"割"
  	],
  	[
  		127546,
  		1,
  		"営"
  	],
  	[
  		127547,
  		1,
  		"配"
  	],
  	[
  		[
  			127548,
  			127551
  		],
  		3
  	],
  	[
  		127552,
  		1,
  		"〔本〕"
  	],
  	[
  		127553,
  		1,
  		"〔三〕"
  	],
  	[
  		127554,
  		1,
  		"〔二〕"
  	],
  	[
  		127555,
  		1,
  		"〔安〕"
  	],
  	[
  		127556,
  		1,
  		"〔点〕"
  	],
  	[
  		127557,
  		1,
  		"〔打〕"
  	],
  	[
  		127558,
  		1,
  		"〔盗〕"
  	],
  	[
  		127559,
  		1,
  		"〔勝〕"
  	],
  	[
  		127560,
  		1,
  		"〔敗〕"
  	],
  	[
  		[
  			127561,
  			127567
  		],
  		3
  	],
  	[
  		127568,
  		1,
  		"得"
  	],
  	[
  		127569,
  		1,
  		"可"
  	],
  	[
  		[
  			127570,
  			127583
  		],
  		3
  	],
  	[
  		[
  			127584,
  			127589
  		],
  		2
  	],
  	[
  		[
  			127590,
  			127743
  		],
  		3
  	],
  	[
  		[
  			127744,
  			127776
  		],
  		2
  	],
  	[
  		[
  			127777,
  			127788
  		],
  		2
  	],
  	[
  		[
  			127789,
  			127791
  		],
  		2
  	],
  	[
  		[
  			127792,
  			127797
  		],
  		2
  	],
  	[
  		127798,
  		2
  	],
  	[
  		[
  			127799,
  			127868
  		],
  		2
  	],
  	[
  		127869,
  		2
  	],
  	[
  		[
  			127870,
  			127871
  		],
  		2
  	],
  	[
  		[
  			127872,
  			127891
  		],
  		2
  	],
  	[
  		[
  			127892,
  			127903
  		],
  		2
  	],
  	[
  		[
  			127904,
  			127940
  		],
  		2
  	],
  	[
  		127941,
  		2
  	],
  	[
  		[
  			127942,
  			127946
  		],
  		2
  	],
  	[
  		[
  			127947,
  			127950
  		],
  		2
  	],
  	[
  		[
  			127951,
  			127955
  		],
  		2
  	],
  	[
  		[
  			127956,
  			127967
  		],
  		2
  	],
  	[
  		[
  			127968,
  			127984
  		],
  		2
  	],
  	[
  		[
  			127985,
  			127991
  		],
  		2
  	],
  	[
  		[
  			127992,
  			127999
  		],
  		2
  	],
  	[
  		[
  			128000,
  			128062
  		],
  		2
  	],
  	[
  		128063,
  		2
  	],
  	[
  		128064,
  		2
  	],
  	[
  		128065,
  		2
  	],
  	[
  		[
  			128066,
  			128247
  		],
  		2
  	],
  	[
  		128248,
  		2
  	],
  	[
  		[
  			128249,
  			128252
  		],
  		2
  	],
  	[
  		[
  			128253,
  			128254
  		],
  		2
  	],
  	[
  		128255,
  		2
  	],
  	[
  		[
  			128256,
  			128317
  		],
  		2
  	],
  	[
  		[
  			128318,
  			128319
  		],
  		2
  	],
  	[
  		[
  			128320,
  			128323
  		],
  		2
  	],
  	[
  		[
  			128324,
  			128330
  		],
  		2
  	],
  	[
  		[
  			128331,
  			128335
  		],
  		2
  	],
  	[
  		[
  			128336,
  			128359
  		],
  		2
  	],
  	[
  		[
  			128360,
  			128377
  		],
  		2
  	],
  	[
  		128378,
  		2
  	],
  	[
  		[
  			128379,
  			128419
  		],
  		2
  	],
  	[
  		128420,
  		2
  	],
  	[
  		[
  			128421,
  			128506
  		],
  		2
  	],
  	[
  		[
  			128507,
  			128511
  		],
  		2
  	],
  	[
  		128512,
  		2
  	],
  	[
  		[
  			128513,
  			128528
  		],
  		2
  	],
  	[
  		128529,
  		2
  	],
  	[
  		[
  			128530,
  			128532
  		],
  		2
  	],
  	[
  		128533,
  		2
  	],
  	[
  		128534,
  		2
  	],
  	[
  		128535,
  		2
  	],
  	[
  		128536,
  		2
  	],
  	[
  		128537,
  		2
  	],
  	[
  		128538,
  		2
  	],
  	[
  		128539,
  		2
  	],
  	[
  		[
  			128540,
  			128542
  		],
  		2
  	],
  	[
  		128543,
  		2
  	],
  	[
  		[
  			128544,
  			128549
  		],
  		2
  	],
  	[
  		[
  			128550,
  			128551
  		],
  		2
  	],
  	[
  		[
  			128552,
  			128555
  		],
  		2
  	],
  	[
  		128556,
  		2
  	],
  	[
  		128557,
  		2
  	],
  	[
  		[
  			128558,
  			128559
  		],
  		2
  	],
  	[
  		[
  			128560,
  			128563
  		],
  		2
  	],
  	[
  		128564,
  		2
  	],
  	[
  		[
  			128565,
  			128576
  		],
  		2
  	],
  	[
  		[
  			128577,
  			128578
  		],
  		2
  	],
  	[
  		[
  			128579,
  			128580
  		],
  		2
  	],
  	[
  		[
  			128581,
  			128591
  		],
  		2
  	],
  	[
  		[
  			128592,
  			128639
  		],
  		2
  	],
  	[
  		[
  			128640,
  			128709
  		],
  		2
  	],
  	[
  		[
  			128710,
  			128719
  		],
  		2
  	],
  	[
  		128720,
  		2
  	],
  	[
  		[
  			128721,
  			128722
  		],
  		2
  	],
  	[
  		[
  			128723,
  			128724
  		],
  		2
  	],
  	[
  		128725,
  		2
  	],
  	[
  		[
  			128726,
  			128727
  		],
  		2
  	],
  	[
  		[
  			128728,
  			128735
  		],
  		3
  	],
  	[
  		[
  			128736,
  			128748
  		],
  		2
  	],
  	[
  		[
  			128749,
  			128751
  		],
  		3
  	],
  	[
  		[
  			128752,
  			128755
  		],
  		2
  	],
  	[
  		[
  			128756,
  			128758
  		],
  		2
  	],
  	[
  		[
  			128759,
  			128760
  		],
  		2
  	],
  	[
  		128761,
  		2
  	],
  	[
  		128762,
  		2
  	],
  	[
  		[
  			128763,
  			128764
  		],
  		2
  	],
  	[
  		[
  			128765,
  			128767
  		],
  		3
  	],
  	[
  		[
  			128768,
  			128883
  		],
  		2
  	],
  	[
  		[
  			128884,
  			128895
  		],
  		3
  	],
  	[
  		[
  			128896,
  			128980
  		],
  		2
  	],
  	[
  		[
  			128981,
  			128984
  		],
  		2
  	],
  	[
  		[
  			128985,
  			128991
  		],
  		3
  	],
  	[
  		[
  			128992,
  			129003
  		],
  		2
  	],
  	[
  		[
  			129004,
  			129023
  		],
  		3
  	],
  	[
  		[
  			129024,
  			129035
  		],
  		2
  	],
  	[
  		[
  			129036,
  			129039
  		],
  		3
  	],
  	[
  		[
  			129040,
  			129095
  		],
  		2
  	],
  	[
  		[
  			129096,
  			129103
  		],
  		3
  	],
  	[
  		[
  			129104,
  			129113
  		],
  		2
  	],
  	[
  		[
  			129114,
  			129119
  		],
  		3
  	],
  	[
  		[
  			129120,
  			129159
  		],
  		2
  	],
  	[
  		[
  			129160,
  			129167
  		],
  		3
  	],
  	[
  		[
  			129168,
  			129197
  		],
  		2
  	],
  	[
  		[
  			129198,
  			129199
  		],
  		3
  	],
  	[
  		[
  			129200,
  			129201
  		],
  		2
  	],
  	[
  		[
  			129202,
  			129279
  		],
  		3
  	],
  	[
  		[
  			129280,
  			129291
  		],
  		2
  	],
  	[
  		129292,
  		2
  	],
  	[
  		[
  			129293,
  			129295
  		],
  		2
  	],
  	[
  		[
  			129296,
  			129304
  		],
  		2
  	],
  	[
  		[
  			129305,
  			129310
  		],
  		2
  	],
  	[
  		129311,
  		2
  	],
  	[
  		[
  			129312,
  			129319
  		],
  		2
  	],
  	[
  		[
  			129320,
  			129327
  		],
  		2
  	],
  	[
  		129328,
  		2
  	],
  	[
  		[
  			129329,
  			129330
  		],
  		2
  	],
  	[
  		[
  			129331,
  			129342
  		],
  		2
  	],
  	[
  		129343,
  		2
  	],
  	[
  		[
  			129344,
  			129355
  		],
  		2
  	],
  	[
  		129356,
  		2
  	],
  	[
  		[
  			129357,
  			129359
  		],
  		2
  	],
  	[
  		[
  			129360,
  			129374
  		],
  		2
  	],
  	[
  		[
  			129375,
  			129387
  		],
  		2
  	],
  	[
  		[
  			129388,
  			129392
  		],
  		2
  	],
  	[
  		129393,
  		2
  	],
  	[
  		129394,
  		2
  	],
  	[
  		[
  			129395,
  			129398
  		],
  		2
  	],
  	[
  		[
  			129399,
  			129400
  		],
  		2
  	],
  	[
  		129401,
  		3
  	],
  	[
  		129402,
  		2
  	],
  	[
  		129403,
  		2
  	],
  	[
  		[
  			129404,
  			129407
  		],
  		2
  	],
  	[
  		[
  			129408,
  			129412
  		],
  		2
  	],
  	[
  		[
  			129413,
  			129425
  		],
  		2
  	],
  	[
  		[
  			129426,
  			129431
  		],
  		2
  	],
  	[
  		[
  			129432,
  			129442
  		],
  		2
  	],
  	[
  		[
  			129443,
  			129444
  		],
  		2
  	],
  	[
  		[
  			129445,
  			129450
  		],
  		2
  	],
  	[
  		[
  			129451,
  			129453
  		],
  		2
  	],
  	[
  		[
  			129454,
  			129455
  		],
  		2
  	],
  	[
  		[
  			129456,
  			129465
  		],
  		2
  	],
  	[
  		[
  			129466,
  			129471
  		],
  		2
  	],
  	[
  		129472,
  		2
  	],
  	[
  		[
  			129473,
  			129474
  		],
  		2
  	],
  	[
  		[
  			129475,
  			129482
  		],
  		2
  	],
  	[
  		129483,
  		2
  	],
  	[
  		129484,
  		3
  	],
  	[
  		[
  			129485,
  			129487
  		],
  		2
  	],
  	[
  		[
  			129488,
  			129510
  		],
  		2
  	],
  	[
  		[
  			129511,
  			129535
  		],
  		2
  	],
  	[
  		[
  			129536,
  			129619
  		],
  		2
  	],
  	[
  		[
  			129620,
  			129631
  		],
  		3
  	],
  	[
  		[
  			129632,
  			129645
  		],
  		2
  	],
  	[
  		[
  			129646,
  			129647
  		],
  		3
  	],
  	[
  		[
  			129648,
  			129651
  		],
  		2
  	],
  	[
  		129652,
  		2
  	],
  	[
  		[
  			129653,
  			129655
  		],
  		3
  	],
  	[
  		[
  			129656,
  			129658
  		],
  		2
  	],
  	[
  		[
  			129659,
  			129663
  		],
  		3
  	],
  	[
  		[
  			129664,
  			129666
  		],
  		2
  	],
  	[
  		[
  			129667,
  			129670
  		],
  		2
  	],
  	[
  		[
  			129671,
  			129679
  		],
  		3
  	],
  	[
  		[
  			129680,
  			129685
  		],
  		2
  	],
  	[
  		[
  			129686,
  			129704
  		],
  		2
  	],
  	[
  		[
  			129705,
  			129711
  		],
  		3
  	],
  	[
  		[
  			129712,
  			129718
  		],
  		2
  	],
  	[
  		[
  			129719,
  			129727
  		],
  		3
  	],
  	[
  		[
  			129728,
  			129730
  		],
  		2
  	],
  	[
  		[
  			129731,
  			129743
  		],
  		3
  	],
  	[
  		[
  			129744,
  			129750
  		],
  		2
  	],
  	[
  		[
  			129751,
  			129791
  		],
  		3
  	],
  	[
  		[
  			129792,
  			129938
  		],
  		2
  	],
  	[
  		129939,
  		3
  	],
  	[
  		[
  			129940,
  			129994
  		],
  		2
  	],
  	[
  		[
  			129995,
  			130031
  		],
  		3
  	],
  	[
  		130032,
  		1,
  		"0"
  	],
  	[
  		130033,
  		1,
  		"1"
  	],
  	[
  		130034,
  		1,
  		"2"
  	],
  	[
  		130035,
  		1,
  		"3"
  	],
  	[
  		130036,
  		1,
  		"4"
  	],
  	[
  		130037,
  		1,
  		"5"
  	],
  	[
  		130038,
  		1,
  		"6"
  	],
  	[
  		130039,
  		1,
  		"7"
  	],
  	[
  		130040,
  		1,
  		"8"
  	],
  	[
  		130041,
  		1,
  		"9"
  	],
  	[
  		[
  			130042,
  			131069
  		],
  		3
  	],
  	[
  		[
  			131070,
  			131071
  		],
  		3
  	],
  	[
  		[
  			131072,
  			173782
  		],
  		2
  	],
  	[
  		[
  			173783,
  			173789
  		],
  		2
  	],
  	[
  		[
  			173790,
  			173823
  		],
  		3
  	],
  	[
  		[
  			173824,
  			177972
  		],
  		2
  	],
  	[
  		[
  			177973,
  			177983
  		],
  		3
  	],
  	[
  		[
  			177984,
  			178205
  		],
  		2
  	],
  	[
  		[
  			178206,
  			178207
  		],
  		3
  	],
  	[
  		[
  			178208,
  			183969
  		],
  		2
  	],
  	[
  		[
  			183970,
  			183983
  		],
  		3
  	],
  	[
  		[
  			183984,
  			191456
  		],
  		2
  	],
  	[
  		[
  			191457,
  			194559
  		],
  		3
  	],
  	[
  		194560,
  		1,
  		"丽"
  	],
  	[
  		194561,
  		1,
  		"丸"
  	],
  	[
  		194562,
  		1,
  		"乁"
  	],
  	[
  		194563,
  		1,
  		"𠄢"
  	],
  	[
  		194564,
  		1,
  		"你"
  	],
  	[
  		194565,
  		1,
  		"侮"
  	],
  	[
  		194566,
  		1,
  		"侻"
  	],
  	[
  		194567,
  		1,
  		"倂"
  	],
  	[
  		194568,
  		1,
  		"偺"
  	],
  	[
  		194569,
  		1,
  		"備"
  	],
  	[
  		194570,
  		1,
  		"僧"
  	],
  	[
  		194571,
  		1,
  		"像"
  	],
  	[
  		194572,
  		1,
  		"㒞"
  	],
  	[
  		194573,
  		1,
  		"𠘺"
  	],
  	[
  		194574,
  		1,
  		"免"
  	],
  	[
  		194575,
  		1,
  		"兔"
  	],
  	[
  		194576,
  		1,
  		"兤"
  	],
  	[
  		194577,
  		1,
  		"具"
  	],
  	[
  		194578,
  		1,
  		"𠔜"
  	],
  	[
  		194579,
  		1,
  		"㒹"
  	],
  	[
  		194580,
  		1,
  		"內"
  	],
  	[
  		194581,
  		1,
  		"再"
  	],
  	[
  		194582,
  		1,
  		"𠕋"
  	],
  	[
  		194583,
  		1,
  		"冗"
  	],
  	[
  		194584,
  		1,
  		"冤"
  	],
  	[
  		194585,
  		1,
  		"仌"
  	],
  	[
  		194586,
  		1,
  		"冬"
  	],
  	[
  		194587,
  		1,
  		"况"
  	],
  	[
  		194588,
  		1,
  		"𩇟"
  	],
  	[
  		194589,
  		1,
  		"凵"
  	],
  	[
  		194590,
  		1,
  		"刃"
  	],
  	[
  		194591,
  		1,
  		"㓟"
  	],
  	[
  		194592,
  		1,
  		"刻"
  	],
  	[
  		194593,
  		1,
  		"剆"
  	],
  	[
  		194594,
  		1,
  		"割"
  	],
  	[
  		194595,
  		1,
  		"剷"
  	],
  	[
  		194596,
  		1,
  		"㔕"
  	],
  	[
  		194597,
  		1,
  		"勇"
  	],
  	[
  		194598,
  		1,
  		"勉"
  	],
  	[
  		194599,
  		1,
  		"勤"
  	],
  	[
  		194600,
  		1,
  		"勺"
  	],
  	[
  		194601,
  		1,
  		"包"
  	],
  	[
  		194602,
  		1,
  		"匆"
  	],
  	[
  		194603,
  		1,
  		"北"
  	],
  	[
  		194604,
  		1,
  		"卉"
  	],
  	[
  		194605,
  		1,
  		"卑"
  	],
  	[
  		194606,
  		1,
  		"博"
  	],
  	[
  		194607,
  		1,
  		"即"
  	],
  	[
  		194608,
  		1,
  		"卽"
  	],
  	[
  		[
  			194609,
  			194611
  		],
  		1,
  		"卿"
  	],
  	[
  		194612,
  		1,
  		"𠨬"
  	],
  	[
  		194613,
  		1,
  		"灰"
  	],
  	[
  		194614,
  		1,
  		"及"
  	],
  	[
  		194615,
  		1,
  		"叟"
  	],
  	[
  		194616,
  		1,
  		"𠭣"
  	],
  	[
  		194617,
  		1,
  		"叫"
  	],
  	[
  		194618,
  		1,
  		"叱"
  	],
  	[
  		194619,
  		1,
  		"吆"
  	],
  	[
  		194620,
  		1,
  		"咞"
  	],
  	[
  		194621,
  		1,
  		"吸"
  	],
  	[
  		194622,
  		1,
  		"呈"
  	],
  	[
  		194623,
  		1,
  		"周"
  	],
  	[
  		194624,
  		1,
  		"咢"
  	],
  	[
  		194625,
  		1,
  		"哶"
  	],
  	[
  		194626,
  		1,
  		"唐"
  	],
  	[
  		194627,
  		1,
  		"啓"
  	],
  	[
  		194628,
  		1,
  		"啣"
  	],
  	[
  		[
  			194629,
  			194630
  		],
  		1,
  		"善"
  	],
  	[
  		194631,
  		1,
  		"喙"
  	],
  	[
  		194632,
  		1,
  		"喫"
  	],
  	[
  		194633,
  		1,
  		"喳"
  	],
  	[
  		194634,
  		1,
  		"嗂"
  	],
  	[
  		194635,
  		1,
  		"圖"
  	],
  	[
  		194636,
  		1,
  		"嘆"
  	],
  	[
  		194637,
  		1,
  		"圗"
  	],
  	[
  		194638,
  		1,
  		"噑"
  	],
  	[
  		194639,
  		1,
  		"噴"
  	],
  	[
  		194640,
  		1,
  		"切"
  	],
  	[
  		194641,
  		1,
  		"壮"
  	],
  	[
  		194642,
  		1,
  		"城"
  	],
  	[
  		194643,
  		1,
  		"埴"
  	],
  	[
  		194644,
  		1,
  		"堍"
  	],
  	[
  		194645,
  		1,
  		"型"
  	],
  	[
  		194646,
  		1,
  		"堲"
  	],
  	[
  		194647,
  		1,
  		"報"
  	],
  	[
  		194648,
  		1,
  		"墬"
  	],
  	[
  		194649,
  		1,
  		"𡓤"
  	],
  	[
  		194650,
  		1,
  		"売"
  	],
  	[
  		194651,
  		1,
  		"壷"
  	],
  	[
  		194652,
  		1,
  		"夆"
  	],
  	[
  		194653,
  		1,
  		"多"
  	],
  	[
  		194654,
  		1,
  		"夢"
  	],
  	[
  		194655,
  		1,
  		"奢"
  	],
  	[
  		194656,
  		1,
  		"𡚨"
  	],
  	[
  		194657,
  		1,
  		"𡛪"
  	],
  	[
  		194658,
  		1,
  		"姬"
  	],
  	[
  		194659,
  		1,
  		"娛"
  	],
  	[
  		194660,
  		1,
  		"娧"
  	],
  	[
  		194661,
  		1,
  		"姘"
  	],
  	[
  		194662,
  		1,
  		"婦"
  	],
  	[
  		194663,
  		1,
  		"㛮"
  	],
  	[
  		194664,
  		3
  	],
  	[
  		194665,
  		1,
  		"嬈"
  	],
  	[
  		[
  			194666,
  			194667
  		],
  		1,
  		"嬾"
  	],
  	[
  		194668,
  		1,
  		"𡧈"
  	],
  	[
  		194669,
  		1,
  		"寃"
  	],
  	[
  		194670,
  		1,
  		"寘"
  	],
  	[
  		194671,
  		1,
  		"寧"
  	],
  	[
  		194672,
  		1,
  		"寳"
  	],
  	[
  		194673,
  		1,
  		"𡬘"
  	],
  	[
  		194674,
  		1,
  		"寿"
  	],
  	[
  		194675,
  		1,
  		"将"
  	],
  	[
  		194676,
  		3
  	],
  	[
  		194677,
  		1,
  		"尢"
  	],
  	[
  		194678,
  		1,
  		"㞁"
  	],
  	[
  		194679,
  		1,
  		"屠"
  	],
  	[
  		194680,
  		1,
  		"屮"
  	],
  	[
  		194681,
  		1,
  		"峀"
  	],
  	[
  		194682,
  		1,
  		"岍"
  	],
  	[
  		194683,
  		1,
  		"𡷤"
  	],
  	[
  		194684,
  		1,
  		"嵃"
  	],
  	[
  		194685,
  		1,
  		"𡷦"
  	],
  	[
  		194686,
  		1,
  		"嵮"
  	],
  	[
  		194687,
  		1,
  		"嵫"
  	],
  	[
  		194688,
  		1,
  		"嵼"
  	],
  	[
  		194689,
  		1,
  		"巡"
  	],
  	[
  		194690,
  		1,
  		"巢"
  	],
  	[
  		194691,
  		1,
  		"㠯"
  	],
  	[
  		194692,
  		1,
  		"巽"
  	],
  	[
  		194693,
  		1,
  		"帨"
  	],
  	[
  		194694,
  		1,
  		"帽"
  	],
  	[
  		194695,
  		1,
  		"幩"
  	],
  	[
  		194696,
  		1,
  		"㡢"
  	],
  	[
  		194697,
  		1,
  		"𢆃"
  	],
  	[
  		194698,
  		1,
  		"㡼"
  	],
  	[
  		194699,
  		1,
  		"庰"
  	],
  	[
  		194700,
  		1,
  		"庳"
  	],
  	[
  		194701,
  		1,
  		"庶"
  	],
  	[
  		194702,
  		1,
  		"廊"
  	],
  	[
  		194703,
  		1,
  		"𪎒"
  	],
  	[
  		194704,
  		1,
  		"廾"
  	],
  	[
  		[
  			194705,
  			194706
  		],
  		1,
  		"𢌱"
  	],
  	[
  		194707,
  		1,
  		"舁"
  	],
  	[
  		[
  			194708,
  			194709
  		],
  		1,
  		"弢"
  	],
  	[
  		194710,
  		1,
  		"㣇"
  	],
  	[
  		194711,
  		1,
  		"𣊸"
  	],
  	[
  		194712,
  		1,
  		"𦇚"
  	],
  	[
  		194713,
  		1,
  		"形"
  	],
  	[
  		194714,
  		1,
  		"彫"
  	],
  	[
  		194715,
  		1,
  		"㣣"
  	],
  	[
  		194716,
  		1,
  		"徚"
  	],
  	[
  		194717,
  		1,
  		"忍"
  	],
  	[
  		194718,
  		1,
  		"志"
  	],
  	[
  		194719,
  		1,
  		"忹"
  	],
  	[
  		194720,
  		1,
  		"悁"
  	],
  	[
  		194721,
  		1,
  		"㤺"
  	],
  	[
  		194722,
  		1,
  		"㤜"
  	],
  	[
  		194723,
  		1,
  		"悔"
  	],
  	[
  		194724,
  		1,
  		"𢛔"
  	],
  	[
  		194725,
  		1,
  		"惇"
  	],
  	[
  		194726,
  		1,
  		"慈"
  	],
  	[
  		194727,
  		1,
  		"慌"
  	],
  	[
  		194728,
  		1,
  		"慎"
  	],
  	[
  		194729,
  		1,
  		"慌"
  	],
  	[
  		194730,
  		1,
  		"慺"
  	],
  	[
  		194731,
  		1,
  		"憎"
  	],
  	[
  		194732,
  		1,
  		"憲"
  	],
  	[
  		194733,
  		1,
  		"憤"
  	],
  	[
  		194734,
  		1,
  		"憯"
  	],
  	[
  		194735,
  		1,
  		"懞"
  	],
  	[
  		194736,
  		1,
  		"懲"
  	],
  	[
  		194737,
  		1,
  		"懶"
  	],
  	[
  		194738,
  		1,
  		"成"
  	],
  	[
  		194739,
  		1,
  		"戛"
  	],
  	[
  		194740,
  		1,
  		"扝"
  	],
  	[
  		194741,
  		1,
  		"抱"
  	],
  	[
  		194742,
  		1,
  		"拔"
  	],
  	[
  		194743,
  		1,
  		"捐"
  	],
  	[
  		194744,
  		1,
  		"𢬌"
  	],
  	[
  		194745,
  		1,
  		"挽"
  	],
  	[
  		194746,
  		1,
  		"拼"
  	],
  	[
  		194747,
  		1,
  		"捨"
  	],
  	[
  		194748,
  		1,
  		"掃"
  	],
  	[
  		194749,
  		1,
  		"揤"
  	],
  	[
  		194750,
  		1,
  		"𢯱"
  	],
  	[
  		194751,
  		1,
  		"搢"
  	],
  	[
  		194752,
  		1,
  		"揅"
  	],
  	[
  		194753,
  		1,
  		"掩"
  	],
  	[
  		194754,
  		1,
  		"㨮"
  	],
  	[
  		194755,
  		1,
  		"摩"
  	],
  	[
  		194756,
  		1,
  		"摾"
  	],
  	[
  		194757,
  		1,
  		"撝"
  	],
  	[
  		194758,
  		1,
  		"摷"
  	],
  	[
  		194759,
  		1,
  		"㩬"
  	],
  	[
  		194760,
  		1,
  		"敏"
  	],
  	[
  		194761,
  		1,
  		"敬"
  	],
  	[
  		194762,
  		1,
  		"𣀊"
  	],
  	[
  		194763,
  		1,
  		"旣"
  	],
  	[
  		194764,
  		1,
  		"書"
  	],
  	[
  		194765,
  		1,
  		"晉"
  	],
  	[
  		194766,
  		1,
  		"㬙"
  	],
  	[
  		194767,
  		1,
  		"暑"
  	],
  	[
  		194768,
  		1,
  		"㬈"
  	],
  	[
  		194769,
  		1,
  		"㫤"
  	],
  	[
  		194770,
  		1,
  		"冒"
  	],
  	[
  		194771,
  		1,
  		"冕"
  	],
  	[
  		194772,
  		1,
  		"最"
  	],
  	[
  		194773,
  		1,
  		"暜"
  	],
  	[
  		194774,
  		1,
  		"肭"
  	],
  	[
  		194775,
  		1,
  		"䏙"
  	],
  	[
  		194776,
  		1,
  		"朗"
  	],
  	[
  		194777,
  		1,
  		"望"
  	],
  	[
  		194778,
  		1,
  		"朡"
  	],
  	[
  		194779,
  		1,
  		"杞"
  	],
  	[
  		194780,
  		1,
  		"杓"
  	],
  	[
  		194781,
  		1,
  		"𣏃"
  	],
  	[
  		194782,
  		1,
  		"㭉"
  	],
  	[
  		194783,
  		1,
  		"柺"
  	],
  	[
  		194784,
  		1,
  		"枅"
  	],
  	[
  		194785,
  		1,
  		"桒"
  	],
  	[
  		194786,
  		1,
  		"梅"
  	],
  	[
  		194787,
  		1,
  		"𣑭"
  	],
  	[
  		194788,
  		1,
  		"梎"
  	],
  	[
  		194789,
  		1,
  		"栟"
  	],
  	[
  		194790,
  		1,
  		"椔"
  	],
  	[
  		194791,
  		1,
  		"㮝"
  	],
  	[
  		194792,
  		1,
  		"楂"
  	],
  	[
  		194793,
  		1,
  		"榣"
  	],
  	[
  		194794,
  		1,
  		"槪"
  	],
  	[
  		194795,
  		1,
  		"檨"
  	],
  	[
  		194796,
  		1,
  		"𣚣"
  	],
  	[
  		194797,
  		1,
  		"櫛"
  	],
  	[
  		194798,
  		1,
  		"㰘"
  	],
  	[
  		194799,
  		1,
  		"次"
  	],
  	[
  		194800,
  		1,
  		"𣢧"
  	],
  	[
  		194801,
  		1,
  		"歔"
  	],
  	[
  		194802,
  		1,
  		"㱎"
  	],
  	[
  		194803,
  		1,
  		"歲"
  	],
  	[
  		194804,
  		1,
  		"殟"
  	],
  	[
  		194805,
  		1,
  		"殺"
  	],
  	[
  		194806,
  		1,
  		"殻"
  	],
  	[
  		194807,
  		1,
  		"𣪍"
  	],
  	[
  		194808,
  		1,
  		"𡴋"
  	],
  	[
  		194809,
  		1,
  		"𣫺"
  	],
  	[
  		194810,
  		1,
  		"汎"
  	],
  	[
  		194811,
  		1,
  		"𣲼"
  	],
  	[
  		194812,
  		1,
  		"沿"
  	],
  	[
  		194813,
  		1,
  		"泍"
  	],
  	[
  		194814,
  		1,
  		"汧"
  	],
  	[
  		194815,
  		1,
  		"洖"
  	],
  	[
  		194816,
  		1,
  		"派"
  	],
  	[
  		194817,
  		1,
  		"海"
  	],
  	[
  		194818,
  		1,
  		"流"
  	],
  	[
  		194819,
  		1,
  		"浩"
  	],
  	[
  		194820,
  		1,
  		"浸"
  	],
  	[
  		194821,
  		1,
  		"涅"
  	],
  	[
  		194822,
  		1,
  		"𣴞"
  	],
  	[
  		194823,
  		1,
  		"洴"
  	],
  	[
  		194824,
  		1,
  		"港"
  	],
  	[
  		194825,
  		1,
  		"湮"
  	],
  	[
  		194826,
  		1,
  		"㴳"
  	],
  	[
  		194827,
  		1,
  		"滋"
  	],
  	[
  		194828,
  		1,
  		"滇"
  	],
  	[
  		194829,
  		1,
  		"𣻑"
  	],
  	[
  		194830,
  		1,
  		"淹"
  	],
  	[
  		194831,
  		1,
  		"潮"
  	],
  	[
  		194832,
  		1,
  		"𣽞"
  	],
  	[
  		194833,
  		1,
  		"𣾎"
  	],
  	[
  		194834,
  		1,
  		"濆"
  	],
  	[
  		194835,
  		1,
  		"瀹"
  	],
  	[
  		194836,
  		1,
  		"瀞"
  	],
  	[
  		194837,
  		1,
  		"瀛"
  	],
  	[
  		194838,
  		1,
  		"㶖"
  	],
  	[
  		194839,
  		1,
  		"灊"
  	],
  	[
  		194840,
  		1,
  		"災"
  	],
  	[
  		194841,
  		1,
  		"灷"
  	],
  	[
  		194842,
  		1,
  		"炭"
  	],
  	[
  		194843,
  		1,
  		"𠔥"
  	],
  	[
  		194844,
  		1,
  		"煅"
  	],
  	[
  		194845,
  		1,
  		"𤉣"
  	],
  	[
  		194846,
  		1,
  		"熜"
  	],
  	[
  		194847,
  		3
  	],
  	[
  		194848,
  		1,
  		"爨"
  	],
  	[
  		194849,
  		1,
  		"爵"
  	],
  	[
  		194850,
  		1,
  		"牐"
  	],
  	[
  		194851,
  		1,
  		"𤘈"
  	],
  	[
  		194852,
  		1,
  		"犀"
  	],
  	[
  		194853,
  		1,
  		"犕"
  	],
  	[
  		194854,
  		1,
  		"𤜵"
  	],
  	[
  		194855,
  		1,
  		"𤠔"
  	],
  	[
  		194856,
  		1,
  		"獺"
  	],
  	[
  		194857,
  		1,
  		"王"
  	],
  	[
  		194858,
  		1,
  		"㺬"
  	],
  	[
  		194859,
  		1,
  		"玥"
  	],
  	[
  		[
  			194860,
  			194861
  		],
  		1,
  		"㺸"
  	],
  	[
  		194862,
  		1,
  		"瑇"
  	],
  	[
  		194863,
  		1,
  		"瑜"
  	],
  	[
  		194864,
  		1,
  		"瑱"
  	],
  	[
  		194865,
  		1,
  		"璅"
  	],
  	[
  		194866,
  		1,
  		"瓊"
  	],
  	[
  		194867,
  		1,
  		"㼛"
  	],
  	[
  		194868,
  		1,
  		"甤"
  	],
  	[
  		194869,
  		1,
  		"𤰶"
  	],
  	[
  		194870,
  		1,
  		"甾"
  	],
  	[
  		194871,
  		1,
  		"𤲒"
  	],
  	[
  		194872,
  		1,
  		"異"
  	],
  	[
  		194873,
  		1,
  		"𢆟"
  	],
  	[
  		194874,
  		1,
  		"瘐"
  	],
  	[
  		194875,
  		1,
  		"𤾡"
  	],
  	[
  		194876,
  		1,
  		"𤾸"
  	],
  	[
  		194877,
  		1,
  		"𥁄"
  	],
  	[
  		194878,
  		1,
  		"㿼"
  	],
  	[
  		194879,
  		1,
  		"䀈"
  	],
  	[
  		194880,
  		1,
  		"直"
  	],
  	[
  		194881,
  		1,
  		"𥃳"
  	],
  	[
  		194882,
  		1,
  		"𥃲"
  	],
  	[
  		194883,
  		1,
  		"𥄙"
  	],
  	[
  		194884,
  		1,
  		"𥄳"
  	],
  	[
  		194885,
  		1,
  		"眞"
  	],
  	[
  		[
  			194886,
  			194887
  		],
  		1,
  		"真"
  	],
  	[
  		194888,
  		1,
  		"睊"
  	],
  	[
  		194889,
  		1,
  		"䀹"
  	],
  	[
  		194890,
  		1,
  		"瞋"
  	],
  	[
  		194891,
  		1,
  		"䁆"
  	],
  	[
  		194892,
  		1,
  		"䂖"
  	],
  	[
  		194893,
  		1,
  		"𥐝"
  	],
  	[
  		194894,
  		1,
  		"硎"
  	],
  	[
  		194895,
  		1,
  		"碌"
  	],
  	[
  		194896,
  		1,
  		"磌"
  	],
  	[
  		194897,
  		1,
  		"䃣"
  	],
  	[
  		194898,
  		1,
  		"𥘦"
  	],
  	[
  		194899,
  		1,
  		"祖"
  	],
  	[
  		194900,
  		1,
  		"𥚚"
  	],
  	[
  		194901,
  		1,
  		"𥛅"
  	],
  	[
  		194902,
  		1,
  		"福"
  	],
  	[
  		194903,
  		1,
  		"秫"
  	],
  	[
  		194904,
  		1,
  		"䄯"
  	],
  	[
  		194905,
  		1,
  		"穀"
  	],
  	[
  		194906,
  		1,
  		"穊"
  	],
  	[
  		194907,
  		1,
  		"穏"
  	],
  	[
  		194908,
  		1,
  		"𥥼"
  	],
  	[
  		[
  			194909,
  			194910
  		],
  		1,
  		"𥪧"
  	],
  	[
  		194911,
  		3
  	],
  	[
  		194912,
  		1,
  		"䈂"
  	],
  	[
  		194913,
  		1,
  		"𥮫"
  	],
  	[
  		194914,
  		1,
  		"篆"
  	],
  	[
  		194915,
  		1,
  		"築"
  	],
  	[
  		194916,
  		1,
  		"䈧"
  	],
  	[
  		194917,
  		1,
  		"𥲀"
  	],
  	[
  		194918,
  		1,
  		"糒"
  	],
  	[
  		194919,
  		1,
  		"䊠"
  	],
  	[
  		194920,
  		1,
  		"糨"
  	],
  	[
  		194921,
  		1,
  		"糣"
  	],
  	[
  		194922,
  		1,
  		"紀"
  	],
  	[
  		194923,
  		1,
  		"𥾆"
  	],
  	[
  		194924,
  		1,
  		"絣"
  	],
  	[
  		194925,
  		1,
  		"䌁"
  	],
  	[
  		194926,
  		1,
  		"緇"
  	],
  	[
  		194927,
  		1,
  		"縂"
  	],
  	[
  		194928,
  		1,
  		"繅"
  	],
  	[
  		194929,
  		1,
  		"䌴"
  	],
  	[
  		194930,
  		1,
  		"𦈨"
  	],
  	[
  		194931,
  		1,
  		"𦉇"
  	],
  	[
  		194932,
  		1,
  		"䍙"
  	],
  	[
  		194933,
  		1,
  		"𦋙"
  	],
  	[
  		194934,
  		1,
  		"罺"
  	],
  	[
  		194935,
  		1,
  		"𦌾"
  	],
  	[
  		194936,
  		1,
  		"羕"
  	],
  	[
  		194937,
  		1,
  		"翺"
  	],
  	[
  		194938,
  		1,
  		"者"
  	],
  	[
  		194939,
  		1,
  		"𦓚"
  	],
  	[
  		194940,
  		1,
  		"𦔣"
  	],
  	[
  		194941,
  		1,
  		"聠"
  	],
  	[
  		194942,
  		1,
  		"𦖨"
  	],
  	[
  		194943,
  		1,
  		"聰"
  	],
  	[
  		194944,
  		1,
  		"𣍟"
  	],
  	[
  		194945,
  		1,
  		"䏕"
  	],
  	[
  		194946,
  		1,
  		"育"
  	],
  	[
  		194947,
  		1,
  		"脃"
  	],
  	[
  		194948,
  		1,
  		"䐋"
  	],
  	[
  		194949,
  		1,
  		"脾"
  	],
  	[
  		194950,
  		1,
  		"媵"
  	],
  	[
  		194951,
  		1,
  		"𦞧"
  	],
  	[
  		194952,
  		1,
  		"𦞵"
  	],
  	[
  		194953,
  		1,
  		"𣎓"
  	],
  	[
  		194954,
  		1,
  		"𣎜"
  	],
  	[
  		194955,
  		1,
  		"舁"
  	],
  	[
  		194956,
  		1,
  		"舄"
  	],
  	[
  		194957,
  		1,
  		"辞"
  	],
  	[
  		194958,
  		1,
  		"䑫"
  	],
  	[
  		194959,
  		1,
  		"芑"
  	],
  	[
  		194960,
  		1,
  		"芋"
  	],
  	[
  		194961,
  		1,
  		"芝"
  	],
  	[
  		194962,
  		1,
  		"劳"
  	],
  	[
  		194963,
  		1,
  		"花"
  	],
  	[
  		194964,
  		1,
  		"芳"
  	],
  	[
  		194965,
  		1,
  		"芽"
  	],
  	[
  		194966,
  		1,
  		"苦"
  	],
  	[
  		194967,
  		1,
  		"𦬼"
  	],
  	[
  		194968,
  		1,
  		"若"
  	],
  	[
  		194969,
  		1,
  		"茝"
  	],
  	[
  		194970,
  		1,
  		"荣"
  	],
  	[
  		194971,
  		1,
  		"莭"
  	],
  	[
  		194972,
  		1,
  		"茣"
  	],
  	[
  		194973,
  		1,
  		"莽"
  	],
  	[
  		194974,
  		1,
  		"菧"
  	],
  	[
  		194975,
  		1,
  		"著"
  	],
  	[
  		194976,
  		1,
  		"荓"
  	],
  	[
  		194977,
  		1,
  		"菊"
  	],
  	[
  		194978,
  		1,
  		"菌"
  	],
  	[
  		194979,
  		1,
  		"菜"
  	],
  	[
  		194980,
  		1,
  		"𦰶"
  	],
  	[
  		194981,
  		1,
  		"𦵫"
  	],
  	[
  		194982,
  		1,
  		"𦳕"
  	],
  	[
  		194983,
  		1,
  		"䔫"
  	],
  	[
  		194984,
  		1,
  		"蓱"
  	],
  	[
  		194985,
  		1,
  		"蓳"
  	],
  	[
  		194986,
  		1,
  		"蔖"
  	],
  	[
  		194987,
  		1,
  		"𧏊"
  	],
  	[
  		194988,
  		1,
  		"蕤"
  	],
  	[
  		194989,
  		1,
  		"𦼬"
  	],
  	[
  		194990,
  		1,
  		"䕝"
  	],
  	[
  		194991,
  		1,
  		"䕡"
  	],
  	[
  		194992,
  		1,
  		"𦾱"
  	],
  	[
  		194993,
  		1,
  		"𧃒"
  	],
  	[
  		194994,
  		1,
  		"䕫"
  	],
  	[
  		194995,
  		1,
  		"虐"
  	],
  	[
  		194996,
  		1,
  		"虜"
  	],
  	[
  		194997,
  		1,
  		"虧"
  	],
  	[
  		194998,
  		1,
  		"虩"
  	],
  	[
  		194999,
  		1,
  		"蚩"
  	],
  	[
  		195000,
  		1,
  		"蚈"
  	],
  	[
  		195001,
  		1,
  		"蜎"
  	],
  	[
  		195002,
  		1,
  		"蛢"
  	],
  	[
  		195003,
  		1,
  		"蝹"
  	],
  	[
  		195004,
  		1,
  		"蜨"
  	],
  	[
  		195005,
  		1,
  		"蝫"
  	],
  	[
  		195006,
  		1,
  		"螆"
  	],
  	[
  		195007,
  		3
  	],
  	[
  		195008,
  		1,
  		"蟡"
  	],
  	[
  		195009,
  		1,
  		"蠁"
  	],
  	[
  		195010,
  		1,
  		"䗹"
  	],
  	[
  		195011,
  		1,
  		"衠"
  	],
  	[
  		195012,
  		1,
  		"衣"
  	],
  	[
  		195013,
  		1,
  		"𧙧"
  	],
  	[
  		195014,
  		1,
  		"裗"
  	],
  	[
  		195015,
  		1,
  		"裞"
  	],
  	[
  		195016,
  		1,
  		"䘵"
  	],
  	[
  		195017,
  		1,
  		"裺"
  	],
  	[
  		195018,
  		1,
  		"㒻"
  	],
  	[
  		195019,
  		1,
  		"𧢮"
  	],
  	[
  		195020,
  		1,
  		"𧥦"
  	],
  	[
  		195021,
  		1,
  		"䚾"
  	],
  	[
  		195022,
  		1,
  		"䛇"
  	],
  	[
  		195023,
  		1,
  		"誠"
  	],
  	[
  		195024,
  		1,
  		"諭"
  	],
  	[
  		195025,
  		1,
  		"變"
  	],
  	[
  		195026,
  		1,
  		"豕"
  	],
  	[
  		195027,
  		1,
  		"𧲨"
  	],
  	[
  		195028,
  		1,
  		"貫"
  	],
  	[
  		195029,
  		1,
  		"賁"
  	],
  	[
  		195030,
  		1,
  		"贛"
  	],
  	[
  		195031,
  		1,
  		"起"
  	],
  	[
  		195032,
  		1,
  		"𧼯"
  	],
  	[
  		195033,
  		1,
  		"𠠄"
  	],
  	[
  		195034,
  		1,
  		"跋"
  	],
  	[
  		195035,
  		1,
  		"趼"
  	],
  	[
  		195036,
  		1,
  		"跰"
  	],
  	[
  		195037,
  		1,
  		"𠣞"
  	],
  	[
  		195038,
  		1,
  		"軔"
  	],
  	[
  		195039,
  		1,
  		"輸"
  	],
  	[
  		195040,
  		1,
  		"𨗒"
  	],
  	[
  		195041,
  		1,
  		"𨗭"
  	],
  	[
  		195042,
  		1,
  		"邔"
  	],
  	[
  		195043,
  		1,
  		"郱"
  	],
  	[
  		195044,
  		1,
  		"鄑"
  	],
  	[
  		195045,
  		1,
  		"𨜮"
  	],
  	[
  		195046,
  		1,
  		"鄛"
  	],
  	[
  		195047,
  		1,
  		"鈸"
  	],
  	[
  		195048,
  		1,
  		"鋗"
  	],
  	[
  		195049,
  		1,
  		"鋘"
  	],
  	[
  		195050,
  		1,
  		"鉼"
  	],
  	[
  		195051,
  		1,
  		"鏹"
  	],
  	[
  		195052,
  		1,
  		"鐕"
  	],
  	[
  		195053,
  		1,
  		"𨯺"
  	],
  	[
  		195054,
  		1,
  		"開"
  	],
  	[
  		195055,
  		1,
  		"䦕"
  	],
  	[
  		195056,
  		1,
  		"閷"
  	],
  	[
  		195057,
  		1,
  		"𨵷"
  	],
  	[
  		195058,
  		1,
  		"䧦"
  	],
  	[
  		195059,
  		1,
  		"雃"
  	],
  	[
  		195060,
  		1,
  		"嶲"
  	],
  	[
  		195061,
  		1,
  		"霣"
  	],
  	[
  		195062,
  		1,
  		"𩅅"
  	],
  	[
  		195063,
  		1,
  		"𩈚"
  	],
  	[
  		195064,
  		1,
  		"䩮"
  	],
  	[
  		195065,
  		1,
  		"䩶"
  	],
  	[
  		195066,
  		1,
  		"韠"
  	],
  	[
  		195067,
  		1,
  		"𩐊"
  	],
  	[
  		195068,
  		1,
  		"䪲"
  	],
  	[
  		195069,
  		1,
  		"𩒖"
  	],
  	[
  		[
  			195070,
  			195071
  		],
  		1,
  		"頋"
  	],
  	[
  		195072,
  		1,
  		"頩"
  	],
  	[
  		195073,
  		1,
  		"𩖶"
  	],
  	[
  		195074,
  		1,
  		"飢"
  	],
  	[
  		195075,
  		1,
  		"䬳"
  	],
  	[
  		195076,
  		1,
  		"餩"
  	],
  	[
  		195077,
  		1,
  		"馧"
  	],
  	[
  		195078,
  		1,
  		"駂"
  	],
  	[
  		195079,
  		1,
  		"駾"
  	],
  	[
  		195080,
  		1,
  		"䯎"
  	],
  	[
  		195081,
  		1,
  		"𩬰"
  	],
  	[
  		195082,
  		1,
  		"鬒"
  	],
  	[
  		195083,
  		1,
  		"鱀"
  	],
  	[
  		195084,
  		1,
  		"鳽"
  	],
  	[
  		195085,
  		1,
  		"䳎"
  	],
  	[
  		195086,
  		1,
  		"䳭"
  	],
  	[
  		195087,
  		1,
  		"鵧"
  	],
  	[
  		195088,
  		1,
  		"𪃎"
  	],
  	[
  		195089,
  		1,
  		"䳸"
  	],
  	[
  		195090,
  		1,
  		"𪄅"
  	],
  	[
  		195091,
  		1,
  		"𪈎"
  	],
  	[
  		195092,
  		1,
  		"𪊑"
  	],
  	[
  		195093,
  		1,
  		"麻"
  	],
  	[
  		195094,
  		1,
  		"䵖"
  	],
  	[
  		195095,
  		1,
  		"黹"
  	],
  	[
  		195096,
  		1,
  		"黾"
  	],
  	[
  		195097,
  		1,
  		"鼅"
  	],
  	[
  		195098,
  		1,
  		"鼏"
  	],
  	[
  		195099,
  		1,
  		"鼖"
  	],
  	[
  		195100,
  		1,
  		"鼻"
  	],
  	[
  		195101,
  		1,
  		"𪘀"
  	],
  	[
  		[
  			195102,
  			196605
  		],
  		3
  	],
  	[
  		[
  			196606,
  			196607
  		],
  		3
  	],
  	[
  		[
  			196608,
  			201546
  		],
  		2
  	],
  	[
  		[
  			201547,
  			262141
  		],
  		3
  	],
  	[
  		[
  			262142,
  			262143
  		],
  		3
  	],
  	[
  		[
  			262144,
  			327677
  		],
  		3
  	],
  	[
  		[
  			327678,
  			327679
  		],
  		3
  	],
  	[
  		[
  			327680,
  			393213
  		],
  		3
  	],
  	[
  		[
  			393214,
  			393215
  		],
  		3
  	],
  	[
  		[
  			393216,
  			458749
  		],
  		3
  	],
  	[
  		[
  			458750,
  			458751
  		],
  		3
  	],
  	[
  		[
  			458752,
  			524285
  		],
  		3
  	],
  	[
  		[
  			524286,
  			524287
  		],
  		3
  	],
  	[
  		[
  			524288,
  			589821
  		],
  		3
  	],
  	[
  		[
  			589822,
  			589823
  		],
  		3
  	],
  	[
  		[
  			589824,
  			655357
  		],
  		3
  	],
  	[
  		[
  			655358,
  			655359
  		],
  		3
  	],
  	[
  		[
  			655360,
  			720893
  		],
  		3
  	],
  	[
  		[
  			720894,
  			720895
  		],
  		3
  	],
  	[
  		[
  			720896,
  			786429
  		],
  		3
  	],
  	[
  		[
  			786430,
  			786431
  		],
  		3
  	],
  	[
  		[
  			786432,
  			851965
  		],
  		3
  	],
  	[
  		[
  			851966,
  			851967
  		],
  		3
  	],
  	[
  		[
  			851968,
  			917501
  		],
  		3
  	],
  	[
  		[
  			917502,
  			917503
  		],
  		3
  	],
  	[
  		917504,
  		3
  	],
  	[
  		917505,
  		3
  	],
  	[
  		[
  			917506,
  			917535
  		],
  		3
  	],
  	[
  		[
  			917536,
  			917631
  		],
  		3
  	],
  	[
  		[
  			917632,
  			917759
  		],
  		3
  	],
  	[
  		[
  			917760,
  			917999
  		],
  		7
  	],
  	[
  		[
  			918000,
  			983037
  		],
  		3
  	],
  	[
  		[
  			983038,
  			983039
  		],
  		3
  	],
  	[
  		[
  			983040,
  			1048573
  		],
  		3
  	],
  	[
  		[
  			1048574,
  			1048575
  		],
  		3
  	],
  	[
  		[
  			1048576,
  			1114109
  		],
  		3
  	],
  	[
  		[
  			1114110,
  			1114111
  		],
  		3
  	]
  ];

  var STATUS_MAPPING$1 = {
    mapped: 1,
    valid: 2,
    disallowed: 3,
    disallowed_STD3_valid: 4, // eslint-disable-line camelcase
    disallowed_STD3_mapped: 5, // eslint-disable-line camelcase
    deviation: 6,
    ignored: 7
  };

  var statusMapping = {
  	STATUS_MAPPING: STATUS_MAPPING$1
  };

  var punycode = /*@__PURE__*/getAugmentedNamespace(punycode_es6);

  const { STATUS_MAPPING } = statusMapping;

  function containsNonASCII(str) {
    return /[^\x00-\x7F]/.test(str);
  }

  function findStatus(val, { useSTD3ASCIIRules }) {
    let start = 0;
    let end = mappingTable.length - 1;

    while (start <= end) {
      const mid = Math.floor((start + end) / 2);

      const target = mappingTable[mid];
      const min = Array.isArray(target[0]) ? target[0][0] : target[0];
      const max = Array.isArray(target[0]) ? target[0][1] : target[0];

      if (min <= val && max >= val) {
        if (useSTD3ASCIIRules &&
            (target[1] === STATUS_MAPPING.disallowed_STD3_valid || target[1] === STATUS_MAPPING.disallowed_STD3_mapped)) {
          return [STATUS_MAPPING.disallowed, ...target.slice(2)];
        } else if (target[1] === STATUS_MAPPING.disallowed_STD3_valid) {
          return [STATUS_MAPPING.valid, ...target.slice(2)];
        } else if (target[1] === STATUS_MAPPING.disallowed_STD3_mapped) {
          return [STATUS_MAPPING.mapped, ...target.slice(2)];
        }

        return target.slice(1);
      } else if (min > val) {
        end = mid - 1;
      } else {
        start = mid + 1;
      }
    }

    return null;
  }

  function mapChars(domainName, { useSTD3ASCIIRules, processingOption }) {
    let hasError = false;
    let processed = "";

    for (const ch of domainName) {
      const [status, mapping] = findStatus(ch.codePointAt(0), { useSTD3ASCIIRules });

      switch (status) {
        case STATUS_MAPPING.disallowed:
          hasError = true;
          processed += ch;
          break;
        case STATUS_MAPPING.ignored:
          break;
        case STATUS_MAPPING.mapped:
          processed += mapping;
          break;
        case STATUS_MAPPING.deviation:
          if (processingOption === "transitional") {
            processed += mapping;
          } else {
            processed += ch;
          }
          break;
        case STATUS_MAPPING.valid:
          processed += ch;
          break;
      }
    }

    return {
      string: processed,
      error: hasError
    };
  }

  function validateLabel(label, { checkHyphens, checkBidi, checkJoiners, processingOption, useSTD3ASCIIRules }) {
    if (label.normalize("NFC") !== label) {
      return false;
    }

    const codePoints = Array.from(label);

    if (checkHyphens) {
      if ((codePoints[2] === "-" && codePoints[3] === "-") ||
          (label.startsWith("-") || label.endsWith("-"))) {
        return false;
      }
    }

    if (label.includes(".") ||
        (codePoints.length > 0 && regexes.combiningMarks.test(codePoints[0]))) {
      return false;
    }

    for (const ch of codePoints) {
      const [status] = findStatus(ch.codePointAt(0), { useSTD3ASCIIRules });
      if ((processingOption === "transitional" && status !== STATUS_MAPPING.valid) ||
          (processingOption === "nontransitional" &&
           status !== STATUS_MAPPING.valid && status !== STATUS_MAPPING.deviation)) {
        return false;
      }
    }

    // https://tools.ietf.org/html/rfc5892#appendix-A
    if (checkJoiners) {
      let last = 0;
      for (const [i, ch] of codePoints.entries()) {
        if (ch === "\u200C" || ch === "\u200D") {
          if (i > 0) {
            if (regexes.combiningClassVirama.test(codePoints[i - 1])) {
              continue;
            }
            if (ch === "\u200C") {
              // TODO: make this more efficient
              const next = codePoints.indexOf("\u200C", i + 1);
              const test = next < 0 ? codePoints.slice(last) : codePoints.slice(last, next);
              if (regexes.validZWNJ.test(test.join(""))) {
                last = i + 1;
                continue;
              }
            }
          }
          return false;
        }
      }
    }

    // https://tools.ietf.org/html/rfc5893#section-2
    if (checkBidi) {
      let rtl;

      // 1
      if (regexes.bidiS1LTR.test(codePoints[0])) {
        rtl = false;
      } else if (regexes.bidiS1RTL.test(codePoints[0])) {
        rtl = true;
      } else {
        return false;
      }

      if (rtl) {
        // 2-4
        if (!regexes.bidiS2.test(label) ||
            !regexes.bidiS3.test(label) ||
            (regexes.bidiS4EN.test(label) && regexes.bidiS4AN.test(label))) {
          return false;
        }
      } else if (!regexes.bidiS5.test(label) ||
                 !regexes.bidiS6.test(label)) { // 5-6
        return false;
      }
    }

    return true;
  }

  function isBidiDomain(labels) {
    const domain = labels.map(label => {
      if (label.startsWith("xn--")) {
        try {
          return punycode.decode(label.substring(4));
        } catch (err) {
          return "";
        }
      }
      return label;
    }).join(".");
    return regexes.bidiDomain.test(domain);
  }

  function processing(domainName, options) {
    const { processingOption } = options;

    // 1. Map.
    let { string, error } = mapChars(domainName, options);

    // 2. Normalize.
    string = string.normalize("NFC");

    // 3. Break.
    const labels = string.split(".");
    const isBidi = isBidiDomain(labels);

    // 4. Convert/Validate.
    for (const [i, origLabel] of labels.entries()) {
      let label = origLabel;
      let curProcessing = processingOption;
      if (label.startsWith("xn--")) {
        try {
          label = punycode.decode(label.substring(4));
          labels[i] = label;
        } catch (err) {
          error = true;
          continue;
        }
        curProcessing = "nontransitional";
      }

      // No need to validate if we already know there is an error.
      if (error) {
        continue;
      }
      const validation = validateLabel(label, Object.assign({}, options, {
        processingOption: curProcessing,
        checkBidi: options.checkBidi && isBidi
      }));
      if (!validation) {
        error = true;
      }
    }

    return {
      string: labels.join("."),
      error
    };
  }

  function toASCII(domainName, {
    checkHyphens = false,
    checkBidi = false,
    checkJoiners = false,
    useSTD3ASCIIRules = false,
    processingOption = "nontransitional",
    verifyDNSLength = false
  } = {}) {
    if (processingOption !== "transitional" && processingOption !== "nontransitional") {
      throw new RangeError("processingOption must be either transitional or nontransitional");
    }

    const result = processing(domainName, {
      processingOption,
      checkHyphens,
      checkBidi,
      checkJoiners,
      useSTD3ASCIIRules
    });
    let labels = result.string.split(".");
    labels = labels.map(l => {
      if (containsNonASCII(l)) {
        try {
          return "xn--" + punycode.encode(l);
        } catch (e) {
          result.error = true;
        }
      }
      return l;
    });

    if (verifyDNSLength) {
      const total = labels.join(".").length;
      if (total > 253 || total === 0) {
        result.error = true;
      }

      for (let i = 0; i < labels.length; ++i) {
        if (labels[i].length > 63 || labels[i].length === 0) {
          result.error = true;
          break;
        }
      }
    }

    if (result.error) {
      return null;
    }
    return labels.join(".");
  }

  function toUnicode(domainName, {
    checkHyphens = false,
    checkBidi = false,
    checkJoiners = false,
    useSTD3ASCIIRules = false,
    processingOption = "nontransitional"
  } = {}) {
    const result = processing(domainName, {
      processingOption,
      checkHyphens,
      checkBidi,
      checkJoiners,
      useSTD3ASCIIRules
    });

    return {
      domain: result.string,
      error: result.error
    };
  }

  var tr46 = {
    toASCII,
    toUnicode
  };

  // Note that we take code points as JS numbers, not JS strings.

  function isASCIIDigit(c) {
    return c >= 0x30 && c <= 0x39;
  }

  function isASCIIAlpha(c) {
    return (c >= 0x41 && c <= 0x5A) || (c >= 0x61 && c <= 0x7A);
  }

  function isASCIIAlphanumeric(c) {
    return isASCIIAlpha(c) || isASCIIDigit(c);
  }

  function isASCIIHex$1(c) {
    return isASCIIDigit(c) || (c >= 0x41 && c <= 0x46) || (c >= 0x61 && c <= 0x66);
  }

  var infra = {
    isASCIIDigit,
    isASCIIAlpha,
    isASCIIAlphanumeric,
    isASCIIHex: isASCIIHex$1
  };

  var encodingIndexes = createCommonjsModule(function (module) {
  (function(global) {

    if (module.exports) {
      module.exports = global;
    }

    global["encoding-indexes"] =
  {
    "big5":[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,17392,19506,17923,17830,17784,160359,19831,17843,162993,19682,163013,15253,18230,18244,19527,19520,148159,144919,160594,159371,159954,19543,172881,18255,17882,19589,162924,19719,19108,18081,158499,29221,154196,137827,146950,147297,26189,22267,null,32149,22813,166841,15860,38708,162799,23515,138590,23204,13861,171696,23249,23479,23804,26478,34195,170309,29793,29853,14453,138579,145054,155681,16108,153822,15093,31484,40855,147809,166157,143850,133770,143966,17162,33924,40854,37935,18736,34323,22678,38730,37400,31184,31282,26208,27177,34973,29772,31685,26498,31276,21071,36934,13542,29636,155065,29894,40903,22451,18735,21580,16689,145038,22552,31346,162661,35727,18094,159368,16769,155033,31662,140476,40904,140481,140489,140492,40905,34052,144827,16564,40906,17633,175615,25281,28782,40907,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,12736,12737,12738,12739,12740,131340,12741,131281,131277,12742,12743,131275,139240,12744,131274,12745,12746,12747,12748,131342,12749,12750,256,193,461,192,274,201,282,200,332,211,465,210,null,7870,null,7872,202,257,225,462,224,593,275,233,283,232,299,237,464,236,333,243,466,242,363,250,468,249,470,472,474,476,252,null,7871,null,7873,234,609,9178,9179,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,172969,135493,null,25866,null,null,20029,28381,40270,37343,null,null,161589,25745,20250,20264,20392,20822,20852,20892,20964,21153,21160,21307,21326,21457,21464,22242,22768,22788,22791,22834,22836,23398,23454,23455,23706,24198,24635,25993,26622,26628,26725,27982,28860,30005,32420,32428,32442,32455,32463,32479,32518,32567,33402,33487,33647,35270,35774,35810,36710,36711,36718,29713,31996,32205,26950,31433,21031,null,null,null,null,37260,30904,37214,32956,null,36107,33014,133607,null,null,32927,40647,19661,40393,40460,19518,171510,159758,40458,172339,13761,null,28314,33342,29977,null,18705,39532,39567,40857,31111,164972,138698,132560,142054,20004,20097,20096,20103,20159,20203,20279,13388,20413,15944,20483,20616,13437,13459,13477,20870,22789,20955,20988,20997,20105,21113,21136,21287,13767,21417,13649,21424,13651,21442,21539,13677,13682,13953,21651,21667,21684,21689,21712,21743,21784,21795,21800,13720,21823,13733,13759,21975,13765,163204,21797,null,134210,134421,151851,21904,142534,14828,131905,36422,150968,169189,16467,164030,30586,142392,14900,18389,164189,158194,151018,25821,134524,135092,134357,135412,25741,36478,134806,134155,135012,142505,164438,148691,null,134470,170573,164073,18420,151207,142530,39602,14951,169460,16365,13574,152263,169940,161992,142660,40302,38933,null,17369,155813,25780,21731,142668,142282,135287,14843,135279,157402,157462,162208,25834,151634,134211,36456,139681,166732,132913,null,18443,131497,16378,22643,142733,null,148936,132348,155799,134988,134550,21881,16571,17338,null,19124,141926,135325,33194,39157,134556,25465,14846,141173,36288,22177,25724,15939,null,173569,134665,142031,142537,null,135368,145858,14738,14854,164507,13688,155209,139463,22098,134961,142514,169760,13500,27709,151099,null,null,161140,142987,139784,173659,167117,134778,134196,157724,32659,135375,141315,141625,13819,152035,134796,135053,134826,16275,134960,134471,135503,134732,null,134827,134057,134472,135360,135485,16377,140950,25650,135085,144372,161337,142286,134526,134527,142417,142421,14872,134808,135367,134958,173618,158544,167122,167321,167114,38314,21708,33476,21945,null,171715,39974,39606,161630,142830,28992,33133,33004,23580,157042,33076,14231,21343,164029,37302,134906,134671,134775,134907,13789,151019,13833,134358,22191,141237,135369,134672,134776,135288,135496,164359,136277,134777,151120,142756,23124,135197,135198,135413,135414,22428,134673,161428,164557,135093,134779,151934,14083,135094,135552,152280,172733,149978,137274,147831,164476,22681,21096,13850,153405,31666,23400,18432,19244,40743,18919,39967,39821,154484,143677,22011,13810,22153,20008,22786,138177,194680,38737,131206,20059,20155,13630,23587,24401,24516,14586,25164,25909,27514,27701,27706,28780,29227,20012,29357,149737,32594,31035,31993,32595,156266,13505,null,156491,32770,32896,157202,158033,21341,34916,35265,161970,35744,36125,38021,38264,38271,38376,167439,38886,39029,39118,39134,39267,170000,40060,40479,40644,27503,63751,20023,131207,38429,25143,38050,null,20539,28158,171123,40870,15817,34959,147790,28791,23797,19232,152013,13657,154928,24866,166450,36775,37366,29073,26393,29626,144001,172295,15499,137600,19216,30948,29698,20910,165647,16393,27235,172730,16931,34319,133743,31274,170311,166634,38741,28749,21284,139390,37876,30425,166371,40871,30685,20131,20464,20668,20015,20247,40872,21556,32139,22674,22736,138678,24210,24217,24514,141074,25995,144377,26905,27203,146531,27903,null,29184,148741,29580,16091,150035,23317,29881,35715,154788,153237,31379,31724,31939,32364,33528,34199,40873,34960,40874,36537,40875,36815,34143,39392,37409,40876,167353,136255,16497,17058,23066,null,null,null,39016,26475,17014,22333,null,34262,149883,33471,160013,19585,159092,23931,158485,159678,40877,40878,23446,40879,26343,32347,28247,31178,15752,17603,143958,141206,17306,17718,null,23765,146202,35577,23672,15634,144721,23928,40882,29015,17752,147692,138787,19575,14712,13386,131492,158785,35532,20404,131641,22975,33132,38998,170234,24379,134047,null,139713,166253,16642,18107,168057,16135,40883,172469,16632,14294,18167,158790,16764,165554,160767,17773,14548,152730,17761,17691,19849,19579,19830,17898,16328,150287,13921,17630,17597,16877,23870,23880,23894,15868,14351,23972,23993,14368,14392,24130,24253,24357,24451,14600,14612,14655,14669,24791,24893,23781,14729,25015,25017,25039,14776,25132,25232,25317,25368,14840,22193,14851,25570,25595,25607,25690,14923,25792,23829,22049,40863,14999,25990,15037,26111,26195,15090,26258,15138,26390,15170,26532,26624,15192,26698,26756,15218,15217,15227,26889,26947,29276,26980,27039,27013,15292,27094,15325,27237,27252,27249,27266,15340,27289,15346,27307,27317,27348,27382,27521,27585,27626,27765,27818,15563,27906,27910,27942,28033,15599,28068,28081,28181,28184,28201,28294,166336,28347,28386,28378,40831,28392,28393,28452,28468,15686,147265,28545,28606,15722,15733,29111,23705,15754,28716,15761,28752,28756,28783,28799,28809,131877,17345,13809,134872,147159,22462,159443,28990,153568,13902,27042,166889,23412,31305,153825,169177,31333,31357,154028,31419,31408,31426,31427,29137,156813,16842,31450,31453,31466,16879,21682,154625,31499,31573,31529,152334,154878,31650,31599,33692,154548,158847,31696,33825,31634,31672,154912,15789,154725,33938,31738,31750,31797,154817,31812,31875,149634,31910,26237,148856,31945,31943,31974,31860,31987,31989,31950,32359,17693,159300,32093,159446,29837,32137,32171,28981,32179,32210,147543,155689,32228,15635,32245,137209,32229,164717,32285,155937,155994,32366,32402,17195,37996,32295,32576,32577,32583,31030,156368,39393,32663,156497,32675,136801,131176,17756,145254,17667,164666,32762,156809,32773,32776,32797,32808,32815,172167,158915,32827,32828,32865,141076,18825,157222,146915,157416,26405,32935,166472,33031,33050,22704,141046,27775,156824,151480,25831,136330,33304,137310,27219,150117,150165,17530,33321,133901,158290,146814,20473,136445,34018,33634,158474,149927,144688,137075,146936,33450,26907,194964,16859,34123,33488,33562,134678,137140,14017,143741,144730,33403,33506,33560,147083,159139,158469,158615,144846,15807,33565,21996,33669,17675,159141,33708,33729,33747,13438,159444,27223,34138,13462,159298,143087,33880,154596,33905,15827,17636,27303,33866,146613,31064,33960,158614,159351,159299,34014,33807,33681,17568,33939,34020,154769,16960,154816,17731,34100,23282,159385,17703,34163,17686,26559,34326,165413,165435,34241,159880,34306,136578,159949,194994,17770,34344,13896,137378,21495,160666,34430,34673,172280,34798,142375,34737,34778,34831,22113,34412,26710,17935,34885,34886,161248,146873,161252,34910,34972,18011,34996,34997,25537,35013,30583,161551,35207,35210,35238,35241,35239,35260,166437,35303,162084,162493,35484,30611,37374,35472,162393,31465,162618,147343,18195,162616,29052,35596,35615,152624,152933,35647,35660,35661,35497,150138,35728,35739,35503,136927,17941,34895,35995,163156,163215,195028,14117,163155,36054,163224,163261,36114,36099,137488,36059,28764,36113,150729,16080,36215,36265,163842,135188,149898,15228,164284,160012,31463,36525,36534,36547,37588,36633,36653,164709,164882,36773,37635,172703,133712,36787,18730,166366,165181,146875,24312,143970,36857,172052,165564,165121,140069,14720,159447,36919,165180,162494,36961,165228,165387,37032,165651,37060,165606,37038,37117,37223,15088,37289,37316,31916,166195,138889,37390,27807,37441,37474,153017,37561,166598,146587,166668,153051,134449,37676,37739,166625,166891,28815,23235,166626,166629,18789,37444,166892,166969,166911,37747,37979,36540,38277,38310,37926,38304,28662,17081,140922,165592,135804,146990,18911,27676,38523,38550,16748,38563,159445,25050,38582,30965,166624,38589,21452,18849,158904,131700,156688,168111,168165,150225,137493,144138,38705,34370,38710,18959,17725,17797,150249,28789,23361,38683,38748,168405,38743,23370,168427,38751,37925,20688,143543,143548,38793,38815,38833,38846,38848,38866,38880,152684,38894,29724,169011,38911,38901,168989,162170,19153,38964,38963,38987,39014,15118,160117,15697,132656,147804,153350,39114,39095,39112,39111,19199,159015,136915,21936,39137,39142,39148,37752,39225,150057,19314,170071,170245,39413,39436,39483,39440,39512,153381,14020,168113,170965,39648,39650,170757,39668,19470,39700,39725,165376,20532,39732,158120,14531,143485,39760,39744,171326,23109,137315,39822,148043,39938,39935,39948,171624,40404,171959,172434,172459,172257,172323,172511,40318,40323,172340,40462,26760,40388,139611,172435,172576,137531,172595,40249,172217,172724,40592,40597,40606,40610,19764,40618,40623,148324,40641,15200,14821,15645,20274,14270,166955,40706,40712,19350,37924,159138,40727,40726,40761,22175,22154,40773,39352,168075,38898,33919,40802,40809,31452,40846,29206,19390,149877,149947,29047,150008,148296,150097,29598,166874,137466,31135,166270,167478,37737,37875,166468,37612,37761,37835,166252,148665,29207,16107,30578,31299,28880,148595,148472,29054,137199,28835,137406,144793,16071,137349,152623,137208,14114,136955,137273,14049,137076,137425,155467,14115,136896,22363,150053,136190,135848,136134,136374,34051,145062,34051,33877,149908,160101,146993,152924,147195,159826,17652,145134,170397,159526,26617,14131,15381,15847,22636,137506,26640,16471,145215,147681,147595,147727,158753,21707,22174,157361,22162,135135,134056,134669,37830,166675,37788,20216,20779,14361,148534,20156,132197,131967,20299,20362,153169,23144,131499,132043,14745,131850,132116,13365,20265,131776,167603,131701,35546,131596,20120,20685,20749,20386,20227,150030,147082,20290,20526,20588,20609,20428,20453,20568,20732,20825,20827,20829,20830,28278,144789,147001,147135,28018,137348,147081,20904,20931,132576,17629,132259,132242,132241,36218,166556,132878,21081,21156,133235,21217,37742,18042,29068,148364,134176,149932,135396,27089,134685,29817,16094,29849,29716,29782,29592,19342,150204,147597,21456,13700,29199,147657,21940,131909,21709,134086,22301,37469,38644,37734,22493,22413,22399,13886,22731,23193,166470,136954,137071,136976,23084,22968,37519,23166,23247,23058,153926,137715,137313,148117,14069,27909,29763,23073,155267,23169,166871,132115,37856,29836,135939,28933,18802,37896,166395,37821,14240,23582,23710,24158,24136,137622,137596,146158,24269,23375,137475,137476,14081,137376,14045,136958,14035,33066,166471,138682,144498,166312,24332,24334,137511,137131,23147,137019,23364,34324,161277,34912,24702,141408,140843,24539,16056,140719,140734,168072,159603,25024,131134,131142,140827,24985,24984,24693,142491,142599,149204,168269,25713,149093,142186,14889,142114,144464,170218,142968,25399,173147,25782,25393,25553,149987,142695,25252,142497,25659,25963,26994,15348,143502,144045,149897,144043,21773,144096,137433,169023,26318,144009,143795,15072,16784,152964,166690,152975,136956,152923,152613,30958,143619,137258,143924,13412,143887,143746,148169,26254,159012,26219,19347,26160,161904,138731,26211,144082,144097,26142,153714,14545,145466,145340,15257,145314,144382,29904,15254,26511,149034,26806,26654,15300,27326,14435,145365,148615,27187,27218,27337,27397,137490,25873,26776,27212,15319,27258,27479,147392,146586,37792,37618,166890,166603,37513,163870,166364,37991,28069,28427,149996,28007,147327,15759,28164,147516,23101,28170,22599,27940,30786,28987,148250,148086,28913,29264,29319,29332,149391,149285,20857,150180,132587,29818,147192,144991,150090,149783,155617,16134,16049,150239,166947,147253,24743,16115,29900,29756,37767,29751,17567,159210,17745,30083,16227,150745,150790,16216,30037,30323,173510,15129,29800,166604,149931,149902,15099,15821,150094,16127,149957,149747,37370,22322,37698,166627,137316,20703,152097,152039,30584,143922,30478,30479,30587,149143,145281,14942,149744,29752,29851,16063,150202,150215,16584,150166,156078,37639,152961,30750,30861,30856,30930,29648,31065,161601,153315,16654,31131,33942,31141,27181,147194,31290,31220,16750,136934,16690,37429,31217,134476,149900,131737,146874,137070,13719,21867,13680,13994,131540,134157,31458,23129,141045,154287,154268,23053,131675,30960,23082,154566,31486,16889,31837,31853,16913,154547,155324,155302,31949,150009,137136,31886,31868,31918,27314,32220,32263,32211,32590,156257,155996,162632,32151,155266,17002,158581,133398,26582,131150,144847,22468,156690,156664,149858,32733,31527,133164,154345,154947,31500,155150,39398,34373,39523,27164,144447,14818,150007,157101,39455,157088,33920,160039,158929,17642,33079,17410,32966,33033,33090,157620,39107,158274,33378,33381,158289,33875,159143,34320,160283,23174,16767,137280,23339,137377,23268,137432,34464,195004,146831,34861,160802,23042,34926,20293,34951,35007,35046,35173,35149,153219,35156,161669,161668,166901,166873,166812,166393,16045,33955,18165,18127,14322,35389,35356,169032,24397,37419,148100,26068,28969,28868,137285,40301,35999,36073,163292,22938,30659,23024,17262,14036,36394,36519,150537,36656,36682,17140,27736,28603,140065,18587,28537,28299,137178,39913,14005,149807,37051,37015,21873,18694,37307,37892,166475,16482,166652,37927,166941,166971,34021,35371,38297,38311,38295,38294,167220,29765,16066,149759,150082,148458,16103,143909,38543,167655,167526,167525,16076,149997,150136,147438,29714,29803,16124,38721,168112,26695,18973,168083,153567,38749,37736,166281,166950,166703,156606,37562,23313,35689,18748,29689,147995,38811,38769,39224,134950,24001,166853,150194,38943,169178,37622,169431,37349,17600,166736,150119,166756,39132,166469,16128,37418,18725,33812,39227,39245,162566,15869,39323,19311,39338,39516,166757,153800,27279,39457,23294,39471,170225,19344,170312,39356,19389,19351,37757,22642,135938,22562,149944,136424,30788,141087,146872,26821,15741,37976,14631,24912,141185,141675,24839,40015,40019,40059,39989,39952,39807,39887,171565,39839,172533,172286,40225,19630,147716,40472,19632,40204,172468,172269,172275,170287,40357,33981,159250,159711,158594,34300,17715,159140,159364,159216,33824,34286,159232,145367,155748,31202,144796,144960,18733,149982,15714,37851,37566,37704,131775,30905,37495,37965,20452,13376,36964,152925,30781,30804,30902,30795,137047,143817,149825,13978,20338,28634,28633,28702,28702,21524,147893,22459,22771,22410,40214,22487,28980,13487,147884,29163,158784,151447,23336,137141,166473,24844,23246,23051,17084,148616,14124,19323,166396,37819,37816,137430,134941,33906,158912,136211,148218,142374,148417,22932,146871,157505,32168,155995,155812,149945,149899,166394,37605,29666,16105,29876,166755,137375,16097,150195,27352,29683,29691,16086,150078,150164,137177,150118,132007,136228,149989,29768,149782,28837,149878,37508,29670,37727,132350,37681,166606,166422,37766,166887,153045,18741,166530,29035,149827,134399,22180,132634,134123,134328,21762,31172,137210,32254,136898,150096,137298,17710,37889,14090,166592,149933,22960,137407,137347,160900,23201,14050,146779,14000,37471,23161,166529,137314,37748,15565,133812,19094,14730,20724,15721,15692,136092,29045,17147,164376,28175,168164,17643,27991,163407,28775,27823,15574,147437,146989,28162,28428,15727,132085,30033,14012,13512,18048,16090,18545,22980,37486,18750,36673,166940,158656,22546,22472,14038,136274,28926,148322,150129,143331,135856,140221,26809,26983,136088,144613,162804,145119,166531,145366,144378,150687,27162,145069,158903,33854,17631,17614,159014,159057,158850,159710,28439,160009,33597,137018,33773,158848,159827,137179,22921,23170,137139,23137,23153,137477,147964,14125,23023,137020,14023,29070,37776,26266,148133,23150,23083,148115,27179,147193,161590,148571,148170,28957,148057,166369,20400,159016,23746,148686,163405,148413,27148,148054,135940,28838,28979,148457,15781,27871,194597,150095,32357,23019,23855,15859,24412,150109,137183,32164,33830,21637,146170,144128,131604,22398,133333,132633,16357,139166,172726,28675,168283,23920,29583,31955,166489,168992,20424,32743,29389,29456,162548,29496,29497,153334,29505,29512,16041,162584,36972,29173,149746,29665,33270,16074,30476,16081,27810,22269,29721,29726,29727,16098,16112,16116,16122,29907,16142,16211,30018,30061,30066,30093,16252,30152,30172,16320,30285,16343,30324,16348,30330,151388,29064,22051,35200,22633,16413,30531,16441,26465,16453,13787,30616,16490,16495,23646,30654,30667,22770,30744,28857,30748,16552,30777,30791,30801,30822,33864,152885,31027,26627,31026,16643,16649,31121,31129,36795,31238,36796,16743,31377,16818,31420,33401,16836,31439,31451,16847,20001,31586,31596,31611,31762,31771,16992,17018,31867,31900,17036,31928,17044,31981,36755,28864,134351,32207,32212,32208,32253,32686,32692,29343,17303,32800,32805,31545,32814,32817,32852,15820,22452,28832,32951,33001,17389,33036,29482,33038,33042,30048,33044,17409,15161,33110,33113,33114,17427,22586,33148,33156,17445,33171,17453,33189,22511,33217,33252,33364,17551,33446,33398,33482,33496,33535,17584,33623,38505,27018,33797,28917,33892,24803,33928,17668,33982,34017,34040,34064,34104,34130,17723,34159,34160,34272,17783,34418,34450,34482,34543,38469,34699,17926,17943,34990,35071,35108,35143,35217,162151,35369,35384,35476,35508,35921,36052,36082,36124,18328,22623,36291,18413,20206,36410,21976,22356,36465,22005,36528,18487,36558,36578,36580,36589,36594,36791,36801,36810,36812,36915,39364,18605,39136,37395,18718,37416,37464,37483,37553,37550,37567,37603,37611,37619,37620,37629,37699,37764,37805,18757,18769,40639,37911,21249,37917,37933,37950,18794,37972,38009,38189,38306,18855,38388,38451,18917,26528,18980,38720,18997,38834,38850,22100,19172,24808,39097,19225,39153,22596,39182,39193,20916,39196,39223,39234,39261,39266,19312,39365,19357,39484,39695,31363,39785,39809,39901,39921,39924,19565,39968,14191,138178,40265,39994,40702,22096,40339,40381,40384,40444,38134,36790,40571,40620,40625,40637,40646,38108,40674,40689,40696,31432,40772,131220,131767,132000,26906,38083,22956,132311,22592,38081,14265,132565,132629,132726,136890,22359,29043,133826,133837,134079,21610,194619,134091,21662,134139,134203,134227,134245,134268,24807,134285,22138,134325,134365,134381,134511,134578,134600,26965,39983,34725,134660,134670,134871,135056,134957,134771,23584,135100,24075,135260,135247,135286,26398,135291,135304,135318,13895,135359,135379,135471,135483,21348,33965,135907,136053,135990,35713,136567,136729,137155,137159,20088,28859,137261,137578,137773,137797,138282,138352,138412,138952,25283,138965,139029,29080,26709,139333,27113,14024,139900,140247,140282,141098,141425,141647,33533,141671,141715,142037,35237,142056,36768,142094,38840,142143,38983,39613,142412,null,142472,142519,154600,142600,142610,142775,142741,142914,143220,143308,143411,143462,144159,144350,24497,26184,26303,162425,144743,144883,29185,149946,30679,144922,145174,32391,131910,22709,26382,26904,146087,161367,155618,146961,147129,161278,139418,18640,19128,147737,166554,148206,148237,147515,148276,148374,150085,132554,20946,132625,22943,138920,15294,146687,148484,148694,22408,149108,14747,149295,165352,170441,14178,139715,35678,166734,39382,149522,149755,150037,29193,150208,134264,22885,151205,151430,132985,36570,151596,21135,22335,29041,152217,152601,147274,150183,21948,152646,152686,158546,37332,13427,152895,161330,152926,18200,152930,152934,153543,149823,153693,20582,13563,144332,24798,153859,18300,166216,154286,154505,154630,138640,22433,29009,28598,155906,162834,36950,156082,151450,35682,156674,156746,23899,158711,36662,156804,137500,35562,150006,156808,147439,156946,19392,157119,157365,141083,37989,153569,24981,23079,194765,20411,22201,148769,157436,20074,149812,38486,28047,158909,13848,35191,157593,157806,156689,157790,29151,157895,31554,168128,133649,157990,37124,158009,31301,40432,158202,39462,158253,13919,156777,131105,31107,158260,158555,23852,144665,33743,158621,18128,158884,30011,34917,159150,22710,14108,140685,159819,160205,15444,160384,160389,37505,139642,160395,37680,160486,149968,27705,38047,160848,134904,34855,35061,141606,164979,137137,28344,150058,137248,14756,14009,23568,31203,17727,26294,171181,170148,35139,161740,161880,22230,16607,136714,14753,145199,164072,136133,29101,33638,162269,168360,23143,19639,159919,166315,162301,162314,162571,163174,147834,31555,31102,163849,28597,172767,27139,164632,21410,159239,37823,26678,38749,164207,163875,158133,136173,143919,163912,23941,166960,163971,22293,38947,166217,23979,149896,26046,27093,21458,150181,147329,15377,26422,163984,164084,164142,139169,164175,164233,164271,164378,164614,164655,164746,13770,164968,165546,18682,25574,166230,30728,37461,166328,17394,166375,17375,166376,166726,166868,23032,166921,36619,167877,168172,31569,168208,168252,15863,168286,150218,36816,29327,22155,169191,169449,169392,169400,169778,170193,170313,170346,170435,170536,170766,171354,171419,32415,171768,171811,19620,38215,172691,29090,172799,19857,36882,173515,19868,134300,36798,21953,36794,140464,36793,150163,17673,32383,28502,27313,20202,13540,166700,161949,14138,36480,137205,163876,166764,166809,162366,157359,15851,161365,146615,153141,153942,20122,155265,156248,22207,134765,36366,23405,147080,150686,25566,25296,137206,137339,25904,22061,154698,21530,152337,15814,171416,19581,22050,22046,32585,155352,22901,146752,34672,19996,135146,134473,145082,33047,40286,36120,30267,40005,30286,30649,37701,21554,33096,33527,22053,33074,33816,32957,21994,31074,22083,21526,134813,13774,22021,22001,26353,164578,13869,30004,22000,21946,21655,21874,134209,134294,24272,151880,134774,142434,134818,40619,32090,21982,135285,25245,38765,21652,36045,29174,37238,25596,25529,25598,21865,142147,40050,143027,20890,13535,134567,20903,21581,21790,21779,30310,36397,157834,30129,32950,34820,34694,35015,33206,33820,135361,17644,29444,149254,23440,33547,157843,22139,141044,163119,147875,163187,159440,160438,37232,135641,37384,146684,173737,134828,134905,29286,138402,18254,151490,163833,135147,16634,40029,25887,142752,18675,149472,171388,135148,134666,24674,161187,135149,null,155720,135559,29091,32398,40272,19994,19972,13687,23309,27826,21351,13996,14812,21373,13989,149016,22682,150382,33325,21579,22442,154261,133497,null,14930,140389,29556,171692,19721,39917,146686,171824,19547,151465,169374,171998,33884,146870,160434,157619,145184,25390,32037,147191,146988,14890,36872,21196,15988,13946,17897,132238,30272,23280,134838,30842,163630,22695,16575,22140,39819,23924,30292,173108,40581,19681,30201,14331,24857,143578,148466,null,22109,135849,22439,149859,171526,21044,159918,13741,27722,40316,31830,39737,22494,137068,23635,25811,169168,156469,160100,34477,134440,159010,150242,134513,null,20990,139023,23950,38659,138705,40577,36940,31519,39682,23761,31651,25192,25397,39679,31695,39722,31870,39726,31810,31878,39957,31740,39689,40727,39963,149822,40794,21875,23491,20477,40600,20466,21088,15878,21201,22375,20566,22967,24082,38856,40363,36700,21609,38836,39232,38842,21292,24880,26924,21466,39946,40194,19515,38465,27008,20646,30022,137069,39386,21107,null,37209,38529,37212,null,37201,167575,25471,159011,27338,22033,37262,30074,25221,132092,29519,31856,154657,146685,null,149785,30422,39837,20010,134356,33726,34882,null,23626,27072,20717,22394,21023,24053,20174,27697,131570,20281,21660,21722,21146,36226,13822,24332,13811,null,27474,37244,40869,39831,38958,39092,39610,40616,40580,29050,31508,null,27642,34840,32632,null,22048,173642,36471,40787,null,36308,36431,40476,36353,25218,164733,36392,36469,31443,150135,31294,30936,27882,35431,30215,166490,40742,27854,34774,30147,172722,30803,194624,36108,29410,29553,35629,29442,29937,36075,150203,34351,24506,34976,17591,null,137275,159237,null,35454,140571,null,24829,30311,39639,40260,37742,39823,34805,null,34831,36087,29484,38689,39856,13782,29362,19463,31825,39242,155993,24921,19460,40598,24957,null,22367,24943,25254,25145,25294,14940,25058,21418,144373,25444,26626,13778,23895,166850,36826,167481,null,20697,138566,30982,21298,38456,134971,16485,null,30718,null,31938,155418,31962,31277,32870,32867,32077,29957,29938,35220,33306,26380,32866,160902,32859,29936,33027,30500,35209,157644,30035,159441,34729,34766,33224,34700,35401,36013,35651,30507,29944,34010,13877,27058,36262,null,35241,29800,28089,34753,147473,29927,15835,29046,24740,24988,15569,29026,24695,null,32625,166701,29264,24809,19326,21024,15384,146631,155351,161366,152881,137540,135934,170243,159196,159917,23745,156077,166415,145015,131310,157766,151310,17762,23327,156492,40784,40614,156267,12288,65292,12289,12290,65294,8231,65307,65306,65311,65281,65072,8230,8229,65104,65105,65106,183,65108,65109,65110,65111,65372,8211,65073,8212,65075,9588,65076,65103,65288,65289,65077,65078,65371,65373,65079,65080,12308,12309,65081,65082,12304,12305,65083,65084,12298,12299,65085,65086,12296,12297,65087,65088,12300,12301,65089,65090,12302,12303,65091,65092,65113,65114,65115,65116,65117,65118,8216,8217,8220,8221,12317,12318,8245,8242,65283,65286,65290,8251,167,12291,9675,9679,9651,9650,9678,9734,9733,9671,9670,9633,9632,9661,9660,12963,8453,175,65507,65343,717,65097,65098,65101,65102,65099,65100,65119,65120,65121,65291,65293,215,247,177,8730,65308,65310,65309,8806,8807,8800,8734,8786,8801,65122,65123,65124,65125,65126,65374,8745,8746,8869,8736,8735,8895,13266,13265,8747,8750,8757,8756,9792,9794,8853,8857,8593,8595,8592,8594,8598,8599,8601,8600,8741,8739,65295,65340,8725,65128,65284,65509,12306,65504,65505,65285,65312,8451,8457,65129,65130,65131,13269,13212,13213,13214,13262,13217,13198,13199,13252,176,20825,20827,20830,20829,20833,20835,21991,29929,31950,9601,9602,9603,9604,9605,9606,9607,9608,9615,9614,9613,9612,9611,9610,9609,9532,9524,9516,9508,9500,9620,9472,9474,9621,9484,9488,9492,9496,9581,9582,9584,9583,9552,9566,9578,9569,9698,9699,9701,9700,9585,9586,9587,65296,65297,65298,65299,65300,65301,65302,65303,65304,65305,8544,8545,8546,8547,8548,8549,8550,8551,8552,8553,12321,12322,12323,12324,12325,12326,12327,12328,12329,21313,21316,21317,65313,65314,65315,65316,65317,65318,65319,65320,65321,65322,65323,65324,65325,65326,65327,65328,65329,65330,65331,65332,65333,65334,65335,65336,65337,65338,65345,65346,65347,65348,65349,65350,65351,65352,65353,65354,65355,65356,65357,65358,65359,65360,65361,65362,65363,65364,65365,65366,65367,65368,65369,65370,913,914,915,916,917,918,919,920,921,922,923,924,925,926,927,928,929,931,932,933,934,935,936,937,945,946,947,948,949,950,951,952,953,954,955,956,957,958,959,960,961,963,964,965,966,967,968,969,12549,12550,12551,12552,12553,12554,12555,12556,12557,12558,12559,12560,12561,12562,12563,12564,12565,12566,12567,12568,12569,12570,12571,12572,12573,12574,12575,12576,12577,12578,12579,12580,12581,12582,12583,12584,12585,729,713,714,711,715,9216,9217,9218,9219,9220,9221,9222,9223,9224,9225,9226,9227,9228,9229,9230,9231,9232,9233,9234,9235,9236,9237,9238,9239,9240,9241,9242,9243,9244,9245,9246,9247,9249,8364,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,19968,20057,19969,19971,20035,20061,20102,20108,20154,20799,20837,20843,20960,20992,20993,21147,21269,21313,21340,21448,19977,19979,19976,19978,20011,20024,20961,20037,20040,20063,20062,20110,20129,20800,20995,21242,21315,21449,21475,22303,22763,22805,22823,22899,23376,23377,23379,23544,23567,23586,23608,23665,24029,24037,24049,24050,24051,24062,24178,24318,24331,24339,25165,19985,19984,19981,20013,20016,20025,20043,23609,20104,20113,20117,20114,20116,20130,20161,20160,20163,20166,20167,20173,20170,20171,20164,20803,20801,20839,20845,20846,20844,20887,20982,20998,20999,21000,21243,21246,21247,21270,21305,21320,21319,21317,21342,21380,21451,21450,21453,22764,22825,22827,22826,22829,23380,23569,23588,23610,23663,24052,24187,24319,24340,24341,24515,25096,25142,25163,25166,25903,25991,26007,26020,26041,26085,26352,26376,26408,27424,27490,27513,27595,27604,27611,27663,27700,28779,29226,29238,29243,29255,29273,29275,29356,29579,19993,19990,19989,19988,19992,20027,20045,20047,20046,20197,20184,20180,20181,20182,20183,20195,20196,20185,20190,20805,20804,20873,20874,20908,20985,20986,20984,21002,21152,21151,21253,21254,21271,21277,20191,21322,21321,21345,21344,21359,21358,21435,21487,21476,21491,21484,21486,21481,21480,21500,21496,21493,21483,21478,21482,21490,21489,21488,21477,21485,21499,22235,22234,22806,22830,22833,22900,22902,23381,23427,23612,24040,24039,24038,24066,24067,24179,24188,24321,24344,24343,24517,25098,25171,25172,25170,25169,26021,26086,26414,26412,26410,26411,26413,27491,27597,27665,27664,27704,27713,27712,27710,29359,29572,29577,29916,29926,29976,29983,29992,29993,30000,30001,30002,30003,30091,30333,30382,30399,30446,30683,30690,30707,31034,31166,31348,31435,19998,19999,20050,20051,20073,20121,20132,20134,20133,20223,20233,20249,20234,20245,20237,20240,20241,20239,20210,20214,20219,20208,20211,20221,20225,20235,20809,20807,20806,20808,20840,20849,20877,20912,21015,21009,21010,21006,21014,21155,21256,21281,21280,21360,21361,21513,21519,21516,21514,21520,21505,21515,21508,21521,21517,21512,21507,21518,21510,21522,22240,22238,22237,22323,22320,22312,22317,22316,22319,22313,22809,22810,22839,22840,22916,22904,22915,22909,22905,22914,22913,23383,23384,23431,23432,23429,23433,23546,23574,23673,24030,24070,24182,24180,24335,24347,24537,24534,25102,25100,25101,25104,25187,25179,25176,25910,26089,26088,26092,26093,26354,26355,26377,26429,26420,26417,26421,27425,27492,27515,27670,27741,27735,27737,27743,27744,27728,27733,27745,27739,27725,27726,28784,29279,29277,30334,31481,31859,31992,32566,32650,32701,32769,32771,32780,32786,32819,32895,32905,32907,32908,33251,33258,33267,33276,33292,33307,33311,33390,33394,33406,34411,34880,34892,34915,35199,38433,20018,20136,20301,20303,20295,20311,20318,20276,20315,20309,20272,20304,20305,20285,20282,20280,20291,20308,20284,20294,20323,20316,20320,20271,20302,20278,20313,20317,20296,20314,20812,20811,20813,20853,20918,20919,21029,21028,21033,21034,21032,21163,21161,21162,21164,21283,21363,21365,21533,21549,21534,21566,21542,21582,21543,21574,21571,21555,21576,21570,21531,21545,21578,21561,21563,21560,21550,21557,21558,21536,21564,21568,21553,21547,21535,21548,22250,22256,22244,22251,22346,22353,22336,22349,22343,22350,22334,22352,22351,22331,22767,22846,22941,22930,22952,22942,22947,22937,22934,22925,22948,22931,22922,22949,23389,23388,23386,23387,23436,23435,23439,23596,23616,23617,23615,23614,23696,23697,23700,23692,24043,24076,24207,24199,24202,24311,24324,24351,24420,24418,24439,24441,24536,24524,24535,24525,24561,24555,24568,24554,25106,25105,25220,25239,25238,25216,25206,25225,25197,25226,25212,25214,25209,25203,25234,25199,25240,25198,25237,25235,25233,25222,25913,25915,25912,26097,26356,26463,26446,26447,26448,26449,26460,26454,26462,26441,26438,26464,26451,26455,27493,27599,27714,27742,27801,27777,27784,27785,27781,27803,27754,27770,27792,27760,27788,27752,27798,27794,27773,27779,27762,27774,27764,27782,27766,27789,27796,27800,27778,28790,28796,28797,28792,29282,29281,29280,29380,29378,29590,29996,29995,30007,30008,30338,30447,30691,31169,31168,31167,31350,31995,32597,32918,32915,32925,32920,32923,32922,32946,33391,33426,33419,33421,35211,35282,35328,35895,35910,35925,35997,36196,36208,36275,36523,36554,36763,36784,36802,36806,36805,36804,24033,37009,37026,37034,37030,37027,37193,37318,37324,38450,38446,38449,38442,38444,20006,20054,20083,20107,20123,20126,20139,20140,20335,20381,20365,20339,20351,20332,20379,20363,20358,20355,20336,20341,20360,20329,20347,20374,20350,20367,20369,20346,20820,20818,20821,20841,20855,20854,20856,20925,20989,21051,21048,21047,21050,21040,21038,21046,21057,21182,21179,21330,21332,21331,21329,21350,21367,21368,21369,21462,21460,21463,21619,21621,21654,21624,21653,21632,21627,21623,21636,21650,21638,21628,21648,21617,21622,21644,21658,21602,21608,21643,21629,21646,22266,22403,22391,22378,22377,22369,22374,22372,22396,22812,22857,22855,22856,22852,22868,22974,22971,22996,22969,22958,22993,22982,22992,22989,22987,22995,22986,22959,22963,22994,22981,23391,23396,23395,23447,23450,23448,23452,23449,23451,23578,23624,23621,23622,23735,23713,23736,23721,23723,23729,23731,24088,24090,24086,24085,24091,24081,24184,24218,24215,24220,24213,24214,24310,24358,24359,24361,24448,24449,24447,24444,24541,24544,24573,24565,24575,24591,24596,24623,24629,24598,24618,24597,24609,24615,24617,24619,24603,25110,25109,25151,25150,25152,25215,25289,25292,25284,25279,25282,25273,25298,25307,25259,25299,25300,25291,25288,25256,25277,25276,25296,25305,25287,25293,25269,25306,25265,25304,25302,25303,25286,25260,25294,25918,26023,26044,26106,26132,26131,26124,26118,26114,26126,26112,26127,26133,26122,26119,26381,26379,26477,26507,26517,26481,26524,26483,26487,26503,26525,26519,26479,26480,26495,26505,26494,26512,26485,26522,26515,26492,26474,26482,27427,27494,27495,27519,27667,27675,27875,27880,27891,27825,27852,27877,27827,27837,27838,27836,27874,27819,27861,27859,27832,27844,27833,27841,27822,27863,27845,27889,27839,27835,27873,27867,27850,27820,27887,27868,27862,27872,28821,28814,28818,28810,28825,29228,29229,29240,29256,29287,29289,29376,29390,29401,29399,29392,29609,29608,29599,29611,29605,30013,30109,30105,30106,30340,30402,30450,30452,30693,30717,31038,31040,31041,31177,31176,31354,31353,31482,31998,32596,32652,32651,32773,32954,32933,32930,32945,32929,32939,32937,32948,32938,32943,33253,33278,33293,33459,33437,33433,33453,33469,33439,33465,33457,33452,33445,33455,33464,33443,33456,33470,33463,34382,34417,21021,34920,36555,36814,36820,36817,37045,37048,37041,37046,37319,37329,38263,38272,38428,38464,38463,38459,38468,38466,38585,38632,38738,38750,20127,20141,20142,20449,20405,20399,20415,20448,20433,20431,20445,20419,20406,20440,20447,20426,20439,20398,20432,20420,20418,20442,20430,20446,20407,20823,20882,20881,20896,21070,21059,21066,21069,21068,21067,21063,21191,21193,21187,21185,21261,21335,21371,21402,21467,21676,21696,21672,21710,21705,21688,21670,21683,21703,21698,21693,21674,21697,21700,21704,21679,21675,21681,21691,21673,21671,21695,22271,22402,22411,22432,22435,22434,22478,22446,22419,22869,22865,22863,22862,22864,23004,23000,23039,23011,23016,23043,23013,23018,23002,23014,23041,23035,23401,23459,23462,23460,23458,23461,23553,23630,23631,23629,23627,23769,23762,24055,24093,24101,24095,24189,24224,24230,24314,24328,24365,24421,24456,24453,24458,24459,24455,24460,24457,24594,24605,24608,24613,24590,24616,24653,24688,24680,24674,24646,24643,24684,24683,24682,24676,25153,25308,25366,25353,25340,25325,25345,25326,25341,25351,25329,25335,25327,25324,25342,25332,25361,25346,25919,25925,26027,26045,26082,26149,26157,26144,26151,26159,26143,26152,26161,26148,26359,26623,26579,26609,26580,26576,26604,26550,26543,26613,26601,26607,26564,26577,26548,26586,26597,26552,26575,26590,26611,26544,26585,26594,26589,26578,27498,27523,27526,27573,27602,27607,27679,27849,27915,27954,27946,27969,27941,27916,27953,27934,27927,27963,27965,27966,27958,27931,27893,27961,27943,27960,27945,27950,27957,27918,27947,28843,28858,28851,28844,28847,28845,28856,28846,28836,29232,29298,29295,29300,29417,29408,29409,29623,29642,29627,29618,29645,29632,29619,29978,29997,30031,30028,30030,30027,30123,30116,30117,30114,30115,30328,30342,30343,30344,30408,30406,30403,30405,30465,30457,30456,30473,30475,30462,30460,30471,30684,30722,30740,30732,30733,31046,31049,31048,31047,31161,31162,31185,31186,31179,31359,31361,31487,31485,31869,32002,32005,32000,32009,32007,32004,32006,32568,32654,32703,32772,32784,32781,32785,32822,32982,32997,32986,32963,32964,32972,32993,32987,32974,32990,32996,32989,33268,33314,33511,33539,33541,33507,33499,33510,33540,33509,33538,33545,33490,33495,33521,33537,33500,33492,33489,33502,33491,33503,33519,33542,34384,34425,34427,34426,34893,34923,35201,35284,35336,35330,35331,35998,36000,36212,36211,36276,36557,36556,36848,36838,36834,36842,36837,36845,36843,36836,36840,37066,37070,37057,37059,37195,37194,37325,38274,38480,38475,38476,38477,38754,38761,38859,38893,38899,38913,39080,39131,39135,39318,39321,20056,20147,20492,20493,20515,20463,20518,20517,20472,20521,20502,20486,20540,20511,20506,20498,20497,20474,20480,20500,20520,20465,20513,20491,20505,20504,20467,20462,20525,20522,20478,20523,20489,20860,20900,20901,20898,20941,20940,20934,20939,21078,21084,21076,21083,21085,21290,21375,21407,21405,21471,21736,21776,21761,21815,21756,21733,21746,21766,21754,21780,21737,21741,21729,21769,21742,21738,21734,21799,21767,21757,21775,22275,22276,22466,22484,22475,22467,22537,22799,22871,22872,22874,23057,23064,23068,23071,23067,23059,23020,23072,23075,23081,23077,23052,23049,23403,23640,23472,23475,23478,23476,23470,23477,23481,23480,23556,23633,23637,23632,23789,23805,23803,23786,23784,23792,23798,23809,23796,24046,24109,24107,24235,24237,24231,24369,24466,24465,24464,24665,24675,24677,24656,24661,24685,24681,24687,24708,24735,24730,24717,24724,24716,24709,24726,25159,25331,25352,25343,25422,25406,25391,25429,25410,25414,25423,25417,25402,25424,25405,25386,25387,25384,25421,25420,25928,25929,26009,26049,26053,26178,26185,26191,26179,26194,26188,26181,26177,26360,26388,26389,26391,26657,26680,26696,26694,26707,26681,26690,26708,26665,26803,26647,26700,26705,26685,26612,26704,26688,26684,26691,26666,26693,26643,26648,26689,27530,27529,27575,27683,27687,27688,27686,27684,27888,28010,28053,28040,28039,28006,28024,28023,27993,28051,28012,28041,28014,27994,28020,28009,28044,28042,28025,28037,28005,28052,28874,28888,28900,28889,28872,28879,29241,29305,29436,29433,29437,29432,29431,29574,29677,29705,29678,29664,29674,29662,30036,30045,30044,30042,30041,30142,30149,30151,30130,30131,30141,30140,30137,30146,30136,30347,30384,30410,30413,30414,30505,30495,30496,30504,30697,30768,30759,30776,30749,30772,30775,30757,30765,30752,30751,30770,31061,31056,31072,31071,31062,31070,31069,31063,31066,31204,31203,31207,31199,31206,31209,31192,31364,31368,31449,31494,31505,31881,32033,32023,32011,32010,32032,32034,32020,32016,32021,32026,32028,32013,32025,32027,32570,32607,32660,32709,32705,32774,32792,32789,32793,32791,32829,32831,33009,33026,33008,33029,33005,33012,33030,33016,33011,33032,33021,33034,33020,33007,33261,33260,33280,33296,33322,33323,33320,33324,33467,33579,33618,33620,33610,33592,33616,33609,33589,33588,33615,33586,33593,33590,33559,33600,33585,33576,33603,34388,34442,34474,34451,34468,34473,34444,34467,34460,34928,34935,34945,34946,34941,34937,35352,35344,35342,35340,35349,35338,35351,35347,35350,35343,35345,35912,35962,35961,36001,36002,36215,36524,36562,36564,36559,36785,36865,36870,36855,36864,36858,36852,36867,36861,36869,36856,37013,37089,37085,37090,37202,37197,37196,37336,37341,37335,37340,37337,38275,38498,38499,38497,38491,38493,38500,38488,38494,38587,39138,39340,39592,39640,39717,39730,39740,20094,20602,20605,20572,20551,20547,20556,20570,20553,20581,20598,20558,20565,20597,20596,20599,20559,20495,20591,20589,20828,20885,20976,21098,21103,21202,21209,21208,21205,21264,21263,21273,21311,21312,21310,21443,26364,21830,21866,21862,21828,21854,21857,21827,21834,21809,21846,21839,21845,21807,21860,21816,21806,21852,21804,21859,21811,21825,21847,22280,22283,22281,22495,22533,22538,22534,22496,22500,22522,22530,22581,22519,22521,22816,22882,23094,23105,23113,23142,23146,23104,23100,23138,23130,23110,23114,23408,23495,23493,23492,23490,23487,23494,23561,23560,23559,23648,23644,23645,23815,23814,23822,23835,23830,23842,23825,23849,23828,23833,23844,23847,23831,24034,24120,24118,24115,24119,24247,24248,24246,24245,24254,24373,24375,24407,24428,24425,24427,24471,24473,24478,24472,24481,24480,24476,24703,24739,24713,24736,24744,24779,24756,24806,24765,24773,24763,24757,24796,24764,24792,24789,24774,24799,24760,24794,24775,25114,25115,25160,25504,25511,25458,25494,25506,25509,25463,25447,25496,25514,25457,25513,25481,25475,25499,25451,25512,25476,25480,25497,25505,25516,25490,25487,25472,25467,25449,25448,25466,25949,25942,25937,25945,25943,21855,25935,25944,25941,25940,26012,26011,26028,26063,26059,26060,26062,26205,26202,26212,26216,26214,26206,26361,21207,26395,26753,26799,26786,26771,26805,26751,26742,26801,26791,26775,26800,26755,26820,26797,26758,26757,26772,26781,26792,26783,26785,26754,27442,27578,27627,27628,27691,28046,28092,28147,28121,28082,28129,28108,28132,28155,28154,28165,28103,28107,28079,28113,28078,28126,28153,28088,28151,28149,28101,28114,28186,28085,28122,28139,28120,28138,28145,28142,28136,28102,28100,28074,28140,28095,28134,28921,28937,28938,28925,28911,29245,29309,29313,29468,29467,29462,29459,29465,29575,29701,29706,29699,29702,29694,29709,29920,29942,29943,29980,29986,30053,30054,30050,30064,30095,30164,30165,30133,30154,30157,30350,30420,30418,30427,30519,30526,30524,30518,30520,30522,30827,30787,30798,31077,31080,31085,31227,31378,31381,31520,31528,31515,31532,31526,31513,31518,31534,31890,31895,31893,32070,32067,32113,32046,32057,32060,32064,32048,32051,32068,32047,32066,32050,32049,32573,32670,32666,32716,32718,32722,32796,32842,32838,33071,33046,33059,33067,33065,33072,33060,33282,33333,33335,33334,33337,33678,33694,33688,33656,33698,33686,33725,33707,33682,33674,33683,33673,33696,33655,33659,33660,33670,33703,34389,24426,34503,34496,34486,34500,34485,34502,34507,34481,34479,34505,34899,34974,34952,34987,34962,34966,34957,34955,35219,35215,35370,35357,35363,35365,35377,35373,35359,35355,35362,35913,35930,36009,36012,36011,36008,36010,36007,36199,36198,36286,36282,36571,36575,36889,36877,36890,36887,36899,36895,36893,36880,36885,36894,36896,36879,36898,36886,36891,36884,37096,37101,37117,37207,37326,37365,37350,37347,37351,37357,37353,38281,38506,38517,38515,38520,38512,38516,38518,38519,38508,38592,38634,38633,31456,31455,38914,38915,39770,40165,40565,40575,40613,40635,20642,20621,20613,20633,20625,20608,20630,20632,20634,26368,20977,21106,21108,21109,21097,21214,21213,21211,21338,21413,21883,21888,21927,21884,21898,21917,21912,21890,21916,21930,21908,21895,21899,21891,21939,21934,21919,21822,21938,21914,21947,21932,21937,21886,21897,21931,21913,22285,22575,22570,22580,22564,22576,22577,22561,22557,22560,22777,22778,22880,23159,23194,23167,23186,23195,23207,23411,23409,23506,23500,23507,23504,23562,23563,23601,23884,23888,23860,23879,24061,24133,24125,24128,24131,24190,24266,24257,24258,24260,24380,24429,24489,24490,24488,24785,24801,24754,24758,24800,24860,24867,24826,24853,24816,24827,24820,24936,24817,24846,24822,24841,24832,24850,25119,25161,25507,25484,25551,25536,25577,25545,25542,25549,25554,25571,25552,25569,25558,25581,25582,25462,25588,25578,25563,25682,25562,25593,25950,25958,25954,25955,26001,26000,26031,26222,26224,26228,26230,26223,26257,26234,26238,26231,26366,26367,26399,26397,26874,26837,26848,26840,26839,26885,26847,26869,26862,26855,26873,26834,26866,26851,26827,26829,26893,26898,26894,26825,26842,26990,26875,27454,27450,27453,27544,27542,27580,27631,27694,27695,27692,28207,28216,28244,28193,28210,28263,28234,28192,28197,28195,28187,28251,28248,28196,28246,28270,28205,28198,28271,28212,28237,28218,28204,28227,28189,28222,28363,28297,28185,28238,28259,28228,28274,28265,28255,28953,28954,28966,28976,28961,28982,29038,28956,29260,29316,29312,29494,29477,29492,29481,29754,29738,29747,29730,29733,29749,29750,29748,29743,29723,29734,29736,29989,29990,30059,30058,30178,30171,30179,30169,30168,30174,30176,30331,30332,30358,30355,30388,30428,30543,30701,30813,30828,30831,31245,31240,31243,31237,31232,31384,31383,31382,31461,31459,31561,31574,31558,31568,31570,31572,31565,31563,31567,31569,31903,31909,32094,32080,32104,32085,32043,32110,32114,32097,32102,32098,32112,32115,21892,32724,32725,32779,32850,32901,33109,33108,33099,33105,33102,33081,33094,33086,33100,33107,33140,33298,33308,33769,33795,33784,33805,33760,33733,33803,33729,33775,33777,33780,33879,33802,33776,33804,33740,33789,33778,33738,33848,33806,33796,33756,33799,33748,33759,34395,34527,34521,34541,34516,34523,34532,34512,34526,34903,35009,35010,34993,35203,35222,35387,35424,35413,35422,35388,35393,35412,35419,35408,35398,35380,35386,35382,35414,35937,35970,36015,36028,36019,36029,36033,36027,36032,36020,36023,36022,36031,36024,36234,36229,36225,36302,36317,36299,36314,36305,36300,36315,36294,36603,36600,36604,36764,36910,36917,36913,36920,36914,36918,37122,37109,37129,37118,37219,37221,37327,37396,37397,37411,37385,37406,37389,37392,37383,37393,38292,38287,38283,38289,38291,38290,38286,38538,38542,38539,38525,38533,38534,38541,38514,38532,38593,38597,38596,38598,38599,38639,38642,38860,38917,38918,38920,39143,39146,39151,39145,39154,39149,39342,39341,40643,40653,40657,20098,20653,20661,20658,20659,20677,20670,20652,20663,20667,20655,20679,21119,21111,21117,21215,21222,21220,21218,21219,21295,21983,21992,21971,21990,21966,21980,21959,21969,21987,21988,21999,21978,21985,21957,21958,21989,21961,22290,22291,22622,22609,22616,22615,22618,22612,22635,22604,22637,22602,22626,22610,22603,22887,23233,23241,23244,23230,23229,23228,23219,23234,23218,23913,23919,24140,24185,24265,24264,24338,24409,24492,24494,24858,24847,24904,24863,24819,24859,24825,24833,24840,24910,24908,24900,24909,24894,24884,24871,24845,24838,24887,25121,25122,25619,25662,25630,25642,25645,25661,25644,25615,25628,25620,25613,25654,25622,25623,25606,25964,26015,26032,26263,26249,26247,26248,26262,26244,26264,26253,26371,27028,26989,26970,26999,26976,26964,26997,26928,27010,26954,26984,26987,26974,26963,27001,27014,26973,26979,26971,27463,27506,27584,27583,27603,27645,28322,28335,28371,28342,28354,28304,28317,28359,28357,28325,28312,28348,28346,28331,28369,28310,28316,28356,28372,28330,28327,28340,29006,29017,29033,29028,29001,29031,29020,29036,29030,29004,29029,29022,28998,29032,29014,29242,29266,29495,29509,29503,29502,29807,29786,29781,29791,29790,29761,29759,29785,29787,29788,30070,30072,30208,30192,30209,30194,30193,30202,30207,30196,30195,30430,30431,30555,30571,30566,30558,30563,30585,30570,30572,30556,30565,30568,30562,30702,30862,30896,30871,30872,30860,30857,30844,30865,30867,30847,31098,31103,31105,33836,31165,31260,31258,31264,31252,31263,31262,31391,31392,31607,31680,31584,31598,31591,31921,31923,31925,32147,32121,32145,32129,32143,32091,32622,32617,32618,32626,32681,32680,32676,32854,32856,32902,32900,33137,33136,33144,33125,33134,33139,33131,33145,33146,33126,33285,33351,33922,33911,33853,33841,33909,33894,33899,33865,33900,33883,33852,33845,33889,33891,33897,33901,33862,34398,34396,34399,34553,34579,34568,34567,34560,34558,34555,34562,34563,34566,34570,34905,35039,35028,35033,35036,35032,35037,35041,35018,35029,35026,35228,35299,35435,35442,35443,35430,35433,35440,35463,35452,35427,35488,35441,35461,35437,35426,35438,35436,35449,35451,35390,35432,35938,35978,35977,36042,36039,36040,36036,36018,36035,36034,36037,36321,36319,36328,36335,36339,36346,36330,36324,36326,36530,36611,36617,36606,36618,36767,36786,36939,36938,36947,36930,36948,36924,36949,36944,36935,36943,36942,36941,36945,36926,36929,37138,37143,37228,37226,37225,37321,37431,37463,37432,37437,37440,37438,37467,37451,37476,37457,37428,37449,37453,37445,37433,37439,37466,38296,38552,38548,38549,38605,38603,38601,38602,38647,38651,38649,38646,38742,38772,38774,38928,38929,38931,38922,38930,38924,39164,39156,39165,39166,39347,39345,39348,39649,40169,40578,40718,40723,40736,20711,20718,20709,20694,20717,20698,20693,20687,20689,20721,20686,20713,20834,20979,21123,21122,21297,21421,22014,22016,22043,22039,22013,22036,22022,22025,22029,22030,22007,22038,22047,22024,22032,22006,22296,22294,22645,22654,22659,22675,22666,22649,22661,22653,22781,22821,22818,22820,22890,22889,23265,23270,23273,23255,23254,23256,23267,23413,23518,23527,23521,23525,23526,23528,23522,23524,23519,23565,23650,23940,23943,24155,24163,24149,24151,24148,24275,24278,24330,24390,24432,24505,24903,24895,24907,24951,24930,24931,24927,24922,24920,24949,25130,25735,25688,25684,25764,25720,25695,25722,25681,25703,25652,25709,25723,25970,26017,26071,26070,26274,26280,26269,27036,27048,27029,27073,27054,27091,27083,27035,27063,27067,27051,27060,27088,27085,27053,27084,27046,27075,27043,27465,27468,27699,28467,28436,28414,28435,28404,28457,28478,28448,28460,28431,28418,28450,28415,28399,28422,28465,28472,28466,28451,28437,28459,28463,28552,28458,28396,28417,28402,28364,28407,29076,29081,29053,29066,29060,29074,29246,29330,29334,29508,29520,29796,29795,29802,29808,29805,29956,30097,30247,30221,30219,30217,30227,30433,30435,30596,30589,30591,30561,30913,30879,30887,30899,30889,30883,31118,31119,31117,31278,31281,31402,31401,31469,31471,31649,31637,31627,31605,31639,31645,31636,31631,31672,31623,31620,31929,31933,31934,32187,32176,32156,32189,32190,32160,32202,32180,32178,32177,32186,32162,32191,32181,32184,32173,32210,32199,32172,32624,32736,32737,32735,32862,32858,32903,33104,33152,33167,33160,33162,33151,33154,33255,33274,33287,33300,33310,33355,33993,33983,33990,33988,33945,33950,33970,33948,33995,33976,33984,34003,33936,33980,34001,33994,34623,34588,34619,34594,34597,34612,34584,34645,34615,34601,35059,35074,35060,35065,35064,35069,35048,35098,35055,35494,35468,35486,35491,35469,35489,35475,35492,35498,35493,35496,35480,35473,35482,35495,35946,35981,35980,36051,36049,36050,36203,36249,36245,36348,36628,36626,36629,36627,36771,36960,36952,36956,36963,36953,36958,36962,36957,36955,37145,37144,37150,37237,37240,37239,37236,37496,37504,37509,37528,37526,37499,37523,37532,37544,37500,37521,38305,38312,38313,38307,38309,38308,38553,38556,38555,38604,38610,38656,38780,38789,38902,38935,38936,39087,39089,39171,39173,39180,39177,39361,39599,39600,39654,39745,39746,40180,40182,40179,40636,40763,40778,20740,20736,20731,20725,20729,20738,20744,20745,20741,20956,21127,21128,21129,21133,21130,21232,21426,22062,22075,22073,22066,22079,22068,22057,22099,22094,22103,22132,22070,22063,22064,22656,22687,22686,22707,22684,22702,22697,22694,22893,23305,23291,23307,23285,23308,23304,23534,23532,23529,23531,23652,23653,23965,23956,24162,24159,24161,24290,24282,24287,24285,24291,24288,24392,24433,24503,24501,24950,24935,24942,24925,24917,24962,24956,24944,24939,24958,24999,24976,25003,24974,25004,24986,24996,24980,25006,25134,25705,25711,25721,25758,25778,25736,25744,25776,25765,25747,25749,25769,25746,25774,25773,25771,25754,25772,25753,25762,25779,25973,25975,25976,26286,26283,26292,26289,27171,27167,27112,27137,27166,27161,27133,27169,27155,27146,27123,27138,27141,27117,27153,27472,27470,27556,27589,27590,28479,28540,28548,28497,28518,28500,28550,28525,28507,28536,28526,28558,28538,28528,28516,28567,28504,28373,28527,28512,28511,29087,29100,29105,29096,29270,29339,29518,29527,29801,29835,29827,29822,29824,30079,30240,30249,30239,30244,30246,30241,30242,30362,30394,30436,30606,30599,30604,30609,30603,30923,30917,30906,30922,30910,30933,30908,30928,31295,31292,31296,31293,31287,31291,31407,31406,31661,31665,31684,31668,31686,31687,31681,31648,31692,31946,32224,32244,32239,32251,32216,32236,32221,32232,32227,32218,32222,32233,32158,32217,32242,32249,32629,32631,32687,32745,32806,33179,33180,33181,33184,33178,33176,34071,34109,34074,34030,34092,34093,34067,34065,34083,34081,34068,34028,34085,34047,34054,34690,34676,34678,34656,34662,34680,34664,34649,34647,34636,34643,34907,34909,35088,35079,35090,35091,35093,35082,35516,35538,35527,35524,35477,35531,35576,35506,35529,35522,35519,35504,35542,35533,35510,35513,35547,35916,35918,35948,36064,36062,36070,36068,36076,36077,36066,36067,36060,36074,36065,36205,36255,36259,36395,36368,36381,36386,36367,36393,36383,36385,36382,36538,36637,36635,36639,36649,36646,36650,36636,36638,36645,36969,36974,36968,36973,36983,37168,37165,37159,37169,37255,37257,37259,37251,37573,37563,37559,37610,37548,37604,37569,37555,37564,37586,37575,37616,37554,38317,38321,38660,38662,38663,38665,38752,38797,38795,38799,38945,38955,38940,39091,39178,39187,39186,39192,39389,39376,39391,39387,39377,39381,39378,39385,39607,39662,39663,39719,39749,39748,39799,39791,40198,40201,40195,40617,40638,40654,22696,40786,20754,20760,20756,20752,20757,20864,20906,20957,21137,21139,21235,22105,22123,22137,22121,22116,22136,22122,22120,22117,22129,22127,22124,22114,22134,22721,22718,22727,22725,22894,23325,23348,23416,23536,23566,24394,25010,24977,25001,24970,25037,25014,25022,25034,25032,25136,25797,25793,25803,25787,25788,25818,25796,25799,25794,25805,25791,25810,25812,25790,25972,26310,26313,26297,26308,26311,26296,27197,27192,27194,27225,27243,27224,27193,27204,27234,27233,27211,27207,27189,27231,27208,27481,27511,27653,28610,28593,28577,28611,28580,28609,28583,28595,28608,28601,28598,28582,28576,28596,29118,29129,29136,29138,29128,29141,29113,29134,29145,29148,29123,29124,29544,29852,29859,29848,29855,29854,29922,29964,29965,30260,30264,30266,30439,30437,30624,30622,30623,30629,30952,30938,30956,30951,31142,31309,31310,31302,31308,31307,31418,31705,31761,31689,31716,31707,31713,31721,31718,31957,31958,32266,32273,32264,32283,32291,32286,32285,32265,32272,32633,32690,32752,32753,32750,32808,33203,33193,33192,33275,33288,33368,33369,34122,34137,34120,34152,34153,34115,34121,34157,34154,34142,34691,34719,34718,34722,34701,34913,35114,35122,35109,35115,35105,35242,35238,35558,35578,35563,35569,35584,35548,35559,35566,35582,35585,35586,35575,35565,35571,35574,35580,35947,35949,35987,36084,36420,36401,36404,36418,36409,36405,36667,36655,36664,36659,36776,36774,36981,36980,36984,36978,36988,36986,37172,37266,37664,37686,37624,37683,37679,37666,37628,37675,37636,37658,37648,37670,37665,37653,37678,37657,38331,38567,38568,38570,38613,38670,38673,38678,38669,38675,38671,38747,38748,38758,38808,38960,38968,38971,38967,38957,38969,38948,39184,39208,39198,39195,39201,39194,39405,39394,39409,39608,39612,39675,39661,39720,39825,40213,40227,40230,40232,40210,40219,40664,40660,40845,40860,20778,20767,20769,20786,21237,22158,22144,22160,22149,22151,22159,22741,22739,22737,22734,23344,23338,23332,23418,23607,23656,23996,23994,23997,23992,24171,24396,24509,25033,25026,25031,25062,25035,25138,25140,25806,25802,25816,25824,25840,25830,25836,25841,25826,25837,25986,25987,26329,26326,27264,27284,27268,27298,27292,27355,27299,27262,27287,27280,27296,27484,27566,27610,27656,28632,28657,28639,28640,28635,28644,28651,28655,28544,28652,28641,28649,28629,28654,28656,29159,29151,29166,29158,29157,29165,29164,29172,29152,29237,29254,29552,29554,29865,29872,29862,29864,30278,30274,30284,30442,30643,30634,30640,30636,30631,30637,30703,30967,30970,30964,30959,30977,31143,31146,31319,31423,31751,31757,31742,31735,31756,31712,31968,31964,31966,31970,31967,31961,31965,32302,32318,32326,32311,32306,32323,32299,32317,32305,32325,32321,32308,32313,32328,32309,32319,32303,32580,32755,32764,32881,32882,32880,32879,32883,33222,33219,33210,33218,33216,33215,33213,33225,33214,33256,33289,33393,34218,34180,34174,34204,34193,34196,34223,34203,34183,34216,34186,34407,34752,34769,34739,34770,34758,34731,34747,34746,34760,34763,35131,35126,35140,35128,35133,35244,35598,35607,35609,35611,35594,35616,35613,35588,35600,35905,35903,35955,36090,36093,36092,36088,36091,36264,36425,36427,36424,36426,36676,36670,36674,36677,36671,36991,36989,36996,36993,36994,36992,37177,37283,37278,37276,37709,37762,37672,37749,37706,37733,37707,37656,37758,37740,37723,37744,37722,37716,38346,38347,38348,38344,38342,38577,38584,38614,38684,38686,38816,38867,38982,39094,39221,39425,39423,39854,39851,39850,39853,40251,40255,40587,40655,40670,40668,40669,40667,40766,40779,21474,22165,22190,22745,22744,23352,24413,25059,25139,25844,25842,25854,25862,25850,25851,25847,26039,26332,26406,27315,27308,27331,27323,27320,27330,27310,27311,27487,27512,27567,28681,28683,28670,28678,28666,28689,28687,29179,29180,29182,29176,29559,29557,29863,29887,29973,30294,30296,30290,30653,30655,30651,30652,30990,31150,31329,31330,31328,31428,31429,31787,31783,31786,31774,31779,31777,31975,32340,32341,32350,32346,32353,32338,32345,32584,32761,32763,32887,32886,33229,33231,33290,34255,34217,34253,34256,34249,34224,34234,34233,34214,34799,34796,34802,34784,35206,35250,35316,35624,35641,35628,35627,35920,36101,36441,36451,36454,36452,36447,36437,36544,36681,36685,36999,36995,37000,37291,37292,37328,37780,37770,37782,37794,37811,37806,37804,37808,37784,37786,37783,38356,38358,38352,38357,38626,38620,38617,38619,38622,38692,38819,38822,38829,38905,38989,38991,38988,38990,38995,39098,39230,39231,39229,39214,39333,39438,39617,39683,39686,39759,39758,39757,39882,39881,39933,39880,39872,40273,40285,40288,40672,40725,40748,20787,22181,22750,22751,22754,23541,40848,24300,25074,25079,25078,25077,25856,25871,26336,26333,27365,27357,27354,27347,28699,28703,28712,28698,28701,28693,28696,29190,29197,29272,29346,29560,29562,29885,29898,29923,30087,30086,30303,30305,30663,31001,31153,31339,31337,31806,31807,31800,31805,31799,31808,32363,32365,32377,32361,32362,32645,32371,32694,32697,32696,33240,34281,34269,34282,34261,34276,34277,34295,34811,34821,34829,34809,34814,35168,35167,35158,35166,35649,35676,35672,35657,35674,35662,35663,35654,35673,36104,36106,36476,36466,36487,36470,36460,36474,36468,36692,36686,36781,37002,37003,37297,37294,37857,37841,37855,37827,37832,37852,37853,37846,37858,37837,37848,37860,37847,37864,38364,38580,38627,38698,38695,38753,38876,38907,39006,39000,39003,39100,39237,39241,39446,39449,39693,39912,39911,39894,39899,40329,40289,40306,40298,40300,40594,40599,40595,40628,21240,22184,22199,22198,22196,22204,22756,23360,23363,23421,23542,24009,25080,25082,25880,25876,25881,26342,26407,27372,28734,28720,28722,29200,29563,29903,30306,30309,31014,31018,31020,31019,31431,31478,31820,31811,31821,31983,31984,36782,32381,32380,32386,32588,32768,33242,33382,34299,34297,34321,34298,34310,34315,34311,34314,34836,34837,35172,35258,35320,35696,35692,35686,35695,35679,35691,36111,36109,36489,36481,36485,36482,37300,37323,37912,37891,37885,38369,38704,39108,39250,39249,39336,39467,39472,39479,39477,39955,39949,40569,40629,40680,40751,40799,40803,40801,20791,20792,22209,22208,22210,22804,23660,24013,25084,25086,25885,25884,26005,26345,27387,27396,27386,27570,28748,29211,29351,29910,29908,30313,30675,31824,32399,32396,32700,34327,34349,34330,34851,34850,34849,34847,35178,35180,35261,35700,35703,35709,36115,36490,36493,36491,36703,36783,37306,37934,37939,37941,37946,37944,37938,37931,38370,38712,38713,38706,38911,39015,39013,39255,39493,39491,39488,39486,39631,39764,39761,39981,39973,40367,40372,40386,40376,40605,40687,40729,40796,40806,40807,20796,20795,22216,22218,22217,23423,24020,24018,24398,25087,25892,27402,27489,28753,28760,29568,29924,30090,30318,30316,31155,31840,31839,32894,32893,33247,35186,35183,35324,35712,36118,36119,36497,36499,36705,37192,37956,37969,37970,38717,38718,38851,38849,39019,39253,39509,39501,39634,39706,40009,39985,39998,39995,40403,40407,40756,40812,40810,40852,22220,24022,25088,25891,25899,25898,26348,27408,29914,31434,31844,31843,31845,32403,32406,32404,33250,34360,34367,34865,35722,37008,37007,37987,37984,37988,38760,39023,39260,39514,39515,39511,39635,39636,39633,40020,40023,40022,40421,40607,40692,22225,22761,25900,28766,30321,30322,30679,32592,32648,34870,34873,34914,35731,35730,35734,33399,36123,37312,37994,38722,38728,38724,38854,39024,39519,39714,39768,40031,40441,40442,40572,40573,40711,40823,40818,24307,27414,28771,31852,31854,34875,35264,36513,37313,38002,38000,39025,39262,39638,39715,40652,28772,30682,35738,38007,38857,39522,39525,32412,35740,36522,37317,38013,38014,38012,40055,40056,40695,35924,38015,40474,29224,39530,39729,40475,40478,31858,9312,9313,9314,9315,9316,9317,9318,9319,9320,9321,9332,9333,9334,9335,9336,9337,9338,9339,9340,9341,8560,8561,8562,8563,8564,8565,8566,8567,8568,8569,20022,20031,20101,20128,20866,20886,20907,21241,21304,21353,21430,22794,23424,24027,12083,24191,24308,24400,24417,25908,26080,30098,30326,36789,38582,168,710,12541,12542,12445,12446,12291,20189,12293,12294,12295,12540,65339,65341,10045,12353,12354,12355,12356,12357,12358,12359,12360,12361,12362,12363,12364,12365,12366,12367,12368,12369,12370,12371,12372,12373,12374,12375,12376,12377,12378,12379,12380,12381,12382,12383,12384,12385,12386,12387,12388,12389,12390,12391,12392,12393,12394,12395,12396,12397,12398,12399,12400,12401,12402,12403,12404,12405,12406,12407,12408,12409,12410,12411,12412,12413,12414,12415,12416,12417,12418,12419,12420,12421,12422,12423,12424,12425,12426,12427,12428,12429,12430,12431,12432,12433,12434,12435,12449,12450,12451,12452,12453,12454,12455,12456,12457,12458,12459,12460,12461,12462,12463,12464,12465,12466,12467,12468,12469,12470,12471,12472,12473,12474,12475,12476,12477,12478,12479,12480,12481,12482,12483,12484,12485,12486,12487,12488,12489,12490,12491,12492,12493,12494,12495,12496,12497,12498,12499,12500,12501,12502,12503,12504,12505,12506,12507,12508,12509,12510,12511,12512,12513,12514,12515,12516,12517,12518,12519,12520,12521,12522,12523,12524,12525,12526,12527,12528,12529,12530,12531,12532,12533,12534,1040,1041,1042,1043,1044,1045,1025,1046,1047,1048,1049,1050,1051,1052,1053,1054,1055,1056,1057,1058,1059,1060,1061,1062,1063,1064,1065,1066,1067,1068,1069,1070,1071,1072,1073,1074,1075,1076,1077,1105,1078,1079,1080,1081,1082,1083,1084,1085,1086,1087,1088,1089,1090,1091,1092,1093,1094,1095,1096,1097,1098,1099,1100,1101,1102,1103,8679,8632,8633,12751,131276,20058,131210,20994,17553,40880,20872,40881,161287,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,65506,65508,65287,65282,12849,8470,8481,12443,12444,11904,11908,11910,11911,11912,11914,11916,11917,11925,11932,11933,11941,11943,11946,11948,11950,11958,11964,11966,11974,11978,11980,11981,11983,11990,11991,11998,12003,null,null,null,643,592,603,596,629,339,248,331,650,618,20034,20060,20981,21274,21378,19975,19980,20039,20109,22231,64012,23662,24435,19983,20871,19982,20014,20115,20162,20169,20168,20888,21244,21356,21433,22304,22787,22828,23568,24063,26081,27571,27596,27668,29247,20017,20028,20200,20188,20201,20193,20189,20186,21004,21276,21324,22306,22307,22807,22831,23425,23428,23570,23611,23668,23667,24068,24192,24194,24521,25097,25168,27669,27702,27715,27711,27707,29358,29360,29578,31160,32906,38430,20238,20248,20268,20213,20244,20209,20224,20215,20232,20253,20226,20229,20258,20243,20228,20212,20242,20913,21011,21001,21008,21158,21282,21279,21325,21386,21511,22241,22239,22318,22314,22324,22844,22912,22908,22917,22907,22910,22903,22911,23382,23573,23589,23676,23674,23675,23678,24031,24181,24196,24322,24346,24436,24533,24532,24527,25180,25182,25188,25185,25190,25186,25177,25184,25178,25189,26095,26094,26430,26425,26424,26427,26426,26431,26428,26419,27672,27718,27730,27740,27727,27722,27732,27723,27724,28785,29278,29364,29365,29582,29994,30335,31349,32593,33400,33404,33408,33405,33407,34381,35198,37017,37015,37016,37019,37012,38434,38436,38432,38435,20310,20283,20322,20297,20307,20324,20286,20327,20306,20319,20289,20312,20269,20275,20287,20321,20879,20921,21020,21022,21025,21165,21166,21257,21347,21362,21390,21391,21552,21559,21546,21588,21573,21529,21532,21541,21528,21565,21583,21569,21544,21540,21575,22254,22247,22245,22337,22341,22348,22345,22347,22354,22790,22848,22950,22936,22944,22935,22926,22946,22928,22927,22951,22945,23438,23442,23592,23594,23693,23695,23688,23691,23689,23698,23690,23686,23699,23701,24032,24074,24078,24203,24201,24204,24200,24205,24325,24349,24440,24438,24530,24529,24528,24557,24552,24558,24563,24545,24548,24547,24570,24559,24567,24571,24576,24564,25146,25219,25228,25230,25231,25236,25223,25201,25211,25210,25200,25217,25224,25207,25213,25202,25204,25911,26096,26100,26099,26098,26101,26437,26439,26457,26453,26444,26440,26461,26445,26458,26443,27600,27673,27674,27768,27751,27755,27780,27787,27791,27761,27759,27753,27802,27757,27783,27797,27804,27750,27763,27749,27771,27790,28788,28794,29283,29375,29373,29379,29382,29377,29370,29381,29589,29591,29587,29588,29586,30010,30009,30100,30101,30337,31037,32820,32917,32921,32912,32914,32924,33424,33423,33413,33422,33425,33427,33418,33411,33412,35960,36809,36799,37023,37025,37029,37022,37031,37024,38448,38440,38447,38445,20019,20376,20348,20357,20349,20352,20359,20342,20340,20361,20356,20343,20300,20375,20330,20378,20345,20353,20344,20368,20380,20372,20382,20370,20354,20373,20331,20334,20894,20924,20926,21045,21042,21043,21062,21041,21180,21258,21259,21308,21394,21396,21639,21631,21633,21649,21634,21640,21611,21626,21630,21605,21612,21620,21606,21645,21615,21601,21600,21656,21603,21607,21604,22263,22265,22383,22386,22381,22379,22385,22384,22390,22400,22389,22395,22387,22388,22370,22376,22397,22796,22853,22965,22970,22991,22990,22962,22988,22977,22966,22972,22979,22998,22961,22973,22976,22984,22964,22983,23394,23397,23443,23445,23620,23623,23726,23716,23712,23733,23727,23720,23724,23711,23715,23725,23714,23722,23719,23709,23717,23734,23728,23718,24087,24084,24089,24360,24354,24355,24356,24404,24450,24446,24445,24542,24549,24621,24614,24601,24626,24587,24628,24586,24599,24627,24602,24606,24620,24610,24589,24592,24622,24595,24593,24588,24585,24604,25108,25149,25261,25268,25297,25278,25258,25270,25290,25262,25267,25263,25275,25257,25264,25272,25917,26024,26043,26121,26108,26116,26130,26120,26107,26115,26123,26125,26117,26109,26129,26128,26358,26378,26501,26476,26510,26514,26486,26491,26520,26502,26500,26484,26509,26508,26490,26527,26513,26521,26499,26493,26497,26488,26489,26516,27429,27520,27518,27614,27677,27795,27884,27883,27886,27865,27830,27860,27821,27879,27831,27856,27842,27834,27843,27846,27885,27890,27858,27869,27828,27786,27805,27776,27870,27840,27952,27853,27847,27824,27897,27855,27881,27857,28820,28824,28805,28819,28806,28804,28817,28822,28802,28826,28803,29290,29398,29387,29400,29385,29404,29394,29396,29402,29388,29393,29604,29601,29613,29606,29602,29600,29612,29597,29917,29928,30015,30016,30014,30092,30104,30383,30451,30449,30448,30453,30712,30716,30713,30715,30714,30711,31042,31039,31173,31352,31355,31483,31861,31997,32821,32911,32942,32931,32952,32949,32941,33312,33440,33472,33451,33434,33432,33435,33461,33447,33454,33468,33438,33466,33460,33448,33441,33449,33474,33444,33475,33462,33442,34416,34415,34413,34414,35926,36818,36811,36819,36813,36822,36821,36823,37042,37044,37039,37043,37040,38457,38461,38460,38458,38467,20429,20421,20435,20402,20425,20427,20417,20436,20444,20441,20411,20403,20443,20423,20438,20410,20416,20409,20460,21060,21065,21184,21186,21309,21372,21399,21398,21401,21400,21690,21665,21677,21669,21711,21699,33549,21687,21678,21718,21686,21701,21702,21664,21616,21692,21666,21694,21618,21726,21680,22453,22430,22431,22436,22412,22423,22429,22427,22420,22424,22415,22425,22437,22426,22421,22772,22797,22867,23009,23006,23022,23040,23025,23005,23034,23037,23036,23030,23012,23026,23031,23003,23017,23027,23029,23008,23038,23028,23021,23464,23628,23760,23768,23756,23767,23755,23771,23774,23770,23753,23751,23754,23766,23763,23764,23759,23752,23750,23758,23775,23800,24057,24097,24098,24099,24096,24100,24240,24228,24226,24219,24227,24229,24327,24366,24406,24454,24631,24633,24660,24690,24670,24645,24659,24647,24649,24667,24652,24640,24642,24671,24612,24644,24664,24678,24686,25154,25155,25295,25357,25355,25333,25358,25347,25323,25337,25359,25356,25336,25334,25344,25363,25364,25338,25365,25339,25328,25921,25923,26026,26047,26166,26145,26162,26165,26140,26150,26146,26163,26155,26170,26141,26164,26169,26158,26383,26384,26561,26610,26568,26554,26588,26555,26616,26584,26560,26551,26565,26603,26596,26591,26549,26573,26547,26615,26614,26606,26595,26562,26553,26574,26599,26608,26546,26620,26566,26605,26572,26542,26598,26587,26618,26569,26570,26563,26602,26571,27432,27522,27524,27574,27606,27608,27616,27680,27681,27944,27956,27949,27935,27964,27967,27922,27914,27866,27955,27908,27929,27962,27930,27921,27904,27933,27970,27905,27928,27959,27907,27919,27968,27911,27936,27948,27912,27938,27913,27920,28855,28831,28862,28849,28848,28833,28852,28853,28841,29249,29257,29258,29292,29296,29299,29294,29386,29412,29416,29419,29407,29418,29414,29411,29573,29644,29634,29640,29637,29625,29622,29621,29620,29675,29631,29639,29630,29635,29638,29624,29643,29932,29934,29998,30023,30024,30119,30122,30329,30404,30472,30467,30468,30469,30474,30455,30459,30458,30695,30696,30726,30737,30738,30725,30736,30735,30734,30729,30723,30739,31050,31052,31051,31045,31044,31189,31181,31183,31190,31182,31360,31358,31441,31488,31489,31866,31864,31865,31871,31872,31873,32003,32008,32001,32600,32657,32653,32702,32775,32782,32783,32788,32823,32984,32967,32992,32977,32968,32962,32976,32965,32995,32985,32988,32970,32981,32969,32975,32983,32998,32973,33279,33313,33428,33497,33534,33529,33543,33512,33536,33493,33594,33515,33494,33524,33516,33505,33522,33525,33548,33531,33526,33520,33514,33508,33504,33530,33523,33517,34423,34420,34428,34419,34881,34894,34919,34922,34921,35283,35332,35335,36210,36835,36833,36846,36832,37105,37053,37055,37077,37061,37054,37063,37067,37064,37332,37331,38484,38479,38481,38483,38474,38478,20510,20485,20487,20499,20514,20528,20507,20469,20468,20531,20535,20524,20470,20471,20503,20508,20512,20519,20533,20527,20529,20494,20826,20884,20883,20938,20932,20933,20936,20942,21089,21082,21074,21086,21087,21077,21090,21197,21262,21406,21798,21730,21783,21778,21735,21747,21732,21786,21759,21764,21768,21739,21777,21765,21745,21770,21755,21751,21752,21728,21774,21763,21771,22273,22274,22476,22578,22485,22482,22458,22470,22461,22460,22456,22454,22463,22471,22480,22457,22465,22798,22858,23065,23062,23085,23086,23061,23055,23063,23050,23070,23091,23404,23463,23469,23468,23555,23638,23636,23788,23807,23790,23793,23799,23808,23801,24105,24104,24232,24238,24234,24236,24371,24368,24423,24669,24666,24679,24641,24738,24712,24704,24722,24705,24733,24707,24725,24731,24727,24711,24732,24718,25113,25158,25330,25360,25430,25388,25412,25413,25398,25411,25572,25401,25419,25418,25404,25385,25409,25396,25432,25428,25433,25389,25415,25395,25434,25425,25400,25431,25408,25416,25930,25926,26054,26051,26052,26050,26186,26207,26183,26193,26386,26387,26655,26650,26697,26674,26675,26683,26699,26703,26646,26673,26652,26677,26667,26669,26671,26702,26692,26676,26653,26642,26644,26662,26664,26670,26701,26682,26661,26656,27436,27439,27437,27441,27444,27501,32898,27528,27622,27620,27624,27619,27618,27623,27685,28026,28003,28004,28022,27917,28001,28050,27992,28002,28013,28015,28049,28045,28143,28031,28038,27998,28007,28000,28055,28016,28028,27999,28034,28056,27951,28008,28043,28030,28032,28036,27926,28035,28027,28029,28021,28048,28892,28883,28881,28893,28875,32569,28898,28887,28882,28894,28896,28884,28877,28869,28870,28871,28890,28878,28897,29250,29304,29303,29302,29440,29434,29428,29438,29430,29427,29435,29441,29651,29657,29669,29654,29628,29671,29667,29673,29660,29650,29659,29652,29661,29658,29655,29656,29672,29918,29919,29940,29941,29985,30043,30047,30128,30145,30139,30148,30144,30143,30134,30138,30346,30409,30493,30491,30480,30483,30482,30499,30481,30485,30489,30490,30498,30503,30755,30764,30754,30773,30767,30760,30766,30763,30753,30761,30771,30762,30769,31060,31067,31055,31068,31059,31058,31057,31211,31212,31200,31214,31213,31210,31196,31198,31197,31366,31369,31365,31371,31372,31370,31367,31448,31504,31492,31507,31493,31503,31496,31498,31502,31497,31506,31876,31889,31882,31884,31880,31885,31877,32030,32029,32017,32014,32024,32022,32019,32031,32018,32015,32012,32604,32609,32606,32608,32605,32603,32662,32658,32707,32706,32704,32790,32830,32825,33018,33010,33017,33013,33025,33019,33024,33281,33327,33317,33587,33581,33604,33561,33617,33573,33622,33599,33601,33574,33564,33570,33602,33614,33563,33578,33544,33596,33613,33558,33572,33568,33591,33583,33577,33607,33605,33612,33619,33566,33580,33611,33575,33608,34387,34386,34466,34472,34454,34445,34449,34462,34439,34455,34438,34443,34458,34437,34469,34457,34465,34471,34453,34456,34446,34461,34448,34452,34883,34884,34925,34933,34934,34930,34944,34929,34943,34927,34947,34942,34932,34940,35346,35911,35927,35963,36004,36003,36214,36216,36277,36279,36278,36561,36563,36862,36853,36866,36863,36859,36868,36860,36854,37078,37088,37081,37082,37091,37087,37093,37080,37083,37079,37084,37092,37200,37198,37199,37333,37346,37338,38492,38495,38588,39139,39647,39727,20095,20592,20586,20577,20574,20576,20563,20555,20573,20594,20552,20557,20545,20571,20554,20578,20501,20549,20575,20585,20587,20579,20580,20550,20544,20590,20595,20567,20561,20944,21099,21101,21100,21102,21206,21203,21293,21404,21877,21878,21820,21837,21840,21812,21802,21841,21858,21814,21813,21808,21842,21829,21772,21810,21861,21838,21817,21832,21805,21819,21824,21835,22282,22279,22523,22548,22498,22518,22492,22516,22528,22509,22525,22536,22520,22539,22515,22479,22535,22510,22499,22514,22501,22508,22497,22542,22524,22544,22503,22529,22540,22513,22505,22512,22541,22532,22876,23136,23128,23125,23143,23134,23096,23093,23149,23120,23135,23141,23148,23123,23140,23127,23107,23133,23122,23108,23131,23112,23182,23102,23117,23097,23116,23152,23145,23111,23121,23126,23106,23132,23410,23406,23489,23488,23641,23838,23819,23837,23834,23840,23820,23848,23821,23846,23845,23823,23856,23826,23843,23839,23854,24126,24116,24241,24244,24249,24242,24243,24374,24376,24475,24470,24479,24714,24720,24710,24766,24752,24762,24787,24788,24783,24804,24793,24797,24776,24753,24795,24759,24778,24767,24771,24781,24768,25394,25445,25482,25474,25469,25533,25502,25517,25501,25495,25515,25486,25455,25479,25488,25454,25519,25461,25500,25453,25518,25468,25508,25403,25503,25464,25477,25473,25489,25485,25456,25939,26061,26213,26209,26203,26201,26204,26210,26392,26745,26759,26768,26780,26733,26734,26798,26795,26966,26735,26787,26796,26793,26741,26740,26802,26767,26743,26770,26748,26731,26738,26794,26752,26737,26750,26779,26774,26763,26784,26761,26788,26744,26747,26769,26764,26762,26749,27446,27443,27447,27448,27537,27535,27533,27534,27532,27690,28096,28075,28084,28083,28276,28076,28137,28130,28087,28150,28116,28160,28104,28128,28127,28118,28094,28133,28124,28125,28123,28148,28106,28093,28141,28144,28090,28117,28098,28111,28105,28112,28146,28115,28157,28119,28109,28131,28091,28922,28941,28919,28951,28916,28940,28912,28932,28915,28944,28924,28927,28934,28947,28928,28920,28918,28939,28930,28942,29310,29307,29308,29311,29469,29463,29447,29457,29464,29450,29448,29439,29455,29470,29576,29686,29688,29685,29700,29697,29693,29703,29696,29690,29692,29695,29708,29707,29684,29704,30052,30051,30158,30162,30159,30155,30156,30161,30160,30351,30345,30419,30521,30511,30509,30513,30514,30516,30515,30525,30501,30523,30517,30792,30802,30793,30797,30794,30796,30758,30789,30800,31076,31079,31081,31082,31075,31083,31073,31163,31226,31224,31222,31223,31375,31380,31376,31541,31559,31540,31525,31536,31522,31524,31539,31512,31530,31517,31537,31531,31533,31535,31538,31544,31514,31523,31892,31896,31894,31907,32053,32061,32056,32054,32058,32069,32044,32041,32065,32071,32062,32063,32074,32059,32040,32611,32661,32668,32669,32667,32714,32715,32717,32720,32721,32711,32719,32713,32799,32798,32795,32839,32835,32840,33048,33061,33049,33051,33069,33055,33068,33054,33057,33045,33063,33053,33058,33297,33336,33331,33338,33332,33330,33396,33680,33699,33704,33677,33658,33651,33700,33652,33679,33665,33685,33689,33653,33684,33705,33661,33667,33676,33693,33691,33706,33675,33662,33701,33711,33672,33687,33712,33663,33702,33671,33710,33654,33690,34393,34390,34495,34487,34498,34497,34501,34490,34480,34504,34489,34483,34488,34508,34484,34491,34492,34499,34493,34494,34898,34953,34965,34984,34978,34986,34970,34961,34977,34975,34968,34983,34969,34971,34967,34980,34988,34956,34963,34958,35202,35286,35289,35285,35376,35367,35372,35358,35897,35899,35932,35933,35965,36005,36221,36219,36217,36284,36290,36281,36287,36289,36568,36574,36573,36572,36567,36576,36577,36900,36875,36881,36892,36876,36897,37103,37098,37104,37108,37106,37107,37076,37099,37100,37097,37206,37208,37210,37203,37205,37356,37364,37361,37363,37368,37348,37369,37354,37355,37367,37352,37358,38266,38278,38280,38524,38509,38507,38513,38511,38591,38762,38916,39141,39319,20635,20629,20628,20638,20619,20643,20611,20620,20622,20637,20584,20636,20626,20610,20615,20831,20948,21266,21265,21412,21415,21905,21928,21925,21933,21879,22085,21922,21907,21896,21903,21941,21889,21923,21906,21924,21885,21900,21926,21887,21909,21921,21902,22284,22569,22583,22553,22558,22567,22563,22568,22517,22600,22565,22556,22555,22579,22591,22582,22574,22585,22584,22573,22572,22587,22881,23215,23188,23199,23162,23202,23198,23160,23206,23164,23205,23212,23189,23214,23095,23172,23178,23191,23171,23179,23209,23163,23165,23180,23196,23183,23187,23197,23530,23501,23499,23508,23505,23498,23502,23564,23600,23863,23875,23915,23873,23883,23871,23861,23889,23886,23893,23859,23866,23890,23869,23857,23897,23874,23865,23881,23864,23868,23858,23862,23872,23877,24132,24129,24408,24486,24485,24491,24777,24761,24780,24802,24782,24772,24852,24818,24842,24854,24837,24821,24851,24824,24828,24830,24769,24835,24856,24861,24848,24831,24836,24843,25162,25492,25521,25520,25550,25573,25576,25583,25539,25757,25587,25546,25568,25590,25557,25586,25589,25697,25567,25534,25565,25564,25540,25560,25555,25538,25543,25548,25547,25544,25584,25559,25561,25906,25959,25962,25956,25948,25960,25957,25996,26013,26014,26030,26064,26066,26236,26220,26235,26240,26225,26233,26218,26226,26369,26892,26835,26884,26844,26922,26860,26858,26865,26895,26838,26871,26859,26852,26870,26899,26896,26867,26849,26887,26828,26888,26992,26804,26897,26863,26822,26900,26872,26832,26877,26876,26856,26891,26890,26903,26830,26824,26845,26846,26854,26868,26833,26886,26836,26857,26901,26917,26823,27449,27451,27455,27452,27540,27543,27545,27541,27581,27632,27634,27635,27696,28156,28230,28231,28191,28233,28296,28220,28221,28229,28258,28203,28223,28225,28253,28275,28188,28211,28235,28224,28241,28219,28163,28206,28254,28264,28252,28257,28209,28200,28256,28273,28267,28217,28194,28208,28243,28261,28199,28280,28260,28279,28245,28281,28242,28262,28213,28214,28250,28960,28958,28975,28923,28974,28977,28963,28965,28962,28978,28959,28968,28986,28955,29259,29274,29320,29321,29318,29317,29323,29458,29451,29488,29474,29489,29491,29479,29490,29485,29478,29475,29493,29452,29742,29740,29744,29739,29718,29722,29729,29741,29745,29732,29731,29725,29737,29728,29746,29947,29999,30063,30060,30183,30170,30177,30182,30173,30175,30180,30167,30357,30354,30426,30534,30535,30532,30541,30533,30538,30542,30539,30540,30686,30700,30816,30820,30821,30812,30829,30833,30826,30830,30832,30825,30824,30814,30818,31092,31091,31090,31088,31234,31242,31235,31244,31236,31385,31462,31460,31562,31547,31556,31560,31564,31566,31552,31576,31557,31906,31902,31912,31905,32088,32111,32099,32083,32086,32103,32106,32079,32109,32092,32107,32082,32084,32105,32081,32095,32078,32574,32575,32613,32614,32674,32672,32673,32727,32849,32847,32848,33022,32980,33091,33098,33106,33103,33095,33085,33101,33082,33254,33262,33271,33272,33273,33284,33340,33341,33343,33397,33595,33743,33785,33827,33728,33768,33810,33767,33764,33788,33782,33808,33734,33736,33771,33763,33727,33793,33757,33765,33752,33791,33761,33739,33742,33750,33781,33737,33801,33807,33758,33809,33798,33730,33779,33749,33786,33735,33745,33770,33811,33731,33772,33774,33732,33787,33751,33762,33819,33755,33790,34520,34530,34534,34515,34531,34522,34538,34525,34539,34524,34540,34537,34519,34536,34513,34888,34902,34901,35002,35031,35001,35000,35008,35006,34998,35004,34999,35005,34994,35073,35017,35221,35224,35223,35293,35290,35291,35406,35405,35385,35417,35392,35415,35416,35396,35397,35410,35400,35409,35402,35404,35407,35935,35969,35968,36026,36030,36016,36025,36021,36228,36224,36233,36312,36307,36301,36295,36310,36316,36303,36309,36313,36296,36311,36293,36591,36599,36602,36601,36582,36590,36581,36597,36583,36584,36598,36587,36593,36588,36596,36585,36909,36916,36911,37126,37164,37124,37119,37116,37128,37113,37115,37121,37120,37127,37125,37123,37217,37220,37215,37218,37216,37377,37386,37413,37379,37402,37414,37391,37388,37376,37394,37375,37373,37382,37380,37415,37378,37404,37412,37401,37399,37381,37398,38267,38285,38284,38288,38535,38526,38536,38537,38531,38528,38594,38600,38595,38641,38640,38764,38768,38766,38919,39081,39147,40166,40697,20099,20100,20150,20669,20671,20678,20654,20676,20682,20660,20680,20674,20656,20673,20666,20657,20683,20681,20662,20664,20951,21114,21112,21115,21116,21955,21979,21964,21968,21963,21962,21981,21952,21972,21956,21993,21951,21970,21901,21967,21973,21986,21974,21960,22002,21965,21977,21954,22292,22611,22632,22628,22607,22605,22601,22639,22613,22606,22621,22617,22629,22619,22589,22627,22641,22780,23239,23236,23243,23226,23224,23217,23221,23216,23231,23240,23227,23238,23223,23232,23242,23220,23222,23245,23225,23184,23510,23512,23513,23583,23603,23921,23907,23882,23909,23922,23916,23902,23912,23911,23906,24048,24143,24142,24138,24141,24139,24261,24268,24262,24267,24263,24384,24495,24493,24823,24905,24906,24875,24901,24886,24882,24878,24902,24879,24911,24873,24896,25120,37224,25123,25125,25124,25541,25585,25579,25616,25618,25609,25632,25636,25651,25667,25631,25621,25624,25657,25655,25634,25635,25612,25638,25648,25640,25665,25653,25647,25610,25626,25664,25637,25639,25611,25575,25627,25646,25633,25614,25967,26002,26067,26246,26252,26261,26256,26251,26250,26265,26260,26232,26400,26982,26975,26936,26958,26978,26993,26943,26949,26986,26937,26946,26967,26969,27002,26952,26953,26933,26988,26931,26941,26981,26864,27000,26932,26985,26944,26991,26948,26998,26968,26945,26996,26956,26939,26955,26935,26972,26959,26961,26930,26962,26927,27003,26940,27462,27461,27459,27458,27464,27457,27547,64013,27643,27644,27641,27639,27640,28315,28374,28360,28303,28352,28319,28307,28308,28320,28337,28345,28358,28370,28349,28353,28318,28361,28343,28336,28365,28326,28367,28338,28350,28355,28380,28376,28313,28306,28302,28301,28324,28321,28351,28339,28368,28362,28311,28334,28323,28999,29012,29010,29027,29024,28993,29021,29026,29042,29048,29034,29025,28994,29016,28995,29003,29040,29023,29008,29011,28996,29005,29018,29263,29325,29324,29329,29328,29326,29500,29506,29499,29498,29504,29514,29513,29764,29770,29771,29778,29777,29783,29760,29775,29776,29774,29762,29766,29773,29780,29921,29951,29950,29949,29981,30073,30071,27011,30191,30223,30211,30199,30206,30204,30201,30200,30224,30203,30198,30189,30197,30205,30361,30389,30429,30549,30559,30560,30546,30550,30554,30569,30567,30548,30553,30573,30688,30855,30874,30868,30863,30852,30869,30853,30854,30881,30851,30841,30873,30848,30870,30843,31100,31106,31101,31097,31249,31256,31257,31250,31255,31253,31266,31251,31259,31248,31395,31394,31390,31467,31590,31588,31597,31604,31593,31602,31589,31603,31601,31600,31585,31608,31606,31587,31922,31924,31919,32136,32134,32128,32141,32127,32133,32122,32142,32123,32131,32124,32140,32148,32132,32125,32146,32621,32619,32615,32616,32620,32678,32677,32679,32731,32732,32801,33124,33120,33143,33116,33129,33115,33122,33138,26401,33118,33142,33127,33135,33092,33121,33309,33353,33348,33344,33346,33349,34033,33855,33878,33910,33913,33935,33933,33893,33873,33856,33926,33895,33840,33869,33917,33882,33881,33908,33907,33885,34055,33886,33847,33850,33844,33914,33859,33912,33842,33861,33833,33753,33867,33839,33858,33837,33887,33904,33849,33870,33868,33874,33903,33989,33934,33851,33863,33846,33843,33896,33918,33860,33835,33888,33876,33902,33872,34571,34564,34551,34572,34554,34518,34549,34637,34552,34574,34569,34561,34550,34573,34565,35030,35019,35021,35022,35038,35035,35034,35020,35024,35205,35227,35295,35301,35300,35297,35296,35298,35292,35302,35446,35462,35455,35425,35391,35447,35458,35460,35445,35459,35457,35444,35450,35900,35915,35914,35941,35940,35942,35974,35972,35973,36044,36200,36201,36241,36236,36238,36239,36237,36243,36244,36240,36242,36336,36320,36332,36337,36334,36304,36329,36323,36322,36327,36338,36331,36340,36614,36607,36609,36608,36613,36615,36616,36610,36619,36946,36927,36932,36937,36925,37136,37133,37135,37137,37142,37140,37131,37134,37230,37231,37448,37458,37424,37434,37478,37427,37477,37470,37507,37422,37450,37446,37485,37484,37455,37472,37479,37487,37430,37473,37488,37425,37460,37475,37456,37490,37454,37459,37452,37462,37426,38303,38300,38302,38299,38546,38547,38545,38551,38606,38650,38653,38648,38645,38771,38775,38776,38770,38927,38925,38926,39084,39158,39161,39343,39346,39344,39349,39597,39595,39771,40170,40173,40167,40576,40701,20710,20692,20695,20712,20723,20699,20714,20701,20708,20691,20716,20720,20719,20707,20704,20952,21120,21121,21225,21227,21296,21420,22055,22037,22028,22034,22012,22031,22044,22017,22035,22018,22010,22045,22020,22015,22009,22665,22652,22672,22680,22662,22657,22655,22644,22667,22650,22663,22673,22670,22646,22658,22664,22651,22676,22671,22782,22891,23260,23278,23269,23253,23274,23258,23277,23275,23283,23266,23264,23259,23276,23262,23261,23257,23272,23263,23415,23520,23523,23651,23938,23936,23933,23942,23930,23937,23927,23946,23945,23944,23934,23932,23949,23929,23935,24152,24153,24147,24280,24273,24279,24270,24284,24277,24281,24274,24276,24388,24387,24431,24502,24876,24872,24897,24926,24945,24947,24914,24915,24946,24940,24960,24948,24916,24954,24923,24933,24891,24938,24929,24918,25129,25127,25131,25643,25677,25691,25693,25716,25718,25714,25715,25725,25717,25702,25766,25678,25730,25694,25692,25675,25683,25696,25680,25727,25663,25708,25707,25689,25701,25719,25971,26016,26273,26272,26271,26373,26372,26402,27057,27062,27081,27040,27086,27030,27056,27052,27068,27025,27033,27022,27047,27021,27049,27070,27055,27071,27076,27069,27044,27092,27065,27082,27034,27087,27059,27027,27050,27041,27038,27097,27031,27024,27074,27061,27045,27078,27466,27469,27467,27550,27551,27552,27587,27588,27646,28366,28405,28401,28419,28453,28408,28471,28411,28462,28425,28494,28441,28442,28455,28440,28475,28434,28397,28426,28470,28531,28409,28398,28461,28480,28464,28476,28469,28395,28423,28430,28483,28421,28413,28406,28473,28444,28412,28474,28447,28429,28446,28424,28449,29063,29072,29065,29056,29061,29058,29071,29051,29062,29057,29079,29252,29267,29335,29333,29331,29507,29517,29521,29516,29794,29811,29809,29813,29810,29799,29806,29952,29954,29955,30077,30096,30230,30216,30220,30229,30225,30218,30228,30392,30593,30588,30597,30594,30574,30592,30575,30590,30595,30898,30890,30900,30893,30888,30846,30891,30878,30885,30880,30892,30882,30884,31128,31114,31115,31126,31125,31124,31123,31127,31112,31122,31120,31275,31306,31280,31279,31272,31270,31400,31403,31404,31470,31624,31644,31626,31633,31632,31638,31629,31628,31643,31630,31621,31640,21124,31641,31652,31618,31931,31935,31932,31930,32167,32183,32194,32163,32170,32193,32192,32197,32157,32206,32196,32198,32203,32204,32175,32185,32150,32188,32159,32166,32174,32169,32161,32201,32627,32738,32739,32741,32734,32804,32861,32860,33161,33158,33155,33159,33165,33164,33163,33301,33943,33956,33953,33951,33978,33998,33986,33964,33966,33963,33977,33972,33985,33997,33962,33946,33969,34000,33949,33959,33979,33954,33940,33991,33996,33947,33961,33967,33960,34006,33944,33974,33999,33952,34007,34004,34002,34011,33968,33937,34401,34611,34595,34600,34667,34624,34606,34590,34593,34585,34587,34627,34604,34625,34622,34630,34592,34610,34602,34605,34620,34578,34618,34609,34613,34626,34598,34599,34616,34596,34586,34608,34577,35063,35047,35057,35058,35066,35070,35054,35068,35062,35067,35056,35052,35051,35229,35233,35231,35230,35305,35307,35304,35499,35481,35467,35474,35471,35478,35901,35944,35945,36053,36047,36055,36246,36361,36354,36351,36365,36349,36362,36355,36359,36358,36357,36350,36352,36356,36624,36625,36622,36621,37155,37148,37152,37154,37151,37149,37146,37156,37153,37147,37242,37234,37241,37235,37541,37540,37494,37531,37498,37536,37524,37546,37517,37542,37530,37547,37497,37527,37503,37539,37614,37518,37506,37525,37538,37501,37512,37537,37514,37510,37516,37529,37543,37502,37511,37545,37533,37515,37421,38558,38561,38655,38744,38781,38778,38782,38787,38784,38786,38779,38788,38785,38783,38862,38861,38934,39085,39086,39170,39168,39175,39325,39324,39363,39353,39355,39354,39362,39357,39367,39601,39651,39655,39742,39743,39776,39777,39775,40177,40178,40181,40615,20735,20739,20784,20728,20742,20743,20726,20734,20747,20748,20733,20746,21131,21132,21233,21231,22088,22082,22092,22069,22081,22090,22089,22086,22104,22106,22080,22067,22077,22060,22078,22072,22058,22074,22298,22699,22685,22705,22688,22691,22703,22700,22693,22689,22783,23295,23284,23293,23287,23286,23299,23288,23298,23289,23297,23303,23301,23311,23655,23961,23959,23967,23954,23970,23955,23957,23968,23964,23969,23962,23966,24169,24157,24160,24156,32243,24283,24286,24289,24393,24498,24971,24963,24953,25009,25008,24994,24969,24987,24979,25007,25005,24991,24978,25002,24993,24973,24934,25011,25133,25710,25712,25750,25760,25733,25751,25756,25743,25739,25738,25740,25763,25759,25704,25777,25752,25974,25978,25977,25979,26034,26035,26293,26288,26281,26290,26295,26282,26287,27136,27142,27159,27109,27128,27157,27121,27108,27168,27135,27116,27106,27163,27165,27134,27175,27122,27118,27156,27127,27111,27200,27144,27110,27131,27149,27132,27115,27145,27140,27160,27173,27151,27126,27174,27143,27124,27158,27473,27557,27555,27554,27558,27649,27648,27647,27650,28481,28454,28542,28551,28614,28562,28557,28553,28556,28514,28495,28549,28506,28566,28534,28524,28546,28501,28530,28498,28496,28503,28564,28563,28509,28416,28513,28523,28541,28519,28560,28499,28555,28521,28543,28565,28515,28535,28522,28539,29106,29103,29083,29104,29088,29082,29097,29109,29085,29093,29086,29092,29089,29098,29084,29095,29107,29336,29338,29528,29522,29534,29535,29536,29533,29531,29537,29530,29529,29538,29831,29833,29834,29830,29825,29821,29829,29832,29820,29817,29960,29959,30078,30245,30238,30233,30237,30236,30243,30234,30248,30235,30364,30365,30366,30363,30605,30607,30601,30600,30925,30907,30927,30924,30929,30926,30932,30920,30915,30916,30921,31130,31137,31136,31132,31138,31131,27510,31289,31410,31412,31411,31671,31691,31678,31660,31694,31663,31673,31690,31669,31941,31944,31948,31947,32247,32219,32234,32231,32215,32225,32259,32250,32230,32246,32241,32240,32238,32223,32630,32684,32688,32685,32749,32747,32746,32748,32742,32744,32868,32871,33187,33183,33182,33173,33186,33177,33175,33302,33359,33363,33362,33360,33358,33361,34084,34107,34063,34048,34089,34062,34057,34061,34079,34058,34087,34076,34043,34091,34042,34056,34060,34036,34090,34034,34069,34039,34027,34035,34044,34066,34026,34025,34070,34046,34088,34077,34094,34050,34045,34078,34038,34097,34086,34023,34024,34032,34031,34041,34072,34080,34096,34059,34073,34095,34402,34646,34659,34660,34679,34785,34675,34648,34644,34651,34642,34657,34650,34641,34654,34669,34666,34640,34638,34655,34653,34671,34668,34682,34670,34652,34661,34639,34683,34677,34658,34663,34665,34906,35077,35084,35092,35083,35095,35096,35097,35078,35094,35089,35086,35081,35234,35236,35235,35309,35312,35308,35535,35526,35512,35539,35537,35540,35541,35515,35543,35518,35520,35525,35544,35523,35514,35517,35545,35902,35917,35983,36069,36063,36057,36072,36058,36061,36071,36256,36252,36257,36251,36384,36387,36389,36388,36398,36373,36379,36374,36369,36377,36390,36391,36372,36370,36376,36371,36380,36375,36378,36652,36644,36632,36634,36640,36643,36630,36631,36979,36976,36975,36967,36971,37167,37163,37161,37162,37170,37158,37166,37253,37254,37258,37249,37250,37252,37248,37584,37571,37572,37568,37593,37558,37583,37617,37599,37592,37609,37591,37597,37580,37615,37570,37608,37578,37576,37582,37606,37581,37589,37577,37600,37598,37607,37585,37587,37557,37601,37574,37556,38268,38316,38315,38318,38320,38564,38562,38611,38661,38664,38658,38746,38794,38798,38792,38864,38863,38942,38941,38950,38953,38952,38944,38939,38951,39090,39176,39162,39185,39188,39190,39191,39189,39388,39373,39375,39379,39380,39374,39369,39382,39384,39371,39383,39372,39603,39660,39659,39667,39666,39665,39750,39747,39783,39796,39793,39782,39798,39797,39792,39784,39780,39788,40188,40186,40189,40191,40183,40199,40192,40185,40187,40200,40197,40196,40579,40659,40719,40720,20764,20755,20759,20762,20753,20958,21300,21473,22128,22112,22126,22131,22118,22115,22125,22130,22110,22135,22300,22299,22728,22717,22729,22719,22714,22722,22716,22726,23319,23321,23323,23329,23316,23315,23312,23318,23336,23322,23328,23326,23535,23980,23985,23977,23975,23989,23984,23982,23978,23976,23986,23981,23983,23988,24167,24168,24166,24175,24297,24295,24294,24296,24293,24395,24508,24989,25000,24982,25029,25012,25030,25025,25036,25018,25023,25016,24972,25815,25814,25808,25807,25801,25789,25737,25795,25819,25843,25817,25907,25983,25980,26018,26312,26302,26304,26314,26315,26319,26301,26299,26298,26316,26403,27188,27238,27209,27239,27186,27240,27198,27229,27245,27254,27227,27217,27176,27226,27195,27199,27201,27242,27236,27216,27215,27220,27247,27241,27232,27196,27230,27222,27221,27213,27214,27206,27477,27476,27478,27559,27562,27563,27592,27591,27652,27651,27654,28589,28619,28579,28615,28604,28622,28616,28510,28612,28605,28574,28618,28584,28676,28581,28590,28602,28588,28586,28623,28607,28600,28578,28617,28587,28621,28591,28594,28592,29125,29122,29119,29112,29142,29120,29121,29131,29140,29130,29127,29135,29117,29144,29116,29126,29146,29147,29341,29342,29545,29542,29543,29548,29541,29547,29546,29823,29850,29856,29844,29842,29845,29857,29963,30080,30255,30253,30257,30269,30259,30268,30261,30258,30256,30395,30438,30618,30621,30625,30620,30619,30626,30627,30613,30617,30615,30941,30953,30949,30954,30942,30947,30939,30945,30946,30957,30943,30944,31140,31300,31304,31303,31414,31416,31413,31409,31415,31710,31715,31719,31709,31701,31717,31706,31720,31737,31700,31722,31714,31708,31723,31704,31711,31954,31956,31959,31952,31953,32274,32289,32279,32268,32287,32288,32275,32270,32284,32277,32282,32290,32267,32271,32278,32269,32276,32293,32292,32579,32635,32636,32634,32689,32751,32810,32809,32876,33201,33190,33198,33209,33205,33195,33200,33196,33204,33202,33207,33191,33266,33365,33366,33367,34134,34117,34155,34125,34131,34145,34136,34112,34118,34148,34113,34146,34116,34129,34119,34147,34110,34139,34161,34126,34158,34165,34133,34151,34144,34188,34150,34141,34132,34149,34156,34403,34405,34404,34715,34703,34711,34707,34706,34696,34689,34710,34712,34681,34695,34723,34693,34704,34705,34717,34692,34708,34716,34714,34697,35102,35110,35120,35117,35118,35111,35121,35106,35113,35107,35119,35116,35103,35313,35552,35554,35570,35572,35573,35549,35604,35556,35551,35568,35528,35550,35553,35560,35583,35567,35579,35985,35986,35984,36085,36078,36081,36080,36083,36204,36206,36261,36263,36403,36414,36408,36416,36421,36406,36412,36413,36417,36400,36415,36541,36662,36654,36661,36658,36665,36663,36660,36982,36985,36987,36998,37114,37171,37173,37174,37267,37264,37265,37261,37263,37671,37662,37640,37663,37638,37647,37754,37688,37692,37659,37667,37650,37633,37702,37677,37646,37645,37579,37661,37626,37669,37651,37625,37623,37684,37634,37668,37631,37673,37689,37685,37674,37652,37644,37643,37630,37641,37632,37627,37654,38332,38349,38334,38329,38330,38326,38335,38325,38333,38569,38612,38667,38674,38672,38809,38807,38804,38896,38904,38965,38959,38962,39204,39199,39207,39209,39326,39406,39404,39397,39396,39408,39395,39402,39401,39399,39609,39615,39604,39611,39670,39674,39673,39671,39731,39808,39813,39815,39804,39806,39803,39810,39827,39826,39824,39802,39829,39805,39816,40229,40215,40224,40222,40212,40233,40221,40216,40226,40208,40217,40223,40584,40582,40583,40622,40621,40661,40662,40698,40722,40765,20774,20773,20770,20772,20768,20777,21236,22163,22156,22157,22150,22148,22147,22142,22146,22143,22145,22742,22740,22735,22738,23341,23333,23346,23331,23340,23335,23334,23343,23342,23419,23537,23538,23991,24172,24170,24510,24507,25027,25013,25020,25063,25056,25061,25060,25064,25054,25839,25833,25827,25835,25828,25832,25985,25984,26038,26074,26322,27277,27286,27265,27301,27273,27295,27291,27297,27294,27271,27283,27278,27285,27267,27304,27300,27281,27263,27302,27290,27269,27276,27282,27483,27565,27657,28620,28585,28660,28628,28643,28636,28653,28647,28646,28638,28658,28637,28642,28648,29153,29169,29160,29170,29156,29168,29154,29555,29550,29551,29847,29874,29867,29840,29866,29869,29873,29861,29871,29968,29969,29970,29967,30084,30275,30280,30281,30279,30372,30441,30645,30635,30642,30647,30646,30644,30641,30632,30704,30963,30973,30978,30971,30972,30962,30981,30969,30974,30980,31147,31144,31324,31323,31318,31320,31316,31322,31422,31424,31425,31749,31759,31730,31744,31743,31739,31758,31732,31755,31731,31746,31753,31747,31745,31736,31741,31750,31728,31729,31760,31754,31976,32301,32316,32322,32307,38984,32312,32298,32329,32320,32327,32297,32332,32304,32315,32310,32324,32314,32581,32639,32638,32637,32756,32754,32812,33211,33220,33228,33226,33221,33223,33212,33257,33371,33370,33372,34179,34176,34191,34215,34197,34208,34187,34211,34171,34212,34202,34206,34167,34172,34185,34209,34170,34168,34135,34190,34198,34182,34189,34201,34205,34177,34210,34178,34184,34181,34169,34166,34200,34192,34207,34408,34750,34730,34733,34757,34736,34732,34745,34741,34748,34734,34761,34755,34754,34764,34743,34735,34756,34762,34740,34742,34751,34744,34749,34782,34738,35125,35123,35132,35134,35137,35154,35127,35138,35245,35247,35246,35314,35315,35614,35608,35606,35601,35589,35595,35618,35599,35602,35605,35591,35597,35592,35590,35612,35603,35610,35919,35952,35954,35953,35951,35989,35988,36089,36207,36430,36429,36435,36432,36428,36423,36675,36672,36997,36990,37176,37274,37282,37275,37273,37279,37281,37277,37280,37793,37763,37807,37732,37718,37703,37756,37720,37724,37750,37705,37712,37713,37728,37741,37775,37708,37738,37753,37719,37717,37714,37711,37745,37751,37755,37729,37726,37731,37735,37760,37710,37721,38343,38336,38345,38339,38341,38327,38574,38576,38572,38688,38687,38680,38685,38681,38810,38817,38812,38814,38813,38869,38868,38897,38977,38980,38986,38985,38981,38979,39205,39211,39212,39210,39219,39218,39215,39213,39217,39216,39320,39331,39329,39426,39418,39412,39415,39417,39416,39414,39419,39421,39422,39420,39427,39614,39678,39677,39681,39676,39752,39834,39848,39838,39835,39846,39841,39845,39844,39814,39842,39840,39855,40243,40257,40295,40246,40238,40239,40241,40248,40240,40261,40258,40259,40254,40247,40256,40253,32757,40237,40586,40585,40589,40624,40648,40666,40699,40703,40740,40739,40738,40788,40864,20785,20781,20782,22168,22172,22167,22170,22173,22169,22896,23356,23657,23658,24000,24173,24174,25048,25055,25069,25070,25073,25066,25072,25067,25046,25065,25855,25860,25853,25848,25857,25859,25852,26004,26075,26330,26331,26328,27333,27321,27325,27361,27334,27322,27318,27319,27335,27316,27309,27486,27593,27659,28679,28684,28685,28673,28677,28692,28686,28671,28672,28667,28710,28668,28663,28682,29185,29183,29177,29187,29181,29558,29880,29888,29877,29889,29886,29878,29883,29890,29972,29971,30300,30308,30297,30288,30291,30295,30298,30374,30397,30444,30658,30650,30975,30988,30995,30996,30985,30992,30994,30993,31149,31148,31327,31772,31785,31769,31776,31775,31789,31773,31782,31784,31778,31781,31792,32348,32336,32342,32355,32344,32354,32351,32337,32352,32343,32339,32693,32691,32759,32760,32885,33233,33234,33232,33375,33374,34228,34246,34240,34243,34242,34227,34229,34237,34247,34244,34239,34251,34254,34248,34245,34225,34230,34258,34340,34232,34231,34238,34409,34791,34790,34786,34779,34795,34794,34789,34783,34803,34788,34772,34780,34771,34797,34776,34787,34724,34775,34777,34817,34804,34792,34781,35155,35147,35151,35148,35142,35152,35153,35145,35626,35623,35619,35635,35632,35637,35655,35631,35644,35646,35633,35621,35639,35622,35638,35630,35620,35643,35645,35642,35906,35957,35993,35992,35991,36094,36100,36098,36096,36444,36450,36448,36439,36438,36446,36453,36455,36443,36442,36449,36445,36457,36436,36678,36679,36680,36683,37160,37178,37179,37182,37288,37285,37287,37295,37290,37813,37772,37778,37815,37787,37789,37769,37799,37774,37802,37790,37798,37781,37768,37785,37791,37773,37809,37777,37810,37796,37800,37812,37795,37797,38354,38355,38353,38579,38615,38618,24002,38623,38616,38621,38691,38690,38693,38828,38830,38824,38827,38820,38826,38818,38821,38871,38873,38870,38872,38906,38992,38993,38994,39096,39233,39228,39226,39439,39435,39433,39437,39428,39441,39434,39429,39431,39430,39616,39644,39688,39684,39685,39721,39733,39754,39756,39755,39879,39878,39875,39871,39873,39861,39864,39891,39862,39876,39865,39869,40284,40275,40271,40266,40283,40267,40281,40278,40268,40279,40274,40276,40287,40280,40282,40590,40588,40671,40705,40704,40726,40741,40747,40746,40745,40744,40780,40789,20788,20789,21142,21239,21428,22187,22189,22182,22183,22186,22188,22746,22749,22747,22802,23357,23358,23359,24003,24176,24511,25083,25863,25872,25869,25865,25868,25870,25988,26078,26077,26334,27367,27360,27340,27345,27353,27339,27359,27356,27344,27371,27343,27341,27358,27488,27568,27660,28697,28711,28704,28694,28715,28705,28706,28707,28713,28695,28708,28700,28714,29196,29194,29191,29186,29189,29349,29350,29348,29347,29345,29899,29893,29879,29891,29974,30304,30665,30666,30660,30705,31005,31003,31009,31004,30999,31006,31152,31335,31336,31795,31804,31801,31788,31803,31980,31978,32374,32373,32376,32368,32375,32367,32378,32370,32372,32360,32587,32586,32643,32646,32695,32765,32766,32888,33239,33237,33380,33377,33379,34283,34289,34285,34265,34273,34280,34266,34263,34284,34290,34296,34264,34271,34275,34268,34257,34288,34278,34287,34270,34274,34816,34810,34819,34806,34807,34825,34828,34827,34822,34812,34824,34815,34826,34818,35170,35162,35163,35159,35169,35164,35160,35165,35161,35208,35255,35254,35318,35664,35656,35658,35648,35667,35670,35668,35659,35669,35665,35650,35666,35671,35907,35959,35958,35994,36102,36103,36105,36268,36266,36269,36267,36461,36472,36467,36458,36463,36475,36546,36690,36689,36687,36688,36691,36788,37184,37183,37296,37293,37854,37831,37839,37826,37850,37840,37881,37868,37836,37849,37801,37862,37834,37844,37870,37859,37845,37828,37838,37824,37842,37863,38269,38362,38363,38625,38697,38699,38700,38696,38694,38835,38839,38838,38877,38878,38879,39004,39001,39005,38999,39103,39101,39099,39102,39240,39239,39235,39334,39335,39450,39445,39461,39453,39460,39451,39458,39456,39463,39459,39454,39452,39444,39618,39691,39690,39694,39692,39735,39914,39915,39904,39902,39908,39910,39906,39920,39892,39895,39916,39900,39897,39909,39893,39905,39898,40311,40321,40330,40324,40328,40305,40320,40312,40326,40331,40332,40317,40299,40308,40309,40304,40297,40325,40307,40315,40322,40303,40313,40319,40327,40296,40596,40593,40640,40700,40749,40768,40769,40781,40790,40791,40792,21303,22194,22197,22195,22755,23365,24006,24007,24302,24303,24512,24513,25081,25879,25878,25877,25875,26079,26344,26339,26340,27379,27376,27370,27368,27385,27377,27374,27375,28732,28725,28719,28727,28724,28721,28738,28728,28735,28730,28729,28736,28731,28723,28737,29203,29204,29352,29565,29564,29882,30379,30378,30398,30445,30668,30670,30671,30669,30706,31013,31011,31015,31016,31012,31017,31154,31342,31340,31341,31479,31817,31816,31818,31815,31813,31982,32379,32382,32385,32384,32698,32767,32889,33243,33241,33291,33384,33385,34338,34303,34305,34302,34331,34304,34294,34308,34313,34309,34316,34301,34841,34832,34833,34839,34835,34838,35171,35174,35257,35319,35680,35690,35677,35688,35683,35685,35687,35693,36270,36486,36488,36484,36697,36694,36695,36693,36696,36698,37005,37187,37185,37303,37301,37298,37299,37899,37907,37883,37920,37903,37908,37886,37909,37904,37928,37913,37901,37877,37888,37879,37895,37902,37910,37906,37882,37897,37880,37898,37887,37884,37900,37878,37905,37894,38366,38368,38367,38702,38703,38841,38843,38909,38910,39008,39010,39011,39007,39105,39106,39248,39246,39257,39244,39243,39251,39474,39476,39473,39468,39466,39478,39465,39470,39480,39469,39623,39626,39622,39696,39698,39697,39947,39944,39927,39941,39954,39928,40000,39943,39950,39942,39959,39956,39945,40351,40345,40356,40349,40338,40344,40336,40347,40352,40340,40348,40362,40343,40353,40346,40354,40360,40350,40355,40383,40361,40342,40358,40359,40601,40603,40602,40677,40676,40679,40678,40752,40750,40795,40800,40798,40797,40793,40849,20794,20793,21144,21143,22211,22205,22206,23368,23367,24011,24015,24305,25085,25883,27394,27388,27395,27384,27392,28739,28740,28746,28744,28745,28741,28742,29213,29210,29209,29566,29975,30314,30672,31021,31025,31023,31828,31827,31986,32394,32391,32392,32395,32390,32397,32589,32699,32816,33245,34328,34346,34342,34335,34339,34332,34329,34343,34350,34337,34336,34345,34334,34341,34857,34845,34843,34848,34852,34844,34859,34890,35181,35177,35182,35179,35322,35705,35704,35653,35706,35707,36112,36116,36271,36494,36492,36702,36699,36701,37190,37188,37189,37305,37951,37947,37942,37929,37949,37948,37936,37945,37930,37943,37932,37952,37937,38373,38372,38371,38709,38714,38847,38881,39012,39113,39110,39104,39256,39254,39481,39485,39494,39492,39490,39489,39482,39487,39629,39701,39703,39704,39702,39738,39762,39979,39965,39964,39980,39971,39976,39977,39972,39969,40375,40374,40380,40385,40391,40394,40399,40382,40389,40387,40379,40373,40398,40377,40378,40364,40392,40369,40365,40396,40371,40397,40370,40570,40604,40683,40686,40685,40731,40728,40730,40753,40782,40805,40804,40850,20153,22214,22213,22219,22897,23371,23372,24021,24017,24306,25889,25888,25894,25890,27403,27400,27401,27661,28757,28758,28759,28754,29214,29215,29353,29567,29912,29909,29913,29911,30317,30381,31029,31156,31344,31345,31831,31836,31833,31835,31834,31988,31985,32401,32591,32647,33246,33387,34356,34357,34355,34348,34354,34358,34860,34856,34854,34858,34853,35185,35263,35262,35323,35710,35716,35714,35718,35717,35711,36117,36501,36500,36506,36498,36496,36502,36503,36704,36706,37191,37964,37968,37962,37963,37967,37959,37957,37960,37961,37958,38719,38883,39018,39017,39115,39252,39259,39502,39507,39508,39500,39503,39496,39498,39497,39506,39504,39632,39705,39723,39739,39766,39765,40006,40008,39999,40004,39993,39987,40001,39996,39991,39988,39986,39997,39990,40411,40402,40414,40410,40395,40400,40412,40401,40415,40425,40409,40408,40406,40437,40405,40413,40630,40688,40757,40755,40754,40770,40811,40853,40866,20797,21145,22760,22759,22898,23373,24024,34863,24399,25089,25091,25092,25897,25893,26006,26347,27409,27410,27407,27594,28763,28762,29218,29570,29569,29571,30320,30676,31847,31846,32405,33388,34362,34368,34361,34364,34353,34363,34366,34864,34866,34862,34867,35190,35188,35187,35326,35724,35726,35723,35720,35909,36121,36504,36708,36707,37308,37986,37973,37981,37975,37982,38852,38853,38912,39510,39513,39710,39711,39712,40018,40024,40016,40010,40013,40011,40021,40025,40012,40014,40443,40439,40431,40419,40427,40440,40420,40438,40417,40430,40422,40434,40432,40418,40428,40436,40435,40424,40429,40642,40656,40690,40691,40710,40732,40760,40759,40758,40771,40783,40817,40816,40814,40815,22227,22221,23374,23661,25901,26349,26350,27411,28767,28769,28765,28768,29219,29915,29925,30677,31032,31159,31158,31850,32407,32649,33389,34371,34872,34871,34869,34891,35732,35733,36510,36511,36512,36509,37310,37309,37314,37995,37992,37993,38629,38726,38723,38727,38855,38885,39518,39637,39769,40035,40039,40038,40034,40030,40032,40450,40446,40455,40451,40454,40453,40448,40449,40457,40447,40445,40452,40608,40734,40774,40820,40821,40822,22228,25902,26040,27416,27417,27415,27418,28770,29222,29354,30680,30681,31033,31849,31851,31990,32410,32408,32411,32409,33248,33249,34374,34375,34376,35193,35194,35196,35195,35327,35736,35737,36517,36516,36515,37998,37997,37999,38001,38003,38729,39026,39263,40040,40046,40045,40459,40461,40464,40463,40466,40465,40609,40693,40713,40775,40824,40827,40826,40825,22302,28774,31855,34876,36274,36518,37315,38004,38008,38006,38005,39520,40052,40051,40049,40053,40468,40467,40694,40714,40868,28776,28773,31991,34410,34878,34877,34879,35742,35996,36521,36553,38731,39027,39028,39116,39265,39339,39524,39526,39527,39716,40469,40471,40776,25095,27422,29223,34380,36520,38018,38016,38017,39529,39528,39726,40473,29225,34379,35743,38019,40057,40631,30325,39531,40058,40477,28777,28778,40612,40830,40777,40856,30849,37561,35023,22715,24658,31911,23290,9556,9574,9559,9568,9580,9571,9562,9577,9565,9554,9572,9557,9566,9578,9569,9560,9575,9563,9555,9573,9558,9567,9579,9570,9561,9576,9564,9553,9552,9581,9582,9584,9583,65517,132423,37595,132575,147397,34124,17077,29679,20917,13897,149826,166372,37700,137691,33518,146632,30780,26436,25311,149811,166314,131744,158643,135941,20395,140525,20488,159017,162436,144896,150193,140563,20521,131966,24484,131968,131911,28379,132127,20605,20737,13434,20750,39020,14147,33814,149924,132231,20832,144308,20842,134143,139516,131813,140592,132494,143923,137603,23426,34685,132531,146585,20914,20920,40244,20937,20943,20945,15580,20947,150182,20915,20962,21314,20973,33741,26942,145197,24443,21003,21030,21052,21173,21079,21140,21177,21189,31765,34114,21216,34317,158483,21253,166622,21833,28377,147328,133460,147436,21299,21316,134114,27851,136998,26651,29653,24650,16042,14540,136936,29149,17570,21357,21364,165547,21374,21375,136598,136723,30694,21395,166555,21408,21419,21422,29607,153458,16217,29596,21441,21445,27721,20041,22526,21465,15019,134031,21472,147435,142755,21494,134263,21523,28793,21803,26199,27995,21613,158547,134516,21853,21647,21668,18342,136973,134877,15796,134477,166332,140952,21831,19693,21551,29719,21894,21929,22021,137431,147514,17746,148533,26291,135348,22071,26317,144010,26276,26285,22093,22095,30961,22257,38791,21502,22272,22255,22253,166758,13859,135759,22342,147877,27758,28811,22338,14001,158846,22502,136214,22531,136276,148323,22566,150517,22620,22698,13665,22752,22748,135740,22779,23551,22339,172368,148088,37843,13729,22815,26790,14019,28249,136766,23076,21843,136850,34053,22985,134478,158849,159018,137180,23001,137211,137138,159142,28017,137256,136917,23033,159301,23211,23139,14054,149929,23159,14088,23190,29797,23251,159649,140628,15749,137489,14130,136888,24195,21200,23414,25992,23420,162318,16388,18525,131588,23509,24928,137780,154060,132517,23539,23453,19728,23557,138052,23571,29646,23572,138405,158504,23625,18653,23685,23785,23791,23947,138745,138807,23824,23832,23878,138916,23738,24023,33532,14381,149761,139337,139635,33415,14390,15298,24110,27274,24181,24186,148668,134355,21414,20151,24272,21416,137073,24073,24308,164994,24313,24315,14496,24316,26686,37915,24333,131521,194708,15070,18606,135994,24378,157832,140240,24408,140401,24419,38845,159342,24434,37696,166454,24487,23990,15711,152144,139114,159992,140904,37334,131742,166441,24625,26245,137335,14691,15815,13881,22416,141236,31089,15936,24734,24740,24755,149890,149903,162387,29860,20705,23200,24932,33828,24898,194726,159442,24961,20980,132694,24967,23466,147383,141407,25043,166813,170333,25040,14642,141696,141505,24611,24924,25886,25483,131352,25285,137072,25301,142861,25452,149983,14871,25656,25592,136078,137212,25744,28554,142902,38932,147596,153373,25825,25829,38011,14950,25658,14935,25933,28438,150056,150051,25989,25965,25951,143486,26037,149824,19255,26065,16600,137257,26080,26083,24543,144384,26136,143863,143864,26180,143780,143781,26187,134773,26215,152038,26227,26228,138813,143921,165364,143816,152339,30661,141559,39332,26370,148380,150049,15147,27130,145346,26462,26471,26466,147917,168173,26583,17641,26658,28240,37436,26625,144358,159136,26717,144495,27105,27147,166623,26995,26819,144845,26881,26880,15666,14849,144956,15232,26540,26977,166474,17148,26934,27032,15265,132041,33635,20624,27129,144985,139562,27205,145155,27293,15347,26545,27336,168348,15373,27421,133411,24798,27445,27508,141261,28341,146139,132021,137560,14144,21537,146266,27617,147196,27612,27703,140427,149745,158545,27738,33318,27769,146876,17605,146877,147876,149772,149760,146633,14053,15595,134450,39811,143865,140433,32655,26679,159013,159137,159211,28054,27996,28284,28420,149887,147589,159346,34099,159604,20935,27804,28189,33838,166689,28207,146991,29779,147330,31180,28239,23185,143435,28664,14093,28573,146992,28410,136343,147517,17749,37872,28484,28508,15694,28532,168304,15675,28575,147780,28627,147601,147797,147513,147440,147380,147775,20959,147798,147799,147776,156125,28747,28798,28839,28801,28876,28885,28886,28895,16644,15848,29108,29078,148087,28971,28997,23176,29002,29038,23708,148325,29007,37730,148161,28972,148570,150055,150050,29114,166888,28861,29198,37954,29205,22801,37955,29220,37697,153093,29230,29248,149876,26813,29269,29271,15957,143428,26637,28477,29314,29482,29483,149539,165931,18669,165892,29480,29486,29647,29610,134202,158254,29641,29769,147938,136935,150052,26147,14021,149943,149901,150011,29687,29717,26883,150054,29753,132547,16087,29788,141485,29792,167602,29767,29668,29814,33721,29804,14128,29812,37873,27180,29826,18771,150156,147807,150137,166799,23366,166915,137374,29896,137608,29966,29929,29982,167641,137803,23511,167596,37765,30029,30026,30055,30062,151426,16132,150803,30094,29789,30110,30132,30210,30252,30289,30287,30319,30326,156661,30352,33263,14328,157969,157966,30369,30373,30391,30412,159647,33890,151709,151933,138780,30494,30502,30528,25775,152096,30552,144044,30639,166244,166248,136897,30708,30729,136054,150034,26826,30895,30919,30931,38565,31022,153056,30935,31028,30897,161292,36792,34948,166699,155779,140828,31110,35072,26882,31104,153687,31133,162617,31036,31145,28202,160038,16040,31174,168205,31188],
    "euc-kr":[44034,44035,44037,44038,44043,44044,44045,44046,44047,44056,44062,44063,44065,44066,44067,44069,44070,44071,44072,44073,44074,44075,44078,44082,44083,44084,null,null,null,null,null,null,44085,44086,44087,44090,44091,44093,44094,44095,44097,44098,44099,44100,44101,44102,44103,44104,44105,44106,44108,44110,44111,44112,44113,44114,44115,44117,null,null,null,null,null,null,44118,44119,44121,44122,44123,44125,44126,44127,44128,44129,44130,44131,44132,44133,44134,44135,44136,44137,44138,44139,44140,44141,44142,44143,44146,44147,44149,44150,44153,44155,44156,44157,44158,44159,44162,44167,44168,44173,44174,44175,44177,44178,44179,44181,44182,44183,44184,44185,44186,44187,44190,44194,44195,44196,44197,44198,44199,44203,44205,44206,44209,44210,44211,44212,44213,44214,44215,44218,44222,44223,44224,44226,44227,44229,44230,44231,44233,44234,44235,44237,44238,44239,44240,44241,44242,44243,44244,44246,44248,44249,44250,44251,44252,44253,44254,44255,44258,44259,44261,44262,44265,44267,44269,44270,44274,44276,44279,44280,44281,44282,44283,44286,44287,44289,44290,44291,44293,44295,44296,44297,44298,44299,44302,44304,44306,44307,44308,44309,44310,44311,44313,44314,44315,44317,44318,44319,44321,44322,44323,44324,44325,44326,44327,44328,44330,44331,44334,44335,44336,44337,44338,44339,null,null,null,null,null,null,44342,44343,44345,44346,44347,44349,44350,44351,44352,44353,44354,44355,44358,44360,44362,44363,44364,44365,44366,44367,44369,44370,44371,44373,44374,44375,null,null,null,null,null,null,44377,44378,44379,44380,44381,44382,44383,44384,44386,44388,44389,44390,44391,44392,44393,44394,44395,44398,44399,44401,44402,44407,44408,44409,44410,44414,44416,44419,44420,44421,44422,44423,44426,44427,44429,44430,44431,44433,44434,44435,44436,44437,44438,44439,44440,44441,44442,44443,44446,44447,44448,44449,44450,44451,44453,44454,44455,44456,44457,44458,44459,44460,44461,44462,44463,44464,44465,44466,44467,44468,44469,44470,44472,44473,44474,44475,44476,44477,44478,44479,44482,44483,44485,44486,44487,44489,44490,44491,44492,44493,44494,44495,44498,44500,44501,44502,44503,44504,44505,44506,44507,44509,44510,44511,44513,44514,44515,44517,44518,44519,44520,44521,44522,44523,44524,44525,44526,44527,44528,44529,44530,44531,44532,44533,44534,44535,44538,44539,44541,44542,44546,44547,44548,44549,44550,44551,44554,44556,44558,44559,44560,44561,44562,44563,44565,44566,44567,44568,44569,44570,44571,44572,null,null,null,null,null,null,44573,44574,44575,44576,44577,44578,44579,44580,44581,44582,44583,44584,44585,44586,44587,44588,44589,44590,44591,44594,44595,44597,44598,44601,44603,44604,null,null,null,null,null,null,44605,44606,44607,44610,44612,44615,44616,44617,44619,44623,44625,44626,44627,44629,44631,44632,44633,44634,44635,44638,44642,44643,44644,44646,44647,44650,44651,44653,44654,44655,44657,44658,44659,44660,44661,44662,44663,44666,44670,44671,44672,44673,44674,44675,44678,44679,44680,44681,44682,44683,44685,44686,44687,44688,44689,44690,44691,44692,44693,44694,44695,44696,44697,44698,44699,44700,44701,44702,44703,44704,44705,44706,44707,44708,44709,44710,44711,44712,44713,44714,44715,44716,44717,44718,44719,44720,44721,44722,44723,44724,44725,44726,44727,44728,44729,44730,44731,44735,44737,44738,44739,44741,44742,44743,44744,44745,44746,44747,44750,44754,44755,44756,44757,44758,44759,44762,44763,44765,44766,44767,44768,44769,44770,44771,44772,44773,44774,44775,44777,44778,44780,44782,44783,44784,44785,44786,44787,44789,44790,44791,44793,44794,44795,44797,44798,44799,44800,44801,44802,44803,44804,44805,null,null,null,null,null,null,44806,44809,44810,44811,44812,44814,44815,44817,44818,44819,44820,44821,44822,44823,44824,44825,44826,44827,44828,44829,44830,44831,44832,44833,44834,44835,null,null,null,null,null,null,44836,44837,44838,44839,44840,44841,44842,44843,44846,44847,44849,44851,44853,44854,44855,44856,44857,44858,44859,44862,44864,44868,44869,44870,44871,44874,44875,44876,44877,44878,44879,44881,44882,44883,44884,44885,44886,44887,44888,44889,44890,44891,44894,44895,44896,44897,44898,44899,44902,44903,44904,44905,44906,44907,44908,44909,44910,44911,44912,44913,44914,44915,44916,44917,44918,44919,44920,44922,44923,44924,44925,44926,44927,44929,44930,44931,44933,44934,44935,44937,44938,44939,44940,44941,44942,44943,44946,44947,44948,44950,44951,44952,44953,44954,44955,44957,44958,44959,44960,44961,44962,44963,44964,44965,44966,44967,44968,44969,44970,44971,44972,44973,44974,44975,44976,44977,44978,44979,44980,44981,44982,44983,44986,44987,44989,44990,44991,44993,44994,44995,44996,44997,44998,45002,45004,45007,45008,45009,45010,45011,45013,45014,45015,45016,45017,45018,45019,45021,45022,45023,45024,45025,null,null,null,null,null,null,45026,45027,45028,45029,45030,45031,45034,45035,45036,45037,45038,45039,45042,45043,45045,45046,45047,45049,45050,45051,45052,45053,45054,45055,45058,45059,null,null,null,null,null,null,45061,45062,45063,45064,45065,45066,45067,45069,45070,45071,45073,45074,45075,45077,45078,45079,45080,45081,45082,45083,45086,45087,45088,45089,45090,45091,45092,45093,45094,45095,45097,45098,45099,45100,45101,45102,45103,45104,45105,45106,45107,45108,45109,45110,45111,45112,45113,45114,45115,45116,45117,45118,45119,45120,45121,45122,45123,45126,45127,45129,45131,45133,45135,45136,45137,45138,45142,45144,45146,45147,45148,45150,45151,45152,45153,45154,45155,45156,45157,45158,45159,45160,45161,45162,45163,45164,45165,45166,45167,45168,45169,45170,45171,45172,45173,45174,45175,45176,45177,45178,45179,45182,45183,45185,45186,45187,45189,45190,45191,45192,45193,45194,45195,45198,45200,45202,45203,45204,45205,45206,45207,45211,45213,45214,45219,45220,45221,45222,45223,45226,45232,45234,45238,45239,45241,45242,45243,45245,45246,45247,45248,45249,45250,45251,45254,45258,45259,45260,45261,45262,45263,45266,null,null,null,null,null,null,45267,45269,45270,45271,45273,45274,45275,45276,45277,45278,45279,45281,45282,45283,45284,45286,45287,45288,45289,45290,45291,45292,45293,45294,45295,45296,null,null,null,null,null,null,45297,45298,45299,45300,45301,45302,45303,45304,45305,45306,45307,45308,45309,45310,45311,45312,45313,45314,45315,45316,45317,45318,45319,45322,45325,45326,45327,45329,45332,45333,45334,45335,45338,45342,45343,45344,45345,45346,45350,45351,45353,45354,45355,45357,45358,45359,45360,45361,45362,45363,45366,45370,45371,45372,45373,45374,45375,45378,45379,45381,45382,45383,45385,45386,45387,45388,45389,45390,45391,45394,45395,45398,45399,45401,45402,45403,45405,45406,45407,45409,45410,45411,45412,45413,45414,45415,45416,45417,45418,45419,45420,45421,45422,45423,45424,45425,45426,45427,45428,45429,45430,45431,45434,45435,45437,45438,45439,45441,45443,45444,45445,45446,45447,45450,45452,45454,45455,45456,45457,45461,45462,45463,45465,45466,45467,45469,45470,45471,45472,45473,45474,45475,45476,45477,45478,45479,45481,45482,45483,45484,45485,45486,45487,45488,45489,45490,45491,45492,45493,45494,45495,45496,null,null,null,null,null,null,45497,45498,45499,45500,45501,45502,45503,45504,45505,45506,45507,45508,45509,45510,45511,45512,45513,45514,45515,45517,45518,45519,45521,45522,45523,45525,null,null,null,null,null,null,45526,45527,45528,45529,45530,45531,45534,45536,45537,45538,45539,45540,45541,45542,45543,45546,45547,45549,45550,45551,45553,45554,45555,45556,45557,45558,45559,45560,45562,45564,45566,45567,45568,45569,45570,45571,45574,45575,45577,45578,45581,45582,45583,45584,45585,45586,45587,45590,45592,45594,45595,45596,45597,45598,45599,45601,45602,45603,45604,45605,45606,45607,45608,45609,45610,45611,45612,45613,45614,45615,45616,45617,45618,45619,45621,45622,45623,45624,45625,45626,45627,45629,45630,45631,45632,45633,45634,45635,45636,45637,45638,45639,45640,45641,45642,45643,45644,45645,45646,45647,45648,45649,45650,45651,45652,45653,45654,45655,45657,45658,45659,45661,45662,45663,45665,45666,45667,45668,45669,45670,45671,45674,45675,45676,45677,45678,45679,45680,45681,45682,45683,45686,45687,45688,45689,45690,45691,45693,45694,45695,45696,45697,45698,45699,45702,45703,45704,45706,45707,45708,45709,45710,null,null,null,null,null,null,45711,45714,45715,45717,45718,45719,45723,45724,45725,45726,45727,45730,45732,45735,45736,45737,45739,45741,45742,45743,45745,45746,45747,45749,45750,45751,null,null,null,null,null,null,45752,45753,45754,45755,45756,45757,45758,45759,45760,45761,45762,45763,45764,45765,45766,45767,45770,45771,45773,45774,45775,45777,45779,45780,45781,45782,45783,45786,45788,45790,45791,45792,45793,45795,45799,45801,45802,45808,45809,45810,45814,45820,45821,45822,45826,45827,45829,45830,45831,45833,45834,45835,45836,45837,45838,45839,45842,45846,45847,45848,45849,45850,45851,45853,45854,45855,45856,45857,45858,45859,45860,45861,45862,45863,45864,45865,45866,45867,45868,45869,45870,45871,45872,45873,45874,45875,45876,45877,45878,45879,45880,45881,45882,45883,45884,45885,45886,45887,45888,45889,45890,45891,45892,45893,45894,45895,45896,45897,45898,45899,45900,45901,45902,45903,45904,45905,45906,45907,45911,45913,45914,45917,45920,45921,45922,45923,45926,45928,45930,45932,45933,45935,45938,45939,45941,45942,45943,45945,45946,45947,45948,45949,45950,45951,45954,45958,45959,45960,45961,45962,45963,45965,null,null,null,null,null,null,45966,45967,45969,45970,45971,45973,45974,45975,45976,45977,45978,45979,45980,45981,45982,45983,45986,45987,45988,45989,45990,45991,45993,45994,45995,45997,null,null,null,null,null,null,45998,45999,46000,46001,46002,46003,46004,46005,46006,46007,46008,46009,46010,46011,46012,46013,46014,46015,46016,46017,46018,46019,46022,46023,46025,46026,46029,46031,46033,46034,46035,46038,46040,46042,46044,46046,46047,46049,46050,46051,46053,46054,46055,46057,46058,46059,46060,46061,46062,46063,46064,46065,46066,46067,46068,46069,46070,46071,46072,46073,46074,46075,46077,46078,46079,46080,46081,46082,46083,46084,46085,46086,46087,46088,46089,46090,46091,46092,46093,46094,46095,46097,46098,46099,46100,46101,46102,46103,46105,46106,46107,46109,46110,46111,46113,46114,46115,46116,46117,46118,46119,46122,46124,46125,46126,46127,46128,46129,46130,46131,46133,46134,46135,46136,46137,46138,46139,46140,46141,46142,46143,46144,46145,46146,46147,46148,46149,46150,46151,46152,46153,46154,46155,46156,46157,46158,46159,46162,46163,46165,46166,46167,46169,46170,46171,46172,46173,46174,46175,46178,46180,46182,null,null,null,null,null,null,46183,46184,46185,46186,46187,46189,46190,46191,46192,46193,46194,46195,46196,46197,46198,46199,46200,46201,46202,46203,46204,46205,46206,46207,46209,46210,null,null,null,null,null,null,46211,46212,46213,46214,46215,46217,46218,46219,46220,46221,46222,46223,46224,46225,46226,46227,46228,46229,46230,46231,46232,46233,46234,46235,46236,46238,46239,46240,46241,46242,46243,46245,46246,46247,46249,46250,46251,46253,46254,46255,46256,46257,46258,46259,46260,46262,46264,46266,46267,46268,46269,46270,46271,46273,46274,46275,46277,46278,46279,46281,46282,46283,46284,46285,46286,46287,46289,46290,46291,46292,46294,46295,46296,46297,46298,46299,46302,46303,46305,46306,46309,46311,46312,46313,46314,46315,46318,46320,46322,46323,46324,46325,46326,46327,46329,46330,46331,46332,46333,46334,46335,46336,46337,46338,46339,46340,46341,46342,46343,46344,46345,46346,46347,46348,46349,46350,46351,46352,46353,46354,46355,46358,46359,46361,46362,46365,46366,46367,46368,46369,46370,46371,46374,46379,46380,46381,46382,46383,46386,46387,46389,46390,46391,46393,46394,46395,46396,46397,46398,46399,46402,46406,null,null,null,null,null,null,46407,46408,46409,46410,46414,46415,46417,46418,46419,46421,46422,46423,46424,46425,46426,46427,46430,46434,46435,46436,46437,46438,46439,46440,46441,46442,null,null,null,null,null,null,46443,46444,46445,46446,46447,46448,46449,46450,46451,46452,46453,46454,46455,46456,46457,46458,46459,46460,46461,46462,46463,46464,46465,46466,46467,46468,46469,46470,46471,46472,46473,46474,46475,46476,46477,46478,46479,46480,46481,46482,46483,46484,46485,46486,46487,46488,46489,46490,46491,46492,46493,46494,46495,46498,46499,46501,46502,46503,46505,46508,46509,46510,46511,46514,46518,46519,46520,46521,46522,46526,46527,46529,46530,46531,46533,46534,46535,46536,46537,46538,46539,46542,46546,46547,46548,46549,46550,46551,46553,46554,46555,46556,46557,46558,46559,46560,46561,46562,46563,46564,46565,46566,46567,46568,46569,46570,46571,46573,46574,46575,46576,46577,46578,46579,46580,46581,46582,46583,46584,46585,46586,46587,46588,46589,46590,46591,46592,46593,46594,46595,46596,46597,46598,46599,46600,46601,46602,46603,46604,46605,46606,46607,46610,46611,46613,46614,46615,46617,46618,46619,46620,46621,null,null,null,null,null,null,46622,46623,46624,46625,46626,46627,46628,46630,46631,46632,46633,46634,46635,46637,46638,46639,46640,46641,46642,46643,46645,46646,46647,46648,46649,46650,null,null,null,null,null,null,46651,46652,46653,46654,46655,46656,46657,46658,46659,46660,46661,46662,46663,46665,46666,46667,46668,46669,46670,46671,46672,46673,46674,46675,46676,46677,46678,46679,46680,46681,46682,46683,46684,46685,46686,46687,46688,46689,46690,46691,46693,46694,46695,46697,46698,46699,46700,46701,46702,46703,46704,46705,46706,46707,46708,46709,46710,46711,46712,46713,46714,46715,46716,46717,46718,46719,46720,46721,46722,46723,46724,46725,46726,46727,46728,46729,46730,46731,46732,46733,46734,46735,46736,46737,46738,46739,46740,46741,46742,46743,46744,46745,46746,46747,46750,46751,46753,46754,46755,46757,46758,46759,46760,46761,46762,46765,46766,46767,46768,46770,46771,46772,46773,46774,46775,46776,46777,46778,46779,46780,46781,46782,46783,46784,46785,46786,46787,46788,46789,46790,46791,46792,46793,46794,46795,46796,46797,46798,46799,46800,46801,46802,46803,46805,46806,46807,46808,46809,46810,46811,46812,46813,null,null,null,null,null,null,46814,46815,46816,46817,46818,46819,46820,46821,46822,46823,46824,46825,46826,46827,46828,46829,46830,46831,46833,46834,46835,46837,46838,46839,46841,46842,null,null,null,null,null,null,46843,46844,46845,46846,46847,46850,46851,46852,46854,46855,46856,46857,46858,46859,46860,46861,46862,46863,46864,46865,46866,46867,46868,46869,46870,46871,46872,46873,46874,46875,46876,46877,46878,46879,46880,46881,46882,46883,46884,46885,46886,46887,46890,46891,46893,46894,46897,46898,46899,46900,46901,46902,46903,46906,46908,46909,46910,46911,46912,46913,46914,46915,46917,46918,46919,46921,46922,46923,46925,46926,46927,46928,46929,46930,46931,46934,46935,46936,46937,46938,46939,46940,46941,46942,46943,46945,46946,46947,46949,46950,46951,46953,46954,46955,46956,46957,46958,46959,46962,46964,46966,46967,46968,46969,46970,46971,46974,46975,46977,46978,46979,46981,46982,46983,46984,46985,46986,46987,46990,46995,46996,46997,47002,47003,47005,47006,47007,47009,47010,47011,47012,47013,47014,47015,47018,47022,47023,47024,47025,47026,47027,47030,47031,47033,47034,47035,47036,47037,47038,47039,47040,47041,null,null,null,null,null,null,47042,47043,47044,47045,47046,47048,47050,47051,47052,47053,47054,47055,47056,47057,47058,47059,47060,47061,47062,47063,47064,47065,47066,47067,47068,47069,null,null,null,null,null,null,47070,47071,47072,47073,47074,47075,47076,47077,47078,47079,47080,47081,47082,47083,47086,47087,47089,47090,47091,47093,47094,47095,47096,47097,47098,47099,47102,47106,47107,47108,47109,47110,47114,47115,47117,47118,47119,47121,47122,47123,47124,47125,47126,47127,47130,47132,47134,47135,47136,47137,47138,47139,47142,47143,47145,47146,47147,47149,47150,47151,47152,47153,47154,47155,47158,47162,47163,47164,47165,47166,47167,47169,47170,47171,47173,47174,47175,47176,47177,47178,47179,47180,47181,47182,47183,47184,47186,47188,47189,47190,47191,47192,47193,47194,47195,47198,47199,47201,47202,47203,47205,47206,47207,47208,47209,47210,47211,47214,47216,47218,47219,47220,47221,47222,47223,47225,47226,47227,47229,47230,47231,47232,47233,47234,47235,47236,47237,47238,47239,47240,47241,47242,47243,47244,47246,47247,47248,47249,47250,47251,47252,47253,47254,47255,47256,47257,47258,47259,47260,47261,47262,47263,null,null,null,null,null,null,47264,47265,47266,47267,47268,47269,47270,47271,47273,47274,47275,47276,47277,47278,47279,47281,47282,47283,47285,47286,47287,47289,47290,47291,47292,47293,null,null,null,null,null,null,47294,47295,47298,47300,47302,47303,47304,47305,47306,47307,47309,47310,47311,47313,47314,47315,47317,47318,47319,47320,47321,47322,47323,47324,47326,47328,47330,47331,47332,47333,47334,47335,47338,47339,47341,47342,47343,47345,47346,47347,47348,47349,47350,47351,47354,47356,47358,47359,47360,47361,47362,47363,47365,47366,47367,47368,47369,47370,47371,47372,47373,47374,47375,47376,47377,47378,47379,47380,47381,47382,47383,47385,47386,47387,47388,47389,47390,47391,47393,47394,47395,47396,47397,47398,47399,47400,47401,47402,47403,47404,47405,47406,47407,47408,47409,47410,47411,47412,47413,47414,47415,47416,47417,47418,47419,47422,47423,47425,47426,47427,47429,47430,47431,47432,47433,47434,47435,47437,47438,47440,47442,47443,47444,47445,47446,47447,47450,47451,47453,47454,47455,47457,47458,47459,47460,47461,47462,47463,47466,47468,47470,47471,47472,47473,47474,47475,47478,47479,47481,47482,47483,47485,null,null,null,null,null,null,47486,47487,47488,47489,47490,47491,47494,47496,47499,47500,47503,47504,47505,47506,47507,47508,47509,47510,47511,47512,47513,47514,47515,47516,47517,47518,null,null,null,null,null,null,47519,47520,47521,47522,47523,47524,47525,47526,47527,47528,47529,47530,47531,47534,47535,47537,47538,47539,47541,47542,47543,47544,47545,47546,47547,47550,47552,47554,47555,47556,47557,47558,47559,47562,47563,47565,47571,47572,47573,47574,47575,47578,47580,47583,47584,47586,47590,47591,47593,47594,47595,47597,47598,47599,47600,47601,47602,47603,47606,47611,47612,47613,47614,47615,47618,47619,47620,47621,47622,47623,47625,47626,47627,47628,47629,47630,47631,47632,47633,47634,47635,47636,47638,47639,47640,47641,47642,47643,47644,47645,47646,47647,47648,47649,47650,47651,47652,47653,47654,47655,47656,47657,47658,47659,47660,47661,47662,47663,47664,47665,47666,47667,47668,47669,47670,47671,47674,47675,47677,47678,47679,47681,47683,47684,47685,47686,47687,47690,47692,47695,47696,47697,47698,47702,47703,47705,47706,47707,47709,47710,47711,47712,47713,47714,47715,47718,47722,47723,47724,47725,47726,47727,null,null,null,null,null,null,47730,47731,47733,47734,47735,47737,47738,47739,47740,47741,47742,47743,47744,47745,47746,47750,47752,47753,47754,47755,47757,47758,47759,47760,47761,47762,null,null,null,null,null,null,47763,47764,47765,47766,47767,47768,47769,47770,47771,47772,47773,47774,47775,47776,47777,47778,47779,47780,47781,47782,47783,47786,47789,47790,47791,47793,47795,47796,47797,47798,47799,47802,47804,47806,47807,47808,47809,47810,47811,47813,47814,47815,47817,47818,47819,47820,47821,47822,47823,47824,47825,47826,47827,47828,47829,47830,47831,47834,47835,47836,47837,47838,47839,47840,47841,47842,47843,47844,47845,47846,47847,47848,47849,47850,47851,47852,47853,47854,47855,47856,47857,47858,47859,47860,47861,47862,47863,47864,47865,47866,47867,47869,47870,47871,47873,47874,47875,47877,47878,47879,47880,47881,47882,47883,47884,47886,47888,47890,47891,47892,47893,47894,47895,47897,47898,47899,47901,47902,47903,47905,47906,47907,47908,47909,47910,47911,47912,47914,47916,47917,47918,47919,47920,47921,47922,47923,47927,47929,47930,47935,47936,47937,47938,47939,47942,47944,47946,47947,47948,47950,47953,47954,null,null,null,null,null,null,47955,47957,47958,47959,47961,47962,47963,47964,47965,47966,47967,47968,47970,47972,47973,47974,47975,47976,47977,47978,47979,47981,47982,47983,47984,47985,null,null,null,null,null,null,47986,47987,47988,47989,47990,47991,47992,47993,47994,47995,47996,47997,47998,47999,48000,48001,48002,48003,48004,48005,48006,48007,48009,48010,48011,48013,48014,48015,48017,48018,48019,48020,48021,48022,48023,48024,48025,48026,48027,48028,48029,48030,48031,48032,48033,48034,48035,48037,48038,48039,48041,48042,48043,48045,48046,48047,48048,48049,48050,48051,48053,48054,48056,48057,48058,48059,48060,48061,48062,48063,48065,48066,48067,48069,48070,48071,48073,48074,48075,48076,48077,48078,48079,48081,48082,48084,48085,48086,48087,48088,48089,48090,48091,48092,48093,48094,48095,48096,48097,48098,48099,48100,48101,48102,48103,48104,48105,48106,48107,48108,48109,48110,48111,48112,48113,48114,48115,48116,48117,48118,48119,48122,48123,48125,48126,48129,48131,48132,48133,48134,48135,48138,48142,48144,48146,48147,48153,48154,48160,48161,48162,48163,48166,48168,48170,48171,48172,48174,48175,48178,48179,48181,null,null,null,null,null,null,48182,48183,48185,48186,48187,48188,48189,48190,48191,48194,48198,48199,48200,48202,48203,48206,48207,48209,48210,48211,48212,48213,48214,48215,48216,48217,null,null,null,null,null,null,48218,48219,48220,48222,48223,48224,48225,48226,48227,48228,48229,48230,48231,48232,48233,48234,48235,48236,48237,48238,48239,48240,48241,48242,48243,48244,48245,48246,48247,48248,48249,48250,48251,48252,48253,48254,48255,48256,48257,48258,48259,48262,48263,48265,48266,48269,48271,48272,48273,48274,48275,48278,48280,48283,48284,48285,48286,48287,48290,48291,48293,48294,48297,48298,48299,48300,48301,48302,48303,48306,48310,48311,48312,48313,48314,48315,48318,48319,48321,48322,48323,48325,48326,48327,48328,48329,48330,48331,48332,48334,48338,48339,48340,48342,48343,48345,48346,48347,48349,48350,48351,48352,48353,48354,48355,48356,48357,48358,48359,48360,48361,48362,48363,48364,48365,48366,48367,48368,48369,48370,48371,48375,48377,48378,48379,48381,48382,48383,48384,48385,48386,48387,48390,48392,48394,48395,48396,48397,48398,48399,48401,48402,48403,48405,48406,48407,48408,48409,48410,48411,48412,48413,null,null,null,null,null,null,48414,48415,48416,48417,48418,48419,48421,48422,48423,48424,48425,48426,48427,48429,48430,48431,48432,48433,48434,48435,48436,48437,48438,48439,48440,48441,null,null,null,null,null,null,48442,48443,48444,48445,48446,48447,48449,48450,48451,48452,48453,48454,48455,48458,48459,48461,48462,48463,48465,48466,48467,48468,48469,48470,48471,48474,48475,48476,48477,48478,48479,48480,48481,48482,48483,48485,48486,48487,48489,48490,48491,48492,48493,48494,48495,48496,48497,48498,48499,48500,48501,48502,48503,48504,48505,48506,48507,48508,48509,48510,48511,48514,48515,48517,48518,48523,48524,48525,48526,48527,48530,48532,48534,48535,48536,48539,48541,48542,48543,48544,48545,48546,48547,48549,48550,48551,48552,48553,48554,48555,48556,48557,48558,48559,48561,48562,48563,48564,48565,48566,48567,48569,48570,48571,48572,48573,48574,48575,48576,48577,48578,48579,48580,48581,48582,48583,48584,48585,48586,48587,48588,48589,48590,48591,48592,48593,48594,48595,48598,48599,48601,48602,48603,48605,48606,48607,48608,48609,48610,48611,48612,48613,48614,48615,48616,48618,48619,48620,48621,48622,48623,48625,null,null,null,null,null,null,48626,48627,48629,48630,48631,48633,48634,48635,48636,48637,48638,48639,48641,48642,48644,48646,48647,48648,48649,48650,48651,48654,48655,48657,48658,48659,null,null,null,null,null,null,48661,48662,48663,48664,48665,48666,48667,48670,48672,48673,48674,48675,48676,48677,48678,48679,48680,48681,48682,48683,48684,48685,48686,48687,48688,48689,48690,48691,48692,48693,48694,48695,48696,48697,48698,48699,48700,48701,48702,48703,48704,48705,48706,48707,48710,48711,48713,48714,48715,48717,48719,48720,48721,48722,48723,48726,48728,48732,48733,48734,48735,48738,48739,48741,48742,48743,48745,48747,48748,48749,48750,48751,48754,48758,48759,48760,48761,48762,48766,48767,48769,48770,48771,48773,48774,48775,48776,48777,48778,48779,48782,48786,48787,48788,48789,48790,48791,48794,48795,48796,48797,48798,48799,48800,48801,48802,48803,48804,48805,48806,48807,48809,48810,48811,48812,48813,48814,48815,48816,48817,48818,48819,48820,48821,48822,48823,48824,48825,48826,48827,48828,48829,48830,48831,48832,48833,48834,48835,48836,48837,48838,48839,48840,48841,48842,48843,48844,48845,48846,48847,48850,48851,null,null,null,null,null,null,48853,48854,48857,48858,48859,48860,48861,48862,48863,48865,48866,48870,48871,48872,48873,48874,48875,48877,48878,48879,48880,48881,48882,48883,48884,48885,null,null,null,null,null,null,48886,48887,48888,48889,48890,48891,48892,48893,48894,48895,48896,48898,48899,48900,48901,48902,48903,48906,48907,48908,48909,48910,48911,48912,48913,48914,48915,48916,48917,48918,48919,48922,48926,48927,48928,48929,48930,48931,48932,48933,48934,48935,48936,48937,48938,48939,48940,48941,48942,48943,48944,48945,48946,48947,48948,48949,48950,48951,48952,48953,48954,48955,48956,48957,48958,48959,48962,48963,48965,48966,48967,48969,48970,48971,48972,48973,48974,48975,48978,48979,48980,48982,48983,48984,48985,48986,48987,48988,48989,48990,48991,48992,48993,48994,48995,48996,48997,48998,48999,49000,49001,49002,49003,49004,49005,49006,49007,49008,49009,49010,49011,49012,49013,49014,49015,49016,49017,49018,49019,49020,49021,49022,49023,49024,49025,49026,49027,49028,49029,49030,49031,49032,49033,49034,49035,49036,49037,49038,49039,49040,49041,49042,49043,49045,49046,49047,49048,49049,49050,49051,49052,49053,null,null,null,null,null,null,49054,49055,49056,49057,49058,49059,49060,49061,49062,49063,49064,49065,49066,49067,49068,49069,49070,49071,49073,49074,49075,49076,49077,49078,49079,49080,null,null,null,null,null,null,49081,49082,49083,49084,49085,49086,49087,49088,49089,49090,49091,49092,49094,49095,49096,49097,49098,49099,49102,49103,49105,49106,49107,49109,49110,49111,49112,49113,49114,49115,49117,49118,49120,49122,49123,49124,49125,49126,49127,49128,49129,49130,49131,49132,49133,49134,49135,49136,49137,49138,49139,49140,49141,49142,49143,49144,49145,49146,49147,49148,49149,49150,49151,49152,49153,49154,49155,49156,49157,49158,49159,49160,49161,49162,49163,49164,49165,49166,49167,49168,49169,49170,49171,49172,49173,49174,49175,49176,49177,49178,49179,49180,49181,49182,49183,49184,49185,49186,49187,49188,49189,49190,49191,49192,49193,49194,49195,49196,49197,49198,49199,49200,49201,49202,49203,49204,49205,49206,49207,49208,49209,49210,49211,49213,49214,49215,49216,49217,49218,49219,49220,49221,49222,49223,49224,49225,49226,49227,49228,49229,49230,49231,49232,49234,49235,49236,49237,49238,49239,49241,49242,49243,null,null,null,null,null,null,49245,49246,49247,49249,49250,49251,49252,49253,49254,49255,49258,49259,49260,49261,49262,49263,49264,49265,49266,49267,49268,49269,49270,49271,49272,49273,null,null,null,null,null,null,49274,49275,49276,49277,49278,49279,49280,49281,49282,49283,49284,49285,49286,49287,49288,49289,49290,49291,49292,49293,49294,49295,49298,49299,49301,49302,49303,49305,49306,49307,49308,49309,49310,49311,49314,49316,49318,49319,49320,49321,49322,49323,49326,49329,49330,49335,49336,49337,49338,49339,49342,49346,49347,49348,49350,49351,49354,49355,49357,49358,49359,49361,49362,49363,49364,49365,49366,49367,49370,49374,49375,49376,49377,49378,49379,49382,49383,49385,49386,49387,49389,49390,49391,49392,49393,49394,49395,49398,49400,49402,49403,49404,49405,49406,49407,49409,49410,49411,49413,49414,49415,49417,49418,49419,49420,49421,49422,49423,49425,49426,49427,49428,49430,49431,49432,49433,49434,49435,49441,49442,49445,49448,49449,49450,49451,49454,49458,49459,49460,49461,49463,49466,49467,49469,49470,49471,49473,49474,49475,49476,49477,49478,49479,49482,49486,49487,49488,49489,49490,49491,49494,49495,null,null,null,null,null,null,49497,49498,49499,49501,49502,49503,49504,49505,49506,49507,49510,49514,49515,49516,49517,49518,49519,49521,49522,49523,49525,49526,49527,49529,49530,49531,null,null,null,null,null,null,49532,49533,49534,49535,49536,49537,49538,49539,49540,49542,49543,49544,49545,49546,49547,49551,49553,49554,49555,49557,49559,49560,49561,49562,49563,49566,49568,49570,49571,49572,49574,49575,49578,49579,49581,49582,49583,49585,49586,49587,49588,49589,49590,49591,49592,49593,49594,49595,49596,49598,49599,49600,49601,49602,49603,49605,49606,49607,49609,49610,49611,49613,49614,49615,49616,49617,49618,49619,49621,49622,49625,49626,49627,49628,49629,49630,49631,49633,49634,49635,49637,49638,49639,49641,49642,49643,49644,49645,49646,49647,49650,49652,49653,49654,49655,49656,49657,49658,49659,49662,49663,49665,49666,49667,49669,49670,49671,49672,49673,49674,49675,49678,49680,49682,49683,49684,49685,49686,49687,49690,49691,49693,49694,49697,49698,49699,49700,49701,49702,49703,49706,49708,49710,49712,49715,49717,49718,49719,49720,49721,49722,49723,49724,49725,49726,49727,49728,49729,49730,49731,49732,49733,null,null,null,null,null,null,49734,49735,49737,49738,49739,49740,49741,49742,49743,49746,49747,49749,49750,49751,49753,49754,49755,49756,49757,49758,49759,49761,49762,49763,49764,49766,null,null,null,null,null,null,49767,49768,49769,49770,49771,49774,49775,49777,49778,49779,49781,49782,49783,49784,49785,49786,49787,49790,49792,49794,49795,49796,49797,49798,49799,49802,49803,49804,49805,49806,49807,49809,49810,49811,49812,49813,49814,49815,49817,49818,49820,49822,49823,49824,49825,49826,49827,49830,49831,49833,49834,49835,49838,49839,49840,49841,49842,49843,49846,49848,49850,49851,49852,49853,49854,49855,49856,49857,49858,49859,49860,49861,49862,49863,49864,49865,49866,49867,49868,49869,49870,49871,49872,49873,49874,49875,49876,49877,49878,49879,49880,49881,49882,49883,49886,49887,49889,49890,49893,49894,49895,49896,49897,49898,49902,49904,49906,49907,49908,49909,49911,49914,49917,49918,49919,49921,49922,49923,49924,49925,49926,49927,49930,49931,49934,49935,49936,49937,49938,49942,49943,49945,49946,49947,49949,49950,49951,49952,49953,49954,49955,49958,49959,49962,49963,49964,49965,49966,49967,49968,49969,49970,null,null,null,null,null,null,49971,49972,49973,49974,49975,49976,49977,49978,49979,49980,49981,49982,49983,49984,49985,49986,49987,49988,49990,49991,49992,49993,49994,49995,49996,49997,null,null,null,null,null,null,49998,49999,50000,50001,50002,50003,50004,50005,50006,50007,50008,50009,50010,50011,50012,50013,50014,50015,50016,50017,50018,50019,50020,50021,50022,50023,50026,50027,50029,50030,50031,50033,50035,50036,50037,50038,50039,50042,50043,50046,50047,50048,50049,50050,50051,50053,50054,50055,50057,50058,50059,50061,50062,50063,50064,50065,50066,50067,50068,50069,50070,50071,50072,50073,50074,50075,50076,50077,50078,50079,50080,50081,50082,50083,50084,50085,50086,50087,50088,50089,50090,50091,50092,50093,50094,50095,50096,50097,50098,50099,50100,50101,50102,50103,50104,50105,50106,50107,50108,50109,50110,50111,50113,50114,50115,50116,50117,50118,50119,50120,50121,50122,50123,50124,50125,50126,50127,50128,50129,50130,50131,50132,50133,50134,50135,50138,50139,50141,50142,50145,50147,50148,50149,50150,50151,50154,50155,50156,50158,50159,50160,50161,50162,50163,50166,50167,50169,50170,50171,50172,50173,50174,null,null,null,null,null,null,50175,50176,50177,50178,50179,50180,50181,50182,50183,50185,50186,50187,50188,50189,50190,50191,50193,50194,50195,50196,50197,50198,50199,50200,50201,50202,null,null,null,null,null,null,50203,50204,50205,50206,50207,50208,50209,50210,50211,50213,50214,50215,50216,50217,50218,50219,50221,50222,50223,50225,50226,50227,50229,50230,50231,50232,50233,50234,50235,50238,50239,50240,50241,50242,50243,50244,50245,50246,50247,50249,50250,50251,50252,50253,50254,50255,50256,50257,50258,50259,50260,50261,50262,50263,50264,50265,50266,50267,50268,50269,50270,50271,50272,50273,50274,50275,50278,50279,50281,50282,50283,50285,50286,50287,50288,50289,50290,50291,50294,50295,50296,50298,50299,50300,50301,50302,50303,50305,50306,50307,50308,50309,50310,50311,50312,50313,50314,50315,50316,50317,50318,50319,50320,50321,50322,50323,50325,50326,50327,50328,50329,50330,50331,50333,50334,50335,50336,50337,50338,50339,50340,50341,50342,50343,50344,50345,50346,50347,50348,50349,50350,50351,50352,50353,50354,50355,50356,50357,50358,50359,50361,50362,50363,50365,50366,50367,50368,50369,50370,50371,50372,50373,null,null,null,null,null,null,50374,50375,50376,50377,50378,50379,50380,50381,50382,50383,50384,50385,50386,50387,50388,50389,50390,50391,50392,50393,50394,50395,50396,50397,50398,50399,null,null,null,null,null,null,50400,50401,50402,50403,50404,50405,50406,50407,50408,50410,50411,50412,50413,50414,50415,50418,50419,50421,50422,50423,50425,50427,50428,50429,50430,50434,50435,50436,50437,50438,50439,50440,50441,50442,50443,50445,50446,50447,50449,50450,50451,50453,50454,50455,50456,50457,50458,50459,50461,50462,50463,50464,50465,50466,50467,50468,50469,50470,50471,50474,50475,50477,50478,50479,50481,50482,50483,50484,50485,50486,50487,50490,50492,50494,50495,50496,50497,50498,50499,50502,50503,50507,50511,50512,50513,50514,50518,50522,50523,50524,50527,50530,50531,50533,50534,50535,50537,50538,50539,50540,50541,50542,50543,50546,50550,50551,50552,50553,50554,50555,50558,50559,50561,50562,50563,50565,50566,50568,50569,50570,50571,50574,50576,50578,50579,50580,50582,50585,50586,50587,50589,50590,50591,50593,50594,50595,50596,50597,50598,50599,50600,50602,50603,50604,50605,50606,50607,50608,50609,50610,50611,50614,null,null,null,null,null,null,50615,50618,50623,50624,50625,50626,50627,50635,50637,50639,50642,50643,50645,50646,50647,50649,50650,50651,50652,50653,50654,50655,50658,50660,50662,50663,null,null,null,null,null,null,50664,50665,50666,50667,50671,50673,50674,50675,50677,50680,50681,50682,50683,50690,50691,50692,50697,50698,50699,50701,50702,50703,50705,50706,50707,50708,50709,50710,50711,50714,50717,50718,50719,50720,50721,50722,50723,50726,50727,50729,50730,50731,50735,50737,50738,50742,50744,50746,50748,50749,50750,50751,50754,50755,50757,50758,50759,50761,50762,50763,50764,50765,50766,50767,50770,50774,50775,50776,50777,50778,50779,50782,50783,50785,50786,50787,50788,50789,50790,50791,50792,50793,50794,50795,50797,50798,50800,50802,50803,50804,50805,50806,50807,50810,50811,50813,50814,50815,50817,50818,50819,50820,50821,50822,50823,50826,50828,50830,50831,50832,50833,50834,50835,50838,50839,50841,50842,50843,50845,50846,50847,50848,50849,50850,50851,50854,50856,50858,50859,50860,50861,50862,50863,50866,50867,50869,50870,50871,50875,50876,50877,50878,50879,50882,50884,50886,50887,50888,50889,50890,50891,50894,null,null,null,null,null,null,50895,50897,50898,50899,50901,50902,50903,50904,50905,50906,50907,50910,50911,50914,50915,50916,50917,50918,50919,50922,50923,50925,50926,50927,50929,50930,null,null,null,null,null,null,50931,50932,50933,50934,50935,50938,50939,50940,50942,50943,50944,50945,50946,50947,50950,50951,50953,50954,50955,50957,50958,50959,50960,50961,50962,50963,50966,50968,50970,50971,50972,50973,50974,50975,50978,50979,50981,50982,50983,50985,50986,50987,50988,50989,50990,50991,50994,50996,50998,51000,51001,51002,51003,51006,51007,51009,51010,51011,51013,51014,51015,51016,51017,51019,51022,51024,51033,51034,51035,51037,51038,51039,51041,51042,51043,51044,51045,51046,51047,51049,51050,51052,51053,51054,51055,51056,51057,51058,51059,51062,51063,51065,51066,51067,51071,51072,51073,51074,51078,51083,51084,51085,51087,51090,51091,51093,51097,51099,51100,51101,51102,51103,51106,51111,51112,51113,51114,51115,51118,51119,51121,51122,51123,51125,51126,51127,51128,51129,51130,51131,51134,51138,51139,51140,51141,51142,51143,51146,51147,51149,51151,51153,51154,51155,51156,51157,51158,51159,51161,51162,51163,51164,null,null,null,null,null,null,51166,51167,51168,51169,51170,51171,51173,51174,51175,51177,51178,51179,51181,51182,51183,51184,51185,51186,51187,51188,51189,51190,51191,51192,51193,51194,null,null,null,null,null,null,51195,51196,51197,51198,51199,51202,51203,51205,51206,51207,51209,51211,51212,51213,51214,51215,51218,51220,51223,51224,51225,51226,51227,51230,51231,51233,51234,51235,51237,51238,51239,51240,51241,51242,51243,51246,51248,51250,51251,51252,51253,51254,51255,51257,51258,51259,51261,51262,51263,51265,51266,51267,51268,51269,51270,51271,51274,51275,51278,51279,51280,51281,51282,51283,51285,51286,51287,51288,51289,51290,51291,51292,51293,51294,51295,51296,51297,51298,51299,51300,51301,51302,51303,51304,51305,51306,51307,51308,51309,51310,51311,51314,51315,51317,51318,51319,51321,51323,51324,51325,51326,51327,51330,51332,51336,51337,51338,51342,51343,51344,51345,51346,51347,51349,51350,51351,51352,51353,51354,51355,51356,51358,51360,51362,51363,51364,51365,51366,51367,51369,51370,51371,51372,51373,51374,51375,51376,51377,51378,51379,51380,51381,51382,51383,51384,51385,51386,51387,51390,51391,51392,51393,null,null,null,null,null,null,51394,51395,51397,51398,51399,51401,51402,51403,51405,51406,51407,51408,51409,51410,51411,51414,51416,51418,51419,51420,51421,51422,51423,51426,51427,51429,null,null,null,null,null,null,51430,51431,51432,51433,51434,51435,51436,51437,51438,51439,51440,51441,51442,51443,51444,51446,51447,51448,51449,51450,51451,51454,51455,51457,51458,51459,51463,51464,51465,51466,51467,51470,12288,12289,12290,183,8229,8230,168,12291,173,8213,8741,65340,8764,8216,8217,8220,8221,12308,12309,12296,12297,12298,12299,12300,12301,12302,12303,12304,12305,177,215,247,8800,8804,8805,8734,8756,176,8242,8243,8451,8491,65504,65505,65509,9794,9792,8736,8869,8978,8706,8711,8801,8786,167,8251,9734,9733,9675,9679,9678,9671,9670,9633,9632,9651,9650,9661,9660,8594,8592,8593,8595,8596,12307,8810,8811,8730,8765,8733,8757,8747,8748,8712,8715,8838,8839,8834,8835,8746,8745,8743,8744,65506,51472,51474,51475,51476,51477,51478,51479,51481,51482,51483,51484,51485,51486,51487,51488,51489,51490,51491,51492,51493,51494,51495,51496,51497,51498,51499,null,null,null,null,null,null,51501,51502,51503,51504,51505,51506,51507,51509,51510,51511,51512,51513,51514,51515,51516,51517,51518,51519,51520,51521,51522,51523,51524,51525,51526,51527,null,null,null,null,null,null,51528,51529,51530,51531,51532,51533,51534,51535,51538,51539,51541,51542,51543,51545,51546,51547,51548,51549,51550,51551,51554,51556,51557,51558,51559,51560,51561,51562,51563,51565,51566,51567,8658,8660,8704,8707,180,65374,711,728,733,730,729,184,731,161,191,720,8750,8721,8719,164,8457,8240,9665,9664,9655,9654,9828,9824,9825,9829,9831,9827,8857,9672,9635,9680,9681,9618,9636,9637,9640,9639,9638,9641,9832,9743,9742,9756,9758,182,8224,8225,8597,8599,8601,8598,8600,9837,9833,9834,9836,12927,12828,8470,13255,8482,13250,13272,8481,8364,174,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,51569,51570,51571,51573,51574,51575,51576,51577,51578,51579,51581,51582,51583,51584,51585,51586,51587,51588,51589,51590,51591,51594,51595,51597,51598,51599,null,null,null,null,null,null,51601,51602,51603,51604,51605,51606,51607,51610,51612,51614,51615,51616,51617,51618,51619,51620,51621,51622,51623,51624,51625,51626,51627,51628,51629,51630,null,null,null,null,null,null,51631,51632,51633,51634,51635,51636,51637,51638,51639,51640,51641,51642,51643,51644,51645,51646,51647,51650,51651,51653,51654,51657,51659,51660,51661,51662,51663,51666,51668,51671,51672,51675,65281,65282,65283,65284,65285,65286,65287,65288,65289,65290,65291,65292,65293,65294,65295,65296,65297,65298,65299,65300,65301,65302,65303,65304,65305,65306,65307,65308,65309,65310,65311,65312,65313,65314,65315,65316,65317,65318,65319,65320,65321,65322,65323,65324,65325,65326,65327,65328,65329,65330,65331,65332,65333,65334,65335,65336,65337,65338,65339,65510,65341,65342,65343,65344,65345,65346,65347,65348,65349,65350,65351,65352,65353,65354,65355,65356,65357,65358,65359,65360,65361,65362,65363,65364,65365,65366,65367,65368,65369,65370,65371,65372,65373,65507,51678,51679,51681,51683,51685,51686,51688,51689,51690,51691,51694,51698,51699,51700,51701,51702,51703,51706,51707,51709,51710,51711,51713,51714,51715,51716,null,null,null,null,null,null,51717,51718,51719,51722,51726,51727,51728,51729,51730,51731,51733,51734,51735,51737,51738,51739,51740,51741,51742,51743,51744,51745,51746,51747,51748,51749,null,null,null,null,null,null,51750,51751,51752,51754,51755,51756,51757,51758,51759,51760,51761,51762,51763,51764,51765,51766,51767,51768,51769,51770,51771,51772,51773,51774,51775,51776,51777,51778,51779,51780,51781,51782,12593,12594,12595,12596,12597,12598,12599,12600,12601,12602,12603,12604,12605,12606,12607,12608,12609,12610,12611,12612,12613,12614,12615,12616,12617,12618,12619,12620,12621,12622,12623,12624,12625,12626,12627,12628,12629,12630,12631,12632,12633,12634,12635,12636,12637,12638,12639,12640,12641,12642,12643,12644,12645,12646,12647,12648,12649,12650,12651,12652,12653,12654,12655,12656,12657,12658,12659,12660,12661,12662,12663,12664,12665,12666,12667,12668,12669,12670,12671,12672,12673,12674,12675,12676,12677,12678,12679,12680,12681,12682,12683,12684,12685,12686,51783,51784,51785,51786,51787,51790,51791,51793,51794,51795,51797,51798,51799,51800,51801,51802,51803,51806,51810,51811,51812,51813,51814,51815,51817,51818,null,null,null,null,null,null,51819,51820,51821,51822,51823,51824,51825,51826,51827,51828,51829,51830,51831,51832,51833,51834,51835,51836,51838,51839,51840,51841,51842,51843,51845,51846,null,null,null,null,null,null,51847,51848,51849,51850,51851,51852,51853,51854,51855,51856,51857,51858,51859,51860,51861,51862,51863,51865,51866,51867,51868,51869,51870,51871,51872,51873,51874,51875,51876,51877,51878,51879,8560,8561,8562,8563,8564,8565,8566,8567,8568,8569,null,null,null,null,null,8544,8545,8546,8547,8548,8549,8550,8551,8552,8553,null,null,null,null,null,null,null,913,914,915,916,917,918,919,920,921,922,923,924,925,926,927,928,929,931,932,933,934,935,936,937,null,null,null,null,null,null,null,null,945,946,947,948,949,950,951,952,953,954,955,956,957,958,959,960,961,963,964,965,966,967,968,969,null,null,null,null,null,null,51880,51881,51882,51883,51884,51885,51886,51887,51888,51889,51890,51891,51892,51893,51894,51895,51896,51897,51898,51899,51902,51903,51905,51906,51907,51909,null,null,null,null,null,null,51910,51911,51912,51913,51914,51915,51918,51920,51922,51924,51925,51926,51927,51930,51931,51932,51933,51934,51935,51937,51938,51939,51940,51941,51942,51943,null,null,null,null,null,null,51944,51945,51946,51947,51949,51950,51951,51952,51953,51954,51955,51957,51958,51959,51960,51961,51962,51963,51964,51965,51966,51967,51968,51969,51970,51971,51972,51973,51974,51975,51977,51978,9472,9474,9484,9488,9496,9492,9500,9516,9508,9524,9532,9473,9475,9487,9491,9499,9495,9507,9523,9515,9531,9547,9504,9519,9512,9527,9535,9501,9520,9509,9528,9538,9490,9489,9498,9497,9494,9493,9486,9485,9502,9503,9505,9506,9510,9511,9513,9514,9517,9518,9521,9522,9525,9526,9529,9530,9533,9534,9536,9537,9539,9540,9541,9542,9543,9544,9545,9546,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,51979,51980,51981,51982,51983,51985,51986,51987,51989,51990,51991,51993,51994,51995,51996,51997,51998,51999,52002,52003,52004,52005,52006,52007,52008,52009,null,null,null,null,null,null,52010,52011,52012,52013,52014,52015,52016,52017,52018,52019,52020,52021,52022,52023,52024,52025,52026,52027,52028,52029,52030,52031,52032,52034,52035,52036,null,null,null,null,null,null,52037,52038,52039,52042,52043,52045,52046,52047,52049,52050,52051,52052,52053,52054,52055,52058,52059,52060,52062,52063,52064,52065,52066,52067,52069,52070,52071,52072,52073,52074,52075,52076,13205,13206,13207,8467,13208,13252,13219,13220,13221,13222,13209,13210,13211,13212,13213,13214,13215,13216,13217,13218,13258,13197,13198,13199,13263,13192,13193,13256,13223,13224,13232,13233,13234,13235,13236,13237,13238,13239,13240,13241,13184,13185,13186,13187,13188,13242,13243,13244,13245,13246,13247,13200,13201,13202,13203,13204,8486,13248,13249,13194,13195,13196,13270,13253,13229,13230,13231,13275,13225,13226,13227,13228,13277,13264,13267,13251,13257,13276,13254,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,52077,52078,52079,52080,52081,52082,52083,52084,52085,52086,52087,52090,52091,52092,52093,52094,52095,52096,52097,52098,52099,52100,52101,52102,52103,52104,null,null,null,null,null,null,52105,52106,52107,52108,52109,52110,52111,52112,52113,52114,52115,52116,52117,52118,52119,52120,52121,52122,52123,52125,52126,52127,52128,52129,52130,52131,null,null,null,null,null,null,52132,52133,52134,52135,52136,52137,52138,52139,52140,52141,52142,52143,52144,52145,52146,52147,52148,52149,52150,52151,52153,52154,52155,52156,52157,52158,52159,52160,52161,52162,52163,52164,198,208,170,294,null,306,null,319,321,216,338,186,222,358,330,null,12896,12897,12898,12899,12900,12901,12902,12903,12904,12905,12906,12907,12908,12909,12910,12911,12912,12913,12914,12915,12916,12917,12918,12919,12920,12921,12922,12923,9424,9425,9426,9427,9428,9429,9430,9431,9432,9433,9434,9435,9436,9437,9438,9439,9440,9441,9442,9443,9444,9445,9446,9447,9448,9449,9312,9313,9314,9315,9316,9317,9318,9319,9320,9321,9322,9323,9324,9325,9326,189,8531,8532,188,190,8539,8540,8541,8542,52165,52166,52167,52168,52169,52170,52171,52172,52173,52174,52175,52176,52177,52178,52179,52181,52182,52183,52184,52185,52186,52187,52188,52189,52190,52191,null,null,null,null,null,null,52192,52193,52194,52195,52197,52198,52200,52202,52203,52204,52205,52206,52207,52208,52209,52210,52211,52212,52213,52214,52215,52216,52217,52218,52219,52220,null,null,null,null,null,null,52221,52222,52223,52224,52225,52226,52227,52228,52229,52230,52231,52232,52233,52234,52235,52238,52239,52241,52242,52243,52245,52246,52247,52248,52249,52250,52251,52254,52255,52256,52259,52260,230,273,240,295,305,307,312,320,322,248,339,223,254,359,331,329,12800,12801,12802,12803,12804,12805,12806,12807,12808,12809,12810,12811,12812,12813,12814,12815,12816,12817,12818,12819,12820,12821,12822,12823,12824,12825,12826,12827,9372,9373,9374,9375,9376,9377,9378,9379,9380,9381,9382,9383,9384,9385,9386,9387,9388,9389,9390,9391,9392,9393,9394,9395,9396,9397,9332,9333,9334,9335,9336,9337,9338,9339,9340,9341,9342,9343,9344,9345,9346,185,178,179,8308,8319,8321,8322,8323,8324,52261,52262,52266,52267,52269,52271,52273,52274,52275,52276,52277,52278,52279,52282,52287,52288,52289,52290,52291,52294,52295,52297,52298,52299,52301,52302,null,null,null,null,null,null,52303,52304,52305,52306,52307,52310,52314,52315,52316,52317,52318,52319,52321,52322,52323,52325,52327,52329,52330,52331,52332,52333,52334,52335,52337,52338,null,null,null,null,null,null,52339,52340,52342,52343,52344,52345,52346,52347,52348,52349,52350,52351,52352,52353,52354,52355,52356,52357,52358,52359,52360,52361,52362,52363,52364,52365,52366,52367,52368,52369,52370,52371,12353,12354,12355,12356,12357,12358,12359,12360,12361,12362,12363,12364,12365,12366,12367,12368,12369,12370,12371,12372,12373,12374,12375,12376,12377,12378,12379,12380,12381,12382,12383,12384,12385,12386,12387,12388,12389,12390,12391,12392,12393,12394,12395,12396,12397,12398,12399,12400,12401,12402,12403,12404,12405,12406,12407,12408,12409,12410,12411,12412,12413,12414,12415,12416,12417,12418,12419,12420,12421,12422,12423,12424,12425,12426,12427,12428,12429,12430,12431,12432,12433,12434,12435,null,null,null,null,null,null,null,null,null,null,null,52372,52373,52374,52375,52378,52379,52381,52382,52383,52385,52386,52387,52388,52389,52390,52391,52394,52398,52399,52400,52401,52402,52403,52406,52407,52409,null,null,null,null,null,null,52410,52411,52413,52414,52415,52416,52417,52418,52419,52422,52424,52426,52427,52428,52429,52430,52431,52433,52434,52435,52437,52438,52439,52440,52441,52442,null,null,null,null,null,null,52443,52444,52445,52446,52447,52448,52449,52450,52451,52453,52454,52455,52456,52457,52458,52459,52461,52462,52463,52465,52466,52467,52468,52469,52470,52471,52472,52473,52474,52475,52476,52477,12449,12450,12451,12452,12453,12454,12455,12456,12457,12458,12459,12460,12461,12462,12463,12464,12465,12466,12467,12468,12469,12470,12471,12472,12473,12474,12475,12476,12477,12478,12479,12480,12481,12482,12483,12484,12485,12486,12487,12488,12489,12490,12491,12492,12493,12494,12495,12496,12497,12498,12499,12500,12501,12502,12503,12504,12505,12506,12507,12508,12509,12510,12511,12512,12513,12514,12515,12516,12517,12518,12519,12520,12521,12522,12523,12524,12525,12526,12527,12528,12529,12530,12531,12532,12533,12534,null,null,null,null,null,null,null,null,52478,52479,52480,52482,52483,52484,52485,52486,52487,52490,52491,52493,52494,52495,52497,52498,52499,52500,52501,52502,52503,52506,52508,52510,52511,52512,null,null,null,null,null,null,52513,52514,52515,52517,52518,52519,52521,52522,52523,52525,52526,52527,52528,52529,52530,52531,52532,52533,52534,52535,52536,52538,52539,52540,52541,52542,null,null,null,null,null,null,52543,52544,52545,52546,52547,52548,52549,52550,52551,52552,52553,52554,52555,52556,52557,52558,52559,52560,52561,52562,52563,52564,52565,52566,52567,52568,52569,52570,52571,52573,52574,52575,1040,1041,1042,1043,1044,1045,1025,1046,1047,1048,1049,1050,1051,1052,1053,1054,1055,1056,1057,1058,1059,1060,1061,1062,1063,1064,1065,1066,1067,1068,1069,1070,1071,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1072,1073,1074,1075,1076,1077,1105,1078,1079,1080,1081,1082,1083,1084,1085,1086,1087,1088,1089,1090,1091,1092,1093,1094,1095,1096,1097,1098,1099,1100,1101,1102,1103,null,null,null,null,null,null,null,null,null,null,null,null,null,52577,52578,52579,52581,52582,52583,52584,52585,52586,52587,52590,52592,52594,52595,52596,52597,52598,52599,52601,52602,52603,52604,52605,52606,52607,52608,null,null,null,null,null,null,52609,52610,52611,52612,52613,52614,52615,52617,52618,52619,52620,52621,52622,52623,52624,52625,52626,52627,52630,52631,52633,52634,52635,52637,52638,52639,null,null,null,null,null,null,52640,52641,52642,52643,52646,52648,52650,52651,52652,52653,52654,52655,52657,52658,52659,52660,52661,52662,52663,52664,52665,52666,52667,52668,52669,52670,52671,52672,52673,52674,52675,52677,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,52678,52679,52680,52681,52682,52683,52685,52686,52687,52689,52690,52691,52692,52693,52694,52695,52696,52697,52698,52699,52700,52701,52702,52703,52704,52705,null,null,null,null,null,null,52706,52707,52708,52709,52710,52711,52713,52714,52715,52717,52718,52719,52721,52722,52723,52724,52725,52726,52727,52730,52732,52734,52735,52736,52737,52738,null,null,null,null,null,null,52739,52741,52742,52743,52745,52746,52747,52749,52750,52751,52752,52753,52754,52755,52757,52758,52759,52760,52762,52763,52764,52765,52766,52767,52770,52771,52773,52774,52775,52777,52778,52779,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,52780,52781,52782,52783,52786,52788,52790,52791,52792,52793,52794,52795,52796,52797,52798,52799,52800,52801,52802,52803,52804,52805,52806,52807,52808,52809,null,null,null,null,null,null,52810,52811,52812,52813,52814,52815,52816,52817,52818,52819,52820,52821,52822,52823,52826,52827,52829,52830,52834,52835,52836,52837,52838,52839,52842,52844,null,null,null,null,null,null,52846,52847,52848,52849,52850,52851,52854,52855,52857,52858,52859,52861,52862,52863,52864,52865,52866,52867,52870,52872,52874,52875,52876,52877,52878,52879,52882,52883,52885,52886,52887,52889,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,52890,52891,52892,52893,52894,52895,52898,52902,52903,52904,52905,52906,52907,52910,52911,52912,52913,52914,52915,52916,52917,52918,52919,52920,52921,52922,null,null,null,null,null,null,52923,52924,52925,52926,52927,52928,52930,52931,52932,52933,52934,52935,52936,52937,52938,52939,52940,52941,52942,52943,52944,52945,52946,52947,52948,52949,null,null,null,null,null,null,52950,52951,52952,52953,52954,52955,52956,52957,52958,52959,52960,52961,52962,52963,52966,52967,52969,52970,52973,52974,52975,52976,52977,52978,52979,52982,52986,52987,52988,52989,52990,52991,44032,44033,44036,44039,44040,44041,44042,44048,44049,44050,44051,44052,44053,44054,44055,44057,44058,44059,44060,44061,44064,44068,44076,44077,44079,44080,44081,44088,44089,44092,44096,44107,44109,44116,44120,44124,44144,44145,44148,44151,44152,44154,44160,44161,44163,44164,44165,44166,44169,44170,44171,44172,44176,44180,44188,44189,44191,44192,44193,44200,44201,44202,44204,44207,44208,44216,44217,44219,44220,44221,44225,44228,44232,44236,44245,44247,44256,44257,44260,44263,44264,44266,44268,44271,44272,44273,44275,44277,44278,44284,44285,44288,44292,44294,52994,52995,52997,52998,52999,53001,53002,53003,53004,53005,53006,53007,53010,53012,53014,53015,53016,53017,53018,53019,53021,53022,53023,53025,53026,53027,null,null,null,null,null,null,53029,53030,53031,53032,53033,53034,53035,53038,53042,53043,53044,53045,53046,53047,53049,53050,53051,53052,53053,53054,53055,53056,53057,53058,53059,53060,null,null,null,null,null,null,53061,53062,53063,53064,53065,53066,53067,53068,53069,53070,53071,53072,53073,53074,53075,53078,53079,53081,53082,53083,53085,53086,53087,53088,53089,53090,53091,53094,53096,53098,53099,53100,44300,44301,44303,44305,44312,44316,44320,44329,44332,44333,44340,44341,44344,44348,44356,44357,44359,44361,44368,44372,44376,44385,44387,44396,44397,44400,44403,44404,44405,44406,44411,44412,44413,44415,44417,44418,44424,44425,44428,44432,44444,44445,44452,44471,44480,44481,44484,44488,44496,44497,44499,44508,44512,44516,44536,44537,44540,44543,44544,44545,44552,44553,44555,44557,44564,44592,44593,44596,44599,44600,44602,44608,44609,44611,44613,44614,44618,44620,44621,44622,44624,44628,44630,44636,44637,44639,44640,44641,44645,44648,44649,44652,44656,44664,53101,53102,53103,53106,53107,53109,53110,53111,53113,53114,53115,53116,53117,53118,53119,53121,53122,53123,53124,53126,53127,53128,53129,53130,53131,53133,null,null,null,null,null,null,53134,53135,53136,53137,53138,53139,53140,53141,53142,53143,53144,53145,53146,53147,53148,53149,53150,53151,53152,53154,53155,53156,53157,53158,53159,53161,null,null,null,null,null,null,53162,53163,53164,53165,53166,53167,53169,53170,53171,53172,53173,53174,53175,53176,53177,53178,53179,53180,53181,53182,53183,53184,53185,53186,53187,53189,53190,53191,53192,53193,53194,53195,44665,44667,44668,44669,44676,44677,44684,44732,44733,44734,44736,44740,44748,44749,44751,44752,44753,44760,44761,44764,44776,44779,44781,44788,44792,44796,44807,44808,44813,44816,44844,44845,44848,44850,44852,44860,44861,44863,44865,44866,44867,44872,44873,44880,44892,44893,44900,44901,44921,44928,44932,44936,44944,44945,44949,44956,44984,44985,44988,44992,44999,45000,45001,45003,45005,45006,45012,45020,45032,45033,45040,45041,45044,45048,45056,45057,45060,45068,45072,45076,45084,45085,45096,45124,45125,45128,45130,45132,45134,45139,45140,45141,45143,45145,53196,53197,53198,53199,53200,53201,53202,53203,53204,53205,53206,53207,53208,53209,53210,53211,53212,53213,53214,53215,53218,53219,53221,53222,53223,53225,null,null,null,null,null,null,53226,53227,53228,53229,53230,53231,53234,53236,53238,53239,53240,53241,53242,53243,53245,53246,53247,53249,53250,53251,53253,53254,53255,53256,53257,53258,null,null,null,null,null,null,53259,53260,53261,53262,53263,53264,53266,53267,53268,53269,53270,53271,53273,53274,53275,53276,53277,53278,53279,53280,53281,53282,53283,53284,53285,53286,53287,53288,53289,53290,53291,53292,45149,45180,45181,45184,45188,45196,45197,45199,45201,45208,45209,45210,45212,45215,45216,45217,45218,45224,45225,45227,45228,45229,45230,45231,45233,45235,45236,45237,45240,45244,45252,45253,45255,45256,45257,45264,45265,45268,45272,45280,45285,45320,45321,45323,45324,45328,45330,45331,45336,45337,45339,45340,45341,45347,45348,45349,45352,45356,45364,45365,45367,45368,45369,45376,45377,45380,45384,45392,45393,45396,45397,45400,45404,45408,45432,45433,45436,45440,45442,45448,45449,45451,45453,45458,45459,45460,45464,45468,45480,45516,45520,45524,45532,45533,53294,53295,53296,53297,53298,53299,53302,53303,53305,53306,53307,53309,53310,53311,53312,53313,53314,53315,53318,53320,53322,53323,53324,53325,53326,53327,null,null,null,null,null,null,53329,53330,53331,53333,53334,53335,53337,53338,53339,53340,53341,53342,53343,53345,53346,53347,53348,53349,53350,53351,53352,53353,53354,53355,53358,53359,null,null,null,null,null,null,53361,53362,53363,53365,53366,53367,53368,53369,53370,53371,53374,53375,53376,53378,53379,53380,53381,53382,53383,53384,53385,53386,53387,53388,53389,53390,53391,53392,53393,53394,53395,53396,45535,45544,45545,45548,45552,45561,45563,45565,45572,45573,45576,45579,45580,45588,45589,45591,45593,45600,45620,45628,45656,45660,45664,45672,45673,45684,45685,45692,45700,45701,45705,45712,45713,45716,45720,45721,45722,45728,45729,45731,45733,45734,45738,45740,45744,45748,45768,45769,45772,45776,45778,45784,45785,45787,45789,45794,45796,45797,45798,45800,45803,45804,45805,45806,45807,45811,45812,45813,45815,45816,45817,45818,45819,45823,45824,45825,45828,45832,45840,45841,45843,45844,45845,45852,45908,45909,45910,45912,45915,45916,45918,45919,45924,45925,53397,53398,53399,53400,53401,53402,53403,53404,53405,53406,53407,53408,53409,53410,53411,53414,53415,53417,53418,53419,53421,53422,53423,53424,53425,53426,null,null,null,null,null,null,53427,53430,53432,53434,53435,53436,53437,53438,53439,53442,53443,53445,53446,53447,53450,53451,53452,53453,53454,53455,53458,53462,53463,53464,53465,53466,null,null,null,null,null,null,53467,53470,53471,53473,53474,53475,53477,53478,53479,53480,53481,53482,53483,53486,53490,53491,53492,53493,53494,53495,53497,53498,53499,53500,53501,53502,53503,53504,53505,53506,53507,53508,45927,45929,45931,45934,45936,45937,45940,45944,45952,45953,45955,45956,45957,45964,45968,45972,45984,45985,45992,45996,46020,46021,46024,46027,46028,46030,46032,46036,46037,46039,46041,46043,46045,46048,46052,46056,46076,46096,46104,46108,46112,46120,46121,46123,46132,46160,46161,46164,46168,46176,46177,46179,46181,46188,46208,46216,46237,46244,46248,46252,46261,46263,46265,46272,46276,46280,46288,46293,46300,46301,46304,46307,46308,46310,46316,46317,46319,46321,46328,46356,46357,46360,46363,46364,46372,46373,46375,46376,46377,46378,46384,46385,46388,46392,53509,53510,53511,53512,53513,53514,53515,53516,53518,53519,53520,53521,53522,53523,53524,53525,53526,53527,53528,53529,53530,53531,53532,53533,53534,53535,null,null,null,null,null,null,53536,53537,53538,53539,53540,53541,53542,53543,53544,53545,53546,53547,53548,53549,53550,53551,53554,53555,53557,53558,53559,53561,53563,53564,53565,53566,null,null,null,null,null,null,53567,53570,53574,53575,53576,53577,53578,53579,53582,53583,53585,53586,53587,53589,53590,53591,53592,53593,53594,53595,53598,53600,53602,53603,53604,53605,53606,53607,53609,53610,53611,53613,46400,46401,46403,46404,46405,46411,46412,46413,46416,46420,46428,46429,46431,46432,46433,46496,46497,46500,46504,46506,46507,46512,46513,46515,46516,46517,46523,46524,46525,46528,46532,46540,46541,46543,46544,46545,46552,46572,46608,46609,46612,46616,46629,46636,46644,46664,46692,46696,46748,46749,46752,46756,46763,46764,46769,46804,46832,46836,46840,46848,46849,46853,46888,46889,46892,46895,46896,46904,46905,46907,46916,46920,46924,46932,46933,46944,46948,46952,46960,46961,46963,46965,46972,46973,46976,46980,46988,46989,46991,46992,46993,46994,46998,46999,53614,53615,53616,53617,53618,53619,53620,53621,53622,53623,53624,53625,53626,53627,53629,53630,53631,53632,53633,53634,53635,53637,53638,53639,53641,53642,null,null,null,null,null,null,53643,53644,53645,53646,53647,53648,53649,53650,53651,53652,53653,53654,53655,53656,53657,53658,53659,53660,53661,53662,53663,53666,53667,53669,53670,53671,null,null,null,null,null,null,53673,53674,53675,53676,53677,53678,53679,53682,53684,53686,53687,53688,53689,53691,53693,53694,53695,53697,53698,53699,53700,53701,53702,53703,53704,53705,53706,53707,53708,53709,53710,53711,47000,47001,47004,47008,47016,47017,47019,47020,47021,47028,47029,47032,47047,47049,47084,47085,47088,47092,47100,47101,47103,47104,47105,47111,47112,47113,47116,47120,47128,47129,47131,47133,47140,47141,47144,47148,47156,47157,47159,47160,47161,47168,47172,47185,47187,47196,47197,47200,47204,47212,47213,47215,47217,47224,47228,47245,47272,47280,47284,47288,47296,47297,47299,47301,47308,47312,47316,47325,47327,47329,47336,47337,47340,47344,47352,47353,47355,47357,47364,47384,47392,47420,47421,47424,47428,47436,47439,47441,47448,47449,47452,47456,47464,47465,53712,53713,53714,53715,53716,53717,53718,53719,53721,53722,53723,53724,53725,53726,53727,53728,53729,53730,53731,53732,53733,53734,53735,53736,53737,53738,null,null,null,null,null,null,53739,53740,53741,53742,53743,53744,53745,53746,53747,53749,53750,53751,53753,53754,53755,53756,53757,53758,53759,53760,53761,53762,53763,53764,53765,53766,null,null,null,null,null,null,53768,53770,53771,53772,53773,53774,53775,53777,53778,53779,53780,53781,53782,53783,53784,53785,53786,53787,53788,53789,53790,53791,53792,53793,53794,53795,53796,53797,53798,53799,53800,53801,47467,47469,47476,47477,47480,47484,47492,47493,47495,47497,47498,47501,47502,47532,47533,47536,47540,47548,47549,47551,47553,47560,47561,47564,47566,47567,47568,47569,47570,47576,47577,47579,47581,47582,47585,47587,47588,47589,47592,47596,47604,47605,47607,47608,47609,47610,47616,47617,47624,47637,47672,47673,47676,47680,47682,47688,47689,47691,47693,47694,47699,47700,47701,47704,47708,47716,47717,47719,47720,47721,47728,47729,47732,47736,47747,47748,47749,47751,47756,47784,47785,47787,47788,47792,47794,47800,47801,47803,47805,47812,47816,47832,47833,47868,53802,53803,53806,53807,53809,53810,53811,53813,53814,53815,53816,53817,53818,53819,53822,53824,53826,53827,53828,53829,53830,53831,53833,53834,53835,53836,null,null,null,null,null,null,53837,53838,53839,53840,53841,53842,53843,53844,53845,53846,53847,53848,53849,53850,53851,53853,53854,53855,53856,53857,53858,53859,53861,53862,53863,53864,null,null,null,null,null,null,53865,53866,53867,53868,53869,53870,53871,53872,53873,53874,53875,53876,53877,53878,53879,53880,53881,53882,53883,53884,53885,53886,53887,53890,53891,53893,53894,53895,53897,53898,53899,53900,47872,47876,47885,47887,47889,47896,47900,47904,47913,47915,47924,47925,47926,47928,47931,47932,47933,47934,47940,47941,47943,47945,47949,47951,47952,47956,47960,47969,47971,47980,48008,48012,48016,48036,48040,48044,48052,48055,48064,48068,48072,48080,48083,48120,48121,48124,48127,48128,48130,48136,48137,48139,48140,48141,48143,48145,48148,48149,48150,48151,48152,48155,48156,48157,48158,48159,48164,48165,48167,48169,48173,48176,48177,48180,48184,48192,48193,48195,48196,48197,48201,48204,48205,48208,48221,48260,48261,48264,48267,48268,48270,48276,48277,48279,53901,53902,53903,53906,53907,53908,53910,53911,53912,53913,53914,53915,53917,53918,53919,53921,53922,53923,53925,53926,53927,53928,53929,53930,53931,53933,null,null,null,null,null,null,53934,53935,53936,53938,53939,53940,53941,53942,53943,53946,53947,53949,53950,53953,53955,53956,53957,53958,53959,53962,53964,53965,53966,53967,53968,53969,null,null,null,null,null,null,53970,53971,53973,53974,53975,53977,53978,53979,53981,53982,53983,53984,53985,53986,53987,53990,53991,53992,53993,53994,53995,53996,53997,53998,53999,54002,54003,54005,54006,54007,54009,54010,48281,48282,48288,48289,48292,48295,48296,48304,48305,48307,48308,48309,48316,48317,48320,48324,48333,48335,48336,48337,48341,48344,48348,48372,48373,48374,48376,48380,48388,48389,48391,48393,48400,48404,48420,48428,48448,48456,48457,48460,48464,48472,48473,48484,48488,48512,48513,48516,48519,48520,48521,48522,48528,48529,48531,48533,48537,48538,48540,48548,48560,48568,48596,48597,48600,48604,48617,48624,48628,48632,48640,48643,48645,48652,48653,48656,48660,48668,48669,48671,48708,48709,48712,48716,48718,48724,48725,48727,48729,48730,48731,48736,48737,48740,54011,54012,54013,54014,54015,54018,54020,54022,54023,54024,54025,54026,54027,54031,54033,54034,54035,54037,54039,54040,54041,54042,54043,54046,54050,54051,null,null,null,null,null,null,54052,54054,54055,54058,54059,54061,54062,54063,54065,54066,54067,54068,54069,54070,54071,54074,54078,54079,54080,54081,54082,54083,54086,54087,54088,54089,null,null,null,null,null,null,54090,54091,54092,54093,54094,54095,54096,54097,54098,54099,54100,54101,54102,54103,54104,54105,54106,54107,54108,54109,54110,54111,54112,54113,54114,54115,54116,54117,54118,54119,54120,54121,48744,48746,48752,48753,48755,48756,48757,48763,48764,48765,48768,48772,48780,48781,48783,48784,48785,48792,48793,48808,48848,48849,48852,48855,48856,48864,48867,48868,48869,48876,48897,48904,48905,48920,48921,48923,48924,48925,48960,48961,48964,48968,48976,48977,48981,49044,49072,49093,49100,49101,49104,49108,49116,49119,49121,49212,49233,49240,49244,49248,49256,49257,49296,49297,49300,49304,49312,49313,49315,49317,49324,49325,49327,49328,49331,49332,49333,49334,49340,49341,49343,49344,49345,49349,49352,49353,49356,49360,49368,49369,49371,49372,49373,49380,54122,54123,54124,54125,54126,54127,54128,54129,54130,54131,54132,54133,54134,54135,54136,54137,54138,54139,54142,54143,54145,54146,54147,54149,54150,54151,null,null,null,null,null,null,54152,54153,54154,54155,54158,54162,54163,54164,54165,54166,54167,54170,54171,54173,54174,54175,54177,54178,54179,54180,54181,54182,54183,54186,54188,54190,null,null,null,null,null,null,54191,54192,54193,54194,54195,54197,54198,54199,54201,54202,54203,54205,54206,54207,54208,54209,54210,54211,54214,54215,54218,54219,54220,54221,54222,54223,54225,54226,54227,54228,54229,54230,49381,49384,49388,49396,49397,49399,49401,49408,49412,49416,49424,49429,49436,49437,49438,49439,49440,49443,49444,49446,49447,49452,49453,49455,49456,49457,49462,49464,49465,49468,49472,49480,49481,49483,49484,49485,49492,49493,49496,49500,49508,49509,49511,49512,49513,49520,49524,49528,49541,49548,49549,49550,49552,49556,49558,49564,49565,49567,49569,49573,49576,49577,49580,49584,49597,49604,49608,49612,49620,49623,49624,49632,49636,49640,49648,49649,49651,49660,49661,49664,49668,49676,49677,49679,49681,49688,49689,49692,49695,49696,49704,49705,49707,49709,54231,54233,54234,54235,54236,54237,54238,54239,54240,54242,54244,54245,54246,54247,54248,54249,54250,54251,54254,54255,54257,54258,54259,54261,54262,54263,null,null,null,null,null,null,54264,54265,54266,54267,54270,54272,54274,54275,54276,54277,54278,54279,54281,54282,54283,54284,54285,54286,54287,54288,54289,54290,54291,54292,54293,54294,null,null,null,null,null,null,54295,54296,54297,54298,54299,54300,54302,54303,54304,54305,54306,54307,54308,54309,54310,54311,54312,54313,54314,54315,54316,54317,54318,54319,54320,54321,54322,54323,54324,54325,54326,54327,49711,49713,49714,49716,49736,49744,49745,49748,49752,49760,49765,49772,49773,49776,49780,49788,49789,49791,49793,49800,49801,49808,49816,49819,49821,49828,49829,49832,49836,49837,49844,49845,49847,49849,49884,49885,49888,49891,49892,49899,49900,49901,49903,49905,49910,49912,49913,49915,49916,49920,49928,49929,49932,49933,49939,49940,49941,49944,49948,49956,49957,49960,49961,49989,50024,50025,50028,50032,50034,50040,50041,50044,50045,50052,50056,50060,50112,50136,50137,50140,50143,50144,50146,50152,50153,50157,50164,50165,50168,50184,50192,50212,50220,50224,54328,54329,54330,54331,54332,54333,54334,54335,54337,54338,54339,54341,54342,54343,54344,54345,54346,54347,54348,54349,54350,54351,54352,54353,54354,54355,null,null,null,null,null,null,54356,54357,54358,54359,54360,54361,54362,54363,54365,54366,54367,54369,54370,54371,54373,54374,54375,54376,54377,54378,54379,54380,54382,54384,54385,54386,null,null,null,null,null,null,54387,54388,54389,54390,54391,54394,54395,54397,54398,54401,54403,54404,54405,54406,54407,54410,54412,54414,54415,54416,54417,54418,54419,54421,54422,54423,54424,54425,54426,54427,54428,54429,50228,50236,50237,50248,50276,50277,50280,50284,50292,50293,50297,50304,50324,50332,50360,50364,50409,50416,50417,50420,50424,50426,50431,50432,50433,50444,50448,50452,50460,50472,50473,50476,50480,50488,50489,50491,50493,50500,50501,50504,50505,50506,50508,50509,50510,50515,50516,50517,50519,50520,50521,50525,50526,50528,50529,50532,50536,50544,50545,50547,50548,50549,50556,50557,50560,50564,50567,50572,50573,50575,50577,50581,50583,50584,50588,50592,50601,50612,50613,50616,50617,50619,50620,50621,50622,50628,50629,50630,50631,50632,50633,50634,50636,50638,54430,54431,54432,54433,54434,54435,54436,54437,54438,54439,54440,54442,54443,54444,54445,54446,54447,54448,54449,54450,54451,54452,54453,54454,54455,54456,null,null,null,null,null,null,54457,54458,54459,54460,54461,54462,54463,54464,54465,54466,54467,54468,54469,54470,54471,54472,54473,54474,54475,54477,54478,54479,54481,54482,54483,54485,null,null,null,null,null,null,54486,54487,54488,54489,54490,54491,54493,54494,54496,54497,54498,54499,54500,54501,54502,54503,54505,54506,54507,54509,54510,54511,54513,54514,54515,54516,54517,54518,54519,54521,54522,54524,50640,50641,50644,50648,50656,50657,50659,50661,50668,50669,50670,50672,50676,50678,50679,50684,50685,50686,50687,50688,50689,50693,50694,50695,50696,50700,50704,50712,50713,50715,50716,50724,50725,50728,50732,50733,50734,50736,50739,50740,50741,50743,50745,50747,50752,50753,50756,50760,50768,50769,50771,50772,50773,50780,50781,50784,50796,50799,50801,50808,50809,50812,50816,50824,50825,50827,50829,50836,50837,50840,50844,50852,50853,50855,50857,50864,50865,50868,50872,50873,50874,50880,50881,50883,50885,50892,50893,50896,50900,50908,50909,50912,50913,50920,54526,54527,54528,54529,54530,54531,54533,54534,54535,54537,54538,54539,54541,54542,54543,54544,54545,54546,54547,54550,54552,54553,54554,54555,54556,54557,null,null,null,null,null,null,54558,54559,54560,54561,54562,54563,54564,54565,54566,54567,54568,54569,54570,54571,54572,54573,54574,54575,54576,54577,54578,54579,54580,54581,54582,54583,null,null,null,null,null,null,54584,54585,54586,54587,54590,54591,54593,54594,54595,54597,54598,54599,54600,54601,54602,54603,54606,54608,54610,54611,54612,54613,54614,54615,54618,54619,54621,54622,54623,54625,54626,54627,50921,50924,50928,50936,50937,50941,50948,50949,50952,50956,50964,50965,50967,50969,50976,50977,50980,50984,50992,50993,50995,50997,50999,51004,51005,51008,51012,51018,51020,51021,51023,51025,51026,51027,51028,51029,51030,51031,51032,51036,51040,51048,51051,51060,51061,51064,51068,51069,51070,51075,51076,51077,51079,51080,51081,51082,51086,51088,51089,51092,51094,51095,51096,51098,51104,51105,51107,51108,51109,51110,51116,51117,51120,51124,51132,51133,51135,51136,51137,51144,51145,51148,51150,51152,51160,51165,51172,51176,51180,51200,51201,51204,51208,51210,54628,54630,54631,54634,54636,54638,54639,54640,54641,54642,54643,54646,54647,54649,54650,54651,54653,54654,54655,54656,54657,54658,54659,54662,54666,54667,null,null,null,null,null,null,54668,54669,54670,54671,54673,54674,54675,54676,54677,54678,54679,54680,54681,54682,54683,54684,54685,54686,54687,54688,54689,54690,54691,54692,54694,54695,null,null,null,null,null,null,54696,54697,54698,54699,54700,54701,54702,54703,54704,54705,54706,54707,54708,54709,54710,54711,54712,54713,54714,54715,54716,54717,54718,54719,54720,54721,54722,54723,54724,54725,54726,54727,51216,51217,51219,51221,51222,51228,51229,51232,51236,51244,51245,51247,51249,51256,51260,51264,51272,51273,51276,51277,51284,51312,51313,51316,51320,51322,51328,51329,51331,51333,51334,51335,51339,51340,51341,51348,51357,51359,51361,51368,51388,51389,51396,51400,51404,51412,51413,51415,51417,51424,51425,51428,51445,51452,51453,51456,51460,51461,51462,51468,51469,51471,51473,51480,51500,51508,51536,51537,51540,51544,51552,51553,51555,51564,51568,51572,51580,51592,51593,51596,51600,51608,51609,51611,51613,51648,51649,51652,51655,51656,51658,51664,51665,51667,54730,54731,54733,54734,54735,54737,54739,54740,54741,54742,54743,54746,54748,54750,54751,54752,54753,54754,54755,54758,54759,54761,54762,54763,54765,54766,null,null,null,null,null,null,54767,54768,54769,54770,54771,54774,54776,54778,54779,54780,54781,54782,54783,54786,54787,54789,54790,54791,54793,54794,54795,54796,54797,54798,54799,54802,null,null,null,null,null,null,54806,54807,54808,54809,54810,54811,54813,54814,54815,54817,54818,54819,54821,54822,54823,54824,54825,54826,54827,54828,54830,54831,54832,54833,54834,54835,54836,54837,54838,54839,54842,54843,51669,51670,51673,51674,51676,51677,51680,51682,51684,51687,51692,51693,51695,51696,51697,51704,51705,51708,51712,51720,51721,51723,51724,51725,51732,51736,51753,51788,51789,51792,51796,51804,51805,51807,51808,51809,51816,51837,51844,51864,51900,51901,51904,51908,51916,51917,51919,51921,51923,51928,51929,51936,51948,51956,51976,51984,51988,51992,52000,52001,52033,52040,52041,52044,52048,52056,52057,52061,52068,52088,52089,52124,52152,52180,52196,52199,52201,52236,52237,52240,52244,52252,52253,52257,52258,52263,52264,52265,52268,52270,52272,52280,52281,52283,54845,54846,54847,54849,54850,54851,54852,54854,54855,54858,54860,54862,54863,54864,54866,54867,54870,54871,54873,54874,54875,54877,54878,54879,54880,54881,null,null,null,null,null,null,54882,54883,54884,54885,54886,54888,54890,54891,54892,54893,54894,54895,54898,54899,54901,54902,54903,54904,54905,54906,54907,54908,54909,54910,54911,54912,null,null,null,null,null,null,54913,54914,54916,54918,54919,54920,54921,54922,54923,54926,54927,54929,54930,54931,54933,54934,54935,54936,54937,54938,54939,54940,54942,54944,54946,54947,54948,54949,54950,54951,54953,54954,52284,52285,52286,52292,52293,52296,52300,52308,52309,52311,52312,52313,52320,52324,52326,52328,52336,52341,52376,52377,52380,52384,52392,52393,52395,52396,52397,52404,52405,52408,52412,52420,52421,52423,52425,52432,52436,52452,52460,52464,52481,52488,52489,52492,52496,52504,52505,52507,52509,52516,52520,52524,52537,52572,52576,52580,52588,52589,52591,52593,52600,52616,52628,52629,52632,52636,52644,52645,52647,52649,52656,52676,52684,52688,52712,52716,52720,52728,52729,52731,52733,52740,52744,52748,52756,52761,52768,52769,52772,52776,52784,52785,52787,52789,54955,54957,54958,54959,54961,54962,54963,54964,54965,54966,54967,54968,54970,54972,54973,54974,54975,54976,54977,54978,54979,54982,54983,54985,54986,54987,null,null,null,null,null,null,54989,54990,54991,54992,54994,54995,54997,54998,55000,55002,55003,55004,55005,55006,55007,55009,55010,55011,55013,55014,55015,55017,55018,55019,55020,55021,null,null,null,null,null,null,55022,55023,55025,55026,55027,55028,55030,55031,55032,55033,55034,55035,55038,55039,55041,55042,55043,55045,55046,55047,55048,55049,55050,55051,55052,55053,55054,55055,55056,55058,55059,55060,52824,52825,52828,52831,52832,52833,52840,52841,52843,52845,52852,52853,52856,52860,52868,52869,52871,52873,52880,52881,52884,52888,52896,52897,52899,52900,52901,52908,52909,52929,52964,52965,52968,52971,52972,52980,52981,52983,52984,52985,52992,52993,52996,53000,53008,53009,53011,53013,53020,53024,53028,53036,53037,53039,53040,53041,53048,53076,53077,53080,53084,53092,53093,53095,53097,53104,53105,53108,53112,53120,53125,53132,53153,53160,53168,53188,53216,53217,53220,53224,53232,53233,53235,53237,53244,53248,53252,53265,53272,53293,53300,53301,53304,53308,55061,55062,55063,55066,55067,55069,55070,55071,55073,55074,55075,55076,55077,55078,55079,55082,55084,55086,55087,55088,55089,55090,55091,55094,55095,55097,null,null,null,null,null,null,55098,55099,55101,55102,55103,55104,55105,55106,55107,55109,55110,55112,55114,55115,55116,55117,55118,55119,55122,55123,55125,55130,55131,55132,55133,55134,null,null,null,null,null,null,55135,55138,55140,55142,55143,55144,55146,55147,55149,55150,55151,55153,55154,55155,55157,55158,55159,55160,55161,55162,55163,55166,55167,55168,55170,55171,55172,55173,55174,55175,55178,55179,53316,53317,53319,53321,53328,53332,53336,53344,53356,53357,53360,53364,53372,53373,53377,53412,53413,53416,53420,53428,53429,53431,53433,53440,53441,53444,53448,53449,53456,53457,53459,53460,53461,53468,53469,53472,53476,53484,53485,53487,53488,53489,53496,53517,53552,53553,53556,53560,53562,53568,53569,53571,53572,53573,53580,53581,53584,53588,53596,53597,53599,53601,53608,53612,53628,53636,53640,53664,53665,53668,53672,53680,53681,53683,53685,53690,53692,53696,53720,53748,53752,53767,53769,53776,53804,53805,53808,53812,53820,53821,53823,53825,53832,53852,55181,55182,55183,55185,55186,55187,55188,55189,55190,55191,55194,55196,55198,55199,55200,55201,55202,55203,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,53860,53888,53889,53892,53896,53904,53905,53909,53916,53920,53924,53932,53937,53944,53945,53948,53951,53952,53954,53960,53961,53963,53972,53976,53980,53988,53989,54000,54001,54004,54008,54016,54017,54019,54021,54028,54029,54030,54032,54036,54038,54044,54045,54047,54048,54049,54053,54056,54057,54060,54064,54072,54073,54075,54076,54077,54084,54085,54140,54141,54144,54148,54156,54157,54159,54160,54161,54168,54169,54172,54176,54184,54185,54187,54189,54196,54200,54204,54212,54213,54216,54217,54224,54232,54241,54243,54252,54253,54256,54260,54268,54269,54271,54273,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,54280,54301,54336,54340,54364,54368,54372,54381,54383,54392,54393,54396,54399,54400,54402,54408,54409,54411,54413,54420,54441,54476,54480,54484,54492,54495,54504,54508,54512,54520,54523,54525,54532,54536,54540,54548,54549,54551,54588,54589,54592,54596,54604,54605,54607,54609,54616,54617,54620,54624,54629,54632,54633,54635,54637,54644,54645,54648,54652,54660,54661,54663,54664,54665,54672,54693,54728,54729,54732,54736,54738,54744,54745,54747,54749,54756,54757,54760,54764,54772,54773,54775,54777,54784,54785,54788,54792,54800,54801,54803,54804,54805,54812,54816,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,54820,54829,54840,54841,54844,54848,54853,54856,54857,54859,54861,54865,54868,54869,54872,54876,54887,54889,54896,54897,54900,54915,54917,54924,54925,54928,54932,54941,54943,54945,54952,54956,54960,54969,54971,54980,54981,54984,54988,54993,54996,54999,55001,55008,55012,55016,55024,55029,55036,55037,55040,55044,55057,55064,55065,55068,55072,55080,55081,55083,55085,55092,55093,55096,55100,55108,55111,55113,55120,55121,55124,55126,55127,55128,55129,55136,55137,55139,55141,55145,55148,55152,55156,55164,55165,55169,55176,55177,55180,55184,55192,55193,55195,55197,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,20285,20339,20551,20729,21152,21487,21621,21733,22025,23233,23478,26247,26550,26551,26607,27468,29634,30146,31292,33499,33540,34903,34952,35382,36040,36303,36603,36838,39381,21051,21364,21508,24682,24932,27580,29647,33050,35258,35282,38307,20355,21002,22718,22904,23014,24178,24185,25031,25536,26438,26604,26751,28567,30286,30475,30965,31240,31487,31777,32925,33390,33393,35563,38291,20075,21917,26359,28212,30883,31469,33883,35088,34638,38824,21208,22350,22570,23884,24863,25022,25121,25954,26577,27204,28187,29976,30131,30435,30640,32058,37039,37969,37970,40853,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,21283,23724,30002,32987,37440,38296,21083,22536,23004,23713,23831,24247,24378,24394,24951,27743,30074,30086,31968,32115,32177,32652,33108,33313,34193,35137,35611,37628,38477,40007,20171,20215,20491,20977,22607,24887,24894,24936,25913,27114,28433,30117,30342,30422,31623,33445,33995,63744,37799,38283,21888,23458,22353,63745,31923,32697,37301,20520,21435,23621,24040,25298,25454,25818,25831,28192,28844,31067,36317,36382,63746,36989,37445,37624,20094,20214,20581,24062,24314,24838,26967,33137,34388,36423,37749,39467,20062,20625,26480,26688,20745,21133,21138,27298,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,30652,37392,40660,21163,24623,36850,20552,25001,25581,25802,26684,27268,28608,33160,35233,38548,22533,29309,29356,29956,32121,32365,32937,35211,35700,36963,40273,25225,27770,28500,32080,32570,35363,20860,24906,31645,35609,37463,37772,20140,20435,20510,20670,20742,21185,21197,21375,22384,22659,24218,24465,24950,25004,25806,25964,26223,26299,26356,26775,28039,28805,28913,29855,29861,29898,30169,30828,30956,31455,31478,32069,32147,32789,32831,33051,33686,35686,36629,36885,37857,38915,38968,39514,39912,20418,21843,22586,22865,23395,23622,24760,25106,26690,26800,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,26856,28330,30028,30328,30926,31293,31995,32363,32380,35336,35489,35903,38542,40388,21476,21481,21578,21617,22266,22993,23396,23611,24235,25335,25911,25925,25970,26272,26543,27073,27837,30204,30352,30590,31295,32660,32771,32929,33167,33510,33533,33776,34241,34865,34996,35493,63747,36764,37678,38599,39015,39640,40723,21741,26011,26354,26767,31296,35895,40288,22256,22372,23825,26118,26801,26829,28414,29736,34974,39908,27752,63748,39592,20379,20844,20849,21151,23380,24037,24656,24685,25329,25511,25915,29657,31354,34467,36002,38799,20018,23521,25096,26524,29916,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,31185,33747,35463,35506,36328,36942,37707,38982,24275,27112,34303,37101,63749,20896,23448,23532,24931,26874,27454,28748,29743,29912,31649,32592,33733,35264,36011,38364,39208,21038,24669,25324,36866,20362,20809,21281,22745,24291,26336,27960,28826,29378,29654,31568,33009,37979,21350,25499,32619,20054,20608,22602,22750,24618,24871,25296,27088,39745,23439,32024,32945,36703,20132,20689,21676,21932,23308,23968,24039,25898,25934,26657,27211,29409,30350,30703,32094,32761,33184,34126,34527,36611,36686,37066,39171,39509,39851,19992,20037,20061,20167,20465,20855,21246,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,21312,21475,21477,21646,22036,22389,22434,23495,23943,24272,25084,25304,25937,26552,26601,27083,27472,27590,27628,27714,28317,28792,29399,29590,29699,30655,30697,31350,32127,32777,33276,33285,33290,33503,34914,35635,36092,36544,36881,37041,37476,37558,39378,39493,40169,40407,40860,22283,23616,33738,38816,38827,40628,21531,31384,32676,35033,36557,37089,22528,23624,25496,31391,23470,24339,31353,31406,33422,36524,20518,21048,21240,21367,22280,25331,25458,27402,28099,30519,21413,29527,34152,36470,38357,26426,27331,28528,35437,36556,39243,63750,26231,27512,36020,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,39740,63751,21483,22317,22862,25542,27131,29674,30789,31418,31429,31998,33909,35215,36211,36917,38312,21243,22343,30023,31584,33740,37406,63752,27224,20811,21067,21127,25119,26840,26997,38553,20677,21156,21220,25027,26020,26681,27135,29822,31563,33465,33771,35250,35641,36817,39241,63753,20170,22935,25810,26129,27278,29748,31105,31165,33449,34942,34943,35167,63754,37670,20235,21450,24613,25201,27762,32026,32102,20120,20834,30684,32943,20225,20238,20854,20864,21980,22120,22331,22522,22524,22804,22855,22931,23492,23696,23822,24049,24190,24524,25216,26071,26083,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,26398,26399,26462,26827,26820,27231,27450,27683,27773,27778,28103,29592,29734,29738,29826,29859,30072,30079,30849,30959,31041,31047,31048,31098,31637,32000,32186,32648,32774,32813,32908,35352,35663,35912,36215,37665,37668,39138,39249,39438,39439,39525,40594,32202,20342,21513,25326,26708,37329,21931,20794,63755,63756,23068,25062,63757,25295,25343,63758,63759,63760,63761,63762,63763,37027,63764,63765,63766,63767,63768,35582,63769,63770,63771,63772,26262,63773,29014,63774,63775,38627,63776,25423,25466,21335,63777,26511,26976,28275,63778,30007,63779,63780,63781,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,32013,63782,63783,34930,22218,23064,63784,63785,63786,63787,63788,20035,63789,20839,22856,26608,32784,63790,22899,24180,25754,31178,24565,24684,25288,25467,23527,23511,21162,63791,22900,24361,24594,63792,63793,63794,29785,63795,63796,63797,63798,63799,63800,39377,63801,63802,63803,63804,63805,63806,63807,63808,63809,63810,63811,28611,63812,63813,33215,36786,24817,63814,63815,33126,63816,63817,23615,63818,63819,63820,63821,63822,63823,63824,63825,23273,35365,26491,32016,63826,63827,63828,63829,63830,63831,33021,63832,63833,23612,27877,21311,28346,22810,33590,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,20025,20150,20294,21934,22296,22727,24406,26039,26086,27264,27573,28237,30701,31471,31774,32222,34507,34962,37170,37723,25787,28606,29562,30136,36948,21846,22349,25018,25812,26311,28129,28251,28525,28601,30192,32835,33213,34113,35203,35527,35674,37663,27795,30035,31572,36367,36957,21776,22530,22616,24162,25095,25758,26848,30070,31958,34739,40680,20195,22408,22382,22823,23565,23729,24118,24453,25140,25825,29619,33274,34955,36024,38538,40667,23429,24503,24755,20498,20992,21040,22294,22581,22615,23566,23648,23798,23947,24230,24466,24764,25361,25481,25623,26691,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,26873,27330,28120,28193,28372,28644,29182,30428,30585,31153,31291,33796,35241,36077,36339,36424,36867,36884,36947,37117,37709,38518,38876,27602,28678,29272,29346,29544,30563,31167,31716,32411,35712,22697,24775,25958,26109,26302,27788,28958,29129,35930,38931,20077,31361,20189,20908,20941,21205,21516,24999,26481,26704,26847,27934,28540,30140,30643,31461,33012,33891,37509,20828,26007,26460,26515,30168,31431,33651,63834,35910,36887,38957,23663,33216,33434,36929,36975,37389,24471,23965,27225,29128,30331,31561,34276,35588,37159,39472,21895,25078,63835,30313,32645,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,34367,34746,35064,37007,63836,27931,28889,29662,32097,33853,63837,37226,39409,63838,20098,21365,27396,27410,28734,29211,34349,40478,21068,36771,23888,25829,25900,27414,28651,31811,32412,34253,35172,35261,25289,33240,34847,24266,26391,28010,29436,29701,29807,34690,37086,20358,23821,24480,33802,20919,25504,30053,20142,20486,20841,20937,26753,27153,31918,31921,31975,33391,35538,36635,37327,20406,20791,21237,21570,24300,24942,25150,26053,27354,28670,31018,34268,34851,38317,39522,39530,40599,40654,21147,26310,27511,28701,31019,36706,38722,24976,25088,25891,28451,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,29001,29833,32244,32879,34030,36646,36899,37706,20925,21015,21155,27916,28872,35010,24265,25986,27566,28610,31806,29557,20196,20278,22265,63839,23738,23994,24604,29618,31533,32666,32718,32838,36894,37428,38646,38728,38936,40801,20363,28583,31150,37300,38583,21214,63840,25736,25796,27347,28510,28696,29200,30439,32769,34310,34396,36335,36613,38706,39791,40442,40565,30860,31103,32160,33737,37636,40575,40595,35542,22751,24324,26407,28711,29903,31840,32894,20769,28712,29282,30922,36034,36058,36084,38647,20102,20698,23534,24278,26009,29134,30274,30637,32842,34044,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,36988,39719,40845,22744,23105,23650,27155,28122,28431,30267,32047,32311,34078,35128,37860,38475,21129,26066,26611,27060,27969,28316,28687,29705,29792,30041,30244,30827,35628,39006,20845,25134,38520,20374,20523,23833,28138,32184,36650,24459,24900,26647,63841,38534,21202,32907,20956,20940,26974,31260,32190,33777,38517,20442,21033,21400,21519,21774,23653,24743,26446,26792,28012,29313,29432,29702,29827,63842,30178,31852,32633,32696,33673,35023,35041,37324,37328,38626,39881,21533,28542,29136,29848,34298,36522,38563,40023,40607,26519,28107,29747,33256,38678,30764,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,31435,31520,31890,25705,29802,30194,30908,30952,39340,39764,40635,23518,24149,28448,33180,33707,37000,19975,21325,23081,24018,24398,24930,25405,26217,26364,28415,28459,28771,30622,33836,34067,34875,36627,39237,39995,21788,25273,26411,27819,33545,35178,38778,20129,22916,24536,24537,26395,32178,32596,33426,33579,33725,36638,37017,22475,22969,23186,23504,26151,26522,26757,27599,29028,32629,36023,36067,36993,39749,33032,35978,38476,39488,40613,23391,27667,29467,30450,30431,33804,20906,35219,20813,20885,21193,26825,27796,30468,30496,32191,32236,38754,40629,28357,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,34065,20901,21517,21629,26126,26269,26919,28319,30399,30609,33559,33986,34719,37225,37528,40180,34946,20398,20882,21215,22982,24125,24917,25720,25721,26286,26576,27169,27597,27611,29279,29281,29761,30520,30683,32791,33468,33541,35584,35624,35980,26408,27792,29287,30446,30566,31302,40361,27519,27794,22818,26406,33945,21359,22675,22937,24287,25551,26164,26483,28218,29483,31447,33495,37672,21209,24043,25006,25035,25098,25287,25771,26080,26969,27494,27595,28961,29687,30045,32326,33310,33538,34154,35491,36031,38695,40289,22696,40664,20497,21006,21563,21839,25991,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,27766,32010,32011,32862,34442,38272,38639,21247,27797,29289,21619,23194,23614,23883,24396,24494,26410,26806,26979,28220,28228,30473,31859,32654,34183,35598,36855,38753,40692,23735,24758,24845,25003,25935,26107,26108,27665,27887,29599,29641,32225,38292,23494,34588,35600,21085,21338,25293,25615,25778,26420,27192,27850,29632,29854,31636,31893,32283,33162,33334,34180,36843,38649,39361,20276,21322,21453,21467,25292,25644,25856,26001,27075,27886,28504,29677,30036,30242,30436,30460,30928,30971,31020,32070,33324,34784,36820,38930,39151,21187,25300,25765,28196,28497,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,30332,36299,37297,37474,39662,39747,20515,20621,22346,22952,23592,24135,24439,25151,25918,26041,26049,26121,26507,27036,28354,30917,32033,32938,33152,33323,33459,33953,34444,35370,35607,37030,38450,40848,20493,20467,63843,22521,24472,25308,25490,26479,28227,28953,30403,32972,32986,35060,35061,35097,36064,36649,37197,38506,20271,20336,24091,26575,26658,30333,30334,39748,24161,27146,29033,29140,30058,63844,32321,34115,34281,39132,20240,31567,32624,38309,20961,24070,26805,27710,27726,27867,29359,31684,33539,27861,29754,20731,21128,22721,25816,27287,29863,30294,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,30887,34327,38370,38713,63845,21342,24321,35722,36776,36783,37002,21029,30629,40009,40712,19993,20482,20853,23643,24183,26142,26170,26564,26821,28851,29953,30149,31177,31453,36647,39200,39432,20445,22561,22577,23542,26222,27493,27921,28282,28541,29668,29995,33769,35036,35091,35676,36628,20239,20693,21264,21340,23443,24489,26381,31119,33145,33583,34068,35079,35206,36665,36667,39333,39954,26412,20086,20472,22857,23553,23791,23792,25447,26834,28925,29090,29739,32299,34028,34562,36898,37586,40179,19981,20184,20463,20613,21078,21103,21542,21648,22496,22827,23142,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,23386,23413,23500,24220,63846,25206,25975,26023,28014,28325,29238,31526,31807,32566,33104,33105,33178,33344,33433,33705,35331,36000,36070,36091,36212,36282,37096,37340,38428,38468,39385,40167,21271,20998,21545,22132,22707,22868,22894,24575,24996,25198,26128,27774,28954,30406,31881,31966,32027,33452,36033,38640,63847,20315,24343,24447,25282,23849,26379,26842,30844,32323,40300,19989,20633,21269,21290,21329,22915,23138,24199,24754,24970,25161,25209,26000,26503,27047,27604,27606,27607,27608,27832,63848,29749,30202,30738,30865,31189,31192,31875,32203,32737,32933,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,33086,33218,33778,34586,35048,35513,35692,36027,37145,38750,39131,40763,22188,23338,24428,25996,27315,27567,27996,28657,28693,29277,29613,36007,36051,38971,24977,27703,32856,39425,20045,20107,20123,20181,20282,20284,20351,20447,20735,21490,21496,21766,21987,22235,22763,22882,23057,23531,23546,23556,24051,24107,24473,24605,25448,26012,26031,26614,26619,26797,27515,27801,27863,28195,28681,29509,30722,31038,31040,31072,31169,31721,32023,32114,32902,33293,33678,34001,34503,35039,35408,35422,35613,36060,36198,36781,37034,39164,39391,40605,21066,63849,26388,63850,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,20632,21034,23665,25955,27733,29642,29987,30109,31639,33948,37240,38704,20087,25746,27578,29022,34217,19977,63851,26441,26862,28183,33439,34072,34923,25591,28545,37394,39087,19978,20663,20687,20767,21830,21930,22039,23360,23577,23776,24120,24202,24224,24258,24819,26705,27233,28248,29245,29248,29376,30456,31077,31665,32724,35059,35316,35443,35937,36062,38684,22622,29885,36093,21959,63852,31329,32034,33394,29298,29983,29989,63853,31513,22661,22779,23996,24207,24246,24464,24661,25234,25471,25933,26257,26329,26360,26646,26866,29312,29790,31598,32110,32214,32626,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,32997,33298,34223,35199,35475,36893,37604,40653,40736,22805,22893,24109,24796,26132,26227,26512,27728,28101,28511,30707,30889,33990,37323,37675,20185,20682,20808,21892,23307,23459,25159,25982,26059,28210,29053,29697,29764,29831,29887,30316,31146,32218,32341,32680,33146,33203,33337,34330,34796,35445,36323,36984,37521,37925,39245,39854,21352,23633,26964,27844,27945,28203,33292,34203,35131,35373,35498,38634,40807,21089,26297,27570,32406,34814,36109,38275,38493,25885,28041,29166,63854,22478,22995,23468,24615,24826,25104,26143,26207,29481,29689,30427,30465,31596,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,32854,32882,33125,35488,37266,19990,21218,27506,27927,31237,31545,32048,63855,36016,21484,22063,22609,23477,23567,23569,24034,25152,25475,25620,26157,26803,27836,28040,28335,28703,28836,29138,29990,30095,30094,30233,31505,31712,31787,32032,32057,34092,34157,34311,35380,36877,36961,37045,37559,38902,39479,20439,23660,26463,28049,31903,32396,35606,36118,36895,23403,24061,25613,33984,36956,39137,29575,23435,24730,26494,28126,35359,35494,36865,38924,21047,63856,28753,30862,37782,34928,37335,20462,21463,22013,22234,22402,22781,23234,23432,23723,23744,24101,24833,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,25101,25163,25480,25628,25910,25976,27193,27530,27700,27929,28465,29159,29417,29560,29703,29874,30246,30561,31168,31319,31466,31929,32143,32172,32353,32670,33065,33585,33936,34010,34282,34966,35504,35728,36664,36930,36995,37228,37526,37561,38539,38567,38568,38614,38656,38920,39318,39635,39706,21460,22654,22809,23408,23487,28113,28506,29087,29729,29881,32901,33789,24033,24455,24490,24642,26092,26642,26991,27219,27529,27957,28147,29667,30462,30636,31565,32020,33059,33308,33600,34036,34147,35426,35524,37255,37662,38918,39348,25100,34899,36848,37477,23815,23847,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,23913,29791,33181,34664,28629,25342,32722,35126,35186,19998,20056,20711,21213,21319,25215,26119,32361,34821,38494,20365,21273,22070,22987,23204,23608,23630,23629,24066,24337,24643,26045,26159,26178,26558,26612,29468,30690,31034,32709,33940,33997,35222,35430,35433,35553,35925,35962,22516,23508,24335,24687,25325,26893,27542,28252,29060,31698,34645,35672,36606,39135,39166,20280,20353,20449,21627,23072,23480,24892,26032,26216,29180,30003,31070,32051,33102,33251,33688,34218,34254,34563,35338,36523,36763,63857,36805,22833,23460,23526,24713,23529,23563,24515,27777,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,63858,28145,28683,29978,33455,35574,20160,21313,63859,38617,27663,20126,20420,20818,21854,23077,23784,25105,29273,33469,33706,34558,34905,35357,38463,38597,39187,40201,40285,22538,23731,23997,24132,24801,24853,25569,27138,28197,37122,37716,38990,39952,40823,23433,23736,25353,26191,26696,30524,38593,38797,38996,39839,26017,35585,36555,38332,21813,23721,24022,24245,26263,30284,33780,38343,22739,25276,29390,40232,20208,22830,24591,26171,27523,31207,40230,21395,21696,22467,23830,24859,26326,28079,30861,33406,38552,38724,21380,25212,25494,28082,32266,33099,38989,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,27387,32588,40367,40474,20063,20539,20918,22812,24825,25590,26928,29242,32822,63860,37326,24369,63861,63862,32004,33509,33903,33979,34277,36493,63863,20335,63864,63865,22756,23363,24665,25562,25880,25965,26264,63866,26954,27171,27915,28673,29036,30162,30221,31155,31344,63867,32650,63868,35140,63869,35731,37312,38525,63870,39178,22276,24481,26044,28417,30208,31142,35486,39341,39770,40812,20740,25014,25233,27277,33222,20547,22576,24422,28937,35328,35578,23420,34326,20474,20796,22196,22852,25513,28153,23978,26989,20870,20104,20313,63871,63872,63873,22914,63874,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,63875,27487,27741,63876,29877,30998,63877,33287,33349,33593,36671,36701,63878,39192,63879,63880,63881,20134,63882,22495,24441,26131,63883,63884,30123,32377,35695,63885,36870,39515,22181,22567,23032,23071,23476,63886,24310,63887,63888,25424,25403,63889,26941,27783,27839,28046,28051,28149,28436,63890,28895,28982,29017,63891,29123,29141,63892,30799,30831,63893,31605,32227,63894,32303,63895,34893,36575,63896,63897,63898,37467,63899,40182,63900,63901,63902,24709,28037,63903,29105,63904,63905,38321,21421,63906,63907,63908,26579,63909,28814,28976,29744,33398,33490,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,63910,38331,39653,40573,26308,63911,29121,33865,63912,63913,22603,63914,63915,23992,24433,63916,26144,26254,27001,27054,27704,27891,28214,28481,28634,28699,28719,29008,29151,29552,63917,29787,63918,29908,30408,31310,32403,63919,63920,33521,35424,36814,63921,37704,63922,38681,63923,63924,20034,20522,63925,21000,21473,26355,27757,28618,29450,30591,31330,33454,34269,34306,63926,35028,35427,35709,35947,63927,37555,63928,38675,38928,20116,20237,20425,20658,21320,21566,21555,21978,22626,22714,22887,23067,23524,24735,63929,25034,25942,26111,26212,26791,27738,28595,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,28879,29100,29522,31613,34568,35492,39986,40711,23627,27779,29508,29577,37434,28331,29797,30239,31337,32277,34314,20800,22725,25793,29934,29973,30320,32705,37013,38605,39252,28198,29926,31401,31402,33253,34521,34680,35355,23113,23436,23451,26785,26880,28003,29609,29715,29740,30871,32233,32747,33048,33109,33694,35916,38446,38929,26352,24448,26106,26505,27754,29579,20525,23043,27498,30702,22806,23916,24013,29477,30031,63930,63931,20709,20985,22575,22829,22934,23002,23525,63932,63933,23970,25303,25622,25747,25854,63934,26332,63935,27208,63936,29183,29796,63937,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,31368,31407,32327,32350,32768,33136,63938,34799,35201,35616,36953,63939,36992,39250,24958,27442,28020,32287,35109,36785,20433,20653,20887,21191,22471,22665,23481,24248,24898,27029,28044,28263,28342,29076,29794,29992,29996,32883,33592,33993,36362,37780,37854,63940,20110,20305,20598,20778,21448,21451,21491,23431,23507,23588,24858,24962,26100,29275,29591,29760,30402,31056,31121,31161,32006,32701,33419,34261,34398,36802,36935,37109,37354,38533,38632,38633,21206,24423,26093,26161,26671,29020,31286,37057,38922,20113,63941,27218,27550,28560,29065,32792,33464,34131,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,36939,38549,38642,38907,34074,39729,20112,29066,38596,20803,21407,21729,22291,22290,22435,23195,23236,23491,24616,24895,25588,27781,27961,28274,28304,29232,29503,29783,33489,34945,36677,36960,63942,38498,39000,40219,26376,36234,37470,20301,20553,20702,21361,22285,22996,23041,23561,24944,26256,28205,29234,29771,32239,32963,33806,33894,34111,34655,34907,35096,35586,36949,38859,39759,20083,20369,20754,20842,63943,21807,21929,23418,23461,24188,24189,24254,24736,24799,24840,24841,25540,25912,26377,63944,26580,26586,63945,26977,26978,27833,27943,63946,28216,63947,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,28641,29494,29495,63948,29788,30001,63949,30290,63950,63951,32173,33278,33848,35029,35480,35547,35565,36400,36418,36938,36926,36986,37193,37321,37742,63952,63953,22537,63954,27603,32905,32946,63955,63956,20801,22891,23609,63957,63958,28516,29607,32996,36103,63959,37399,38287,63960,63961,63962,63963,32895,25102,28700,32104,34701,63964,22432,24681,24903,27575,35518,37504,38577,20057,21535,28139,34093,38512,38899,39150,25558,27875,37009,20957,25033,33210,40441,20381,20506,20736,23452,24847,25087,25836,26885,27589,30097,30691,32681,33380,34191,34811,34915,35516,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,35696,37291,20108,20197,20234,63965,63966,22839,23016,63967,24050,24347,24411,24609,63968,63969,63970,63971,29246,29669,63972,30064,30157,63973,31227,63974,32780,32819,32900,33505,33617,63975,63976,36029,36019,36999,63977,63978,39156,39180,63979,63980,28727,30410,32714,32716,32764,35610,20154,20161,20995,21360,63981,21693,22240,23035,23493,24341,24525,28270,63982,63983,32106,33589,63984,34451,35469,63985,38765,38775,63986,63987,19968,20314,20350,22777,26085,28322,36920,37808,39353,20219,22764,22922,23001,24641,63988,63989,31252,63990,33615,36035,20837,21316,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,63991,63992,63993,20173,21097,23381,33471,20180,21050,21672,22985,23039,23376,23383,23388,24675,24904,28363,28825,29038,29574,29943,30133,30913,32043,32773,33258,33576,34071,34249,35566,36039,38604,20316,21242,22204,26027,26152,28796,28856,29237,32189,33421,37196,38592,40306,23409,26855,27544,28538,30430,23697,26283,28507,31668,31786,34870,38620,19976,20183,21280,22580,22715,22767,22892,23559,24115,24196,24373,25484,26290,26454,27167,27299,27404,28479,29254,63994,29520,29835,31456,31911,33144,33247,33255,33674,33900,34083,34196,34255,35037,36115,37292,38263,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,38556,20877,21705,22312,23472,25165,26448,26685,26771,28221,28371,28797,32289,35009,36001,36617,40779,40782,29229,31631,35533,37658,20295,20302,20786,21632,22992,24213,25269,26485,26990,27159,27822,28186,29401,29482,30141,31672,32053,33511,33785,33879,34295,35419,36015,36487,36889,37048,38606,40799,21219,21514,23265,23490,25688,25973,28404,29380,63995,30340,31309,31515,31821,32318,32735,33659,35627,36042,36196,36321,36447,36842,36857,36969,37841,20291,20346,20659,20840,20856,21069,21098,22625,22652,22880,23560,23637,24283,24731,25136,26643,27583,27656,28593,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,29006,29728,30000,30008,30033,30322,31564,31627,31661,31686,32399,35438,36670,36681,37439,37523,37666,37931,38651,39002,39019,39198,20999,25130,25240,27993,30308,31434,31680,32118,21344,23742,24215,28472,28857,31896,38673,39822,40670,25509,25722,34678,19969,20117,20141,20572,20597,21576,22979,23450,24128,24237,24311,24449,24773,25402,25919,25972,26060,26230,26232,26622,26984,27273,27491,27712,28096,28136,28191,28254,28702,28833,29582,29693,30010,30555,30855,31118,31243,31357,31934,32142,33351,35330,35562,35998,37165,37194,37336,37478,37580,37664,38662,38742,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,38748,38914,40718,21046,21137,21884,22564,24093,24351,24716,25552,26799,28639,31085,31532,33229,34234,35069,35576,36420,37261,38500,38555,38717,38988,40778,20430,20806,20939,21161,22066,24340,24427,25514,25805,26089,26177,26362,26361,26397,26781,26839,27133,28437,28526,29031,29157,29226,29866,30522,31062,31066,31199,31264,31381,31895,31967,32068,32368,32903,34299,34468,35412,35519,36249,36481,36896,36973,37347,38459,38613,40165,26063,31751,36275,37827,23384,23562,21330,25305,29469,20519,23447,24478,24752,24939,26837,28121,29742,31278,32066,32156,32305,33131,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,36394,36405,37758,37912,20304,22352,24038,24231,25387,32618,20027,20303,20367,20570,23005,32964,21610,21608,22014,22863,23449,24030,24282,26205,26417,26609,26666,27880,27954,28234,28557,28855,29664,30087,31820,32002,32044,32162,33311,34523,35387,35461,36208,36490,36659,36913,37198,37202,37956,39376,31481,31909,20426,20737,20934,22472,23535,23803,26201,27197,27994,28310,28652,28940,30063,31459,34850,36897,36981,38603,39423,33537,20013,20210,34886,37325,21373,27355,26987,27713,33914,22686,24974,26366,25327,28893,29969,30151,32338,33976,35657,36104,20043,21482,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,21675,22320,22336,24535,25345,25351,25711,25903,26088,26234,26525,26547,27490,27744,27802,28460,30693,30757,31049,31063,32025,32930,33026,33267,33437,33463,34584,35468,63996,36100,36286,36978,30452,31257,31287,32340,32887,21767,21972,22645,25391,25634,26185,26187,26733,27035,27524,27941,28337,29645,29800,29857,30043,30137,30433,30494,30603,31206,32265,32285,33275,34095,34967,35386,36049,36587,36784,36914,37805,38499,38515,38663,20356,21489,23018,23241,24089,26702,29894,30142,31209,31378,33187,34541,36074,36300,36845,26015,26389,63997,22519,28503,32221,36655,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,37878,38598,24501,25074,28548,19988,20376,20511,21449,21983,23919,24046,27425,27492,30923,31642,63998,36425,36554,36974,25417,25662,30528,31364,37679,38015,40810,25776,28591,29158,29864,29914,31428,31762,32386,31922,32408,35738,36106,38013,39184,39244,21049,23519,25830,26413,32046,20717,21443,22649,24920,24921,25082,26028,31449,35730,35734,20489,20513,21109,21809,23100,24288,24432,24884,25950,26124,26166,26274,27085,28356,28466,29462,30241,31379,33081,33369,33750,33980,20661,22512,23488,23528,24425,25505,30758,32181,33756,34081,37319,37365,20874,26613,31574,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,36012,20932,22971,24765,34389,20508,63999,21076,23610,24957,25114,25299,25842,26021,28364,30240,33034,36448,38495,38587,20191,21315,21912,22825,24029,25797,27849,28154,29588,31359,33307,34214,36068,36368,36983,37351,38369,38433,38854,20984,21746,21894,24505,25764,28552,32180,36639,36685,37941,20681,23574,27838,28155,29979,30651,31805,31844,35449,35522,22558,22974,24086,25463,29266,30090,30571,35548,36028,36626,24307,26228,28152,32893,33729,35531,38737,39894,64000,21059,26367,28053,28399,32224,35558,36910,36958,39636,21021,21119,21736,24980,25220,25307,26786,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,26898,26970,27189,28818,28966,30813,30977,30990,31186,31245,32918,33400,33493,33609,34121,35970,36229,37218,37259,37294,20419,22225,29165,30679,34560,35320,23544,24534,26449,37032,21474,22618,23541,24740,24961,25696,32317,32880,34085,37507,25774,20652,23828,26368,22684,25277,25512,26894,27000,27166,28267,30394,31179,33467,33833,35535,36264,36861,37138,37195,37276,37648,37656,37786,38619,39478,39949,19985,30044,31069,31482,31569,31689,32302,33988,36441,36468,36600,36880,26149,26943,29763,20986,26414,40668,20805,24544,27798,34802,34909,34935,24756,33205,33795,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,36101,21462,21561,22068,23094,23601,28810,32736,32858,33030,33261,36259,37257,39519,40434,20596,20164,21408,24827,28204,23652,20360,20516,21988,23769,24159,24677,26772,27835,28100,29118,30164,30196,30305,31258,31305,32199,32251,32622,33268,34473,36636,38601,39347,40786,21063,21189,39149,35242,19971,26578,28422,20405,23522,26517,27784,28024,29723,30759,37341,37756,34756,31204,31281,24555,20182,21668,21822,22702,22949,24816,25171,25302,26422,26965,33333,38464,39345,39389,20524,21331,21828,22396,64001,25176,64002,25826,26219,26589,28609,28655,29730,29752,35351,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,37944,21585,22022,22374,24392,24986,27470,28760,28845,32187,35477,22890,33067,25506,30472,32829,36010,22612,25645,27067,23445,24081,28271,64003,34153,20812,21488,22826,24608,24907,27526,27760,27888,31518,32974,33492,36294,37040,39089,64004,25799,28580,25745,25860,20814,21520,22303,35342,24927,26742,64005,30171,31570,32113,36890,22534,27084,33151,35114,36864,38969,20600,22871,22956,25237,36879,39722,24925,29305,38358,22369,23110,24052,25226,25773,25850,26487,27874,27966,29228,29750,30772,32631,33453,36315,38935,21028,22338,26495,29256,29923,36009,36774,37393,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,38442,20843,21485,25420,20329,21764,24726,25943,27803,28031,29260,29437,31255,35207,35997,24429,28558,28921,33192,24846,20415,20559,25153,29255,31687,32232,32745,36941,38829,39449,36022,22378,24179,26544,33805,35413,21536,23318,24163,24290,24330,25987,32954,34109,38281,38491,20296,21253,21261,21263,21638,21754,22275,24067,24598,25243,25265,25429,64006,27873,28006,30129,30770,32990,33071,33502,33889,33970,34957,35090,36875,37610,39165,39825,24133,26292,26333,28689,29190,64007,20469,21117,24426,24915,26451,27161,28418,29922,31080,34920,35961,39111,39108,39491,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,21697,31263,26963,35575,35914,39080,39342,24444,25259,30130,30382,34987,36991,38466,21305,24380,24517,27852,29644,30050,30091,31558,33534,39325,20047,36924,19979,20309,21414,22799,24264,26160,27827,29781,33655,34662,36032,36944,38686,39957,22737,23416,34384,35604,40372,23506,24680,24717,26097,27735,28450,28579,28698,32597,32752,38289,38290,38480,38867,21106,36676,20989,21547,21688,21859,21898,27323,28085,32216,33382,37532,38519,40569,21512,21704,30418,34532,38308,38356,38492,20130,20233,23022,23270,24055,24658,25239,26477,26689,27782,28207,32568,32923,33322,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,64008,64009,38917,20133,20565,21683,22419,22874,23401,23475,25032,26999,28023,28707,34809,35299,35442,35559,36994,39405,39608,21182,26680,20502,24184,26447,33607,34892,20139,21521,22190,29670,37141,38911,39177,39255,39321,22099,22687,34395,35377,25010,27382,29563,36562,27463,38570,39511,22869,29184,36203,38761,20436,23796,24358,25080,26203,27883,28843,29572,29625,29694,30505,30541,32067,32098,32291,33335,34898,64010,36066,37449,39023,23377,31348,34880,38913,23244,20448,21332,22846,23805,25406,28025,29433,33029,33031,33698,37583,38960,20136,20804,21009,22411,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,24418,27842,28366,28677,28752,28847,29074,29673,29801,33610,34722,34913,36872,37026,37795,39336,20846,24407,24800,24935,26291,34137,36426,37295,38795,20046,20114,21628,22741,22778,22909,23733,24359,25142,25160,26122,26215,27627,28009,28111,28246,28408,28564,28640,28649,28765,29392,29733,29786,29920,30355,31068,31946,32286,32993,33446,33899,33983,34382,34399,34676,35703,35946,37804,38912,39013,24785,25110,37239,23130,26127,28151,28222,29759,39746,24573,24794,31503,21700,24344,27742,27859,27946,28888,32005,34425,35340,40251,21270,21644,23301,27194,28779,30069,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,31117,31166,33457,33775,35441,35649,36008,38772,64011,25844,25899,30906,30907,31339,20024,21914,22864,23462,24187,24739,25563,27489,26213,26707,28185,29029,29872,32008,36996,39529,39973,27963,28369,29502,35905,38346,20976,24140,24488,24653,24822,24880,24908,26179,26180,27045,27841,28255,28361,28514,29004,29852,30343,31681,31783,33618,34647,36945,38541,40643,21295,22238,24315,24458,24674,24724,25079,26214,26371,27292,28142,28590,28784,29546,32362,33214,33588,34516,35496,36036,21123,29554,23446,27243,37892,21742,22150,23389,25928,25989,26313,26783,28045,28102,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,29243,32948,37237,39501,20399,20505,21402,21518,21564,21897,21957,24127,24460,26429,29030,29661,36869,21211,21235,22628,22734,28932,29071,29179,34224,35347,26248,34216,21927,26244,29002,33841,21321,21913,27585,24409,24509,25582,26249,28999,35569,36637,40638,20241,25658,28875,30054,34407,24676,35662,40440,20807,20982,21256,27958,33016,40657,26133,27427,28824,30165,21507,23673,32007,35350,27424,27453,27462,21560,24688,27965,32725,33288,20694,20958,21916,22123,22221,23020,23305,24076,24985,24984,25137,26206,26342,29081,29113,29114,29351,31143,31232,32690,35440,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null],
    "gb18030":[19970,19972,19973,19974,19983,19986,19991,19999,20000,20001,20003,20006,20009,20014,20015,20017,20019,20021,20023,20028,20032,20033,20034,20036,20038,20042,20049,20053,20055,20058,20059,20066,20067,20068,20069,20071,20072,20074,20075,20076,20077,20078,20079,20082,20084,20085,20086,20087,20088,20089,20090,20091,20092,20093,20095,20096,20097,20098,20099,20100,20101,20103,20106,20112,20118,20119,20121,20124,20125,20126,20131,20138,20143,20144,20145,20148,20150,20151,20152,20153,20156,20157,20158,20168,20172,20175,20176,20178,20186,20187,20188,20192,20194,20198,20199,20201,20205,20206,20207,20209,20212,20216,20217,20218,20220,20222,20224,20226,20227,20228,20229,20230,20231,20232,20235,20236,20242,20243,20244,20245,20246,20252,20253,20257,20259,20264,20265,20268,20269,20270,20273,20275,20277,20279,20281,20283,20286,20287,20288,20289,20290,20292,20293,20295,20296,20297,20298,20299,20300,20306,20308,20310,20321,20322,20326,20328,20330,20331,20333,20334,20337,20338,20341,20343,20344,20345,20346,20349,20352,20353,20354,20357,20358,20359,20362,20364,20366,20368,20370,20371,20373,20374,20376,20377,20378,20380,20382,20383,20385,20386,20388,20395,20397,20400,20401,20402,20403,20404,20406,20407,20408,20409,20410,20411,20412,20413,20414,20416,20417,20418,20422,20423,20424,20425,20427,20428,20429,20434,20435,20436,20437,20438,20441,20443,20448,20450,20452,20453,20455,20459,20460,20464,20466,20468,20469,20470,20471,20473,20475,20476,20477,20479,20480,20481,20482,20483,20484,20485,20486,20487,20488,20489,20490,20491,20494,20496,20497,20499,20501,20502,20503,20507,20509,20510,20512,20514,20515,20516,20519,20523,20527,20528,20529,20530,20531,20532,20533,20534,20535,20536,20537,20539,20541,20543,20544,20545,20546,20548,20549,20550,20553,20554,20555,20557,20560,20561,20562,20563,20564,20566,20567,20568,20569,20571,20573,20574,20575,20576,20577,20578,20579,20580,20582,20583,20584,20585,20586,20587,20589,20590,20591,20592,20593,20594,20595,20596,20597,20600,20601,20602,20604,20605,20609,20610,20611,20612,20614,20615,20617,20618,20619,20620,20622,20623,20624,20625,20626,20627,20628,20629,20630,20631,20632,20633,20634,20635,20636,20637,20638,20639,20640,20641,20642,20644,20646,20650,20651,20653,20654,20655,20656,20657,20659,20660,20661,20662,20663,20664,20665,20668,20669,20670,20671,20672,20673,20674,20675,20676,20677,20678,20679,20680,20681,20682,20683,20684,20685,20686,20688,20689,20690,20691,20692,20693,20695,20696,20697,20699,20700,20701,20702,20703,20704,20705,20706,20707,20708,20709,20712,20713,20714,20715,20719,20720,20721,20722,20724,20726,20727,20728,20729,20730,20732,20733,20734,20735,20736,20737,20738,20739,20740,20741,20744,20745,20746,20748,20749,20750,20751,20752,20753,20755,20756,20757,20758,20759,20760,20761,20762,20763,20764,20765,20766,20767,20768,20770,20771,20772,20773,20774,20775,20776,20777,20778,20779,20780,20781,20782,20783,20784,20785,20786,20787,20788,20789,20790,20791,20792,20793,20794,20795,20796,20797,20798,20802,20807,20810,20812,20814,20815,20816,20818,20819,20823,20824,20825,20827,20829,20830,20831,20832,20833,20835,20836,20838,20839,20841,20842,20847,20850,20858,20862,20863,20867,20868,20870,20871,20874,20875,20878,20879,20880,20881,20883,20884,20888,20890,20893,20894,20895,20897,20899,20902,20903,20904,20905,20906,20909,20910,20916,20920,20921,20922,20926,20927,20929,20930,20931,20933,20936,20938,20941,20942,20944,20946,20947,20948,20949,20950,20951,20952,20953,20954,20956,20958,20959,20962,20963,20965,20966,20967,20968,20969,20970,20972,20974,20977,20978,20980,20983,20990,20996,20997,21001,21003,21004,21007,21008,21011,21012,21013,21020,21022,21023,21025,21026,21027,21029,21030,21031,21034,21036,21039,21041,21042,21044,21045,21052,21054,21060,21061,21062,21063,21064,21065,21067,21070,21071,21074,21075,21077,21079,21080,21081,21082,21083,21085,21087,21088,21090,21091,21092,21094,21096,21099,21100,21101,21102,21104,21105,21107,21108,21109,21110,21111,21112,21113,21114,21115,21116,21118,21120,21123,21124,21125,21126,21127,21129,21130,21131,21132,21133,21134,21135,21137,21138,21140,21141,21142,21143,21144,21145,21146,21148,21156,21157,21158,21159,21166,21167,21168,21172,21173,21174,21175,21176,21177,21178,21179,21180,21181,21184,21185,21186,21188,21189,21190,21192,21194,21196,21197,21198,21199,21201,21203,21204,21205,21207,21209,21210,21211,21212,21213,21214,21216,21217,21218,21219,21221,21222,21223,21224,21225,21226,21227,21228,21229,21230,21231,21233,21234,21235,21236,21237,21238,21239,21240,21243,21244,21245,21249,21250,21251,21252,21255,21257,21258,21259,21260,21262,21265,21266,21267,21268,21272,21275,21276,21278,21279,21282,21284,21285,21287,21288,21289,21291,21292,21293,21295,21296,21297,21298,21299,21300,21301,21302,21303,21304,21308,21309,21312,21314,21316,21318,21323,21324,21325,21328,21332,21336,21337,21339,21341,21349,21352,21354,21356,21357,21362,21366,21369,21371,21372,21373,21374,21376,21377,21379,21383,21384,21386,21390,21391,21392,21393,21394,21395,21396,21398,21399,21401,21403,21404,21406,21408,21409,21412,21415,21418,21419,21420,21421,21423,21424,21425,21426,21427,21428,21429,21431,21432,21433,21434,21436,21437,21438,21440,21443,21444,21445,21446,21447,21454,21455,21456,21458,21459,21461,21466,21468,21469,21470,21473,21474,21479,21492,21498,21502,21503,21504,21506,21509,21511,21515,21524,21528,21529,21530,21532,21538,21540,21541,21546,21552,21555,21558,21559,21562,21565,21567,21569,21570,21572,21573,21575,21577,21580,21581,21582,21583,21585,21594,21597,21598,21599,21600,21601,21603,21605,21607,21609,21610,21611,21612,21613,21614,21615,21616,21620,21625,21626,21630,21631,21633,21635,21637,21639,21640,21641,21642,21645,21649,21651,21655,21656,21660,21662,21663,21664,21665,21666,21669,21678,21680,21682,21685,21686,21687,21689,21690,21692,21694,21699,21701,21706,21707,21718,21720,21723,21728,21729,21730,21731,21732,21739,21740,21743,21744,21745,21748,21749,21750,21751,21752,21753,21755,21758,21760,21762,21763,21764,21765,21768,21770,21771,21772,21773,21774,21778,21779,21781,21782,21783,21784,21785,21786,21788,21789,21790,21791,21793,21797,21798,21800,21801,21803,21805,21810,21812,21813,21814,21816,21817,21818,21819,21821,21824,21826,21829,21831,21832,21835,21836,21837,21838,21839,21841,21842,21843,21844,21847,21848,21849,21850,21851,21853,21854,21855,21856,21858,21859,21864,21865,21867,21871,21872,21873,21874,21875,21876,21881,21882,21885,21887,21893,21894,21900,21901,21902,21904,21906,21907,21909,21910,21911,21914,21915,21918,21920,21921,21922,21923,21924,21925,21926,21928,21929,21930,21931,21932,21933,21934,21935,21936,21938,21940,21942,21944,21946,21948,21951,21952,21953,21954,21955,21958,21959,21960,21962,21963,21966,21967,21968,21973,21975,21976,21977,21978,21979,21982,21984,21986,21991,21993,21997,21998,22000,22001,22004,22006,22008,22009,22010,22011,22012,22015,22018,22019,22020,22021,22022,22023,22026,22027,22029,22032,22033,22034,22035,22036,22037,22038,22039,22041,22042,22044,22045,22048,22049,22050,22053,22054,22056,22057,22058,22059,22062,22063,22064,22067,22069,22071,22072,22074,22076,22077,22078,22080,22081,22082,22083,22084,22085,22086,22087,22088,22089,22090,22091,22095,22096,22097,22098,22099,22101,22102,22106,22107,22109,22110,22111,22112,22113,22115,22117,22118,22119,22125,22126,22127,22128,22130,22131,22132,22133,22135,22136,22137,22138,22141,22142,22143,22144,22145,22146,22147,22148,22151,22152,22153,22154,22155,22156,22157,22160,22161,22162,22164,22165,22166,22167,22168,22169,22170,22171,22172,22173,22174,22175,22176,22177,22178,22180,22181,22182,22183,22184,22185,22186,22187,22188,22189,22190,22192,22193,22194,22195,22196,22197,22198,22200,22201,22202,22203,22205,22206,22207,22208,22209,22210,22211,22212,22213,22214,22215,22216,22217,22219,22220,22221,22222,22223,22224,22225,22226,22227,22229,22230,22232,22233,22236,22243,22245,22246,22247,22248,22249,22250,22252,22254,22255,22258,22259,22262,22263,22264,22267,22268,22272,22273,22274,22277,22279,22283,22284,22285,22286,22287,22288,22289,22290,22291,22292,22293,22294,22295,22296,22297,22298,22299,22301,22302,22304,22305,22306,22308,22309,22310,22311,22315,22321,22322,22324,22325,22326,22327,22328,22332,22333,22335,22337,22339,22340,22341,22342,22344,22345,22347,22354,22355,22356,22357,22358,22360,22361,22370,22371,22373,22375,22380,22382,22384,22385,22386,22388,22389,22392,22393,22394,22397,22398,22399,22400,22401,22407,22408,22409,22410,22413,22414,22415,22416,22417,22420,22421,22422,22423,22424,22425,22426,22428,22429,22430,22431,22437,22440,22442,22444,22447,22448,22449,22451,22453,22454,22455,22457,22458,22459,22460,22461,22462,22463,22464,22465,22468,22469,22470,22471,22472,22473,22474,22476,22477,22480,22481,22483,22486,22487,22491,22492,22494,22497,22498,22499,22501,22502,22503,22504,22505,22506,22507,22508,22510,22512,22513,22514,22515,22517,22518,22519,22523,22524,22526,22527,22529,22531,22532,22533,22536,22537,22538,22540,22542,22543,22544,22546,22547,22548,22550,22551,22552,22554,22555,22556,22557,22559,22562,22563,22565,22566,22567,22568,22569,22571,22572,22573,22574,22575,22577,22578,22579,22580,22582,22583,22584,22585,22586,22587,22588,22589,22590,22591,22592,22593,22594,22595,22597,22598,22599,22600,22601,22602,22603,22606,22607,22608,22610,22611,22613,22614,22615,22617,22618,22619,22620,22621,22623,22624,22625,22626,22627,22628,22630,22631,22632,22633,22634,22637,22638,22639,22640,22641,22642,22643,22644,22645,22646,22647,22648,22649,22650,22651,22652,22653,22655,22658,22660,22662,22663,22664,22666,22667,22668,22669,22670,22671,22672,22673,22676,22677,22678,22679,22680,22683,22684,22685,22688,22689,22690,22691,22692,22693,22694,22695,22698,22699,22700,22701,22702,22703,22704,22705,22706,22707,22708,22709,22710,22711,22712,22713,22714,22715,22717,22718,22719,22720,22722,22723,22724,22726,22727,22728,22729,22730,22731,22732,22733,22734,22735,22736,22738,22739,22740,22742,22743,22744,22745,22746,22747,22748,22749,22750,22751,22752,22753,22754,22755,22757,22758,22759,22760,22761,22762,22765,22767,22769,22770,22772,22773,22775,22776,22778,22779,22780,22781,22782,22783,22784,22785,22787,22789,22790,22792,22793,22794,22795,22796,22798,22800,22801,22802,22803,22807,22808,22811,22813,22814,22816,22817,22818,22819,22822,22824,22828,22832,22834,22835,22837,22838,22843,22845,22846,22847,22848,22851,22853,22854,22858,22860,22861,22864,22866,22867,22873,22875,22876,22877,22878,22879,22881,22883,22884,22886,22887,22888,22889,22890,22891,22892,22893,22894,22895,22896,22897,22898,22901,22903,22906,22907,22908,22910,22911,22912,22917,22921,22923,22924,22926,22927,22928,22929,22932,22933,22936,22938,22939,22940,22941,22943,22944,22945,22946,22950,22951,22956,22957,22960,22961,22963,22964,22965,22966,22967,22968,22970,22972,22973,22975,22976,22977,22978,22979,22980,22981,22983,22984,22985,22988,22989,22990,22991,22997,22998,23001,23003,23006,23007,23008,23009,23010,23012,23014,23015,23017,23018,23019,23021,23022,23023,23024,23025,23026,23027,23028,23029,23030,23031,23032,23034,23036,23037,23038,23040,23042,23050,23051,23053,23054,23055,23056,23058,23060,23061,23062,23063,23065,23066,23067,23069,23070,23073,23074,23076,23078,23079,23080,23082,23083,23084,23085,23086,23087,23088,23091,23093,23095,23096,23097,23098,23099,23101,23102,23103,23105,23106,23107,23108,23109,23111,23112,23115,23116,23117,23118,23119,23120,23121,23122,23123,23124,23126,23127,23128,23129,23131,23132,23133,23134,23135,23136,23137,23139,23140,23141,23142,23144,23145,23147,23148,23149,23150,23151,23152,23153,23154,23155,23160,23161,23163,23164,23165,23166,23168,23169,23170,23171,23172,23173,23174,23175,23176,23177,23178,23179,23180,23181,23182,23183,23184,23185,23187,23188,23189,23190,23191,23192,23193,23196,23197,23198,23199,23200,23201,23202,23203,23204,23205,23206,23207,23208,23209,23211,23212,23213,23214,23215,23216,23217,23220,23222,23223,23225,23226,23227,23228,23229,23231,23232,23235,23236,23237,23238,23239,23240,23242,23243,23245,23246,23247,23248,23249,23251,23253,23255,23257,23258,23259,23261,23262,23263,23266,23268,23269,23271,23272,23274,23276,23277,23278,23279,23280,23282,23283,23284,23285,23286,23287,23288,23289,23290,23291,23292,23293,23294,23295,23296,23297,23298,23299,23300,23301,23302,23303,23304,23306,23307,23308,23309,23310,23311,23312,23313,23314,23315,23316,23317,23320,23321,23322,23323,23324,23325,23326,23327,23328,23329,23330,23331,23332,23333,23334,23335,23336,23337,23338,23339,23340,23341,23342,23343,23344,23345,23347,23349,23350,23352,23353,23354,23355,23356,23357,23358,23359,23361,23362,23363,23364,23365,23366,23367,23368,23369,23370,23371,23372,23373,23374,23375,23378,23382,23390,23392,23393,23399,23400,23403,23405,23406,23407,23410,23412,23414,23415,23416,23417,23419,23420,23422,23423,23426,23430,23434,23437,23438,23440,23441,23442,23444,23446,23455,23463,23464,23465,23468,23469,23470,23471,23473,23474,23479,23482,23483,23484,23488,23489,23491,23496,23497,23498,23499,23501,23502,23503,23505,23508,23509,23510,23511,23512,23513,23514,23515,23516,23520,23522,23523,23526,23527,23529,23530,23531,23532,23533,23535,23537,23538,23539,23540,23541,23542,23543,23549,23550,23552,23554,23555,23557,23559,23560,23563,23564,23565,23566,23568,23570,23571,23575,23577,23579,23582,23583,23584,23585,23587,23590,23592,23593,23594,23595,23597,23598,23599,23600,23602,23603,23605,23606,23607,23619,23620,23622,23623,23628,23629,23634,23635,23636,23638,23639,23640,23642,23643,23644,23645,23647,23650,23652,23655,23656,23657,23658,23659,23660,23661,23664,23666,23667,23668,23669,23670,23671,23672,23675,23676,23677,23678,23680,23683,23684,23685,23686,23687,23689,23690,23691,23694,23695,23698,23699,23701,23709,23710,23711,23712,23713,23716,23717,23718,23719,23720,23722,23726,23727,23728,23730,23732,23734,23737,23738,23739,23740,23742,23744,23746,23747,23749,23750,23751,23752,23753,23754,23756,23757,23758,23759,23760,23761,23763,23764,23765,23766,23767,23768,23770,23771,23772,23773,23774,23775,23776,23778,23779,23783,23785,23787,23788,23790,23791,23793,23794,23795,23796,23797,23798,23799,23800,23801,23802,23804,23805,23806,23807,23808,23809,23812,23813,23816,23817,23818,23819,23820,23821,23823,23824,23825,23826,23827,23829,23831,23832,23833,23834,23836,23837,23839,23840,23841,23842,23843,23845,23848,23850,23851,23852,23855,23856,23857,23858,23859,23861,23862,23863,23864,23865,23866,23867,23868,23871,23872,23873,23874,23875,23876,23877,23878,23880,23881,23885,23886,23887,23888,23889,23890,23891,23892,23893,23894,23895,23897,23898,23900,23902,23903,23904,23905,23906,23907,23908,23909,23910,23911,23912,23914,23917,23918,23920,23921,23922,23923,23925,23926,23927,23928,23929,23930,23931,23932,23933,23934,23935,23936,23937,23939,23940,23941,23942,23943,23944,23945,23946,23947,23948,23949,23950,23951,23952,23953,23954,23955,23956,23957,23958,23959,23960,23962,23963,23964,23966,23967,23968,23969,23970,23971,23972,23973,23974,23975,23976,23977,23978,23979,23980,23981,23982,23983,23984,23985,23986,23987,23988,23989,23990,23992,23993,23994,23995,23996,23997,23998,23999,24000,24001,24002,24003,24004,24006,24007,24008,24009,24010,24011,24012,24014,24015,24016,24017,24018,24019,24020,24021,24022,24023,24024,24025,24026,24028,24031,24032,24035,24036,24042,24044,24045,24048,24053,24054,24056,24057,24058,24059,24060,24063,24064,24068,24071,24073,24074,24075,24077,24078,24082,24083,24087,24094,24095,24096,24097,24098,24099,24100,24101,24104,24105,24106,24107,24108,24111,24112,24114,24115,24116,24117,24118,24121,24122,24126,24127,24128,24129,24131,24134,24135,24136,24137,24138,24139,24141,24142,24143,24144,24145,24146,24147,24150,24151,24152,24153,24154,24156,24157,24159,24160,24163,24164,24165,24166,24167,24168,24169,24170,24171,24172,24173,24174,24175,24176,24177,24181,24183,24185,24190,24193,24194,24195,24197,24200,24201,24204,24205,24206,24210,24216,24219,24221,24225,24226,24227,24228,24232,24233,24234,24235,24236,24238,24239,24240,24241,24242,24244,24250,24251,24252,24253,24255,24256,24257,24258,24259,24260,24261,24262,24263,24264,24267,24268,24269,24270,24271,24272,24276,24277,24279,24280,24281,24282,24284,24285,24286,24287,24288,24289,24290,24291,24292,24293,24294,24295,24297,24299,24300,24301,24302,24303,24304,24305,24306,24307,24309,24312,24313,24315,24316,24317,24325,24326,24327,24329,24332,24333,24334,24336,24338,24340,24342,24345,24346,24348,24349,24350,24353,24354,24355,24356,24360,24363,24364,24366,24368,24370,24371,24372,24373,24374,24375,24376,24379,24381,24382,24383,24385,24386,24387,24388,24389,24390,24391,24392,24393,24394,24395,24396,24397,24398,24399,24401,24404,24409,24410,24411,24412,24414,24415,24416,24419,24421,24423,24424,24427,24430,24431,24434,24436,24437,24438,24440,24442,24445,24446,24447,24451,24454,24461,24462,24463,24465,24467,24468,24470,24474,24475,24477,24478,24479,24480,24482,24483,24484,24485,24486,24487,24489,24491,24492,24495,24496,24497,24498,24499,24500,24502,24504,24505,24506,24507,24510,24511,24512,24513,24514,24519,24520,24522,24523,24526,24531,24532,24533,24538,24539,24540,24542,24543,24546,24547,24549,24550,24552,24553,24556,24559,24560,24562,24563,24564,24566,24567,24569,24570,24572,24583,24584,24585,24587,24588,24592,24593,24595,24599,24600,24602,24606,24607,24610,24611,24612,24620,24621,24622,24624,24625,24626,24627,24628,24630,24631,24632,24633,24634,24637,24638,24640,24644,24645,24646,24647,24648,24649,24650,24652,24654,24655,24657,24659,24660,24662,24663,24664,24667,24668,24670,24671,24672,24673,24677,24678,24686,24689,24690,24692,24693,24695,24702,24704,24705,24706,24709,24710,24711,24712,24714,24715,24718,24719,24720,24721,24723,24725,24727,24728,24729,24732,24734,24737,24738,24740,24741,24743,24745,24746,24750,24752,24755,24757,24758,24759,24761,24762,24765,24766,24767,24768,24769,24770,24771,24772,24775,24776,24777,24780,24781,24782,24783,24784,24786,24787,24788,24790,24791,24793,24795,24798,24801,24802,24803,24804,24805,24810,24817,24818,24821,24823,24824,24827,24828,24829,24830,24831,24834,24835,24836,24837,24839,24842,24843,24844,24848,24849,24850,24851,24852,24854,24855,24856,24857,24859,24860,24861,24862,24865,24866,24869,24872,24873,24874,24876,24877,24878,24879,24880,24881,24882,24883,24884,24885,24886,24887,24888,24889,24890,24891,24892,24893,24894,24896,24897,24898,24899,24900,24901,24902,24903,24905,24907,24909,24911,24912,24914,24915,24916,24918,24919,24920,24921,24922,24923,24924,24926,24927,24928,24929,24931,24932,24933,24934,24937,24938,24939,24940,24941,24942,24943,24945,24946,24947,24948,24950,24952,24953,24954,24955,24956,24957,24958,24959,24960,24961,24962,24963,24964,24965,24966,24967,24968,24969,24970,24972,24973,24975,24976,24977,24978,24979,24981,24982,24983,24984,24985,24986,24987,24988,24990,24991,24992,24993,24994,24995,24996,24997,24998,25002,25003,25005,25006,25007,25008,25009,25010,25011,25012,25013,25014,25016,25017,25018,25019,25020,25021,25023,25024,25025,25027,25028,25029,25030,25031,25033,25036,25037,25038,25039,25040,25043,25045,25046,25047,25048,25049,25050,25051,25052,25053,25054,25055,25056,25057,25058,25059,25060,25061,25063,25064,25065,25066,25067,25068,25069,25070,25071,25072,25073,25074,25075,25076,25078,25079,25080,25081,25082,25083,25084,25085,25086,25088,25089,25090,25091,25092,25093,25095,25097,25107,25108,25113,25116,25117,25118,25120,25123,25126,25127,25128,25129,25131,25133,25135,25136,25137,25138,25141,25142,25144,25145,25146,25147,25148,25154,25156,25157,25158,25162,25167,25168,25173,25174,25175,25177,25178,25180,25181,25182,25183,25184,25185,25186,25188,25189,25192,25201,25202,25204,25205,25207,25208,25210,25211,25213,25217,25218,25219,25221,25222,25223,25224,25227,25228,25229,25230,25231,25232,25236,25241,25244,25245,25246,25251,25254,25255,25257,25258,25261,25262,25263,25264,25266,25267,25268,25270,25271,25272,25274,25278,25280,25281,25283,25291,25295,25297,25301,25309,25310,25312,25313,25316,25322,25323,25328,25330,25333,25336,25337,25338,25339,25344,25347,25348,25349,25350,25354,25355,25356,25357,25359,25360,25362,25363,25364,25365,25367,25368,25369,25372,25382,25383,25385,25388,25389,25390,25392,25393,25395,25396,25397,25398,25399,25400,25403,25404,25406,25407,25408,25409,25412,25415,25416,25418,25425,25426,25427,25428,25430,25431,25432,25433,25434,25435,25436,25437,25440,25444,25445,25446,25448,25450,25451,25452,25455,25456,25458,25459,25460,25461,25464,25465,25468,25469,25470,25471,25473,25475,25476,25477,25478,25483,25485,25489,25491,25492,25493,25495,25497,25498,25499,25500,25501,25502,25503,25505,25508,25510,25515,25519,25521,25522,25525,25526,25529,25531,25533,25535,25536,25537,25538,25539,25541,25543,25544,25546,25547,25548,25553,25555,25556,25557,25559,25560,25561,25562,25563,25564,25565,25567,25570,25572,25573,25574,25575,25576,25579,25580,25582,25583,25584,25585,25587,25589,25591,25593,25594,25595,25596,25598,25603,25604,25606,25607,25608,25609,25610,25613,25614,25617,25618,25621,25622,25623,25624,25625,25626,25629,25631,25634,25635,25636,25637,25639,25640,25641,25643,25646,25647,25648,25649,25650,25651,25653,25654,25655,25656,25657,25659,25660,25662,25664,25666,25667,25673,25675,25676,25677,25678,25679,25680,25681,25683,25685,25686,25687,25689,25690,25691,25692,25693,25695,25696,25697,25698,25699,25700,25701,25702,25704,25706,25707,25708,25710,25711,25712,25713,25714,25715,25716,25717,25718,25719,25723,25724,25725,25726,25727,25728,25729,25731,25734,25736,25737,25738,25739,25740,25741,25742,25743,25744,25747,25748,25751,25752,25754,25755,25756,25757,25759,25760,25761,25762,25763,25765,25766,25767,25768,25770,25771,25775,25777,25778,25779,25780,25782,25785,25787,25789,25790,25791,25793,25795,25796,25798,25799,25800,25801,25802,25803,25804,25807,25809,25811,25812,25813,25814,25817,25818,25819,25820,25821,25823,25824,25825,25827,25829,25831,25832,25833,25834,25835,25836,25837,25838,25839,25840,25841,25842,25843,25844,25845,25846,25847,25848,25849,25850,25851,25852,25853,25854,25855,25857,25858,25859,25860,25861,25862,25863,25864,25866,25867,25868,25869,25870,25871,25872,25873,25875,25876,25877,25878,25879,25881,25882,25883,25884,25885,25886,25887,25888,25889,25890,25891,25892,25894,25895,25896,25897,25898,25900,25901,25904,25905,25906,25907,25911,25914,25916,25917,25920,25921,25922,25923,25924,25926,25927,25930,25931,25933,25934,25936,25938,25939,25940,25943,25944,25946,25948,25951,25952,25953,25956,25957,25959,25960,25961,25962,25965,25966,25967,25969,25971,25973,25974,25976,25977,25978,25979,25980,25981,25982,25983,25984,25985,25986,25987,25988,25989,25990,25992,25993,25994,25997,25998,25999,26002,26004,26005,26006,26008,26010,26013,26014,26016,26018,26019,26022,26024,26026,26028,26030,26033,26034,26035,26036,26037,26038,26039,26040,26042,26043,26046,26047,26048,26050,26055,26056,26057,26058,26061,26064,26065,26067,26068,26069,26072,26073,26074,26075,26076,26077,26078,26079,26081,26083,26084,26090,26091,26098,26099,26100,26101,26104,26105,26107,26108,26109,26110,26111,26113,26116,26117,26119,26120,26121,26123,26125,26128,26129,26130,26134,26135,26136,26138,26139,26140,26142,26145,26146,26147,26148,26150,26153,26154,26155,26156,26158,26160,26162,26163,26167,26168,26169,26170,26171,26173,26175,26176,26178,26180,26181,26182,26183,26184,26185,26186,26189,26190,26192,26193,26200,26201,26203,26204,26205,26206,26208,26210,26211,26213,26215,26217,26218,26219,26220,26221,26225,26226,26227,26229,26232,26233,26235,26236,26237,26239,26240,26241,26243,26245,26246,26248,26249,26250,26251,26253,26254,26255,26256,26258,26259,26260,26261,26264,26265,26266,26267,26268,26270,26271,26272,26273,26274,26275,26276,26277,26278,26281,26282,26283,26284,26285,26287,26288,26289,26290,26291,26293,26294,26295,26296,26298,26299,26300,26301,26303,26304,26305,26306,26307,26308,26309,26310,26311,26312,26313,26314,26315,26316,26317,26318,26319,26320,26321,26322,26323,26324,26325,26326,26327,26328,26330,26334,26335,26336,26337,26338,26339,26340,26341,26343,26344,26346,26347,26348,26349,26350,26351,26353,26357,26358,26360,26362,26363,26365,26369,26370,26371,26372,26373,26374,26375,26380,26382,26383,26385,26386,26387,26390,26392,26393,26394,26396,26398,26400,26401,26402,26403,26404,26405,26407,26409,26414,26416,26418,26419,26422,26423,26424,26425,26427,26428,26430,26431,26433,26436,26437,26439,26442,26443,26445,26450,26452,26453,26455,26456,26457,26458,26459,26461,26466,26467,26468,26470,26471,26475,26476,26478,26481,26484,26486,26488,26489,26490,26491,26493,26496,26498,26499,26501,26502,26504,26506,26508,26509,26510,26511,26513,26514,26515,26516,26518,26521,26523,26527,26528,26529,26532,26534,26537,26540,26542,26545,26546,26548,2655