# How to get support

> This project has a [Code of Conduct](https://github.com/Cantera/cantera/blob/main/CODE_OF_CONDUCT.md).
> By interacting with this repository, organisation, or community you agree to
> abide by its terms.

For **help**, **support** and **questions** please create a post on the
**[Cantera Users' Group](https://groups.google.com/group/cantera-users)**.
Any discussion of Cantera functionality such as how to use certain function
calls, syntax problems, input files, etc. should be directed to the Users' Group.

Further, the **[Cantera Gitter Chat](https://gitter.im/Cantera/Lobby)** is an
infrequently monitored chat room that can be used to discuss tangentially-related
topics such as how to model the underlying physics of a problem, share cool
applications that you have developed, etc.

Please **_do not_** raise an issue on GitHub unless it is a bug report or a
feature request. Issues that do not fall into these categories will be closed.
If you're not sure, please make a post on the
[Users' Group](https://groups.google.com/group/cantera-users) and someone will
be able to help you out.

## Documentation

The [documentation](https://cantera.org/documentation)
offers a number of starting points:

- [Python tutorial](https://cantera.org/tutorials/python-tutorial.html)
- [Application Examples in Python (Jupyter)](https://github.com/Cantera/cantera-jupyter#cantera-jupyter)
- [A guide to Cantera's input file format](https://cantera.org/tutorials/input-files.html)
- [Information about the Cantera community](https://cantera.org/community.html)

Documentation for the [development version of
Cantera](https://cantera.org/documentation/dev-docs.html) is also available.

## Contributions

See [`CONTRIBUTING.md`](https://github.com/Cantera/cantera/blob/main/CONTRIBUTING.md) on how to contribute.
