/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.model;

import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.exceptions.JBBPFinderException;
import com.igormaznitsa.jbbp.exceptions.JBBPTooManyFieldsFoundException;
import com.igormaznitsa.jbbp.mapper.BinFieldFilter;
import com.igormaznitsa.jbbp.mapper.JBBPMapper;
import com.igormaznitsa.jbbp.mapper.JBBPMapperCustomFieldProcessor;
import com.igormaznitsa.jbbp.model.JBBPAbstractField;
import com.igormaznitsa.jbbp.model.finder.JBBPFieldFinder;
import com.igormaznitsa.jbbp.utils.Function;
import com.igormaznitsa.jbbp.utils.JBBPUtils;
import java.util.List;

public final class JBBPFieldStruct
extends JBBPAbstractField
implements JBBPFieldFinder {
    private static final long serialVersionUID = -5862961302818335702L;
    private final JBBPAbstractField[] fields;

    public JBBPFieldStruct(JBBPNamedFieldInfo name, JBBPAbstractField[] fields) {
        super(name);
        JBBPUtils.assertNotNull(fields, "Array of fields must not be null");
        this.fields = fields;
    }

    public JBBPFieldStruct(JBBPNamedFieldInfo name, List<JBBPAbstractField> fields) {
        this(name, fields.toArray(JBBPUtils.ARRAY_FIELD_EMPTY));
    }

    public JBBPAbstractField[] getArray() {
        return (JBBPAbstractField[])this.fields.clone();
    }

    @Override
    public JBBPAbstractField findFieldForPath(String fieldPath) {
        int firstIndex;
        String[] parsedName = JBBPUtils.splitString(JBBPUtils.normalizeFieldNameOrPath(fieldPath), '.');
        JBBPAbstractField found = this;
        if ("".equals(this.getFieldName())) {
            firstIndex = 0;
        } else if (parsedName[0].equals(this.getNameInfo().getFieldName())) {
            firstIndex = 1;
        } else {
            firstIndex = 0;
            found = null;
        }
        for (int i = firstIndex; found != null && i < parsedName.length; found = found.findFieldForName(parsedName[i]), ++i) {
            if (found instanceof JBBPFieldStruct) continue;
            throw new JBBPFinderException("Detected a field instead of a structure as one of nodes in the path '" + fieldPath + "'", fieldPath, null);
        }
        return found;
    }

    @Override
    public JBBPAbstractField findFieldForName(String name) {
        String normalizedName = JBBPUtils.normalizeFieldNameOrPath(name);
        JBBPAbstractField result = null;
        for (JBBPAbstractField f : this.fields) {
            if (!normalizedName.equals(f.getFieldName())) continue;
            result = f;
            break;
        }
        return result;
    }

    @Override
    public <T extends JBBPAbstractField> T findFieldForType(Class<T> fieldType) {
        JBBPAbstractField result = null;
        int counter = 0;
        for (JBBPAbstractField f : this.fields) {
            if (!fieldType.isAssignableFrom(f.getClass())) continue;
            if (result == null) {
                result = (JBBPAbstractField)fieldType.cast(f);
            }
            ++counter;
        }
        if (counter > 1) {
            throw new JBBPTooManyFieldsFoundException(counter, "Detected more than one field", null, fieldType);
        }
        return (T)result;
    }

    @Override
    public <T extends JBBPAbstractField> T findFirstFieldForType(Class<T> fieldType) {
        JBBPAbstractField result = null;
        for (JBBPAbstractField f : this.fields) {
            if (!fieldType.isAssignableFrom(f.getClass())) continue;
            result = (JBBPAbstractField)fieldType.cast(f);
            break;
        }
        return (T)result;
    }

    @Override
    public <T extends JBBPAbstractField> T findLastFieldForType(Class<T> fieldType) {
        JBBPAbstractField result = null;
        for (int i = this.fields.length - 1; i >= 0; --i) {
            JBBPAbstractField f = this.fields[i];
            if (!fieldType.isAssignableFrom(f.getClass())) continue;
            result = (JBBPAbstractField)fieldType.cast(f);
            break;
        }
        return (T)result;
    }

    @Override
    public <T extends JBBPAbstractField> T findFieldForNameAndType(String fieldName, Class<T> fieldType) {
        String normalizedName = JBBPUtils.normalizeFieldNameOrPath(fieldName);
        JBBPAbstractField result = null;
        for (JBBPAbstractField f : this.fields) {
            if (!fieldType.isAssignableFrom(f.getClass()) || !normalizedName.equals(f.getFieldName())) continue;
            result = (JBBPAbstractField)fieldType.cast(f);
            break;
        }
        return (T)result;
    }

    @Override
    public boolean nameExists(String fieldName) {
        String normalizedName = JBBPUtils.normalizeFieldNameOrPath(fieldName);
        boolean result = false;
        for (JBBPAbstractField f : this.fields) {
            if (!normalizedName.equals(f.getFieldName())) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public boolean pathExists(String fieldPath) {
        String normalizedPath = JBBPUtils.normalizeFieldNameOrPath(fieldPath);
        boolean result = false;
        for (JBBPAbstractField f : this.fields) {
            if (!normalizedPath.equals(f.getFieldPath())) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public <T extends JBBPAbstractField> T findFieldForPathAndType(String fieldPath, Class<T> fieldType) {
        JBBPAbstractField field = this.findFieldForPath(fieldPath);
        JBBPAbstractField result = null;
        if (field != null && fieldType.isAssignableFrom(field.getClass())) {
            result = (JBBPAbstractField)fieldType.cast(field);
        }
        return (T)result;
    }

    @SafeVarargs
    public final <T> T mapTo(String path, T instance, Function<Class<?>, Object> ... instantiators) {
        return JBBPMapper.map(this, path, instance, instantiators);
    }

    @SafeVarargs
    public final <T> T mapTo(String path, T instance, int flags, Function<Class<?>, Object> ... instantiators) {
        return JBBPMapper.map(this, path, instance, flags, instantiators);
    }

    @SafeVarargs
    public final <T> T mapTo(String path, T instance, JBBPMapperCustomFieldProcessor customFieldProcessor, Function<Class<?>, Object> ... instantiators) {
        return JBBPMapper.map(this, path, instance, customFieldProcessor, instantiators);
    }

    @SafeVarargs
    public final <T> T mapTo(String path, T instance, JBBPMapperCustomFieldProcessor customFieldProcessor, int flags, Function<Class<?>, Object> ... instantiators) {
        return JBBPMapper.map(this, path, instance, customFieldProcessor, flags, instantiators);
    }

    @SafeVarargs
    public final <T> T mapTo(T objectToMap, Function<Class<?>, Object> ... instantiators) {
        return this.mapTo(objectToMap, (JBBPMapperCustomFieldProcessor)null, instantiators);
    }

    @SafeVarargs
    public final <T> T mapTo(T objectToMap, BinFieldFilter binFieldFilter, Function<Class<?>, Object> ... instantiators) {
        return this.mapTo(objectToMap, null, binFieldFilter, instantiators);
    }

    @SafeVarargs
    public final <T> T mapTo(T instance, int flags, Function<Class<?>, Object> ... instantiators) {
        return this.mapTo(instance, null, flags, instantiators);
    }

    @SafeVarargs
    public final <T> T mapTo(T instance, int flags, BinFieldFilter binFieldFilter, Function<Class<?>, Object> ... instantiators) {
        return this.mapTo(instance, null, flags, binFieldFilter, instantiators);
    }

    @SafeVarargs
    public final <T> T mapTo(T instance, JBBPMapperCustomFieldProcessor customFieldProcessor, Function<Class<?>, Object> ... instantiators) {
        return JBBPMapper.map(this, instance, customFieldProcessor, instantiators);
    }

    @SafeVarargs
    public final <T> T mapTo(T instance, JBBPMapperCustomFieldProcessor customFieldProcessor, BinFieldFilter binFieldFilter, Function<Class<?>, Object> ... instantiators) {
        return JBBPMapper.map(this, instance, customFieldProcessor, 0, binFieldFilter, instantiators);
    }

    @SafeVarargs
    public final <T> T mapTo(T objectToMap, JBBPMapperCustomFieldProcessor customFieldProcessor, int flags, Function<Class<?>, Object> ... instantiators) {
        return JBBPMapper.map(this, objectToMap, customFieldProcessor, flags, instantiators);
    }

    @SafeVarargs
    public final <T> T mapTo(T objectToMap, JBBPMapperCustomFieldProcessor customFieldProcessor, int flags, BinFieldFilter binFieldFilter, Function<Class<?>, Object> ... instantiators) {
        return JBBPMapper.map(this, objectToMap, customFieldProcessor, flags, binFieldFilter, instantiators);
    }

    @Override
    public String getTypeAsString() {
        return "{}";
    }
}

