/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.jmdns.ServiceInfo;
import javax.jmdns.impl.DNSCache;
import javax.jmdns.impl.DNSEntry;
import javax.jmdns.impl.DNSListener;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.DNSStatefulObject;
import javax.jmdns.impl.HostInfo;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.ServiceEventImpl;
import javax.jmdns.impl.ServiceTypeDecoder;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;
import javax.jmdns.impl.constants.DNSState;
import javax.jmdns.impl.tasks.DNSTask;
import javax.jmdns.impl.util.ByteWrangler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceInfoImpl
extends ServiceInfo
implements DNSListener,
DNSStatefulObject {
    private final Logger logger = LoggerFactory.getLogger(ServiceInfoImpl.class);
    private String _domain;
    private String _protocol;
    private String _application;
    private String _name;
    private String _subtype;
    private String _server;
    private int _port;
    private int _weight;
    private int _priority;
    private byte[] _text;
    private Map<String, byte[]> _props;
    private final Set<Inet4Address> _ipv4Addresses;
    private final Set<Inet6Address> _ipv6Addresses;
    private transient String _key;
    private boolean _persistent;
    private boolean _needTextAnnouncing;
    private final ServiceInfoState _state;
    private Delegate _delegate;

    public ServiceInfoImpl(String type, String name, String subtype, int port, int weight, int priority, boolean persistent, String text) {
        this(ServiceTypeDecoder.decodeQualifiedNameMap(type, name, subtype), port, weight, priority, persistent, (byte[])null);
        try {
            this._text = ByteWrangler.encodeText(text);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception: " + e);
        }
        this._server = text;
    }

    public ServiceInfoImpl(String type, String name, String subtype, int port, int weight, int priority, boolean persistent, Map<String, ?> props) {
        this(ServiceTypeDecoder.decodeQualifiedNameMap(type, name, subtype), port, weight, priority, persistent, ByteWrangler.textFromProperties(props));
    }

    public ServiceInfoImpl(String type, String name, String subtype, int port, int weight, int priority, boolean persistent, byte[] text) {
        this(ServiceTypeDecoder.decodeQualifiedNameMap(type, name, subtype), port, weight, priority, persistent, text);
    }

    public ServiceInfoImpl(Map<ServiceInfo.Fields, String> qualifiedNameMap, int port, int weight, int priority, boolean persistent, Map<String, ?> props) {
        this(qualifiedNameMap, port, weight, priority, persistent, ByteWrangler.textFromProperties(props));
    }

    ServiceInfoImpl(Map<ServiceInfo.Fields, String> qualifiedNameMap, int port, int weight, int priority, boolean persistent, String text) {
        this(qualifiedNameMap, port, weight, priority, persistent, (byte[])null);
        try {
            this._text = ByteWrangler.encodeText(text);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception: " + e);
        }
        this._server = text;
    }

    ServiceInfoImpl(Map<ServiceInfo.Fields, String> qualifiedNameMap, int port, int weight, int priority, boolean persistent, byte[] text) {
        Map<ServiceInfo.Fields, String> map = ServiceInfoImpl.checkQualifiedNameMap(qualifiedNameMap);
        this._domain = map.get((Object)ServiceInfo.Fields.Domain);
        this._protocol = map.get((Object)ServiceInfo.Fields.Protocol);
        this._application = map.get((Object)ServiceInfo.Fields.Application);
        this._name = map.get((Object)ServiceInfo.Fields.Instance);
        this._subtype = map.get((Object)ServiceInfo.Fields.Subtype);
        this._port = port;
        this._weight = weight;
        this._priority = priority;
        this._text = text;
        this.setNeedTextAnnouncing(false);
        this._state = new ServiceInfoState(this);
        this._persistent = persistent;
        this._ipv4Addresses = Collections.synchronizedSet(new LinkedHashSet());
        this._ipv6Addresses = Collections.synchronizedSet(new LinkedHashSet());
    }

    ServiceInfoImpl(ServiceInfo info) {
        this._ipv4Addresses = Collections.synchronizedSet(new LinkedHashSet());
        this._ipv6Addresses = Collections.synchronizedSet(new LinkedHashSet());
        if (info != null) {
            this._domain = info.getDomain();
            this._protocol = info.getProtocol();
            this._application = info.getApplication();
            this._name = info.getName();
            this._subtype = info.getSubtype();
            this._port = info.getPort();
            this._weight = info.getWeight();
            this._priority = info.getPriority();
            this._text = info.getTextBytes();
            this._persistent = info.isPersistent();
            Inet6Address[] ipv6Addresses = info.getInet6Addresses();
            this._ipv6Addresses.addAll(Arrays.asList(ipv6Addresses));
            Inet4Address[] ipv4Addresses = info.getInet4Addresses();
            this._ipv4Addresses.addAll(Arrays.asList(ipv4Addresses));
        }
        this._state = new ServiceInfoState(this);
    }

    static Map<ServiceInfo.Fields, String> createQualifiedMap(String instance, String application, String protocol, String domain, String subtype) {
        EnumMap<ServiceInfo.Fields, String> qualifiedMap = new EnumMap<ServiceInfo.Fields, String>(ServiceInfo.Fields.class);
        qualifiedMap.put(ServiceInfo.Fields.Instance, instance);
        qualifiedMap.put(ServiceInfo.Fields.Application, application);
        qualifiedMap.put(ServiceInfo.Fields.Protocol, protocol);
        qualifiedMap.put(ServiceInfo.Fields.Domain, domain);
        qualifiedMap.put(ServiceInfo.Fields.Subtype, subtype);
        return qualifiedMap;
    }

    protected static Map<ServiceInfo.Fields, String> checkQualifiedNameMap(Map<ServiceInfo.Fields, String> qualifiedNameMap) {
        EnumMap<ServiceInfo.Fields, String> checkedQualifiedNameMap = new EnumMap<ServiceInfo.Fields, String>(ServiceInfo.Fields.class);
        String domain = qualifiedNameMap.getOrDefault((Object)ServiceInfo.Fields.Domain, "local");
        if (domain == null || domain.isEmpty()) {
            domain = "local";
        }
        domain = ServiceInfoImpl.removeSeparators(domain);
        checkedQualifiedNameMap.put(ServiceInfo.Fields.Domain, domain);
        String protocol = qualifiedNameMap.getOrDefault((Object)ServiceInfo.Fields.Protocol, "tcp");
        if (protocol == null || protocol.isEmpty()) {
            protocol = "tcp";
        }
        protocol = ServiceInfoImpl.removeSeparators(protocol);
        checkedQualifiedNameMap.put(ServiceInfo.Fields.Protocol, protocol);
        String application = qualifiedNameMap.getOrDefault((Object)ServiceInfo.Fields.Application, "");
        if (application == null || application.isEmpty()) {
            application = "";
        }
        application = ServiceInfoImpl.removeSeparators(application);
        checkedQualifiedNameMap.put(ServiceInfo.Fields.Application, application);
        String instance = qualifiedNameMap.getOrDefault((Object)ServiceInfo.Fields.Instance, "");
        if (instance == null || instance.isEmpty()) {
            instance = "";
        }
        instance = ServiceInfoImpl.removeSeparators(instance);
        checkedQualifiedNameMap.put(ServiceInfo.Fields.Instance, instance);
        String subtype = qualifiedNameMap.getOrDefault((Object)ServiceInfo.Fields.Subtype, "");
        if (subtype == null || subtype.isEmpty()) {
            subtype = "";
        }
        subtype = ServiceInfoImpl.removeSeparators(subtype);
        checkedQualifiedNameMap.put(ServiceInfo.Fields.Subtype, subtype);
        return checkedQualifiedNameMap;
    }

    static String removeSeparators(String name) {
        if (name == null) {
            return "";
        }
        String newName = name.trim();
        if (newName.startsWith(".")) {
            newName = newName.substring(1);
        }
        if (newName.startsWith("_")) {
            newName = newName.substring(1);
        }
        if (newName.endsWith(".")) {
            newName = newName.substring(0, newName.length() - 1);
        }
        return newName;
    }

    @Override
    public String getType() {
        String protocol;
        StringBuilder type = new StringBuilder();
        String application = this.getApplication();
        if (!application.isEmpty()) {
            type.append('_').append(application).append('.');
        }
        if (!(protocol = this.getProtocol()).isEmpty()) {
            type.append('_').append(protocol).append('.');
        }
        String domain = this.getDomain();
        type.append(domain).append('.');
        return type.toString();
    }

    @Override
    public String getTypeWithSubtype() {
        String subtype = this.getSubtype();
        return subtype.isEmpty() ? this.getType() : '_' + subtype + "._sub." + this.getType();
    }

    @Override
    public String getName() {
        return this._name != null ? this._name : "";
    }

    @Override
    public String getKey() {
        if (this._key == null) {
            this._key = this.getQualifiedName().toLowerCase();
        }
        return this._key;
    }

    void setName(String name) {
        this._name = name;
        this._key = null;
    }

    @Override
    public String getQualifiedName() {
        String instance = this.getName();
        return instance.isEmpty() ? this.getType() : instance + '.' + this.getType();
    }

    @Override
    public String getServer() {
        return this._server != null ? this._server : "";
    }

    @Override
    public boolean hasServer() {
        return this._server != null;
    }

    void setServer(String server) {
        this._server = server;
    }

    @Override
    @Deprecated
    public String getHostAddress() {
        String[] names = this.getHostAddresses();
        return names.length > 0 ? names[0] : "";
    }

    @Override
    public String[] getHostAddresses() {
        Inet4Address[] ip4Addresses = this.getInet4Addresses();
        Inet6Address[] ip6Addresses = this.getInet6Addresses();
        if (ip4Addresses == null) {
            ip4Addresses = new Inet4Address[]{};
        }
        if (ip6Addresses == null) {
            ip6Addresses = new Inet6Address[]{};
        }
        ArrayList<String> addresses = new ArrayList<String>();
        for (Inet4Address inet4Address : ip4Addresses) {
            if (inet4Address != null) {
                addresses.add(inet4Address.getHostAddress());
                continue;
            }
            this.logger.info("IPv4 address is null");
        }
        for (InetAddress inetAddress : ip6Addresses) {
            if (inetAddress != null) {
                addresses.add("[" + ((Inet6Address)inetAddress).getHostAddress() + "]");
                continue;
            }
            this.logger.info("IPv6 address is null");
        }
        return addresses.toArray(new String[0]);
    }

    void addAddress(Inet4Address addr) {
        this._ipv4Addresses.add(addr);
    }

    void addAddress(Inet6Address addr) {
        this._ipv6Addresses.add(addr);
    }

    @Override
    @Deprecated
    public InetAddress getAddress() {
        return this.getInetAddress();
    }

    @Override
    @Deprecated
    public InetAddress getInetAddress() {
        InetAddress[] addresses = this.getInetAddresses();
        return addresses.length > 0 ? addresses[0] : null;
    }

    @Override
    @Deprecated
    public Inet4Address getInet4Address() {
        Inet4Address[] addresses = this.getInet4Addresses();
        return addresses.length > 0 ? addresses[0] : null;
    }

    @Override
    @Deprecated
    public Inet6Address getInet6Address() {
        Inet6Address[] addresses = this.getInet6Addresses();
        return addresses.length > 0 ? addresses[0] : null;
    }

    @Override
    public InetAddress[] getInetAddresses() {
        ArrayList<InetAddress> aList = new ArrayList<InetAddress>(this._ipv4Addresses.size() + this._ipv6Addresses.size());
        aList.addAll(this._ipv4Addresses);
        aList.addAll(this._ipv6Addresses);
        return aList.toArray(new InetAddress[0]);
    }

    @Override
    public Inet4Address[] getInet4Addresses() {
        return this._ipv4Addresses.toArray(new Inet4Address[0]);
    }

    @Override
    public Inet6Address[] getInet6Addresses() {
        return this._ipv6Addresses.toArray(new Inet6Address[0]);
    }

    @Override
    public int getPort() {
        return this._port;
    }

    @Override
    public int getPriority() {
        return this._priority;
    }

    @Override
    public int getWeight() {
        return this._weight;
    }

    @Override
    public byte[] getTextBytes() {
        return this._text != null && this._text.length > 0 ? this._text : ByteWrangler.EMPTY_TXT;
    }

    @Override
    @Deprecated
    public String getTextString() {
        Map<String, byte[]> properties = this.getProperties();
        Iterator<Map.Entry<String, byte[]>> iterator = properties.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, byte[]> entry = iterator.next();
            byte[] value = entry.getValue();
            if (value != null && value.length > 0) {
                String val = ByteWrangler.readUTF(value);
                return entry.getKey() + "=" + val;
            }
            return entry.getKey();
        }
        return "";
    }

    @Override
    @Deprecated
    public String getURL() {
        return this.getURL("http");
    }

    @Override
    public String[] getURLs() {
        return this.getURLs("http");
    }

    @Override
    @Deprecated
    public String getURL(String protocol) {
        String[] urls = this.getURLs(protocol);
        return urls.length > 0 ? urls[0] : protocol + "://null:" + this.getPort();
    }

    @Override
    public String[] getURLs(String protocol) {
        InetAddress[] addresses = this.getInetAddresses();
        ArrayList<String> urls = new ArrayList<String>(addresses.length);
        for (InetAddress address : addresses) {
            String hostAddress = address.getHostAddress();
            if (address instanceof Inet6Address) {
                hostAddress = "[" + hostAddress + "]";
            }
            String url = protocol + "://" + hostAddress + ":" + this.getPort();
            String path = this.getPropertyString("path");
            if (path != null) {
                url = path.contains("://") ? path : url + (path.startsWith("/") ? path : "/" + path);
            }
            urls.add(url);
        }
        return urls.toArray(new String[0]);
    }

    @Override
    public synchronized byte[] getPropertyBytes(String name) {
        return this.getProperties().get(name);
    }

    @Override
    public synchronized String getPropertyString(String name) {
        byte[] data = this.getProperties().get(name);
        if (data == null) {
            return null;
        }
        if (data == ByteWrangler.NO_VALUE) {
            return "true";
        }
        return ByteWrangler.readUTF(data, 0, data.length);
    }

    @Override
    public Enumeration<String> getPropertyNames() {
        Map<String, byte[]> properties = this.getProperties();
        Set<Object> names = properties != null ? properties.keySet() : Collections.emptySet();
        return new Vector(names).elements();
    }

    @Override
    public String getApplication() {
        return this._application != null ? this._application : "";
    }

    @Override
    public String getDomain() {
        return this._domain != null ? this._domain : "local";
    }

    @Override
    public String getProtocol() {
        return this._protocol != null ? this._protocol : "tcp";
    }

    @Override
    public String getSubtype() {
        return this._subtype != null ? this._subtype : "";
    }

    @Override
    public Map<ServiceInfo.Fields, String> getQualifiedNameMap() {
        EnumMap<ServiceInfo.Fields, String> map = new EnumMap<ServiceInfo.Fields, String>(ServiceInfo.Fields.class);
        map.put(ServiceInfo.Fields.Domain, this.getDomain());
        map.put(ServiceInfo.Fields.Protocol, this.getProtocol());
        map.put(ServiceInfo.Fields.Application, this.getApplication());
        map.put(ServiceInfo.Fields.Instance, this.getName());
        map.put(ServiceInfo.Fields.Subtype, this.getSubtype());
        return map;
    }

    synchronized Map<String, byte[]> getProperties() {
        if (this._props == null && this.getTextBytes() != null) {
            LinkedHashMap<String, byte[]> properties = new LinkedHashMap<String, byte[]>();
            try {
                ByteWrangler.readProperties(properties, this.getTextBytes());
            }
            catch (Exception exception) {
                this.logger.warn("Malformed TXT Field ", (Throwable)exception);
            }
            this._props = properties;
        }
        return this._props != null ? this._props : Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRecord(DNSCache dnsCache, long now, DNSEntry dnsEntry) {
        if (!(dnsEntry instanceof DNSRecord)) {
            this.logger.trace("DNSEntry is not of type 'DNSRecord' but of type {}", (Object)(null == dnsEntry ? "null" : dnsEntry.getClass().getSimpleName()));
            return;
        }
        DNSRecord record = (DNSRecord)dnsEntry;
        boolean serviceChanged = record.isExpired(now) ? this.handleExpiredRecord(record) : this.handleUpdateRecord(dnsCache, now, record);
        if (serviceChanged) {
            JmDNSImpl dns = this.getDns();
            if (dns != null) {
                if (this.hasData()) {
                    ServiceEventImpl event = new ServiceEventImpl(dns, this.getType(), this.getName(), this.clone());
                    dns.handleServiceResolved(event);
                }
                ServiceInfoImpl serviceInfoImpl = this;
                synchronized (serviceInfoImpl) {
                    this.notifyAll();
                }
            } else {
                this.logger.debug("JmDNS not available.");
            }
        }
    }

    private boolean handleExpiredRecord(DNSRecord record) {
        switch (record.getRecordType()) {
            case TYPE_A: 
            case TYPE_AAAA: {
                if (!record.getName().equalsIgnoreCase(this.getServer())) break;
                DNSRecord.Address address = (DNSRecord.Address)record;
                if (DNSRecordType.TYPE_A.equals((Object)record.getRecordType())) {
                    Inet4Address inet4Address = (Inet4Address)address.getAddress();
                    if (this._ipv4Addresses.remove(inet4Address)) {
                        this.logger.debug("Removed expired IPv4: {}", (Object)inet4Address);
                        return true;
                    }
                    this.logger.debug("Expired IPv4 not in this service: {}", (Object)inet4Address);
                    break;
                }
                Inet6Address inet6Address = (Inet6Address)address.getAddress();
                if (this._ipv6Addresses.remove(inet6Address)) {
                    this.logger.debug("Removed expired IPv6: {}", (Object)inet6Address);
                    return true;
                }
                this.logger.debug("Expired IPv6 not in this service: {}", (Object)inet6Address);
                break;
            }
            default: {
                this.logger.trace("Unhandled expired record: {}", (Object)record);
            }
        }
        return false;
    }

    private boolean handleUpdateRecord(DNSCache dnsCache, long now, DNSRecord record) {
        boolean serviceUpdated = false;
        switch (record.getRecordType()) {
            case TYPE_A: {
                Inet4Address inet4Address;
                DNSRecord.Address address;
                if (!record.getName().equalsIgnoreCase(this.getServer()) || !((address = (DNSRecord.Address)record).getAddress() instanceof Inet4Address) || !this._ipv4Addresses.add(inet4Address = (Inet4Address)address.getAddress())) break;
                serviceUpdated = true;
                break;
            }
            case TYPE_AAAA: {
                Inet6Address inet6Address;
                DNSRecord.Address address;
                if (!record.getName().equalsIgnoreCase(this.getServer()) || !((address = (DNSRecord.Address)record).getAddress() instanceof Inet6Address) || !this._ipv6Addresses.add(inet6Address = (Inet6Address)address.getAddress())) break;
                serviceUpdated = true;
                break;
            }
            case TYPE_SRV: {
                if (!record.getName().equalsIgnoreCase(this.getQualifiedName())) break;
                DNSRecord.Service srv = (DNSRecord.Service)record;
                boolean serverChanged = this._server == null || !this._server.equalsIgnoreCase(srv.getServer());
                this._server = srv.getServer();
                this._port = srv.getPort();
                this._weight = srv.getWeight();
                this._priority = srv.getPriority();
                if (serverChanged) {
                    this._ipv4Addresses.clear();
                    this._ipv6Addresses.clear();
                    for (DNSEntry dNSEntry : dnsCache.getDNSEntryList(this._server, DNSRecordType.TYPE_A, DNSRecordClass.CLASS_IN)) {
                        this.updateRecord(dnsCache, now, dNSEntry);
                    }
                    for (DNSEntry dNSEntry : dnsCache.getDNSEntryList(this._server, DNSRecordType.TYPE_AAAA, DNSRecordClass.CLASS_IN)) {
                        this.updateRecord(dnsCache, now, dNSEntry);
                    }
                    break;
                }
                serviceUpdated = true;
                break;
            }
            case TYPE_TXT: {
                if (!record.getName().equalsIgnoreCase(this.getQualifiedName())) break;
                DNSRecord.Text txt = (DNSRecord.Text)record;
                this._text = txt.getText();
                this._props = null;
                serviceUpdated = true;
                break;
            }
            case TYPE_PTR: {
                if (!this.getSubtype().isEmpty() || record.getSubtype().isEmpty()) break;
                this._subtype = record.getSubtype();
                serviceUpdated = true;
                break;
            }
        }
        return serviceUpdated;
    }

    @Override
    public synchronized boolean hasData() {
        return this.hasServer() && this.hasInetAddress() && this.getTextBytes() != null && this.getTextBytes().length > 0;
    }

    private boolean hasInetAddress() {
        return !this._ipv4Addresses.isEmpty() || !this._ipv6Addresses.isEmpty();
    }

    @Override
    public boolean advanceState(DNSTask task) {
        return this._state.advanceState(task);
    }

    @Override
    public boolean revertState() {
        return this._state.revertState();
    }

    @Override
    public boolean cancelState() {
        return this._state.cancelState();
    }

    @Override
    public boolean closeState() {
        return this._state.closeState();
    }

    @Override
    public boolean recoverState() {
        return this._state.recoverState();
    }

    @Override
    public void removeAssociationWithTask(DNSTask task) {
        this._state.removeAssociationWithTask(task);
    }

    @Override
    public void associateWithTask(DNSTask task, DNSState state) {
        this._state.associateWithTask(task, state);
    }

    @Override
    public boolean isAssociatedWithTask(DNSTask task, DNSState state) {
        return this._state.isAssociatedWithTask(task, state);
    }

    @Override
    public boolean isProbing() {
        return this._state.isProbing();
    }

    @Override
    public boolean isAnnouncing() {
        return this._state.isAnnouncing();
    }

    @Override
    public boolean isAnnounced() {
        return this._state.isAnnounced();
    }

    @Override
    public boolean isCanceling() {
        return this._state.isCanceling();
    }

    @Override
    public boolean isCanceled() {
        return this._state.isCanceled();
    }

    @Override
    public boolean isClosing() {
        return this._state.isClosing();
    }

    @Override
    public boolean isClosed() {
        return this._state.isClosed();
    }

    @Override
    public boolean waitForAnnounced(long timeout) {
        return this._state.waitForAnnounced(timeout);
    }

    @Override
    public boolean waitForCanceled(long timeout) {
        return this._state.waitForCanceled(timeout);
    }

    public int hashCode() {
        return this.getQualifiedName().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ServiceInfoImpl && this.getQualifiedName().equals(((ServiceInfoImpl)obj).getQualifiedName());
    }

    @Override
    public String getNiceTextString() {
        StringBuilder sb = new StringBuilder();
        int len = this.getTextBytes().length;
        for (int i = 0; i < len; ++i) {
            if (i >= 200) {
                sb.append("...");
                break;
            }
            int ch = this.getTextBytes()[i] & 0xFF;
            if (ch < 32 || ch > 127) {
                sb.append("\\0");
                sb.append(Integer.toString(ch, 8));
                continue;
            }
            sb.append((char)ch);
        }
        return sb.toString();
    }

    @Override
    public ServiceInfoImpl clone() {
        ServiceInfoImpl serviceInfo = new ServiceInfoImpl(this.getQualifiedNameMap(), this._port, this._weight, this._priority, this._persistent, this._text);
        serviceInfo.setServer(this._server);
        Inet6Address[] ipv6Addresses = this.getInet6Addresses();
        Collections.addAll(serviceInfo._ipv6Addresses, ipv6Addresses);
        Inet4Address[] ipv4Addresses = this.getInet4Addresses();
        Collections.addAll(serviceInfo._ipv4Addresses, ipv4Addresses);
        return serviceInfo;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(this.getClass().getSimpleName()).append('@').append(System.identityHashCode(this));
        sb.append(" name: '");
        if (!this.getName().isEmpty()) {
            sb.append(this.getName()).append('.');
        }
        sb.append(this.getTypeWithSubtype());
        sb.append("' address: '");
        InetAddress[] addresses = this.getInetAddresses();
        if (addresses.length > 0) {
            for (InetAddress address : addresses) {
                sb.append(address).append(':').append(this.getPort()).append(' ');
            }
        } else {
            sb.append("(null):").append(this.getPort());
        }
        sb.append("' status: '").append(this._state.toString());
        sb.append(this.isPersistent() ? "' is persistent," : "',");
        if (this.hasData()) {
            sb.append(" has data");
        } else {
            sb.append(" has NO data");
        }
        if (this.getTextBytes().length > 0) {
            Map<String, byte[]> properties = this.getProperties();
            if (!properties.isEmpty()) {
                for (Map.Entry<String, byte[]> entry : properties.entrySet()) {
                    String value = ByteWrangler.readUTF(entry.getValue());
                    sb.append("\n\t").append(entry.getKey()).append(": ").append(value);
                }
            } else {
                sb.append(", empty");
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public Collection<DNSRecord> answers(DNSRecordClass recordClass, boolean unique, int ttl, HostInfo localHost) {
        return this.answers(recordClass, unique, ttl, localHost, null);
    }

    public Collection<DNSRecord> answers(DNSRecordClass recordClass, boolean unique, int ttl, HostInfo localHost, String subType) {
        ArrayList<DNSRecord> list = new ArrayList<DNSRecord>();
        if (recordClass == DNSRecordClass.CLASS_ANY || recordClass == DNSRecordClass.CLASS_IN) {
            if (subType == null && !this.getSubtype().isEmpty() || this.getSubtype().equals(subType)) {
                list.add(new DNSRecord.Pointer(this.getTypeWithSubtype(), DNSRecordClass.CLASS_IN, false, ttl, this.getQualifiedName()));
            }
            list.add(new DNSRecord.Pointer(this.getType(), DNSRecordClass.CLASS_IN, false, ttl, this.getQualifiedName()));
            list.add(new DNSRecord.Service(this.getQualifiedName(), DNSRecordClass.CLASS_IN, unique, ttl, this._priority, this._weight, this._port, localHost.getName()));
            list.add(new DNSRecord.Text(this.getQualifiedName(), DNSRecordClass.CLASS_IN, unique, ttl, this.getTextBytes()));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setText(byte[] text) throws IllegalStateException {
        ServiceInfoImpl serviceInfoImpl = this;
        synchronized (serviceInfoImpl) {
            this._text = text;
            this._props = null;
            this.setNeedTextAnnouncing(true);
        }
    }

    @Override
    public void setText(Map<String, ?> props) throws IllegalStateException {
        this.setText(ByteWrangler.textFromProperties(props));
    }

    void _setText(byte[] text) {
        this._text = text;
        this._props = null;
    }

    public void setDns(JmDNSImpl dns) {
        this._state.setDns(dns);
    }

    @Override
    public JmDNSImpl getDns() {
        return this._state.getDns();
    }

    @Override
    public boolean isPersistent() {
        return this._persistent;
    }

    public void setNeedTextAnnouncing(boolean needTextAnnouncing) {
        this._needTextAnnouncing = needTextAnnouncing;
        if (this._needTextAnnouncing) {
            this._state.setTask(null);
        }
    }

    public boolean needTextAnnouncing() {
        return this._needTextAnnouncing;
    }

    Delegate getDelegate() {
        return this._delegate;
    }

    void setDelegate(Delegate delegate) {
        this._delegate = delegate;
    }

    @Override
    public boolean hasSameAddresses(ServiceInfo other) {
        InetAddress[] otherAddresses;
        if (other == null) {
            return false;
        }
        if (other instanceof ServiceInfoImpl) {
            ServiceInfoImpl otherImpl = (ServiceInfoImpl)other;
            return this._ipv4Addresses.size() == otherImpl._ipv4Addresses.size() && this._ipv6Addresses.size() == otherImpl._ipv6Addresses.size() && this._ipv4Addresses.equals(otherImpl._ipv4Addresses) && this._ipv6Addresses.equals(otherImpl._ipv6Addresses);
        }
        InetAddress[] addresses = this.getInetAddresses();
        return addresses.length == (otherAddresses = other.getInetAddresses()).length && new HashSet<InetAddress>(Arrays.asList(addresses)).equals(new HashSet<InetAddress>(Arrays.asList(otherAddresses)));
    }

    private static final class ServiceInfoState
    extends DNSStatefulObject.DefaultImplementation {
        private static final long serialVersionUID = 1104131034952196820L;
        private final ServiceInfoImpl _info;

        public ServiceInfoState(ServiceInfoImpl info) {
            this._info = info;
        }

        @Override
        protected void setTask(DNSTask task) {
            super.setTask(task);
            if (this._task == null && this._info.needTextAnnouncing()) {
                this.lock();
                try {
                    if (this._task == null && this._info.needTextAnnouncing()) {
                        if (this._state.isAnnounced()) {
                            this.setState(DNSState.ANNOUNCING_1);
                            if (this.getDns() != null) {
                                this.getDns().startAnnouncer();
                            }
                        }
                        this._info.setNeedTextAnnouncing(false);
                    }
                }
                finally {
                    this.unlock();
                }
            }
        }

        @Override
        public void setDns(JmDNSImpl dns) {
            super.setDns(dns);
        }
    }

    public static interface Delegate {
        public void textValueUpdated(ServiceInfo var1, byte[] var2);
    }
}

