// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package policy

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/cilium/cilium/api/v1/models"
)

// GetFqdnNamesReader is a Reader for the GetFqdnNames structure.
type GetFqdnNamesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetFqdnNamesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetFqdnNamesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetFqdnNamesBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewGetFqdnNamesOK creates a GetFqdnNamesOK with default headers values
func NewGetFqdnNamesOK() *GetFqdnNamesOK {
	return &GetFqdnNamesOK{}
}

/*
GetFqdnNamesOK describes a response with status code 200, with default header values.

Success
*/
type GetFqdnNamesOK struct {
	Payload *models.NameManager
}

// IsSuccess returns true when this get fqdn names o k response has a 2xx status code
func (o *GetFqdnNamesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get fqdn names o k response has a 3xx status code
func (o *GetFqdnNamesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get fqdn names o k response has a 4xx status code
func (o *GetFqdnNamesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get fqdn names o k response has a 5xx status code
func (o *GetFqdnNamesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get fqdn names o k response a status code equal to that given
func (o *GetFqdnNamesOK) IsCode(code int) bool {
	return code == 200
}

func (o *GetFqdnNamesOK) Error() string {
	return fmt.Sprintf("[GET /fqdn/names][%d] getFqdnNamesOK  %+v", 200, o.Payload)
}

func (o *GetFqdnNamesOK) String() string {
	return fmt.Sprintf("[GET /fqdn/names][%d] getFqdnNamesOK  %+v", 200, o.Payload)
}

func (o *GetFqdnNamesOK) GetPayload() *models.NameManager {
	return o.Payload
}

func (o *GetFqdnNamesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.NameManager)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetFqdnNamesBadRequest creates a GetFqdnNamesBadRequest with default headers values
func NewGetFqdnNamesBadRequest() *GetFqdnNamesBadRequest {
	return &GetFqdnNamesBadRequest{}
}

/*
GetFqdnNamesBadRequest describes a response with status code 400, with default header values.

Invalid request (error parsing parameters)
*/
type GetFqdnNamesBadRequest struct {
	Payload models.Error
}

// IsSuccess returns true when this get fqdn names bad request response has a 2xx status code
func (o *GetFqdnNamesBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get fqdn names bad request response has a 3xx status code
func (o *GetFqdnNamesBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get fqdn names bad request response has a 4xx status code
func (o *GetFqdnNamesBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get fqdn names bad request response has a 5xx status code
func (o *GetFqdnNamesBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get fqdn names bad request response a status code equal to that given
func (o *GetFqdnNamesBadRequest) IsCode(code int) bool {
	return code == 400
}

func (o *GetFqdnNamesBadRequest) Error() string {
	return fmt.Sprintf("[GET /fqdn/names][%d] getFqdnNamesBadRequest  %+v", 400, o.Payload)
}

func (o *GetFqdnNamesBadRequest) String() string {
	return fmt.Sprintf("[GET /fqdn/names][%d] getFqdnNamesBadRequest  %+v", 400, o.Payload)
}

func (o *GetFqdnNamesBadRequest) GetPayload() models.Error {
	return o.Payload
}

func (o *GetFqdnNamesBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
