<!-- Code generated by gomarkdoc. DO NOT EDIT -->

# generic

```go
import "github.com/zyedidia/generic"
```

## Index

- [func Clamp[T constraints.Ordered](x, lo, hi T) T](<#func-clamp>)
- [func ClampFunc[T any](x, lo, hi T, less LessFn[T]) T](<#func-clampfunc>)
- [func Compare[T any](a, b T, less LessFn[T]) int](<#func-compare>)
- [func Equals[T comparable](a, b T) bool](<#func-equals>)
- [func HashBytes(b []byte) uint64](<#func-hashbytes>)
- [func HashInt(i int) uint64](<#func-hashint>)
- [func HashInt16(i int16) uint64](<#func-hashint16>)
- [func HashInt32(i int32) uint64](<#func-hashint32>)
- [func HashInt64(i int64) uint64](<#func-hashint64>)
- [func HashInt8(i int8) uint64](<#func-hashint8>)
- [func HashString(s string) uint64](<#func-hashstring>)
- [func HashUint(i uint) uint64](<#func-hashuint>)
- [func HashUint16(u uint16) uint64](<#func-hashuint16>)
- [func HashUint32(u uint32) uint64](<#func-hashuint32>)
- [func HashUint64(u uint64) uint64](<#func-hashuint64>)
- [func HashUint8(u uint8) uint64](<#func-hashuint8>)
- [func Less[T constraints.Ordered](a, b T) bool](<#func-less>)
- [func Max[T constraints.Ordered](a, b T) T](<#func-max>)
- [func MaxFunc[T any](a, b T, less LessFn[T]) T](<#func-maxfunc>)
- [func Min[T constraints.Ordered](a, b T) T](<#func-min>)
- [func MinFunc[T any](a, b T, less LessFn[T]) T](<#func-minfunc>)
- [type EqualsFn](<#type-equalsfn>)
- [type HashFn](<#type-hashfn>)
- [type LessFn](<#type-lessfn>)


## func [Clamp](<https://github.com/zyedidia/generic/blob/master/generic.go#L62>)

```go
func Clamp[T constraints.Ordered](x, lo, hi T) T
```

Clamp returns x constrained within \[lo:hi\] range. If x compares less than lo, returns lo; otherwise if hi compares less than x, returns hi; otherwise returns v.

<details><summary>Example</summary>
<p>

```go
package main

import (
	"fmt"
	"time"

	"github.com/zyedidia/generic"
)

func main() {
	fmt.Println(generic.Clamp(500, 400, 600))
	fmt.Println(generic.Clamp(200, 400, 600))
	fmt.Println(generic.Clamp(800, 400, 600))

	fmt.Println(generic.Clamp(5*time.Second, 4*time.Second, 6*time.Second).Milliseconds())
	fmt.Println(generic.Clamp(2*time.Second, 4*time.Second, 6*time.Second).Milliseconds())
	fmt.Println(generic.Clamp(8*time.Second, 4*time.Second, 6*time.Second).Milliseconds())

	fmt.Println(generic.Clamp(1.5, 1.4, 1.8))
	fmt.Println(generic.Clamp(1.5, 1.8, 1.8))
	fmt.Println(generic.Clamp(1.5, 2.1, 1.9))

}
```

#### Output

```
500
400
600
5000
4000
6000
1.5
1.8
2.1
```

</p>
</details>

## func [ClampFunc](<https://github.com/zyedidia/generic/blob/master/generic.go#L84>)

```go
func ClampFunc[T any](x, lo, hi T, less LessFn[T]) T
```

ClampFunc returns x constrained within \[lo:hi\] range using the less func. If x compares less than lo, returns lo; otherwise if hi compares less than x, returns hi; otherwise returns v.

<details><summary>Example</summary>
<p>

```go
package main

import (
	"fmt"
	"math"

	"github.com/zyedidia/generic"
)

func lessMagnitude(a, b float64) bool {
	return math.Abs(a) < math.Abs(b)
}

func main() {
	fmt.Println(generic.ClampFunc(1.5, 1.4, 1.8, lessMagnitude))
	fmt.Println(generic.ClampFunc(1.5, 1.8, 1.8, lessMagnitude))
	fmt.Println(generic.ClampFunc(1.5, 2.1, 1.9, lessMagnitude))
	fmt.Println(generic.ClampFunc(-1.5, -1.4, -1.8, lessMagnitude))
	fmt.Println(generic.ClampFunc(-1.5, -1.8, -1.8, lessMagnitude))
	fmt.Println(generic.ClampFunc(-1.5, -2.1, -1.9, lessMagnitude))
	fmt.Println(generic.ClampFunc(1.5, -1.5, -1.5, lessMagnitude))

}
```

#### Output

```
1.5
1.8
2.1
-1.5
-1.8
-2.1
1.5
```

</p>
</details>

## func [Compare](<https://github.com/zyedidia/generic/blob/master/generic.go#L35>)

```go
func Compare[T any](a, b T, less LessFn[T]) int
```

Compare uses a less function to determine the ordering of 'a' and 'b'. It returns:

\* \-1 if a \< b

\* 1 if a \> b

\* 0 if a == b

## func [Equals](<https://github.com/zyedidia/generic/blob/master/generic.go#L19>)

```go
func Equals[T comparable](a, b T) bool
```

Equals wraps the '==' operator for comparable types.

## func [HashBytes](<https://github.com/zyedidia/generic/blob/master/generic.go#L121>)

```go
func HashBytes(b []byte) uint64
```

## func [HashInt](<https://github.com/zyedidia/generic/blob/master/generic.go#L112>)

```go
func HashInt(i int) uint64
```

## func [HashInt16](<https://github.com/zyedidia/generic/blob/master/generic.go#L106>)

```go
func HashInt16(i int16) uint64
```

## func [HashInt32](<https://github.com/zyedidia/generic/blob/master/generic.go#L103>)

```go
func HashInt32(i int32) uint64
```

## func [HashInt64](<https://github.com/zyedidia/generic/blob/master/generic.go#L100>)

```go
func HashInt64(i int64) uint64
```

## func [HashInt8](<https://github.com/zyedidia/generic/blob/master/generic.go#L109>)

```go
func HashInt8(i int8) uint64
```

## func [HashString](<https://github.com/zyedidia/generic/blob/master/generic.go#L118>)

```go
func HashString(s string) uint64
```

## func [HashUint](<https://github.com/zyedidia/generic/blob/master/generic.go#L115>)

```go
func HashUint(i uint) uint64
```

## func [HashUint16](<https://github.com/zyedidia/generic/blob/master/generic.go#L94>)

```go
func HashUint16(u uint16) uint64
```

## func [HashUint32](<https://github.com/zyedidia/generic/blob/master/generic.go#L91>)

```go
func HashUint32(u uint32) uint64
```

## func [HashUint64](<https://github.com/zyedidia/generic/blob/master/generic.go#L88>)

```go
func HashUint64(u uint64) uint64
```

## func [HashUint8](<https://github.com/zyedidia/generic/blob/master/generic.go#L97>)

```go
func HashUint8(u uint8) uint64
```

## func [Less](<https://github.com/zyedidia/generic/blob/master/generic.go#L24>)

```go
func Less[T constraints.Ordered](a, b T) bool
```

Less wraps the '\<' operator for ordered types.

## func [Max](<https://github.com/zyedidia/generic/blob/master/generic.go#L45>)

```go
func Max[T constraints.Ordered](a, b T) T
```

Max returns the max of a and b.

<details><summary>Example</summary>
<p>

```go
package main

import (
	"fmt"
	"time"

	"github.com/zyedidia/generic"
)

func main() {
	fmt.Println(generic.Max(7, 3))
	fmt.Println(generic.Max(2*time.Second, 3*time.Second).Milliseconds())
}
```

#### Output

```
7
3000
```

</p>
</details>

## func [MaxFunc](<https://github.com/zyedidia/generic/blob/master/generic.go#L67>)

```go
func MaxFunc[T any](a, b T, less LessFn[T]) T
```

MaxFunc returns the max of a and b using the less func.

<details><summary>Example</summary>
<p>

```go
package main

import (
	"fmt"
	"math"

	"github.com/zyedidia/generic"
)

func lessMagnitude(a, b float64) bool {
	return math.Abs(a) < math.Abs(b)
}

func main() {
	fmt.Println(generic.MaxFunc(2.5, -3.1, lessMagnitude))
}
```

#### Output

```
-3.1
```

</p>
</details>

## func [Min](<https://github.com/zyedidia/generic/blob/master/generic.go#L53>)

```go
func Min[T constraints.Ordered](a, b T) T
```

Min returns the min of a and b.

<details><summary>Example</summary>
<p>

```go
package main

import (
	"fmt"
	"time"

	"github.com/zyedidia/generic"
)

func main() {
	fmt.Println(generic.Min(7, 3))
	fmt.Println(generic.Min(2*time.Second, 3*time.Second).Milliseconds())
}
```

#### Output

```
3
2000
```

</p>
</details>

## func [MinFunc](<https://github.com/zyedidia/generic/blob/master/generic.go#L75>)

```go
func MinFunc[T any](a, b T, less LessFn[T]) T
```

MinFunc returns the min of a and b using the less func.

<details><summary>Example</summary>
<p>

```go
package main

import (
	"fmt"
	"math"

	"github.com/zyedidia/generic"
)

func lessMagnitude(a, b float64) bool {
	return math.Abs(a) < math.Abs(b)
}

func main() {
	fmt.Println(generic.MinFunc(2.5, -3.1, lessMagnitude))
}
```

#### Output

```
2.5
```

</p>
</details>

## type [EqualsFn](<https://github.com/zyedidia/generic/blob/master/generic.go#L10>)

EqualsFn is a function that returns whether 'a' and 'b' are equal.

```go
type EqualsFn[T any] func(a, b T) bool
```

## type [HashFn](<https://github.com/zyedidia/generic/blob/master/generic.go#L16>)

HashFn is a function that returns the hash of 't'.

```go
type HashFn[T any] func(t T) uint64
```

## type [LessFn](<https://github.com/zyedidia/generic/blob/master/generic.go#L13>)

LessFn is a function that returns whether 'a' is less than 'b'.

```go
type LessFn[T any] func(a, b T) bool
```



Generated by [gomarkdoc](<https://github.com/princjef/gomarkdoc>)
