#ifndef WMPASMAN_H
#define WMPASMAN_H

#include <glib.h>

#define APP_GENERIC_ERROR app_generic_error_quark()
#define APP_NO_ERROR app_no_error_quark()

GQuark app_generic_error_quark(void) G_GNUC_CONST;
GQuark app_no_error_quark(void) G_GNUC_CONST;

typedef enum {
    STARTING,
    LOCKED,
    NOPASS,
    INACTIVE,
    WORKING,
    ACTIVE,
} appstate_t;
extern appstate_t appstate;

void app_unlock(void);
void app_lock(void);
void app_activate(void);
void app_deactivate(void);
void app_update_state(void);

// Call app_start_work() to set the state to "WORKING" and get a GCancellable
// to pass to keyring functions. When your callback is called, success or fail,
// call app_finish_work().
GCancellable *app_start_work(void);
void app_cancel_work();
void app_finish_work();

extern gboolean allow_insecure_memory;

void exec_command(int button);

#endif
