/*
************************************************************************
*
*   VRML2Init.c - init VRML2 device
*
*   Copyright (c) 1996-99
*
*   ETH Zuerich
*   Institut fuer Molekularbiologie und Biophysik
*   ETH-Hoenggerberg
*   CH-8093 Zuerich
*
*   SPECTROSPIN AG
*   Industriestr. 26
*   CH-8117 Faellanden
*
*   All Rights Reserved
*
*   Date of last modification : 01/05/27
*   Pathname of SCCS file     : /tmp_mnt/net/sn/homeb/rkoradi/molmol-master/sg/src/vrml2/SCCS/s.VRML2Init.c
*   SCCS identification       : 1.2
*
************************************************************************
*/

#include "vrml2_init.h"

#include <sg_plot.h>
#include <sg_get.h>
#include "vrml2_util.h"

SgRes
SgVRML2Init(int *argcP, char *argv[])
{
  SgPlotOutputStr("#VRML V2.0 utf8\n\n");

  SgPlotOutputStr("WorldInfo {\n");
  SgPlotOutputStr("title \"MOLMOL VRML 2.0 Output\"\n");
  SgPlotOutputStr("info [\"Generated by MOLMOL\"]\n");
  SgPlotOutputStr("}\n\n");

  VRML2Init2D();

  return SG_RES_OK;
}

SgRes
SgVRML2Cleanup(void)
{
  float r, g, b;

  SgGetBackgroundColor(&r, &g, &b);
  if (r != 0.0f || g != 0.0f || b != 0.0f) {
    SgPlotOutputStr("Background {\n");
    SgPlotOutputStr("skyColor [");
    SgPlotOutputFloat(r);
    SgPlotOutputStr(" ");
    SgPlotOutputFloat(g);
    SgPlotOutputStr(" ");
    SgPlotOutputFloat(b);
    SgPlotOutputStr("]\n");
    SgPlotOutputStr("}\n");
  }

  return SG_RES_OK;
}
