/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd;

import com.sun.msv.datatype.xsd.Comparator;
import com.sun.msv.datatype.xsd.DataTypeWithFacet;
import com.sun.msv.datatype.xsd.EnumerationFacet;
import com.sun.msv.datatype.xsd.FinalComponent;
import com.sun.msv.datatype.xsd.FractionDigitsFacet;
import com.sun.msv.datatype.xsd.LengthFacet;
import com.sun.msv.datatype.xsd.MaxExclusiveFacet;
import com.sun.msv.datatype.xsd.MaxInclusiveFacet;
import com.sun.msv.datatype.xsd.MaxLengthFacet;
import com.sun.msv.datatype.xsd.MinExclusiveFacet;
import com.sun.msv.datatype.xsd.MinInclusiveFacet;
import com.sun.msv.datatype.xsd.MinLengthFacet;
import com.sun.msv.datatype.xsd.PatternFacet;
import com.sun.msv.datatype.xsd.RangeFacet;
import com.sun.msv.datatype.xsd.TotalDigitsFacet;
import com.sun.msv.datatype.xsd.WhiteSpaceFacet;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.datatype.xsd.XSDatatypeImpl;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

public class TypeIncubator {
    private final Map impl = new HashMap();
    private final XSDatatypeImpl baseType;
    private static final String[][] exclusiveFacetPairs = new String[][]{{"length", "minLength"}, {"length", "maxLength"}, {"maxInclusive", "maxExclusive"}, {"minInclusive", "minExclusive"}};

    public TypeIncubator(XSDatatype xSDatatype) {
        this.baseType = (XSDatatypeImpl)xSDatatype;
        if (xSDatatype == null) {
            throw new IllegalArgumentException();
        }
    }

    public void add(String string, String string2, boolean bl, ValidationContext validationContext) throws DatatypeException {
        this.addFacet(string, string2, bl, validationContext);
    }

    public void addFacet(String string, String string2, boolean bl, ValidationContext validationContext) throws DatatypeException {
        Object object;
        switch (this.baseType.isFacetApplicable(string)) {
            case 0: {
                break;
            }
            case -1: {
                throw new DatatypeException(XSDatatypeImpl.localize("BadTypeException.OverridingFixedFacet", string));
            }
            case -2: {
                throw new DatatypeException(XSDatatypeImpl.localize("BadTypeException.NotApplicableFacet", string));
            }
            default: {
                throw new Error();
            }
        }
        if (TypeIncubator.isValueFacet(string)) {
            object = this.baseType.createValue(string2, validationContext);
            if (object == null) {
                throw new DatatypeException(XSDatatypeImpl.localize("EnumerationFacet.InvalidValueForThisType", string2, this.baseType.displayName()));
            }
        } else {
            object = string2;
        }
        if (TypeIncubator.isRepeatable(string)) {
            FacetInfo facetInfo;
            if (this.impl.containsKey(string)) {
                facetInfo = (FacetInfo)this.impl.get(string);
            } else {
                facetInfo = new FacetInfo(new Vector(), bl);
                this.impl.put(string, facetInfo);
            }
            ((Vector)facetInfo.value).add(object);
            facetInfo.fixed |= bl;
        } else {
            if (this.impl.containsKey(string)) {
                throw new DatatypeException(XSDatatypeImpl.localize("BadTypeException.DuplicateFacet", string));
            }
            this.impl.put(string, new FacetInfo(object, bl));
        }
    }

    public XSDatatypeImpl derive(String string) throws DatatypeException {
        if (this.baseType.isFinal(1)) {
            throw new DatatypeException(XSDatatypeImpl.localize("BadTypeException.InvalidBaseType", this.baseType.displayName()));
        }
        if (this.isEmpty()) {
            if (string == null) {
                return this.baseType;
            }
            return new FinalComponent(string, this.baseType, 0);
        }
        XSDatatypeImpl xSDatatypeImpl = this.baseType;
        int n = 0;
        while (n < exclusiveFacetPairs.length) {
            if (this.contains(exclusiveFacetPairs[n][0]) && this.contains(exclusiveFacetPairs[n][1])) {
                throw new DatatypeException(XSDatatypeImpl.localize("XAndYAreExclusive", exclusiveFacetPairs[n][0], exclusiveFacetPairs[n][1]));
            }
            ++n;
        }
        if (this.contains("totalDigits")) {
            xSDatatypeImpl = new TotalDigitsFacet(string, xSDatatypeImpl, this);
        }
        if (this.contains("fractionDigits")) {
            xSDatatypeImpl = new FractionDigitsFacet(string, xSDatatypeImpl, this);
        }
        if (this.contains("minInclusive")) {
            xSDatatypeImpl = new MinInclusiveFacet(string, xSDatatypeImpl, this);
        }
        if (this.contains("maxInclusive")) {
            xSDatatypeImpl = new MaxInclusiveFacet(string, xSDatatypeImpl, this);
        }
        if (this.contains("minExclusive")) {
            xSDatatypeImpl = new MinExclusiveFacet(string, xSDatatypeImpl, this);
        }
        if (this.contains("maxExclusive")) {
            xSDatatypeImpl = new MaxExclusiveFacet(string, xSDatatypeImpl, this);
        }
        if (this.contains("length")) {
            xSDatatypeImpl = new LengthFacet(string, xSDatatypeImpl, this);
        }
        if (this.contains("minLength")) {
            xSDatatypeImpl = new MinLengthFacet(string, xSDatatypeImpl, this);
        }
        if (this.contains("maxLength")) {
            xSDatatypeImpl = new MaxLengthFacet(string, xSDatatypeImpl, this);
        }
        if (this.contains("whiteSpace")) {
            xSDatatypeImpl = new WhiteSpaceFacet(string, xSDatatypeImpl, this);
        }
        if (this.contains("pattern")) {
            xSDatatypeImpl = new PatternFacet(string, xSDatatypeImpl, this);
        }
        if (this.contains("enumeration")) {
            xSDatatypeImpl = new EnumerationFacet(string, xSDatatypeImpl, this);
        }
        DataTypeWithFacet dataTypeWithFacet = xSDatatypeImpl.getFacetObject("maxLength");
        DataTypeWithFacet dataTypeWithFacet2 = xSDatatypeImpl.getFacetObject("minLength");
        if (dataTypeWithFacet != null && dataTypeWithFacet2 != null && ((MaxLengthFacet)dataTypeWithFacet).maxLength < ((MinLengthFacet)dataTypeWithFacet2).minLength) {
            throw TypeIncubator.reportFacetInconsistency(string, dataTypeWithFacet, "maxLength", dataTypeWithFacet2, "minLength");
        }
        dataTypeWithFacet = xSDatatypeImpl.getFacetObject("fractionDigits");
        dataTypeWithFacet2 = xSDatatypeImpl.getFacetObject("totalDigits");
        if (dataTypeWithFacet != null && dataTypeWithFacet2 != null && ((FractionDigitsFacet)dataTypeWithFacet).scale > ((TotalDigitsFacet)dataTypeWithFacet2).precision) {
            throw TypeIncubator.reportFacetInconsistency(string, dataTypeWithFacet, "fractionDigits", dataTypeWithFacet2, "totalDigits");
        }
        TypeIncubator.checkRangeConsistency(xSDatatypeImpl, "minInclusive", "maxInclusive");
        TypeIncubator.checkRangeConsistency(xSDatatypeImpl, "minExclusive", "maxExclusive");
        TypeIncubator.checkRangeConsistency(xSDatatypeImpl, "minInclusive", "maxExclusive");
        TypeIncubator.checkRangeConsistency(xSDatatypeImpl, "minExclusive", "maxInclusive");
        return xSDatatypeImpl;
    }

    private static void checkRangeConsistency(XSDatatypeImpl xSDatatypeImpl, String string, String string2) throws DatatypeException {
        int n;
        DataTypeWithFacet dataTypeWithFacet = xSDatatypeImpl.getFacetObject(string);
        DataTypeWithFacet dataTypeWithFacet2 = xSDatatypeImpl.getFacetObject(string2);
        if (dataTypeWithFacet != null && dataTypeWithFacet2 != null && (n = ((Comparator)((Object)dataTypeWithFacet.getConcreteType())).compare(((RangeFacet)dataTypeWithFacet).limitValue, ((RangeFacet)dataTypeWithFacet2).limitValue)) == 1) {
            throw TypeIncubator.reportFacetInconsistency(xSDatatypeImpl.displayName(), dataTypeWithFacet, string, dataTypeWithFacet2, string2);
        }
    }

    private static DatatypeException reportFacetInconsistency(String string, DataTypeWithFacet dataTypeWithFacet, String string2, DataTypeWithFacet dataTypeWithFacet2, String string3) {
        String string4;
        String string5 = dataTypeWithFacet.getName();
        if (string5.equals(string4 = dataTypeWithFacet2.getName())) {
            return new DatatypeException(XSDatatypeImpl.localize("InconsistentFacets.1", string2, string3));
        }
        if (string5.equals(string)) {
            return new DatatypeException(XSDatatypeImpl.localize("InconsistentFacets.2", string2, dataTypeWithFacet2.displayName(), string3));
        }
        if (string4.equals(string)) {
            return new DatatypeException(XSDatatypeImpl.localize("InconsistentFacets.2", string3, dataTypeWithFacet.displayName(), string2));
        }
        throw new IllegalStateException();
    }

    private static boolean isValueFacet(String string) {
        return string.equals("enumeration") || string.equals("maxExclusive") || string.equals("minExclusive") || string.equals("maxInclusive") || string.equals("minInclusive");
    }

    private static boolean isRepeatable(String string) {
        return string.equals("enumeration") || string.equals("pattern");
    }

    public boolean isFixed(String string) {
        return ((FacetInfo)this.impl.get((Object)string)).fixed;
    }

    public Object getFacet(String string) {
        return ((FacetInfo)this.impl.get((Object)string)).value;
    }

    public Vector getVector(String string) {
        return (Vector)((FacetInfo)this.impl.get((Object)string)).value;
    }

    public int getPositiveInteger(String string) throws DatatypeException {
        try {
            int n = Integer.parseInt((String)this.getFacet(string));
            if (n > 0) {
                return n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            try {
                if (new BigInteger((String)this.getFacet(string)).signum() > 0) {
                    return Integer.MAX_VALUE;
                }
            }
            catch (NumberFormatException numberFormatException2) {
                // empty catch block
            }
        }
        throw new DatatypeException(XSDatatypeImpl.localize("BadTypeException.FacetMustBePositiveInteger", string));
    }

    public int getNonNegativeInteger(String string) throws DatatypeException {
        try {
            int n = Integer.parseInt((String)this.getFacet(string));
            if (n >= 0) {
                return n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new DatatypeException(XSDatatypeImpl.localize("BadTypeException.FacetMustBeNonNegativeInteger", string));
    }

    private boolean contains(String string) {
        return this.impl.containsKey(string);
    }

    public boolean isEmpty() {
        return this.impl.isEmpty();
    }

    public void dump(PrintStream printStream) {
        Iterator iterator = this.impl.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            FacetInfo facetInfo = (FacetInfo)this.impl.get(string);
            if (facetInfo.value instanceof Vector) {
                printStream.println(string + " :");
                Vector vector = (Vector)facetInfo.value;
                int n = 0;
                while (n < vector.size()) {
                    printStream.println("  " + vector.elementAt(n));
                    ++n;
                }
                continue;
            }
            printStream.println(string + " : " + facetInfo.value);
        }
    }

    public String getFacetNames() {
        String string = "";
        Iterator iterator = this.impl.keySet().iterator();
        while (iterator.hasNext()) {
            if (string.length() != 0) {
                string = string + ", ";
            }
            string = string + (String)iterator.next();
        }
        return string;
    }

    private static class FacetInfo {
        public Object value;
        public boolean fixed;

        public FacetInfo(Object object, boolean bl) {
            this.value = object;
            this.fixed = bl;
        }
    }
}

