/*
 *  svaf_render.c: submit SVAF geometry to an OpenGL renderer.
 *
 *  Copyright (c) 2006, Michael C. Martin
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *  - Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  - Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  - Neither the name 'Bumbershoot Software' nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 *  CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 *  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 *  BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 *  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 *  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 *  TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 *  THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *  SUCH DAMAGE.
 */

#include "svaf.h"

void
svaf_SelectModel (svaf_model *m)
{
	glVertexPointer (3, GL_FLOAT, 0, m->vertices);
	glNormalPointer (GL_FLOAT, 0, m->normals);
}

void
svaf_SetAlpha (svaf_model *m, GLfloat alpha)
{
	int i;
	for (i = 0; i < m->num_commands; i++)
	{
		if (m->commands[i].tag == SVAF_CMD_MATERIAL)
		{
			m->commands[i].command.material.diffuse[3] = alpha;
			m->commands[i].command.material.specular[3] = alpha;
			m->commands[i].command.material.emissive[3] = alpha;
		}
	}
}

void
svaf_RenderCommands (svaf_model *m)
{
	int i;
	for (i = 0; i < m->num_commands; i++)
	{
		switch (m->commands[i].tag)
		{
		case SVAF_CMD_MATERIAL:
			glMaterialfv (GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, m->commands[i].command.material.diffuse);
			glMaterialfv (GL_FRONT_AND_BACK, GL_SPECULAR, m->commands[i].command.material.specular);
			glMaterialfv (GL_FRONT_AND_BACK, GL_EMISSION, m->commands[i].command.material.emissive);
			glMaterialf (GL_FRONT_AND_BACK, GL_SHININESS, m->commands[i].command.material.shininess);
			break;
		case SVAF_CMD_ELEMENTS:
			glDrawElements (m->commands[i].command.elements.type,
					m->commands[i].command.elements.count,
					GL_UNSIGNED_INT,
					m->commands[i].command.elements.indices);
			break;
		default:
			break;
		}
	}
}
