/*
 * Decompiled with CFR 0.152.
 */
package jwbroek.cuelib;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import jwbroek.cuelib.Error;
import jwbroek.cuelib.FileData;
import jwbroek.cuelib.LineOfInput;
import jwbroek.cuelib.Message;
import jwbroek.cuelib.TrackData;
import jwbroek.cuelib.Warning;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CueSheet {
    private final List<Message> messages = new ArrayList<Message>();
    private final List<FileData> fileData = new ArrayList<FileData>();
    private String catalog = null;
    private String cdTextFile = null;
    private String performer = null;
    private String title = null;
    private String songwriter = null;
    private String comment = null;
    private int year = -1;
    private String discid = null;
    private String genre = null;
    private static final Logger logger = Logger.getLogger(CueSheet.class.getCanonicalName());

    public CueSheet() {
        logger.entering(CueSheet.class.getCanonicalName(), "CueSheet()");
        logger.exiting(CueSheet.class.getCanonicalName(), "CueSheet()");
    }

    public String getMetaData(MetaDataField metaDataField) throws IllegalArgumentException {
        String string;
        logger.entering(CueSheet.class.getCanonicalName(), "getMetaData(MetaDataField)", (Object)metaDataField);
        switch (metaDataField) {
            case CATALOG: {
                string = this.getCatalog() == null ? "" : this.getCatalog();
                break;
            }
            case CDTEXTFILE: {
                string = this.getCdTextFile() == null ? "" : this.getCdTextFile();
                break;
            }
            case COMMENT: {
                string = this.getComment() == null ? "" : this.getComment();
                break;
            }
            case DISCID: {
                string = this.getDiscid() == null ? "" : this.getDiscid();
                break;
            }
            case GENRE: {
                string = this.getGenre() == null ? "" : this.getGenre();
                break;
            }
            case PERFORMER: 
            case ALBUMPERFORMER: {
                string = this.getPerformer() == null ? "" : this.getPerformer();
                break;
            }
            case SONGWRITER: 
            case ALBUMSONGWRITER: {
                string = this.getSongwriter() == null ? "" : this.getSongwriter();
                break;
            }
            case TITLE: 
            case ALBUMTITLE: {
                string = this.getTitle() == null ? "" : this.getTitle();
                break;
            }
            case YEAR: {
                string = this.getYear() == -1 ? "" : "" + this.getYear();
                break;
            }
            default: {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Unsupported field: " + metaDataField.toString());
                logger.throwing(CueSheet.class.getCanonicalName(), "getMetaData(MetaDataField)", illegalArgumentException);
                throw illegalArgumentException;
            }
        }
        logger.exiting(CueSheet.class.getCanonicalName(), "getMetaData(MetaDataField)", string);
        return string;
    }

    public void addError(LineOfInput lineOfInput, String string) {
        logger.entering(CueSheet.class.getCanonicalName(), "addError(LineOfInput,String)", new Object[]{lineOfInput, string});
        this.messages.add(new Error(lineOfInput, string));
        logger.exiting(CueSheet.class.getCanonicalName(), "addError(LineOfInput,String)");
    }

    public void addWarning(LineOfInput lineOfInput, String string) {
        logger.entering(CueSheet.class.getCanonicalName(), "addWarning(LineOfInput,String)", new Object[]{lineOfInput, string});
        this.messages.add(new Warning(lineOfInput, string));
        logger.exiting(CueSheet.class.getCanonicalName(), "addWarning(LineOfInput,String)");
    }

    public List<TrackData> getAllTrackData() {
        logger.entering(CueSheet.class.getCanonicalName(), "getAllTrackData()");
        ArrayList<TrackData> arrayList = new ArrayList<TrackData>();
        for (FileData fileData : this.fileData) {
            arrayList.addAll(fileData.getTrackData());
        }
        logger.exiting(CueSheet.class.getCanonicalName(), "getAllTrackData()", arrayList);
        return arrayList;
    }

    public String getCatalog() {
        logger.entering(CueSheet.class.getCanonicalName(), "getCatalog()");
        logger.exiting(CueSheet.class.getCanonicalName(), "getCatalog()", this.catalog);
        return this.catalog;
    }

    public void setCatalog(String string) {
        logger.entering(CueSheet.class.getCanonicalName(), "setCatalog(String)", string);
        this.catalog = string;
        logger.exiting(CueSheet.class.getCanonicalName(), "setCatalog(String)");
    }

    public String getCdTextFile() {
        logger.entering(CueSheet.class.getCanonicalName(), "getCdTextFile()");
        logger.exiting(CueSheet.class.getCanonicalName(), "getCdTextFile()", this.cdTextFile);
        return this.cdTextFile;
    }

    public void setCdTextFile(String string) {
        logger.entering(CueSheet.class.getCanonicalName(), "setCdTextFile(String)", string);
        this.cdTextFile = string;
        logger.exiting(CueSheet.class.getCanonicalName(), "setCdTextFile(String)");
    }

    public String getPerformer() {
        logger.entering(CueSheet.class.getCanonicalName(), "getPerformer()");
        logger.exiting(CueSheet.class.getCanonicalName(), "getPerformer()", this.performer);
        return this.performer;
    }

    public void setPerformer(String string) {
        logger.entering(CueSheet.class.getCanonicalName(), "setPerformer(String)", string);
        this.performer = string;
        logger.exiting(CueSheet.class.getCanonicalName(), "setPerformer(String)");
    }

    public String getSongwriter() {
        logger.entering(CueSheet.class.getCanonicalName(), "getSongwriter()");
        logger.exiting(CueSheet.class.getCanonicalName(), "getSongwriter()", this.songwriter);
        return this.songwriter;
    }

    public void setSongwriter(String string) {
        logger.entering(CueSheet.class.getCanonicalName(), "setSongwriter(String)", string);
        this.songwriter = string;
        logger.exiting(CueSheet.class.getCanonicalName(), "setSongwriter(String)");
    }

    public String getTitle() {
        logger.entering(CueSheet.class.getCanonicalName(), "getTitle()");
        logger.exiting(CueSheet.class.getCanonicalName(), "getTitle()", this.title);
        return this.title;
    }

    public void setTitle(String string) {
        logger.entering(CueSheet.class.getCanonicalName(), "setTitle(String)", string);
        this.title = string;
        logger.exiting(CueSheet.class.getCanonicalName(), "setTitle(String)");
    }

    public String getDiscid() {
        logger.entering(CueSheet.class.getCanonicalName(), "getDiscid()");
        logger.exiting(CueSheet.class.getCanonicalName(), "getDiscid()", this.discid);
        return this.discid;
    }

    public void setDiscid(String string) {
        logger.entering(CueSheet.class.getCanonicalName(), "setDiscid(String)", string);
        this.discid = string;
        logger.exiting(CueSheet.class.getCanonicalName(), "setDiscid(String)");
    }

    public String getGenre() {
        logger.entering(CueSheet.class.getCanonicalName(), "getGenre()");
        logger.exiting(CueSheet.class.getCanonicalName(), "getGenre()", this.genre);
        return this.genre;
    }

    public void setGenre(String string) {
        logger.entering(CueSheet.class.getCanonicalName(), "setGenre(String)", string);
        this.genre = string;
        logger.exiting(CueSheet.class.getCanonicalName(), "setGenre(String)");
    }

    public int getYear() {
        logger.entering(CueSheet.class.getCanonicalName(), "getYear()");
        logger.exiting(CueSheet.class.getCanonicalName(), "getYear()", this.year);
        return this.year;
    }

    public void setYear(int n) {
        logger.entering(CueSheet.class.getCanonicalName(), "setYear(int)", n);
        this.year = n;
        logger.exiting(CueSheet.class.getCanonicalName(), "setYear(int)");
    }

    public String getComment() {
        logger.entering(CueSheet.class.getCanonicalName(), "getComment()");
        logger.exiting(CueSheet.class.getCanonicalName(), "getComment()", this.comment);
        return this.comment;
    }

    public void setComment(String string) {
        logger.entering(CueSheet.class.getCanonicalName(), "setComment(String)", string);
        this.comment = string;
        logger.exiting(CueSheet.class.getCanonicalName(), "setComment(String)");
    }

    public List<FileData> getFileData() {
        logger.entering(CueSheet.class.getCanonicalName(), "getFileData()");
        logger.exiting(CueSheet.class.getCanonicalName(), "getFileData()", this.fileData);
        return this.fileData;
    }

    public List<Message> getMessages() {
        logger.entering(CueSheet.class.getCanonicalName(), "getMessages()");
        logger.exiting(CueSheet.class.getCanonicalName(), "getMessages()", this.messages);
        return this.messages;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MetaDataField {
        ALBUMPERFORMER,
        ALBUMSONGWRITER,
        ALBUMTITLE,
        CATALOG,
        CDTEXTFILE,
        COMMENT,
        DISCID,
        GENRE,
        ISRCCODE,
        PERFORMER,
        SONGWRITER,
        TITLE,
        TRACKNUMBER,
        TRACKPERFORMER,
        TRACKSONGWRITER,
        TRACKTITLE,
        YEAR;

    }
}

