/*
 * Decompiled with CFR 0.152.
 */
package jwbroek.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import jwbroek.util.LogUtil;

public class StreamPiper
implements Runnable {
    private InputStream from;
    private OutputStream to;
    private boolean closeOutput;
    private static final Logger logger = Logger.getLogger(StreamPiper.class.getCanonicalName());

    public StreamPiper(InputStream inputStream, OutputStream outputStream) {
        this(inputStream, outputStream, false);
        logger.entering(StreamPiper.class.getCanonicalName(), "StreamPiper(InputStream,OutputStream)", new Object[]{inputStream, outputStream});
        logger.exiting(StreamPiper.class.getCanonicalName(), "StreamPiper(InputStream,OutputStream)");
    }

    public StreamPiper(InputStream inputStream, OutputStream outputStream, boolean bl) {
        logger.entering(StreamPiper.class.getCanonicalName(), "StreamPiper(InputStream,OutputStream,boolean)", new Object[]{inputStream, outputStream, bl});
        this.from = inputStream;
        this.to = outputStream;
        this.closeOutput = bl;
        logger.exiting(StreamPiper.class.getCanonicalName(), "StreamPiper(InputStream,OutputStream,boolean)");
    }

    public static void pipeStream(InputStream inputStream, File file) throws IOException {
        logger.entering(StreamPiper.class.getCanonicalName(), "pipeStream(InputStream,File)", new Object[]{inputStream, file});
        FileOutputStream fileOutputStream = null;
        if (file != null) {
            fileOutputStream = new FileOutputStream(file);
        }
        new Thread(new StreamPiper(inputStream, fileOutputStream, true)).start();
        logger.exiting(StreamPiper.class.getCanonicalName(), "pipeStream(InputStream,File)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        logger.entering(StreamPiper.class.getCanonicalName(), "run()");
        try {
            int n = this.from.read();
            while (n != -1) {
                if (this.to != null) {
                    this.to.write(n);
                }
                n = this.from.read();
            }
        }
        catch (IOException iOException) {
            LogUtil.logStacktrace(logger, Level.WARNING, iOException);
        }
        finally {
            try {
                this.from.close();
            }
            catch (IOException iOException) {
                LogUtil.logStacktrace(logger, Level.WARNING, iOException);
            }
            if (this.closeOutput && this.to != null) {
                try {
                    this.to.close();
                }
                catch (IOException iOException) {
                    LogUtil.logStacktrace(logger, Level.WARNING, iOException);
                }
            }
        }
        logger.exiting(StreamPiper.class.getCanonicalName(), "run()");
    }
}

