/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import com.sun.jna.Platform;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JComponent;
import net.pms.configuration.PmsConfiguration;
import net.pms.dlna.DLNAMediaInfo;
import net.pms.dlna.DLNAResource;
import net.pms.encoders.Player;
import net.pms.encoders.PlayerPurpose;
import net.pms.io.OutputParams;
import net.pms.io.PipeProcess;
import net.pms.io.ProcessWrapper;
import net.pms.io.ProcessWrapperImpl;
import net.pms.util.PlayerUtil;

public class VideoLanVideoStreaming
extends Player {
    private final PmsConfiguration configuration;
    public static final String ID = "vlcvideo";

    public VideoLanVideoStreaming(PmsConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public PlayerPurpose getPurpose() {
        return PlayerPurpose.VIDEO_WEB_STREAM_PLAYER;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public String[] args() {
        return new String[0];
    }

    @Override
    public String name() {
        return "VLC Web Video (Legacy)";
    }

    @Override
    public int type() {
        return 4;
    }

    @Override
    public String mimeType() {
        return "video/mpeg";
    }

    @Override
    public String executable() {
        return this.configuration.getVlcPath();
    }

    protected String getEncodingArgs() {
        return "vcodec=mp2v,vb=4096,fps=25,scale=1,acodec=mp2a,ab=128,channels=2";
    }

    protected String getMux() {
        return "ts";
    }

    @Override
    public ProcessWrapper launchTranscode(DLNAResource dlna, DLNAMediaInfo media, OutputParams params) throws IOException {
        boolean isWindows = Platform.isWindows();
        String filename = dlna.getSystemName();
        PipeProcess tsPipe = new PipeProcess("VLC" + System.currentTimeMillis() + "." + this.getMux(), new String[0]);
        ProcessWrapper pipe_process = tsPipe.getPipeProcess();
        pipe_process.runInNewThread();
        tsPipe.deleteLater();
        params.input_pipes[0] = tsPipe;
        params.minBufferSize = params.minFileSize;
        params.secondread_minsize = 100000;
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(this.executable());
        cmdList.add("-I");
        cmdList.add("dummy");
        String transcodeSpec = String.format("#transcode{%s}:standard{access=file,mux=%s,dst=\"%s%s\"}", this.getEncodingArgs(), this.getMux(), isWindows ? "\\\\" : "", tsPipe.getInputPipe());
        if (isWindows) {
            cmdList.add("--dummy-quiet");
        }
        if (isWindows || Platform.isMac()) {
            cmdList.add("--sout=" + transcodeSpec);
        } else {
            cmdList.add("--sout");
            cmdList.add(transcodeSpec);
        }
        if (Platform.isMac()) {
            cmdList.add("");
        }
        cmdList.add(filename);
        cmdList.add("vlc://quit");
        String[] cmdArray = new String[cmdList.size()];
        cmdList.toArray(cmdArray);
        cmdArray = this.finalizeTranscoderArgs(filename, dlna, media, params, cmdArray);
        ProcessWrapperImpl pw = new ProcessWrapperImpl(cmdArray, params);
        pw.attachProcess(pipe_process);
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        pw.runInNewThread();
        return pw;
    }

    @Override
    public JComponent config() {
        return null;
    }

    @Override
    public boolean isCompatible(DLNAResource resource) {
        return PlayerUtil.isWebVideo(resource);
    }
}

