/*
 * Decompiled with CFR 0.152.
 */
package net.pms.external;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;
import net.pms.external.AdditionalFolderAtRoot;
import net.pms.external.AdditionalFoldersAtRoot;
import net.pms.external.ExternalListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalFactory {
    private static final Logger logger = LoggerFactory.getLogger(ExternalFactory.class);
    private static final PmsConfiguration configuration = PMS.getConfiguration();
    private static List<ExternalListener> externalListeners = new ArrayList<ExternalListener>();
    private static List<Class<?>> externalListenerClasses = new ArrayList();

    public static List<ExternalListener> getExternalListeners() {
        return externalListeners;
    }

    public static void registerListener(ExternalListener listener) {
        if (!externalListeners.contains(listener)) {
            externalListeners.add(listener);
        }
    }

    private static void registerListenerClass(Class<?> clazz) {
        if (!externalListenerClasses.contains(clazz)) {
            externalListenerClasses.add(clazz);
        }
    }

    public static void lookup() {
        Enumeration<URL> resources;
        int nJars;
        File pluginDirectory = new File(configuration.getPluginDirectory());
        logger.info("Searching for plugins in " + pluginDirectory.getAbsolutePath());
        if (!pluginDirectory.exists()) {
            logger.warn("Plugin directory doesn't exist: " + pluginDirectory);
            return;
        }
        if (!pluginDirectory.isDirectory()) {
            logger.warn("Plugin directory is not a directory: " + pluginDirectory);
            return;
        }
        if (!pluginDirectory.canRead()) {
            logger.warn("Plugin directory is not readable: " + pluginDirectory);
            return;
        }
        File[] jarFiles = pluginDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().toLowerCase().endsWith(".jar");
            }
        });
        int n = nJars = jarFiles == null ? 0 : jarFiles.length;
        if (nJars == 0) {
            logger.info("No plugins found");
            return;
        }
        ArrayList<URL> jarURLList = new ArrayList<URL>();
        for (int i = 0; i < nJars; ++i) {
            try {
                jarURLList.add(jarFiles[i].toURI().toURL());
                continue;
            }
            catch (MalformedURLException e) {
                logger.error("Can't convert file path " + jarFiles[i] + " to URL", e);
            }
        }
        URL[] jarURLs = new URL[jarURLList.size()];
        jarURLList.toArray(jarURLs);
        URLClassLoader classLoader = new URLClassLoader(jarURLs);
        try {
            resources = classLoader.getResources("plugin");
        }
        catch (IOException e) {
            logger.error("Can't load plugin resources", e);
            return;
        }
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            try {
                InputStreamReader in = new InputStreamReader(url.openStream());
                char[] name = new char[512];
                in.read(name);
                in.close();
                String pluginMainClassName = new String(name).trim();
                logger.info("Found plugin: " + pluginMainClassName);
                Class<?> clazz = classLoader.loadClass(pluginMainClassName);
                ExternalFactory.registerListenerClass(clazz);
            }
            catch (Exception e) {
                logger.error("Error loading plugin", e);
            }
            catch (NoClassDefFoundError e) {
                logger.error("Error loading plugin", e);
            }
        }
        ExternalFactory.instantiateEarlyListeners();
    }

    private static void instantiateEarlyListeners() {
        for (Class<?> clazz : externalListenerClasses) {
            if (AdditionalFolderAtRoot.class.isAssignableFrom(clazz) || AdditionalFoldersAtRoot.class.isAssignableFrom(clazz)) continue;
            try {
                ExternalListener instance = (ExternalListener)clazz.newInstance();
                ExternalFactory.registerListener(instance);
            }
            catch (Throwable t) {
                logger.error("Error instantiating plugin", t);
            }
        }
    }

    public static void instantiateLateListeners() {
        for (Class<?> clazz : externalListenerClasses) {
            if (!AdditionalFolderAtRoot.class.isAssignableFrom(clazz) && !AdditionalFoldersAtRoot.class.isAssignableFrom(clazz)) continue;
            try {
                ExternalListener instance = (ExternalListener)clazz.newInstance();
                ExternalFactory.registerListener(instance);
            }
            catch (Throwable t) {
                logger.error("Error instantiating plugin", t);
            }
        }
    }
}

