/*
 * Decompiled with CFR 0.152.
 */
package net.pms.formats.v2;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;
import net.pms.dlna.DLNAMediaSubtitle;
import net.pms.formats.v2.SubtitleType;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.mozilla.universalchardet.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubtitleUtils {
    private static final Logger logger = LoggerFactory.getLogger(SubtitleUtils.class);
    private static PmsConfiguration configuration = PMS.getConfiguration();
    private static final Map<String, String> fileCharsetToMencoderSubcpOptionMap = new HashMap<String, String>(){
        {
            this.put(Constants.CHARSET_IBM855, "enca:ru:cp1251");
            this.put(Constants.CHARSET_ISO_8859_5, "enca:ru:cp1251");
            this.put(Constants.CHARSET_KOI8_R, "enca:ru:cp1251");
            this.put(Constants.CHARSET_MACCYRILLIC, "enca:ru:cp1251");
            this.put(Constants.CHARSET_WINDOWS_1251, "enca:ru:cp1251");
            this.put(Constants.CHARSET_IBM866, "enca:ru:cp1251");
            this.put(Constants.CHARSET_WINDOWS_1253, "cp1253");
            this.put(Constants.CHARSET_ISO_8859_7, "ISO-8859-7");
            this.put(Constants.CHARSET_WINDOWS_1252, "cp1252");
            this.put(Constants.CHARSET_WINDOWS_1255, "cp1255");
            this.put(Constants.CHARSET_ISO_8859_8, "ISO-8859-8");
            this.put(Constants.CHARSET_ISO_2022_CN, "ISO-2022-CN");
            this.put(Constants.CHARSET_BIG5, "enca:zh:big5");
            this.put(Constants.CHARSET_GB18030, "enca:zh:big5");
            this.put(Constants.CHARSET_EUC_TW, "enca:zh:big5");
            this.put(Constants.CHARSET_HZ_GB_2312, "enca:zh:big5");
            this.put(Constants.CHARSET_ISO_2022_KR, "cp949");
            this.put(Constants.CHARSET_EUC_KR, "euc-kr");
            this.put(Constants.CHARSET_ISO_2022_JP, "ISO-2022-JP");
            this.put(Constants.CHARSET_EUC_JP, "euc-jp");
            this.put(Constants.CHARSET_SHIFT_JIS, "shift-jis");
        }
    };
    private static final EnumSet<SubtitleType> SUPPORTS_TIME_SHIFTING = EnumSet.of(SubtitleType.SUBRIP, SubtitleType.ASS);
    private static final DecimalFormat ASS_DECIMAL_FORMAT = new DecimalFormat("00.00");
    private static final DecimalFormat SRT_DECIMAL_FORMAT = new DecimalFormat("00.000");

    public static String getSubCpOptionForMencoder(DLNAMediaSubtitle dlnaMediaSubtitle) {
        if (dlnaMediaSubtitle == null) {
            throw new NullPointerException("dlnaMediaSubtitle can't be null.");
        }
        if (StringUtils.isBlank(dlnaMediaSubtitle.getExternalFileCharacterSet())) {
            return null;
        }
        return fileCharsetToMencoderSubcpOptionMap.get(dlnaMediaSubtitle.getExternalFileCharacterSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DLNAMediaSubtitle shiftSubtitlesTimingWithUtfConversion(DLNAMediaSubtitle inputSubtitles, double timeShift) throws IOException {
        boolean isSubtitlesCodepageAutoDetectedAndSupportedByJVM;
        if (inputSubtitles == null) {
            throw new NullPointerException("inputSubtitles should not be null.");
        }
        if (!inputSubtitles.isExternal()) {
            throw new IllegalArgumentException("inputSubtitles should be external.");
        }
        if (StringUtils.isBlank(inputSubtitles.getExternalFile().getName())) {
            throw new IllegalArgumentException("inputSubtitles' external file should not have blank name.");
        }
        if (inputSubtitles.getType() == null) {
            throw new NullPointerException("inputSubtitles.getType() should not be null.");
        }
        if (!SubtitleUtils.isSupportsTimeShifting(inputSubtitles.getType())) {
            throw new IllegalArgumentException("inputSubtitles.getType() " + (Object)((Object)inputSubtitles.getType()) + " is not supported.");
        }
        File convertedSubtitlesFile = new File(configuration.getTempFolder(), FilenameUtils.getBaseName(inputSubtitles.getExternalFile().getName()) + System.currentTimeMillis() + ".tmp");
        FileUtils.forceDeleteOnExit(convertedSubtitlesFile);
        boolean isSubtitlesCodepageForcedInConfigurationAndSupportedByJVM = StringUtils.isNotBlank(configuration.getSubtitlesCodepage()) && Charset.isSupported(configuration.getSubtitlesCodepage());
        boolean bl = isSubtitlesCodepageAutoDetectedAndSupportedByJVM = StringUtils.isNotBlank(inputSubtitles.getExternalFileCharacterSet()) && Charset.isSupported(inputSubtitles.getExternalFileCharacterSet());
        BufferedReader input = isSubtitlesCodepageForcedInConfigurationAndSupportedByJVM ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputSubtitles.getExternalFile()), Charset.forName(configuration.getSubtitlesCodepage()))) : (isSubtitlesCodepageAutoDetectedAndSupportedByJVM ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputSubtitles.getExternalFile()), Charset.forName(inputSubtitles.getExternalFileCharacterSet()))) : new BufferedReader(new InputStreamReader(new FileInputStream(inputSubtitles.getExternalFile()))));
        BufferedWriter output = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(convertedSubtitlesFile), Charset.forName("UTF-8")));
        try {
            if (SubtitleType.ASS.equals((Object)inputSubtitles.getType())) {
                String line;
                while ((line = input.readLine()) != null) {
                    if (StringUtils.startsWith(line, "Dialogue:")) {
                        Object[] timings = StringUtils.splitPreserveAllTokens(line, ",");
                        if (timings.length >= 3 && StringUtils.isNotBlank(timings[1]) && StringUtils.isNotBlank(timings[1])) {
                            double startTime = SubtitleUtils.convertSubtitleTimingStringToTime(timings[1]);
                            double endTime = SubtitleUtils.convertSubtitleTimingStringToTime(timings[2]);
                            if (!(startTime >= timeShift)) continue;
                            timings[1] = SubtitleUtils.convertTimeToSubtitleTimingString(startTime - timeShift, TimingFormat.ASS_TIMING);
                            timings[2] = SubtitleUtils.convertTimeToSubtitleTimingString(endTime - timeShift, TimingFormat.ASS_TIMING);
                            output.write(StringUtils.join(timings, ",") + "\n");
                            continue;
                        }
                        output.write(line + "\n");
                        continue;
                    }
                    output.write(line + "\n");
                }
            } else if (SubtitleType.SUBRIP.equals((Object)inputSubtitles.getType())) {
                String line;
                int n = 1;
                while ((line = input.readLine()) != null) {
                    if (!StringUtils.contains((CharSequence)line, "-->")) continue;
                    double startTime = SubtitleUtils.convertSubtitleTimingStringToTime(line.substring(0, line.indexOf("-->") - 1));
                    double endTime = SubtitleUtils.convertSubtitleTimingStringToTime(line.substring(line.indexOf("-->") + 4));
                    if (!(startTime >= timeShift)) continue;
                    output.write("" + n++ + "\n");
                    output.write(SubtitleUtils.convertTimeToSubtitleTimingString(startTime - timeShift, TimingFormat.SRT_TIMING));
                    output.write(" --> ");
                    output.write(SubtitleUtils.convertTimeToSubtitleTimingString(endTime - timeShift, TimingFormat.SRT_TIMING) + "\n");
                    while (StringUtils.isNotBlank(line = input.readLine())) {
                        output.write(line + "\n");
                    }
                    output.write("\n");
                }
            }
        }
        finally {
            if (output != null) {
                output.flush();
                output.close();
            }
            if (input != null) {
                input.close();
            }
        }
        DLNAMediaSubtitle convertedSubtitles = new DLNAMediaSubtitle();
        convertedSubtitles.setExternalFile(convertedSubtitlesFile);
        convertedSubtitles.setType(inputSubtitles.getType());
        convertedSubtitles.setLang(inputSubtitles.getLang());
        convertedSubtitles.setFlavor(inputSubtitles.getFlavor());
        convertedSubtitles.setId(inputSubtitles.getId());
        return convertedSubtitles;
    }

    public static boolean isSupportsTimeShifting(SubtitleType subtitleType) {
        return SUPPORTS_TIME_SHIFTING.contains((Object)subtitleType);
    }

    static String convertTimeToSubtitleTimingString(double time, TimingFormat timingFormat) {
        if (timingFormat == null) {
            throw new NullPointerException("timingFormat should not be null.");
        }
        double s = Math.abs(time % 60.0);
        int h = (int)(time / 3600.0);
        int m = Math.abs((int)(time / 60.0) % 60);
        switch (timingFormat) {
            case ASS_TIMING: {
                return StringUtils.trim(String.format("% 02d:%02d:%s", h, m, ASS_DECIMAL_FORMAT.format(s)));
            }
            case SRT_TIMING: {
                return StringUtils.trim(String.format("% 03d:%02d:%s", h, m, SRT_DECIMAL_FORMAT.format(s)));
            }
            case SECONDS_TIMING: {
                return StringUtils.trim(String.format("% 03d:%02d:%02.0f", h, m, s));
            }
        }
        return StringUtils.trim(String.format("% 03d:%02d:%02.0f", h, m, s));
    }

    static Double convertSubtitleTimingStringToTime(String timingString) throws NumberFormatException {
        if (StringUtils.isBlank(timingString)) {
            throw new IllegalArgumentException("timingString should not be blank.");
        }
        StringTokenizer st = new StringTokenizer(timingString, ":");
        try {
            int h = Integer.parseInt(st.nextToken());
            int m = Integer.parseInt(st.nextToken());
            double s = Double.parseDouble(StringUtils.replace(st.nextToken(), ",", "."));
            if (h >= 0) {
                return (double)(h * 3600 + m * 60) + s;
            }
            return (double)(h * 3600 - m * 60) - s;
        }
        catch (NumberFormatException nfe) {
            logger.debug("Failed to convert timing string \"" + timingString + "\".");
            throw nfe;
        }
    }

    static void setConfiguration(PmsConfiguration configuration) {
        SubtitleUtils.configuration = configuration;
    }

    static {
        DecimalFormatSymbols dotDecimalSeparator = new DecimalFormatSymbols();
        dotDecimalSeparator.setDecimalSeparator('.');
        ASS_DECIMAL_FORMAT.setDecimalFormatSymbols(dotDecimalSeparator);
        DecimalFormatSymbols commaDecimalSeparator = new DecimalFormatSymbols();
        commaDecimalSeparator.setDecimalSeparator(',');
        SRT_DECIMAL_FORMAT.setDecimalFormatSymbols(commaDecimalSeparator);
    }

    static enum TimingFormat {
        ASS_TIMING,
        SRT_TIMING,
        SECONDS_TIMING;

    }
}

