/*
 * Decompiled with CFR 0.152.
 */
package net.pms.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.pms.io.BufferedOutputFile;
import net.pms.io.OutputConsumer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputTextConsumer
extends OutputConsumer {
    private static final Logger logger = LoggerFactory.getLogger(OutputTextConsumer.class);
    private List<String> lines = new ArrayList<String>();
    private Object linesLock = new Object();
    private boolean log;

    public OutputTextConsumer(InputStream inputStream, boolean log) {
        super(inputStream);
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        LineIterator it = null;
        try {
            it = IOUtils.lineIterator(this.inputStream, "UTF-8");
            while (it.hasNext()) {
                String line = it.nextLine();
                if (line.length() > 0) {
                    this.addLine(line);
                }
                if (!this.log) continue;
                logger.debug(line);
            }
        }
        catch (IOException ioe) {
            logger.debug("Error consuming input stream: {}", (Object)ioe.getMessage());
            LineIterator.closeQuietly(it);
        }
        catch (IllegalStateException ise) {
            logger.debug("Error reading from closed input stream: {}", (Object)ise.getMessage());
            {
                catch (Throwable throwable) {
                    LineIterator.closeQuietly(it);
                    throw throwable;
                }
            }
            LineIterator.closeQuietly(it);
        }
        LineIterator.closeQuietly(it);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLine(String line) {
        Object object = this.linesLock;
        synchronized (object) {
            this.lines.add(line);
        }
    }

    @Override
    public BufferedOutputFile getBuffer() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getResults() {
        ArrayList<String> clonedResults = new ArrayList<String>();
        Object object = this.linesLock;
        synchronized (object) {
            clonedResults.addAll(this.lines);
        }
        return clonedResults;
    }
}

