/*
 * Decompiled with CFR 0.152.
 */
package net.pms.io;

import com.sun.jna.Platform;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;
import net.pms.io.BufferedOutputFile;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapper;
import net.pms.io.ProcessWrapperImpl;
import net.pms.io.WindowsNamedPipe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeProcess {
    private static final Logger logger = LoggerFactory.getLogger(PipeProcess.class);
    private static final PmsConfiguration configuration = PMS.getConfiguration();
    private String linuxPipeName;
    private WindowsNamedPipe mk;
    private boolean forcereconnect = false;

    public PipeProcess(String pipeName, OutputParams params, String ... extras) {
        boolean in = true;
        if (extras != null && extras.length > 0 && extras[0].equals("out")) {
            in = false;
        }
        if (extras != null) {
            for (int i = 0; i < extras.length; ++i) {
                if (!extras[i].equals("reconnect")) continue;
                this.forcereconnect = true;
            }
        }
        if (Platform.isWindows()) {
            this.mk = new WindowsNamedPipe(pipeName, this.forcereconnect, in, params);
        } else {
            this.linuxPipeName = PipeProcess.getPipeName(pipeName);
        }
    }

    public PipeProcess(String pipeName, String ... extras) {
        this(pipeName, (OutputParams)null, extras);
    }

    private static String getPipeName(String pipeName) {
        try {
            return configuration.getTempFolder() + "/" + pipeName;
        }
        catch (IOException e) {
            logger.error("Pipe may not be in temporary directory", e);
            return pipeName;
        }
    }

    public String getInputPipe() {
        if (!Platform.isWindows()) {
            return this.linuxPipeName;
        }
        return this.mk.getPipeName();
    }

    public String getOutputPipe() {
        if (!Platform.isWindows()) {
            return this.linuxPipeName;
        }
        return this.mk.getPipeName();
    }

    public ProcessWrapper getPipeProcess() {
        if (!Platform.isWindows()) {
            OutputParams mkfifo_vid_params = new OutputParams(configuration);
            mkfifo_vid_params.maxBufferSize = 0.1;
            mkfifo_vid_params.log = true;
            String[] cmdArray = Platform.isMac() || Platform.isFreeBSD() || Platform.isSolaris() ? new String[]{"mkfifo", "-m", "777", this.linuxPipeName} : new String[]{"mkfifo", "--mode=777", this.linuxPipeName};
            ProcessWrapperImpl mkfifo_vid_process = new ProcessWrapperImpl(cmdArray, mkfifo_vid_params);
            return mkfifo_vid_process;
        }
        return this.mk;
    }

    public void deleteLater() {
        if (!Platform.isWindows()) {
            File f = new File(this.linuxPipeName);
            f.deleteOnExit();
        }
    }

    public BufferedOutputFile getDirectBuffer() throws IOException {
        if (!Platform.isWindows()) {
            return null;
        }
        return this.mk.getDirectBuffer();
    }

    public InputStream getInputStream() throws IOException {
        if (!Platform.isWindows()) {
            logger.trace("Opening file " + this.linuxPipeName + " for reading...");
            RandomAccessFile raf = new RandomAccessFile(this.linuxPipeName, "r");
            return new FileInputStream(raf.getFD());
        }
        return this.mk.getReadable();
    }

    public OutputStream getOutputStream() throws IOException {
        if (!Platform.isWindows()) {
            logger.trace("Opening file " + this.linuxPipeName + " for writing...");
            RandomAccessFile raf = new RandomAccessFile(this.linuxPipeName, "rw");
            return new FileOutputStream(raf.getFD());
        }
        return this.mk.getWritable();
    }
}

